#!/bin/bash
#
# install gprbuild package (normally in the chroot that just built it),
# and run the examples using it.

# usage
# cd gprbuild-<version>/debian
# sudo schroot ./test_installed.sh

# This re-installs the latest version.
sudo dpkg --install ../../gprbuild_1.3.0-1_i386.deb
sudo dpkg --install ../../gprbuild-doc_1.3.0-1_all.deb

# tmp is owned by root; we need write permission
sudo chmod -R o+w tmp

cd ../examples
make

# test gprclean
make clean

# test running gprbuild with the default config file
cd first_steps
gprbuild -Pc_main
gprbuild -Pada_main

# clean up for next build
make clean

# test that default gpr search path follows Debian Ada policy
cd ../../debian
gprbuild -P aunit_example
gprclean -P aunit_example

# test that -s (check switches) doesn't attempt to write in system directories
# FIXME: need to run this as non-root
gprbuild bug_571013.gpr

# end of file
