/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 c-style: "K&R" -*- */

/*----------------------------------------------------------------------
 
  gpiv - Graphic program for Particle Image Velocimetry, based on gtk/gnome
          libraries.

   Copyright (C) 2002, 2003, 2004 Gerber van der Graaf

   This file is part of gpiv.

   Gpiv is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

----------------------------------------------------------------------*/

/*
 * $Log: preferences.c,v $
 * Revision 1.10  2006/01/31 14:28:13  gerber
 * version 0.3.0
 *
 * Revision 1.8  2005/01/19 15:53:42  gerber
 * Initiation of Data Acquisition (DAC); trigerring of lasers and camera
 * by using RTAI and Realtime Linux, recording images from IEEE1394
 * (Firewire) IIDC compliant camera's
 *
 * Revision 1.7  2004/10/15 19:24:05  gerber
 * GPIV_ and Gpiv prefix to defines and structure names of libgpiv
 *
 * Revision 1.6  2004/06/14 21:19:23  gerber
 * Image depth up to 16 bits.
 * Improvement "single int" and "drag int" in Eval tab.
 * Viewer's pop-up menu.
 * Adaption for gpiv_matrix_* and gpiv_vector_*.
 * Resizing console.
 * See Changelog for further info.
 *
 * Revision 1.5  2003/09/01 11:17:15  gerber
 * improved monitoring of interrogation process
 *
 * Revision 1.4  2003/08/22 15:24:52  gerber
 * interactive spatial scaling
 *
 * Revision 1.3  2003/07/25 15:40:24  gerber
 * removed/disabled setting of correlation in Eval tab, Correlation type in Image info tab
 *
 * Revision 1.2  2003/06/27 13:47:26  gerber
 * display ruler, line/point evaluation
 *
 * Revision 1.1.1.1  2003/06/17 17:10:52  gerber
 * Imported gpiv
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#include "support.h"

#include "gpiv_gui.h"
#include "utils.h"
#include "preferences.h"
#include "preferences_interface.h"


void 
on_checkbutton_gpivbuttons_activate(GtkWidget *widget, 
                                         gpointer data
                                         )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.view_gpivbuttons = 1;
    } else {
	default_par.view_gpivbuttons = 0;
    }
}



void 
on_checkbutton_tab_activate(GtkWidget *widget, 
                                 gpointer data
                                 )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.view_tabulator = 1;
    } else {
	default_par.view_tabulator = 0;
    }
}



void 
on_checkbutton_hdf_activate(GtkWidget *widget, 
                                 gpointer data
                                 )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.hdf = 1;
    } else {
	default_par.hdf = 0;
    }
}



void 
on_checkbutton_hdfimg_activate(GtkWidget *widget, 
                                    gpointer data
                                    )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.hdf_img = 1;
    } else {
	default_par.hdf_img = 0;
    }
}



void 
on_checkbutton_xcorr_activate(GtkWidget *widget, 
                                   gpointer data
                                   )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.x_corr = 1;
    } else {
	default_par.x_corr = 0;
    }
}



void 
on_spinbutton_cols_activate(GtkSpinButton * widget, 
                                 GtkWidget * entry
                                 )
/*-----------------------------------------------------------------------------
 */
{
    default_par.img_width = gtk_spin_button_get_value_as_int(widget);
    img_set = TRUE;
}



void 
on_spinbutton_rows_activate(GtkSpinButton * widget, 
                                 GtkWidget * entry
                                 )
/*-----------------------------------------------------------------------------
 */
{
    default_par.img_height = gtk_spin_button_get_value_as_int(widget);
    img_set = TRUE;
}



void 
on_spinbutton_depth_activate(GtkSpinButton * widget, 
                                  GtkWidget * entry
                                  )
/*-----------------------------------------------------------------------------
 */
{
    default_par.img_depth = gtk_spin_button_get_value_as_int(widget);
    img_set = TRUE;
}



void 
on_checkbutton_tooltips_activate(GtkWidget *widget, 
                                      gpointer data
                                      )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.show_tooltips = 1;
    } else {
	default_par.show_tooltips = 0;
    }
}



#ifndef DISABLE_DAC
void 
on_checkbutton_process_dac_activate(GtkWidget *widget, 
                                         gpointer data
                                         )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.process_dac = TRUE;
    } else {
	default_par.process_dac = FALSE;
    }
}
#endif /* DISABLE_DAC */


void 
on_checkbutton_process_piv_activate(GtkWidget *widget, 
                                         gpointer data
                                         )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.process_piv = TRUE;
    } else {
	default_par.process_piv = FALSE;
    }
}



void 
on_checkbutton_process_gradient_activate(GtkWidget *widget, 
                                              gpointer data
                                              )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.process_gradient = TRUE;
    } else {
	default_par.process_gradient = FALSE;
    }
}



void 
on_checkbutton_process_resstats_activate(GtkWidget *widget, 
                                              gpointer data
                                              )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.process_resstats = TRUE;
    } else {
	default_par.process_resstats = FALSE;
    }
}



void 
on_checkbutton_process_errvec_activate(GtkWidget *widget, 
                                            gpointer data
                                            )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.process_errvec = TRUE;
    } else {
	default_par.process_errvec = FALSE;
    }
}



void 
on_checkbutton_process_peaklck_activate(GtkWidget *widget, 
                                             gpointer data
                                             )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.process_peaklock = TRUE;
    } else {
	default_par.process_peaklock = FALSE;
    }
}



void 
on_checkbutton_process_subtract_activate(GtkWidget *widget, 
                                              gpointer data
                                              )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.process_subtract = TRUE;
    } else {
	default_par.process_subtract = FALSE;
    }
}



void 
on_checkbutton_process_scale_activate(GtkWidget *widget, 
                                           gpointer data
                                           )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.process_scale = TRUE;
    } else {
	default_par.process_scale = FALSE;
    }
}



void 
on_checkbutton_process_avg_activate(GtkWidget *widget, 
                                         gpointer data
                                         )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.process_average = TRUE;
    } else {
	default_par.process_average = FALSE;
    }
}



void 
on_checkbutton_process_vorstra_activate(GtkWidget *widget, 
                                             gpointer data
                                             )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.process_vorstra = TRUE;
    } else {
	default_par.process_vorstra = FALSE;
    }
}



void 
on_spinbutton_bins_activate(GtkWidget *widget, 
		  gpointer data
                                 )
/*-----------------------------------------------------------------------------
 */
{}



void
on_radiobutton_display_vecscale(GtkWidget *widget, 
                                     gpointer data
                                     )
/*-----------------------------------------------------------------------------
 */
{
    default_par.vector_scale = atoi(gtk_object_get_data(GTK_OBJECT(widget), 
                                                        "vscale"));
}



void
on_radiobutton_display_veccolor(GtkWidget *widget, 
                                     gpointer data
                                     )
/*-----------------------------------------------------------------------------
 */
{
    default_par.vector_color = atoi(gtk_object_get_data(GTK_OBJECT(widget), 
                                                        "vcolor"));
}



void
on_radiobutton_display_zoomscale(GtkWidget *widget, 
                                      gpointer data
                                      )
/*-----------------------------------------------------------------------------
 */
{
    default_par.zoom_index = atoi(gtk_object_get_data(GTK_OBJECT(widget), 
                                                        "zscale"));
}



void
on_radiobutton_display_background(GtkWidget *widget, 
                                      gpointer data
                                      )
/*-----------------------------------------------------------------------------
 */
{
    default_par.background = atoi(gtk_object_get_data(GTK_OBJECT(widget), 
                                                        "bgcolor"));
    if (default_par.background == SHOW_BG_DARKBLUE
        || default_par.background == SHOW_BG_BLACK) {
        default_par.display_img1 = 0;
        default_par.display_img2 = 0;
    } else if (default_par.background == SHOW_BG_IMG1) {
        default_par.display_img1 = 1;
        default_par.display_img2 = 0;
    } else if (default_par.background == SHOW_BG_IMG2) {
        default_par.display_img1 = 0;
        default_par.display_img2 = 1;
    }
}



void
on_checkbutton_display_display_intregs(GtkWidget *widget, 
                                            gpointer data
                                            )
/*-----------------------------------------------------------------------------
 */

{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.display_intregs = TRUE;
    } else {
	default_par.display_intregs = FALSE;
    }
}



void
on_checkbutton_display_display_piv(GtkWidget *widget, 
				       gpointer data
                                        )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.display_piv = TRUE;
    } else {
	default_par.display_piv = FALSE;
    }
}



void
on_radiobutton_display_display_none(GtkWidget *widget, 
					gpointer data
                                        )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.display_vor = FALSE;
	default_par.display_sstrain = FALSE;
	default_par.display_nstrain = FALSE;
    }
}



void
on_radiobutton_display_display_vor(GtkWidget *widget, 
					gpointer data
                                        )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.display_vor = TRUE;
    } else {
	default_par.display_vor = FALSE;
    }
}



void
on_radiobutton_display_display_sstrain(GtkWidget *widget, 
                                            gpointer data
                                            )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.display_sstrain = TRUE;
    } else {
	default_par.display_sstrain = FALSE;
    }
}



void
on_radiobutton_display_display_nstrain(GtkWidget *widget, 
                                            gpointer data
                                            )
/*-----------------------------------------------------------------------------
 */
{
    if (GTK_TOGGLE_BUTTON(widget)->active) {
	default_par.display_nstrain = TRUE;
    } else {
	default_par.display_nstrain = FALSE;
    }
}



void
on_preferences_response(GtkDialog *dialog,
			gint response,
			gpointer data
			)
/*-----------------------------------------------------------------------------
 */
{
    GpivConsole *gpiv = gtk_object_get_data(GTK_OBJECT(dialog), "gpiv");
    Pref *pref = gtk_object_get_data(GTK_OBJECT(dialog), "pref");
    g_assert( response == GTK_RESPONSE_OK
              || response == GTK_RESPONSE_APPLY
              || response == GTK_RESPONSE_CANCEL);

    switch (response) {
    case GTK_RESPONSE_OK:
        apply_gpivpar(gpiv);
        store_defaultpar();
        if (img_set) {
            warning_gpiv(_("In order to affect image width, height and depth\n"
                          "restart GPIV"));
        }
        gtk_widget_destroy(GTK_WIDGET (dialog));
        break;
 
   case GTK_RESPONSE_APPLY:
       apply_gpivpar(gpiv);
       if (img_set) warning_gpiv(_("In order to change image width, height and depth\n"
                                  "press OK button and restart GPIV"));
       break;

    case GTK_RESPONSE_CANCEL:
        gtk_widget_destroy(GTK_WIDGET (dialog));
        break;

    default:
        g_warning("on_preferences_response: should not arrive here");
        break;
    }

}



void
apply_gpivpar(GpivConsole * gpiv)
/* ----------------------------------------------------------------------------
 * Updates actual parameters
 */
{
    GtkWidget *settings_menu_gpiv0 = 
        gtk_object_get_data(GTK_OBJECT(gpiv->console), "settings_menu_gpiv0");
    GtkWidget *settings_menu_gpiv1 = 
        gtk_object_get_data(GTK_OBJECT(gpiv->console), "settings_menu_gpiv1");
    GtkWidget *help_menu_gpiv0 = 
        gtk_object_get_data(GTK_OBJECT(gpiv->console), "help_menu_gpiv0");
    GtkWidget *help_menu_gpiv_popup0 = 
        gtk_object_get_data(GTK_OBJECT(gpiv->console), "help_menu_gpiv_popup0");


    cp_parameters(default_par, &gpiv_par, TRUE, FALSE, FALSE);


    if (default_par.view_gpivbuttons == 1) {
        gtk_widget_show(gpiv->handlebox1);
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
				       (settings_menu_gpiv0), TRUE);
    } else {
        gtk_widget_hide(gpiv->handlebox1);
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
				       (settings_menu_gpiv0), FALSE);
    }
    
    if (default_par.view_tabulator == 1) {
	 gtk_widget_show(gpiv->notebook);
         gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
                                        (settings_menu_gpiv1), TRUE);
    } else {
        gtk_widget_hide(gpiv->notebook);
 	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
				       (settings_menu_gpiv1), FALSE);
    }

    if (default_par.show_tooltips == 1) {
        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
                                       (help_menu_gpiv0), TRUE);
        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
                                     (help_menu_gpiv_popup0), TRUE);
    } else {
        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
                                       (help_menu_gpiv0), FALSE);
        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM
                                       (help_menu_gpiv_popup0), FALSE);
    }
    
    gtk_spin_button_set_value(GTK_SPIN_BUTTON
                              (gpiv->pivvalid->spinbutton_histo_bins), 
                              default_par.nbins);
    

    
    
#ifndef DISABLE_DAC
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
                                 (gpiv->button_toolbar_dac), 
                                 default_par.process_dac);
#endif /* DISABLE_DAC */

        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON
                                     (gpiv->button_toolbar_piv), 
                                     default_par.process_piv);
    
        gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON
                                    (gpiv->button_toolbar_gradient), 
                                    default_par.process_gradient);
   
        gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON
                                    (gpiv->button_toolbar_resstats), 
                                    default_par.process_resstats);
    
        gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON
                                    (gpiv->button_toolbar_errvec), 
                                    default_par.process_errvec);
    
        gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON
                                    (gpiv->button_toolbar_peaklock), 
                                    default_par.process_peaklock);
    
        gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON
                                    (gpiv->button_toolbar_scale), 
                                    default_par.process_scale);
    
        gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON
                                    (gpiv->button_toolbar_average), 
                                    default_par.process_average);
    
        gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON
                                    (gpiv->button_toolbar_subavg), 
                                    default_par.process_subtract);
    
        gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON
                                    (gpiv->button_toolbar_vorstra), 
                                    default_par.process_vorstra);
    
    if (nbufs > 0 && display_act->gpd.exist_piv
        && display_act->display_piv) {
        update_all_vectors(&display_act->gpd);
    }
    
    if (display_act != NULL) {

/*   if (default_par.zoom_index == ZOOM_0) { */
/*       zoomfactor = 0.5; */
/*   } else if (default_par.zoom_index == ZOOM_1) { */
/*       zoomfactor = 0.83; */
/*   } else if (default_par.zoom_index == ZOOM_2) { */
/*         zoomfactor  = 1.0; */
/*   } else if (default_par.zoom_index == ZOOM_3) { */
/*       zoomfactor = 1.3; */
/*   } else if (default_par.zoom_index == ZOOM_4) { */
/*       zoomfactor = 1.6; */
/*   } else if (default_par.zoom_index == ZOOM_5) { */
/*       zoomfactor = 2.0; */
/*   } else {  */
/*       g_warning ("select_zoomscale:: unvalid zoomfacor"); */
/*   }  */

/*     update_all_displays(&display_act->gpd); */


        if (display_act->display_intregs) {
            if (default_par.display_intregs == 1) {
                create_all_intregs2(display_act);
                create_all_intregs1(display_act);
            } else {
                hide_all_intregs1(display_act);
                hide_all_intregs2(display_act);
            }
        }
        
        
        if (display_act->gpd.exist_piv) {
            if (default_par.display_piv) {
                create_all_vectors(&display_act->gpd);
            } else {
                hide_all_vectors(&display_act->gpd);
            }
        }
        
        
        if (display_act->gpd.exist_vor) {
            if (default_par.display_vor) {
                create_all_scalars(display_act, GPIV_VORTICITY);
            } else {
                hide_all_scalars(display_act, GPIV_VORTICITY);
            }
        }
        
        
        if (display_act->gpd.exist_sstrain) {
            if (default_par.display_sstrain) {
                create_all_scalars(display_act, GPIV_S_STRAIN);
            } else {
                hide_all_scalars(display_act, GPIV_S_STRAIN);
            }
        }
        
        
        if (display_act->gpd.exist_nstrain) {
            if (default_par.display_nstrain) {
                create_all_scalars(display_act, GPIV_N_STRAIN);
            } else {
                hide_all_scalars(display_act, GPIV_N_STRAIN);
            }
        }
        
    }
}



void
store_defaultpar(void
                 )
/* ----------------------------------------------------------------------------
 * Store parameters as defaults
 */
{
    gnome_config_push_prefix("/gpiv/General/");
/*     gnome_config_set_bool("print_par", print_par); */
    gnome_config_set_bool("show_tooltips", default_par.show_tooltips);
    gnome_config_set_bool("view_gpivbuttons", default_par.view_gpivbuttons);
    gnome_config_set_bool("view_tabulator", default_par.view_tabulator);
    gnome_config_set_int("nbins", default_par.nbins);
    gnome_config_set_bool("hdf", default_par.hdf);
    gnome_config_set_bool("hdf_img", default_par.hdf_img);


    gnome_config_pop_prefix();
    gnome_config_push_prefix("/gpiv/Image/");
    gnome_config_set_bool("x_corr", default_par.x_corr);
    gnome_config_set_int("columns", default_par.img_width);
    gnome_config_set_int("rows", default_par.img_height);
    gnome_config_set_int("depth", default_par.img_depth);
    

    gnome_config_pop_prefix();
    gnome_config_push_prefix("/gpiv/Processes/");
#ifndef DISABLE_DAC
    gnome_config_set_bool("process_dac", default_par.process_dac);
#endif /* DISABLE_DAC */
    gnome_config_set_bool("process_piv", default_par.process_piv);
    gnome_config_set_bool("process_gradient", default_par.process_gradient);
    gnome_config_set_bool("process_resstats", default_par.process_resstats);
    gnome_config_set_bool("process_errvec", default_par.process_errvec);
    gnome_config_set_bool("process_peaklock", default_par.process_peaklock);
    gnome_config_set_bool("process_scale", default_par.process_scale);
    gnome_config_set_bool("process_average", default_par.process_average);
    gnome_config_set_bool("process_subtract", default_par.process_subtract);
    gnome_config_set_bool("process_vorstra", default_par.process_vorstra);
    

    gnome_config_pop_prefix();
    gnome_config_push_prefix("/gpiv/Display/");
    gnome_config_set_int("vector_scale", default_par.vector_scale);
    gnome_config_set_int("vector_color", default_par.vector_color);
    gnome_config_set_int("zoom_index", default_par.zoom_index);
    gnome_config_set_int("background", default_par.background);
    gnome_config_set_int("display_img1", default_par.display_img1);
    gnome_config_set_int("display_img2", default_par.display_img2);
    gnome_config_set_bool("display_intregs", default_par.display_intregs);
    gnome_config_set_bool("display_piv", default_par.display_piv);
    gnome_config_set_bool("display_none", default_par.display_none);
    gnome_config_set_bool("display_vor", default_par.display_vor);
    gnome_config_set_bool("display_sstrain", default_par.display_sstrain);
    gnome_config_set_bool("display_nstrain", default_par.display_nstrain);
    
    gnome_config_pop_prefix();
    gnome_config_sync();

}

