/***************************************************************************
                          gpc_utils.c  -  description
                             -------------------
    begin                : Tue Jun 13 2000
    copyright            : (C) 2000 by 
    email                : tflorac@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <gnome.h>

#include <sys/wait.h>

#include "gpc_app.h"
#include "gpc_utils.h"


/* Launch an external command with given parametes */
void gpc_app_launch (const char *command, char *const args[])
{
  pid_t   pid;
  
  pid = fork ();
  if (pid == 0) {
    execvp (command, args);
    _exit (0);
  }
}


/* Callback used by OK/Cancel dialog boxes */
void gpc_app_check_reply_callback (gint reply, gpointer data)
{
  switch (reply) {
    case  0 : modal_result = GPC_MODAL_RESULT_OK;
              break;
    default : modal_result = GPC_MODAL_RESULT_CANCEL;
  }
}


/* Retrieve a repository relative path name, given an absolute one */
gchar* gpc_path_relname (gchar *value)
{
  gint    repos_len;
  
  if (!value)
    return NULL;
  repos_len = strlen (gpc_repository);
  if (g_strncasecmp (value, gpc_repository, repos_len) == 0)  /* Path name is a repository sub-dir */
    return (g_strconcat ("./", value + repos_len, NULL));
  else
    return (g_strdup (value));  
}


/* Retrieve a filename which can be used in shell commands, escaping spaces */
gchar* gpc_file_physname (gchar *value)
{
  gchar *result;
  int length;
  int nb_car = 0;
  int index = 0;
  int pos = 0;

  if ((value == NULL) ||
      (strlen (value) == 0))
    return NULL;
  if (strchr (value, ' ') == NULL)
    return g_strdup (value);
  length = strlen (value);
  for (index = 0; index < length; index++)
    if (value[index] == ' ')
      nb_car++;
  result = g_strnfill (length + nb_car, '\0');
  for (pos = 0, index = 0; index < length; index++) {
    if (value[index] == ' ') {
      result[pos] = '\\';
      pos++;
    }
    result[pos] = value[index];
    pos++;
  }
  return result;
}


/* Retrieve a correct SQL string corresponding with a given string, escaping quotes
   Result as well as Value parameter may be freed */
gchar* get_sql_string (gchar *value)
{
  gchar *result;
  int length;
  int nb_car = 0;
  int index = 0;
  int pos = 0;

  if ((value == NULL) ||
      (strlen (value) == 0))
    return g_strdup ("NULL");
  if (strchr (value, '\'') == NULL) {
    result = g_strdup (g_strconcat ("'", value, "'", NULL));
    return result;
  }
  length = strlen (value);
  for (index = 0; index < length; index++)
    if (value[index] == '\'')
      nb_car++;
  result = g_strnfill (length + nb_car + 2, '\0');
  result[0] = '\'';
  for (pos = 1, index = 0; index < length; index++) {
    if (value[index] == '\'') {
      result[pos] = value[index];
      pos++;
    }
    result[pos] = value[index];
    pos++;
  }
  result[pos] = '\'';
  return result;
}


/* Retrieve a correct SQL float value which may not interfere with national decimal separators */
gchar* get_sql_float (gfloat value)
{
  gchar *result;
  int    index = 0;
  int 	 length = 0;

  result = g_strdup_printf ("%f", value);
  length = strlen (result);
  for (index = 0; index < length; index++)
    if (result[index] == ',')
      result[index] = '.';
  return result;
}


/* Release memory handled by a list and his elements */
void gpc_list_free (GList *list)
{
  if (list == NULL)
    return;
  
  g_list_foreach (list, (GFunc) g_free, NULL);
  g_list_free (list);
}


/* Check to see if a file is hidden */
gboolean file_is_hidden (gchar *name)
{
  return !((name[0] != '.') || (name[1] == '\0' || (name[1] == '.' && name[2] == '\0')));
}

