/*
 * GPG Keys 
 * cdlgserversearch.cpp
 * (c) 2001 Peter Mathiasson <peter@mathiasson.nu>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation
 */

#include <qstatusbar.h>
#include <qlayout.h>
#include <qprocess.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include "cdlgsign.h"
#include "cgpgproc.h"
#include "functions.h"
#include "config.h"

/* --------------------------------------------------------------------------------- */

CDlgSign::CDlgSign( QWidget *parent, const QString tmpKeyId ) : CDlgSignUI( parent, 0, TRUE )
{
    /* Set Font */
    setFont( readConfigFont( "stdfont", STD_FONT ) );

    /* Set Caption */
    setCaption( tr( "Sign Key - Reading secret keys..." ) );

    /* Save keyID */
    keyId = tmpKeyId;

    /* Connect Signals */
    connect( btnSign, SIGNAL(clicked()), this, SLOT(doSign()) );
    connect( btnCancel, SIGNAL(clicked()), this, SLOT(reject()) );

    /* Read Secret Keys */
    readSecretKeys();

}

/* --------------------------------------------------------------------------------- */

void CDlgSign::readSecretKeys()
{
    /* Create Process */
    gpgProc = new QProcess( this );
    gpgProc->addArgument( readConfigString( "gpgpath", GPGPATH ) );
    gpgProc->addArgument( "--list-secret-keys" );
    gpgProc->addArgument( "--with-colon" );
    connect( gpgProc, SIGNAL(processExited()), this, SLOT(processDone()) );
    connect( gpgProc, SIGNAL(readyReadStdout()), this, SLOT(readFromStdout()) );
    
    /* Run GPG */
    if ( !gpgProc->start() ) {
        return;
    }

}

/* --------------------------------------------------------------------------------- */

void CDlgSign::processDone()
{
    setCaption( tr( "Sign Key" ) );
}

/* --------------------------------------------------------------------------------- */

void CDlgSign::readFromStdout()
{
    QStringList entry;

    while ( gpgProc->canReadLineStdout() ) {
        
        /* Read/Split Line */
        entry = QStringList::split( ':', gpgProc->readLineStdout(), TRUE );

        /* Secret Key */
        if ( entry[0] == "sec" ) {

            /* Add to Secret Key Combo Box */
            cbSecret->insertItem( entry[9] );

            /* Save KeyID of Secret Key */
            keyIdList << entry[4];

        }
    }
}

/* --------------------------------------------------------------------------------- */

void CDlgSign::doSign()
{    

    /* Get Secret Key ID */
    int secId = 0;
    for ( int i = 0; i < cbSecret->count(); i++ ) {
        if ( cbSecret->text( i ) == cbSecret->currentText() )
            secId = i;
    }
    
    /* Get Sign Type */
    QString signArg;
    if ( radioLocal->isOn() ) {
        signArg = "--lsign-key";
    } else {
        signArg = "--sign-key";
    }

    /* Create Argument List */
    QStringList args;
    args << "--default-key" << keyIdList[secId] << signArg << keyId;    

    /* Run and Check Return Code */
    switch ( CGPGProc::run( this, args, QString::null, TRUE ) ) {

    case CGPGProc::RUNFAILED:
        break;
    
    default:
        emit newPublic();
        accept();
        break;

    }
}

/* --------------------------------------------------------------------------------- */

