/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>
#include <glade/glade-xml.h>

#include "gpass/error.h"
#include "helper.h"
#undef gpass_helper_error

void
gpass_helper_message(GtkMessageType type, const char *fmt, ...)
{
    GtkWidget *dialog;
    gchar *str;
    va_list va;

    va_start(va, fmt);
    str = g_strdup_vprintf(fmt, va);
    va_end(va);
    dialog = gtk_message_dialog_new(NULL, GTK_DIALOG_DESTROY_WITH_PARENT,
                                    type, GTK_BUTTONS_CLOSE, str);
    gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
    g_free(str);
}

void
gpass_helper_shutdown_main_loop(GMainLoop *main_loop)
{
    if (g_main_loop_is_running(main_loop)) {
        g_main_loop_quit(main_loop);
    }
}

void
gpass_helper_error(GError *error, const gchar *file, gint line)
{
    g_return_if_fail(error != NULL);
    gpass_error_locale_printf("**error**: %s:%d: %s\n",
                              file, line, error->message);
    g_error_free(error);
    exit(1);
}
