/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "helper.h"
#include "application.h"
#include "confirm-quit.h"

GType
gpass_confirm_quit_get_type(void)
{
    static GType type = 0;
    
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof(GPassConfirmQuitClass),
            NULL,
            NULL,
            NULL,
            NULL,
            NULL,
            sizeof(GPassConfirmQuit),
            0,
            NULL,
        };
        
        type = g_type_register_static(GPASS_TYPE_VIEW,
                                      "GPassConfirmQuitType", &info, 0);
    }
    return type;
}

/***********************************************************
 *
 * Signal handlers
 *
 ***********************************************************/
void
gpass_confirm_quit_on_response(GtkWidget *widget, gint response_id,
                               gpointer user_data)
{
    GPassConfirmQuit *self;
    GPassApplication *app;
    gboolean result;
    GError *error;
    
    gpass_view_self_from_widget(widget, (gpointer **) &self);
    switch (response_id) {
    case GTK_RESPONSE_ACCEPT:
        app = GPASS_APPLICATION(GPASS_VIEW(self)->model);
        error = gpass_application_passwords_save(app, &result);
        if (error != NULL) {
            gpass_helper_error(error);
        }
        if (result) {
            GPASS_VIEW(self)->result = GPASS_VIEW_RESULT_SUCCEED;
        }
        else {
            GPASS_VIEW(self)->result = GPASS_VIEW_RESULT_FAILED;
        }
        break;
    case GTK_RESPONSE_REJECT:
        GPASS_VIEW(self)->result = GPASS_VIEW_RESULT_SUCCEED;
        break;
    default:
        GPASS_VIEW(self)->result = GPASS_VIEW_RESULT_FAILED;
    }
    gpass_view_shutdown_main_loop(GPASS_VIEW(self));
}
