/*
 *  Copyright (C) 2004 Morten Fjord-Larsen
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_CONFIGURATION_H__
#define __GPASS_CONFIGURATION_H__

#include <gconf/gconf-client.h>

G_BEGIN_DECLS

#define GPASS_TYPE_CONFIGURATION  (gpass_configuration_get_type())
#define GPASS_CONFIGURATION(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_CONFIGURATION, \
                                GPassConfiguration))
#define GPASS_CONFIGURATION_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_CONFIGURATION, \
                             GPassConfigurationClass))
#define GPASS_IS_CONFIGURATION(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_CONFIGURATION))
#define GPASS_IS_CONFIGURATION_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_CONFIGURATION))
#define GPASS_CONFIGURATION_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_CONFIGURATION, \
                               GPassConfigurationClass))

typedef struct {
    GObject parent;
    
    GConfClient *gconf_client;
    gint window_x;
    gint window_y;
    gint window_width;
    gint window_height;
    gboolean toolbar_visible;
    gboolean statusbar_visible;
    gint pane_width;
    gboolean lock;
    gint lock_timeout;
    gboolean visible_secrets;
    GData *launchers;
    gint undo_levels;
} GPassConfiguration;

typedef struct {
    GObjectClass parent;
} GPassConfigurationClass;

GType gpass_configuration_get_type(void);
GPassConfiguration *gpass_configuration_instance(void);
void gpass_configuration_finalize(void);

void gpass_configuration_get_launcher(GPassConfiguration *self,
                                      const gchar *type,
                                      gchar **launcher);
void gpass_configuration_set_launcher(GPassConfiguration *self,
                                      const gchar *type,
                                      const gchar *launcher);

G_END_DECLS

#endif /* #ifndef __GPASS_CONFIGURATION_H__ */
