/*
Copyright (C) 2002  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "header.h"

void gerepilelist(stack *s, stack *g, int savb)
{
  affnode *an=(affnode *) *stack_base(s);
  int **gcvar=(int **) stack_base(g);
  int i;
  for(i=0;i<s->n;i++)
  {
    int idx=an[i].idx;
    ctxvar *v=ctxstack+idx;
    int t=vartype(*v);
    if (ctype[t]!=Vgen || ((v->flag&(1<<Cconst)) && v->val!=-1))
      continue;
    /*If i is affected or referenced*/
    if (an[i].f!=AFaccess && an[i].f!=AFhide && an[i].f!=AFclone)
    {
      int j;
      /*search the first occurence of i*/
      for(j=0;j<i;j++)
        if (an[j].idx==idx)
          break;
      /*if the variable is local and the first occurence
        is an affectation, do nothing */
      if (an[j].idx>=savb &&  an[j].f==AFaffect)
        continue;

      /*else check if it is not already in the list*/
      for(j=0;j<g->n;j++)
        if ((*gcvar)[j]==idx)
          break;
      /*if it is already, do nothing*/
      if (j<g->n) continue;
      /*add to list*/
      j=stack_new(g);
      (*gcvar)[j]=idx;
    }
  }
  if (debug)
  {
    int i;
    fprintf(stderr,"/*");
    for(i=0;i<s->n;i++)
      fprintf(stderr,"%s%s ",varstr(ctxstack[an[i].idx]),an[i].f==AFaffectcompo?"=[]":an[i].f==AFaffect?"=":"");
    fprintf(stderr,"*/\n");
  }
}

void pilelistvar(int idx)
{
  ctxvar *v=ctxstack+idx;
  if (v->flag&(1<<Carg))
    return;
  if (ctype[vartype(*v)]!=Vgen)
    return;
  if (v->initval>=0)
  {
    pilelist(v->initval);
    newaff(AFaffect,idx);
  }
}

void pilelist(int n)
{
  int x,y;
  int savc,savb;
  context *bl;
  if (n<0)
    return;
  x=tree[n].x;
  y=tree[n].y;
  switch(tree[n].f)
  {
  case Faffect:
    if (tree[x].f!=Fentry)
      pilelist(x);
    pilelist(y);
    x=getlvaluerr(x);
    if (ctype[tree[x].t]==Vgen && ctype[tree[y].t]==Vgen
       && (tree[detag(y)].m&(1<<Mcopy)))
    {
      int z=newnode(Ffunction,-1,-1);
      tree[z]=tree[y];
      tree[z].f=Ffunction;
      tree[z].x=newentry("copy");
      tree[z].y=y;
      tree[z].m=tree[y].m&MODHERIT;
      tree[n].y=z;
    }
    break;
  case Frefarg:
  case Ftag:
    pilelist(x);
    break;
  case Fconst:
  case Fsmall:
  case Fnoarg:
  case Fentry:
    break;
  case Ffunction:
    pilelist(y);
    break;
  case Fdeffunc:
    {
      int funcid=tree[n].x;
      const char *name=entryname(funcid);
      int savcf=currfunc;
      userfunc *uf;
      /*get func number and context*/
      currfunc=findfunction(name);
      uf=lfunc[currfunc].user;
      savc=s_ctx.n;
      pilelist(y);
      gerepilelist(&uf->v,&uf->g,uf->savb);
      currfunc=savcf;
    }
    break;
  case Fblock:
    savc=s_ctx.n;
    bl=block+tree[n].x;
    pushctx(bl);
    savb=s_ctx.n;
    pilelist(y);
    if (bl->gc&(1<<GCneeded))
    {
      gerepilelist(&bl->v,&bl->g,bl->savb);
      if (bl->egc>=0)
      {
        int vret=getvar(bl->egc);
        ctxvar *v=ctxstack+vret;
        if (ctype[vartype(*v)]==Vgen)
        {
          int **gcvar=(int **) stack_base(&bl->g);
          int j=stack_new(&bl->g);
          (*gcvar)[j]=vret;
        }
      }
    }
    copyctx(savc,bl);
    s_ctx.n=savc;
    break;
  default:
    if (tree[n].f>=FneedENTRY || tree[n].f<0)
      die(n,"Incorrect node %s in pilelist",funcname(tree[n].f));
    pilelist(x);
    pilelist(y);
  }
}
void pileclean(int n)
{
  int x,y;
  int savc,sava,savb;
  context *bl;
  if (n<0)
    return;
  x=tree[n].x;
  y=tree[n].y;
  switch(tree[n].f)
  {
  case Faffect:
    pileclean(x);
    pileclean(y);
    break;
  case Frefarg:
  case Ftag:
    pileclean(x);
    break;
  case Fconst:
  case Fsmall:
  case Fnoarg:
  case Fentry:
    break;
  case Ffunction:
    pileclean(y);
    break;
  case Fdeffunc:
    {
      int funcid=tree[n].x;
      const char *name=entryname(funcid);
      int savcf=currfunc;
      /*get func number and context*/
      currfunc=findfunction(name);
      pileclean(y);
      currfunc=savcf;
    }
    break;
  case Fblock:
    savc=s_ctx.n;
    sava=s_aff.n;
    bl=block+tree[n].x;
    pushctx(bl);
    savb=s_ctx.n;
    pileclean(y);
    if (bl->gc&(1<<GCglobal))
    {
      userfunc *ufunc=lfunc[currfunc].user;
      int i,j;
      int *var;
      stack v;
      stack_init(&v,sizeof(*var),(void *)&var);
      for(i=0,j=0;i<bl->g.n || j<ufunc->g.n;)
      {
        if (j==ufunc->g.n
            || (i<bl->g.n && bl->gcvar[i]<ufunc->gcvar[j]))
        {
          int k=stack_new(&v);
          var[k]=bl->gcvar[i++];
        }
        else
        {
          int k=stack_new(&v);
          var[k]=ufunc->gcvar[j];
          if (i<bl->g.n  && bl->gcvar[i]==ufunc->gcvar[j])
            i++;
          j++;
        }
      }
      stack_replace(&bl->g,&v);
      if (bl->g.n!=1)
        bl->gc&=~(1<<GCupto);
    }
    if ((bl->gc&(1<<GCneeded)) && (!bl->g.n || (bl->gc&(1<<GCupto))))
    {
      if (bl->gc&(1<<GCglobal))
      {
        if (FC_gerepileall<0)
        {
          int v=getvarbyname("gptr");
          if (v>=savc && v<savb)
            vartype(ctxstack[v])=Gvoid;
        }
      }
      else
      {
        int w=getvarbyname("st_lim");
        if (w>=savc && w<savb)
          vartype(ctxstack[w])=Gvoid;
        if (FC_gerepileall<0)
        {
          int v=getvarbyname("bptr");
          if (v>=savc && v<savb)
            vartype(ctxstack[v])=Gvoid;
        }
      }
    }
    if ((bl->gc&(1<<GCreturn)) &&
                  (bl->g.n==0 ||
                  (bl->g.n==1 && (bl->gc&(1<<GCupto))) ))
      tree[n].m|=(1<<Mbrace);
    copyctx(savc,bl);
    s_ctx.n=savc;
    break;
  default:
    if (tree[n].f>=FneedENTRY || tree[n].f<0)
      die(n,"Incorrect node %s in pileclean",funcname(tree[n].f));
    pileclean(x);
    pileclean(y);
  }
}
