/*
Copyright (C) 2002  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h> 
#include "stack.h"

void ** stack_base(stack *s)
{
  return (void **) ((char *)s+s->offset);
}

void stack_init(stack *s, int size, void **data)
{
  s->offset=(char *)data-(char *)s;
  *data=NULL;
  s->n=0;
  s->alloc=0;
  s->size=size;
}

void stack_alloc(stack *s, int nb)
{
  void **sdat=(void **)((char *)s+s->offset);
  if (s->n+nb <= s->alloc)
    return;
  while (s->n+nb > s->alloc)
    s->alloc=s->alloc?s->alloc<<1:1;
  if (debug_stack)
    fprintf(stderr,"data=%lx (%d/%ld)\n",
        (unsigned long) sdat,s->n,(long) s->alloc);
  *sdat=realloc(*sdat,s->alloc*s->size);
  if (*sdat==NULL)
    fprintf(stderr,"Cannot alloc memory (%ld bytes)\n",(long)s->alloc*s->size);
}

int stack_new(stack *s)
{
  stack_alloc(s, 1);
  return s->n++;
}

void stack_pop(stack *s)
{
  if (s->n)
    s->n--;
  else
    fprintf(stderr,"stack_pop: stack is already empty\n");
}

void stack_pop_safe(stack *s, int n)
{
  if (n == s->n-1)
    stack_pop(s);
  else
    fprintf(stderr,"stack_pop: unexpected stack level\n");
}

/*Push stack t on stack s*/
void stack_push(stack *s, stack *t)
{
  if ( s->size!=t->size )
    fprintf(stderr,"Incompatible stack size in stack_push: %ld!=%ld\n",
	(long)s->size,(long)t->size);
  if ( t->n>0 )
  {
    void **sdat=(void **) ((char *)s+s->offset);
    void **tdat=(void **) ((char *)t+t->offset);
    stack_alloc(s, t->n);
    memcpy((char *)*(sdat)+s->n*s->size,*tdat,t->n*t->size);
    s->n+=t->n;
  }
}

void stack_replace(stack *s, stack *t)
{
  void **sdat=(void **) ((char *)s+s->offset);
  void **tdat=(void **) ((char *)t+t->offset);
  *sdat=realloc(*sdat,0);
  *sdat=*tdat;
  s->n=t->n;
  s->alloc=t->alloc;
}
  
