/*
Copyright (C) 2000-2005  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "header.h"
int indent=0;
extern int indentlevel;

void genindent(FILE *fout)
{
  int i;
  for (i=0;i<indent*indentlevel;i++)
    fputc(' ',fout);
}

void genindentseq(FILE *fout, int n)
{
  if (n==-1 || (tree[n].m&(1<<Msemicomma)))
    return;
  genindent(fout);
}

void gencomment(FILE *fout, int n, int flag)
{
  comment *c;
  int i;
  if (tree[n].comment<0)
    return;
  c=com+tree[n].comment;
  for(i=0;i<c->s.n-1;i++)
  {
    if (c->txt[i]=='\n')
    {
      if (!flag) fputc('\n',fout);
      genindent(fout);
      while(c->txt[i+1]==' ' || c->txt[i+1]=='\t')
        i++;
    }
    else
      fputc(c->txt[i],fout);
  }
  if (c->txt[i]=='\n')
  {
    if (!flag) fputc('\n',fout);
    if (!(tree[n].m&(1<<Msemicomma)))
      genindent(fout);
  }
  else
    fputc(c->txt[i],fout);
}
void gensemicomma(FILE *fout, int x)
{
  if (x!=-1 && !(tree[x].m&(1<<Msemicomma)))
    fprintf(fout,";\n");
}
extern int optcleanvar;
void genbrace(FILE *fout, int x)
{
  if (x==-1) return;
  if (tree[x].f==Fblock)
  {
  /*If it is an empty block, cross it*/
    if ((tree[x].m&(1<<Mbrace)) && !optcleanvar )
      genbrace(fout,tree[x].y);
    else
      gencodeg(fout,x);
  }
  else
  {
    int brace=(tree[x].f==Fseq || (tree[x].m&(1<<Melse)));
    if (brace)
    {
      genindent(fout);
      fprintf(fout,"{\n");
    }
    indent++;
    genindentseq(fout,x);
    gencodeg(fout,x);
    gensemicomma(fout,x);
    indent--;
    if (brace)
    {
      genindent(fout);
      fprintf(fout,"}\n");
    }
  }
}

void genpercent(FILE *fout, int n)
{
  const char *s=value[tree[n].x].val.str;
  while(*s)
  {
    if (*s=='\r')
    {
      s++;
      continue;
    }
    if (*s=='%')
      fputc('%',fout);
    if (*s=='\n')
    {
      fprintf(fout,"\\n\"\n");
      genindent(fout);
      fputc('"',fout);
      s++;
    }
    else
      fputc(*s++,fout);
  }
}

void genfacteuraff(FILE *fout, int x, int z)
{
  int tx=tree[x].t;
  gencodeg(fout,x);
  fprintf(fout," = ");
  if ((tree[x].m&(1<<Mlong)) && ctype[tx]==Vgen)
    gencastl(fout,z,tx,0);
  else
    gencast(fout,z,tx);
}

extern char *optsuffix;
void genaddhelp(FILE *fout, int nf)
{
  gpfunc *gp=lfunc+nf;
  if( !gp->proto.help ) return;
  fprintf(fout,"GP;addhelp(%s%s, \"%s\");\n",
      gp->gpname,(optsuffix?optsuffix:""),gp->proto.help);
}

int checkinstall(gpfunc *gp)
{
  int i;
  int nargs=0;
  context *fc=block+gp->user->bl;
  if (!descfindrules1(gp->node, FC_proto_ret))
    return 1;
  for (i=0;i<fc->s.n;i++)
  {
    ctxvar *v=fc->c+i;
    if ( v->flag&(1<<Carg) )
    {
      if (descfindrules1(v->node, FC_proto_code))
        nargs++;
      else
        return 1;
    }
  }
  if (max_args>0 && nargs>max_args)
    return 1;
  return 0;
}

/*If there is no suitable GP prototype, just print nothing*/
void geninstall(FILE *fout, int nf)
{
  int i;
  gpfunc *gp=lfunc+nf;
  if(gp->spec==GPuser)
  {
    context *fc=block+gp->user->bl;
    if (checkinstall(gp))
      return;
    fprintf(fout,"GP;install(\"%s\",\"",gp->proto.cname);
    genfuncbydesc1(fout,gp->node,FC_proto_ret,-1);
    for (i=0;i<fc->s.n;i++)
    {
      ctxvar *v=fc->c+i;
      if ( v->flag&(1<<Carg) )
      {
        if (v->initval<0)
          genfuncbydesc1(fout,v->node,FC_proto_code,-1);
        else if (v->flag&(1<<Cdefmarker))
        {
          fputc('D',fout);
          genfuncbydesc1(fout,v->node,FC_proto_code,-1);
        }
        else
        {
          fputc('D',fout);
          printnode(fout,v->initval);
          fputc(',',fout);
          genfuncbydesc1(fout,v->node,FC_proto_code,-1);
          fputc(',',fout);
        }
      }
    }
    if (funcmode(*gp)&(1<<Mprec))
      fputc('p',fout);
  }
  else
  {
    fprintf(fout,"GP;install(\"%s\",\"",gp->proto.cname);
    genfuncbydesc1(fout,gp->node,FC_proto_ret,-1);
    fprintf(fout,"%s",gp->proto.code);
  }
  /* Member function has a gpname of "_.func" which is not a valid
   * GP func name.
   * we use "m_" instead.
   */
  if( gp->gpname[0]=='_' && gp->gpname[1]=='.' )
    fprintf(fout,"\",\"m_%s%s\"",gp->gpname+2,(optsuffix?optsuffix:""));
  else
    fprintf(fout,"\",\"%s%s\"",gp->gpname,(optsuffix?optsuffix:""));
  if (gp->proto.origin)
    fprintf(fout,",\"%s\"",gp->proto.origin);
  fprintf(fout,");\n");
}

void genheader(FILE *fout)
{
  int i;
  fprintf(fout,"/*-*- compile-command: \"");
  fprintf(fout,PARI_MODULE_BUILD,nameparse,nameparse,nameparse,nameparse);
  fprintf(fout,"\"; -*-*/\n");
  fprintf(fout,"#include <pari/pari.h>\n");
  fprintf(fout,"/*\n");
  for(i=0;i<s_func.n;i++)
    if (lfunc[i].spec==GPinstalled)
    {
      geninstall(fout,i);
      genaddhelp(fout,i);
    }
  for(i=0;i<s_func.n;i++)
    if (lfunc[i].spec==GPuser)
    {
      geninstall(fout,i);
      genaddhelp(fout,i);
    }
  fprintf(fout,"*/\n");
  for(i=0;i<s_func.n;i++)
  {
    if (lfunc[i].spec==GPuser)
      genprototype(fout,i,0);
    else if (lfunc[i].spec==GPinstalled)
      genprotocode(fout,i);
    else continue;
    fprintf(fout,";\n");
  }
  fprintf(fout,"/*End of prototype*/\n\n");
  if (s_ctx.n)
  {
    for(i=0;i<s_ctx.n;i++)
    {
      ctxvar *v=ctxstack+i;
      fprintf(fout,"static ");
      genvarproto(fout,v->node,v->node);
      fprintf(fout,";\n");
    }
    fprintf(fout,"/*End of global vars*/\n\n");
  }
}

void gencodeg(FILE *fout, int n)
{
  int x=tree[n].x;
  int y=tree[n].y;
  if (n<0)
    return;
  if (tree[n].comment>=0)
  {
    if (tree[n].m&(1<<Msemicomma))
      genindent(fout);
    gencomment(fout,n,0);
  }
  if (debug>=3) fprintf(fout,"/*%s:%d*/",GPname(tree[n].t),tree[n].m);
  switch(tree[n].f)
  {
  case Fseq:
    genindentseq(fout,x);
    gencodeg(fout,x);
    gensemicomma(fout,x);
    genindentseq(fout,y);
    gencodeg(fout,y);
    gensemicomma(fout,y);
    break;
  case Faffect:
    genfacteuraff(fout,x,y);
    break;
  case Fconst:
    {
      long val=value[x].val.small;
      const char *str=value[x].val.str;
      long typ=value[x].type;
      switch (typ)
      {
      case CSTsmall:
        fprintf(fout,"%ld",val);
        break;
      case CSTsmallreal:
        {
          int arg=newsmall(val);
          tree[arg].t=Gsmall;
          if (genfuncbydesc1(fout,arg,FC_const_smallreal,n))
            die(n,"Bad description for _const_smallreal");
          stack_pop_safe(&s_node,arg);
        }
        break;
      case CSTint:
      case CSTreal:
        {
          int arg=newstringnode(str,-1);
          int fc=FC_const_expr;
          tree[arg].t=Gstr;
          if (FC_const_real>=0 && typ==CSTreal)
            fc=FC_const_real;
          if (genfuncbydesc1(fout,arg,fc,n))
            die(n,"Bad description for _const_expr");
          stack_pop_safe(&s_value,tree[arg].x);
          stack_pop_safe(&s_node,arg);
        }
        break;
      case CSTstr:
        fprintf(fout,"\"%s\"",str);
        break;
      }
      break;
    }
  case Fsmall:
    fprintf(fout,"%d",tree[n].x);
    break;
  case Frefarg:
    gencodeg(fout,x);
    break;
  case Fentry:
    genentry(fout,n);
    break;
  case Ffunction:
    {
      gpfunc *gp=lfunc+tree[n].x;
      fprintf(fout,"%s",gp->proto.cname);
    }
    break;
  case Fentryfunc:
    genentryfunc(fout,n);
    break;
  case Fdeffunc:
    gendeffunc(fout,n);
    break;
  case Fblock:
    gendefblock(fout,n);
    break;
  case Fgnil:
    fputc('0',fout);
    break;
  case Ftag:
    gencast(fout,x,y);
    break;
  default:
    die(n,"Internal error : unknown func %s in gencode",funcname(tree[n].f));
    break;
  }
}
void genparensg(FILE *fout, int n)
{
  if (n!=-1 && (tree[n].m&(1<<Mparens)))
    fprintf(fout,"(");
  gencodeg(fout, n);
  if (n!=-1 && (tree[n].m&(1<<Mparens)))
    fprintf(fout,")");
}
void gencode(FILE *fout, int n)
{
  if ((tree[n].m&(1<<Mlong)) && ctype[tree[n].t]==Vgen)
  {
    fprintf(fout,"(GEN) ");
    genparensg(fout, n);
  }
  else
    gencodeg(fout, n);
}
void genparens(FILE *fout, int n)
{
  long x=n;
  if(n<0) return;
  x=detag(x);
  if (tree[x].m&(1<<Mlong|1<<Mparens))
  {
    fprintf(fout,"(");
    gencode(fout, n);
    fprintf(fout,")");
  }
  else
    gencode(fout, n);
}

