# gozerlib/gozernet/bot.py
#
#

""" gozernet bot. handlers incoming nodes. """

## gozerlib imports

from gozerbot.xmpp.bot import Bot
from gozerbot.gozernet.event import RemoteEvent
from gozerbot.utils.log import rlog

class GozerNetBot(Bot):

    """ gozernet bot just inherits from xmpp bot for now. """

    def __init__(self, name, cfg={}):
        Bot.__init__(self, name, cfg)
        self.type = "gozernet"

    def say(self, channel, txt, event=None, *args, **kwargs):
        rlog(10, 'gozernet', 'out - %s - %s' % (channel, txt))
        re = RemoteEvent()

        if event:
            re.copyin(event)
        else:
            re.userhost = "%s.%s" % (self.name, self.server)
            re.nick = self.name

        re.isreply = True
        re.iscallback = False
        re.fromm = self.jid
        re.printto = channel
        re.target = channel
        re.txt = re.origtxt = txt         
        re.iscmnd = False
        re.botoutput = True
        re.isresponse = True
        re.remotecmnd = False
        Bot.say(self, channel, re.tojson(), event, *args, **kwargs)

    def cmnd(self, outs, txt, event=None, *args, **kwargs):
        rlog(10, 'gozernet', 'cmnd - %s - %s' % (outs, txt))
        re = RemoteEvent()

        if event:
            re.copyin(event)

        for out in outs:

            try:
                (source, jid) = out
            except ValueError:
                source = ""
                jid = out

            re.fromm = self.jid
            re.printto = jid
            re.target = jid
            re.to = jid
            re.txt = re.origtxt = txt
            re.iscmnd = True
            re.remotecmnd = True
            re.remoteout = self.jid
            Bot.say(self, jid, re.tojson(), event, *args, **kwargs)
