# tests/test_jabberbot.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.jabberbot import Jabberbot
from gozerbot.generic import stringinlist
import unittest, time

class test_jabberbot(unittest.TestCase):
    b = Jabberbot('jabbertest', 'test@test')
    b.userhosts['test'] = 'test@test'

    def test_connect(self):
        result = self.b.connect('jabber.xs4all.nl', \
'gozerd@jabber.xs4all.nl', 'miep')
        self.assert_(result)

    def test_reconnect(self):
        result = self.b.connect('jabber.xs4all.nl', \
'gozerd@jabber.xs4all.nl', 'miep')
        self.b.disconnectHandler()
        self.assert_(self.b.stopped != 0)

    def test_reconnectconnectok(self):
        result = self.b.connect('jabber.xs4all.nl', \
'gozerd@jabber.xs4all.nl', 'miep')
        self.b.disconnectHandler()
        time.sleep(20)
        self.assert_(self.b.connectok.isSet() == 1)
