# web/join.py
#
#

""" join the collective """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import geturl2
from gozerplugs.plugs.webserver import httpd
from gozerplugs.plugs.collective import colls, CollNode
from urllib import unquote_plus
import socket

def handle_join(event):
    """ join the collective """
    try:
        (host, port) = event.client_address
    except:
        return ["can't determine host/port", ]
    input = unquote_plus(event.path)
    try:
        collport = int(input.split('?', 1)[1].strip())
    except (IndexError, ValueError):
        return ['wrong port number', ]
    hp = "%s:%s" % (host, collport)
    url = 'http://%s' % hp
    (hostname, alias, ips) = socket.gethostbyaddr(host)
    hn = socket.getfqdn(hostname)
    name = "%s:%s" % (hn, collport)
    node = CollNode(name, url)
    if 'pong' in node.ping():
        if colls.add(name, url):
            return ['node added', ]
    else:
        return ['no pong received from %s' % host, ]

if httpd:
    httpd.addhandler('join', handle_join)
