# plugs/misc.py
#
#

""" misc commands """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import waitforuser, gozerpopen
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.aliases import aliases
from gozerbot.plughelp import plughelp
from gozerbot.persiststate import UserState
from gozerbot.users import users
import time, os, threading, thread

plughelp.add('misc', 'miscellaneous commands')

def handle_test(bot, ievent):
    """ test .. give test response which is a string of the ircevent """
    ievent.reply(str(ievent))

cmnds.add('test', handle_test, ['USER', 'WEB', 'JCOLL', 'ANON'], options={'--t': 'bla'})
examples.add('test', 'give test response',' test')

def handle_source(bot, ievent):
    """ source .. show where to fetch the bot source """ 
    ievent.reply('see http://gozerbot.org')

cmnds.add('source', handle_source, ['USER', 'WEB', 'ANON'])
examples.add('source', 'show source url', 'source')
aliases.data['about'] = 'source'

def handle_response(bot, ievent):
    """ response .. check if we can get a reply of user """
    ievent.reply("say something so i can see if i can get a \
response from you")
    reply = waitforuser(bot, ievent.userhost)
    if not reply:
        ievent.reply("can't get a response")
    else:
        ievent.reply("you said %s" % reply.txt)

cmnds.add('response', handle_response, ['USER', 'ANON'])
examples.add('response', 'response test .. see if we can receive a response', \
'response')

def handle_ps(bot, ievent):
    """ ps .. show ps line of the bot """
    if os.uname()[0] == 'SunOS':
        args = [""] * 5
        args[0] = 'ps'
        args[1] = '-o'
        args[2] = 'user,pid,pcpu,pmem,vsz,rss,tty,s,stime,etime,comm'
        args[3] = '-p'
        args[4] = str(os.getpid())
    else:
        args = [""] * 3
        args[0] = 'ps'
        args[1] = 'wwup'
        args[2] = str(os.getpid())
    try:
        proces = gozerpopen(args)
    except Exception, ex:
        ievent.reply('error running popen: %s' % str(ex))
        return
    data = proces.fromchild.readlines()
    returncode = proces.close()
    if returncode == 0:
        result = str(data[1]).strip().split()
        temp1 = "cpu=%s mem=%s vsz=%s rss=%s " % tuple(result[2:6])
        temp2 = "stat=%s started=%s time=%s" % tuple(result[7:10])
        threads = " threads=%s" % str(threading.activeCount())
        ievent.reply(temp1+temp2+threads)
    else:
        ievent.reply('error executing ps')

cmnds.add('ps', handle_ps, 'OPER')
examples.add('ps', 'show ps line of the bot', 'ps')

def handle_time(bot, ievent):
    """ time .. show current time """
    authuser = users.getname(ievent.userhost)
    if authuser:
        if ievent.rest:
            if users.exist(ievent.rest):
                username = ievent.rest
            else:
                ievent.reply("We don't have a user %s" % ievent.rest)
                return
        else:
            username = authuser
        userstate = UserState(username)
        try:
            tz = userstate['TZ']
        except KeyError:
            if username == authuser:
                tz = handle_ask_timezone(bot, ievent)
                if tz and set_timezone(bot, ievent, userstate, tz):
                    tz = userstate['TZ']
                else:
                    return
            else:
                ievent.reply("%s doesn't have a timezone set" % username)
                return
        ievent.reply(get_time(tz, username, authuser))
    else:
        ievent.reply(get_time('UTC', '', ''))

cmnds.add('time', handle_time, ['USER', 'ANON'])
examples.add('time', 'show current time (of a user)', 'time [user]')
aliases.data['t'] = 'time'
aliases.data['date'] = 'time'

def handle_timezone(bot, ievent):
    """ timezone .. set current timezone """
    username = users.getname(ievent.userhost)
    if username:
        userstate = UserState(username)
        if ievent.rest:
            try:
                timezone = int(ievent.rest)
            except ValueError:
                ievent.reply('TZ needs to be an integer')
                return
        else:
            timezone = handle_ask_timezone(bot, ievent)
        if timezone:
            set_timezone(bot, ievent, userstate, timezone)

cmnds.add('timezone', handle_timezone, ['USER'])
examples.add('timezone', 'set current timezone', 'timezone [tz]')

def handle_ask_timezone(bot, ievent):
    ievent.reply('what is your timezone ? for example -1 or +4')
    response = waitforuser(bot, ievent.userhost)
    if response:
        return response.txt
    else:
        ievent.reply("can't determine timezone .. not setting it")
        return

def set_timezone(bot, ievent, userstate, timezone):
    # check for timezone validity and return False, if necessary
    try:
        tz = int(timezone)
    except ValueError:
        ievent.reply('timezone needs to be an integer')
        return False
    userstate['TZ'] = timezone
    userstate.save()
    ievent.reply("timezone set to %s" % timezone)
    return True

def get_time(zone, username, authuser):
    try:
        zone = int(zone)
    except ValueError:
        zone = 0
    return time.ctime(time.time() + int(time.timezone) + zone*3600)
