# gozerbot/commands.py
#
#

""" implement commands """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import rlog, calledfrom, handle_exception, lockdec
import gozerbot.thr as thr
import sys, re, copy, types, thread

commandlock = thread.allocate_lock()
locked = lockdec(commandlock)

class Command(object):

    """ a command """

    def __init__(self, func, perm, plugname, speed=5, threaded=True, \
allowqueue=True, options={}):
        # function to call
        self.name = "noname"
        self.func = func
        # make sure permission(s) are stored in a list
        if type(perm) == types.ListType:
            self.perms = list(perm)
        else:
            self.perms = [perm, ]
        # the plugin name
        self.plugname = plugname
        # determines which runqueue to put the command in. the lower the 
        # faster
        self.speed = copy.deepcopy(speed)
        # flag to see if commands need to run threaded or in the main loop
        self.threaded = copy.deepcopy(threaded)
        self.allowqueue = copy.deepcopy(allowqueue)
        self.options = dict(options)
        
class Commands(dict):

    """ commands object is a dict containing the commands """

    def __setitem__(self, name, value):
        dict.__setitem__(self, name, value)

    def __delitem__(self, name):
        dict.__delitem__(self, name)

    def size(self):
        """ nr of commands """
        return len(self)

    @locked
    def whatperms(self):
        """ return all possible permissions """
        result = []
        for i in self.values():
            for j in i.perms:
                if j not in result:
                    result.append(j)
        return result

    @locked
    def list(self, perm):
        """ list commands with permission perm """
        result = []
        if type(perm) != types.ListType:
            perm = perm.upper()
            perms = [perm, ]
        else:
            perms = perm
        for name, cmnd in self.items():
            for i in perms:
                if i in cmnd.perms:
                    result.append(name)
        return result

    @locked
    def getfuncnames(self, plug):
        result = []
        for i in self.values():
            if i.plugname == plug:
                result.append(i.func.func_name)
        return result

    @locked
    def permoverload(self, funcname, perms):
        """ overload permission of function with funcname  """
        perms = [perm.upper() for perm in perms]
        for com in self.values():
            try:
                if com.func.func_name == funcname:
                    com.perms = perms
                    return 1
            except AttributeError:
                rlog(10, 'commands', "permoverload: no %s function" % funcname)
        return 0

    @locked
    def add(self, cmnd, func, perm, speed=5, threaded=True, allowqueue=True, \
options={}):
        """ add a command """
        # plugin where the command is added
        plugname = calledfrom(sys._getframe())
        rlog(-3, 'commands', 'added %s (%s) ' % (cmnd, plugname))
        # add command
        self[cmnd.lower()] = Command(func, perm, plugname, speed, threaded, \
allowqueue, options)
        self[cmnd.lower()].name = cmnd.lower()

    @locked
    def apropos(self, what, perms=[]):
        """ search for command """
        result = []
        for name, cmnd in self.iteritems():
            if perms:
                go = False
                for i in perms:
                    if i in cmnd.perms:
                        go = True
                if not go:
                    continue                
            if re.search(what, name):
                result.append(name)
        return result

    @locked
    def unload(self, plugname):
        """ unload plugin commands """
        results = []
        # look for the commands registerd in plugin
        for name, cmnd in self.iteritems():
            if cmnd.plugname == plugname:
                results.append(name)
        got = 0
        # remove commands
        for name in results:
            del self[name]
            rlog(-3, 'commands', 'unloaded %s (%s)' % (name, plugname))
            got = 1
        if got:
            return 1

    @locked
    def whereis(self, what):
        """ locate command """
        result = []
        for name, cmnd in self.iteritems():
            if name == what:
                if not cmnd.plugname in result:
                    result.append(cmnd.plugname)
        return result

    @locked
    def perms(self, name):
        """ get permission of command """
        name = name.lower()
        if self.has_key(name):
            return self[name].perms
        else:
            return []

    @locked
    def setperm(self, name, perm):
        """ set permission of command """
        name = name.lower()
        perm = perm.upper()
        if self.has_key(name):
            if perm not in self[name].perms:
                self[name].perms.append(perm)
            return 1

    @locked
    def getcommand(self, txt):
        """ return commands matching with txt """
        textlist = txt.split()
        if not textlist:
            return None
        cmnd = textlist[0].lower()
        if self.has_key(cmnd):
            com = self[cmnd] # the command
            return com
        else:
            return None

    def dispatch(self, com, txt):
        """ dispatch command """
        if com.threaded:
            thr.start_new_thread(com.func, (txt, ))
        else:
            try:
                com.func(txt)
            except Exception, ex:
                handle_exception()
                return 0
        return 1

class Botcommands(Commands):

    """ commands for the bot aka dispatch with (bot, ircevent) """

    def dispatch(self, com, bot, ievent):
        """ dispatch on ircevent passing bot an ievent as arguments """
        if bot.stopped:
            return 0
        # execute command
        if com.threaded:
            thr.start_bot_command(com.func, (bot, ievent))
        else:
            try:
                com.func(bot, ievent)
            except Exception, ex:
                handle_exception(ievent)
                return 0
        return 1

cmnds = Botcommands()
