# tests/test_alert.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.users import users
from gozerbot.generic import stringinlist
from gozerbot.plugins import plugins
import unittest, time, Queue

class test_alert(unittest.TestCase):
    b = Bot()

    def __init__(self, bla):
        self.b.userhosts['test'] = 'test@test'
        self.b.say = self.sayoverload
        unittest.TestCase.__init__(self, bla)
        self.gotcha = 0
        users.permitted = self.yes
        plugins.reload('gozerplugs.plugs', 'alert')

    def sayoverload(self, printto, what, who=None, how=None, fromm=None, \
speed=5):
        if 'looking' in what:
            self.gotcha = 1

    def yes(self, a, b, c):
        return 1

    def no(self, a, b, c):
        return 0

    def test_alert(self):
        result = self.b.test('alert')
        self.assert_(stringinlist('<nick>', result))

    def test_alert2(self):
        result = self.b.test('alert blablabla')
        self.assert_(stringinlist("can't", result))

    def test_alertnoallow(self):
        users.permitted = self.no
        result = self.b.test('alert test')
        self.assert_(stringinlist("doesn't", result))

    def test_alertok(self):
        self.gotcha = 0
        users.permitted = self.yes
        self.b.test('alert test')
        self.assertEqual(self.gotcha, 1)
