# plugs/alias.py
#
#

""" implement aliases commands """

__copyright__ = 'this file is in the public domain'

from gozerbot.aliases import aliasget, aliasdel, aliasset, aliases, aliassave
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.plughelp import plughelp

plughelp.add('alias', 'support for aliases')

def handle_aliassearch(bot, ievent):
    """ alias-search <what> .. search aliases """
    try:
        what = ievent.args[0]
    except IndexError:
        ievent.missing('<what>')
        return
    result = []
    res = []
    for i, j in aliases.data.iteritems():
        if what in i or what in j:
            result.append((i, j))
    if not result:
        ievent.reply('no %s found' % what)
    else:
        for i in result:
            res.append("%s => %s" % i)
        ievent.reply("aliases matching %s: " % what, res, dot=True)

cmnds.add('alias-search', handle_aliassearch, 'USER')
examples.add('alias-search', 'search aliases',' alias-search web')

def handle_aliasset(bot, ievent):
    """ alias-set <from> <to> .. set alias """
    try:
        (aliasfrom, aliasto) = (ievent.args[0], ' '.join(ievent.args[1:]))
    except IndexError:
        ievent.missing('<from> <to>')
        return
    if not aliasto:
        ievent.missing('<from> <to>')
        return
    if aliases.data.has_key(aliasto):
        ievent.reply('cannot alias an alias')
        return
    if not cmnds.has_key(aliasto):
        ievent.reply('command does not exist')
        return
    if cmnds.has_key(aliasfrom):
        ievent.reply('command with same name already exists.')
        return
    # add alias and save
    aliasset(aliasfrom, aliasto)
    aliassave()
    ievent.reply('alias added')

cmnds.add('alias-set', handle_aliasset, 'OPER', allowqueue=False)
examples.add('alias-set', 'alias-set <from> <to> .. define alias', \
'alias-set ll list')
aliases.data['alias'] = 'alias-set'

def handle_delalias(bot, ievent):
    """ alias-del <word> .. delete alias """
    try:
        what = ievent.args[0]
    except IndexError:
        ievent.missing('<what>')
        return
    # del alias and save
    if not aliasdel(what):
        ievent.reply('there is no %s alias' % what)
        return
    ievent.reply('alias deleted')

cmnds.add('alias-del', handle_delalias, 'OPER')
examples.add('alias-del', 'alias-del <what> .. delete alias', 'alias-del ll')

def handle_getalias(bot, ievent):
    """ alias-get <word> .. show alias """
    try:
        what = ievent.args[0]
    except IndexError:
        ievent.missing('<what>')
        return
    # del alias and save
    alias = aliasget(what)
    if not alias:
        ievent.reply('there is no %s alias' % what)
        return
    ievent.reply(alias)

cmnds.add('alias-get', handle_getalias, 'USER')
examples.add('alias-get', 'alias-get <what> .. get alias', 'alias-get v')
