# plugs/pgp.py
#
# (c) Wijnand 'tehmaze' Modderman - http://tehmaze.com
# BSD License

""" pgp utilities """

__author__ = "Wijnand 'tehmaze' Modderman - http://tehmaze.com"
__license__ = 'BSD'

from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.pgp import pgp
from gozerbot.plughelp import plughelp
import re

plughelp.add('pgp', 'pgp utilities')

re_keyid = re.compile('^[0-9a-f]+$', re.I)
re_keyfinger = re.compile('.*Key fingerprint = ([0-9A-F\s]+)', re.I | re.M)
re_keypub = re.compile('pub\s+(\d+)(.)/([0-9A-F]+).+([-\d]{10})', re.M)
re_keyuid = re.compile('^uid\s+(.*)', re.M)

def handle_pgpfingerprint(bot, ievent):
    """ return fingerprint """
    if not ievent.args:
        return ievent.missing('<key id>')
    if not re_keyid.match(ievent.args[0]):
        return ievent.reply('invalid key id')
    (data, returncode) = pgp._gpg('--fingerprint', ievent.args[0])
    results = []
    test_keypub = re_keypub.search(data)
    if test_keypub:
        bits = int(test_keypub.group(1))
        keytype = test_keypub.group(2)
        if keytype == 'D':
            keytype = 'DSA'
        elif keytype == 'R':
            keytype = 'RSA'
        else:
            keytype = 'unknown'
        date = test_keypub.group(4).strip()
        results.append('%d bits %s key, created %s' % (bits, keytype, date))
    test_keyfinger = re_keyfinger.search(data)
    if test_keyfinger:
        results.append('fingerprint %s' % \
test_keyfinger.group(1).strip().replace(' ', ''))
    test_keyuid = re_keyuid.findall(data)
    if test_keyuid:
        results.append('user ids: %s' % ' .. '.join([x.strip() for x in \
test_keyuid]))
    if not results:
        return ievent.reply('no results')
    ievent.reply(', '.join(results))

cmnds.add('pgp-fingerprint', handle_pgpfingerprint, 'USER')
examples.add('pgp-fingerprint', 'shows the fingerprint information of a \
key id', 'pgp-fingerprint C5C9C2B2')

def handle_ppglist(bot, ievent):
    """ lists pgp keys """
    (data, returncode) = pgp._gpg('--fingerprint')
    pubkeys = re_keypub.findall(data)
    if pubkeys:
        pubkeys = [x[2] for x in pubkeys]
        pubkeys.sort()
        ievent.reply('installed public keys: %s' % ' .. '.join(pubkeys))
    else:
        ievent.reply('no public keys installed')

cmnds.add('pgp-list', handle_ppglist, 'OPER')

def handle_pgpremove(bot, ievent):
    """ remove pgp key """
    if not ievent.args:
        return ievent.missing('<key id>')
    if len(ievent.args[0]) < 8 or not re_keyid.match(ievent.args[0]):
        return ievent.reply('invalid key id')
    if pgp.remove(ievent.args[0]):
        ievent.reply('ok')
    else:
        ievent.reply('failed')

cmnds.add('pgp-remove', handle_pgpremove, 'OPER')
