# plugs/job.py
#
# (c) Wijnand 'tehmaze' Modderman - http://tehmaze.com
# BSD License

""" Job management """

__author__ = "Wijnand 'tehmaze' Modderman - http://tehmaze.com"
__license__ = "BSD"

from gozerbot.aliases import aliases
from gozerbot.commands import cmnds
from gozerbot.periodical import periodical, at
from gozerbot.plugins import plugins
from gozerbot.examples import examples
from gozerbot.plughelp import plughelp
import copy
import datetime
import time
import types

plughelp.add('job', 'job management')

def handle_job(bot, ievent):
    """ show data of <jobid> """
    if not ievent.args or not ievent.args[0].isdigit():
        ievent.reply('<job id>')
        return
    for job in periodical.jobs:
        if job.id() == int(ievent.args[0]):
            next = job.next
            if type(next) in [types.FloatType, types.IntType]:
                next = datetime.datetime(*time.localtime(next)[:7])
            ievent.reply('%s, fires at %s' % (job.__repr__(), str(next)))
            return
    ievent.reply('job not found')

cmnds.add('job', handle_job, 'USER')
examples.add('job', 'show job data of <jobid>', 'job 1')

def handle_joblist(bot, ievent):
    """ show job list """
    reply = []
    for job in periodical.jobs:
        reply.append('%d: %s (%s)' % (job.id(), str(job.func.func_name), \
job.group or '<no group>'))
    if reply:
        ievent.reply(reply)
    else:
        ievent.reply('no jobs')

cmnds.add('job-list', handle_joblist, 'OPER')
examples.add('job-list', 'show waiting jobs', 'jobs-list')
aliases.data['jobs'] = 'job-list'

def handle_jobkill(bot, ievent):
    """ kill a job """
    if not ievent.args or not ievent.args[0].isdigit():
        ievent.missing('<job id> [<job id> ...]')
        return
    try:
        ids = [int(jid) for jid in ievent.args]
    except ValueError:
        ievent.missing('<job id> [<job id> ...]')
        return
    for jid in ids:
        periodical.killjob(int(ievent.args[0]))
    ievent.reply('killed %d jobs' % len(ids))

cmnds.add('job-kill', handle_jobkill, 'OPER')
examples.add('job-kill', 'kill job with <jobid>', 'job-kill 100000')
