# plugs/alert.py
#
#

"""  alert somebody """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import getwho
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.users import users
from gozerbot.plughelp import plughelp

plughelp.add('alert', 'send a message to a user')

def handle_alert(bot, ievent):
    """ alert <nick> .. send alert message """
    try:
        who = ievent.args[0]
    except Exception, ex:
        ievent.missing('<nick>')
        return
    userhost = getwho(bot, who)        
    if not userhost:
        ievent.reply("can't find userhost of %s" % who)
        return
    username = users.getname(ievent.userhost)
    if users.permitted(userhost, username, 'alert'):
        bot.say(who, "%s is looking for you" % ievent.nick, speed=1)
        ievent.reply("alert send")
    else:
        ievent.reply("%s doesn't allow alert for %s" % (who, username))
 
cmnds.add('alert', handle_alert, 'USER', speed=2)
examples.add('alert', 'send alert to user', 'alert dunker')
