# gozerbot/monitor.py
#
#

""" monitors .. call callback on bot output """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import rlog, handle_exception
import gozerbot.thr as thr

class Monitor(object):

    """ monitor base class """

    def __init__(self):
        self.outs = []

    def add(self, name, callback, pre):
        """ add a say monitoring callback """
        name = name.lower()
        self.outs.append((name, callback, pre))
        rlog(0, 'monitor', 'added %s (%s)' % (name, str(callback)))

    def unload(self, name):
        """ delete monitor item """
        name = name.lower()
        for i in range(len(self.outs)-1, -1, -1):
            if self.outs[i][0] == name:
                del self.outs[i]

class Saymonitor(Monitor):

    """ monitor bot output (bot.say) """

    def callcb(self, botname, printto, txt, who, how, fromm):
        """ fire saymonitor callbacks """
        for i in self.outs:
            # check if precondition is met
            try:
                if i[2]:
                    doit = i[2](botname, printto, txt, who, how, fromm)
                else:
                    doit = 1
            except Exception, ex:
                handle_exception()
                doit = 0
            if doit:
                # run monitor callback in its own thread
                rlog(0, 'saymonitor', 'excecuting saymonitor callback %s' \
% i[0])
                thr.start_new_thread(i[1], (botname, printto, txt, who, \
how, fromm))

class Outmonitor(Monitor):

    """ monitor for bot output (bot.send) """

    def callcb(self, botname, txt):
        """ fire outmonitor callbacks """
        for i in self.outs:
            # check if precondition is met
            try:
                if i[2]:
                    doit = i[2](botname, txt)
                else:
                    doit = 1
            except Exception, ex:
                handle_exception()
                doit = 0
            if doit:
                # run monitor callback in thread
                rlog(0, 'outmonitor', 'excecuting outmonitor callback \
%s' % i[0])
                thr.start_new_thread(i[1], (botname, txt))

class Jabbermonitor(Monitor):

    """ monitor jabber output """

    def callcb(self, botname, msg):
        """ fire jabber monitor callbacks """
        for i in self.outs:
            # check if precondition is met
            try:
                if i[2]:
                    rlog(0, 'jabbermonitor', 'checking inloop %s' % str(i[2]))
                    doit = i[2](botname, msg)
                else:
                    doit = 1
            except Exception, ex:
                handle_exception()
                doit = 0
            if doit:
                # run monitor callback in its own thread
                rlog(0, 'jabbermonitor', 'excecuting jabbermonitor callback \
%s' % i[0])
                thr.start_new_thread(i[1], (botname, msg))

# bot.send() monitor
outmonitor = Outmonitor() 

# bot.say() monitor
saymonitor = Saymonitor()

# jabber monitor
jabbermonitor = Jabbermonitor()
