# Google OAuth Client Library for Java

## <a name='maintenance'>Library maintenance</a>

This client library is supported but in maintenance mode only. We are fixing necessary bugs and
adding essential features to ensure this library continues to meet your needs for accessing Google
APIs. Non-critical issues will be closed. Any issue may be reopened if it is causing ongoing
problems.

## Description

Written by Google, the Google OAuth Client Library for Java is a powerful and easy-to-use Java
library for the OAuth 1.0a and OAuth 2.0 authorization standards. The Google OAuth Client Library
for Java is designed to work with any OAuth service on the web, not just with Google APIs. It is
built on the [Google HTTP Client Library for Java](https://github.com/google/google-http-java-client).

The library supports the following Java environments:

- Java 6 (or higher)
- Android 4.0 (Ice Cream Sandwich) (or higher)
- Google App Engine

For access to Google APIs, see the
[Google APIs Client Library for Java](https://github.com/google/google-api-java-client).

This is an open-source library, and
[contributions](https://developers.google.com/api-client-library/java/google-oauth-java-client/contribute)
are welcome.

## Documentation

- [Developer's Guide](https://developers.google.com/api-client-library/java/google-oauth-java-client/)
- [Setup Instructions](https://developers.google.com/api-client-library/java/google-oauth-java-client/setup)
- [Samples](https://developers.google.com/api-client-library/java/google-oauth-java-client/samples)
- [JavaDoc](https://developers.google.com/api-client-library/java/google-oauth-java-client/reference/index)
- [Release Notes](https://developers.google.com/api-client-library/java/google-oauth-java-client/release-notes)
- [Support (Questions, Bugs)](https://developers.google.com/api-client-library/java/google-oauth-java-client/support)

## CI Status

Java Version | Status
------------ | ------
Java 7 | [![Kokoro CI](http://storage.googleapis.com/cloud-devrel-public/java/badges/google-oauth-java-client/java7.svg)](https://storage.googleapis.com/cloud-devrel-public/java/badges/google-oauth-java-client/java7.html)
Java 8 | [![Kokoro CI](http://storage.googleapis.com/cloud-devrel-public/java/badges/google-oauth-java-client/java8.svg)](https://storage.googleapis.com/cloud-devrel-public/java/badges/google-oauth-java-client/java8.html)
Java 10 | [![Kokoro CI](http://storage.googleapis.com/cloud-devrel-public/java/badges/google-oauth-java-client/java10.svg)](https://storage.googleapis.com/cloud-devrel-public/java/badges/google-oauth-java-client/java10.html)

## Links

- [Discuss](http://groups.google.com/group/google-oauth-java-client)

## Notice: Ending Java 6 Support

Please note: since Java 6 extended support is being ended this December by Oracle, we will begin
ending Java 6 support in early 2019, with release 1.28.0 as a tentative goal. Users may stay still
use these libraries in Java 6 projects for some time, but going forward we will not ensure that
these libraries work in such an environment. After 1.28.0, our supported versions will include Java
7 and onward.

For Android users, we will continue our 4.0 support.

For questions or concerns, please file an issue in the GitHub repository.
