/*
	Version 1.0.0.6
	. aadir icono animado al acceder a Google
	. removeBookmark: pedir confirmacin usando XPath
	. editBookmark
	. arbol para aadir

	Version 1.0.0.7
	. 18.12.2006
		permitir aadir dos marcadores contra el mismo directorio virtual (addRemoveMenuItem)
	. 27.12.2006
		corregido error en 'getBookmarksFromGoogleAndCreateMenu' que aadia una carpeta vacia cuando solo hay enlaces 'raiz'
		
	Versin 1.0.0.9
	. 11.01.2007
		corregido error al borrar una carpeta: se borraban otras carpetas con nombres que contuvieran al dado (doRemoveFolderFromTree)

	Versin 1.0.0.10
	. 15.01.2007
		Se aade un interfaz de opciones

	Versin 1.0.0.11
	. 18.01.2007
		Se aaden las funciones overrideUsertAgent y restoreUserAgent (ambas tomadas de la extensin Google Bookmarks Button) para 
			adaptarnos a la nueva gestin de marcadores de Google
		Se modifica el modo de mostrar el men contextual

	Versin 1.0.0.12
	. 18.06.2007
		Se modifica la extensin para adpatarse a la nueva interfaz de Google

	Versin 1.0.0.14
	. 25.06.2007
		Error al incluir el ttulo de un marcador caracteres internacionales
	. 26.06.2007
		Error al recuperar marcadores sin subcarpetas

	Versin 1.0.0.15
	. 24.10.2007
		Error al recuperar marcadores 'raiz' en la ventana de administracin
	. 25.10.2007
		Error al renombrar una etiqueta
		Opcin para no recuperar los 'favicons'
		Dialogo de mantenimiento no modal
		Mantenimiento mnimo
		Nueva opcin para abrir los marcadores de una carpeta
	Versin 1.0.0.16
		Error al instalar la versin 1.0.0.15 desde cero
	Versin 1.0.0.17
		Actualizacin para Firefox 3.0 beta
	Versin 1.0.0.18
		Actualizacin para Firefox 3.0
	Versin 1.0.0.19
		Eliminamos dilogo de error en getFavicon
	Versin 1.0.0.20
		Nuevo men contextual para abrir el marcador en la solapa activa
	Versin 1.0.0.21 y  1.0.0.22
		Versin para Firefox 3.5.*
	Versin 1.1
		Versin para Firefox 4.*
	Versin 1.2
		Solucionamos el doble menu contextual
	Versin 1.3
		'Botonizamos' el aspecto del icono de la extensin (Zan Reus)
		Solucionamos la codificacin de los ttulos de un marcador para que acepte caracteres especiales (Yu Jianrong)
	Version 1.4
		Convertimos las llamadas XMLHttpRequests en asincronas
*/

var isContextOpen = false;

var dengGB = {
	defaultSep: "_SEP_",
	m_labelsArr: null,
	currentContextId: "",
	m_response: null,
	m_bookmarksUserDefinedSep: "",
	m_originalUserFavIconPref: true,
	
	suniconvCID   : '@mozilla.org/intl/scriptableunicodeconverter',
	suniconvIID   : Components.interfaces.nsIScriptableUnicodeConverter,

	// Mtodos overrideUserAgent y restoreUserAgent tomados de 'Google Bookmarks Button' y modificados 
	// 18/06/2007: Google modific el modo en que gestiona los marcadores
	overrideUserAgent : function(){
		var com = Components.classes["@mozilla.org/uriloader/external-helper-app-service;1"];
		var httpHandler = com.createInstance(Components.interfaces.nsIExternalProtocolService);
		
		var userAgent = httpHandler.userAgent
		var prefs = Components.classes["@mozilla.org/preferences-service;1"].
						getService(Components.interfaces.nsIPrefService).getBranch("general.useragent.");
		
		if (prefs.prefHasUserValue("override")) {
			this.oldUserAgent=prefs.getCharPref("override");
		}
		else {
			this.oldUserAgent=null;
		}   
		prefs.setCharPref("override",this.userAgent+' GoogleToolbarBB');
	},
		
	restoreUserAgent : function(){
	    var prefs=Components.classes["@mozilla.org/preferences-service;1"].
				        getService(Components.interfaces.nsIPrefService).getBranch("general.useragent.");
	    if(this.oldUserAgent!=null)
			prefs.setCharPref("override",this.oldUserAgent);
	    else 
			prefs.clearUserPref("override");
	},

	// Carga
	onLoad: function() {
		// initialization code
		this.initialized = true;
		this.promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
		this.m_bookmarksUserDefinedSep = dengGB.getBookmarksLevelSeparator();
		this.m_originalUserFavIconPref = dengGB.getFavIconsOption();
	},
	// Abrir un 'alert'
	dumpDebug: function(title, text) {
		if (!this.initialized) dengGB.onLoad();
		this.promptService.alert(window, title, text);
	},
	// Navegar a un marcador
	onItemCommand: function(e) {
		dengGB.showWebPage(e.currentTarget.getAttribute("url"));
	},
	// Gestionar marcadores
	onManageBookmarks: function(e) {
		dengGB.showWebPage("http://www.google.com/bookmarks/?zx=VLt1Lnqae50");
	},
	// Abrir una url en una nueva solapa
	showWebPage: function(pageUrl) {
	    //check for an existing browser window
	    const kWindowMediatorContractID = "@mozilla.org/appshell/window-mediator;1";
	    const kWindowMediatorIID = Components.interfaces.nsIWindowMediator;
	    const kWindowMediator = Components.classes[kWindowMediatorContractID].getService(kWindowMediatorIID);
	    var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
		if (browserWindow) {
			try {
				browserWindow.delayedOpenTab(pageUrl); 	// Abre una nueva solapa en Firefox y carga la pgina solicitada
			}
			catch(e) {
				browserWindow.loadURI(pageUrl); 		// Carga la url en la pgina activa
			}
		}
		else 
			window.open(pageUrl);
	},
	// Abrir una url en la solapa activa
	showWebPageAtCurrentTab: function(pageUrl) {
	    //check for an existing browser window
	    const kWindowMediatorContractID = "@mozilla.org/appshell/window-mediator;1";
	    const kWindowMediatorIID = Components.interfaces.nsIWindowMediator;
	    const kWindowMediator = Components.classes[kWindowMediatorContractID].getService(kWindowMediatorIID);
	    var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
		if (browserWindow) 
			browserWindow.loadURI(pageUrl); 		// Carga la url en la pgina activa
		else 
			window.open(pageUrl);
	},
	// Abrir acerca de
	onItemAbout: function(e) {
		window.openDialog("chrome://dengGB/content/about.xul", "", "centerscreen");
	},
	// Verificar si estamos conectados a Google
	checkLogin: function () {
		var cookieManager = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager);
		var iter = cookieManager.enumerator;
		
		while (iter.hasMoreElements()) {
			var cookie = iter.getNext();
			if (cookie instanceof Components.interfaces.nsICookie && cookie.host.indexOf("google.com") != -1 && cookie.name == "SID")
				return true;	
		}
		return false;
	},
	// Cuadro de conexin para identificarse en Google
	showLogin: function (e)	{
		try
		{
			var a = window, b = document;
			var c = encodeURIComponent;

			var width = 340;
			var height = 340;
			var left = Math.floor( (screen.width - width) / 2);
			var top = Math.floor( (screen.height - height) / 2);

			window.open('https://www.google.com/accounts/ServiceLogin?service=toolbar&nui=1&hl=en&continue=http%3A%2F%2Ftoolbar.google.com%2Fcommand%3Fclose_browser',
				'bkmk_popup',
				'left=' + left + ',top=' + top + ',height=' + height + 'px, width= ' + width + 'px,resizable=1');
		}
		catch (ex) {
			dengGB.dumpDebug("doLogin", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
			return false;
		}
		return true;
	},
	contextRemoveBookmark: function(event) {
		try {
			// Cerramos el men principal (?)
			document.getElementById("dengGBMainMenuPopup").hidePopup();
			
			dengGB.removeBookmark(event, dengGB.currentContextId, true, true);
		}
		catch (ex) {
			dengGB.dumpDebug("contextRemoveBookmark", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	contextEditBookmark: function(event) {
		try {
			// Cerramos el men principal (?)
			document.getElementById("dengGBMainMenuPopup").hidePopup();
			
			// Buscamos los valores que necesitamos
			var bS = { id: dengGB.currentContextId, label: "", url: "", tag: "" };
			
			dengGB.getBookmarkFromId(bS);
			dengGB.openAddBookmarkDlg(event, bS);
		}
		catch (ex) {
			dengGB.dumpDebug("contextEditBookmark", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	contextOpenBookmarks: function(event) {
		try {
			// Cerramos el men principal (?)
			document.getElementById("dengGBMainMenuPopup").hidePopup();
			
			// Buscamos los valores que necesitamos
			var bS = { id: dengGB.currentContextId, label: "", url: "", tag: "" };
			
			dengGB.getBookmarkFromId(bS);
				
			var bookmarks = dengGB.m_response.getElementsByTagName("bookmark");
			
			for (var j = 0; j < bookmarks.length; j++) {
				var bookmarkLabels = bookmarks[j].getElementsByTagName("label");

				if (!bookmarkLabels.length && bS.tag == "") 
					dengGB.showWebPage(bookmarks[j].getElementsByTagName("url")[0].childNodes[0].nodeValue);
				else if (bookmarkLabels[0] && bookmarkLabels[0].childNodes[0].nodeValue == bS.tag) 
					dengGB.showWebPage(bookmarks[j].getElementsByTagName("url")[0].childNodes[0].nodeValue);
			}
		}
		catch (ex) {
			dengGB.dumpDebug("contextOpenBookmarks", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	// Men contextual de abrir marcador en la solapa activa
	contextOpenBookmarkHere: function(event) {
		try {
			// Cerramos el men principal (?)
			document.getElementById("dengGBMainMenuPopup").hidePopup();
			
			// Buscamos los valores que necesitamos
			var bS = { id: dengGB.currentContextId, label: "", url: "", tag: "" };
			
			dengGB.getBookmarkFromId(bS);
			dengGB.showWebPageAtCurrentTab(bS.url); 
		}
		catch (ex) {
			dengGB.dumpDebug("contextOpenBookmarks", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	// Men contextual de un marcador
	onBookmarkContextMenu: function(event) {
		try {
			isContextOpen = true;
			dengGB.currentContextId = event.target.getAttribute("id");
			
			document.getElementById("bookmarkContext").showPopup(document.getElementById(dengGB.currentContextId), 
																event.screenX - 2, event.screenY - 2, "context");
		}
		catch (ex) {
			dengGB.dumpDebug("onBookmarkContextMenu", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	sortBookmarks: function (a, b) {
		return a.getElementsByTagName("title")[0].childNodes[0].nodeValue < b.getElementsByTagName("title")[0].childNodes[0].nodeValue ? -1 : 1; 
	},
	// Marcadores y subcarpetas de una carpeta
	popupPopulate: function(e, label) {
		try {
			var menupopup 	= document.getElementById("folderpopup_" + label);
			var menu 		= document.getElementById("folderMenu_" + label);
			
			var submenus 	= menupopup.getElementsByTagName("menupopup");
			var subitems 	= menupopup.getElementsByTagName("menuitem");
			
			menu.setAttribute("image", "chrome://dengGB/skin/openFolder.gif");
			
			if (subitems.length || submenus.length) return true;
			
			// Buscamos los bookmarks que tengan esta etiqueta
			var bookmarks = dengGB.m_response.getElementsByTagName("bookmark");
			var subfoldersLabelsArr = new Array();
			var bookmarksArr = new Array();
			
			for (var j = 0; j < bookmarks.length; j++) {
				var bookmarkLabels = bookmarks[j].getElementsByTagName("label");
				var pos;

				for (var k = 0; k < bookmarkLabels.length; k++) {
					if (bookmarkLabels[k].childNodes[0].nodeValue.indexOf("^") == 0) continue;
				
					if (bookmarkLabels[k].childNodes[0].nodeValue == label)
						bookmarksArr.push(bookmarks[j]);
					else if((pos = bookmarkLabels[k].childNodes[0].nodeValue.indexOf(label)) != -1 && 
							bookmarkLabels[k].childNodes[0].nodeValue.length > label.length) {
							
						var tempArr = bookmarkLabels[k].childNodes[0].nodeValue.split(dengGB.getBookmarksLevelSeparator());
						
						for (var i = 0; i < tempArr.length; i++) {
							if (tempArr[i] == label) {
								if (i + 1 < tempArr.length) {
									// Solo la aadimos si no la tenemos ya
									var subfoldersLabelsArrJoin = subfoldersLabelsArr.join();
									if (subfoldersLabelsArrJoin.indexOf(tempArr[i + 1]) == -1)
										subfoldersLabelsArr.push(tempArr[i + 1]);
								}
								else
									bookmarksArr.push(bookmarks[j]);
								break;								
							}
						}
						
					}
				}
			}
				
			subfoldersLabelsArr.sort();
			bookmarksArr.sort(dengGB.sortBookmarks);

			// Aadimos las subcarpetas que haya
			for (i = 0; i < subfoldersLabelsArr.length; i++) {
				// Creamos un menupopup
				var tempMenupopup = document.createElement('menupopup');
				
				with (tempMenupopup) {	
					setAttribute('id', "folderpopup_" + subfoldersLabelsArr[i]);
					setAttribute('onpopupshowing', 'return dengGB.popupPopulate(event, "' + subfoldersLabelsArr[i] + '");');
					setAttribute('onpopuphiding', 'return dengGB.popupHide(event, "' + subfoldersLabelsArr[i] + '");');
				}
				
				// Creamos un menu para cada carpeta
				var tempMenu = document.createElement("menu");
				
				with (tempMenu) {	
					setAttribute("id", "folderMenu_" + subfoldersLabelsArr[i]);
					setAttribute("class", "menu-iconic");
					setAttribute("image", "chrome://dengGB/skin/closeFolder.gif");
					setAttribute("label", subfoldersLabelsArr[i]);
					setAttribute("tooltiptext", subfoldersLabelsArr[i]);
					setAttribute("container", "true");
				}
				
				// Aadimos el popup
				tempMenu.appendChild(tempMenupopup);
				
				// Insertamos el menu de carpeta
				menupopup.appendChild(tempMenu);
			}
				
			// Por ltimo aadimos los marcadores de esta carpeta
			for (var i = 0; i < bookmarksArr.length; i++) {
				var mItem = document.createElement("menuitem");
				with (mItem) {
					setAttribute("id", bookmarksArr[i].getElementsByTagName("id")[0].childNodes[0].nodeValue);
					setAttribute("label", bookmarksArr[i].getElementsByTagName("title")[0].childNodes[0].nodeValue);
					setAttribute("url", bookmarksArr[i].getElementsByTagName("url")[0].childNodes[0].nodeValue);
					setAttribute("tooltiptext", bookmarksArr[i].getElementsByTagName("url")[0].childNodes[0].nodeValue);
					setAttribute("class", "menuitem-iconic");
					setAttribute("image", "chrome://dengGB/skin/closeFolder.gif");
					setAttribute("oncommand", "dengGB.onItemCommand(event)");
					setAttribute("oncontextmenu", "dengGB.onBookmarkContextMenu(event); return false;");
				}
				dengGB.getFavicon(menupopup.appendChild(mItem), bookmarksArr[i].getElementsByTagName("url")[0].childNodes[0].nodeValue, "image");
			}
		}
		catch (ex) {
			dengGB.dumpDebug("popupPopulate", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
		return true;
	},
	// Ocultar los marcadores de una etiqueta
	popupHide: function(e, label) {
		var menu = document.getElementById("folderMenu_" + label);
		menu.setAttribute("image", "chrome://dengGB/skin/closeFolder.gif");
	},
	// Aadir marcador
	// Bookmark: http://www.google.com/bookmarks/mark?q={URL}&title={TITULO}&{ETIQUETAS SEPARADAS POR COMAS}&annotation={NOTAS}&sig={KEY}
	openAddBookmarkDlg: function (e, dS) {
		try {
			var retVals = { choice: "cancel", tag: (dS == null) ? "" : dS.tag, id: (dS == null) ? "" : dS.id, mainObj: dengGB };

			window.openDialog("chrome://dengGB/content/addBookmark.xul", "", "alwaysRaised,centerscreen,chrome,resizable=yes", 
								(dS == null) ? window.content.document.title : dS.label,
								(dS == null) ? window.content.location.href: dS.url,
								dengGB.m_labelsArr, retVals, dengGB.m_response);
		}
		catch (ex) {
			dengGB.dumpDebug("openAddBookmarkDlg", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	// Aadir una carpeta al rbol
	doAddFolderFromTree: function(event) {
		try {
			// Sorprendentemente aun cuando el botn est inhibido se recibe la pulsacin del botn
			if (document.getElementById("addFolderBtn").getAttribute("disabled") == "true") return;
				
			var defaultBookmarksSep = dengGB.getBookmarksLevelSeparator();
				
			// Aadimos una nueva carpeta debajo de la rama actual
			var currItem = document.getElementById("bookmarksTree").view.getItemAtIndex(document.getElementById("bookmarksTree").currentIndex);
			
			var input = {value: ""};
			var check = {value: false};
			var result;
			
			while (true) {
				var result = this.promptService.prompt(window, 
														document.getElementById("dengGB.strings").getString("dengGB.NewTag"), 
														document.getElementById("dengGB.strings").getString("dengGB.AddNewTag"), 
														input, 
														"", 
														check);
													
				if (result && input.value.indexOf(defaultBookmarksSep) != -1)
					dengGB.dumpDebug(document.getElementById("dengGB.strings").getString("dengGB.NewTag"), 
									 document.getElementById("dengGB.strings").getString("dengGB.NewTagError"));
				else
					break;
			}
				
			if (result) {
				var treeChildrenNodes = currItem.getElementsByTagName("treeitem");
				
				// Est contraido: hay que expandir
				if (!treeChildrenNodes.length)
					dengGB.expandTreeItem(currItem);
				else 
					currItem.setAttribute("open", "true");
					
				treeChildrenNodes = currItem.getElementsByTagName("treeitem");
				// Buscamos entre las subcarpetas hijas para ver donde insertar
				var insertBefore = (treeChildrenNodes.length) ? treeChildrenNodes[0] : null;
				
				/* AQUI BUSCAMOS EL NODO ANTES DEL QUE HEMOS DE INSERTAR: AHORA EL NUEVO NODO VA SIEMPRE EL PRIMERO
				for (var i = 0; i < treeChildrenNodes.length; i++) {
					if (treeChildrenNodes[i].id.indexOf("folder_") == 0) {
						var tagName = treeChildrenNodes[i].id.substr("folder_".length);
						var pos;
						
						if ((pos = tagName.lastIndexOf(defaultBookmarksSep)) == -1) pos = 0;
						
						if (tagName.substr(pos) < input.value)
							insertBefore = treeChildrenNodes[i];
					}
				}
				*/
				
				var newId = (currItem.id.indexOf("folder_") == 0) ? 
								currItem.id.substr("folder_".length) + defaultBookmarksSep + input.value : input.value;
								
				// Insertamos el nuevo elemento
				var newItem = dengGB.insertBookmarksTreeElement(currItem.getElementsByTagName("treechildren")[0], 			// padre
																newId,														// id
																input.value,												// label
																"", 														// url
																"chrome://dengGB/skin/closeFolder.gif", 					// icono
																true,														// es padre
																insertBefore);												// insertar antes de
																
				document.getElementById("bookmarksTree").currentIndex += 1; // Seleccionamos el nuevo elemento
				dengGB.doBookmarkTreeSelect(event);
			}
		}
		catch (ex) {
			dengGB.dumpDebug("doAddFolderFromTree", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	// Recupera todos los marcadores 'hijos' de una carpeta dada
	getRecursiveChildrenFromFolder: function(folderName) {
		var childrenArr = new Array();
		
		try {
			var bookmarks = dengGB.m_response.getElementsByTagName("bookmark");
			
			for (var j = 0; j < bookmarks.length; j++) {
				var bookmarkLabels = bookmarks[j].getElementsByTagName("label");
				
				for (var k = 0; k < bookmarkLabels.length; k++) {
					//if (bookmarkLabels[k].childNodes[0].nodeValue.indexOf(folderName) == 0)
					if (bookmarkLabels[k].childNodes[0].nodeValue == folderName)
						childrenArr.push(bookmarks[j]);
				}
			}
		}
		catch (ex) {
			dengGB.dumpDebug("getRecursiveChildrenFromFolder", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
		return childrenArr;
	},
	// Volvemos a pedir los marcadores a Google
	requestBookmarks: function() {
		try {
			dengGB.m_response = null;

			var httpRequest = new XMLHttpRequest();

			// Creamos una funcin asincrona
			httpRequest.onreadystatechange = function() {
				if (httpRequest.status == 200) dengGB.m_response = httpRequest.responseXML.documentElement;
			}
			
			httpRequest.open("GET", "http://www.google.com/bookmarks/lookup?output=xml&num=10000", false); 
			httpRequest.send(null);
		}
		catch (ex) {
			dengGB.dumpDebug("requestBookmarks", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	// Eliminar una carpeta del rbol
	doRemoveFolderFromTree: function(event) {
		try {
			// Sorprendentemente aun cuando el botn est inhibido se recibe la pulsacin del botn
			if (document.getElementById("removeFolderBtn").getAttribute("disabled") == "true") return;
			
			var currItem 		= document.getElementById("bookmarksTree").view.getItemAtIndex(document.getElementById("bookmarksTree").currentIndex);			
			var childrenArr 	= dengGB.getRecursiveChildrenFromFolder(currItem.id.substr("folder_".length));
			
			var msg				= document.getElementById("dengGB.strings").getString("dengGB.RemoveFolderConfirm");
			
			msg = msg.replace(/~foldername~/, currItem.id.substr("folder_".length));
			msg = msg.replace(/~numBookmarks~/, childrenArr.length);
			
			var result = this.promptService.confirm(window, document.getElementById("dengGB.strings").getString("dengGB.RemoveFolder"), msg);
			
			if (result) {
				// Eliminamos los marcadores
				for (var i = 0; i < childrenArr.length; i++) 
					dengGB.removeBookmark(event, childrenArr[i].getElementsByTagName("id")[0].childNodes[0].nodeValue, false, false);
				
				// Volvemos a pedir los marcadores a Google
				dengGB.requestBookmarks();
				
				// Eliminamos esta subcarpeta de pantalla: por algn motivo funciona pero arroja una excepcin (?!@#)
				try {
					// Ponemos el foco en el elemento anterior
					document.getElementById("bookmarksTree").currentIndex = document.getElementById("bookmarksTree").currentIndex - 1;
					// Eliminamos el elemento
					currItem.parentNode.removeChild(currItem);
				}
				catch (ex) {}
			}
		}
		catch (ex) {
			dengGB.dumpDebug("doRemoveFolderFromTree", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	doEditFolderFromTree: function(event) {
		try {
			// Sorprendentemente aun cuando el botn est inhibido se recibe la pulsacin del botn
			if (document.getElementById("editFolderBtn").getAttribute("disabled") == "true") return;
				
			var defaultBookmarksSep = dengGB.getBookmarksLevelSeparator();
			
			// Cambiamos el nombre de la subcarpeta
			var currItem 		= document.getElementById("bookmarksTree").view.getItemAtIndex(document.getElementById("bookmarksTree").currentIndex);
			var treecell1 		= document.getElementById("treecell1_" + currItem.id.substr("folder_".length));
			var orgLabelValue 	= treecell1.getAttribute("label").substr(1);
			var regExpr			= new RegExp(orgLabelValue);
			
			var input = {value: orgLabelValue};
			var check = {value: false};
			var result;
			
			while (true) {
				var result = this.promptService.prompt(window, 
														document.getElementById("dengGB.strings").getString("dengGB.EditTag"), 
														document.getElementById("dengGB.strings").getString("dengGB.ChangeTagValue"), 
														input, 
														"", 
														check);
													
				if (result && input.value.indexOf(defaultBookmarksSep) != -1)
					dengGB.dumpDebug(document.getElementById("dengGB.strings").getString("dengGB.NewTag"), 
									 document.getElementById("dengGB.strings").getString("dengGB.NewTagError"));
				else
					break;
			}
				
			if (result) {
				var childrenArr = dengGB.getRecursiveChildrenFromFolder(currItem.id.substr("folder_".length));
				var msg 		= document.getElementById("dengGB.strings").getString("dengGB.editsubFolderConfirm");
				
				msg = msg.replace(/~foldername~/, orgLabelValue);
				msg = msg.replace(/~numBookmarks~/, childrenArr.length);
				
				var result = this.promptService.confirm(window, document.getElementById("dengGB.strings").getString("dengGB.RemoveFolder"), msg);
				
				if (result) {
					// Eliminamos los marcadores
					for (var i = 0; i < childrenArr.length; i++) {
						var tag = "";
						var ds 	= childrenArr[i].getElementsByTagName("title")[0].childNodes[0].nodeValue;
						var url = childrenArr[i].getElementsByTagName("url")[0].childNodes[0].nodeValue;
						
						// Buscamos la etiqueta a cambiar
						var labelsArr = childrenArr[i].getElementsByTagName("label");
						
						for (var j = 0; j < labelsArr.length; j++) {
							if (labelsArr[j].childNodes[0].nodeValue.indexOf(orgLabelValue) != -1) {
								tag = new String(labelsArr[j].childNodes[0].nodeValue);
								tag = tag.replace(regExpr, input.value);
								break;
							}
						}
						if (tag == "") {
							dengGB.dumpDebug("doEditFolderFromTree", "Error: hay un marcador perdido: " + ds);
							continue;
						}
						
						// Eliminamos el marcador
						dengGB.removeBookmark(event, childrenArr[i].getElementsByTagName("id")[0].childNodes[0].nodeValue, false, false);

						// Insertamos el marcador con la nueva etiqueta usando una llamada asncrona
						dengGB.overrideUserAgent();
						
						var httpRequest = new XMLHttpRequest();
						
						// Creamos una funcin asincrona
						httpRequest.onreadystatechange = function() {
							if (httpRequest.status == 200) dengGB.restoreUserAgent();
						}
						
						httpRequest.open("POST", "http://www.google.com/bookmarks/mark", false); 
						httpRequest.send('q=' + escape(url) + '&title=' + encodeURI(ds) + '&labels=' + encodeURI(tag));
					}
					
					// Volvemos a pedir los marcadores a Google
					dengGB.requestBookmarks();
					
					// Actualizamos esta subcarpeta de pantalla: por algn motivo funciona pero arroja una excepcin (?!@#)
					var treeitem 	= currItem;
					var treerow 	= document.getElementById("treerow_" + currItem.id.substr("folder_".length));
					var treecell1 	= document.getElementById("treecell1_" + currItem.id.substr("folder_".length));
					var treecell2 	= document.getElementById("treecell2_" + currItem.id.substr("folder_".length));
					
					var tmpId = currItem.id.substr("folder_".length)
					var newId = (tmpId == orgLabelValue) ? input.value : tmpId.replace(regExpr, input.value);
					
					treeitem.setAttribute("id", "folder_" + newId);
					treerow.setAttribute("id", "treerow_" + newId);
					treecell1.setAttribute("id", "treecell1_" + newId);
					treecell1.setAttribute("label", " " + input.value); 
					treecell2.setAttribute("id", "treecell2_" + newId);
				}
			}
		}
		catch (ex) {
			dengGB.dumpDebug("doEditFolderFromTree", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	doRemoveBookmarkFromTree: function(event) {
		// Sorprendentemente aun cuando el botn est inhibido se recibe la pulsacin del botn
		if (document.getElementById("removeBookmarkBtn").getAttribute("disabled") == "true") 
			return;
			
		var currItem = document.getElementById("bookmarksTree").view.getItemAtIndex(document.getElementById("bookmarksTree").currentIndex);			
		
		// Eliminamos esta subcarpeta de pantalla: por algn motivo funciona pero arroja una excepcin (?!@#)
		try {
			// Ponemos el foco en el elemento anterior
			document.getElementById("bookmarksTree").currentIndex = document.getElementById("bookmarksTree").currentIndex - 1;
			// Eliminamos el marcador
			dengGB.removeBookmark(event, currItem.id, true, false);
			// Eliminamos el elemento
			currItem.parentNode.removeChild(currItem);
			// Volvemos a pedir los marcadores a Google
			dengGB.requestBookmarks();
		}
		catch (ex) {}
		
	},
	// Devuelve el elemento del arbol que marca 'event'
	getCurrentTreeItem: function(event) {
		try {
			if (!event.clientX) return null;
		
			var row = {}, col = {}, obj = {};
			var bookmarksTree = document.getElementById("bookmarksTree");
			
			bookmarksTree.treeBoxObject.getCellAt(event.clientX, event.clientY, row, col, obj);
			
			return (row.value == -1) ? document.getElementById("dengGBRoot") : bookmarksTree.view.getItemAtIndex(row.value);
		}
		catch (ex) {
			dengGB.dumpDebug("getCurrentTreeItem", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
			return null;
		}
	},
	manageToolbar: function(treeItem) {
		// En contra de lo que dice la documentacin no basta solo con poner el atributo 'disabled' a true o false (?)
		if (treeItem.id == "dengGBRoot") {
			document.getElementById("addFolderBtn").setAttribute("disabled", "false");
			document.getElementById("addFolderBtn").setAttribute("image", "chrome://dengGB/skin/addFolder.png");
			
			document.getElementById("removeFolderBtn").setAttribute("disabled", "true");
			document.getElementById("removeFolderBtn").setAttribute("image", "chrome://dengGB/skin/removeFolderDisabled.png");
			
			document.getElementById("editFolderBtn").setAttribute("disabled", "true");
			document.getElementById("editFolderBtn").setAttribute("image", "chrome://dengGB/skin/editFolderDisabled.png");
			
			document.getElementById("removeBookmarkBtn").setAttribute("disabled", "true");
			document.getElementById("removeBookmarkBtn").setAttribute("image", "chrome://dengGB/skin/removeBookmarkDisabled.png");
		}
		else if (treeItem.id.indexOf("folder_") == 0) {
			document.getElementById("addFolderBtn").setAttribute("disabled", "false");
			document.getElementById("addFolderBtn").setAttribute("image", "chrome://dengGB/skin/addFolder.png");
			
			document.getElementById("removeFolderBtn").setAttribute("disabled", "false");
			document.getElementById("removeFolderBtn").setAttribute("image", "chrome://dengGB/skin/removeFolder.png");
			
			document.getElementById("editFolderBtn").setAttribute("disabled", "false");
			document.getElementById("editFolderBtn").setAttribute("image", "chrome://dengGB/skin/editFolder.png");
			
			document.getElementById("removeBookmarkBtn").setAttribute("disabled", "true");
			document.getElementById("removeBookmarkBtn").setAttribute("image", "chrome://dengGB/skin/removeBookmarkDisabled.png");
		}
		else {
			document.getElementById("addFolderBtn").setAttribute("disabled", "true");
			document.getElementById("addFolderBtn").setAttribute("image", "chrome://dengGB/skin/addFolderDisabled.png");
			
			document.getElementById("removeFolderBtn").setAttribute("disabled", "true");
			document.getElementById("removeFolderBtn").setAttribute("image", "chrome://dengGB/skin/removeFolderDisabled.png");
			
			document.getElementById("editFolderBtn").setAttribute("disabled", "true");
			document.getElementById("editFolderBtn").setAttribute("image", "chrome://dengGB/skin/editFolderDisabled.png");
			
			document.getElementById("removeBookmarkBtn").setAttribute("disabled", "false");
			document.getElementById("removeBookmarkBtn").setAttribute("image", "chrome://dengGB/skin/removeBookmark.png");
		}
	},
	// Gestin de la seleccin del arbol de marcadores
	doBookmarkTreeSelect: function(event) {
		try {
			dengGB.manageToolbar(document.getElementById("bookmarksTree").view.getItemAtIndex(document.getElementById("bookmarksTree").currentIndex));
		}
		catch (ex) {
			dengGB.dumpDebug("doBookmarkTreeSelect", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	// Gestin del doble click del arbol de marcadores
	doBookmarkTreeDblclick: function(event) {
		try {
			var clickedTreeItem = dengGB.getCurrentTreeItem(event);
			
			clickedTreeItem.collapsed = clickedTreeItem.collapsed ? false : true;
			
			if (!clickedTreeItem.collapsed) 
				dengGB.expandTreeItem(clickedTreeItem);
			else 
				dengGB.collapseTreeItem(clickedTreeItem);
		}
		catch (ex) {
			//dengGB.dumpDebug("doBookmarkTreeDblclick", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	// Gestin del click del arbol de marcadores
	doBookmarkTreeClick: function(event) {
		// event.button: 0 izq, 1 central, 2 derecho
		if (event.button == 0) {
			var row = {}, col = {}, obj = {};
			var bookmarksTree = document.getElementById("bookmarksTree");
			
			bookmarksTree.treeBoxObject.getCellAt(event.clientX, event.clientY, row, col, obj);
			
			var clickedTreeItem = bookmarksTree.view.getItemAtIndex(row.value);
			
			if (obj.value && obj.value == "twisty") {
				clickedTreeItem.collapsed = clickedTreeItem.collapsed ? false : true;
				
				if (!clickedTreeItem.collapsed) 
					dengGB.expandTreeItem(clickedTreeItem);
				else
					dengGB.collapseTreeItem(clickedTreeItem);
			}
		}
	},
	// Cambiamos el icono de la carpeta que se cierra
	collapseTreeItem: function(treeItem) {
		try {
			if (treeItem.id == "dengGBRoot") return; // Si es el raiz me voy

			var currTreeItemId = treeItem.id.substr("folder_".length);	// El id de una carpeta empieza por "folder_"
			
			document.getElementById("treecell1_" + currTreeItemId).setAttribute("src", "chrome://dengGB/skin/closeFolder.gif");
		}
		catch (ex) {
			//dengGB.dumpDebug("collapseTreeItem", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	getBookmarksFromFullPath: function (parentItemFullPath, subfoldersArr, childrenArr) {
		try {
			// Buscamos los bookmarks que tengan esta etiqueta
			var bookmarks = dengGB.m_response.getElementsByTagName("bookmark");
			var defaultBookmarksSep = dengGB.getBookmarksLevelSeparator();
			
			for (var j = 0; j < bookmarks.length; j++) {
				var bookmarkLabels = bookmarks[j].getElementsByTagName("label");
				
				for (var k = 0; k < bookmarkLabels.length; k++) {
					if (bookmarkLabels[k].childNodes[0].nodeValue == parentItemFullPath) 
						childrenArr.push(bookmarks[j]);
					else if (bookmarkLabels[k].childNodes[0].nodeValue.indexOf(parentItemFullPath) != -1) {
						var tempArr = bookmarkLabels[k].childNodes[0].nodeValue.split(defaultBookmarksSep);
						var path = "";
						
						for (var i = 0; i < tempArr.length; i++) {
							path += tempArr[i];
							if (path == parentItemFullPath) {
								if (i + 1 < tempArr.length) {
									// Solo la aadimos si no la tenemos ya
									var subfoldersArrJoin = subfoldersArr.join();
									if (subfoldersArrJoin.indexOf(path + defaultBookmarksSep + tempArr[i + 1]) == -1) {
										path += defaultBookmarksSep + tempArr[i + 1];
										subfoldersArr.push(path);
									}
								}
								break;								
							}
							path += defaultBookmarksSep;
						}
					}
				}
			}
			subfoldersArr.sort();
			childrenArr.sort(dengGB.sortBookmarks);
		}
		catch (ex) {
			dengGB.dumpDebug("getBookmarksFromFullPath", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	// Insertamos los hijos de este treeItem
	expandTreeItem: function(treeItem) {
		try {
			if (treeItem.id == "dengGBRoot") return; // Si es el raiz me voy
				
			// Cambiamos el icono
			var itemId = treeItem.id.substr("folder_".length); // El id de una carpeta empieza por "folder_"
			var defaultBookmarksSep = dengGB.getBookmarksLevelSeparator();
			
			document.getElementById("treecell1_" + itemId).setAttribute("src", "chrome://dengGB/skin/openFolder.gif");
			
			var treeChildrenNodes = treeItem.getElementsByTagName("treechildren");
			
			if (treeChildrenNodes.length) return;
			
			// Buscamos todos los marcadores que tengan esta etiqueta: si no tienen url son padres
			var subfolders = new Array();
			var children = new Array();
			
			dengGB.getBookmarksFromFullPath(treeItem.id.substr("folder_".length), subfolders, children);
			
			var treeChildren = document.createElement("treechildren");

			// Primero aadimos las subcarpetas
			for (var i = 0; i < subfolders.length; i++) {
				dengGB.insertBookmarksTreeElement(treeChildren, 																// padre
													subfolders[i],																// id													
													subfolders[i].substr(subfolders[i].lastIndexOf(defaultBookmarksSep) + 1),	// label 
													"", 																		// url
													"chrome://dengGB/skin/closeFolder.gif", 									// icono
													true,																		// es padre
													null);																		// insertBefore	
			}
			
			// Ahora los marcadores de esta carpeta
			for (i = 0; i < children.length; i++) {
				dengGB.insertBookmarksTreeElement(treeChildren, 															// padre
													children[i].getElementsByTagName("id")[0].childNodes[0].nodeValue, 		// id													
													children[i].getElementsByTagName("title")[0].childNodes[0].nodeValue,	// label 
													children[i].getElementsByTagName("url")[0].childNodes[0].nodeValue, 	// url
													"chrome://dengGB/skin/bookmark.png", 									// icono
													false,																	// es padre
													null);																	// insertBefore	
			}
			treeChildren.setAttribute("open", "true");
			treeItem.setAttribute("open","true");
			treeItem.appendChild(treeChildren);
		}
		catch (ex) {
			//dengGB.dumpDebug("expandTreeItem", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	// Metodo para aadir un elemento al arbol de marcadores
	insertBookmarksTreeElement: function(parent, id, text1, text2, icon, container, _insertbefore) {
		try {
			var folderTreeitem 	= document.createElement('treeitem');
			var folderTreeRow 	= document.createElement("treerow");
			var folderTreeCell1 = document.createElement("treecell");
			var folderTreeCell2 = document.createElement("treecell");
			var strId = id;
			
			with (folderTreeitem) {
				setAttribute("id", container ? ("folder_" + strId) : strId);
				setAttribute("label", text1);
				setAttribute("container", container ? true : false);
				setAttribute("collapsed", "true");
				setAttribute("allowevents", "true");
			}
			
			folderTreeRow.setAttribute("id", "treerow_" + strId);
			
			folderTreeCell1.setAttribute("id", "treecell1_" + strId);
			folderTreeCell1.setAttribute("label", " " + text1);
			folderTreeCell1.setAttribute("src", icon);
				
			folderTreeCell2.setAttribute("id", "treecell2_" + strId);
			folderTreeCell2.setAttribute("label", text2);
			
			// Por ltimo aadimos
			folderTreeRow.appendChild(folderTreeCell1);
			folderTreeRow.appendChild(folderTreeCell2);
			folderTreeitem.appendChild(folderTreeRow);
			
			if (_insertbefore == null)
				parent.appendChild(folderTreeitem);
			else
				parent.insertBefore(folderTreeitem, _insertbefore);
			
			if (!container) dengGB.getFavicon(folderTreeCell1, text2, "src");
				
			return folderTreeitem;
		}
		catch (ex) {
			dengGB.dumpDebug("insertBookmarksTreeElement", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
			return null;
		}
	},
	// Editar marcadores usando el dialogo de alta
	onLocalManageBookmarks: function(e) {
		try {
			var retVals = { choice: "manage", tag : "manage" };
		
			window.openDialog("chrome://dengGB/content/addBookmark.xul", "", "modal,centerscreen,chrome,resizable=yes", 
								null, null, dengGB.m_labelsArr, retVals, dengGB.m_response);
								
			// refrescamos nuestros marcadores
			dengGB.refreshBookmarks(e);
		}
		catch (ex) {
			dengGB.dumpDebug("onLocalManageBookmarks", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	// Inicializamos el dialogo de aadir marcador
	doAddBookmarkStartup: function () {
		try {
			var defaultBookmarksSep = dengGB.getBookmarksLevelSeparator();
		
			if (window.arguments[0] != null && window.arguments[1] != null) {
				document.getElementById("bookmarkDs").value = window.arguments[0];
				document.getElementById("bookmarkUrl").value = window.arguments[1];
			}
			else {
				document.getElementById("dsBox").hidden = true;
				document.getElementById("urlBox").hidden = true;
			}
			
			var labelsArr = window.arguments[2];
			var tag = window.arguments[3].tag;
			var choice = window.arguments[3].choice;
			var rootTreeChildren = document.getElementById("rootTreeChildren");

			var tagArr = null;
			var expandItemsRoot;
			var showTreeExpanded = false;
			
			// Si en tag viene un array lo tratamos
			if (tag.indexOf(defaultBookmarksSep) != -1) {
				showTreeExpanded = true;
				tagArr = tag.split(defaultBookmarksSep);
			}

			var retVals = window.arguments[3];
				
			// Cambiamos el ttulo de la ventana
			if (tag == "manage" && choice == "manage") {
				document.getElementById("mainTitle").setAttribute("title", document.getElementById("dengGB.strings").getString("dengGB.LocalManageBookmarks"));
				
				// Ocultamos el botn de aceptar
				document.documentElement.getButton("accept").hidden = true;
				
				// Cambiamos el texto del botn de cancelar
				document.documentElement.getButton("cancel").label = document.getElementById("dengGB.strings").getString("dengGB.EXit");
			}
			else if (tag != "" || retVals.id != "") 
				document.getElementById("mainTitle").setAttribute("title", document.getElementById("dengGB.strings").getString("dengGB.EditBookmark"));
				
			// Asignamos el documento XML que devuelve Google con los marcadores
			dengGB.m_response = window.arguments[4];
			
			if (labelsArr != null) {
				for (var i = 0; i < labelsArr.length; i++) {
				
					// Aadimos un elemento al arbol por cada etiqueta
					var tempItem = dengGB.insertBookmarksTreeElement(rootTreeChildren, 							// padre
																	labelsArr[i], 								// id
																	labelsArr[i], "", 							// label, url
																	"chrome://dengGB/skin/closeFolder.gif", 	// icono
																	true, 										// es padre
																	null);
					if (showTreeExpanded && tagArr.length > 1 && tagArr[0] == labelsArr[i]) {
						expandItemsRoot = tempItem; // Aadimos este treeitem a nuestro array de elementos a expandir
					}
				}
			}
				
			// Insertamos los elementos sin etiqueta
			var bookmarks = dengGB.m_response.getElementsByTagName("bookmark");
			
			if (bookmarks.length) {
				var noTagBookmarks = new Array(bookmarks.length);
				var numNoTagBookmarks = 0;
					
				for (i = 0; i < bookmarks.length; i++) {
					if (bookmarks[i].getElementsByTagName("labels").length) continue;
					
					noTagBookmarks[numNoTagBookmarks] = new Array(3);
					
					noTagBookmarks[numNoTagBookmarks][0] = bookmarks[i].getElementsByTagName("title")[0].childNodes[0].nodeValue;
					noTagBookmarks[numNoTagBookmarks][1] = bookmarks[i].getElementsByTagName("id")[0].childNodes[0].nodeValue;
					noTagBookmarks[numNoTagBookmarks][2] = bookmarks[i].getElementsByTagName("url")[0].childNodes[0].nodeValue;
					
					numNoTagBookmarks++;
				}
					
				// Ordenamos el array
				noTagBookmarks.sort();
					
				for (i = 0; i < numNoTagBookmarks; i++) {
					dengGB.insertBookmarksTreeElement(rootTreeChildren, 
														noTagBookmarks[i][1], 								// id													
														noTagBookmarks[i][0], noTagBookmarks[i][2], 		// label, url
														"chrome://dengGB/skin/bookmark.png", 				// icono
														false,												// es padre
														null);
				}
			}
				
			// Por ltimo seleccionamos el elemento del arbol padre de nuestro marcador
			var bookmarksTree = document.getElementById("bookmarksTree");
			
			if ((tag == "manage" && choice == "manage") || tag == "") {
				bookmarksTree.view.selection.select(0);
				dengGB.manageToolbar(bookmarksTree.view.getItemAtIndex(0));
			}
			else {
				// Si estamos en un arbol expandido lo tratamos primero
				if (showTreeExpanded && expandItemsRoot) {
					dengGB.expandTreeItem(expandItemsRoot);
						
					var tempItemId = expandItemsRoot.id;
					
					for (var i = 1; i < tagArr.length; i++) {
						// Buscamos los 'treeitem' hijos de expandItemsRoot
						var childTreeitemArr = expandItemsRoot.getElementsByTagName("treeitem");
						
						expandItemsRoot = null;
						tempItemId += defaultBookmarksSep + tagArr[i];
						for (var j = 0; j < childTreeitemArr.length; j++) {
							if (childTreeitemArr[j].id == tempItemId) {
								dengGB.expandTreeItem(expandItemsRoot = childTreeitemArr[j]);
								break;
							}
						}
						if (expandItemsRoot == null) break;
					}
					// Por ltimo ponemos la seleccin en el ltimo elemento
					tag = "folder_" + tag;
				}
					
				// Aqu buscamos la seleccin
				for (var i = 1; i < bookmarksTree.view.rowCount; i++) {
					var treeItem = bookmarksTree.view.getItemAtIndex(i);
						
					if (treeItem.id == tag || treeItem.id.substr("folder_".length) == tag) {
						bookmarksTree.view.selection.select(i);
						dengGB.manageToolbar(treeItem);
					}
				}
			}
		}
		catch(ex) {
			dengGB.dumpDebug("doAddBookmarkStartup", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	// Se acept el dialogo de aadir marcador
	doAddBookmarkAccept: function (e) {
		var retVals = window.arguments[3];
		
		// Validaciones
		if (document.getElementById("bookmarkDs").value == "") {
			dengGB.dumpDebug(document.getElementById("dengGB.strings").getString("dengGB.AddAsBookmark"), 
							 document.getElementById("dengGB.strings").getString("dengGB.AddAsBookmark.NoDs"));
			document.getElementById("bookmarkDs").focus();
			return false;
		}
			
		if (document.getElementById("bookmarkUrl").value == "") {
			dengGB.dumpDebug(document.getElementById("dengGB.strings").getString("dengGB.AddAsBookmark"), 
							 document.getElementById("dengGB.strings").getString("dengGB.AddAsBookmark.NoUrl"));
			document.getElementById("bookmarkUrl").focus();
			return false;
		}
			
		id = document.getElementById("bookmarksTree").view.getItemAtIndex(document.getElementById("bookmarksTree").	currentIndex).id;
			
		if (id.indexOf("folder_") != 0 && id != "dengGBRoot") {
			dengGB.dumpDebug(document.getElementById("dengGB.strings").getString("dengGB.AddAsBookmark"), 
							 document.getElementById("dengGB.strings").getString("dengGB.AddAsBookmark.BadParentFolder"));
			document.getElementById("bookmarkUrl").focus();
			return false;
		}
		
		// Aceptamos el dilogo	
		retVals.choice = "accept";
		retVals.ds = document.getElementById("bookmarkDs").value;
		retVals.url = document.getElementById("bookmarkUrl").value;
		retVals.tag = (id == "dengGBRoot") ? "" : id.substr("folder_".length); // El id de una carpeta empieza por "folder_"
		
		// Procesamos el nuevo bookmark
		try {
			// Hay que eliminar el marcador anterior?
			if (retVals.id != "") dengGB.removeBookmark(e, retVals.id, false, false); 
			
			dengGB.updateStatusPanel(document.getElementById("dengGB.strings").getString("dengGB.RequestAddBookmark"));
			dengGB.setWaitCursor(true);
			
			dengGB.overrideUserAgent();

			// Insertamos el nuevo marcador usando una llamada asncrona
			var httpRequest = new XMLHttpRequest();
			
			// Creamos una funcin asincrona
			httpRequest.onreadystatechange = function() {
				if (httpRequest.status == 200) {
					dengGB.updateStatusPanel(document.getElementById("dengGB.strings").getString("dengGB.BookmarkAdded"));
					dengGB.setWaitCursor(false);
					
					// refrescamos nuestros marcadores
					retVals.mainObj.refreshBookmarks(e);
					
					dengGB.restoreUserAgent();
				}
			}

			httpRequest.open("POST", "http://www.google.com/bookmarks/mark", false); 
			httpRequest.send('q=' + escape(retVals.url) + '&title=' + encodeURI(retVals.ds) + '&labels=' + encodeURI(retVals.tag));
		}
		catch (ex) {
			dengGB.dumpDebug("doAddBookmarkAccept", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
		return true;
	},
	getBookmarkFromId: function(bS) {
		try {
			var bookmarks = dengGB.m_response.getElementsByTagName("bookmark");
			
			for (var i = 0; i < bookmarks.length; i++) {
				if (bookmarks[i].getElementsByTagName("id")[0].childNodes[0].nodeValue == bS.id) {
					bS.label = bookmarks[i].getElementsByTagName("title")[0].childNodes[0].nodeValue;
					bS.url = bookmarks[i].getElementsByTagName("url")[0].childNodes[0].nodeValue;
					
					if (bookmarks[i].getElementsByTagName("label")[0]) {
						var strTemp = bookmarks[i].getElementsByTagName("label")[0].childNodes[0].nodeValue;
						
						bS.tag = (strTemp.indexOf("^") == 0) ? "" : strTemp;
					}
					else 
						bS.tag = "";
					break;
				}
			}
		}
		catch (ex) {
			dengGB.dumpDebug("getBookmarkFromId", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
	},
	// Eliminar marcadores
	// Unbookmark: http://www.google.com/bookmarks/mark?dlq={IDENTIFICADOR}&sig={KEY}
	removeBookmark: function (e, _id, askFirst, refresh) {
		try {
			// Pedimos confirmacin
			if (askFirst) {
				var bS = { id: _id, label: "", url: "", tag: "" };
				
				dengGB.getBookmarkFromId(bS);
				
				var result = this.promptService.confirm(window, 
					document.getElementById("dengGB.strings").getString("dengGB.RemoveAsBookmark"), 
					document.getElementById("dengGB.strings").getString("dengGB.RemoveBookmarkConfirm") + " '" + bS.label + "'?");
					
				if (!result) return;
			}
		}
		catch (ex) {
			dengGB.dumpDebug("[0] removeBookmark", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
			
		if (document.getElementById("dengGBToolbarButton")) document.getElementById("dengGBToolbarButton").image = "chrome://dengGB/skin/refresh.png";
		try {
			// Eliminamos el marcador
			dengGB.updateStatusPanel(document.getElementById("dengGB.strings").getString("dengGB.RequestRemoveBookmark"));
			
			dengGB.overrideUserAgent();
				
			var httpRequest = new XMLHttpRequest();
			
			// Creamos una funcin asincrona
			httpRequest.onreadystatechange = function() {
				if (httpRequest.status == 200) {
					dengGB.restoreUserAgent();
					
					dengGB.updateStatusPanel(document.getElementById("dengGB.strings").getString("dengGB.BookmarkRemoved"));
					// No refrescamos nuestros marcadores si venimos de 'editBookmark'
					if (refresh) dengGB.refreshBookmarks(e);
				}
			}
			
			httpRequest.open("POST", "http://www.google.com/bookmarks/mark", false); 
			httpRequest.send('dlq=' + escape(_id)); 
		}
		catch (ex) {
			dengGB.dumpDebug("removeBookmark", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
		if (document.getElementById("dengGBToolbarButton")) document.getElementById("dengGBToolbarButton").image = "chrome://dengGB/skin/dengGB.png";
	},
	// Pedimos los bookmarks a Google
	getBookmarksFromGoogleAndCreateMenu: function() {
		document.getElementById("dengGBToolbarButton").image = "chrome://dengGB/skin/refresh.png";
		try {
			var dengGBMainMenuPopup = document.getElementById('dengGBMainMenuPopup');
			var dengGBSeparator = document.getElementById('separatorAbout');
			var tempStr = "";
			var defaultBookmarksSep = dengGB.getBookmarksLevelSeparator();
			
			// Lanzamos la peticin de los marcadores		
			dengGB.requestBookmarks();
				
			// Primero buscamos cuantas etiquetas distintas hay. Eliminamos las que empiezan por ^
			var labels = dengGB.m_response.getElementsByTagName("label");
			var bookmarks = dengGB.m_response.getElementsByTagName("bookmark");
			var strLabels = dengGB.defaultSep;
				
			// Si no hay ni una sola etiqueta es porque no hay marcadores definidos: nos vamos
			if (!labels.length && !bookmarks.length) return;
				
			// Aadimos un separador
			var firstSeparator = document.createElement("menuseparator");
			
			firstSeparator.setAttribute("id", "firstSeparator");
			dengGBMainMenuPopup.insertBefore(firstSeparator, dengGBSeparator);
				
			for (i = 0; i < labels.length; i++) {
				var nodeValue = labels[i].childNodes[0].nodeValue;
				
				// Si es una etiqueta anidada, solo cojemos la primera parte
				if (nodeValue.indexOf(defaultBookmarksSep) != -1) nodeValue = nodeValue.substr(0, nodeValue.indexOf(defaultBookmarksSep));
					
				// Si no tenemos esta etiqueta ya la aadimos
				if (nodeValue.indexOf("^") != 0  && strLabels.indexOf(dengGB.defaultSep + nodeValue + dengGB.defaultSep) == -1) 
					strLabels += (nodeValue + dengGB.defaultSep);
			}
				
			strLabels = strLabels.substr(dengGB.defaultSep.length, strLabels.length - (2*dengGB.defaultSep.length));
				
			if (strLabels.length) {
				// Creamos un array de etiquetas distintas
				dengGB.m_labelsArr = strLabels.split(dengGB.defaultSep);
				
				// Ordenamos el array
				dengGB.m_labelsArr.sort();
				
				for (i = 0; i < dengGB.m_labelsArr.length; i++) {
					// Creamos un menupopup
					var tempMenupopup = document.createElement('menupopup');
					
					with (tempMenupopup) {	
						setAttribute('id', "folderpopup_" + dengGB.m_labelsArr[i]);
						setAttribute('onpopupshowing', 'return dengGB.popupPopulate(event, "' + dengGB.m_labelsArr[i] + '");');
						setAttribute('onpopuphiding', 'return dengGB.popupHide(event, "' + dengGB.m_labelsArr[i] + '");');
					}
					
					// Creamos un menu para cada carpeta
					var tempMenu = document.createElement("menu");
					
					with (tempMenu) {	
						setAttribute("id", "folderMenu_" + dengGB.m_labelsArr[i]);
						setAttribute("class", "menu-iconic");
						setAttribute("image", "chrome://dengGB/skin/closeFolder.gif");
						setAttribute("label", dengGB.m_labelsArr[i]);
						setAttribute("tooltiptext", dengGB.m_labelsArr[i]);
						setAttribute("container", "true");
					}
					
					// Aadimos el popup
					tempMenu.appendChild(tempMenupopup);
					
					// Insertamos el menu de carpeta
					dengGBMainMenuPopup.insertBefore(tempMenu, dengGBSeparator);
				}
			}
				
			// Insertamos ahora los elementos sin etiqueta
			if (bookmarks.length) {
				var noTagBookmarks = new Array(bookmarks.length);
				var numNoTagBookmarks = 0;
				
				for (i = 0; i < bookmarks.length; i++) {
					if (bookmarks[i].getElementsByTagName("labels").length) continue;
					
					noTagBookmarks[numNoTagBookmarks] = new Array(3);
					
					noTagBookmarks[numNoTagBookmarks][0] = bookmarks[i].getElementsByTagName("title")[0].childNodes[0].nodeValue;
					noTagBookmarks[numNoTagBookmarks][1] = bookmarks[i].getElementsByTagName("id")[0].childNodes[0].nodeValue;
					noTagBookmarks[numNoTagBookmarks][2] = bookmarks[i].getElementsByTagName("url")[0].childNodes[0].nodeValue;
					
					numNoTagBookmarks++;
				}
				
				// Ordenamos el array
				noTagBookmarks.sort();
				
				for (i = 0; i < numNoTagBookmarks; i++) {
					var mItem = document.createElement("menuitem");
					with (mItem) {
						setAttribute("label", noTagBookmarks[i][0]);
						setAttribute("id", noTagBookmarks[i][1]);
						setAttribute("noTagBookmark", "1");
						setAttribute("url", noTagBookmarks[i][2]);
						setAttribute("tooltiptext", noTagBookmarks[i][2]);
						setAttribute("class", "menuitem-iconic");
						setAttribute("image", "chrome://dengGB/skin/bookmark.png");
						setAttribute("oncommand", "dengGB.onItemCommand(event)");
						setAttribute("oncontextmenu", "dengGB.onBookmarkContextMenu(event, '" + noTagBookmarks[i][1] + "'); return false;");
					}
					dengGB.getFavicon(dengGBMainMenuPopup.insertBefore(mItem, dengGBSeparator), noTagBookmarks[i][2], "image");
				}
			}
		}
		catch (e) {
			dengGB.dumpDebug("getBookmarksFromGoogleAndCreateMenu", document.getElementById("dengGB.strings").getString("dengGB.RetrieveBookmarksGeneralError") + e);
		}
		document.getElementById("dengGBToolbarButton").image = "chrome://dengGB/skin/denggb.png";
	},
	removeMenuItems: function() {
		try {
			var dengGBMainMenuPopup = document.getElementById("dengGBMainMenuPopup");
			
			// Borramos los elementos 'folderMenu_' y 'id_'
			var folders = document.getElementsByTagName("menu");
			var menuItems = document.getElementsByTagName("menuitem");
			
			for (i = 0; i < folders.length;) {
				if (!folders[i]) break;
				if (folders[i].getAttribute("id").indexOf("folderMenu_") != -1)
					dengGBMainMenuPopup.removeChild(folders[i]);
				else
					i++;
			}
			
			for (i = 0; i < menuItems.length;) {
				if (!menuItems[i]) break;
				if (menuItems[i].getAttribute("noTagBookmark") == "1")
					dengGBMainMenuPopup.removeChild(menuItems[i]);
				else
					i++;
			}
			
			// Eliminamos el elemento que permite gestionar bookmarks
			if (document.getElementById("googleManageBookmarks")) dengGBMainMenuPopup.removeChild(document.getElementById("googleManageBookmarks"));
			// Eliminamos el elemento que permite gestionar bookmarks localmente
			if (document.getElementById("localManageBookmarks")) dengGBMainMenuPopup.removeChild(document.getElementById("localManageBookmarks"));
			// Eliminamos el elemento de aadir / eliminar marcador
			if (document.getElementById("addBookmark")) dengGBMainMenuPopup.removeChild(document.getElementById("addBookmark"));
			if (document.getElementById("removeBookmark")) dengGBMainMenuPopup.removeChild(document.getElementById("removeBookmark"));
			// Eliminamos el elemento que permite refrescar
			if (document.getElementById("refreshBookmarks")) dengGBMainMenuPopup.removeChild(document.getElementById("refreshBookmarks"));
			// Eliminamos el primer separador
			if (document.getElementById("firstSeparator")) dengGBMainMenuPopup.removeChild(document.getElementById("firstSeparator"));
		}
		catch (e) {
			dengGB.dumpDebug("removeMenuItems", document.getElementById("dengGB.strings").getString("error") + e);
		}
	},
	// Actualizamos los bookmarks
	refreshBookmarks: function (e) {
		dengGB.updateStatusPanel(document.getElementById("dengGB.strings").getString("dengGB.RetrieveBookmarks"));
		try {
			dengGB.removeMenuItems();
			// Volvemos a solicitar los marcadores y a crear los menus
			dengGB.m_response = null;
			dengGB.onpopupshowing(e);
		}
		catch (ex) {
			dengGB.dumpDebug("refreshBookmarks", document.getElementById("dengGB.strings").getString("error") + ex);
		}
		dengGB.updateStatusPanel("");
	},
	// Ponemos el elemento para aadir o eliminar un marcador en funcin de la pgina que haya en pantalla
	addRemoveMenuItem: function() {
		try {
			var dengGBMainMenuPopup 	= document.getElementById('dengGBMainMenuPopup');
			var currUrl 				= window.top._content.location.href.toLowerCase();
			var currUrlIsInBookmarks 	= false;
			var currBookmarkId;
			
			var bookmarks = dengGB.m_response.getElementsByTagName("bookmark");
			
			for (i = 0; i < bookmarks.length; i++) {
				if (bookmarks[i].getElementsByTagName("url")[0].childNodes[0].nodeValue.toLowerCase() == currUrl) {
					currUrlIsInBookmarks = true;
					currBookmarkId = bookmarks[i].getElementsByTagName("id")[0].childNodes[0].nodeValue;
					break;
				}
			}
		
			var addBookmarkItem 	= document.getElementById("addBookmark");
			var removeBookmarkItem 	= document.getElementById("removeBookmark");
			
			if (currUrlIsInBookmarks && addBookmarkItem) return;	
			if (!currUrlIsInBookmarks && removeBookmarkItem) return;	

			if (addBookmarkItem)  dengGBMainMenuPopup.removeChild(addBookmarkItem);
			if (removeBookmarkItem)  dengGBMainMenuPopup.removeChild(removeBookmarkItem);
			
			var mItemCurrUrl = document.createElement("menuitem");
			with (mItemCurrUrl) {
				setAttribute('id', currUrlIsInBookmarks ? "addBookmark" : "removeBookmark");
				setAttribute('label', currUrlIsInBookmarks ? document.getElementById("dengGB.strings").getString("dengGB.RemoveAsBookmark") : document.getElementById("dengGB.strings").getString("dengGB.AddAsBookmark"));
				setAttribute("tooltiptext", currUrlIsInBookmarks ? document.getElementById("dengGB.strings").getString("dengGB.RemoveAsBookmark") : document.getElementById("dengGB.strings").getString("dengGB.AddAsBookmark.tooltiptext"));
				setAttribute('class', "menuitem-iconic");
				setAttribute('image', currUrlIsInBookmarks ? "chrome://dengGB/skin/removeBookmark.png" : "chrome://dengGB/skin/addBookmark.png");
				setAttribute('oncommand', currUrlIsInBookmarks ? "dengGB.removeBookmark(event, '" + currBookmarkId + "', true, true)" : "dengGB.openAddBookmarkDlg(event, null)");
			}
			dengGBMainMenuPopup.insertBefore(mItemCurrUrl, 
				document.getElementById("refreshBookmarks") ? document.getElementById("refreshBookmarks") : dengGBSeparator);
		}
		catch (ex) {
			dengGB.dumpDebug("addRemoveMenuItem", document.getElementById("dengGB.strings").getString("error") + ex);
		}
	},	
	// Mostrar el menu de dengGB
	onpopupshowing: function(e) {
		dengGB.getBookmarksLevelSeparator(); // Pedimos/establecemos el separador por defecto
		
		try {
			var dengGBMainMenuPopup = document.getElementById('dengGBMainMenuPopup');
			var dengGBSeparator 	= document.getElementById('separatorAbout');
			
			// Est conectado?
			if (dengGB.checkLogin()) {
				// Si el separador por defecto, o la opcin de mostrar iconos, ha cambiado volvemos a pedir el men
				if (dengGB.m_bookmarksUserDefinedSep != dengGB.getBookmarksLevelSeparator() ||
					dengGB.m_originalUserFavIconPref != dengGB.getFavIconsOption()
					) {
					dengGB.m_bookmarksUserDefinedSep = dengGB.getBookmarksLevelSeparator();
					dengGB.m_originalUserFavIconPref = dengGB.getFavIconsOption();
					
					dengGB.removeMenuItems();
					// Volvemos a solicitar los marcadores y a crear los menus
					dengGB.m_response = null;
				}
				
				// Si ya hemos creado el menu solo gestionamos el icono de aadir o eliminar marcador
				if (document.getElementById("googleManageBookmarks")) {
					dengGB.addRemoveMenuItem();
					return; 
				}
					
				// Si el menu de conectarse esta creado, lo eliminamos
				var googleConnect = document.getElementById('googleConnect');
					
				if (googleConnect) dengGBMainMenuPopup.removeChild(googleConnect);
					
				// Aadimos un menu para gestionar los marcadores
				var mItem = document.createElement("menuitem");
					
				with (mItem) {
					setAttribute("id", "googleManageBookmarks");
					setAttribute("class", "menuitem-iconic");
					setAttribute("image", "chrome://dengGB/skin/editBookmarks.gif");
					setAttribute("label", document.getElementById("dengGB.strings").getString("dengGB.ManageBookmarks"));
					setAttribute("tooltiptext", document.getElementById("dengGB.strings").getString("dengGB.ManageBookmarks.tooltiptext"));
					setAttribute("oncommand", "dengGB.onManageBookmarks(event);");
				}
					
				if (document.getElementById("addBookmark"))
					dengGBMainMenuPopup.insertBefore(mItem, document.getElementById("addBookmark"));
				else if (document.getElementById("removeBookmark"))
					dengGBMainMenuPopup.insertBefore(mItem, document.getElementById("removeBookmark"));
				else
					dengGBMainMenuPopup.insertBefore(mItem, dengGBSeparator);
					
				// Creamos una opcin de men para 'gestionar' los marcadores
				var mItemManage = document.createElement("menuitem");
					
				with (mItemManage) {
					setAttribute("id", "localManageBookmarks");
					setAttribute("class", "menuitem-iconic");
					setAttribute("image", "chrome://dengGB/skin/manageBookmarks.png");
					setAttribute("label", document.getElementById("dengGB.strings").getString("dengGB.LocalManageBookmarks"));
					setAttribute("tooltiptext", document.getElementById("dengGB.strings").getString("dengGB.LocalManageBookmarks.tooltiptext"));
					setAttribute("oncommand", "dengGB.onLocalManageBookmarks(event);");
				}
				dengGBMainMenuPopup.insertBefore(mItemManage, mItem);
					
				// Pedimos los bookmarks
				dengGB.updateStatusPanel(document.getElementById("dengGB.strings").getString("dengGB.RetrieveBookmarks"));
				dengGB.getBookmarksFromGoogleAndCreateMenu();
					
				// Aadimos la opcin de Refresh. Si ya existe lo eliminamos
				var refreshBookmarksItem = document.getElementById("refreshBookmarks");
					
				if (refreshBookmarksItem) dengGBMainMenuPopup.removeChild(refreshBookmarksItem);
					
				var mItemRefresh = document.createElement("menuitem");
				with (mItemRefresh) {
					setAttribute('id', "refreshBookmarks");
					setAttribute('label', document.getElementById("dengGB.strings").getString("dengGB.Refresh"));
					setAttribute("tooltiptext", document.getElementById("dengGB.strings").getString("dengGB.Refresh.tooltiptext"));
					setAttribute('class', "menuitem-iconic");
					setAttribute('image', "chrome://dengGB/skin/refresh.png");
					setAttribute('oncommand', "dengGB.refreshBookmarks(event)");
				}
				dengGBMainMenuPopup.insertBefore(mItemRefresh, 
					document.getElementById("firstSeparator") ? document.getElementById("firstSeparator") : dengGBSeparator);

				// Existe ya el elemento de aadir / eliminar?
				dengGB.addRemoveMenuItem();
			}
			else {
				// No estamos comectados a Google: aadimos un men para pedir usuario y contrasea
				dengGB.removeMenuItems(); // Primero eliminamos los menus si es que existen
				if (!document.getElementById("googleConnect")) { // Si est creado ya, nos vamos
					var mItem = document.createElement("menuitem");
					with (mItem) {
						setAttribute("id", "googleConnect");
						setAttribute("label", document.getElementById("dengGB.strings").getString("dengGB.Connect"));
						setAttribute("tooltiptext", document.getElementById("dengGB.strings").getString("dengGB.Connect.tooltiptext"));
						setAttribute("class", "menuitem-iconic");
						setAttribute("image", "chrome://dengGB/skin/connect.gif");
						setAttribute("oncommand", "dengGB.showLogin(event);");
					}
					document.getElementById("dengGBMainMenuPopup").insertBefore(mItem, document.getElementById("separatorAbout"));
				}
			}
		}
		catch(e) {
			dengGB.dumpDebug("onpopupshowing", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + e);
		}
		dengGB.updateStatusPanel("");
	},
	// Recuperamos el separador 
	getBookmarksLevelSeparator: function() {
		var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);	
		var sep;
		
		if (prefs.getPrefType("dengGB.bookmarkSeparator") == prefs.PREF_STRING)
			sep = prefs.getCharPref("dengGB.bookmarkSeparator");
		else {
			prefs.setCharPref("dengGB.bookmarkSeparator", "/");
			sep = "/"
		}
		return sep;
	},
	// Queremos recuperar los favicons?
	getFavIconsOption: function() {
		try {
			var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);	
			var value;
			
			if (prefs.getPrefType("dengGB.bookmarkShowIcon") == prefs.PREF_BOOL)
				value = prefs.getBoolPref("dengGB.bookmarkShowIcon");
			else {
				prefs.setBoolPref("dengGB.bookmarkShowIcon", false);
				value = false;
			}
			return value;
		}
		catch(e) {
			dengGB.dumpDebug("getFavIconsOption", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + e);
		}
		return false;
	},
	updateStatusPanel: function(msg) {
		if (document.getElementById("dengGBPanel")) document.getElementById("dengGBPanel").label = msg;
	},
	setWaitCursor: function(state) {
		try {
			if (state)
				setCursor("wait");
			else
				setCursor("default");
		}
		catch(e) {
			dengGB.dumpDebug("setWaitCursor", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + e);
		}
	},
	callPreferencesDialog: function() {
		window.openDialog("chrome://dengGB/content/options.xul", "", "centerscreen");
	},
	doPreferencesStartup: function() {
		try {
			document.getElementById("bookmarkSeparatorCtrlId").value = dengGB.getBookmarksLevelSeparator();
		}
		catch(e) {
			dengGB.dumpDebug("doPreferencesStartup", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + e);
		}
	},
	doPreferencesAccept: function(e) {
		try {
			if (document.getElementById("bookmarkSeparatorCtrlId").value == "" || document.getElementById("bookmarkSeparatorCtrlId").value.length != 1) {
				dengGB.dumpDebug(document.getElementById("dengGB.strings").getString("dengGB.rootName"), 
								document.getElementById("dengGB.strings").getString("options.bookmarkSeparatorLength")); 
				return false;
			}
			
			var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);	
			
			prefs.setCharPref("dengGB.bookmarkSeparator", document.getElementById("bookmarkSeparatorCtrlId").value);
			dengGB.removeMenuItems(); // Forzamos una reconstruccin del men la prxima vez
		}
		catch (ex) {
			dengGB.dumpDebug("doPreferencesAccept", document.getElementById("dengGB.strings").getString("dengGB.ExceptionError") + ex);
		}
		return true;
	},
	// Recuperar el icono por defecto de una url
	getFavicon: function(item, url, dstField) {
		try {
			if (dengGB.getFavIconsOption()) {
				var uriLink = Components.classes['@mozilla.org/network/standard-url;1'].createInstance(Components.interfaces.nsIURI);
				var imageUri = Components.classes['@mozilla.org/network/standard-url;1'].createInstance(Components.interfaces.nsIURI);
				
				uriLink.spec = url;
				imageUri.spec = uriLink.scheme + "://" + uriLink.host + "/favicon.ico";
				
				// Make a new nsIURIChecker
				var uriChecker = Components.classes["@mozilla.org/network/urichecker;1"]
									.createInstance().QueryInterface(Components.interfaces.nsIURIChecker);
				// uri creation needs to be localized
				uriChecker.init(imageUri);
				uriChecker.asyncCheck(new imageRequestObserver(item, dstField), null);
				
				item.setAttribute(dstField, uriLink.scheme + "://" + uriLink.host + "/favicon.ico");
			}
			else 
				item.setAttribute(dstField, "chrome://dengGB/skin/bookmark.png");
		}
		catch (e) {
		}
	}
};

function  imageRequestObserver (item, dstField) {
	this.item = item;
	this.dstField = dstField;
}

imageRequestObserver.prototype = {
	// La interfaz urichecker exije que definamos OnStartRequest a pesar de que no la usemos
	onStartRequest: function(request, ctxt) { },

	// Preguntamos por el estatus de la peticin
	onStopRequest: function(request, ctxt, status) {
		// Si no encontramos el icono ponemos uno por defecto
		if (status != 0) this.item.setAttribute(this.dstField, "chrome://dengGB/skin/bookmark.png");
	}
}

window.addEventListener("load", function(e) { dengGB.onLoad(e); }, false);
window.addEventListener("click", function(e) { if (isContextOpen && e.button == 0) document.getElementById("dengGBMainMenuPopup").hidePopup(); isContextOpen = false;}, false);
