<?php
/**
 * $Horde: gollem/selectlist.php,v 1.13 2005/08/02 06:30:49 slusarz Exp $
 *
 * Copyright 2004-2005 Michael Slusarz <slusarz@curecanti.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did notcan receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('AUTH_HANDLER', true);
@define('GOLLEM_BASE', dirname(__FILE__));
$authentication = 'selectlist';
require_once GOLLEM_BASE . '/lib/base.php';
require_once 'Horde/Template.php';

/* Set directory. */
if (is_a($result = Gollem::changeDir(), 'PEAR_Error')) {
    $notification->push($result);
}
$currdir = Gollem::getDir();

/* Create a new cache ID if one does not already exist. */
$cacheid = Util::getFormData('cacheid');
if (empty($cacheid)) {
    $cacheid = substr(base_convert(microtime() . mt_rand(), 10, 36), -16);
    $_SESSION['gollem']['selectlist'][$cacheid] = array();
}

/* Get the formid for the return. */
$formid = Util::getFormData('formid');

/* Run through the action handlers. */
$actionID = Util::getFormData('actionID');
switch ($actionID) {
case 'select':
    $items = Util::getPost('items');
    if (is_array($items) && count($items)) {
        foreach ($items as $item) {
            $item_value = $currdir . '|' . $item;
            if (empty($_SESSION['gollem']['selectlist'][$cacheid]['files'])) {
                $_SESSION['gollem']['selectlist'][$cacheid]['files'] = array($item_value);
            } else {
                $item_key = array_search($item_value, $_SESSION['gollem']['selectlist'][$cacheid]['files']);
                if ($item_key !== false) {
                    unset($_SESSION['gollem']['selectlist'][$cacheid]['files'][$item_key]);
                    sort($_SESSION['gollem']['selectlist'][$cacheid]['files']);
                } else {
                    $_SESSION['gollem']['selectlist'][$cacheid]['files'][] = $item_value;
                }
            }
        }
        $filelist = array_unique($_SESSION['gollem']['selectlist'][$cacheid]['files']);
    }
    break;
}

$info = array();
$info['list'] = Gollem::listFolder($currdir);

/* If that didn't work, fall back to the parent or the home directory. */
if (is_a($info['list'], 'PEAR_Error')) {
    $notification->push(sprintf(_("Permission denied to %s: %s"), $currdir, $info['list']->getMessage()), 'horde.error');

    $loc = strrpos($currdir, '/');
    Gollem::setDir(($loc !== false) ? substr($currdir, 0, $loc) : Gollem::getHome());
    $currdir = Gollem::getDir();
    $info['list'] = Gollem::listFolder($currdir);
}

$info['title'] = htmlspecialchars($GLOBALS['gollem_be']['label']);

/* Image links. */
$folder_img = Horde::img('manager/folder.png', _("folder"));
$symlink_img = Horde::img('manager/symlink.png', _("symlink"));

/* Commonly used URLs. */
$self_url = Horde::applicationUrl('selectlist.php');

/* Now actually display everything, after we've notified the user of
   any errors. */
$backkey = $_SESSION['gollem']['backend_key'];
$list = $info['list'];
$title = $info['title'];

/* We only display the 'type' and 'name' columns. */
$columns = array('type', 'name');

/* Set up column listing for cloop. */
$columns_cloop = array();
foreach ($columns as $val) {
    $columns_cloop[] = array('case' => $val);
}

require GOLLEM_TEMPLATES . '/common-header.inc';
require GOLLEM_TEMPLATES . '/selectlist/javascript.inc';

/* Set up the template object. */
$template = &new Horde_Template();
$template->set('addbutton', _("Add"));
$template->set('donebutton', _("Done"));
$template->set('cancelbutton', _("Cancel"));
$template->set('self_url', $self_url);
$template->set('forminput', Util::formInput());
$template->set('cacheid', htmlspecialchars($cacheid));
$template->set('currdir', htmlspecialchars($currdir));
$template->set('formid', htmlspecialchars($formid));
$template->set('navlink', Gollem::directoryNavLink($currdir, Util::addParameter($self_url, array('cacheid' => $cacheid, 'formid' => $formid))));
if ($GLOBALS['conf']['backend']['backend_list'] == 'shown') {
    $template->set('changeserver', Horde::link(Auth::addLogoutParameters(Util::addParameter(Horde::applicationUrl('login.php'), array('url' => Util::addParameter(Horde::url('selectlist.php'), array('formid' => $formid)))), AUTH_REASON_LOGOUT), _("Change Server")) . Horde::img('logout.png', _("Change Server"), null, $GLOBALS['registry']->getImageDir('horde')) . '</a>', true);
} else {
    $template->set('changeserver', '', true);
}

if (is_array($list) &&
    count($list) &&
    Gollem::checkPermissions('backend', PERMS_READ)) {

    $entry = $icon_cache = array();
    $rowct = 0;

    foreach ($list as $key => $val) {
        $item = array(
          'dir' => false,
          'name' => htmlspecialchars($val['name']),
          'selected' => false,
          'type' => $val['type']
        );

        $name = str_replace(' ', '&nbsp;', $item['name']);

        /* Determine graphic to use. */
        if (!empty($val['link'])) {
            $item['graphic'] = $symlink_img;
        } elseif ($val['type'] == '**dir') {
            $item['graphic'] = $folder_img;
        } else {
            if (empty($icon_cache[$val['type']])) {
                require_once 'Horde/MIME/Magic.php';
                require_once 'Horde/MIME/Viewer.php';
                require HORDE_BASE . '/config/mime_drivers.php';
                require GOLLEM_BASE . '/config/mime_drivers.php';
                $icon_cache[$val['type']] = Horde::img(MIME_Viewer::getIcon(MIME_Magic::extToMIME($val['type'])), '', '', '');
            }
            $item['graphic'] = $icon_cache[$val['type']];
        }

        /* Create proper link. */
        switch ($val['type']) {
        case '**dir':
            $url = Util::addParameter($self_url, array('dir' => Gollem::subdirectory($currdir, $val['name']), 'cacheid' => $cacheid, 'formid' => $formid));
            $item['link'] = Horde::link($url, $val['name']) . '<strong>' . $name . '</strong></a>';
            $item['dir'] = true;
            break;

        case '**sym':
            if ($val['linktype'] === '**dir') {
                if (substr($val['link'], 0, 1) == '/') {
                    $parts = explode('/', $val['link']);
                    $name = array_pop($parts);
                    $dir = implode('/', $parts);
                } else {
                    $name = $val['link'];
                    $dir = $currdir;
                }

                $url = Util::addParameter($self_url, array('dir' => Gollem::subdirectory($currdir, $val['name']), 'cacheid' => $cacheid, 'formid' => $formid));
                $item['link'] = $item['name'] . ' -> <strong>' . Horde::link($url, $val['link']) . $val['link'] . '</a></strong>';
            } else {
                $item['link'] = $item['name'] . ' -> ' . $val['link'];
            }
            break;

        default:
            $item['link'] = $name;
            break;
        }

        if (!empty($_SESSION['gollem']['selectlist'][$cacheid]['files']) &&
            in_array($currdir . '|' . $val['name'], $_SESSION['gollem']['selectlist'][$cacheid]['files'])) {
            $item['selected'] = true;
        }

        $item['item'] = (++$rowct % 2) ? 'item0' : 'item1';

        $entry[] = $item;
    }

    $template->set('entry', $entry, true);
    $template->set('nofiles', '', true);
    $template->setCloop('columns', $columns_cloop, $columns);
} else {
    $template->set('nofiles', _("There are no files in this folder."), true);
}

echo $template->fetch(GOLLEM_TEMPLATES . '/selectlist/selectlist.html');
require $registry->get('templates', 'horde') . '/common-footer.inc';
