<?php
/**
 * $Horde: gollem/redirect.php,v 1.55 2005/07/15 06:44:01 slusarz Exp $
 *
 * Copyright 1999-2005 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2005 Max Kalika <max@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('AUTH_HANDLER', true);
@define('GOLLEM_BASE', dirname(__FILE__));
$authentication = 'none';
require_once GOLLEM_BASE . '/lib/base.php';
require GOLLEM_BASE . '/config/credentials.php';

$actionID = Util::getFormData('actionID');
$autologin = Util::getFormData('autologin');
$backend_key = Util::getFormData('backend_key');

$user = (empty($autologin)) ? Util::getPost('username') : Gollem::getAutologinID($backend_key);
$pass = (empty($autologin)) ? Util::getPost('password') : Auth::getCredential('password');

/* If we already have a session. */
if (isset($_SESSION['gollem']) &&
    is_array($_SESSION['gollem']) &&
    ($_SESSION['gollem']['backend_key'] == $backend_key)) {
    /* Make sure that if a username was specified, it is the current
     * username. */
    if ((is_null($user) ||
         ($user == $GLOBALS['gollem_be']['params']['username'])) &&
        (is_null($pass) ||
         ($pass == Secret::read(Secret::getKey('gollem'), $GLOBALS['gollem_be']['params']['password'])))) {
        $url = Util::getFormData('url');
        if (empty($url)) {
            $url = Horde::applicationUrl('manager.php', true);
        } elseif (!empty($actionID)) {
            $url = Util::addParameter($url, 'actionID', $actionID);
        }

        if (Util::getFormData('load_frameset')) {
            $full_url = Horde::applicationUrl($registry->get('webroot', 'horde') . '/index.php', true);
            $url = Util::addParameter($full_url, 'url', $url, false);
        }

        header('Refresh: 0; URL=' . $url);
        exit;
    } else {
        /* Disable the old session. */
        unset($_SESSION['gollem']);
        header('Location: ' . Auth::addLogoutParameters(Gollem::logoutUrl(), AUTH_REASON_FAILED));
        exit;
    }
}

/* Create a new session if we're given the proper parameters. */
if (Util::getFormData('gollem_loginform') || 
    Util::getFormData('nocredentials') ||
    $autologin) {
    if (Auth::getProvider() == 'gollem') {
        /* Destroy any existing session on login and make sure to use
         * a new session ID, to avoid session fixation issues. */
        Horde::getCleanSession();
    }

    /* Get the required parameters from the form data. */
    $args = array();
    $postdata = array_keys($GLOBALS['gollem_backends'][$backend_key]['loginparams']);
    if (empty($autologin)) {
        $GLOBALS['gollem_vfs'] = &VFS::singleton($GLOBALS['gollem_backends'][$backend_key]['driver']);
        $postdata = array_merge($postdata, $GLOBALS['gollem_vfs']->getRequiredCredentials());
    }
    foreach ($postdata as $val) {
        $args[$val] = Util::getPost($val);
    }

    require_once GOLLEM_BASE . '/lib/Session.php';
    if (Gollem_Session::createSession($backend_key, $user, $pass, $args)) {
        $entry = sprintf('%s login success for Horde User %s using backend %s.', $_SERVER['REMOTE_ADDR'], Auth::getAuth(), $backend_key);
        Horde::logMessage($entry, __FILE__, __LINE__, PEAR_LOG_NOTICE);

        $ie_version = Util::getFormData('ie_version');
        if ($ie_version) {
            $browser->setIEVersion($ie_version);
        }

        $url = '';
        if (Util::getFormData('url')) {
            $url = Horde::url(Util::removeParameter(Util::getFormData('url'), session_name()), true);
            if ($actionID) {
                $url = Util::addParameter($url, 'actionID', $actionID, false);
            }
        } elseif (Auth::getProvider() == 'gollem') {
            $url = Horde::applicationUrl($registry->get('webroot', 'horde') . '/index.php', true);
        } else {
            $url = Horde::applicationUrl('manager.php', true);
        }
    } else {
        $url = Util::addParameter(Auth::addLogoutParameters(Gollem::logoutUrl()), 'backend_key', $backend_key, false);
        if (!empty($autologin)) {
            $url = Util::addParameter($url, 'autologin_fail', '1', false);
        }
    }

    if (Util::getFormData('load_frameset')) {
        $full_url = Horde::applicationUrl($registry->get('webroot', 'horde') . '/index.php', true);
        $url = Util::addParameter($full_url, 'url', $url, false);
    }

    header('Refresh: 0; URL=' . $url);
    exit;
}

/* No session, and no login attempt. Just go to the login page. */
require GOLLEM_BASE . '/login.php';
