package quic

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
	protocol "v2ray.com/core/common/protocol"
	serial "v2ray.com/core/common/serial"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Config struct {
	Key                  string                   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Security             *protocol.SecurityConfig `protobuf:"bytes,2,opt,name=security,proto3" json:"security,omitempty"`
	Header               *serial.TypedMessage     `protobuf:"bytes,3,opt,name=header,proto3" json:"header,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Config) Reset()         { *m = Config{} }
func (m *Config) String() string { return proto.CompactTextString(m) }
func (*Config) ProtoMessage()    {}
func (*Config) Descriptor() ([]byte, []int) {
	return fileDescriptor_462e2eb906061b36, []int{0}
}

func (m *Config) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Config.Unmarshal(m, b)
}
func (m *Config) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Config.Marshal(b, m, deterministic)
}
func (m *Config) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Config.Merge(m, src)
}
func (m *Config) XXX_Size() int {
	return xxx_messageInfo_Config.Size(m)
}
func (m *Config) XXX_DiscardUnknown() {
	xxx_messageInfo_Config.DiscardUnknown(m)
}

var xxx_messageInfo_Config proto.InternalMessageInfo

func (m *Config) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Config) GetSecurity() *protocol.SecurityConfig {
	if m != nil {
		return m.Security
	}
	return nil
}

func (m *Config) GetHeader() *serial.TypedMessage {
	if m != nil {
		return m.Header
	}
	return nil
}

func init() {
	proto.RegisterType((*Config)(nil), "v2ray.core.transport.internet.quic.Config")
}

func init() {
	proto.RegisterFile("v2ray.com/core/transport/internet/quic/config.proto", fileDescriptor_462e2eb906061b36)
}

var fileDescriptor_462e2eb906061b36 = []byte{
	// 269 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x90, 0xc1, 0x4b, 0xc3, 0x30,
	0x14, 0xc6, 0xe9, 0x26, 0x45, 0xe3, 0x45, 0x7a, 0x2a, 0x3b, 0x8d, 0x1e, 0xc6, 0x10, 0x79, 0x91,
	0xee, 0xee, 0xc1, 0x81, 0xe0, 0x41, 0xd0, 0x3a, 0x3d, 0x78, 0x91, 0x98, 0x3d, 0x67, 0x70, 0xed,
	0xab, 0x2f, 0xa9, 0xd0, 0x7f, 0xc7, 0xa3, 0x7f, 0xa5, 0xa4, 0x59, 0x8b, 0xc8, 0xc0, 0x53, 0x0b,
	0xf9, 0x7e, 0xbf, 0x7c, 0x5f, 0xc4, 0xe2, 0x33, 0x67, 0xd5, 0x82, 0xa6, 0x52, 0x6a, 0x62, 0x94,
	0x8e, 0x55, 0x65, 0x6b, 0x62, 0x27, 0x4d, 0xe5, 0x90, 0x2b, 0x74, 0xf2, 0xa3, 0x31, 0x5a, 0x6a,
	0xaa, 0x5e, 0xcd, 0x06, 0x6a, 0x26, 0x47, 0x49, 0xd6, 0x43, 0x8c, 0x30, 0x00, 0xd0, 0x03, 0xe0,
	0x81, 0xc9, 0xf9, 0x1f, 0xb1, 0xa6, 0xb2, 0xa4, 0x4a, 0x5a, 0x64, 0xa3, 0xb6, 0xd2, 0xb5, 0x35,
	0xae, 0x9f, 0x4b, 0xb4, 0x56, 0x6d, 0x30, 0x58, 0x27, 0x67, 0xfb, 0x89, 0xee, 0x50, 0xd3, 0x56,
	0xbe, 0xa1, 0x5a, 0x23, 0xdb, 0x90, 0xce, 0xbe, 0x22, 0x11, 0x2f, 0xbb, 0x52, 0xc9, 0x89, 0x18,
	0xbf, 0x63, 0x9b, 0x46, 0xd3, 0x68, 0x7e, 0x54, 0xf8, 0xdf, 0xe4, 0x4a, 0x1c, 0x5a, 0xd4, 0x0d,
	0x1b, 0xd7, 0xa6, 0xa3, 0x69, 0x34, 0x3f, 0xce, 0x4f, 0xe1, 0x57, 0xe7, 0x60, 0x86, 0xde, 0x0c,
	0xf7, 0xbb, 0x6c, 0xf0, 0x15, 0x03, 0x9b, 0x5c, 0x88, 0x38, 0xdc, 0x9a, 0x8e, 0x3b, 0xcb, 0x6c,
	0x8f, 0x25, 0x2c, 0x82, 0x95, 0x5f, 0x74, 0x13, 0x06, 0x15, 0x3b, 0xea, 0xf2, 0x41, 0xcc, 0x34,
	0x95, 0xf0, 0xff, 0x73, 0xdd, 0x46, 0x4f, 0x07, 0xfe, 0xfb, 0x3d, 0xca, 0x1e, 0xf3, 0x42, 0xb5,
	0xb0, 0xf4, 0xe1, 0xd5, 0x10, 0xbe, 0xee, 0xc3, 0x77, 0x8d, 0xd1, 0x2f, 0x71, 0xd7, 0x7c, 0xf1,
	0x13, 0x00, 0x00, 0xff, 0xff, 0xd0, 0x05, 0x0f, 0xf6, 0xbd, 0x01, 0x00, 0x00,
}
