ARCH := amd64

CFLAGS := -Wall -Werror -Wno-unused-command-line-argument -fpie \
	-O2 -fno-builtin -ffreestanding -mgeneral-regs-only -g \
	-Wa,--noexecstack -fno-asynchronous-unwind-tables -fno-stack-protector

%.o: %.S
	$(CC) $(CFLAGS) -c $^ -o $@

%.o: %.c
	$(CC) $(CFLAGS) -c $^ -o $@

sighandler.built-in.bin.o: sighandler_$(ARCH).o syshandler_$(ARCH).o sigrestorer_$(ARCH).o sysmsg_lib.o
	$(LD) -pie -z noexecstack -T pie.lds.S $^ -o $@

sighandler_$(ARCH).go: sighandler.built-in.bin.o
	bash gen_offsets_go.sh sighandler Sighandler $^ > $@

sighandler.built-in.$(ARCH).bin: sighandler.built-in.bin.o
	 objcopy -O binary $^ $@

all: sighandler.built-in.$(ARCH).bin sighandler_$(ARCH).go

clean:
	$(RM) *.o

distclean: clean
	$(RM) *.bin sighandler_*.go
