// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/cloud/videointelligence/v1/video_intelligence.proto

package videointelligence

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// Human face detection and tracking.
	Feature_FACE_DETECTION Feature = 4
	// Speech transcription.
	Feature_SPEECH_TRANSCRIPTION Feature = 6
	// OCR text detection and tracking.
	Feature_TEXT_DETECTION Feature = 7
	// Object detection and tracking.
	Feature_OBJECT_TRACKING Feature = 9
	// Logo detection, tracking, and recognition.
	Feature_LOGO_RECOGNITION Feature = 12
)

// Enum value maps for Feature.
var (
	Feature_name = map[int32]string{
		0:  "FEATURE_UNSPECIFIED",
		1:  "LABEL_DETECTION",
		2:  "SHOT_CHANGE_DETECTION",
		3:  "EXPLICIT_CONTENT_DETECTION",
		4:  "FACE_DETECTION",
		6:  "SPEECH_TRANSCRIPTION",
		7:  "TEXT_DETECTION",
		9:  "OBJECT_TRACKING",
		12: "LOGO_RECOGNITION",
	}
	Feature_value = map[string]int32{
		"FEATURE_UNSPECIFIED":        0,
		"LABEL_DETECTION":            1,
		"SHOT_CHANGE_DETECTION":      2,
		"EXPLICIT_CONTENT_DETECTION": 3,
		"FACE_DETECTION":             4,
		"SPEECH_TRANSCRIPTION":       6,
		"TEXT_DETECTION":             7,
		"OBJECT_TRACKING":            9,
		"LOGO_RECOGNITION":           12,
	}
)

func (x Feature) Enum() *Feature {
	p := new(Feature)
	*p = x
	return p
}

func (x Feature) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Feature) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_enumTypes[0].Descriptor()
}

func (Feature) Type() protoreflect.EnumType {
	return &file_google_cloud_videointelligence_v1_video_intelligence_proto_enumTypes[0]
}

func (x Feature) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Feature.Descriptor instead.
func (Feature) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{0}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

// Enum value maps for LabelDetectionMode.
var (
	LabelDetectionMode_name = map[int32]string{
		0: "LABEL_DETECTION_MODE_UNSPECIFIED",
		1: "SHOT_MODE",
		2: "FRAME_MODE",
		3: "SHOT_AND_FRAME_MODE",
	}
	LabelDetectionMode_value = map[string]int32{
		"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
		"SHOT_MODE":                        1,
		"FRAME_MODE":                       2,
		"SHOT_AND_FRAME_MODE":              3,
	}
)

func (x LabelDetectionMode) Enum() *LabelDetectionMode {
	p := new(LabelDetectionMode)
	*p = x
	return p
}

func (x LabelDetectionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LabelDetectionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_enumTypes[1].Descriptor()
}

func (LabelDetectionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_videointelligence_v1_video_intelligence_proto_enumTypes[1]
}

func (x LabelDetectionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LabelDetectionMode.Descriptor instead.
func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{1}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

// Enum value maps for Likelihood.
var (
	Likelihood_name = map[int32]string{
		0: "LIKELIHOOD_UNSPECIFIED",
		1: "VERY_UNLIKELY",
		2: "UNLIKELY",
		3: "POSSIBLE",
		4: "LIKELY",
		5: "VERY_LIKELY",
	}
	Likelihood_value = map[string]int32{
		"LIKELIHOOD_UNSPECIFIED": 0,
		"VERY_UNLIKELY":          1,
		"UNLIKELY":               2,
		"POSSIBLE":               3,
		"LIKELY":                 4,
		"VERY_LIKELY":            5,
	}
)

func (x Likelihood) Enum() *Likelihood {
	p := new(Likelihood)
	*p = x
	return p
}

func (x Likelihood) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Likelihood) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_enumTypes[2].Descriptor()
}

func (Likelihood) Type() protoreflect.EnumType {
	return &file_google_cloud_videointelligence_v1_video_intelligence_proto_enumTypes[2]
}

func (x Likelihood) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Likelihood.Descriptor instead.
func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{2}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](https://cloud.google.com/storage/docs/request-endpoints).
	// A video URI may include wildcards in `object-id`, and thus identify
	// multiple videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Required. Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional. Location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](https://cloud.google.com/storage/docs/request-endpoints).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional. Cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId string `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
}

func (x *AnnotateVideoRequest) Reset() {
	*x = AnnotateVideoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateVideoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateVideoRequest) ProtoMessage() {}

func (x *AnnotateVideoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateVideoRequest.ProtoReflect.Descriptor instead.
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{0}
}

func (x *AnnotateVideoRequest) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

func (x *AnnotateVideoRequest) GetInputContent() []byte {
	if x != nil {
		return x.InputContent
	}
	return nil
}

func (x *AnnotateVideoRequest) GetFeatures() []Feature {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if x != nil {
		return x.VideoContext
	}
	return nil
}

func (x *AnnotateVideoRequest) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

func (x *AnnotateVideoRequest) GetLocationId() string {
	if x != nil {
		return x.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video is
	// treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig,proto3" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3" json:"explicit_content_detection_config,omitempty"`
	// Config for FACE_DETECTION.
	FaceDetectionConfig *FaceDetectionConfig `protobuf:"bytes,5,opt,name=face_detection_config,json=faceDetectionConfig,proto3" json:"face_detection_config,omitempty"`
	// Config for SPEECH_TRANSCRIPTION.
	SpeechTranscriptionConfig *SpeechTranscriptionConfig `protobuf:"bytes,6,opt,name=speech_transcription_config,json=speechTranscriptionConfig,proto3" json:"speech_transcription_config,omitempty"`
	// Config for TEXT_DETECTION.
	TextDetectionConfig *TextDetectionConfig `protobuf:"bytes,8,opt,name=text_detection_config,json=textDetectionConfig,proto3" json:"text_detection_config,omitempty"`
	// Config for OBJECT_TRACKING.
	ObjectTrackingConfig *ObjectTrackingConfig `protobuf:"bytes,13,opt,name=object_tracking_config,json=objectTrackingConfig,proto3" json:"object_tracking_config,omitempty"`
}

func (x *VideoContext) Reset() {
	*x = VideoContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoContext) ProtoMessage() {}

func (x *VideoContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoContext.ProtoReflect.Descriptor instead.
func (*VideoContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{1}
}

func (x *VideoContext) GetSegments() []*VideoSegment {
	if x != nil {
		return x.Segments
	}
	return nil
}

func (x *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if x != nil {
		return x.LabelDetectionConfig
	}
	return nil
}

func (x *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if x != nil {
		return x.ShotChangeDetectionConfig
	}
	return nil
}

func (x *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if x != nil {
		return x.ExplicitContentDetectionConfig
	}
	return nil
}

func (x *VideoContext) GetFaceDetectionConfig() *FaceDetectionConfig {
	if x != nil {
		return x.FaceDetectionConfig
	}
	return nil
}

func (x *VideoContext) GetSpeechTranscriptionConfig() *SpeechTranscriptionConfig {
	if x != nil {
		return x.SpeechTranscriptionConfig
	}
	return nil
}

func (x *VideoContext) GetTextDetectionConfig() *TextDetectionConfig {
	if x != nil {
		return x.TextDetectionConfig
	}
	return nil
}

func (x *VideoContext) GetObjectTrackingConfig() *ObjectTrackingConfig {
	if x != nil {
		return x.ObjectTrackingConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	// The confidence threshold we perform filtering on the labels from
	// frame-level detection. If not set, it is set to 0.4 by default. The valid
	// range for this threshold is [0.1, 0.9]. Any value set outside of this
	// range will be clipped.
	// Note: for best results please follow the default threshold. We will update
	// the default threshold everytime when we release a new model.
	FrameConfidenceThreshold float32 `protobuf:"fixed32,4,opt,name=frame_confidence_threshold,json=frameConfidenceThreshold,proto3" json:"frame_confidence_threshold,omitempty"`
	// The confidence threshold we perform filtering on the labels from
	// video-level and shot-level detections. If not set, it is set to 0.3 by
	// default. The valid range for this threshold is [0.1, 0.9]. Any value set
	// outside of this range will be clipped.
	// Note: for best results please follow the default threshold. We will update
	// the default threshold everytime when we release a new model.
	VideoConfidenceThreshold float32 `protobuf:"fixed32,5,opt,name=video_confidence_threshold,json=videoConfidenceThreshold,proto3" json:"video_confidence_threshold,omitempty"`
}

func (x *LabelDetectionConfig) Reset() {
	*x = LabelDetectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelDetectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelDetectionConfig) ProtoMessage() {}

func (x *LabelDetectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelDetectionConfig.ProtoReflect.Descriptor instead.
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{2}
}

func (x *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if x != nil {
		return x.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (x *LabelDetectionConfig) GetStationaryCamera() bool {
	if x != nil {
		return x.StationaryCamera
	}
	return false
}

func (x *LabelDetectionConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *LabelDetectionConfig) GetFrameConfidenceThreshold() float32 {
	if x != nil {
		return x.FrameConfidenceThreshold
	}
	return 0
}

func (x *LabelDetectionConfig) GetVideoConfidenceThreshold() float32 {
	if x != nil {
		return x.VideoConfidenceThreshold
	}
	return 0
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *ShotChangeDetectionConfig) Reset() {
	*x = ShotChangeDetectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShotChangeDetectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShotChangeDetectionConfig) ProtoMessage() {}

func (x *ShotChangeDetectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShotChangeDetectionConfig.ProtoReflect.Descriptor instead.
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{3}
}

func (x *ShotChangeDetectionConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Config for OBJECT_TRACKING.
type ObjectTrackingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Model to use for object tracking.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *ObjectTrackingConfig) Reset() {
	*x = ObjectTrackingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectTrackingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectTrackingConfig) ProtoMessage() {}

func (x *ObjectTrackingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectTrackingConfig.ProtoReflect.Descriptor instead.
func (*ObjectTrackingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{4}
}

func (x *ObjectTrackingConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Config for FACE_DETECTION.
type FaceDetectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Model to use for face detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Whether bounding boxes be included in the face annotation output.
	IncludeBoundingBoxes bool `protobuf:"varint,2,opt,name=include_bounding_boxes,json=includeBoundingBoxes,proto3" json:"include_bounding_boxes,omitempty"`
}

func (x *FaceDetectionConfig) Reset() {
	*x = FaceDetectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FaceDetectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FaceDetectionConfig) ProtoMessage() {}

func (x *FaceDetectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FaceDetectionConfig.ProtoReflect.Descriptor instead.
func (*FaceDetectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{5}
}

func (x *FaceDetectionConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *FaceDetectionConfig) GetIncludeBoundingBoxes() bool {
	if x != nil {
		return x.IncludeBoundingBoxes
	}
	return false
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *ExplicitContentDetectionConfig) Reset() {
	*x = ExplicitContentDetectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplicitContentDetectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplicitContentDetectionConfig) ProtoMessage() {}

func (x *ExplicitContentDetectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplicitContentDetectionConfig.ProtoReflect.Descriptor instead.
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{6}
}

func (x *ExplicitContentDetectionConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Config for TEXT_DETECTION.
type TextDetectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Language hint can be specified if the language to be detected is known a
	// priori. It can increase the accuracy of the detection. Language hint must
	// be language code in BCP-47 format.
	//
	// Automatic language detection is performed if no hint is provided.
	LanguageHints []string `protobuf:"bytes,1,rep,name=language_hints,json=languageHints,proto3" json:"language_hints,omitempty"`
	// Model to use for text detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *TextDetectionConfig) Reset() {
	*x = TextDetectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextDetectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextDetectionConfig) ProtoMessage() {}

func (x *TextDetectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextDetectionConfig.ProtoReflect.Descriptor instead.
func (*TextDetectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{7}
}

func (x *TextDetectionConfig) GetLanguageHints() []string {
	if x != nil {
		return x.LanguageHints
	}
	return nil
}

func (x *TextDetectionConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Video segment.
type VideoSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset *duration.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
}

func (x *VideoSegment) Reset() {
	*x = VideoSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoSegment) ProtoMessage() {}

func (x *VideoSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoSegment.ProtoReflect.Descriptor instead.
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{8}
}

func (x *VideoSegment) GetStartTimeOffset() *duration.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

func (x *VideoSegment) GetEndTimeOffset() *duration.Duration {
	if x != nil {
		return x.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *LabelSegment) Reset() {
	*x = LabelSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelSegment) ProtoMessage() {}

func (x *LabelSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelSegment.ProtoReflect.Descriptor instead.
func (*LabelSegment) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{9}
}

func (x *LabelSegment) GetSegment() *VideoSegment {
	if x != nil {
		return x.Segment
	}
	return nil
}

func (x *LabelSegment) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *LabelFrame) Reset() {
	*x = LabelFrame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelFrame) ProtoMessage() {}

func (x *LabelFrame) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelFrame.ProtoReflect.Descriptor instead.
func (*LabelFrame) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{10}
}

func (x *LabelFrame) GetTimeOffset() *duration.Duration {
	if x != nil {
		return x.TimeOffset
	}
	return nil
}

func (x *LabelFrame) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *Entity) Reset() {
	*x = Entity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entity) ProtoMessage() {}

func (x *Entity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entity.ProtoReflect.Descriptor instead.
func (*Entity) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{11}
}

func (x *Entity) GetEntityId() string {
	if x != nil {
		return x.EntityId
	}
	return ""
}

func (x *Entity) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Entity) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities,proto3" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames []*LabelFrame `protobuf:"bytes,4,rep,name=frames,proto3" json:"frames,omitempty"`
}

func (x *LabelAnnotation) Reset() {
	*x = LabelAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelAnnotation) ProtoMessage() {}

func (x *LabelAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelAnnotation.ProtoReflect.Descriptor instead.
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{12}
}

func (x *LabelAnnotation) GetEntity() *Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *LabelAnnotation) GetCategoryEntities() []*Entity {
	if x != nil {
		return x.CategoryEntities
	}
	return nil
}

func (x *LabelAnnotation) GetSegments() []*LabelSegment {
	if x != nil {
		return x.Segments
	}
	return nil
}

func (x *LabelAnnotation) GetFrames() []*LabelFrame {
	if x != nil {
		return x.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,proto3,enum=google.cloud.videointelligence.v1.Likelihood" json:"pornography_likelihood,omitempty"`
}

func (x *ExplicitContentFrame) Reset() {
	*x = ExplicitContentFrame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplicitContentFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplicitContentFrame) ProtoMessage() {}

func (x *ExplicitContentFrame) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplicitContentFrame.ProtoReflect.Descriptor instead.
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{13}
}

func (x *ExplicitContentFrame) GetTimeOffset() *duration.Duration {
	if x != nil {
		return x.TimeOffset
	}
	return nil
}

func (x *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if x != nil {
		return x.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All video frames where explicit content was detected.
	Frames []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames,proto3" json:"frames,omitempty"`
}

func (x *ExplicitContentAnnotation) Reset() {
	*x = ExplicitContentAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplicitContentAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplicitContentAnnotation) ProtoMessage() {}

func (x *ExplicitContentAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplicitContentAnnotation.ProtoReflect.Descriptor instead.
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{14}
}

func (x *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if x != nil {
		return x.Frames
	}
	return nil
}

// Normalized bounding box.
// The normalized vertex coordinates are relative to the original image.
// Range: [0, 1].
type NormalizedBoundingBox struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Left X coordinate.
	Left float32 `protobuf:"fixed32,1,opt,name=left,proto3" json:"left,omitempty"`
	// Top Y coordinate.
	Top float32 `protobuf:"fixed32,2,opt,name=top,proto3" json:"top,omitempty"`
	// Right X coordinate.
	Right float32 `protobuf:"fixed32,3,opt,name=right,proto3" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom float32 `protobuf:"fixed32,4,opt,name=bottom,proto3" json:"bottom,omitempty"`
}

func (x *NormalizedBoundingBox) Reset() {
	*x = NormalizedBoundingBox{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NormalizedBoundingBox) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NormalizedBoundingBox) ProtoMessage() {}

func (x *NormalizedBoundingBox) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NormalizedBoundingBox.ProtoReflect.Descriptor instead.
func (*NormalizedBoundingBox) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{15}
}

func (x *NormalizedBoundingBox) GetLeft() float32 {
	if x != nil {
		return x.Left
	}
	return 0
}

func (x *NormalizedBoundingBox) GetTop() float32 {
	if x != nil {
		return x.Top
	}
	return 0
}

func (x *NormalizedBoundingBox) GetRight() float32 {
	if x != nil {
		return x.Right
	}
	return 0
}

func (x *NormalizedBoundingBox) GetBottom() float32 {
	if x != nil {
		return x.Bottom
	}
	return 0
}

// Video segment level annotation results for face detection.
type FaceSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Video segment where a face was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
}

func (x *FaceSegment) Reset() {
	*x = FaceSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FaceSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FaceSegment) ProtoMessage() {}

func (x *FaceSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FaceSegment.ProtoReflect.Descriptor instead.
func (*FaceSegment) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{16}
}

func (x *FaceSegment) GetSegment() *VideoSegment {
	if x != nil {
		return x.Segment
	}
	return nil
}

// Video frame level annotation results for face detection.
type FaceFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Normalized Bounding boxes in a frame.
	// There can be more than one boxes if the same face is detected in multiple
	// locations within the current frame.
	NormalizedBoundingBoxes []*NormalizedBoundingBox `protobuf:"bytes,1,rep,name=normalized_bounding_boxes,json=normalizedBoundingBoxes,proto3" json:"normalized_bounding_boxes,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
}

func (x *FaceFrame) Reset() {
	*x = FaceFrame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FaceFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FaceFrame) ProtoMessage() {}

func (x *FaceFrame) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FaceFrame.ProtoReflect.Descriptor instead.
func (*FaceFrame) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{17}
}

func (x *FaceFrame) GetNormalizedBoundingBoxes() []*NormalizedBoundingBox {
	if x != nil {
		return x.NormalizedBoundingBoxes
	}
	return nil
}

func (x *FaceFrame) GetTimeOffset() *duration.Duration {
	if x != nil {
		return x.TimeOffset
	}
	return nil
}

// Face annotation.
type FaceAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Thumbnail of a representative face view (in JPEG format).
	Thumbnail []byte `protobuf:"bytes,1,opt,name=thumbnail,proto3" json:"thumbnail,omitempty"`
	// All video segments where a face was detected.
	Segments []*FaceSegment `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a face was detected.
	Frames []*FaceFrame `protobuf:"bytes,3,rep,name=frames,proto3" json:"frames,omitempty"`
}

func (x *FaceAnnotation) Reset() {
	*x = FaceAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FaceAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FaceAnnotation) ProtoMessage() {}

func (x *FaceAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FaceAnnotation.ProtoReflect.Descriptor instead.
func (*FaceAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{18}
}

func (x *FaceAnnotation) GetThumbnail() []byte {
	if x != nil {
		return x.Thumbnail
	}
	return nil
}

func (x *FaceAnnotation) GetSegments() []*FaceSegment {
	if x != nil {
		return x.Segments
	}
	return nil
}

func (x *FaceAnnotation) GetFrames() []*FaceFrame {
	if x != nil {
		return x.Frames
	}
	return nil
}

// For tracking related features.
// An object at time_offset with attributes, and located with
// normalized_bounding_box.
type TimestampedObject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Normalized Bounding box in a frame, where the object is located.
	NormalizedBoundingBox *NormalizedBoundingBox `protobuf:"bytes,1,opt,name=normalized_bounding_box,json=normalizedBoundingBox,proto3" json:"normalized_bounding_box,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the video frame for this object.
	TimeOffset *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Optional. The attributes of the object in the bounding box.
	Attributes []*DetectedAttribute `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty"`
	// Optional. The detected landmarks.
	Landmarks []*DetectedLandmark `protobuf:"bytes,4,rep,name=landmarks,proto3" json:"landmarks,omitempty"`
}

func (x *TimestampedObject) Reset() {
	*x = TimestampedObject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimestampedObject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimestampedObject) ProtoMessage() {}

func (x *TimestampedObject) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimestampedObject.ProtoReflect.Descriptor instead.
func (*TimestampedObject) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{19}
}

func (x *TimestampedObject) GetNormalizedBoundingBox() *NormalizedBoundingBox {
	if x != nil {
		return x.NormalizedBoundingBox
	}
	return nil
}

func (x *TimestampedObject) GetTimeOffset() *duration.Duration {
	if x != nil {
		return x.TimeOffset
	}
	return nil
}

func (x *TimestampedObject) GetAttributes() []*DetectedAttribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *TimestampedObject) GetLandmarks() []*DetectedLandmark {
	if x != nil {
		return x.Landmarks
	}
	return nil
}

// A track of an object instance.
type Track struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Video segment of a track.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// The object with timestamp and attributes per frame in the track.
	TimestampedObjects []*TimestampedObject `protobuf:"bytes,2,rep,name=timestamped_objects,json=timestampedObjects,proto3" json:"timestamped_objects,omitempty"`
	// Optional. Attributes in the track level.
	Attributes []*DetectedAttribute `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty"`
	// Optional. The confidence score of the tracked object.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *Track) Reset() {
	*x = Track{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Track) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Track) ProtoMessage() {}

func (x *Track) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Track.ProtoReflect.Descriptor instead.
func (*Track) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{20}
}

func (x *Track) GetSegment() *VideoSegment {
	if x != nil {
		return x.Segment
	}
	return nil
}

func (x *Track) GetTimestampedObjects() []*TimestampedObject {
	if x != nil {
		return x.TimestampedObjects
	}
	return nil
}

func (x *Track) GetAttributes() []*DetectedAttribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Track) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// A generic detected attribute represented by name in string format.
type DetectedAttribute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the attribute, i.e. glasses, dark_glasses, mouth_open etc.
	// A full list of supported type names will be provided in the document.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Detected attribute confidence. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Text value of the detection result. For example, the value for "HairColor"
	// can be "black", "blonde", etc.
	Value string `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *DetectedAttribute) Reset() {
	*x = DetectedAttribute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectedAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectedAttribute) ProtoMessage() {}

func (x *DetectedAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectedAttribute.ProtoReflect.Descriptor instead.
func (*DetectedAttribute) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{21}
}

func (x *DetectedAttribute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DetectedAttribute) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *DetectedAttribute) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// A generic detected landmark represented by name in string format and a 2D
// location.
type DetectedLandmark struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this landmark, i.e. left_hand, right_shoulder.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The 2D point of the detected landmark using the normalized image
	// coordindate system. The normalized coordinates have the range from 0 to 1.
	Point *NormalizedVertex `protobuf:"bytes,2,opt,name=point,proto3" json:"point,omitempty"`
	// The confidence score of the detected landmark. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,3,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *DetectedLandmark) Reset() {
	*x = DetectedLandmark{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectedLandmark) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectedLandmark) ProtoMessage() {}

func (x *DetectedLandmark) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectedLandmark.ProtoReflect.Descriptor instead.
func (*DetectedLandmark) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{22}
}

func (x *DetectedLandmark) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DetectedLandmark) GetPoint() *NormalizedVertex {
	if x != nil {
		return x.Point
	}
	return nil
}

func (x *DetectedLandmark) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Video segment on which the annotation is run.
	Segment *VideoSegment `protobuf:"bytes,10,opt,name=segment,proto3" json:"segment,omitempty"`
	// Topical label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations,proto3" json:"segment_label_annotations,omitempty"`
	// Presence label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label. Compared to the
	// existing topical `segment_label_annotations`, this field presents more
	// fine-grained, segment-level labels detected in video content and is made
	// available only when the client sets `LabelDetectionConfig.model` to
	// "builtin/latest" in the request.
	SegmentPresenceLabelAnnotations []*LabelAnnotation `protobuf:"bytes,23,rep,name=segment_presence_label_annotations,json=segmentPresenceLabelAnnotations,proto3" json:"segment_presence_label_annotations,omitempty"`
	// Topical label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations,proto3" json:"shot_label_annotations,omitempty"`
	// Presence label annotations on shot level. There is exactly one element for
	// each unique label. Compared to the existing topical
	// `shot_label_annotations`, this field presents more fine-grained, shot-level
	// labels detected in video content and is made available only when the client
	// sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
	ShotPresenceLabelAnnotations []*LabelAnnotation `protobuf:"bytes,24,rep,name=shot_presence_label_annotations,json=shotPresenceLabelAnnotations,proto3" json:"shot_presence_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations,proto3" json:"frame_label_annotations,omitempty"`
	// Face annotations. There is exactly one element for each unique face.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,5,rep,name=face_annotations,json=faceAnnotations,proto3" json:"face_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// Speech transcription.
	SpeechTranscriptions []*SpeechTranscription `protobuf:"bytes,11,rep,name=speech_transcriptions,json=speechTranscriptions,proto3" json:"speech_transcriptions,omitempty"`
	// OCR text detection and tracking.
	// Annotations for list of detected text snippets. Each will have list of
	// frame information associated with it.
	TextAnnotations []*TextAnnotation `protobuf:"bytes,12,rep,name=text_annotations,json=textAnnotations,proto3" json:"text_annotations,omitempty"`
	// Annotations for list of objects detected and tracked in video.
	ObjectAnnotations []*ObjectTrackingAnnotation `protobuf:"bytes,14,rep,name=object_annotations,json=objectAnnotations,proto3" json:"object_annotations,omitempty"`
	// Annotations for list of logos detected, tracked and recognized in video.
	LogoRecognitionAnnotations []*LogoRecognitionAnnotation `protobuf:"bytes,19,rep,name=logo_recognition_annotations,json=logoRecognitionAnnotations,proto3" json:"logo_recognition_annotations,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *VideoAnnotationResults) Reset() {
	*x = VideoAnnotationResults{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoAnnotationResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoAnnotationResults) ProtoMessage() {}

func (x *VideoAnnotationResults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoAnnotationResults.ProtoReflect.Descriptor instead.
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{23}
}

func (x *VideoAnnotationResults) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

func (x *VideoAnnotationResults) GetSegment() *VideoSegment {
	if x != nil {
		return x.Segment
	}
	return nil
}

func (x *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if x != nil {
		return x.SegmentLabelAnnotations
	}
	return nil
}

func (x *VideoAnnotationResults) GetSegmentPresenceLabelAnnotations() []*LabelAnnotation {
	if x != nil {
		return x.SegmentPresenceLabelAnnotations
	}
	return nil
}

func (x *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if x != nil {
		return x.ShotLabelAnnotations
	}
	return nil
}

func (x *VideoAnnotationResults) GetShotPresenceLabelAnnotations() []*LabelAnnotation {
	if x != nil {
		return x.ShotPresenceLabelAnnotations
	}
	return nil
}

func (x *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if x != nil {
		return x.FrameLabelAnnotations
	}
	return nil
}

func (x *VideoAnnotationResults) GetFaceAnnotations() []*FaceAnnotation {
	if x != nil {
		return x.FaceAnnotations
	}
	return nil
}

func (x *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if x != nil {
		return x.ShotAnnotations
	}
	return nil
}

func (x *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if x != nil {
		return x.ExplicitAnnotation
	}
	return nil
}

func (x *VideoAnnotationResults) GetSpeechTranscriptions() []*SpeechTranscription {
	if x != nil {
		return x.SpeechTranscriptions
	}
	return nil
}

func (x *VideoAnnotationResults) GetTextAnnotations() []*TextAnnotation {
	if x != nil {
		return x.TextAnnotations
	}
	return nil
}

func (x *VideoAnnotationResults) GetObjectAnnotations() []*ObjectTrackingAnnotation {
	if x != nil {
		return x.ObjectAnnotations
	}
	return nil
}

func (x *VideoAnnotationResults) GetLogoRecognitionAnnotations() []*LogoRecognitionAnnotation {
	if x != nil {
		return x.LogoRecognitionAnnotations
	}
	return nil
}

func (x *VideoAnnotationResults) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
}

func (x *AnnotateVideoResponse) Reset() {
	*x = AnnotateVideoResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateVideoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateVideoResponse) ProtoMessage() {}

func (x *AnnotateVideoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateVideoResponse.ProtoReflect.Descriptor instead.
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{24}
}

func (x *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if x != nil {
		return x.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far. Guaranteed to be
	// 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Specifies which feature is being tracked if the request contains more than
	// one features.
	Feature Feature `protobuf:"varint,5,opt,name=feature,proto3,enum=google.cloud.videointelligence.v1.Feature" json:"feature,omitempty"`
	// Specifies which segment is being tracked if the request contains more than
	// one segments.
	Segment *VideoSegment `protobuf:"bytes,6,opt,name=segment,proto3" json:"segment,omitempty"`
}

func (x *VideoAnnotationProgress) Reset() {
	*x = VideoAnnotationProgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoAnnotationProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoAnnotationProgress) ProtoMessage() {}

func (x *VideoAnnotationProgress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoAnnotationProgress.ProtoReflect.Descriptor instead.
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{25}
}

func (x *VideoAnnotationProgress) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

func (x *VideoAnnotationProgress) GetProgressPercent() int32 {
	if x != nil {
		return x.ProgressPercent
	}
	return 0
}

func (x *VideoAnnotationProgress) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *VideoAnnotationProgress) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *VideoAnnotationProgress) GetFeature() Feature {
	if x != nil {
		return x.Feature
	}
	return Feature_FEATURE_UNSPECIFIED
}

func (x *VideoAnnotationProgress) GetSegment() *VideoSegment {
	if x != nil {
		return x.Segment
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
}

func (x *AnnotateVideoProgress) Reset() {
	*x = AnnotateVideoProgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateVideoProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateVideoProgress) ProtoMessage() {}

func (x *AnnotateVideoProgress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateVideoProgress.ProtoReflect.Descriptor instead.
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{26}
}

func (x *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if x != nil {
		return x.AnnotationProgress
	}
	return nil
}

// Config for SPEECH_TRANSCRIPTION.
type SpeechTranscriptionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. *Required* The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Example: "en-US".
	// See [Language Support](https://cloud.google.com/speech/docs/languages)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechTranscription`. The server may return fewer than
	// `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1` will
	// return a maximum of one. If omitted, will return a maximum of one.
	MaxAlternatives int32 `protobuf:"varint,2,opt,name=max_alternatives,json=maxAlternatives,proto3" json:"max_alternatives,omitempty"`
	// Optional. If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	FilterProfanity bool `protobuf:"varint,3,opt,name=filter_profanity,json=filterProfanity,proto3" json:"filter_profanity,omitempty"`
	// Optional. A means to provide context to assist the speech recognition.
	SpeechContexts []*SpeechContext `protobuf:"bytes,4,rep,name=speech_contexts,json=speechContexts,proto3" json:"speech_contexts,omitempty"`
	// Optional. If 'true', adds punctuation to recognition result hypotheses.
	// This feature is only available in select languages. Setting this for
	// requests in other languages has no effect at all. The default 'false' value
	// does not add punctuation to result hypotheses. NOTE: "This is currently
	// offered as an experimental service, complimentary to all users. In the
	// future this may be exclusively available as a premium feature."
	EnableAutomaticPunctuation bool `protobuf:"varint,5,opt,name=enable_automatic_punctuation,json=enableAutomaticPunctuation,proto3" json:"enable_automatic_punctuation,omitempty"`
	// Optional. For file formats, such as MXF or MKV, supporting multiple audio
	// tracks, specify up to two tracks. Default: track 0.
	AudioTracks []int32 `protobuf:"varint,6,rep,packed,name=audio_tracks,json=audioTracks,proto3" json:"audio_tracks,omitempty"`
	// Optional. If 'true', enables speaker detection for each recognized word in
	// the top alternative of the recognition result using a speaker_tag provided
	// in the WordInfo.
	// Note: When this is true, we send all the words from the beginning of the
	// audio for the top alternative in every consecutive responses.
	// This is done in order to improve our speaker tags as our models learn to
	// identify the speakers in the conversation over time.
	EnableSpeakerDiarization bool `protobuf:"varint,7,opt,name=enable_speaker_diarization,json=enableSpeakerDiarization,proto3" json:"enable_speaker_diarization,omitempty"`
	// Optional. If set, specifies the estimated number of speakers in the conversation.
	// If not set, defaults to '2'.
	// Ignored unless enable_speaker_diarization is set to true.
	DiarizationSpeakerCount int32 `protobuf:"varint,8,opt,name=diarization_speaker_count,json=diarizationSpeakerCount,proto3" json:"diarization_speaker_count,omitempty"`
	// Optional. If `true`, the top result includes a list of words and the
	// confidence for those words. If `false`, no word-level confidence
	// information is returned. The default is `false`.
	EnableWordConfidence bool `protobuf:"varint,9,opt,name=enable_word_confidence,json=enableWordConfidence,proto3" json:"enable_word_confidence,omitempty"`
}

func (x *SpeechTranscriptionConfig) Reset() {
	*x = SpeechTranscriptionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpeechTranscriptionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechTranscriptionConfig) ProtoMessage() {}

func (x *SpeechTranscriptionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechTranscriptionConfig.ProtoReflect.Descriptor instead.
func (*SpeechTranscriptionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{27}
}

func (x *SpeechTranscriptionConfig) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *SpeechTranscriptionConfig) GetMaxAlternatives() int32 {
	if x != nil {
		return x.MaxAlternatives
	}
	return 0
}

func (x *SpeechTranscriptionConfig) GetFilterProfanity() bool {
	if x != nil {
		return x.FilterProfanity
	}
	return false
}

func (x *SpeechTranscriptionConfig) GetSpeechContexts() []*SpeechContext {
	if x != nil {
		return x.SpeechContexts
	}
	return nil
}

func (x *SpeechTranscriptionConfig) GetEnableAutomaticPunctuation() bool {
	if x != nil {
		return x.EnableAutomaticPunctuation
	}
	return false
}

func (x *SpeechTranscriptionConfig) GetAudioTracks() []int32 {
	if x != nil {
		return x.AudioTracks
	}
	return nil
}

func (x *SpeechTranscriptionConfig) GetEnableSpeakerDiarization() bool {
	if x != nil {
		return x.EnableSpeakerDiarization
	}
	return false
}

func (x *SpeechTranscriptionConfig) GetDiarizationSpeakerCount() int32 {
	if x != nil {
		return x.DiarizationSpeakerCount
	}
	return 0
}

func (x *SpeechTranscriptionConfig) GetEnableWordConfidence() bool {
	if x != nil {
		return x.EnableWordConfidence
	}
	return false
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of strings containing words and phrases "hints" so that
	// the speech recognition is more likely to recognize them. This can be used
	// to improve the accuracy for specific words and phrases, for example, if
	// specific commands are typically spoken by the user. This can also be used
	// to add additional words to the vocabulary of the recognizer. See
	// [usage limits](https://cloud.google.com/speech/limits#content).
	Phrases []string `protobuf:"bytes,1,rep,name=phrases,proto3" json:"phrases,omitempty"`
}

func (x *SpeechContext) Reset() {
	*x = SpeechContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpeechContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechContext) ProtoMessage() {}

func (x *SpeechContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechContext.ProtoReflect.Descriptor instead.
func (*SpeechContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{28}
}

func (x *SpeechContext) GetPhrases() []string {
	if x != nil {
		return x.Phrases
	}
	return nil
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechTranscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// May contain one or more recognition hypotheses (up to the maximum specified
	// in `max_alternatives`).  These alternatives are ordered in terms of
	// accuracy, with the top (first) alternative being the most probable, as
	// ranked by the recognizer.
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	// Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag of
	// the language in this result. This language code was detected to have the
	// most likelihood of being spoken in the audio.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *SpeechTranscription) Reset() {
	*x = SpeechTranscription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpeechTranscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechTranscription) ProtoMessage() {}

func (x *SpeechTranscription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechTranscription.ProtoReflect.Descriptor instead.
func (*SpeechTranscription) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{29}
}

func (x *SpeechTranscription) GetAlternatives() []*SpeechRecognitionAlternative {
	if x != nil {
		return x.Alternatives
	}
	return nil
}

func (x *SpeechTranscription) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative.
	// This field is not guaranteed to be accurate and users should not rely on it
	// to be always provided.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. A list of word-specific information for each recognized word.
	// Note: When `enable_speaker_diarization` is true, you will see all the words
	// from the beginning of the audio.
	Words []*WordInfo `protobuf:"bytes,3,rep,name=words,proto3" json:"words,omitempty"`
}

func (x *SpeechRecognitionAlternative) Reset() {
	*x = SpeechRecognitionAlternative{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpeechRecognitionAlternative) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechRecognitionAlternative) ProtoMessage() {}

func (x *SpeechRecognitionAlternative) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechRecognitionAlternative.ProtoReflect.Descriptor instead.
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{30}
}

func (x *SpeechRecognitionAlternative) GetTranscript() string {
	if x != nil {
		return x.Transcript
	}
	return ""
}

func (x *SpeechRecognitionAlternative) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *SpeechRecognitionAlternative) GetWords() []*WordInfo {
	if x != nil {
		return x.Words
	}
	return nil
}

// Word-specific information for recognized words. Word information is only
// included in the response when certain request parameters are set, such
// as `enable_word_time_offsets`.
type WordInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time offset relative to the beginning of the audio, and
	// corresponding to the start of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	StartTime *duration.Duration `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time offset relative to the beginning of the audio, and
	// corresponding to the end of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	EndTime *duration.Duration `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The word corresponding to this set of information.
	Word string `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative.
	// This field is not guaranteed to be accurate and users should not rely on it
	// to be always provided.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. A distinct integer value is assigned for every speaker within
	// the audio. This field specifies which one of those speakers was detected to
	// have spoken this word. Value ranges from 1 up to diarization_speaker_count,
	// and is only set if speaker diarization is enabled.
	SpeakerTag int32 `protobuf:"varint,5,opt,name=speaker_tag,json=speakerTag,proto3" json:"speaker_tag,omitempty"`
}

func (x *WordInfo) Reset() {
	*x = WordInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WordInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WordInfo) ProtoMessage() {}

func (x *WordInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WordInfo.ProtoReflect.Descriptor instead.
func (*WordInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{31}
}

func (x *WordInfo) GetStartTime() *duration.Duration {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *WordInfo) GetEndTime() *duration.Duration {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *WordInfo) GetWord() string {
	if x != nil {
		return x.Word
	}
	return ""
}

func (x *WordInfo) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *WordInfo) GetSpeakerTag() int32 {
	if x != nil {
		return x.SpeakerTag
	}
	return 0
}

// A vertex represents a 2D point in the image.
// NOTE: the normalized vertex coordinates are relative to the original image
// and range from 0 to 1.
type NormalizedVertex struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// X coordinate.
	X float32 `protobuf:"fixed32,1,opt,name=x,proto3" json:"x,omitempty"`
	// Y coordinate.
	Y float32 `protobuf:"fixed32,2,opt,name=y,proto3" json:"y,omitempty"`
}

func (x *NormalizedVertex) Reset() {
	*x = NormalizedVertex{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NormalizedVertex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NormalizedVertex) ProtoMessage() {}

func (x *NormalizedVertex) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NormalizedVertex.ProtoReflect.Descriptor instead.
func (*NormalizedVertex) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{32}
}

func (x *NormalizedVertex) GetX() float32 {
	if x != nil {
		return x.X
	}
	return 0
}

func (x *NormalizedVertex) GetY() float32 {
	if x != nil {
		return x.Y
	}
	return 0
}

// Normalized bounding polygon for text (that might not be aligned with axis).
// Contains list of the corner points in clockwise order starting from
// top-left corner. For example, for a rectangular bounding box:
// When the text is horizontal it might look like:
//         0----1
//         |    |
//         3----2
//
// When it's clockwise rotated 180 degrees around the top-left corner it
// becomes:
//         2----3
//         |    |
//         1----0
//
// and the vertex order will still be (0, 1, 2, 3). Note that values can be less
// than 0, or greater than 1 due to trignometric calculations for location of
// the box.
type NormalizedBoundingPoly struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Normalized vertices of the bounding polygon.
	Vertices []*NormalizedVertex `protobuf:"bytes,1,rep,name=vertices,proto3" json:"vertices,omitempty"`
}

func (x *NormalizedBoundingPoly) Reset() {
	*x = NormalizedBoundingPoly{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NormalizedBoundingPoly) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NormalizedBoundingPoly) ProtoMessage() {}

func (x *NormalizedBoundingPoly) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NormalizedBoundingPoly.ProtoReflect.Descriptor instead.
func (*NormalizedBoundingPoly) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{33}
}

func (x *NormalizedBoundingPoly) GetVertices() []*NormalizedVertex {
	if x != nil {
		return x.Vertices
	}
	return nil
}

// Video segment level annotation results for text detection.
type TextSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Video segment where a text snippet was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence for the track of detected text. It is calculated as the highest
	// over all frames where OCR detected text appears.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Information related to the frames where OCR detected text appears.
	Frames []*TextFrame `protobuf:"bytes,3,rep,name=frames,proto3" json:"frames,omitempty"`
}

func (x *TextSegment) Reset() {
	*x = TextSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextSegment) ProtoMessage() {}

func (x *TextSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextSegment.ProtoReflect.Descriptor instead.
func (*TextSegment) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{34}
}

func (x *TextSegment) GetSegment() *VideoSegment {
	if x != nil {
		return x.Segment
	}
	return nil
}

func (x *TextSegment) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *TextSegment) GetFrames() []*TextFrame {
	if x != nil {
		return x.Frames
	}
	return nil
}

// Video frame level annotation results for text annotation (OCR).
// Contains information regarding timestamp and bounding box locations for the
// frames containing detected OCR text snippets.
type TextFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bounding polygon of the detected text for this frame.
	RotatedBoundingBox *NormalizedBoundingPoly `protobuf:"bytes,1,opt,name=rotated_bounding_box,json=rotatedBoundingBox,proto3" json:"rotated_bounding_box,omitempty"`
	// Timestamp of this frame.
	TimeOffset *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
}

func (x *TextFrame) Reset() {
	*x = TextFrame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextFrame) ProtoMessage() {}

func (x *TextFrame) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextFrame.ProtoReflect.Descriptor instead.
func (*TextFrame) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{35}
}

func (x *TextFrame) GetRotatedBoundingBox() *NormalizedBoundingPoly {
	if x != nil {
		return x.RotatedBoundingBox
	}
	return nil
}

func (x *TextFrame) GetTimeOffset() *duration.Duration {
	if x != nil {
		return x.TimeOffset
	}
	return nil
}

// Annotations related to one detected OCR text snippet. This will contain the
// corresponding text, confidence value, and frame level information for each
// detection.
type TextAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The detected text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// All video segments where OCR detected text appears.
	Segments []*TextSegment `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
}

func (x *TextAnnotation) Reset() {
	*x = TextAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextAnnotation) ProtoMessage() {}

func (x *TextAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextAnnotation.ProtoReflect.Descriptor instead.
func (*TextAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{36}
}

func (x *TextAnnotation) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *TextAnnotation) GetSegments() []*TextSegment {
	if x != nil {
		return x.Segments
	}
	return nil
}

// Video frame level annotations for object detection and tracking. This field
// stores per frame location, time offset, and confidence.
type ObjectTrackingFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The normalized bounding box location of this object track for the frame.
	NormalizedBoundingBox *NormalizedBoundingBox `protobuf:"bytes,1,opt,name=normalized_bounding_box,json=normalizedBoundingBox,proto3" json:"normalized_bounding_box,omitempty"`
	// The timestamp of the frame in microseconds.
	TimeOffset *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
}

func (x *ObjectTrackingFrame) Reset() {
	*x = ObjectTrackingFrame{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectTrackingFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectTrackingFrame) ProtoMessage() {}

func (x *ObjectTrackingFrame) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectTrackingFrame.ProtoReflect.Descriptor instead.
func (*ObjectTrackingFrame) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{37}
}

func (x *ObjectTrackingFrame) GetNormalizedBoundingBox() *NormalizedBoundingBox {
	if x != nil {
		return x.NormalizedBoundingBox
	}
	return nil
}

func (x *ObjectTrackingFrame) GetTimeOffset() *duration.Duration {
	if x != nil {
		return x.TimeOffset
	}
	return nil
}

// Annotations corresponding to one tracked object.
type ObjectTrackingAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Different representation of tracking info in non-streaming batch
	// and streaming modes.
	//
	// Types that are assignable to TrackInfo:
	//	*ObjectTrackingAnnotation_Segment
	//	*ObjectTrackingAnnotation_TrackId
	TrackInfo isObjectTrackingAnnotation_TrackInfo `protobuf_oneof:"track_info"`
	// Entity to specify the object category that this track is labeled as.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Object category's labeling confidence of this track.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Information corresponding to all frames where this object track appears.
	// Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
	// messages in frames.
	// Streaming mode: it can only be one ObjectTrackingFrame message in frames.
	Frames []*ObjectTrackingFrame `protobuf:"bytes,2,rep,name=frames,proto3" json:"frames,omitempty"`
}

func (x *ObjectTrackingAnnotation) Reset() {
	*x = ObjectTrackingAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectTrackingAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectTrackingAnnotation) ProtoMessage() {}

func (x *ObjectTrackingAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectTrackingAnnotation.ProtoReflect.Descriptor instead.
func (*ObjectTrackingAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{38}
}

func (m *ObjectTrackingAnnotation) GetTrackInfo() isObjectTrackingAnnotation_TrackInfo {
	if m != nil {
		return m.TrackInfo
	}
	return nil
}

func (x *ObjectTrackingAnnotation) GetSegment() *VideoSegment {
	if x, ok := x.GetTrackInfo().(*ObjectTrackingAnnotation_Segment); ok {
		return x.Segment
	}
	return nil
}

func (x *ObjectTrackingAnnotation) GetTrackId() int64 {
	if x, ok := x.GetTrackInfo().(*ObjectTrackingAnnotation_TrackId); ok {
		return x.TrackId
	}
	return 0
}

func (x *ObjectTrackingAnnotation) GetEntity() *Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *ObjectTrackingAnnotation) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *ObjectTrackingAnnotation) GetFrames() []*ObjectTrackingFrame {
	if x != nil {
		return x.Frames
	}
	return nil
}

type isObjectTrackingAnnotation_TrackInfo interface {
	isObjectTrackingAnnotation_TrackInfo()
}

type ObjectTrackingAnnotation_Segment struct {
	// Non-streaming batch mode ONLY.
	// Each object track corresponds to one video segment where it appears.
	Segment *VideoSegment `protobuf:"bytes,3,opt,name=segment,proto3,oneof"`
}

type ObjectTrackingAnnotation_TrackId struct {
	// Streaming mode ONLY.
	// In streaming mode, we do not know the end time of a tracked object
	// before it is completed. Hence, there is no VideoSegment info returned.
	// Instead, we provide a unique identifiable integer track_id so that
	// the customers can correlate the results of the ongoing
	// ObjectTrackAnnotation of the same track_id over time.
	TrackId int64 `protobuf:"varint,5,opt,name=track_id,json=trackId,proto3,oneof"`
}

func (*ObjectTrackingAnnotation_Segment) isObjectTrackingAnnotation_TrackInfo() {}

func (*ObjectTrackingAnnotation_TrackId) isObjectTrackingAnnotation_TrackInfo() {}

// Annotation corresponding to one detected, tracked and recognized logo class.
type LogoRecognitionAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entity category information to specify the logo class that all the logo
	// tracks within this LogoRecognitionAnnotation are recognized as.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// All logo tracks where the recognized logo appears. Each track corresponds
	// to one logo instance appearing in consecutive frames.
	Tracks []*Track `protobuf:"bytes,2,rep,name=tracks,proto3" json:"tracks,omitempty"`
	// All video segments where the recognized logo appears. There might be
	// multiple instances of the same logo class appearing in one VideoSegment.
	Segments []*VideoSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
}

func (x *LogoRecognitionAnnotation) Reset() {
	*x = LogoRecognitionAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogoRecognitionAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogoRecognitionAnnotation) ProtoMessage() {}

func (x *LogoRecognitionAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogoRecognitionAnnotation.ProtoReflect.Descriptor instead.
func (*LogoRecognitionAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP(), []int{39}
}

func (x *LogoRecognitionAnnotation) GetEntity() *Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

func (x *LogoRecognitionAnnotation) GetTracks() []*Track {
	if x != nil {
		return x.Tracks
	}
	return nil
}

func (x *LogoRecognitionAnnotation) GetSegments() []*VideoSegment {
	if x != nil {
		return x.Segments
	}
	return nil
}

var File_google_cloud_videointelligence_v1_video_intelligence_proto protoreflect.FileDescriptor

var file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65,
	0x2f, 0x76, 0x31, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c,
	0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc5, 0x02, 0x0a, 0x14, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x12, 0x23, 0x0a, 0x0d,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x12, 0x4b, 0x0a, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67,
	0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x54,
	0x0a, 0x0d, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c,
	0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x12, 0x24, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x9d,
	0x07, 0x0a, 0x0c, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12,
	0x4b, 0x0a, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x6d, 0x0a, 0x16,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7d, 0x0a, 0x1c, 0x73,
	0x68, 0x6f, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x6f, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x19, 0x73, 0x68, 0x6f, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x8c, 0x01, 0x0a, 0x21, 0x65,
	0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f,
	0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c,
	0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x69,
	0x63, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1e, 0x65, 0x78, 0x70, 0x6c, 0x69,
	0x63, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6a, 0x0a, 0x15, 0x66, 0x61, 0x63,
	0x65, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74,
	0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63,
	0x65, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x13, 0x66, 0x61, 0x63, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7c, 0x0a, 0x1b, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69,
	0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x19, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x6a, 0x0a, 0x15, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x74, 0x65, 0x78, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x6d, 0x0a, 0x16, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xbe,
	0x02, 0x0a, 0x14, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x67, 0x0a, 0x14, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c,
	0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x12, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x2b, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x63,
	0x61, 0x6d, 0x65, 0x72, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x43, 0x61, 0x6d, 0x65, 0x72, 0x61, 0x12, 0x14, 0x0a,
	0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x3c, 0x0a, 0x1a, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x18, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x12, 0x3c, 0x0a, 0x1a, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x02, 0x52, 0x18, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x22,
	0x31, 0x0a, 0x19, 0x53, 0x68, 0x6f, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x22, 0x2c, 0x0a, 0x14, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63,
	0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x22, 0x61, 0x0a, 0x13, 0x46, 0x61, 0x63, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x34, 0x0a,
	0x16, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x5f, 0x62, 0x6f, 0x78, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f,
	0x78, 0x65, 0x73, 0x22, 0x36, 0x0a, 0x1e, 0x45, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x52, 0x0a, 0x13, 0x54,
	0x65, 0x78, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x68,
	0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x22,
	0x98, 0x01, 0x0a, 0x0c, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x41, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x79, 0x0a, 0x0c, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x07, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x68, 0x0a, 0x0a, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x46, 0x72,
	0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12,
	0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22,
	0x6c, 0x0a, 0x06, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xc0, 0x02,
	0x0a, 0x0f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x41, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x06, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x12, 0x56, 0x0a, 0x11, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x10, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x08,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x45, 0x0a, 0x06, 0x66, 0x72, 0x61,
	0x6d, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e,
	0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73,
	0x22, 0xb8, 0x01, 0x0a, 0x14, 0x45, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x0b, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x4f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x64, 0x0a, 0x16, 0x70, 0x6f, 0x72, 0x6e, 0x6f, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x79, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c,
	0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69,
	0x68, 0x6f, 0x6f, 0x64, 0x52, 0x15, 0x70, 0x6f, 0x72, 0x6e, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x79, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x22, 0x6c, 0x0a, 0x19, 0x45,
	0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x06, 0x66, 0x72, 0x61, 0x6d,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74,
	0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70,
	0x6c, 0x69, 0x63, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x72, 0x61, 0x6d,
	0x65, 0x52, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x6b, 0x0a, 0x15, 0x4e, 0x6f, 0x72,
	0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42,
	0x6f, 0x78, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x65, 0x66, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x04, 0x6c, 0x65, 0x66, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x6f, 0x70, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x03, 0x74, 0x6f, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x72, 0x69, 0x67, 0x68,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x72, 0x69, 0x67, 0x68, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x06,
	0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x22, 0x58, 0x0a, 0x0b, 0x46, 0x61, 0x63, 0x65, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c,
	0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x22, 0xbd, 0x01, 0x0a, 0x09, 0x46, 0x61, 0x63, 0x65, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x74,
	0x0a, 0x19, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6f, 0x78, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x52, 0x17, 0x6e, 0x6f, 0x72,
	0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42,
	0x6f, 0x78, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x22, 0xc0, 0x01, 0x0a, 0x0e, 0x46, 0x61, 0x63, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x68, 0x75, 0x6d, 0x62, 0x6e, 0x61, 0x69, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x74, 0x68, 0x75, 0x6d, 0x62, 0x6e, 0x61, 0x69,
	0x6c, 0x12, 0x4a, 0x0a, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67,
	0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x44, 0x0a,
	0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x06, 0x66, 0x72, 0x61,
	0x6d, 0x65, 0x73, 0x22, 0xf4, 0x02, 0x0a, 0x11, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x70, 0x0a, 0x17, 0x6e, 0x6f, 0x72,
	0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x62, 0x6f, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69,
	0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x42, 0x6f, 0x78, 0x52, 0x15, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x12, 0x3a, 0x0a, 0x0b, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x74, 0x69, 0x6d,
	0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x59, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x12, 0x56, 0x0a, 0x09, 0x6c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c,
	0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x4c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x6c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x22, 0xb9, 0x02, 0x0a, 0x05, 0x54,
	0x72, 0x61, 0x63, 0x6b, 0x12, 0x49, 0x0a, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c,
	0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x65, 0x0a, 0x13, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x65, 0x64, 0x5f, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x52, 0x12, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x65, 0x64, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x59, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69,
	0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x12, 0x23, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x5d, 0x0a, 0x11, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x91, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x4c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49,
	0x0a, 0x05, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x65, 0x72, 0x74,
	0x65, 0x78, 0x52, 0x05, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xcc, 0x0b, 0x0a, 0x16, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x55, 0x72,
	0x69, 0x12, 0x49, 0x0a, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x6e, 0x0a, 0x19,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x17, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x7f, 0x0a, 0x22,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74,
	0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1f, 0x73, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x68, 0x0a,
	0x16, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x14, 0x73, 0x68, 0x6f, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x79, 0x0a, 0x1f, 0x73, 0x68, 0x6f, 0x74, 0x5f,
	0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x18, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1c, 0x73, 0x68, 0x6f, 0x74, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e,
	0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x6a, 0x0a, 0x17, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67,
	0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5c,
	0x0a, 0x10, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74,
	0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63,
	0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x66, 0x61, 0x63,
	0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x10,
	0x73, 0x68, 0x6f, 0x74, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c,
	0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0f, 0x73, 0x68, 0x6f, 0x74, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6d, 0x0a, 0x13, 0x65, 0x78, 0x70, 0x6c,
	0x69, 0x63, 0x69, 0x74, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c,
	0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x69, 0x63,
	0x69, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x12, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6b, 0x0a, 0x15, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c,
	0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5c, 0x0a, 0x10, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0f, 0x74, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x6a, 0x0a, 0x12, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e,
	0x67, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x7e,
	0x0a, 0x1c, 0x6c, 0x6f, 0x67, 0x6f, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x13,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69,
	0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x6f, 0x52, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x1a, 0x6c, 0x6f, 0x67, 0x6f, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28,
	0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x81, 0x01, 0x0a, 0x15, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x68, 0x0a, 0x12, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x11, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0xea, 0x02, 0x0a,
	0x17, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x55, 0x72, 0x69, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x07, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e,
	0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x07, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x49,
	0x0a, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x84, 0x01, 0x0a, 0x15, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x12, 0x6b, 0x0a, 0x13, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x12, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x22, 0xb3, 0x04, 0x0a, 0x19, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x28,
	0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2e, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f,
	0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x41, 0x6c, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x50,
	0x72, 0x6f, 0x66, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x12, 0x5e, 0x0a, 0x0f, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x12, 0x45, 0x0a, 0x1c, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x70, 0x75, 0x6e,
	0x63, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x63, 0x50, 0x75, 0x6e, 0x63, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x26, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x75, 0x64, 0x69,
	0x6f, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x12, 0x41, 0x0a, 0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x5f, 0x64, 0x69, 0x61, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x18, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x44,
	0x69, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x19, 0x64, 0x69,
	0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65,
	0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x17, 0x64, 0x69, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x16, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x6f, 0x72, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x2e, 0x0a, 0x0d, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x70,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x22, 0xa4, 0x01, 0x0a, 0x13, 0x53, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x63,
	0x0a, 0x0c, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69,
	0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52,
	0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x52, 0x0c, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xab, 0x01,
	0x0a, 0x1c, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x12, 0x1e,
	0x0a, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x23,
	0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x46, 0x0a, 0x05, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x22, 0xd9, 0x01, 0x0a, 0x08,
	0x57, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x38, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x34, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x77, 0x6f, 0x72, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x23, 0x0a, 0x0a,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x5f, 0x74, 0x61, 0x67,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x73, 0x70, 0x65,
	0x61, 0x6b, 0x65, 0x72, 0x54, 0x61, 0x67, 0x22, 0x2e, 0x0a, 0x10, 0x4e, 0x6f, 0x72, 0x6d, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x12, 0x0c, 0x0a, 0x01, 0x78,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x01, 0x78, 0x12, 0x0c, 0x0a, 0x01, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x01, 0x79, 0x22, 0x69, 0x0a, 0x16, 0x4e, 0x6f, 0x72, 0x6d, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c,
	0x79, 0x12, 0x4f, 0x0a, 0x08, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67,
	0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x64, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x08, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63,
	0x65, 0x73, 0x22, 0xbe, 0x01, 0x0a, 0x0b, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x49, 0x0a, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67,
	0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a,
	0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x44, 0x0a,
	0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x06, 0x66, 0x72, 0x61,
	0x6d, 0x65, 0x73, 0x22, 0xb4, 0x01, 0x0a, 0x09, 0x54, 0x65, 0x78, 0x74, 0x46, 0x72, 0x61, 0x6d,
	0x65, 0x12, 0x6b, 0x0a, 0x14, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6f, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x52, 0x12, 0x72, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x12, 0x3a,
	0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a,
	0x74, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x70, 0x0a, 0x0e, 0x54, 0x65,
	0x78, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x4a, 0x0a, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xc3, 0x01, 0x0a,
	0x13, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x46,
	0x72, 0x61, 0x6d, 0x65, 0x12, 0x70, 0x0a, 0x17, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x64, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6f, 0x78, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c,
	0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x52,
	0x15, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x42, 0x6f, 0x78, 0x12, 0x3a, 0x0a, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x22, 0xc5, 0x02, 0x0a, 0x18, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61,
	0x63, 0x6b, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x4b, 0x0a, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x48, 0x00, 0x52, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x08,
	0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00,
	0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x41, 0x0a, 0x06, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e,
	0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1e, 0x0a, 0x0a,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x4e, 0x0a, 0x06,
	0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x46,
	0x72, 0x61, 0x6d, 0x65, 0x52, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x42, 0x0c, 0x0a, 0x0a,
	0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0xed, 0x01, 0x0a, 0x19, 0x4c,
	0x6f, 0x67, 0x6f, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74,
	0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x40, 0x0a, 0x06, 0x74,
	0x72, 0x61, 0x63, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x72, 0x61, 0x63, 0x6b, 0x52, 0x06, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x12, 0x4b, 0x0a,
	0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2a, 0xdf, 0x01, 0x0a, 0x07, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x13, 0x0a, 0x0f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x48, 0x4f, 0x54, 0x5f, 0x43, 0x48, 0x41,
	0x4e, 0x47, 0x45, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12,
	0x1e, 0x0a, 0x1a, 0x45, 0x58, 0x50, 0x4c, 0x49, 0x43, 0x49, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x54,
	0x45, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12,
	0x12, 0x0a, 0x0e, 0x46, 0x41, 0x43, 0x45, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x50, 0x45, 0x45, 0x43, 0x48, 0x5f, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x12, 0x12, 0x0a,
	0x0e, 0x54, 0x45, 0x58, 0x54, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x07, 0x12, 0x13, 0x0a, 0x0f, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x54, 0x52, 0x41, 0x43,
	0x4b, 0x49, 0x4e, 0x47, 0x10, 0x09, 0x12, 0x14, 0x0a, 0x10, 0x4c, 0x4f, 0x47, 0x4f, 0x5f, 0x52,
	0x45, 0x43, 0x4f, 0x47, 0x4e, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0c, 0x2a, 0x72, 0x0a, 0x12,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x44, 0x45, 0x54, 0x45,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x48, 0x4f, 0x54,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x52, 0x41, 0x4d, 0x45,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x48, 0x4f, 0x54, 0x5f,
	0x41, 0x4e, 0x44, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x10, 0x03,
	0x2a, 0x74, 0x0a, 0x0a, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x1a,
	0x0a, 0x16, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x49, 0x48, 0x4f, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x56, 0x45,
	0x52, 0x59, 0x5f, 0x55, 0x4e, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x55, 0x4e, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x50,
	0x4f, 0x53, 0x53, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x49, 0x4b,
	0x45, 0x4c, 0x59, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x4c, 0x49,
	0x4b, 0x45, 0x4c, 0x59, 0x10, 0x05, 0x32, 0xc0, 0x02, 0x0a, 0x18, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x49, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0xcd, 0x01, 0x0a, 0x0d, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c,
	0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x18, 0x22, 0x13, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x73, 0x3a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x12,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x2c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0xca, 0x41, 0x2e, 0x0a, 0x15, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x15, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x1a, 0x54, 0xca, 0x41, 0x20, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74,
	0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x8b, 0x02, 0x0a, 0x25, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x42, 0x1d, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x49, 0x6e, 0x74, 0x65, 0x6c, 0x6c,
	0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x52, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65,
	0x6e, 0x63, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x69, 0x6e, 0x74, 0x65,
	0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x49, 0x6e, 0x74,
	0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x21, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x69, 0x64, 0x65,
	0x6f, 0x49, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x49, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65,
	0x6e, 0x63, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescOnce sync.Once
	file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescData = file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDesc
)

func file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescGZIP() []byte {
	file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescOnce.Do(func() {
		file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescData)
	})
	return file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDescData
}

var file_google_cloud_videointelligence_v1_video_intelligence_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes = make([]protoimpl.MessageInfo, 40)
var file_google_cloud_videointelligence_v1_video_intelligence_proto_goTypes = []interface{}{
	(Feature)(0),                           // 0: google.cloud.videointelligence.v1.Feature
	(LabelDetectionMode)(0),                // 1: google.cloud.videointelligence.v1.LabelDetectionMode
	(Likelihood)(0),                        // 2: google.cloud.videointelligence.v1.Likelihood
	(*AnnotateVideoRequest)(nil),           // 3: google.cloud.videointelligence.v1.AnnotateVideoRequest
	(*VideoContext)(nil),                   // 4: google.cloud.videointelligence.v1.VideoContext
	(*LabelDetectionConfig)(nil),           // 5: google.cloud.videointelligence.v1.LabelDetectionConfig
	(*ShotChangeDetectionConfig)(nil),      // 6: google.cloud.videointelligence.v1.ShotChangeDetectionConfig
	(*ObjectTrackingConfig)(nil),           // 7: google.cloud.videointelligence.v1.ObjectTrackingConfig
	(*FaceDetectionConfig)(nil),            // 8: google.cloud.videointelligence.v1.FaceDetectionConfig
	(*ExplicitContentDetectionConfig)(nil), // 9: google.cloud.videointelligence.v1.ExplicitContentDetectionConfig
	(*TextDetectionConfig)(nil),            // 10: google.cloud.videointelligence.v1.TextDetectionConfig
	(*VideoSegment)(nil),                   // 11: google.cloud.videointelligence.v1.VideoSegment
	(*LabelSegment)(nil),                   // 12: google.cloud.videointelligence.v1.LabelSegment
	(*LabelFrame)(nil),                     // 13: google.cloud.videointelligence.v1.LabelFrame
	(*Entity)(nil),                         // 14: google.cloud.videointelligence.v1.Entity
	(*LabelAnnotation)(nil),                // 15: google.cloud.videointelligence.v1.LabelAnnotation
	(*ExplicitContentFrame)(nil),           // 16: google.cloud.videointelligence.v1.ExplicitContentFrame
	(*ExplicitContentAnnotation)(nil),      // 17: google.cloud.videointelligence.v1.ExplicitContentAnnotation
	(*NormalizedBoundingBox)(nil),          // 18: google.cloud.videointelligence.v1.NormalizedBoundingBox
	(*FaceSegment)(nil),                    // 19: google.cloud.videointelligence.v1.FaceSegment
	(*FaceFrame)(nil),                      // 20: google.cloud.videointelligence.v1.FaceFrame
	(*FaceAnnotation)(nil),                 // 21: google.cloud.videointelligence.v1.FaceAnnotation
	(*TimestampedObject)(nil),              // 22: google.cloud.videointelligence.v1.TimestampedObject
	(*Track)(nil),                          // 23: google.cloud.videointelligence.v1.Track
	(*DetectedAttribute)(nil),              // 24: google.cloud.videointelligence.v1.DetectedAttribute
	(*DetectedLandmark)(nil),               // 25: google.cloud.videointelligence.v1.DetectedLandmark
	(*VideoAnnotationResults)(nil),         // 26: google.cloud.videointelligence.v1.VideoAnnotationResults
	(*AnnotateVideoResponse)(nil),          // 27: google.cloud.videointelligence.v1.AnnotateVideoResponse
	(*VideoAnnotationProgress)(nil),        // 28: google.cloud.videointelligence.v1.VideoAnnotationProgress
	(*AnnotateVideoProgress)(nil),          // 29: google.cloud.videointelligence.v1.AnnotateVideoProgress
	(*SpeechTranscriptionConfig)(nil),      // 30: google.cloud.videointelligence.v1.SpeechTranscriptionConfig
	(*SpeechContext)(nil),                  // 31: google.cloud.videointelligence.v1.SpeechContext
	(*SpeechTranscription)(nil),            // 32: google.cloud.videointelligence.v1.SpeechTranscription
	(*SpeechRecognitionAlternative)(nil),   // 33: google.cloud.videointelligence.v1.SpeechRecognitionAlternative
	(*WordInfo)(nil),                       // 34: google.cloud.videointelligence.v1.WordInfo
	(*NormalizedVertex)(nil),               // 35: google.cloud.videointelligence.v1.NormalizedVertex
	(*NormalizedBoundingPoly)(nil),         // 36: google.cloud.videointelligence.v1.NormalizedBoundingPoly
	(*TextSegment)(nil),                    // 37: google.cloud.videointelligence.v1.TextSegment
	(*TextFrame)(nil),                      // 38: google.cloud.videointelligence.v1.TextFrame
	(*TextAnnotation)(nil),                 // 39: google.cloud.videointelligence.v1.TextAnnotation
	(*ObjectTrackingFrame)(nil),            // 40: google.cloud.videointelligence.v1.ObjectTrackingFrame
	(*ObjectTrackingAnnotation)(nil),       // 41: google.cloud.videointelligence.v1.ObjectTrackingAnnotation
	(*LogoRecognitionAnnotation)(nil),      // 42: google.cloud.videointelligence.v1.LogoRecognitionAnnotation
	(*duration.Duration)(nil),              // 43: google.protobuf.Duration
	(*status.Status)(nil),                  // 44: google.rpc.Status
	(*timestamp.Timestamp)(nil),            // 45: google.protobuf.Timestamp
	(*longrunning.Operation)(nil),          // 46: google.longrunning.Operation
}
var file_google_cloud_videointelligence_v1_video_intelligence_proto_depIdxs = []int32{
	0,  // 0: google.cloud.videointelligence.v1.AnnotateVideoRequest.features:type_name -> google.cloud.videointelligence.v1.Feature
	4,  // 1: google.cloud.videointelligence.v1.AnnotateVideoRequest.video_context:type_name -> google.cloud.videointelligence.v1.VideoContext
	11, // 2: google.cloud.videointelligence.v1.VideoContext.segments:type_name -> google.cloud.videointelligence.v1.VideoSegment
	5,  // 3: google.cloud.videointelligence.v1.VideoContext.label_detection_config:type_name -> google.cloud.videointelligence.v1.LabelDetectionConfig
	6,  // 4: google.cloud.videointelligence.v1.VideoContext.shot_change_detection_config:type_name -> google.cloud.videointelligence.v1.ShotChangeDetectionConfig
	9,  // 5: google.cloud.videointelligence.v1.VideoContext.explicit_content_detection_config:type_name -> google.cloud.videointelligence.v1.ExplicitContentDetectionConfig
	8,  // 6: google.cloud.videointelligence.v1.VideoContext.face_detection_config:type_name -> google.cloud.videointelligence.v1.FaceDetectionConfig
	30, // 7: google.cloud.videointelligence.v1.VideoContext.speech_transcription_config:type_name -> google.cloud.videointelligence.v1.SpeechTranscriptionConfig
	10, // 8: google.cloud.videointelligence.v1.VideoContext.text_detection_config:type_name -> google.cloud.videointelligence.v1.TextDetectionConfig
	7,  // 9: google.cloud.videointelligence.v1.VideoContext.object_tracking_config:type_name -> google.cloud.videointelligence.v1.ObjectTrackingConfig
	1,  // 10: google.cloud.videointelligence.v1.LabelDetectionConfig.label_detection_mode:type_name -> google.cloud.videointelligence.v1.LabelDetectionMode
	43, // 11: google.cloud.videointelligence.v1.VideoSegment.start_time_offset:type_name -> google.protobuf.Duration
	43, // 12: google.cloud.videointelligence.v1.VideoSegment.end_time_offset:type_name -> google.protobuf.Duration
	11, // 13: google.cloud.videointelligence.v1.LabelSegment.segment:type_name -> google.cloud.videointelligence.v1.VideoSegment
	43, // 14: google.cloud.videointelligence.v1.LabelFrame.time_offset:type_name -> google.protobuf.Duration
	14, // 15: google.cloud.videointelligence.v1.LabelAnnotation.entity:type_name -> google.cloud.videointelligence.v1.Entity
	14, // 16: google.cloud.videointelligence.v1.LabelAnnotation.category_entities:type_name -> google.cloud.videointelligence.v1.Entity
	12, // 17: google.cloud.videointelligence.v1.LabelAnnotation.segments:type_name -> google.cloud.videointelligence.v1.LabelSegment
	13, // 18: google.cloud.videointelligence.v1.LabelAnnotation.frames:type_name -> google.cloud.videointelligence.v1.LabelFrame
	43, // 19: google.cloud.videointelligence.v1.ExplicitContentFrame.time_offset:type_name -> google.protobuf.Duration
	2,  // 20: google.cloud.videointelligence.v1.ExplicitContentFrame.pornography_likelihood:type_name -> google.cloud.videointelligence.v1.Likelihood
	16, // 21: google.cloud.videointelligence.v1.ExplicitContentAnnotation.frames:type_name -> google.cloud.videointelligence.v1.ExplicitContentFrame
	11, // 22: google.cloud.videointelligence.v1.FaceSegment.segment:type_name -> google.cloud.videointelligence.v1.VideoSegment
	18, // 23: google.cloud.videointelligence.v1.FaceFrame.normalized_bounding_boxes:type_name -> google.cloud.videointelligence.v1.NormalizedBoundingBox
	43, // 24: google.cloud.videointelligence.v1.FaceFrame.time_offset:type_name -> google.protobuf.Duration
	19, // 25: google.cloud.videointelligence.v1.FaceAnnotation.segments:type_name -> google.cloud.videointelligence.v1.FaceSegment
	20, // 26: google.cloud.videointelligence.v1.FaceAnnotation.frames:type_name -> google.cloud.videointelligence.v1.FaceFrame
	18, // 27: google.cloud.videointelligence.v1.TimestampedObject.normalized_bounding_box:type_name -> google.cloud.videointelligence.v1.NormalizedBoundingBox
	43, // 28: google.cloud.videointelligence.v1.TimestampedObject.time_offset:type_name -> google.protobuf.Duration
	24, // 29: google.cloud.videointelligence.v1.TimestampedObject.attributes:type_name -> google.cloud.videointelligence.v1.DetectedAttribute
	25, // 30: google.cloud.videointelligence.v1.TimestampedObject.landmarks:type_name -> google.cloud.videointelligence.v1.DetectedLandmark
	11, // 31: google.cloud.videointelligence.v1.Track.segment:type_name -> google.cloud.videointelligence.v1.VideoSegment
	22, // 32: google.cloud.videointelligence.v1.Track.timestamped_objects:type_name -> google.cloud.videointelligence.v1.TimestampedObject
	24, // 33: google.cloud.videointelligence.v1.Track.attributes:type_name -> google.cloud.videointelligence.v1.DetectedAttribute
	35, // 34: google.cloud.videointelligence.v1.DetectedLandmark.point:type_name -> google.cloud.videointelligence.v1.NormalizedVertex
	11, // 35: google.cloud.videointelligence.v1.VideoAnnotationResults.segment:type_name -> google.cloud.videointelligence.v1.VideoSegment
	15, // 36: google.cloud.videointelligence.v1.VideoAnnotationResults.segment_label_annotations:type_name -> google.cloud.videointelligence.v1.LabelAnnotation
	15, // 37: google.cloud.videointelligence.v1.VideoAnnotationResults.segment_presence_label_annotations:type_name -> google.cloud.videointelligence.v1.LabelAnnotation
	15, // 38: google.cloud.videointelligence.v1.VideoAnnotationResults.shot_label_annotations:type_name -> google.cloud.videointelligence.v1.LabelAnnotation
	15, // 39: google.cloud.videointelligence.v1.VideoAnnotationResults.shot_presence_label_annotations:type_name -> google.cloud.videointelligence.v1.LabelAnnotation
	15, // 40: google.cloud.videointelligence.v1.VideoAnnotationResults.frame_label_annotations:type_name -> google.cloud.videointelligence.v1.LabelAnnotation
	21, // 41: google.cloud.videointelligence.v1.VideoAnnotationResults.face_annotations:type_name -> google.cloud.videointelligence.v1.FaceAnnotation
	11, // 42: google.cloud.videointelligence.v1.VideoAnnotationResults.shot_annotations:type_name -> google.cloud.videointelligence.v1.VideoSegment
	17, // 43: google.cloud.videointelligence.v1.VideoAnnotationResults.explicit_annotation:type_name -> google.cloud.videointelligence.v1.ExplicitContentAnnotation
	32, // 44: google.cloud.videointelligence.v1.VideoAnnotationResults.speech_transcriptions:type_name -> google.cloud.videointelligence.v1.SpeechTranscription
	39, // 45: google.cloud.videointelligence.v1.VideoAnnotationResults.text_annotations:type_name -> google.cloud.videointelligence.v1.TextAnnotation
	41, // 46: google.cloud.videointelligence.v1.VideoAnnotationResults.object_annotations:type_name -> google.cloud.videointelligence.v1.ObjectTrackingAnnotation
	42, // 47: google.cloud.videointelligence.v1.VideoAnnotationResults.logo_recognition_annotations:type_name -> google.cloud.videointelligence.v1.LogoRecognitionAnnotation
	44, // 48: google.cloud.videointelligence.v1.VideoAnnotationResults.error:type_name -> google.rpc.Status
	26, // 49: google.cloud.videointelligence.v1.AnnotateVideoResponse.annotation_results:type_name -> google.cloud.videointelligence.v1.VideoAnnotationResults
	45, // 50: google.cloud.videointelligence.v1.VideoAnnotationProgress.start_time:type_name -> google.protobuf.Timestamp
	45, // 51: google.cloud.videointelligence.v1.VideoAnnotationProgress.update_time:type_name -> google.protobuf.Timestamp
	0,  // 52: google.cloud.videointelligence.v1.VideoAnnotationProgress.feature:type_name -> google.cloud.videointelligence.v1.Feature
	11, // 53: google.cloud.videointelligence.v1.VideoAnnotationProgress.segment:type_name -> google.cloud.videointelligence.v1.VideoSegment
	28, // 54: google.cloud.videointelligence.v1.AnnotateVideoProgress.annotation_progress:type_name -> google.cloud.videointelligence.v1.VideoAnnotationProgress
	31, // 55: google.cloud.videointelligence.v1.SpeechTranscriptionConfig.speech_contexts:type_name -> google.cloud.videointelligence.v1.SpeechContext
	33, // 56: google.cloud.videointelligence.v1.SpeechTranscription.alternatives:type_name -> google.cloud.videointelligence.v1.SpeechRecognitionAlternative
	34, // 57: google.cloud.videointelligence.v1.SpeechRecognitionAlternative.words:type_name -> google.cloud.videointelligence.v1.WordInfo
	43, // 58: google.cloud.videointelligence.v1.WordInfo.start_time:type_name -> google.protobuf.Duration
	43, // 59: google.cloud.videointelligence.v1.WordInfo.end_time:type_name -> google.protobuf.Duration
	35, // 60: google.cloud.videointelligence.v1.NormalizedBoundingPoly.vertices:type_name -> google.cloud.videointelligence.v1.NormalizedVertex
	11, // 61: google.cloud.videointelligence.v1.TextSegment.segment:type_name -> google.cloud.videointelligence.v1.VideoSegment
	38, // 62: google.cloud.videointelligence.v1.TextSegment.frames:type_name -> google.cloud.videointelligence.v1.TextFrame
	36, // 63: google.cloud.videointelligence.v1.TextFrame.rotated_bounding_box:type_name -> google.cloud.videointelligence.v1.NormalizedBoundingPoly
	43, // 64: google.cloud.videointelligence.v1.TextFrame.time_offset:type_name -> google.protobuf.Duration
	37, // 65: google.cloud.videointelligence.v1.TextAnnotation.segments:type_name -> google.cloud.videointelligence.v1.TextSegment
	18, // 66: google.cloud.videointelligence.v1.ObjectTrackingFrame.normalized_bounding_box:type_name -> google.cloud.videointelligence.v1.NormalizedBoundingBox
	43, // 67: google.cloud.videointelligence.v1.ObjectTrackingFrame.time_offset:type_name -> google.protobuf.Duration
	11, // 68: google.cloud.videointelligence.v1.ObjectTrackingAnnotation.segment:type_name -> google.cloud.videointelligence.v1.VideoSegment
	14, // 69: google.cloud.videointelligence.v1.ObjectTrackingAnnotation.entity:type_name -> google.cloud.videointelligence.v1.Entity
	40, // 70: google.cloud.videointelligence.v1.ObjectTrackingAnnotation.frames:type_name -> google.cloud.videointelligence.v1.ObjectTrackingFrame
	14, // 71: google.cloud.videointelligence.v1.LogoRecognitionAnnotation.entity:type_name -> google.cloud.videointelligence.v1.Entity
	23, // 72: google.cloud.videointelligence.v1.LogoRecognitionAnnotation.tracks:type_name -> google.cloud.videointelligence.v1.Track
	11, // 73: google.cloud.videointelligence.v1.LogoRecognitionAnnotation.segments:type_name -> google.cloud.videointelligence.v1.VideoSegment
	3,  // 74: google.cloud.videointelligence.v1.VideoIntelligenceService.AnnotateVideo:input_type -> google.cloud.videointelligence.v1.AnnotateVideoRequest
	46, // 75: google.cloud.videointelligence.v1.VideoIntelligenceService.AnnotateVideo:output_type -> google.longrunning.Operation
	75, // [75:76] is the sub-list for method output_type
	74, // [74:75] is the sub-list for method input_type
	74, // [74:74] is the sub-list for extension type_name
	74, // [74:74] is the sub-list for extension extendee
	0,  // [0:74] is the sub-list for field type_name
}

func init() { file_google_cloud_videointelligence_v1_video_intelligence_proto_init() }
func file_google_cloud_videointelligence_v1_video_intelligence_proto_init() {
	if File_google_cloud_videointelligence_v1_video_intelligence_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateVideoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelDetectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShotChangeDetectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectTrackingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FaceDetectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplicitContentDetectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextDetectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelFrame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Entity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplicitContentFrame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplicitContentAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NormalizedBoundingBox); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FaceSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FaceFrame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FaceAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimestampedObject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Track); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetectedAttribute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetectedLandmark); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoAnnotationResults); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateVideoResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoAnnotationProgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateVideoProgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpeechTranscriptionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpeechContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpeechTranscription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpeechRecognitionAlternative); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WordInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NormalizedVertex); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NormalizedBoundingPoly); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextFrame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectTrackingFrame); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectTrackingAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogoRecognitionAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes[38].OneofWrappers = []interface{}{
		(*ObjectTrackingAnnotation_Segment)(nil),
		(*ObjectTrackingAnnotation_TrackId)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   40,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_videointelligence_v1_video_intelligence_proto_goTypes,
		DependencyIndexes: file_google_cloud_videointelligence_v1_video_intelligence_proto_depIdxs,
		EnumInfos:         file_google_cloud_videointelligence_v1_video_intelligence_proto_enumTypes,
		MessageInfos:      file_google_cloud_videointelligence_v1_video_intelligence_proto_msgTypes,
	}.Build()
	File_google_cloud_videointelligence_v1_video_intelligence_proto = out.File
	file_google_cloud_videointelligence_v1_video_intelligence_proto_rawDesc = nil
	file_google_cloud_videointelligence_v1_video_intelligence_proto_goTypes = nil
	file_google_cloud_videointelligence_v1_video_intelligence_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVideoIntelligenceServiceClient(cc grpc.ClientConnInterface) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

// UnimplementedVideoIntelligenceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVideoIntelligenceServiceServer struct {
}

func (*UnimplementedVideoIntelligenceServiceServer) AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnnotateVideo not implemented")
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1/video_intelligence.proto",
}
