// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/cloud/documentai/v1beta1/document.proto

package documentai

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	color "google.golang.org/genproto/googleapis/type/color"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Detected human reading orientation.
type Document_Page_Layout_Orientation int32

const (
	// Unspecified orientation.
	Document_Page_Layout_ORIENTATION_UNSPECIFIED Document_Page_Layout_Orientation = 0
	// Orientation is aligned with page up.
	Document_Page_Layout_PAGE_UP Document_Page_Layout_Orientation = 1
	// Orientation is aligned with page right.
	// Turn the head 90 degrees clockwise from upright to read.
	Document_Page_Layout_PAGE_RIGHT Document_Page_Layout_Orientation = 2
	// Orientation is aligned with page down.
	// Turn the head 180 degrees from upright to read.
	Document_Page_Layout_PAGE_DOWN Document_Page_Layout_Orientation = 3
	// Orientation is aligned with page left.
	// Turn the head 90 degrees counterclockwise from upright to read.
	Document_Page_Layout_PAGE_LEFT Document_Page_Layout_Orientation = 4
)

// Enum value maps for Document_Page_Layout_Orientation.
var (
	Document_Page_Layout_Orientation_name = map[int32]string{
		0: "ORIENTATION_UNSPECIFIED",
		1: "PAGE_UP",
		2: "PAGE_RIGHT",
		3: "PAGE_DOWN",
		4: "PAGE_LEFT",
	}
	Document_Page_Layout_Orientation_value = map[string]int32{
		"ORIENTATION_UNSPECIFIED": 0,
		"PAGE_UP":                 1,
		"PAGE_RIGHT":              2,
		"PAGE_DOWN":               3,
		"PAGE_LEFT":               4,
	}
)

func (x Document_Page_Layout_Orientation) Enum() *Document_Page_Layout_Orientation {
	p := new(Document_Page_Layout_Orientation)
	*p = x
	return p
}

func (x Document_Page_Layout_Orientation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Document_Page_Layout_Orientation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1beta1_document_proto_enumTypes[0].Descriptor()
}

func (Document_Page_Layout_Orientation) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1beta1_document_proto_enumTypes[0]
}

func (x Document_Page_Layout_Orientation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Document_Page_Layout_Orientation.Descriptor instead.
func (Document_Page_Layout_Orientation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 1, 0}
}

// Enum to denote the type of break found.
type Document_Page_Token_DetectedBreak_Type int32

const (
	// Unspecified break type.
	Document_Page_Token_DetectedBreak_TYPE_UNSPECIFIED Document_Page_Token_DetectedBreak_Type = 0
	// A single whitespace.
	Document_Page_Token_DetectedBreak_SPACE Document_Page_Token_DetectedBreak_Type = 1
	// A wider whitespace.
	Document_Page_Token_DetectedBreak_WIDE_SPACE Document_Page_Token_DetectedBreak_Type = 2
	// A hyphen that indicates that a token has been split across lines.
	Document_Page_Token_DetectedBreak_HYPHEN Document_Page_Token_DetectedBreak_Type = 3
)

// Enum value maps for Document_Page_Token_DetectedBreak_Type.
var (
	Document_Page_Token_DetectedBreak_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "SPACE",
		2: "WIDE_SPACE",
		3: "HYPHEN",
	}
	Document_Page_Token_DetectedBreak_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"SPACE":            1,
		"WIDE_SPACE":       2,
		"HYPHEN":           3,
	}
)

func (x Document_Page_Token_DetectedBreak_Type) Enum() *Document_Page_Token_DetectedBreak_Type {
	p := new(Document_Page_Token_DetectedBreak_Type)
	*p = x
	return p
}

func (x Document_Page_Token_DetectedBreak_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Document_Page_Token_DetectedBreak_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1beta1_document_proto_enumTypes[1].Descriptor()
}

func (Document_Page_Token_DetectedBreak_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1beta1_document_proto_enumTypes[1]
}

func (x Document_Page_Token_DetectedBreak_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Document_Page_Token_DetectedBreak_Type.Descriptor instead.
func (Document_Page_Token_DetectedBreak_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 5, 0, 0}
}

// Document represents the canonical document resource in Document Understanding
// AI.
// It is an interchange format that provides insights into documents and allows
// for collaboration between users and Document Understanding AI to iterate and
// optimize for quality.
type Document struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Original source document from the user.
	//
	// Types that are assignable to Source:
	//	*Document_Uri
	//	*Document_Content
	Source isDocument_Source `protobuf_oneof:"source"`
	// An IANA published MIME type (also referred to as media type). For more
	// information, see
	// https://www.iana.org/assignments/media-types/media-types.xhtml.
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// UTF-8 encoded text in reading order from the document.
	Text string `protobuf:"bytes,4,opt,name=text,proto3" json:"text,omitempty"`
	// Styles for the
	// [Document.text][google.cloud.documentai.v1beta1.Document.text].
	TextStyles []*Document_Style `protobuf:"bytes,5,rep,name=text_styles,json=textStyles,proto3" json:"text_styles,omitempty"`
	// Visual page layout for the
	// [Document][google.cloud.documentai.v1beta1.Document].
	Pages []*Document_Page `protobuf:"bytes,6,rep,name=pages,proto3" json:"pages,omitempty"`
	// A list of entities detected on
	// [Document.text][google.cloud.documentai.v1beta1.Document.text]. For
	// document shards, entities in this list may cross shard boundaries.
	Entities []*Document_Entity `protobuf:"bytes,7,rep,name=entities,proto3" json:"entities,omitempty"`
	// Relationship among
	// [Document.entities][google.cloud.documentai.v1beta1.Document.entities].
	EntityRelations []*Document_EntityRelation `protobuf:"bytes,8,rep,name=entity_relations,json=entityRelations,proto3" json:"entity_relations,omitempty"`
	// Information about the sharding if this document is sharded part of a larger
	// document. If the document is not sharded, this message is not specified.
	ShardInfo *Document_ShardInfo `protobuf:"bytes,9,opt,name=shard_info,json=shardInfo,proto3" json:"shard_info,omitempty"`
	// Any error that occurred while processing this document.
	Error *status.Status `protobuf:"bytes,10,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *Document) Reset() {
	*x = Document{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document) ProtoMessage() {}

func (x *Document) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document.ProtoReflect.Descriptor instead.
func (*Document) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0}
}

func (m *Document) GetSource() isDocument_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *Document) GetUri() string {
	if x, ok := x.GetSource().(*Document_Uri); ok {
		return x.Uri
	}
	return ""
}

func (x *Document) GetContent() []byte {
	if x, ok := x.GetSource().(*Document_Content); ok {
		return x.Content
	}
	return nil
}

func (x *Document) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *Document) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *Document) GetTextStyles() []*Document_Style {
	if x != nil {
		return x.TextStyles
	}
	return nil
}

func (x *Document) GetPages() []*Document_Page {
	if x != nil {
		return x.Pages
	}
	return nil
}

func (x *Document) GetEntities() []*Document_Entity {
	if x != nil {
		return x.Entities
	}
	return nil
}

func (x *Document) GetEntityRelations() []*Document_EntityRelation {
	if x != nil {
		return x.EntityRelations
	}
	return nil
}

func (x *Document) GetShardInfo() *Document_ShardInfo {
	if x != nil {
		return x.ShardInfo
	}
	return nil
}

func (x *Document) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

type isDocument_Source interface {
	isDocument_Source()
}

type Document_Uri struct {
	// Currently supports Google Cloud Storage URI of the form
	//    `gs://bucket_name/object_name`. Object versioning is not supported.
	//    See [Google Cloud Storage Request
	//    URIs](https://cloud.google.com/storage/docs/reference-uris) for more
	//    info.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3,oneof"`
}

type Document_Content struct {
	// Inline document content, represented as a stream of bytes.
	// Note: As with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	Content []byte `protobuf:"bytes,2,opt,name=content,proto3,oneof"`
}

func (*Document_Uri) isDocument_Source() {}

func (*Document_Content) isDocument_Source() {}

// For a large document, sharding may be performed to produce several
// document shards. Each document shard contains this field to detail which
// shard it is.
type Document_ShardInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The 0-based index of this shard.
	ShardIndex int64 `protobuf:"varint,1,opt,name=shard_index,json=shardIndex,proto3" json:"shard_index,omitempty"`
	// Total number of shards.
	ShardCount int64 `protobuf:"varint,2,opt,name=shard_count,json=shardCount,proto3" json:"shard_count,omitempty"`
	// The index of the first character in
	// [Document.text][google.cloud.documentai.v1beta1.Document.text] in the
	// overall document global text.
	TextOffset int64 `protobuf:"varint,3,opt,name=text_offset,json=textOffset,proto3" json:"text_offset,omitempty"`
}

func (x *Document_ShardInfo) Reset() {
	*x = Document_ShardInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_ShardInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_ShardInfo) ProtoMessage() {}

func (x *Document_ShardInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_ShardInfo.ProtoReflect.Descriptor instead.
func (*Document_ShardInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Document_ShardInfo) GetShardIndex() int64 {
	if x != nil {
		return x.ShardIndex
	}
	return 0
}

func (x *Document_ShardInfo) GetShardCount() int64 {
	if x != nil {
		return x.ShardCount
	}
	return 0
}

func (x *Document_ShardInfo) GetTextOffset() int64 {
	if x != nil {
		return x.TextOffset
	}
	return 0
}

// Annotation for common text style attributes. This adheres to CSS
// conventions as much as possible.
type Document_Style struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text anchor indexing into the
	// [Document.text][google.cloud.documentai.v1beta1.Document.text].
	TextAnchor *Document_TextAnchor `protobuf:"bytes,1,opt,name=text_anchor,json=textAnchor,proto3" json:"text_anchor,omitempty"`
	// Text color.
	Color *color.Color `protobuf:"bytes,2,opt,name=color,proto3" json:"color,omitempty"`
	// Text background color.
	BackgroundColor *color.Color `protobuf:"bytes,3,opt,name=background_color,json=backgroundColor,proto3" json:"background_color,omitempty"`
	// Font weight. Possible values are normal, bold, bolder, and lighter.
	// https://www.w3schools.com/cssref/pr_font_weight.asp
	FontWeight string `protobuf:"bytes,4,opt,name=font_weight,json=fontWeight,proto3" json:"font_weight,omitempty"`
	// Text style. Possible values are normal, italic, and oblique.
	// https://www.w3schools.com/cssref/pr_font_font-style.asp
	TextStyle string `protobuf:"bytes,5,opt,name=text_style,json=textStyle,proto3" json:"text_style,omitempty"`
	// Text decoration. Follows CSS standard.
	// <text-decoration-line> <text-decoration-color> <text-decoration-style>
	// https://www.w3schools.com/cssref/pr_text_text-decoration.asp
	TextDecoration string `protobuf:"bytes,6,opt,name=text_decoration,json=textDecoration,proto3" json:"text_decoration,omitempty"`
	// Font size.
	FontSize *Document_Style_FontSize `protobuf:"bytes,7,opt,name=font_size,json=fontSize,proto3" json:"font_size,omitempty"`
}

func (x *Document_Style) Reset() {
	*x = Document_Style{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Style) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Style) ProtoMessage() {}

func (x *Document_Style) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Style.ProtoReflect.Descriptor instead.
func (*Document_Style) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Document_Style) GetTextAnchor() *Document_TextAnchor {
	if x != nil {
		return x.TextAnchor
	}
	return nil
}

func (x *Document_Style) GetColor() *color.Color {
	if x != nil {
		return x.Color
	}
	return nil
}

func (x *Document_Style) GetBackgroundColor() *color.Color {
	if x != nil {
		return x.BackgroundColor
	}
	return nil
}

func (x *Document_Style) GetFontWeight() string {
	if x != nil {
		return x.FontWeight
	}
	return ""
}

func (x *Document_Style) GetTextStyle() string {
	if x != nil {
		return x.TextStyle
	}
	return ""
}

func (x *Document_Style) GetTextDecoration() string {
	if x != nil {
		return x.TextDecoration
	}
	return ""
}

func (x *Document_Style) GetFontSize() *Document_Style_FontSize {
	if x != nil {
		return x.FontSize
	}
	return nil
}

// A page in a [Document][google.cloud.documentai.v1beta1.Document].
type Document_Page struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// 1-based index for current
	// [Page][google.cloud.documentai.v1beta1.Document.Page] in a parent
	// [Document][google.cloud.documentai.v1beta1.Document]. Useful when a page
	// is taken out of a [Document][google.cloud.documentai.v1beta1.Document]
	// for individual processing.
	PageNumber int32 `protobuf:"varint,1,opt,name=page_number,json=pageNumber,proto3" json:"page_number,omitempty"`
	// Physical dimension of the page.
	Dimension *Document_Page_Dimension `protobuf:"bytes,2,opt,name=dimension,proto3" json:"dimension,omitempty"`
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
	// page.
	Layout *Document_Page_Layout `protobuf:"bytes,3,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	// A list of visually detected text blocks on the page.
	// A block has a set of lines (collected into paragraphs) that have a common
	// line-spacing and orientation.
	Blocks []*Document_Page_Block `protobuf:"bytes,5,rep,name=blocks,proto3" json:"blocks,omitempty"`
	// A list of visually detected text paragraphs on the page.
	// A collection of lines that a human would perceive as a paragraph.
	Paragraphs []*Document_Page_Paragraph `protobuf:"bytes,6,rep,name=paragraphs,proto3" json:"paragraphs,omitempty"`
	// A list of visually detected text lines on the page.
	// A collection of tokens that a human would perceive as a line.
	Lines []*Document_Page_Line `protobuf:"bytes,7,rep,name=lines,proto3" json:"lines,omitempty"`
	// A list of visually detected tokens on the page.
	Tokens []*Document_Page_Token `protobuf:"bytes,8,rep,name=tokens,proto3" json:"tokens,omitempty"`
	// A list of detected non-text visual elements e.g. checkbox,
	// signature etc. on the page.
	VisualElements []*Document_Page_VisualElement `protobuf:"bytes,9,rep,name=visual_elements,json=visualElements,proto3" json:"visual_elements,omitempty"`
	// A list of visually detected tables on the page.
	Tables []*Document_Page_Table `protobuf:"bytes,10,rep,name=tables,proto3" json:"tables,omitempty"`
	// A list of visually detected form fields on the page.
	FormFields []*Document_Page_FormField `protobuf:"bytes,11,rep,name=form_fields,json=formFields,proto3" json:"form_fields,omitempty"`
}

func (x *Document_Page) Reset() {
	*x = Document_Page{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page) ProtoMessage() {}

func (x *Document_Page) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page.ProtoReflect.Descriptor instead.
func (*Document_Page) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Document_Page) GetPageNumber() int32 {
	if x != nil {
		return x.PageNumber
	}
	return 0
}

func (x *Document_Page) GetDimension() *Document_Page_Dimension {
	if x != nil {
		return x.Dimension
	}
	return nil
}

func (x *Document_Page) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

func (x *Document_Page) GetBlocks() []*Document_Page_Block {
	if x != nil {
		return x.Blocks
	}
	return nil
}

func (x *Document_Page) GetParagraphs() []*Document_Page_Paragraph {
	if x != nil {
		return x.Paragraphs
	}
	return nil
}

func (x *Document_Page) GetLines() []*Document_Page_Line {
	if x != nil {
		return x.Lines
	}
	return nil
}

func (x *Document_Page) GetTokens() []*Document_Page_Token {
	if x != nil {
		return x.Tokens
	}
	return nil
}

func (x *Document_Page) GetVisualElements() []*Document_Page_VisualElement {
	if x != nil {
		return x.VisualElements
	}
	return nil
}

func (x *Document_Page) GetTables() []*Document_Page_Table {
	if x != nil {
		return x.Tables
	}
	return nil
}

func (x *Document_Page) GetFormFields() []*Document_Page_FormField {
	if x != nil {
		return x.FormFields
	}
	return nil
}

// A phrase in the text that is a known entity type, such as a person, an
// organization, or location.
type Document_Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Provenance of the entity.
	// Text anchor indexing into the
	// [Document.text][google.cloud.documentai.v1beta1.Document.text].
	TextAnchor *Document_TextAnchor `protobuf:"bytes,1,opt,name=text_anchor,json=textAnchor,proto3" json:"text_anchor,omitempty"`
	// Entity type from a schema e.g. `Address`.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Text value in the document e.g. `1600 Amphitheatre Pkwy`.
	MentionText string `protobuf:"bytes,3,opt,name=mention_text,json=mentionText,proto3" json:"mention_text,omitempty"`
	// Canonical mention name. This will be a unique value in the entity list
	// for this document.
	MentionId string `protobuf:"bytes,4,opt,name=mention_id,json=mentionId,proto3" json:"mention_id,omitempty"`
}

func (x *Document_Entity) Reset() {
	*x = Document_Entity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Entity) ProtoMessage() {}

func (x *Document_Entity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Entity.ProtoReflect.Descriptor instead.
func (*Document_Entity) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Document_Entity) GetTextAnchor() *Document_TextAnchor {
	if x != nil {
		return x.TextAnchor
	}
	return nil
}

func (x *Document_Entity) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Document_Entity) GetMentionText() string {
	if x != nil {
		return x.MentionText
	}
	return ""
}

func (x *Document_Entity) GetMentionId() string {
	if x != nil {
		return x.MentionId
	}
	return ""
}

// Relationship between
// [Entities][google.cloud.documentai.v1beta1.Document.Entity].
type Document_EntityRelation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Subject entity mention_id.
	SubjectId string `protobuf:"bytes,1,opt,name=subject_id,json=subjectId,proto3" json:"subject_id,omitempty"`
	// Object entity mention_id.
	ObjectId string `protobuf:"bytes,2,opt,name=object_id,json=objectId,proto3" json:"object_id,omitempty"`
	// Relationship description.
	Relation string `protobuf:"bytes,3,opt,name=relation,proto3" json:"relation,omitempty"`
}

func (x *Document_EntityRelation) Reset() {
	*x = Document_EntityRelation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_EntityRelation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_EntityRelation) ProtoMessage() {}

func (x *Document_EntityRelation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_EntityRelation.ProtoReflect.Descriptor instead.
func (*Document_EntityRelation) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Document_EntityRelation) GetSubjectId() string {
	if x != nil {
		return x.SubjectId
	}
	return ""
}

func (x *Document_EntityRelation) GetObjectId() string {
	if x != nil {
		return x.ObjectId
	}
	return ""
}

func (x *Document_EntityRelation) GetRelation() string {
	if x != nil {
		return x.Relation
	}
	return ""
}

// Text reference indexing into the
// [Document.text][google.cloud.documentai.v1beta1.Document.text].
type Document_TextAnchor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The text segments from the
	// [Document.text][google.cloud.documentai.v1beta1.Document.text].
	TextSegments []*Document_TextAnchor_TextSegment `protobuf:"bytes,1,rep,name=text_segments,json=textSegments,proto3" json:"text_segments,omitempty"`
}

func (x *Document_TextAnchor) Reset() {
	*x = Document_TextAnchor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_TextAnchor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_TextAnchor) ProtoMessage() {}

func (x *Document_TextAnchor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_TextAnchor.ProtoReflect.Descriptor instead.
func (*Document_TextAnchor) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Document_TextAnchor) GetTextSegments() []*Document_TextAnchor_TextSegment {
	if x != nil {
		return x.TextSegments
	}
	return nil
}

// Font size with unit.
type Document_Style_FontSize struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Font size for the text.
	Size float32 `protobuf:"fixed32,1,opt,name=size,proto3" json:"size,omitempty"`
	// Unit for the font size. Follows CSS naming (in, px, pt, etc.).
	Unit string `protobuf:"bytes,2,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *Document_Style_FontSize) Reset() {
	*x = Document_Style_FontSize{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Style_FontSize) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Style_FontSize) ProtoMessage() {}

func (x *Document_Style_FontSize) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Style_FontSize.ProtoReflect.Descriptor instead.
func (*Document_Style_FontSize) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *Document_Style_FontSize) GetSize() float32 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *Document_Style_FontSize) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

// Dimension for the page.
type Document_Page_Dimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Page width.
	Width float32 `protobuf:"fixed32,1,opt,name=width,proto3" json:"width,omitempty"`
	// Page height.
	Height float32 `protobuf:"fixed32,2,opt,name=height,proto3" json:"height,omitempty"`
	// Dimension unit.
	Unit string `protobuf:"bytes,3,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *Document_Page_Dimension) Reset() {
	*x = Document_Page_Dimension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Dimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Dimension) ProtoMessage() {}

func (x *Document_Page_Dimension) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Dimension.ProtoReflect.Descriptor instead.
func (*Document_Page_Dimension) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *Document_Page_Dimension) GetWidth() float32 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *Document_Page_Dimension) GetHeight() float32 {
	if x != nil {
		return x.Height
	}
	return 0
}

func (x *Document_Page_Dimension) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

// Visual element describing a layout unit on a page.
type Document_Page_Layout struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text anchor indexing into the
	// [Document.text][google.cloud.documentai.v1beta1.Document.text].
	TextAnchor *Document_TextAnchor `protobuf:"bytes,1,opt,name=text_anchor,json=textAnchor,proto3" json:"text_anchor,omitempty"`
	// Confidence of the current
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] within
	// context of the object this layout is for. e.g. confidence can be for a
	// single token, a table, a visual element, etc. depending on context.
	// Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// The bounding polygon for the
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
	BoundingPoly *BoundingPoly `protobuf:"bytes,3,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// Detected orientation for the
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
	Orientation Document_Page_Layout_Orientation `protobuf:"varint,4,opt,name=orientation,proto3,enum=google.cloud.documentai.v1beta1.Document_Page_Layout_Orientation" json:"orientation,omitempty"`
}

func (x *Document_Page_Layout) Reset() {
	*x = Document_Page_Layout{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Layout) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Layout) ProtoMessage() {}

func (x *Document_Page_Layout) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Layout.ProtoReflect.Descriptor instead.
func (*Document_Page_Layout) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 1}
}

func (x *Document_Page_Layout) GetTextAnchor() *Document_TextAnchor {
	if x != nil {
		return x.TextAnchor
	}
	return nil
}

func (x *Document_Page_Layout) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *Document_Page_Layout) GetBoundingPoly() *BoundingPoly {
	if x != nil {
		return x.BoundingPoly
	}
	return nil
}

func (x *Document_Page_Layout) GetOrientation() Document_Page_Layout_Orientation {
	if x != nil {
		return x.Orientation
	}
	return Document_Page_Layout_ORIENTATION_UNSPECIFIED
}

// A block has a set of lines (collected into paragraphs) that have a
// common line-spacing and orientation.
type Document_Page_Block struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
	// [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,2,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
}

func (x *Document_Page_Block) Reset() {
	*x = Document_Page_Block{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Block) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Block) ProtoMessage() {}

func (x *Document_Page_Block) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Block.ProtoReflect.Descriptor instead.
func (*Document_Page_Block) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 2}
}

func (x *Document_Page_Block) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_Block) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// A collection of lines that a human would perceive as a paragraph.
type Document_Page_Paragraph struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
	// [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,2,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
}

func (x *Document_Page_Paragraph) Reset() {
	*x = Document_Page_Paragraph{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Paragraph) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Paragraph) ProtoMessage() {}

func (x *Document_Page_Paragraph) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Paragraph.ProtoReflect.Descriptor instead.
func (*Document_Page_Paragraph) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 3}
}

func (x *Document_Page_Paragraph) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_Paragraph) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// A collection of tokens that a human would perceive as a line.
// Does not cross column boundaries, can be horizontal, vertical, etc.
type Document_Page_Line struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
	// [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,2,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
}

func (x *Document_Page_Line) Reset() {
	*x = Document_Page_Line{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Line) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Line) ProtoMessage() {}

func (x *Document_Page_Line) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Line.ProtoReflect.Descriptor instead.
func (*Document_Page_Line) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 4}
}

func (x *Document_Page_Line) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_Line) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// A detected token.
type Document_Page_Token struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
	// [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// Detected break at the end of a
	// [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
	DetectedBreak *Document_Page_Token_DetectedBreak `protobuf:"bytes,2,opt,name=detected_break,json=detectedBreak,proto3" json:"detected_break,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,3,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
}

func (x *Document_Page_Token) Reset() {
	*x = Document_Page_Token{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Token) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Token) ProtoMessage() {}

func (x *Document_Page_Token) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Token.ProtoReflect.Descriptor instead.
func (*Document_Page_Token) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 5}
}

func (x *Document_Page_Token) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_Token) GetDetectedBreak() *Document_Page_Token_DetectedBreak {
	if x != nil {
		return x.DetectedBreak
	}
	return nil
}

func (x *Document_Page_Token) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// Detected non-text visual elements e.g. checkbox, signature etc. on the
// page.
type Document_Page_VisualElement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
	// [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// Type of the
	// [VisualElement][google.cloud.documentai.v1beta1.Document.Page.VisualElement].
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,3,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
}

func (x *Document_Page_VisualElement) Reset() {
	*x = Document_Page_VisualElement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_VisualElement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_VisualElement) ProtoMessage() {}

func (x *Document_Page_VisualElement) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_VisualElement.ProtoReflect.Descriptor instead.
func (*Document_Page_VisualElement) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 6}
}

func (x *Document_Page_VisualElement) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_VisualElement) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Document_Page_VisualElement) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// A table representation similar to HTML table structure.
type Document_Page_Table struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
	// [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// Header rows of the table.
	HeaderRows []*Document_Page_Table_TableRow `protobuf:"bytes,2,rep,name=header_rows,json=headerRows,proto3" json:"header_rows,omitempty"`
	// Body rows of the table.
	BodyRows []*Document_Page_Table_TableRow `protobuf:"bytes,3,rep,name=body_rows,json=bodyRows,proto3" json:"body_rows,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
}

func (x *Document_Page_Table) Reset() {
	*x = Document_Page_Table{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Table) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Table) ProtoMessage() {}

func (x *Document_Page_Table) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Table.ProtoReflect.Descriptor instead.
func (*Document_Page_Table) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 7}
}

func (x *Document_Page_Table) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_Table) GetHeaderRows() []*Document_Page_Table_TableRow {
	if x != nil {
		return x.HeaderRows
	}
	return nil
}

func (x *Document_Page_Table) GetBodyRows() []*Document_Page_Table_TableRow {
	if x != nil {
		return x.BodyRows
	}
	return nil
}

func (x *Document_Page_Table) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// A form field detected on the page.
type Document_Page_FormField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
	// [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
	// name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
	FieldName *Document_Page_Layout `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
	// [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
	// value.
	FieldValue *Document_Page_Layout `protobuf:"bytes,2,opt,name=field_value,json=fieldValue,proto3" json:"field_value,omitempty"`
	// A list of detected languages for name together with confidence.
	NameDetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,3,rep,name=name_detected_languages,json=nameDetectedLanguages,proto3" json:"name_detected_languages,omitempty"`
	// A list of detected languages for value together with confidence.
	ValueDetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=value_detected_languages,json=valueDetectedLanguages,proto3" json:"value_detected_languages,omitempty"`
}

func (x *Document_Page_FormField) Reset() {
	*x = Document_Page_FormField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_FormField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_FormField) ProtoMessage() {}

func (x *Document_Page_FormField) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_FormField.ProtoReflect.Descriptor instead.
func (*Document_Page_FormField) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 8}
}

func (x *Document_Page_FormField) GetFieldName() *Document_Page_Layout {
	if x != nil {
		return x.FieldName
	}
	return nil
}

func (x *Document_Page_FormField) GetFieldValue() *Document_Page_Layout {
	if x != nil {
		return x.FieldValue
	}
	return nil
}

func (x *Document_Page_FormField) GetNameDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.NameDetectedLanguages
	}
	return nil
}

func (x *Document_Page_FormField) GetValueDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.ValueDetectedLanguages
	}
	return nil
}

// Detected language for a structural component.
type Document_Page_DetectedLanguage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The BCP-47 language code, such as "en-US" or "sr-Latn". For more
	// information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Confidence of detected language. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *Document_Page_DetectedLanguage) Reset() {
	*x = Document_Page_DetectedLanguage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_DetectedLanguage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_DetectedLanguage) ProtoMessage() {}

func (x *Document_Page_DetectedLanguage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_DetectedLanguage.ProtoReflect.Descriptor instead.
func (*Document_Page_DetectedLanguage) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 9}
}

func (x *Document_Page_DetectedLanguage) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *Document_Page_DetectedLanguage) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Detected break at the end of a
// [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
type Document_Page_Token_DetectedBreak struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Detected break type.
	Type Document_Page_Token_DetectedBreak_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.documentai.v1beta1.Document_Page_Token_DetectedBreak_Type" json:"type,omitempty"`
}

func (x *Document_Page_Token_DetectedBreak) Reset() {
	*x = Document_Page_Token_DetectedBreak{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Token_DetectedBreak) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Token_DetectedBreak) ProtoMessage() {}

func (x *Document_Page_Token_DetectedBreak) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Token_DetectedBreak.ProtoReflect.Descriptor instead.
func (*Document_Page_Token_DetectedBreak) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 5, 0}
}

func (x *Document_Page_Token_DetectedBreak) GetType() Document_Page_Token_DetectedBreak_Type {
	if x != nil {
		return x.Type
	}
	return Document_Page_Token_DetectedBreak_TYPE_UNSPECIFIED
}

// A row of table cells.
type Document_Page_Table_TableRow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cells that make up this row.
	Cells []*Document_Page_Table_TableCell `protobuf:"bytes,1,rep,name=cells,proto3" json:"cells,omitempty"`
}

func (x *Document_Page_Table_TableRow) Reset() {
	*x = Document_Page_Table_TableRow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Table_TableRow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Table_TableRow) ProtoMessage() {}

func (x *Document_Page_Table_TableRow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Table_TableRow.ProtoReflect.Descriptor instead.
func (*Document_Page_Table_TableRow) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 7, 0}
}

func (x *Document_Page_Table_TableRow) GetCells() []*Document_Page_Table_TableCell {
	if x != nil {
		return x.Cells
	}
	return nil
}

// A cell representation inside the table.
type Document_Page_Table_TableCell struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
	// [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// How many rows this cell spans.
	RowSpan int32 `protobuf:"varint,2,opt,name=row_span,json=rowSpan,proto3" json:"row_span,omitempty"`
	// How many columns this cell spans.
	ColSpan int32 `protobuf:"varint,3,opt,name=col_span,json=colSpan,proto3" json:"col_span,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
}

func (x *Document_Page_Table_TableCell) Reset() {
	*x = Document_Page_Table_TableCell{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Table_TableCell) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Table_TableCell) ProtoMessage() {}

func (x *Document_Page_Table_TableCell) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Table_TableCell.ProtoReflect.Descriptor instead.
func (*Document_Page_Table_TableCell) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 2, 7, 1}
}

func (x *Document_Page_Table_TableCell) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_Table_TableCell) GetRowSpan() int32 {
	if x != nil {
		return x.RowSpan
	}
	return 0
}

func (x *Document_Page_Table_TableCell) GetColSpan() int32 {
	if x != nil {
		return x.ColSpan
	}
	return 0
}

func (x *Document_Page_Table_TableCell) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// A text segment in the
// [Document.text][google.cloud.documentai.v1beta1.Document.text]. The
// indices may be out of bounds which indicate that the text extends into
// another document shard for large sharded documents. See
// [ShardInfo.text_offset][google.cloud.documentai.v1beta1.Document.ShardInfo.text_offset]
type Document_TextAnchor_TextSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [TextSegment][google.cloud.documentai.v1beta1.Document.TextAnchor.TextSegment]
	// start UTF-8 char index in the
	// [Document.text][google.cloud.documentai.v1beta1.Document.text].
	StartIndex int64 `protobuf:"varint,1,opt,name=start_index,json=startIndex,proto3" json:"start_index,omitempty"`
	// [TextSegment][google.cloud.documentai.v1beta1.Document.TextAnchor.TextSegment]
	// half open end UTF-8 char index in the
	// [Document.text][google.cloud.documentai.v1beta1.Document.text].
	EndIndex int64 `protobuf:"varint,2,opt,name=end_index,json=endIndex,proto3" json:"end_index,omitempty"`
}

func (x *Document_TextAnchor_TextSegment) Reset() {
	*x = Document_TextAnchor_TextSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_TextAnchor_TextSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_TextAnchor_TextSegment) ProtoMessage() {}

func (x *Document_TextAnchor_TextSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta1_document_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_TextAnchor_TextSegment.ProtoReflect.Descriptor instead.
func (*Document_TextAnchor_TextSegment) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP(), []int{0, 5, 0}
}

func (x *Document_TextAnchor_TextSegment) GetStartIndex() int64 {
	if x != nil {
		return x.StartIndex
	}
	return 0
}

func (x *Document_TextAnchor_TextSegment) GetEndIndex() int64 {
	if x != nil {
		return x.EndIndex
	}
	return 0
}

var File_google_cloud_documentai_v1beta1_document_proto protoreflect.FileDescriptor

var file_google_cloud_documentai_v1beta1_document_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x67, 0x65, 0x6f, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xf2, 0x2b, 0x0a, 0x08, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12,
	0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x75,
	0x72, 0x69, 0x12, 0x1a, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12,
	0x50, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x53, 0x74, 0x79, 0x6c, 0x65, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65,
	0x73, 0x12, 0x44, 0x0a, 0x05, 0x70, 0x61, 0x67, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65,
	0x52, 0x05, 0x70, 0x61, 0x67, 0x65, 0x73, 0x12, 0x4c, 0x0a, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x08, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x63, 0x0a, 0x10, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f,
	0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x52, 0x0a, 0x0a, 0x73, 0x68,
	0x61, 0x72, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x09, 0x73, 0x68, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x28,
	0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x1a, 0x6e, 0x0a, 0x09, 0x53, 0x68, 0x61, 0x72,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x68, 0x61, 0x72,
	0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x68, 0x61,
	0x72, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x74, 0x65,
	0x78, 0x74, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x1a, 0xbb, 0x03, 0x0a, 0x05, 0x53, 0x74, 0x79,
	0x6c, 0x65, 0x12, 0x55, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x61, 0x6e, 0x63, 0x68, 0x6f,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x52, 0x0a, 0x74,
	0x65, 0x78, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x12, 0x28, 0x0a, 0x05, 0x63, 0x6f, 0x6c,
	0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x52, 0x05, 0x63, 0x6f,
	0x6c, 0x6f, 0x72, 0x12, 0x3d, 0x0a, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x6f, 0x6c, 0x6f,
	0x72, 0x52, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x6c,
	0x6f, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x6f, 0x6e, 0x74, 0x5f, 0x77, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x6f, 0x6e, 0x74, 0x57, 0x65, 0x69,
	0x67, 0x68, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x74, 0x79, 0x6c,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x65, 0x78, 0x74, 0x53, 0x74, 0x79,
	0x6c, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x64, 0x65, 0x63, 0x6f, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x74, 0x65, 0x78,
	0x74, 0x44, 0x65, 0x63, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x09, 0x66,
	0x6f, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x2e,
	0x46, 0x6f, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x52, 0x08, 0x66, 0x6f, 0x6e, 0x74, 0x53, 0x69,
	0x7a, 0x65, 0x1a, 0x32, 0x0a, 0x08, 0x46, 0x6f, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04, 0x73, 0x69,
	0x7a, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x1a, 0x9e, 0x1f, 0x0a, 0x04, 0x50, 0x61, 0x67, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x12, 0x56, 0x0a, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50,
	0x61, 0x67, 0x65, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f,
	0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52,
	0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x6e, 0x0a, 0x12, 0x64, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50,
	0x61, 0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x52, 0x11, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0x4c, 0x0a, 0x06, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x06, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x12, 0x58, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x67, 0x72, 0x61,
	0x70, 0x68, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x67, 0x72, 0x61, 0x70, 0x68, 0x73, 0x12,
	0x49, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c,
	0x69, 0x6e, 0x65, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0x4c, 0x0a, 0x06, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x52, 0x06, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x12, 0x65, 0x0a, 0x0f, 0x76, 0x69, 0x73, 0x75,
	0x61, 0x6c, 0x5f, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67,
	0x65, 0x2e, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x0e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x4c, 0x0a, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x59, 0x0a,
	0x0b, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x0b, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61,
	0x67, 0x65, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x0a, 0x66, 0x6f,
	0x72, 0x6d, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x1a, 0x4d, 0x0a, 0x09, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x68,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x06, 0x68, 0x65, 0x69,
	0x67, 0x68, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x1a, 0x9f, 0x03, 0x0a, 0x06, 0x4c, 0x61, 0x79, 0x6f,
	0x75, 0x74, 0x12, 0x55, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x61, 0x6e, 0x63, 0x68, 0x6f,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x52, 0x0a, 0x74,
	0x65, 0x78, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x52,
	0x0c, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x12, 0x63, 0x0a,
	0x0b, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61,
	0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x2e, 0x4f, 0x72, 0x69, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x65, 0x0a, 0x0b, 0x4f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1b, 0x0a, 0x17, 0x4f, 0x52, 0x49, 0x45, 0x4e, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x50, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x50, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50,
	0x41, 0x47, 0x45, 0x5f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x50,
	0x41, 0x47, 0x45, 0x5f, 0x44, 0x4f, 0x57, 0x4e, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x41,
	0x47, 0x45, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x10, 0x04, 0x1a, 0xc6, 0x01, 0x0a, 0x05, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50,
	0x61, 0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f,
	0x75, 0x74, 0x12, 0x6e, 0x0a, 0x12, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52,
	0x11, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x73, 0x1a, 0xca, 0x01, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x61, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65,
	0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12,
	0x6e, 0x0a, 0x12, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x11, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x1a,
	0xc5, 0x01, 0x0a, 0x04, 0x4c, 0x69, 0x6e, 0x65, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f,
	0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52,
	0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x6e, 0x0a, 0x12, 0x64, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50,
	0x61, 0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x52, 0x11, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x1a, 0xe5, 0x03, 0x0a, 0x05, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67,
	0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74,
	0x12, 0x69, 0x0a, 0x0e, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x72, 0x65,
	0x61, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x2e, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x0d, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x12, 0x6e, 0x0a, 0x12, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x11, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x1a, 0xb1, 0x01, 0x0a, 0x0d,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x12, 0x5b, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x43, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x50, 0x41, 0x43,
	0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x57, 0x49, 0x44, 0x45, 0x5f, 0x53, 0x50, 0x41, 0x43,
	0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x48, 0x59, 0x50, 0x48, 0x45, 0x4e, 0x10, 0x03, 0x1a,
	0xe2, 0x01, 0x0a, 0x0d, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67,
	0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x6e, 0x0a, 0x12, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65,
	0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x52, 0x11, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x73, 0x1a, 0xe7, 0x05, 0x0a, 0x05, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x4d,
	0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x5e, 0x0a,
	0x0b, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61,
	0x67, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x6f,
	0x77, 0x52, 0x0a, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x5a, 0x0a,
	0x09, 0x62, 0x6f, 0x64, 0x79, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65,
	0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x6f, 0x77, 0x52,
	0x08, 0x62, 0x6f, 0x64, 0x79, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x6e, 0x0a, 0x12, 0x64, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x11, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x1a, 0x60, 0x0a, 0x08, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x52, 0x6f, 0x77, 0x12, 0x54, 0x0a, 0x05, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x50, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x43, 0x65, 0x6c, 0x6c, 0x52, 0x05, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x1a, 0x80, 0x02, 0x0a, 0x09,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x65, 0x6c, 0x6c, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x79,
	0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74,
	0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x72, 0x6f, 0x77, 0x5f,
	0x73, 0x70, 0x61, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x72, 0x6f, 0x77, 0x53,
	0x70, 0x61, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x6f, 0x6c, 0x5f, 0x73, 0x70, 0x61, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x6e,
	0x0a, 0x12, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x11, 0x64, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x1a, 0xad,
	0x03, 0x0a, 0x09, 0x46, 0x6f, 0x72, 0x6d, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x54, 0x0a, 0x0a,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65,
	0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x56, 0x0a, 0x0b, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x0a,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x77, 0x0a, 0x17, 0x6e, 0x61,
	0x6d, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x15, 0x6e, 0x61,
	0x6d, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x73, 0x12, 0x79, 0x0a, 0x18, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x64, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x16, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x1a, 0x57,
	0x0a, 0x10, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x1a, 0xb5, 0x01, 0x0a, 0x06, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x12, 0x55, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x61, 0x6e, 0x63, 0x68, 0x6f,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x52, 0x0a, 0x74,
	0x65, 0x78, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x78, 0x74,
	0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x1a,
	0x68, 0x0a, 0x0e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x1b, 0x0a, 0x09, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1a, 0x0a,
	0x08, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xc0, 0x01, 0x0a, 0x0a, 0x54, 0x65,
	0x78, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x12, 0x65, 0x0a, 0x0d, 0x74, 0x65, 0x78, 0x74,
	0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x41,
	0x6e, 0x63, 0x68, 0x6f, 0x72, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x0c, 0x74, 0x65, 0x78, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a,
	0x4b, 0x0a, 0x0b, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1f,
	0x0a, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x1b, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x08, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0xea, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0d,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x41, 0x49, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x41, 0x69, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02,
	0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_documentai_v1beta1_document_proto_rawDescOnce sync.Once
	file_google_cloud_documentai_v1beta1_document_proto_rawDescData = file_google_cloud_documentai_v1beta1_document_proto_rawDesc
)

func file_google_cloud_documentai_v1beta1_document_proto_rawDescGZIP() []byte {
	file_google_cloud_documentai_v1beta1_document_proto_rawDescOnce.Do(func() {
		file_google_cloud_documentai_v1beta1_document_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_documentai_v1beta1_document_proto_rawDescData)
	})
	return file_google_cloud_documentai_v1beta1_document_proto_rawDescData
}

var file_google_cloud_documentai_v1beta1_document_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_documentai_v1beta1_document_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_google_cloud_documentai_v1beta1_document_proto_goTypes = []interface{}{
	(Document_Page_Layout_Orientation)(0),       // 0: google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation
	(Document_Page_Token_DetectedBreak_Type)(0), // 1: google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type
	(*Document)(nil),                            // 2: google.cloud.documentai.v1beta1.Document
	(*Document_ShardInfo)(nil),                  // 3: google.cloud.documentai.v1beta1.Document.ShardInfo
	(*Document_Style)(nil),                      // 4: google.cloud.documentai.v1beta1.Document.Style
	(*Document_Page)(nil),                       // 5: google.cloud.documentai.v1beta1.Document.Page
	(*Document_Entity)(nil),                     // 6: google.cloud.documentai.v1beta1.Document.Entity
	(*Document_EntityRelation)(nil),             // 7: google.cloud.documentai.v1beta1.Document.EntityRelation
	(*Document_TextAnchor)(nil),                 // 8: google.cloud.documentai.v1beta1.Document.TextAnchor
	(*Document_Style_FontSize)(nil),             // 9: google.cloud.documentai.v1beta1.Document.Style.FontSize
	(*Document_Page_Dimension)(nil),             // 10: google.cloud.documentai.v1beta1.Document.Page.Dimension
	(*Document_Page_Layout)(nil),                // 11: google.cloud.documentai.v1beta1.Document.Page.Layout
	(*Document_Page_Block)(nil),                 // 12: google.cloud.documentai.v1beta1.Document.Page.Block
	(*Document_Page_Paragraph)(nil),             // 13: google.cloud.documentai.v1beta1.Document.Page.Paragraph
	(*Document_Page_Line)(nil),                  // 14: google.cloud.documentai.v1beta1.Document.Page.Line
	(*Document_Page_Token)(nil),                 // 15: google.cloud.documentai.v1beta1.Document.Page.Token
	(*Document_Page_VisualElement)(nil),         // 16: google.cloud.documentai.v1beta1.Document.Page.VisualElement
	(*Document_Page_Table)(nil),                 // 17: google.cloud.documentai.v1beta1.Document.Page.Table
	(*Document_Page_FormField)(nil),             // 18: google.cloud.documentai.v1beta1.Document.Page.FormField
	(*Document_Page_DetectedLanguage)(nil),      // 19: google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
	(*Document_Page_Token_DetectedBreak)(nil),   // 20: google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
	(*Document_Page_Table_TableRow)(nil),        // 21: google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
	(*Document_Page_Table_TableCell)(nil),       // 22: google.cloud.documentai.v1beta1.Document.Page.Table.TableCell
	(*Document_TextAnchor_TextSegment)(nil),     // 23: google.cloud.documentai.v1beta1.Document.TextAnchor.TextSegment
	(*status.Status)(nil),                       // 24: google.rpc.Status
	(*color.Color)(nil),                         // 25: google.type.Color
	(*BoundingPoly)(nil),                        // 26: google.cloud.documentai.v1beta1.BoundingPoly
}
var file_google_cloud_documentai_v1beta1_document_proto_depIdxs = []int32{
	4,  // 0: google.cloud.documentai.v1beta1.Document.text_styles:type_name -> google.cloud.documentai.v1beta1.Document.Style
	5,  // 1: google.cloud.documentai.v1beta1.Document.pages:type_name -> google.cloud.documentai.v1beta1.Document.Page
	6,  // 2: google.cloud.documentai.v1beta1.Document.entities:type_name -> google.cloud.documentai.v1beta1.Document.Entity
	7,  // 3: google.cloud.documentai.v1beta1.Document.entity_relations:type_name -> google.cloud.documentai.v1beta1.Document.EntityRelation
	3,  // 4: google.cloud.documentai.v1beta1.Document.shard_info:type_name -> google.cloud.documentai.v1beta1.Document.ShardInfo
	24, // 5: google.cloud.documentai.v1beta1.Document.error:type_name -> google.rpc.Status
	8,  // 6: google.cloud.documentai.v1beta1.Document.Style.text_anchor:type_name -> google.cloud.documentai.v1beta1.Document.TextAnchor
	25, // 7: google.cloud.documentai.v1beta1.Document.Style.color:type_name -> google.type.Color
	25, // 8: google.cloud.documentai.v1beta1.Document.Style.background_color:type_name -> google.type.Color
	9,  // 9: google.cloud.documentai.v1beta1.Document.Style.font_size:type_name -> google.cloud.documentai.v1beta1.Document.Style.FontSize
	10, // 10: google.cloud.documentai.v1beta1.Document.Page.dimension:type_name -> google.cloud.documentai.v1beta1.Document.Page.Dimension
	11, // 11: google.cloud.documentai.v1beta1.Document.Page.layout:type_name -> google.cloud.documentai.v1beta1.Document.Page.Layout
	19, // 12: google.cloud.documentai.v1beta1.Document.Page.detected_languages:type_name -> google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
	12, // 13: google.cloud.documentai.v1beta1.Document.Page.blocks:type_name -> google.cloud.documentai.v1beta1.Document.Page.Block
	13, // 14: google.cloud.documentai.v1beta1.Document.Page.paragraphs:type_name -> google.cloud.documentai.v1beta1.Document.Page.Paragraph
	14, // 15: google.cloud.documentai.v1beta1.Document.Page.lines:type_name -> google.cloud.documentai.v1beta1.Document.Page.Line
	15, // 16: google.cloud.documentai.v1beta1.Document.Page.tokens:type_name -> google.cloud.documentai.v1beta1.Document.Page.Token
	16, // 17: google.cloud.documentai.v1beta1.Document.Page.visual_elements:type_name -> google.cloud.documentai.v1beta1.Document.Page.VisualElement
	17, // 18: google.cloud.documentai.v1beta1.Document.Page.tables:type_name -> google.cloud.documentai.v1beta1.Document.Page.Table
	18, // 19: google.cloud.documentai.v1beta1.Document.Page.form_fields:type_name -> google.cloud.documentai.v1beta1.Document.Page.FormField
	8,  // 20: google.cloud.documentai.v1beta1.Document.Entity.text_anchor:type_name -> google.cloud.documentai.v1beta1.Document.TextAnchor
	23, // 21: google.cloud.documentai.v1beta1.Document.TextAnchor.text_segments:type_name -> google.cloud.documentai.v1beta1.Document.TextAnchor.TextSegment
	8,  // 22: google.cloud.documentai.v1beta1.Document.Page.Layout.text_anchor:type_name -> google.cloud.documentai.v1beta1.Document.TextAnchor
	26, // 23: google.cloud.documentai.v1beta1.Document.Page.Layout.bounding_poly:type_name -> google.cloud.documentai.v1beta1.BoundingPoly
	0,  // 24: google.cloud.documentai.v1beta1.Document.Page.Layout.orientation:type_name -> google.cloud.documentai.v1beta1.Document.Page.Layout.Orientation
	11, // 25: google.cloud.documentai.v1beta1.Document.Page.Block.layout:type_name -> google.cloud.documentai.v1beta1.Document.Page.Layout
	19, // 26: google.cloud.documentai.v1beta1.Document.Page.Block.detected_languages:type_name -> google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
	11, // 27: google.cloud.documentai.v1beta1.Document.Page.Paragraph.layout:type_name -> google.cloud.documentai.v1beta1.Document.Page.Layout
	19, // 28: google.cloud.documentai.v1beta1.Document.Page.Paragraph.detected_languages:type_name -> google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
	11, // 29: google.cloud.documentai.v1beta1.Document.Page.Line.layout:type_name -> google.cloud.documentai.v1beta1.Document.Page.Layout
	19, // 30: google.cloud.documentai.v1beta1.Document.Page.Line.detected_languages:type_name -> google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
	11, // 31: google.cloud.documentai.v1beta1.Document.Page.Token.layout:type_name -> google.cloud.documentai.v1beta1.Document.Page.Layout
	20, // 32: google.cloud.documentai.v1beta1.Document.Page.Token.detected_break:type_name -> google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak
	19, // 33: google.cloud.documentai.v1beta1.Document.Page.Token.detected_languages:type_name -> google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
	11, // 34: google.cloud.documentai.v1beta1.Document.Page.VisualElement.layout:type_name -> google.cloud.documentai.v1beta1.Document.Page.Layout
	19, // 35: google.cloud.documentai.v1beta1.Document.Page.VisualElement.detected_languages:type_name -> google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
	11, // 36: google.cloud.documentai.v1beta1.Document.Page.Table.layout:type_name -> google.cloud.documentai.v1beta1.Document.Page.Layout
	21, // 37: google.cloud.documentai.v1beta1.Document.Page.Table.header_rows:type_name -> google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
	21, // 38: google.cloud.documentai.v1beta1.Document.Page.Table.body_rows:type_name -> google.cloud.documentai.v1beta1.Document.Page.Table.TableRow
	19, // 39: google.cloud.documentai.v1beta1.Document.Page.Table.detected_languages:type_name -> google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
	11, // 40: google.cloud.documentai.v1beta1.Document.Page.FormField.field_name:type_name -> google.cloud.documentai.v1beta1.Document.Page.Layout
	11, // 41: google.cloud.documentai.v1beta1.Document.Page.FormField.field_value:type_name -> google.cloud.documentai.v1beta1.Document.Page.Layout
	19, // 42: google.cloud.documentai.v1beta1.Document.Page.FormField.name_detected_languages:type_name -> google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
	19, // 43: google.cloud.documentai.v1beta1.Document.Page.FormField.value_detected_languages:type_name -> google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
	1,  // 44: google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.type:type_name -> google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak.Type
	22, // 45: google.cloud.documentai.v1beta1.Document.Page.Table.TableRow.cells:type_name -> google.cloud.documentai.v1beta1.Document.Page.Table.TableCell
	11, // 46: google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.layout:type_name -> google.cloud.documentai.v1beta1.Document.Page.Layout
	19, // 47: google.cloud.documentai.v1beta1.Document.Page.Table.TableCell.detected_languages:type_name -> google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage
	48, // [48:48] is the sub-list for method output_type
	48, // [48:48] is the sub-list for method input_type
	48, // [48:48] is the sub-list for extension type_name
	48, // [48:48] is the sub-list for extension extendee
	0,  // [0:48] is the sub-list for field type_name
}

func init() { file_google_cloud_documentai_v1beta1_document_proto_init() }
func file_google_cloud_documentai_v1beta1_document_proto_init() {
	if File_google_cloud_documentai_v1beta1_document_proto != nil {
		return
	}
	file_google_cloud_documentai_v1beta1_geometry_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_ShardInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Style); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Entity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_EntityRelation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_TextAnchor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Style_FontSize); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Dimension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Layout); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Block); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Paragraph); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Line); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Token); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_VisualElement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Table); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_FormField); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_DetectedLanguage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Token_DetectedBreak); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Table_TableRow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Table_TableCell); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta1_document_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_TextAnchor_TextSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_documentai_v1beta1_document_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Document_Uri)(nil),
		(*Document_Content)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_documentai_v1beta1_document_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_documentai_v1beta1_document_proto_goTypes,
		DependencyIndexes: file_google_cloud_documentai_v1beta1_document_proto_depIdxs,
		EnumInfos:         file_google_cloud_documentai_v1beta1_document_proto_enumTypes,
		MessageInfos:      file_google_cloud_documentai_v1beta1_document_proto_msgTypes,
	}.Build()
	File_google_cloud_documentai_v1beta1_document_proto = out.File
	file_google_cloud_documentai_v1beta1_document_proto_rawDesc = nil
	file_google_cloud_documentai_v1beta1_document_proto_goTypes = nil
	file_google_cloud_documentai_v1beta1_document_proto_depIdxs = nil
}
