// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/cloud/accessapproval/v1/accessapproval.proto

package accessapproval

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Represents the type of enrollment for a given service to Access Approval.
type EnrollmentLevel int32

const (
	// Default value for proto, shouldn't be used.
	EnrollmentLevel_ENROLLMENT_LEVEL_UNSPECIFIED EnrollmentLevel = 0
	// Service is enrolled in Access Approval for all requests
	EnrollmentLevel_BLOCK_ALL EnrollmentLevel = 1
)

// Enum value maps for EnrollmentLevel.
var (
	EnrollmentLevel_name = map[int32]string{
		0: "ENROLLMENT_LEVEL_UNSPECIFIED",
		1: "BLOCK_ALL",
	}
	EnrollmentLevel_value = map[string]int32{
		"ENROLLMENT_LEVEL_UNSPECIFIED": 0,
		"BLOCK_ALL":                    1,
	}
)

func (x EnrollmentLevel) Enum() *EnrollmentLevel {
	p := new(EnrollmentLevel)
	*p = x
	return p
}

func (x EnrollmentLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EnrollmentLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_enumTypes[0].Descriptor()
}

func (EnrollmentLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_accessapproval_v1_accessapproval_proto_enumTypes[0]
}

func (x EnrollmentLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EnrollmentLevel.Descriptor instead.
func (EnrollmentLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{0}
}

// Type of access justification.
type AccessReason_Type int32

const (
	// Default value for proto, shouldn't be used.
	AccessReason_TYPE_UNSPECIFIED AccessReason_Type = 0
	// Customer made a request or raised an issue that required the principal to
	// access customer data. `detail` is of the form ("#####" is the issue ID):
	// <ol>
	//   <li>"Feedback Report: #####"</li>
	//   <li>"Case Number: #####"</li>
	//   <li>"Case ID: #####"</li>
	//   <li>"E-PIN Reference: #####"</li>
	//   <li>"Google-#####"</li>
	//   <li>"T-#####"</li>
	// </ol>
	AccessReason_CUSTOMER_INITIATED_SUPPORT AccessReason_Type = 1
	// The principal accessed customer data in order to diagnose or resolve a
	// suspected issue in services or a known outage. Often this access is used
	// to confirm that customers are not affected by a suspected service issue
	// or to remediate a reversible system issue.
	AccessReason_GOOGLE_INITIATED_SERVICE AccessReason_Type = 2
	// Google initiated service for security, fraud, abuse, or compliance
	// purposes.
	AccessReason_GOOGLE_INITIATED_REVIEW AccessReason_Type = 3
)

// Enum value maps for AccessReason_Type.
var (
	AccessReason_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "CUSTOMER_INITIATED_SUPPORT",
		2: "GOOGLE_INITIATED_SERVICE",
		3: "GOOGLE_INITIATED_REVIEW",
	}
	AccessReason_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":           0,
		"CUSTOMER_INITIATED_SUPPORT": 1,
		"GOOGLE_INITIATED_SERVICE":   2,
		"GOOGLE_INITIATED_REVIEW":    3,
	}
)

func (x AccessReason_Type) Enum() *AccessReason_Type {
	p := new(AccessReason_Type)
	*p = x
	return p
}

func (x AccessReason_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessReason_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_enumTypes[1].Descriptor()
}

func (AccessReason_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_accessapproval_v1_accessapproval_proto_enumTypes[1]
}

func (x AccessReason_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessReason_Type.Descriptor instead.
func (AccessReason_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{1, 0}
}

// Home office and physical location of the principal.
type AccessLocations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The "home office" location of the principal. A two-letter country code
	// (ISO 3166-1 alpha-2), such as "US", "DE" or "GB" or a region code. In some
	// limited situations Google systems may refer refer to a region code instead
	// of a country code.
	// Possible Region Codes:
	// <ol>
	//   <li>ASI: Asia</li>
	//   <li>EUR: Europe</li>
	//   <li>OCE: Oceania</li>
	//   <li>AFR: Africa</li>
	//   <li>NAM: North America</li>
	//   <li>SAM: South America</li>
	//   <li>ANT: Antarctica</li>
	//   <li>ANY: Any location</li>
	// </ol>
	PrincipalOfficeCountry string `protobuf:"bytes,1,opt,name=principal_office_country,json=principalOfficeCountry,proto3" json:"principal_office_country,omitempty"`
	// Physical location of the principal at the time of the access. A
	// two-letter country code (ISO 3166-1 alpha-2), such as "US", "DE" or "GB" or
	// a region code. In some limited situations Google systems may refer refer to
	// a region code instead of a country code.
	// Possible Region Codes:
	// <ol>
	//   <li>ASI: Asia</li>
	//   <li>EUR: Europe</li>
	//   <li>OCE: Oceania</li>
	//   <li>AFR: Africa</li>
	//   <li>NAM: North America</li>
	//   <li>SAM: South America</li>
	//   <li>ANT: Antarctica</li>
	//   <li>ANY: Any location</li>
	// </ol>
	PrincipalPhysicalLocationCountry string `protobuf:"bytes,2,opt,name=principal_physical_location_country,json=principalPhysicalLocationCountry,proto3" json:"principal_physical_location_country,omitempty"`
}

func (x *AccessLocations) Reset() {
	*x = AccessLocations{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessLocations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessLocations) ProtoMessage() {}

func (x *AccessLocations) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessLocations.ProtoReflect.Descriptor instead.
func (*AccessLocations) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{0}
}

func (x *AccessLocations) GetPrincipalOfficeCountry() string {
	if x != nil {
		return x.PrincipalOfficeCountry
	}
	return ""
}

func (x *AccessLocations) GetPrincipalPhysicalLocationCountry() string {
	if x != nil {
		return x.PrincipalPhysicalLocationCountry
	}
	return ""
}

type AccessReason struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of access justification.
	Type AccessReason_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.accessapproval.v1.AccessReason_Type" json:"type,omitempty"`
	// More detail about certain reason types. See comments for each type above.
	Detail string `protobuf:"bytes,2,opt,name=detail,proto3" json:"detail,omitempty"`
}

func (x *AccessReason) Reset() {
	*x = AccessReason{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessReason) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessReason) ProtoMessage() {}

func (x *AccessReason) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessReason.ProtoReflect.Descriptor instead.
func (*AccessReason) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{1}
}

func (x *AccessReason) GetType() AccessReason_Type {
	if x != nil {
		return x.Type
	}
	return AccessReason_TYPE_UNSPECIFIED
}

func (x *AccessReason) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

// A decision that has been made to approve access to a resource.
type ApproveDecision struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time at which approval was granted.
	ApproveTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=approve_time,json=approveTime,proto3" json:"approve_time,omitempty"`
	// The time at which the approval expires.
	ExpireTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
}

func (x *ApproveDecision) Reset() {
	*x = ApproveDecision{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApproveDecision) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveDecision) ProtoMessage() {}

func (x *ApproveDecision) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveDecision.ProtoReflect.Descriptor instead.
func (*ApproveDecision) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{2}
}

func (x *ApproveDecision) GetApproveTime() *timestamp.Timestamp {
	if x != nil {
		return x.ApproveTime
	}
	return nil
}

func (x *ApproveDecision) GetExpireTime() *timestamp.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

// A decision that has been made to dismiss an approval request.
type DismissDecision struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time at which the approval request was dismissed.
	DismissTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=dismiss_time,json=dismissTime,proto3" json:"dismiss_time,omitempty"`
}

func (x *DismissDecision) Reset() {
	*x = DismissDecision{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DismissDecision) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DismissDecision) ProtoMessage() {}

func (x *DismissDecision) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DismissDecision.ProtoReflect.Descriptor instead.
func (*DismissDecision) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{3}
}

func (x *DismissDecision) GetDismissTime() *timestamp.Timestamp {
	if x != nil {
		return x.DismissTime
	}
	return nil
}

// The properties associated with the resource of the request.
type ResourceProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether an approval will exclude the descendants of the resource being
	// requested.
	ExcludesDescendants bool `protobuf:"varint,1,opt,name=excludes_descendants,json=excludesDescendants,proto3" json:"excludes_descendants,omitempty"`
}

func (x *ResourceProperties) Reset() {
	*x = ResourceProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceProperties) ProtoMessage() {}

func (x *ResourceProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceProperties.ProtoReflect.Descriptor instead.
func (*ResourceProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{4}
}

func (x *ResourceProperties) GetExcludesDescendants() bool {
	if x != nil {
		return x.ExcludesDescendants
	}
	return false
}

// A request for the customer to approve access to a resource.
type ApprovalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the request. Format is
	// "{projects|folders|organizations}/{id}/approvalRequests/{approval_request_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource for which approval is being requested. The format of the
	// resource name is defined at
	// https://cloud.google.com/apis/design/resource_names. The resource name here
	// may either be a "full" resource name (e.g.
	// "//library.googleapis.com/shelves/shelf1/books/book2") or a "relative"
	// resource name (e.g. "shelves/shelf1/books/book2") as described in the
	// resource name specification.
	RequestedResourceName string `protobuf:"bytes,2,opt,name=requested_resource_name,json=requestedResourceName,proto3" json:"requested_resource_name,omitempty"`
	// Properties related to the resource represented by requested_resource_name.
	RequestedResourceProperties *ResourceProperties `protobuf:"bytes,9,opt,name=requested_resource_properties,json=requestedResourceProperties,proto3" json:"requested_resource_properties,omitempty"`
	// The justification for which approval is being requested.
	RequestedReason *AccessReason `protobuf:"bytes,3,opt,name=requested_reason,json=requestedReason,proto3" json:"requested_reason,omitempty"`
	// The locations for which approval is being requested.
	RequestedLocations *AccessLocations `protobuf:"bytes,4,opt,name=requested_locations,json=requestedLocations,proto3" json:"requested_locations,omitempty"`
	// The time at which approval was requested.
	RequestTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=request_time,json=requestTime,proto3" json:"request_time,omitempty"`
	// The requested expiration for the approval. If the request is approved,
	// access will be granted from the time of approval until the expiration time.
	RequestedExpiration *timestamp.Timestamp `protobuf:"bytes,6,opt,name=requested_expiration,json=requestedExpiration,proto3" json:"requested_expiration,omitempty"`
	// The current decision on the approval request.
	//
	// Types that are assignable to Decision:
	//	*ApprovalRequest_Approve
	//	*ApprovalRequest_Dismiss
	Decision isApprovalRequest_Decision `protobuf_oneof:"decision"`
}

func (x *ApprovalRequest) Reset() {
	*x = ApprovalRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApprovalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApprovalRequest) ProtoMessage() {}

func (x *ApprovalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApprovalRequest.ProtoReflect.Descriptor instead.
func (*ApprovalRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{5}
}

func (x *ApprovalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ApprovalRequest) GetRequestedResourceName() string {
	if x != nil {
		return x.RequestedResourceName
	}
	return ""
}

func (x *ApprovalRequest) GetRequestedResourceProperties() *ResourceProperties {
	if x != nil {
		return x.RequestedResourceProperties
	}
	return nil
}

func (x *ApprovalRequest) GetRequestedReason() *AccessReason {
	if x != nil {
		return x.RequestedReason
	}
	return nil
}

func (x *ApprovalRequest) GetRequestedLocations() *AccessLocations {
	if x != nil {
		return x.RequestedLocations
	}
	return nil
}

func (x *ApprovalRequest) GetRequestTime() *timestamp.Timestamp {
	if x != nil {
		return x.RequestTime
	}
	return nil
}

func (x *ApprovalRequest) GetRequestedExpiration() *timestamp.Timestamp {
	if x != nil {
		return x.RequestedExpiration
	}
	return nil
}

func (m *ApprovalRequest) GetDecision() isApprovalRequest_Decision {
	if m != nil {
		return m.Decision
	}
	return nil
}

func (x *ApprovalRequest) GetApprove() *ApproveDecision {
	if x, ok := x.GetDecision().(*ApprovalRequest_Approve); ok {
		return x.Approve
	}
	return nil
}

func (x *ApprovalRequest) GetDismiss() *DismissDecision {
	if x, ok := x.GetDecision().(*ApprovalRequest_Dismiss); ok {
		return x.Dismiss
	}
	return nil
}

type isApprovalRequest_Decision interface {
	isApprovalRequest_Decision()
}

type ApprovalRequest_Approve struct {
	// Access was approved.
	Approve *ApproveDecision `protobuf:"bytes,7,opt,name=approve,proto3,oneof"`
}

type ApprovalRequest_Dismiss struct {
	// The request was dismissed.
	Dismiss *DismissDecision `protobuf:"bytes,8,opt,name=dismiss,proto3,oneof"`
}

func (*ApprovalRequest_Approve) isApprovalRequest_Decision() {}

func (*ApprovalRequest_Dismiss) isApprovalRequest_Decision() {}

// Represents the enrollment of a cloud resource into a specific service.
type EnrolledService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The product for which Access Approval will be enrolled. Allowed values are
	// listed below (case-sensitive):
	// <ol>
	//   <li>all</li>
	//   <li>appengine.googleapis.com</li>
	//   <li>bigquery.googleapis.com</li>
	//   <li>bigtable.googleapis.com</li>
	//   <li>cloudkms.googleapis.com</li>
	//   <li>compute.googleapis.com</li>
	//   <li>dataflow.googleapis.com</li>
	//   <li>iam.googleapis.com</li>
	//   <li>pubsub.googleapis.com</li>
	//   <li>storage.googleapis.com</li>
	// <ol>
	CloudProduct string `protobuf:"bytes,1,opt,name=cloud_product,json=cloudProduct,proto3" json:"cloud_product,omitempty"`
	// The enrollment level of the service.
	EnrollmentLevel EnrollmentLevel `protobuf:"varint,2,opt,name=enrollment_level,json=enrollmentLevel,proto3,enum=google.cloud.accessapproval.v1.EnrollmentLevel" json:"enrollment_level,omitempty"`
}

func (x *EnrolledService) Reset() {
	*x = EnrolledService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnrolledService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnrolledService) ProtoMessage() {}

func (x *EnrolledService) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnrolledService.ProtoReflect.Descriptor instead.
func (*EnrolledService) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{6}
}

func (x *EnrolledService) GetCloudProduct() string {
	if x != nil {
		return x.CloudProduct
	}
	return ""
}

func (x *EnrolledService) GetEnrollmentLevel() EnrollmentLevel {
	if x != nil {
		return x.EnrollmentLevel
	}
	return EnrollmentLevel_ENROLLMENT_LEVEL_UNSPECIFIED
}

// Settings on a Project/Folder/Organization related to Access Approval.
type AccessApprovalSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the settings. Format is one of:
	// <ol>
	//   <li>"projects/{project_id}/accessApprovalSettings"</li>
	//   <li>"folders/{folder_id}/accessApprovalSettings"</li>
	//   <li>"organizations/{organization_id}/accessApprovalSettings"</li>
	// <ol>
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of email addresses to which notifications relating to approval
	// requests should be sent. Notifications relating to a resource will be sent
	// to all emails in the settings of ancestor resources of that resource. A
	// maximum of 50 email addresses are allowed.
	NotificationEmails []string `protobuf:"bytes,2,rep,name=notification_emails,json=notificationEmails,proto3" json:"notification_emails,omitempty"`
	// A list of Google Cloud Services for which the given resource has Access
	// Approval enrolled. Access requests for the resource given by name against
	// any of these services contained here will be required to have explicit
	// approval. If name refers to an organization, enrollment can be done for
	// individual services. If name refers to a folder or project, enrollment can
	// only be done on an all or nothing basis.
	//
	// If a cloud_product is repeated in this list, the first entry will be
	// honored and all following entries will be discarded. A maximum of 10
	// enrolled services will be enforced, to be expanded as the set of supported
	// services is expanded.
	EnrolledServices []*EnrolledService `protobuf:"bytes,3,rep,name=enrolled_services,json=enrolledServices,proto3" json:"enrolled_services,omitempty"`
	// Output only. This field is read only (not settable via
	// UpdateAccessAccessApprovalSettings method). If the field is true, that
	// indicates that at least one service is enrolled for Access Approval in one
	// or more ancestors of the Project or Folder (this field will always be
	// unset for the organization since organizations do not have ancestors).
	EnrolledAncestor bool `protobuf:"varint,4,opt,name=enrolled_ancestor,json=enrolledAncestor,proto3" json:"enrolled_ancestor,omitempty"`
}

func (x *AccessApprovalSettings) Reset() {
	*x = AccessApprovalSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessApprovalSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessApprovalSettings) ProtoMessage() {}

func (x *AccessApprovalSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessApprovalSettings.ProtoReflect.Descriptor instead.
func (*AccessApprovalSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{7}
}

func (x *AccessApprovalSettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AccessApprovalSettings) GetNotificationEmails() []string {
	if x != nil {
		return x.NotificationEmails
	}
	return nil
}

func (x *AccessApprovalSettings) GetEnrolledServices() []*EnrolledService {
	if x != nil {
		return x.EnrolledServices
	}
	return nil
}

func (x *AccessApprovalSettings) GetEnrolledAncestor() bool {
	if x != nil {
		return x.EnrolledAncestor
	}
	return false
}

// Request to list approval requests.
type ListApprovalRequestsMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent resource. This may be "projects/{project_id}",
	// "folders/{folder_id}", or "organizations/{organization_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A filter on the type of approval requests to retrieve. Must be one of the
	// following values:
	// <ol>
	//   <li>[not set]: Requests that are pending or have active approvals.</li>
	//   <li>ALL: All requests.</li>
	//   <li>PENDING: Only pending requests.</li>
	//   <li>ACTIVE: Only active (i.e. currently approved) requests.</li>
	//   <li>DISMISSED: Only dismissed (including expired) requests.</li>
	// </ol>
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying the page of results to return.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListApprovalRequestsMessage) Reset() {
	*x = ListApprovalRequestsMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListApprovalRequestsMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListApprovalRequestsMessage) ProtoMessage() {}

func (x *ListApprovalRequestsMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListApprovalRequestsMessage.ProtoReflect.Descriptor instead.
func (*ListApprovalRequestsMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{8}
}

func (x *ListApprovalRequestsMessage) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListApprovalRequestsMessage) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListApprovalRequestsMessage) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListApprovalRequestsMessage) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response to listing of ApprovalRequest objects.
type ListApprovalRequestsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Approval request details.
	ApprovalRequests []*ApprovalRequest `protobuf:"bytes,1,rep,name=approval_requests,json=approvalRequests,proto3" json:"approval_requests,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListApprovalRequestsResponse) Reset() {
	*x = ListApprovalRequestsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListApprovalRequestsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListApprovalRequestsResponse) ProtoMessage() {}

func (x *ListApprovalRequestsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListApprovalRequestsResponse.ProtoReflect.Descriptor instead.
func (*ListApprovalRequestsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{9}
}

func (x *ListApprovalRequestsResponse) GetApprovalRequests() []*ApprovalRequest {
	if x != nil {
		return x.ApprovalRequests
	}
	return nil
}

func (x *ListApprovalRequestsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to get an approval request.
type GetApprovalRequestMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the approval request to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetApprovalRequestMessage) Reset() {
	*x = GetApprovalRequestMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetApprovalRequestMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetApprovalRequestMessage) ProtoMessage() {}

func (x *GetApprovalRequestMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetApprovalRequestMessage.ProtoReflect.Descriptor instead.
func (*GetApprovalRequestMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{10}
}

func (x *GetApprovalRequestMessage) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to approve an ApprovalRequest.
type ApproveApprovalRequestMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the approval request to approve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The expiration time of this approval.
	ExpireTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
}

func (x *ApproveApprovalRequestMessage) Reset() {
	*x = ApproveApprovalRequestMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApproveApprovalRequestMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveApprovalRequestMessage) ProtoMessage() {}

func (x *ApproveApprovalRequestMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveApprovalRequestMessage.ProtoReflect.Descriptor instead.
func (*ApproveApprovalRequestMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{11}
}

func (x *ApproveApprovalRequestMessage) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ApproveApprovalRequestMessage) GetExpireTime() *timestamp.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

// Request to dismiss an approval request.
type DismissApprovalRequestMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the ApprovalRequest to dismiss.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DismissApprovalRequestMessage) Reset() {
	*x = DismissApprovalRequestMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DismissApprovalRequestMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DismissApprovalRequestMessage) ProtoMessage() {}

func (x *DismissApprovalRequestMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DismissApprovalRequestMessage.ProtoReflect.Descriptor instead.
func (*DismissApprovalRequestMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{12}
}

func (x *DismissApprovalRequestMessage) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to get access approval settings.
type GetAccessApprovalSettingsMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the AccessApprovalSettings to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAccessApprovalSettingsMessage) Reset() {
	*x = GetAccessApprovalSettingsMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAccessApprovalSettingsMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAccessApprovalSettingsMessage) ProtoMessage() {}

func (x *GetAccessApprovalSettingsMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAccessApprovalSettingsMessage.ProtoReflect.Descriptor instead.
func (*GetAccessApprovalSettingsMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{13}
}

func (x *GetAccessApprovalSettingsMessage) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to update access approval settings.
type UpdateAccessApprovalSettingsMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The new AccessApprovalSettings.
	Settings *AccessApprovalSettings `protobuf:"bytes,1,opt,name=settings,proto3" json:"settings,omitempty"`
	// The update mask applies to the settings. Only the top level fields of
	// AccessApprovalSettings (notification_emails & enrolled_services) are
	// supported. For each field, if it is included, the currently stored value
	// will be entirely overwritten with the value of the field passed in this
	// request.
	//
	// For the `FieldMask` definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	// If this field is left unset, only the notification_emails field will be
	// updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAccessApprovalSettingsMessage) Reset() {
	*x = UpdateAccessApprovalSettingsMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAccessApprovalSettingsMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAccessApprovalSettingsMessage) ProtoMessage() {}

func (x *UpdateAccessApprovalSettingsMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAccessApprovalSettingsMessage.ProtoReflect.Descriptor instead.
func (*UpdateAccessApprovalSettingsMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateAccessApprovalSettingsMessage) GetSettings() *AccessApprovalSettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *UpdateAccessApprovalSettingsMessage) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to delete access approval settings.
type DeleteAccessApprovalSettingsMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the AccessApprovalSettings to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAccessApprovalSettingsMessage) Reset() {
	*x = DeleteAccessApprovalSettingsMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAccessApprovalSettingsMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAccessApprovalSettingsMessage) ProtoMessage() {}

func (x *DeleteAccessApprovalSettingsMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAccessApprovalSettingsMessage.ProtoReflect.Descriptor instead.
func (*DeleteAccessApprovalSettingsMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteAccessApprovalSettingsMessage) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_accessapproval_v1_accessapproval_proto protoreflect.FileDescriptor

var file_google_cloud_accessapproval_v1_accessapproval_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2f, 0x76, 0x31,
	0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76,
	0x61, 0x6c, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9a, 0x01,
	0x0a, 0x0f, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x38, 0x0a, 0x18, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x6f,
	0x66, 0x66, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x16, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x4f, 0x66,
	0x66, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x4d, 0x0a, 0x23, 0x70,
	0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61,
	0x6c, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x20, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x50, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x22, 0xe6, 0x01, 0x0a, 0x0c, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0x77, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x55, 0x53, 0x54,
	0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x53,
	0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x47, 0x4f, 0x4f, 0x47,
	0x4c, 0x45, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x45, 0x52,
	0x56, 0x49, 0x43, 0x45, 0x10, 0x02, 0x12, 0x1b, 0x0a, 0x17, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45,
	0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x56, 0x49, 0x45,
	0x57, 0x10, 0x03, 0x22, 0x8d, 0x01, 0x0a, 0x0f, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x44,
	0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x0c, 0x61, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0x50, 0x0a, 0x0f, 0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x44, 0x65,
	0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6d, 0x69, 0x73,
	0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x6d, 0x69, 0x73,
	0x73, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x47, 0x0a, 0x12, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x14, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61,
	0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x73, 0x44, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x74, 0x73, 0x22, 0xc4,
	0x05, 0x0a, 0x0f, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x76,
	0x0a, 0x1d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x1b, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x0f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12,
	0x60, 0x0a, 0x13, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x12, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x3d, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x4d, 0x0a, 0x14, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x13, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x45, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x4b, 0x0a, 0x07, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x44, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x07, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x12, 0x4b, 0x0a, 0x07,
	0x64, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x44, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x07, 0x64, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x42, 0x0a, 0x0a, 0x08, 0x64, 0x65, 0x63,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x92, 0x01, 0x0a, 0x0f, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x5a,
	0x0a, 0x10, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x65, 0x76,
	0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70,
	0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c,
	0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0f, 0x65, 0x6e, 0x72, 0x6f, 0x6c,
	0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0xed, 0x01, 0x0a, 0x16, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x6e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x5c, 0x0a, 0x11, 0x65, 0x6e,
	0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x10, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x11, 0x65, 0x6e, 0x72, 0x6f,
	0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x64, 0x41, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x22, 0x89, 0x01, 0x0a, 0x1b, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5c, 0x0a, 0x11, 0x61, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x52, 0x10, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x2f, 0x0a,
	0x19, 0x47, 0x65, 0x74, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x70,
	0x0a, 0x1d, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0x33, 0x0a, 0x1d, 0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x36, 0x0a, 0x20, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb6, 0x01,
	0x0a, 0x23, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x41, 0x70,
	0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x52, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x41,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52,
	0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x39, 0x0a, 0x23, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x2a, 0x42, 0x0a, 0x0f, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x20, 0x0a, 0x1c, 0x45, 0x4e, 0x52, 0x4f, 0x4c, 0x4c, 0x4d, 0x45,
	0x4e, 0x54, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f,
	0x41, 0x4c, 0x4c, 0x10, 0x01, 0x32, 0x88, 0x12, 0x0a, 0x0e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x12, 0xaa, 0x02, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x96, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x86, 0x01, 0x12, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73,
	0x5a, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x5a, 0x2f, 0x12, 0x2d, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x97, 0x02, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x41, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x94, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x86, 0x01, 0x12, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x29, 0x12, 0x27,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xb9, 0x02, 0x0a, 0x16, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x41, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xae, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0xa7, 0x01, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x3a, 0x01, 0x2a, 0x5a, 0x34, 0x22, 0x2f, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x3a, 0x01, 0x2a, 0x5a,
	0x3a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0xb9, 0x02, 0x0a, 0x16,
	0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x41,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xae, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa7, 0x01,
	0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x69, 0x73, 0x6d, 0x69,
	0x73, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x34, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x64, 0x69, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x3a, 0x22, 0x35, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x69, 0x73,
	0x6d, 0x69, 0x73, 0x73, 0x3a, 0x01, 0x2a, 0x12, 0xb8, 0x02, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x41,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22,
	0xa0, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x92, 0x01, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x5a, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x5a, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76,
	0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x87, 0x03, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70,
	0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x22, 0xe9, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xcb, 0x01, 0x32, 0x35, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x7d, 0x3a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x5a, 0x40, 0x32, 0x34, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x7d, 0x3a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x5a, 0x46, 0x32,
	0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76,
	0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0x3a, 0x08, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0xda, 0x41, 0x14, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x9e, 0x02, 0x0a,
	0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x41, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0xa0, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x92, 0x01, 0x2a, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x7d, 0x5a, 0x2d, 0x2a, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x7d, 0x5a, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x51, 0xca,
	0x41, 0x1d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0xad, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x61, 0x6c, 0x2e, 0x76, 0x31, 0x42, 0x13, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x41,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x2f, 0x76, 0x31, 0x3b, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0xea, 0x02, 0x21, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescOnce sync.Once
	file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescData = file_google_cloud_accessapproval_v1_accessapproval_proto_rawDesc
)

func file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescGZIP() []byte {
	file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescOnce.Do(func() {
		file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescData)
	})
	return file_google_cloud_accessapproval_v1_accessapproval_proto_rawDescData
}

var file_google_cloud_accessapproval_v1_accessapproval_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_google_cloud_accessapproval_v1_accessapproval_proto_goTypes = []interface{}{
	(EnrollmentLevel)(0),                        // 0: google.cloud.accessapproval.v1.EnrollmentLevel
	(AccessReason_Type)(0),                      // 1: google.cloud.accessapproval.v1.AccessReason.Type
	(*AccessLocations)(nil),                     // 2: google.cloud.accessapproval.v1.AccessLocations
	(*AccessReason)(nil),                        // 3: google.cloud.accessapproval.v1.AccessReason
	(*ApproveDecision)(nil),                     // 4: google.cloud.accessapproval.v1.ApproveDecision
	(*DismissDecision)(nil),                     // 5: google.cloud.accessapproval.v1.DismissDecision
	(*ResourceProperties)(nil),                  // 6: google.cloud.accessapproval.v1.ResourceProperties
	(*ApprovalRequest)(nil),                     // 7: google.cloud.accessapproval.v1.ApprovalRequest
	(*EnrolledService)(nil),                     // 8: google.cloud.accessapproval.v1.EnrolledService
	(*AccessApprovalSettings)(nil),              // 9: google.cloud.accessapproval.v1.AccessApprovalSettings
	(*ListApprovalRequestsMessage)(nil),         // 10: google.cloud.accessapproval.v1.ListApprovalRequestsMessage
	(*ListApprovalRequestsResponse)(nil),        // 11: google.cloud.accessapproval.v1.ListApprovalRequestsResponse
	(*GetApprovalRequestMessage)(nil),           // 12: google.cloud.accessapproval.v1.GetApprovalRequestMessage
	(*ApproveApprovalRequestMessage)(nil),       // 13: google.cloud.accessapproval.v1.ApproveApprovalRequestMessage
	(*DismissApprovalRequestMessage)(nil),       // 14: google.cloud.accessapproval.v1.DismissApprovalRequestMessage
	(*GetAccessApprovalSettingsMessage)(nil),    // 15: google.cloud.accessapproval.v1.GetAccessApprovalSettingsMessage
	(*UpdateAccessApprovalSettingsMessage)(nil), // 16: google.cloud.accessapproval.v1.UpdateAccessApprovalSettingsMessage
	(*DeleteAccessApprovalSettingsMessage)(nil), // 17: google.cloud.accessapproval.v1.DeleteAccessApprovalSettingsMessage
	(*timestamp.Timestamp)(nil),                 // 18: google.protobuf.Timestamp
	(*field_mask.FieldMask)(nil),                // 19: google.protobuf.FieldMask
	(*empty.Empty)(nil),                         // 20: google.protobuf.Empty
}
var file_google_cloud_accessapproval_v1_accessapproval_proto_depIdxs = []int32{
	1,  // 0: google.cloud.accessapproval.v1.AccessReason.type:type_name -> google.cloud.accessapproval.v1.AccessReason.Type
	18, // 1: google.cloud.accessapproval.v1.ApproveDecision.approve_time:type_name -> google.protobuf.Timestamp
	18, // 2: google.cloud.accessapproval.v1.ApproveDecision.expire_time:type_name -> google.protobuf.Timestamp
	18, // 3: google.cloud.accessapproval.v1.DismissDecision.dismiss_time:type_name -> google.protobuf.Timestamp
	6,  // 4: google.cloud.accessapproval.v1.ApprovalRequest.requested_resource_properties:type_name -> google.cloud.accessapproval.v1.ResourceProperties
	3,  // 5: google.cloud.accessapproval.v1.ApprovalRequest.requested_reason:type_name -> google.cloud.accessapproval.v1.AccessReason
	2,  // 6: google.cloud.accessapproval.v1.ApprovalRequest.requested_locations:type_name -> google.cloud.accessapproval.v1.AccessLocations
	18, // 7: google.cloud.accessapproval.v1.ApprovalRequest.request_time:type_name -> google.protobuf.Timestamp
	18, // 8: google.cloud.accessapproval.v1.ApprovalRequest.requested_expiration:type_name -> google.protobuf.Timestamp
	4,  // 9: google.cloud.accessapproval.v1.ApprovalRequest.approve:type_name -> google.cloud.accessapproval.v1.ApproveDecision
	5,  // 10: google.cloud.accessapproval.v1.ApprovalRequest.dismiss:type_name -> google.cloud.accessapproval.v1.DismissDecision
	0,  // 11: google.cloud.accessapproval.v1.EnrolledService.enrollment_level:type_name -> google.cloud.accessapproval.v1.EnrollmentLevel
	8,  // 12: google.cloud.accessapproval.v1.AccessApprovalSettings.enrolled_services:type_name -> google.cloud.accessapproval.v1.EnrolledService
	7,  // 13: google.cloud.accessapproval.v1.ListApprovalRequestsResponse.approval_requests:type_name -> google.cloud.accessapproval.v1.ApprovalRequest
	18, // 14: google.cloud.accessapproval.v1.ApproveApprovalRequestMessage.expire_time:type_name -> google.protobuf.Timestamp
	9,  // 15: google.cloud.accessapproval.v1.UpdateAccessApprovalSettingsMessage.settings:type_name -> google.cloud.accessapproval.v1.AccessApprovalSettings
	19, // 16: google.cloud.accessapproval.v1.UpdateAccessApprovalSettingsMessage.update_mask:type_name -> google.protobuf.FieldMask
	10, // 17: google.cloud.accessapproval.v1.AccessApproval.ListApprovalRequests:input_type -> google.cloud.accessapproval.v1.ListApprovalRequestsMessage
	12, // 18: google.cloud.accessapproval.v1.AccessApproval.GetApprovalRequest:input_type -> google.cloud.accessapproval.v1.GetApprovalRequestMessage
	13, // 19: google.cloud.accessapproval.v1.AccessApproval.ApproveApprovalRequest:input_type -> google.cloud.accessapproval.v1.ApproveApprovalRequestMessage
	14, // 20: google.cloud.accessapproval.v1.AccessApproval.DismissApprovalRequest:input_type -> google.cloud.accessapproval.v1.DismissApprovalRequestMessage
	15, // 21: google.cloud.accessapproval.v1.AccessApproval.GetAccessApprovalSettings:input_type -> google.cloud.accessapproval.v1.GetAccessApprovalSettingsMessage
	16, // 22: google.cloud.accessapproval.v1.AccessApproval.UpdateAccessApprovalSettings:input_type -> google.cloud.accessapproval.v1.UpdateAccessApprovalSettingsMessage
	17, // 23: google.cloud.accessapproval.v1.AccessApproval.DeleteAccessApprovalSettings:input_type -> google.cloud.accessapproval.v1.DeleteAccessApprovalSettingsMessage
	11, // 24: google.cloud.accessapproval.v1.AccessApproval.ListApprovalRequests:output_type -> google.cloud.accessapproval.v1.ListApprovalRequestsResponse
	7,  // 25: google.cloud.accessapproval.v1.AccessApproval.GetApprovalRequest:output_type -> google.cloud.accessapproval.v1.ApprovalRequest
	7,  // 26: google.cloud.accessapproval.v1.AccessApproval.ApproveApprovalRequest:output_type -> google.cloud.accessapproval.v1.ApprovalRequest
	7,  // 27: google.cloud.accessapproval.v1.AccessApproval.DismissApprovalRequest:output_type -> google.cloud.accessapproval.v1.ApprovalRequest
	9,  // 28: google.cloud.accessapproval.v1.AccessApproval.GetAccessApprovalSettings:output_type -> google.cloud.accessapproval.v1.AccessApprovalSettings
	9,  // 29: google.cloud.accessapproval.v1.AccessApproval.UpdateAccessApprovalSettings:output_type -> google.cloud.accessapproval.v1.AccessApprovalSettings
	20, // 30: google.cloud.accessapproval.v1.AccessApproval.DeleteAccessApprovalSettings:output_type -> google.protobuf.Empty
	24, // [24:31] is the sub-list for method output_type
	17, // [17:24] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_accessapproval_v1_accessapproval_proto_init() }
func file_google_cloud_accessapproval_v1_accessapproval_proto_init() {
	if File_google_cloud_accessapproval_v1_accessapproval_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessLocations); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessReason); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApproveDecision); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DismissDecision); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApprovalRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnrolledService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessApprovalSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListApprovalRequestsMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListApprovalRequestsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetApprovalRequestMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApproveApprovalRequestMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DismissApprovalRequestMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAccessApprovalSettingsMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAccessApprovalSettingsMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAccessApprovalSettingsMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*ApprovalRequest_Approve)(nil),
		(*ApprovalRequest_Dismiss)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_accessapproval_v1_accessapproval_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_accessapproval_v1_accessapproval_proto_goTypes,
		DependencyIndexes: file_google_cloud_accessapproval_v1_accessapproval_proto_depIdxs,
		EnumInfos:         file_google_cloud_accessapproval_v1_accessapproval_proto_enumTypes,
		MessageInfos:      file_google_cloud_accessapproval_v1_accessapproval_proto_msgTypes,
	}.Build()
	File_google_cloud_accessapproval_v1_accessapproval_proto = out.File
	file_google_cloud_accessapproval_v1_accessapproval_proto_rawDesc = nil
	file_google_cloud_accessapproval_v1_accessapproval_proto_goTypes = nil
	file_google_cloud_accessapproval_v1_accessapproval_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AccessApprovalClient is the client API for AccessApproval service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AccessApprovalClient interface {
	// Lists approval requests associated with a project, folder, or organization.
	// Approval requests can be filtered by state (pending, active, dismissed).
	// The order is reverse chronological.
	ListApprovalRequests(ctx context.Context, in *ListApprovalRequestsMessage, opts ...grpc.CallOption) (*ListApprovalRequestsResponse, error)
	// Gets an approval request. Returns NOT_FOUND if the request does not exist.
	GetApprovalRequest(ctx context.Context, in *GetApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error)
	// Approves a request and returns the updated ApprovalRequest.
	//
	// Returns NOT_FOUND if the request does not exist. Returns
	// FAILED_PRECONDITION if the request exists but is not in a pending state.
	ApproveApprovalRequest(ctx context.Context, in *ApproveApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error)
	// Dismisses a request. Returns the updated ApprovalRequest.
	//
	// NOTE: This does not deny access to the resource if another request has been
	// made and approved. It is equivalent in effect to ignoring the request
	// altogether.
	//
	// Returns NOT_FOUND if the request does not exist.
	//
	// Returns FAILED_PRECONDITION if the request exists but is not in a pending
	// state.
	DismissApprovalRequest(ctx context.Context, in *DismissApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error)
	// Gets the settings associated with a project, folder, or organization.
	GetAccessApprovalSettings(ctx context.Context, in *GetAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*AccessApprovalSettings, error)
	// Updates the settings associated with a project, folder, or organization.
	// Settings to update are determined by the value of field_mask.
	UpdateAccessApprovalSettings(ctx context.Context, in *UpdateAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*AccessApprovalSettings, error)
	// Deletes the settings associated with a project, folder, or organization.
	// This will have the effect of disabling Access Approval for the project,
	// folder, or organization, but only if all ancestors also have Access
	// Approval disabled. If Access Approval is enabled at a higher level of the
	// hierarchy, then Access Approval will still be enabled at this level as
	// the settings are inherited.
	DeleteAccessApprovalSettings(ctx context.Context, in *DeleteAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*empty.Empty, error)
}

type accessApprovalClient struct {
	cc grpc.ClientConnInterface
}

func NewAccessApprovalClient(cc grpc.ClientConnInterface) AccessApprovalClient {
	return &accessApprovalClient{cc}
}

func (c *accessApprovalClient) ListApprovalRequests(ctx context.Context, in *ListApprovalRequestsMessage, opts ...grpc.CallOption) (*ListApprovalRequestsResponse, error) {
	out := new(ListApprovalRequestsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.accessapproval.v1.AccessApproval/ListApprovalRequests", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) GetApprovalRequest(ctx context.Context, in *GetApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error) {
	out := new(ApprovalRequest)
	err := c.cc.Invoke(ctx, "/google.cloud.accessapproval.v1.AccessApproval/GetApprovalRequest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) ApproveApprovalRequest(ctx context.Context, in *ApproveApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error) {
	out := new(ApprovalRequest)
	err := c.cc.Invoke(ctx, "/google.cloud.accessapproval.v1.AccessApproval/ApproveApprovalRequest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) DismissApprovalRequest(ctx context.Context, in *DismissApprovalRequestMessage, opts ...grpc.CallOption) (*ApprovalRequest, error) {
	out := new(ApprovalRequest)
	err := c.cc.Invoke(ctx, "/google.cloud.accessapproval.v1.AccessApproval/DismissApprovalRequest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) GetAccessApprovalSettings(ctx context.Context, in *GetAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*AccessApprovalSettings, error) {
	out := new(AccessApprovalSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.accessapproval.v1.AccessApproval/GetAccessApprovalSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) UpdateAccessApprovalSettings(ctx context.Context, in *UpdateAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*AccessApprovalSettings, error) {
	out := new(AccessApprovalSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.accessapproval.v1.AccessApproval/UpdateAccessApprovalSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accessApprovalClient) DeleteAccessApprovalSettings(ctx context.Context, in *DeleteAccessApprovalSettingsMessage, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.accessapproval.v1.AccessApproval/DeleteAccessApprovalSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AccessApprovalServer is the server API for AccessApproval service.
type AccessApprovalServer interface {
	// Lists approval requests associated with a project, folder, or organization.
	// Approval requests can be filtered by state (pending, active, dismissed).
	// The order is reverse chronological.
	ListApprovalRequests(context.Context, *ListApprovalRequestsMessage) (*ListApprovalRequestsResponse, error)
	// Gets an approval request. Returns NOT_FOUND if the request does not exist.
	GetApprovalRequest(context.Context, *GetApprovalRequestMessage) (*ApprovalRequest, error)
	// Approves a request and returns the updated ApprovalRequest.
	//
	// Returns NOT_FOUND if the request does not exist. Returns
	// FAILED_PRECONDITION if the request exists but is not in a pending state.
	ApproveApprovalRequest(context.Context, *ApproveApprovalRequestMessage) (*ApprovalRequest, error)
	// Dismisses a request. Returns the updated ApprovalRequest.
	//
	// NOTE: This does not deny access to the resource if another request has been
	// made and approved. It is equivalent in effect to ignoring the request
	// altogether.
	//
	// Returns NOT_FOUND if the request does not exist.
	//
	// Returns FAILED_PRECONDITION if the request exists but is not in a pending
	// state.
	DismissApprovalRequest(context.Context, *DismissApprovalRequestMessage) (*ApprovalRequest, error)
	// Gets the settings associated with a project, folder, or organization.
	GetAccessApprovalSettings(context.Context, *GetAccessApprovalSettingsMessage) (*AccessApprovalSettings, error)
	// Updates the settings associated with a project, folder, or organization.
	// Settings to update are determined by the value of field_mask.
	UpdateAccessApprovalSettings(context.Context, *UpdateAccessApprovalSettingsMessage) (*AccessApprovalSettings, error)
	// Deletes the settings associated with a project, folder, or organization.
	// This will have the effect of disabling Access Approval for the project,
	// folder, or organization, but only if all ancestors also have Access
	// Approval disabled. If Access Approval is enabled at a higher level of the
	// hierarchy, then Access Approval will still be enabled at this level as
	// the settings are inherited.
	DeleteAccessApprovalSettings(context.Context, *DeleteAccessApprovalSettingsMessage) (*empty.Empty, error)
}

// UnimplementedAccessApprovalServer can be embedded to have forward compatible implementations.
type UnimplementedAccessApprovalServer struct {
}

func (*UnimplementedAccessApprovalServer) ListApprovalRequests(context.Context, *ListApprovalRequestsMessage) (*ListApprovalRequestsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListApprovalRequests not implemented")
}
func (*UnimplementedAccessApprovalServer) GetApprovalRequest(context.Context, *GetApprovalRequestMessage) (*ApprovalRequest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApprovalRequest not implemented")
}
func (*UnimplementedAccessApprovalServer) ApproveApprovalRequest(context.Context, *ApproveApprovalRequestMessage) (*ApprovalRequest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApproveApprovalRequest not implemented")
}
func (*UnimplementedAccessApprovalServer) DismissApprovalRequest(context.Context, *DismissApprovalRequestMessage) (*ApprovalRequest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DismissApprovalRequest not implemented")
}
func (*UnimplementedAccessApprovalServer) GetAccessApprovalSettings(context.Context, *GetAccessApprovalSettingsMessage) (*AccessApprovalSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccessApprovalSettings not implemented")
}
func (*UnimplementedAccessApprovalServer) UpdateAccessApprovalSettings(context.Context, *UpdateAccessApprovalSettingsMessage) (*AccessApprovalSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessApprovalSettings not implemented")
}
func (*UnimplementedAccessApprovalServer) DeleteAccessApprovalSettings(context.Context, *DeleteAccessApprovalSettingsMessage) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAccessApprovalSettings not implemented")
}

func RegisterAccessApprovalServer(s *grpc.Server, srv AccessApprovalServer) {
	s.RegisterService(&_AccessApproval_serviceDesc, srv)
}

func _AccessApproval_ListApprovalRequests_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApprovalRequestsMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).ListApprovalRequests(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.accessapproval.v1.AccessApproval/ListApprovalRequests",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).ListApprovalRequests(ctx, req.(*ListApprovalRequestsMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_GetApprovalRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApprovalRequestMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).GetApprovalRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.accessapproval.v1.AccessApproval/GetApprovalRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).GetApprovalRequest(ctx, req.(*GetApprovalRequestMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_ApproveApprovalRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApproveApprovalRequestMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).ApproveApprovalRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.accessapproval.v1.AccessApproval/ApproveApprovalRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).ApproveApprovalRequest(ctx, req.(*ApproveApprovalRequestMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_DismissApprovalRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DismissApprovalRequestMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).DismissApprovalRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.accessapproval.v1.AccessApproval/DismissApprovalRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).DismissApprovalRequest(ctx, req.(*DismissApprovalRequestMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_GetAccessApprovalSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccessApprovalSettingsMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).GetAccessApprovalSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.accessapproval.v1.AccessApproval/GetAccessApprovalSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).GetAccessApprovalSettings(ctx, req.(*GetAccessApprovalSettingsMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_UpdateAccessApprovalSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccessApprovalSettingsMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).UpdateAccessApprovalSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.accessapproval.v1.AccessApproval/UpdateAccessApprovalSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).UpdateAccessApprovalSettings(ctx, req.(*UpdateAccessApprovalSettingsMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccessApproval_DeleteAccessApprovalSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAccessApprovalSettingsMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccessApprovalServer).DeleteAccessApprovalSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.accessapproval.v1.AccessApproval/DeleteAccessApprovalSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccessApprovalServer).DeleteAccessApprovalSettings(ctx, req.(*DeleteAccessApprovalSettingsMessage))
	}
	return interceptor(ctx, in, info, handler)
}

var _AccessApproval_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.accessapproval.v1.AccessApproval",
	HandlerType: (*AccessApprovalServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListApprovalRequests",
			Handler:    _AccessApproval_ListApprovalRequests_Handler,
		},
		{
			MethodName: "GetApprovalRequest",
			Handler:    _AccessApproval_GetApprovalRequest_Handler,
		},
		{
			MethodName: "ApproveApprovalRequest",
			Handler:    _AccessApproval_ApproveApprovalRequest_Handler,
		},
		{
			MethodName: "DismissApprovalRequest",
			Handler:    _AccessApproval_DismissApprovalRequest_Handler,
		},
		{
			MethodName: "GetAccessApprovalSettings",
			Handler:    _AccessApproval_GetAccessApprovalSettings_Handler,
		},
		{
			MethodName: "UpdateAccessApprovalSettings",
			Handler:    _AccessApproval_UpdateAccessApprovalSettings_Handler,
		},
		{
			MethodName: "DeleteAccessApprovalSettings",
			Handler:    _AccessApproval_DeleteAccessApprovalSettings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/accessapproval/v1/accessapproval.proto",
}
