// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/ads/googleads/v3/common/metrics.proto

package common

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Metrics data.
type Metrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The percent of your ad impressions that are shown as the very first ad
	// above the organic search results.
	AbsoluteTopImpressionPercentage *wrappers.DoubleValue `protobuf:"bytes,95,opt,name=absolute_top_impression_percentage,json=absoluteTopImpressionPercentage,proto3" json:"absolute_top_impression_percentage,omitempty"`
	// Average cost of viewable impressions (`active_view_impressions`).
	ActiveViewCpm *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=active_view_cpm,json=activeViewCpm,proto3" json:"active_view_cpm,omitempty"`
	// Active view measurable clicks divided by active view viewable impressions.
	// This metric is reported only for display network.
	ActiveViewCtr *wrappers.DoubleValue `protobuf:"bytes,79,opt,name=active_view_ctr,json=activeViewCtr,proto3" json:"active_view_ctr,omitempty"`
	// A measurement of how often your ad has become viewable on a Display
	// Network site.
	ActiveViewImpressions *wrappers.Int64Value `protobuf:"bytes,2,opt,name=active_view_impressions,json=activeViewImpressions,proto3" json:"active_view_impressions,omitempty"`
	// The ratio of impressions that could be measured by Active View over the
	// number of served impressions.
	ActiveViewMeasurability *wrappers.DoubleValue `protobuf:"bytes,96,opt,name=active_view_measurability,json=activeViewMeasurability,proto3" json:"active_view_measurability,omitempty"`
	// The cost of the impressions you received that were measurable by Active
	// View.
	ActiveViewMeasurableCostMicros *wrappers.Int64Value `protobuf:"bytes,3,opt,name=active_view_measurable_cost_micros,json=activeViewMeasurableCostMicros,proto3" json:"active_view_measurable_cost_micros,omitempty"`
	// The number of times your ads are appearing on placements in positions
	// where they can be seen.
	ActiveViewMeasurableImpressions *wrappers.Int64Value `protobuf:"bytes,4,opt,name=active_view_measurable_impressions,json=activeViewMeasurableImpressions,proto3" json:"active_view_measurable_impressions,omitempty"`
	// The percentage of time when your ad appeared on an Active View enabled site
	// (measurable impressions) and was viewable (viewable impressions).
	ActiveViewViewability *wrappers.DoubleValue `protobuf:"bytes,97,opt,name=active_view_viewability,json=activeViewViewability,proto3" json:"active_view_viewability,omitempty"`
	// All conversions from interactions (as oppose to view through conversions)
	// divided by the number of ad interactions.
	AllConversionsFromInteractionsRate *wrappers.DoubleValue `protobuf:"bytes,65,opt,name=all_conversions_from_interactions_rate,json=allConversionsFromInteractionsRate,proto3" json:"all_conversions_from_interactions_rate,omitempty"`
	// The total value of all conversions.
	AllConversionsValue *wrappers.DoubleValue `protobuf:"bytes,66,opt,name=all_conversions_value,json=allConversionsValue,proto3" json:"all_conversions_value,omitempty"`
	// The total number of conversions. This only includes conversion actions
	// which include_in_conversions_metric attribute is set to true.
	AllConversions *wrappers.DoubleValue `protobuf:"bytes,7,opt,name=all_conversions,json=allConversions,proto3" json:"all_conversions,omitempty"`
	// The value of all conversions divided by the total cost of ad interactions
	// (such as clicks for text ads or views for video ads).
	AllConversionsValuePerCost *wrappers.DoubleValue `protobuf:"bytes,62,opt,name=all_conversions_value_per_cost,json=allConversionsValuePerCost,proto3" json:"all_conversions_value_per_cost,omitempty"`
	// The number of times people clicked the "Call" button to call a store during
	// or after clicking an ad. This number doesn't include whether or not calls
	// were connected, or the duration of any calls.
	// This metric applies to feed items only.
	AllConversionsFromClickToCall *wrappers.DoubleValue `protobuf:"bytes,118,opt,name=all_conversions_from_click_to_call,json=allConversionsFromClickToCall,proto3" json:"all_conversions_from_click_to_call,omitempty"`
	// The number of times people clicked a "Get directions" button to navigate to
	// a store after clicking an ad.
	// This metric applies to feed items only.
	AllConversionsFromDirections *wrappers.DoubleValue `protobuf:"bytes,119,opt,name=all_conversions_from_directions,json=allConversionsFromDirections,proto3" json:"all_conversions_from_directions,omitempty"`
	// The value of all conversions from interactions divided by the total number
	// of interactions.
	AllConversionsFromInteractionsValuePerInteraction *wrappers.DoubleValue `protobuf:"bytes,67,opt,name=all_conversions_from_interactions_value_per_interaction,json=allConversionsFromInteractionsValuePerInteraction,proto3" json:"all_conversions_from_interactions_value_per_interaction,omitempty"`
	// The number of times people clicked a link to view a store's menu after
	// clicking an ad.
	// This metric applies to feed items only.
	AllConversionsFromMenu *wrappers.DoubleValue `protobuf:"bytes,120,opt,name=all_conversions_from_menu,json=allConversionsFromMenu,proto3" json:"all_conversions_from_menu,omitempty"`
	// The number of times people placed an order at a store after clicking an ad.
	// This metric applies to feed items only.
	AllConversionsFromOrder *wrappers.DoubleValue `protobuf:"bytes,121,opt,name=all_conversions_from_order,json=allConversionsFromOrder,proto3" json:"all_conversions_from_order,omitempty"`
	// The number of other conversions (for example, posting a review or saving a
	// location for a store) that occurred after people clicked an ad.
	// This metric applies to feed items only.
	AllConversionsFromOtherEngagement *wrappers.DoubleValue `protobuf:"bytes,122,opt,name=all_conversions_from_other_engagement,json=allConversionsFromOtherEngagement,proto3" json:"all_conversions_from_other_engagement,omitempty"`
	// Estimated number of times people visited a store after clicking an ad.
	// This metric applies to feed items only.
	AllConversionsFromStoreVisit *wrappers.DoubleValue `protobuf:"bytes,123,opt,name=all_conversions_from_store_visit,json=allConversionsFromStoreVisit,proto3" json:"all_conversions_from_store_visit,omitempty"`
	// The number of times that people were taken to a store's URL after clicking
	// an ad.
	// This metric applies to feed items only.
	AllConversionsFromStoreWebsite *wrappers.DoubleValue `protobuf:"bytes,124,opt,name=all_conversions_from_store_website,json=allConversionsFromStoreWebsite,proto3" json:"all_conversions_from_store_website,omitempty"`
	// The average amount you pay per interaction. This amount is the total cost
	// of your ads divided by the total number of interactions.
	AverageCost *wrappers.DoubleValue `protobuf:"bytes,8,opt,name=average_cost,json=averageCost,proto3" json:"average_cost,omitempty"`
	// The total cost of all clicks divided by the total number of clicks
	// received.
	AverageCpc *wrappers.DoubleValue `protobuf:"bytes,9,opt,name=average_cpc,json=averageCpc,proto3" json:"average_cpc,omitempty"`
	// The average amount that you've been charged for an ad engagement. This
	// amount is the total cost of all ad engagements divided by the total number
	// of ad engagements.
	AverageCpe *wrappers.DoubleValue `protobuf:"bytes,98,opt,name=average_cpe,json=averageCpe,proto3" json:"average_cpe,omitempty"`
	// Average cost-per-thousand impressions (CPM).
	AverageCpm *wrappers.DoubleValue `protobuf:"bytes,10,opt,name=average_cpm,json=averageCpm,proto3" json:"average_cpm,omitempty"`
	// The average amount you pay each time someone views your ad.
	// The average CPV is defined by the total cost of all ad views divided by
	// the number of views.
	AverageCpv *wrappers.DoubleValue `protobuf:"bytes,11,opt,name=average_cpv,json=averageCpv,proto3" json:"average_cpv,omitempty"`
	// Average number of pages viewed per session.
	AveragePageViews *wrappers.DoubleValue `protobuf:"bytes,99,opt,name=average_page_views,json=averagePageViews,proto3" json:"average_page_views,omitempty"`
	// Total duration of all sessions (in seconds) / number of sessions. Imported
	// from Google Analytics.
	AverageTimeOnSite *wrappers.DoubleValue `protobuf:"bytes,84,opt,name=average_time_on_site,json=averageTimeOnSite,proto3" json:"average_time_on_site,omitempty"`
	// An indication of how other advertisers are bidding on similar products.
	BenchmarkAverageMaxCpc *wrappers.DoubleValue `protobuf:"bytes,14,opt,name=benchmark_average_max_cpc,json=benchmarkAverageMaxCpc,proto3" json:"benchmark_average_max_cpc,omitempty"`
	// An indication on how other advertisers' Shopping ads for similar products
	// are performing based on how often people who see their ad click on it.
	BenchmarkCtr *wrappers.DoubleValue `protobuf:"bytes,77,opt,name=benchmark_ctr,json=benchmarkCtr,proto3" json:"benchmark_ctr,omitempty"`
	// Percentage of clicks where the user only visited a single page on your
	// site. Imported from Google Analytics.
	BounceRate *wrappers.DoubleValue `protobuf:"bytes,15,opt,name=bounce_rate,json=bounceRate,proto3" json:"bounce_rate,omitempty"`
	// The number of clicks.
	Clicks *wrappers.Int64Value `protobuf:"bytes,19,opt,name=clicks,proto3" json:"clicks,omitempty"`
	// The number of times your ad or your site's listing in the unpaid
	// results was clicked. See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	CombinedClicks *wrappers.Int64Value `protobuf:"bytes,115,opt,name=combined_clicks,json=combinedClicks,proto3" json:"combined_clicks,omitempty"`
	// The number of times your ad or your site's listing in the unpaid
	// results was clicked (combined_clicks) divided by combined_queries. See the
	// help page at https://support.google.com/google-ads/answer/3097241 for
	// details.
	CombinedClicksPerQuery *wrappers.DoubleValue `protobuf:"bytes,116,opt,name=combined_clicks_per_query,json=combinedClicksPerQuery,proto3" json:"combined_clicks_per_query,omitempty"`
	// The number of searches that returned pages from your site in the unpaid
	// results or showed one of your text ads. See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	CombinedQueries *wrappers.Int64Value `protobuf:"bytes,117,opt,name=combined_queries,json=combinedQueries,proto3" json:"combined_queries,omitempty"`
	// The estimated percent of times that your ad was eligible to show
	// on the Display Network but didn't because your budget was too low.
	// Note: Content budget lost impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	ContentBudgetLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,20,opt,name=content_budget_lost_impression_share,json=contentBudgetLostImpressionShare,proto3" json:"content_budget_lost_impression_share,omitempty"`
	// The impressions you've received on the Display Network divided
	// by the estimated number of impressions you were eligible to receive.
	// Note: Content impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	ContentImpressionShare *wrappers.DoubleValue `protobuf:"bytes,21,opt,name=content_impression_share,json=contentImpressionShare,proto3" json:"content_impression_share,omitempty"`
	// The last date/time a conversion tag for this conversion action successfully
	// fired and was seen by Google Ads. This firing event may not have been the
	// result of an attributable conversion (e.g. because the tag was fired from a
	// browser that did not previously click an ad from an appropriate
	// advertiser). The date/time is in the customer's time zone.
	ConversionLastReceivedRequestDateTime *wrappers.StringValue `protobuf:"bytes,73,opt,name=conversion_last_received_request_date_time,json=conversionLastReceivedRequestDateTime,proto3" json:"conversion_last_received_request_date_time,omitempty"`
	// The date of the most recent conversion for this conversion action. The date
	// is in the customer's time zone.
	ConversionLastConversionDate *wrappers.StringValue `protobuf:"bytes,74,opt,name=conversion_last_conversion_date,json=conversionLastConversionDate,proto3" json:"conversion_last_conversion_date,omitempty"`
	// The estimated percentage of impressions on the Display Network
	// that your ads didn't receive due to poor Ad Rank.
	// Note: Content rank lost impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	ContentRankLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,22,opt,name=content_rank_lost_impression_share,json=contentRankLostImpressionShare,proto3" json:"content_rank_lost_impression_share,omitempty"`
	// Conversions from interactions divided by the number of ad interactions
	// (such as clicks for text ads or views for video ads). This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true.
	ConversionsFromInteractionsRate *wrappers.DoubleValue `protobuf:"bytes,69,opt,name=conversions_from_interactions_rate,json=conversionsFromInteractionsRate,proto3" json:"conversions_from_interactions_rate,omitempty"`
	// The total value of conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	ConversionsValue *wrappers.DoubleValue `protobuf:"bytes,70,opt,name=conversions_value,json=conversionsValue,proto3" json:"conversions_value,omitempty"`
	// The value of conversions divided by the cost of ad interactions. This only
	// includes conversion actions which include_in_conversions_metric attribute
	// is set to true.
	ConversionsValuePerCost *wrappers.DoubleValue `protobuf:"bytes,71,opt,name=conversions_value_per_cost,json=conversionsValuePerCost,proto3" json:"conversions_value_per_cost,omitempty"`
	// The value of conversions from interactions divided by the number of ad
	// interactions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	ConversionsFromInteractionsValuePerInteraction *wrappers.DoubleValue `protobuf:"bytes,72,opt,name=conversions_from_interactions_value_per_interaction,json=conversionsFromInteractionsValuePerInteraction,proto3" json:"conversions_from_interactions_value_per_interaction,omitempty"`
	// The number of conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	Conversions *wrappers.DoubleValue `protobuf:"bytes,25,opt,name=conversions,proto3" json:"conversions,omitempty"`
	// The sum of your cost-per-click (CPC) and cost-per-thousand impressions
	// (CPM) costs during this period.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,26,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// The cost of ad interactions divided by all conversions.
	CostPerAllConversions *wrappers.DoubleValue `protobuf:"bytes,68,opt,name=cost_per_all_conversions,json=costPerAllConversions,proto3" json:"cost_per_all_conversions,omitempty"`
	// The cost of ad interactions divided by conversions. This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true.
	CostPerConversion *wrappers.DoubleValue `protobuf:"bytes,28,opt,name=cost_per_conversion,json=costPerConversion,proto3" json:"cost_per_conversion,omitempty"`
	// The cost of ad interactions divided by current model attributed
	// conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	CostPerCurrentModelAttributedConversion *wrappers.DoubleValue `protobuf:"bytes,106,opt,name=cost_per_current_model_attributed_conversion,json=costPerCurrentModelAttributedConversion,proto3" json:"cost_per_current_model_attributed_conversion,omitempty"`
	// Conversions from when a customer clicks on a Google Ads ad on one device,
	// then converts on a different device or browser.
	// Cross-device conversions are already included in all_conversions.
	CrossDeviceConversions *wrappers.DoubleValue `protobuf:"bytes,29,opt,name=cross_device_conversions,json=crossDeviceConversions,proto3" json:"cross_device_conversions,omitempty"`
	// The number of clicks your ad receives (Clicks) divided by the number
	// of times your ad is shown (Impressions).
	Ctr *wrappers.DoubleValue `protobuf:"bytes,30,opt,name=ctr,proto3" json:"ctr,omitempty"`
	// Shows how your historic conversions data would look under the attribution
	// model you've currently selected. This only includes conversion actions
	// which include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversions *wrappers.DoubleValue `protobuf:"bytes,101,opt,name=current_model_attributed_conversions,json=currentModelAttributedConversions,proto3" json:"current_model_attributed_conversions,omitempty"`
	// Current model attributed conversions from interactions divided by the
	// number of ad interactions (such as clicks for text ads or views for video
	// ads). This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversionsFromInteractionsRate *wrappers.DoubleValue `protobuf:"bytes,102,opt,name=current_model_attributed_conversions_from_interactions_rate,json=currentModelAttributedConversionsFromInteractionsRate,proto3" json:"current_model_attributed_conversions_from_interactions_rate,omitempty"`
	// The value of current model attributed conversions from interactions divided
	// by the number of ad interactions. This only includes conversion actions
	// which include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversionsFromInteractionsValuePerInteraction *wrappers.DoubleValue `protobuf:"bytes,103,opt,name=current_model_attributed_conversions_from_interactions_value_per_interaction,json=currentModelAttributedConversionsFromInteractionsValuePerInteraction,proto3" json:"current_model_attributed_conversions_from_interactions_value_per_interaction,omitempty"`
	// The total value of current model attributed conversions. This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true.
	CurrentModelAttributedConversionsValue *wrappers.DoubleValue `protobuf:"bytes,104,opt,name=current_model_attributed_conversions_value,json=currentModelAttributedConversionsValue,proto3" json:"current_model_attributed_conversions_value,omitempty"`
	// The value of current model attributed conversions divided by the cost of ad
	// interactions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversionsValuePerCost *wrappers.DoubleValue `protobuf:"bytes,105,opt,name=current_model_attributed_conversions_value_per_cost,json=currentModelAttributedConversionsValuePerCost,proto3" json:"current_model_attributed_conversions_value_per_cost,omitempty"`
	// How often people engage with your ad after it's shown to them. This is the
	// number of ad expansions divided by the number of times your ad is shown.
	EngagementRate *wrappers.DoubleValue `protobuf:"bytes,31,opt,name=engagement_rate,json=engagementRate,proto3" json:"engagement_rate,omitempty"`
	// The number of engagements.
	// An engagement occurs when a viewer expands your Lightbox ad. Also, in the
	// future, other ad types may support engagement metrics.
	Engagements *wrappers.Int64Value `protobuf:"bytes,32,opt,name=engagements,proto3" json:"engagements,omitempty"`
	// Average lead value based on clicks.
	HotelAverageLeadValueMicros *wrappers.DoubleValue `protobuf:"bytes,75,opt,name=hotel_average_lead_value_micros,json=hotelAverageLeadValueMicros,proto3" json:"hotel_average_lead_value_micros,omitempty"`
	// The average price difference between the price offered by reporting hotel
	// advertiser and the cheapest price offered by the competing advertiser.
	HotelPriceDifferencePercentage *wrappers.DoubleValue `protobuf:"bytes,129,opt,name=hotel_price_difference_percentage,json=hotelPriceDifferencePercentage,proto3" json:"hotel_price_difference_percentage,omitempty"`
	// The creative historical quality score.
	HistoricalCreativeQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,80,opt,name=historical_creative_quality_score,json=historicalCreativeQualityScore,proto3,enum=google.ads.googleads.v3.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_creative_quality_score,omitempty"`
	// The quality of historical landing page experience.
	HistoricalLandingPageQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,81,opt,name=historical_landing_page_quality_score,json=historicalLandingPageQualityScore,proto3,enum=google.ads.googleads.v3.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_landing_page_quality_score,omitempty"`
	// The historical quality score.
	HistoricalQualityScore *wrappers.Int64Value `protobuf:"bytes,82,opt,name=historical_quality_score,json=historicalQualityScore,proto3" json:"historical_quality_score,omitempty"`
	// The historical search predicted click through rate (CTR).
	HistoricalSearchPredictedCtr enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,83,opt,name=historical_search_predicted_ctr,json=historicalSearchPredictedCtr,proto3,enum=google.ads.googleads.v3.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_search_predicted_ctr,omitempty"`
	// The number of times the ad was forwarded to someone else as a message.
	GmailForwards *wrappers.Int64Value `protobuf:"bytes,85,opt,name=gmail_forwards,json=gmailForwards,proto3" json:"gmail_forwards,omitempty"`
	// The number of times someone has saved your Gmail ad to their inbox as a
	// message.
	GmailSaves *wrappers.Int64Value `protobuf:"bytes,86,opt,name=gmail_saves,json=gmailSaves,proto3" json:"gmail_saves,omitempty"`
	// The number of clicks to the landing page on the expanded state of Gmail
	// ads.
	GmailSecondaryClicks *wrappers.Int64Value `protobuf:"bytes,87,opt,name=gmail_secondary_clicks,json=gmailSecondaryClicks,proto3" json:"gmail_secondary_clicks,omitempty"`
	// The number of times a store's location-based ad was shown.
	// This metric applies to feed items only.
	ImpressionsFromStoreReach *wrappers.Int64Value `protobuf:"bytes,125,opt,name=impressions_from_store_reach,json=impressionsFromStoreReach,proto3" json:"impressions_from_store_reach,omitempty"`
	// Count of how often your ad has appeared on a search results page or
	// website on the Google Network.
	Impressions *wrappers.Int64Value `protobuf:"bytes,37,opt,name=impressions,proto3" json:"impressions,omitempty"`
	// How often people interact with your ad after it is shown to them.
	// This is the number of interactions divided by the number of times your ad
	// is shown.
	InteractionRate *wrappers.DoubleValue `protobuf:"bytes,38,opt,name=interaction_rate,json=interactionRate,proto3" json:"interaction_rate,omitempty"`
	// The number of interactions.
	// An interaction is the main user action associated with an ad format-clicks
	// for text and shopping ads, views for video ads, and so on.
	Interactions *wrappers.Int64Value `protobuf:"bytes,39,opt,name=interactions,proto3" json:"interactions,omitempty"`
	// The types of payable and free interactions.
	InteractionEventTypes []enums.InteractionEventTypeEnum_InteractionEventType `protobuf:"varint,100,rep,packed,name=interaction_event_types,json=interactionEventTypes,proto3,enum=google.ads.googleads.v3.enums.InteractionEventTypeEnum_InteractionEventType" json:"interaction_event_types,omitempty"`
	// The percentage of clicks filtered out of your total number of clicks
	// (filtered + non-filtered clicks) during the reporting period.
	InvalidClickRate *wrappers.DoubleValue `protobuf:"bytes,40,opt,name=invalid_click_rate,json=invalidClickRate,proto3" json:"invalid_click_rate,omitempty"`
	// Number of clicks Google considers illegitimate and doesn't charge you for.
	InvalidClicks *wrappers.Int64Value `protobuf:"bytes,41,opt,name=invalid_clicks,json=invalidClicks,proto3" json:"invalid_clicks,omitempty"`
	// Number of message chats initiated for Click To Message impressions that
	// were message tracking eligible.
	MessageChats *wrappers.Int64Value `protobuf:"bytes,126,opt,name=message_chats,json=messageChats,proto3" json:"message_chats,omitempty"`
	// Number of Click To Message impressions that were message tracking eligible.
	MessageImpressions *wrappers.Int64Value `protobuf:"bytes,127,opt,name=message_impressions,json=messageImpressions,proto3" json:"message_impressions,omitempty"`
	// Number of message chats initiated (message_chats) divided by the number
	// of message impressions (message_impressions).
	// Rate at which a user initiates a message chat from an ad impression with
	// a messaging option and message tracking enabled.
	// Note that this rate can be more than 1.0 for a given message impression.
	MessageChatRate *wrappers.DoubleValue `protobuf:"bytes,128,opt,name=message_chat_rate,json=messageChatRate,proto3" json:"message_chat_rate,omitempty"`
	// The percentage of mobile clicks that go to a mobile-friendly page.
	MobileFriendlyClicksPercentage *wrappers.DoubleValue `protobuf:"bytes,109,opt,name=mobile_friendly_clicks_percentage,json=mobileFriendlyClicksPercentage,proto3" json:"mobile_friendly_clicks_percentage,omitempty"`
	// The number of times someone clicked your site's listing in the unpaid
	// results for a particular query. See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	OrganicClicks *wrappers.Int64Value `protobuf:"bytes,110,opt,name=organic_clicks,json=organicClicks,proto3" json:"organic_clicks,omitempty"`
	// The number of times someone clicked your site's listing in the unpaid
	// results (organic_clicks) divided by the total number of searches that
	// returned pages from your site (organic_queries). See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	OrganicClicksPerQuery *wrappers.DoubleValue `protobuf:"bytes,111,opt,name=organic_clicks_per_query,json=organicClicksPerQuery,proto3" json:"organic_clicks_per_query,omitempty"`
	// The number of listings for your site in the unpaid search results. See the
	// help page at https://support.google.com/google-ads/answer/3097241 for
	// details.
	OrganicImpressions *wrappers.Int64Value `protobuf:"bytes,112,opt,name=organic_impressions,json=organicImpressions,proto3" json:"organic_impressions,omitempty"`
	// The number of times a page from your site was listed in the unpaid search
	// results (organic_impressions) divided by the number of searches returning
	// your site's listing in the unpaid results (organic_queries). See the help
	// page at https://support.google.com/google-ads/answer/3097241 for details.
	OrganicImpressionsPerQuery *wrappers.DoubleValue `protobuf:"bytes,113,opt,name=organic_impressions_per_query,json=organicImpressionsPerQuery,proto3" json:"organic_impressions_per_query,omitempty"`
	// The total number of searches that returned your site's listing in the
	// unpaid results. See the help page at
	// https://support.google.com/google-ads/answer/3097241 for details.
	OrganicQueries *wrappers.Int64Value `protobuf:"bytes,114,opt,name=organic_queries,json=organicQueries,proto3" json:"organic_queries,omitempty"`
	// Percentage of first-time sessions (from people who had never visited your
	// site before). Imported from Google Analytics.
	PercentNewVisitors *wrappers.DoubleValue `protobuf:"bytes,42,opt,name=percent_new_visitors,json=percentNewVisitors,proto3" json:"percent_new_visitors,omitempty"`
	// Number of offline phone calls.
	PhoneCalls *wrappers.Int64Value `protobuf:"bytes,43,opt,name=phone_calls,json=phoneCalls,proto3" json:"phone_calls,omitempty"`
	// Number of offline phone impressions.
	PhoneImpressions *wrappers.Int64Value `protobuf:"bytes,44,opt,name=phone_impressions,json=phoneImpressions,proto3" json:"phone_impressions,omitempty"`
	// Number of phone calls received (phone_calls) divided by the number of
	// times your phone number is shown (phone_impressions).
	PhoneThroughRate *wrappers.DoubleValue `protobuf:"bytes,45,opt,name=phone_through_rate,json=phoneThroughRate,proto3" json:"phone_through_rate,omitempty"`
	// Your clickthrough rate (Ctr) divided by the average clickthrough rate of
	// all advertisers on the websites that show your ads. Measures how your ads
	// perform on Display Network sites compared to other ads on the same sites.
	RelativeCtr *wrappers.DoubleValue `protobuf:"bytes,46,opt,name=relative_ctr,json=relativeCtr,proto3" json:"relative_ctr,omitempty"`
	// The percentage of the customer's Shopping or Search ad impressions that are
	// shown in the most prominent Shopping position. See
	// https://support.google.com/google-ads/answer/7501826
	// for details. Any value below 0.1 is reported as 0.0999.
	SearchAbsoluteTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,78,opt,name=search_absolute_top_impression_share,json=searchAbsoluteTopImpressionShare,proto3" json:"search_absolute_top_impression_share,omitempty"`
	// The number estimating how often your ad wasn't the very first ad above the
	// organic search results due to a low budget. Note: Search
	// budget lost absolute top impression share is reported in the range of 0 to
	// 0.9. Any value above 0.9 is reported as 0.9001.
	SearchBudgetLostAbsoluteTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,88,opt,name=search_budget_lost_absolute_top_impression_share,json=searchBudgetLostAbsoluteTopImpressionShare,proto3" json:"search_budget_lost_absolute_top_impression_share,omitempty"`
	// The estimated percent of times that your ad was eligible to show on the
	// Search Network but didn't because your budget was too low. Note: Search
	// budget lost impression share is reported in the range of 0 to 0.9. Any
	// value above 0.9 is reported as 0.9001.
	SearchBudgetLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,47,opt,name=search_budget_lost_impression_share,json=searchBudgetLostImpressionShare,proto3" json:"search_budget_lost_impression_share,omitempty"`
	// The number estimating how often your ad didn't show anywhere above the
	// organic search results due to a low budget. Note: Search
	// budget lost top impression share is reported in the range of 0 to 0.9. Any
	// value above 0.9 is reported as 0.9001.
	SearchBudgetLostTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,89,opt,name=search_budget_lost_top_impression_share,json=searchBudgetLostTopImpressionShare,proto3" json:"search_budget_lost_top_impression_share,omitempty"`
	// The number of clicks you've received on the Search Network
	// divided by the estimated number of clicks you were eligible to receive.
	// Note: Search click share is reported in the range of 0.1 to 1. Any value
	// below 0.1 is reported as 0.0999.
	SearchClickShare *wrappers.DoubleValue `protobuf:"bytes,48,opt,name=search_click_share,json=searchClickShare,proto3" json:"search_click_share,omitempty"`
	// The impressions you've received divided by the estimated number of
	// impressions you were eligible to receive on the Search Network for search
	// terms that matched your keywords exactly (or were close variants of your
	// keyword), regardless of your keyword match types. Note: Search exact match
	// impression share is reported in the range of 0.1 to 1. Any value below 0.1
	// is reported as 0.0999.
	SearchExactMatchImpressionShare *wrappers.DoubleValue `protobuf:"bytes,49,opt,name=search_exact_match_impression_share,json=searchExactMatchImpressionShare,proto3" json:"search_exact_match_impression_share,omitempty"`
	// The impressions you've received on the Search Network divided
	// by the estimated number of impressions you were eligible to receive.
	// Note: Search impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	SearchImpressionShare *wrappers.DoubleValue `protobuf:"bytes,50,opt,name=search_impression_share,json=searchImpressionShare,proto3" json:"search_impression_share,omitempty"`
	// The number estimating how often your ad wasn't the very first ad above the
	// organic search results due to poor Ad Rank.
	// Note: Search rank lost absolute top impression share is reported in the
	// range of 0 to 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostAbsoluteTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,90,opt,name=search_rank_lost_absolute_top_impression_share,json=searchRankLostAbsoluteTopImpressionShare,proto3" json:"search_rank_lost_absolute_top_impression_share,omitempty"`
	// The estimated percentage of impressions on the Search Network
	// that your ads didn't receive due to poor Ad Rank.
	// Note: Search rank lost impression share is reported in the range of 0 to
	// 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,51,opt,name=search_rank_lost_impression_share,json=searchRankLostImpressionShare,proto3" json:"search_rank_lost_impression_share,omitempty"`
	// The number estimating how often your ad didn't show anywhere above the
	// organic search results due to poor Ad Rank.
	// Note: Search rank lost top impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,91,opt,name=search_rank_lost_top_impression_share,json=searchRankLostTopImpressionShare,proto3" json:"search_rank_lost_top_impression_share,omitempty"`
	// The impressions you've received in the top location (anywhere above the
	// organic search results) compared to the estimated number of impressions you
	// were eligible to receive in the top location.
	// Note: Search top impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	SearchTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,92,opt,name=search_top_impression_share,json=searchTopImpressionShare,proto3" json:"search_top_impression_share,omitempty"`
	// A measure of how quickly your page loads after clicks on your mobile ads.
	// The score is a range from 1 to 10, 10 being the fastest.
	SpeedScore *wrappers.Int64Value `protobuf:"bytes,107,opt,name=speed_score,json=speedScore,proto3" json:"speed_score,omitempty"`
	// The percent of your ad impressions that are shown anywhere above the
	// organic search results.
	TopImpressionPercentage *wrappers.DoubleValue `protobuf:"bytes,93,opt,name=top_impression_percentage,json=topImpressionPercentage,proto3" json:"top_impression_percentage,omitempty"`
	// The percentage of ad clicks to Accelerated Mobile Pages (AMP) landing pages
	// that reach a valid AMP page.
	ValidAcceleratedMobilePagesClicksPercentage *wrappers.DoubleValue `protobuf:"bytes,108,opt,name=valid_accelerated_mobile_pages_clicks_percentage,json=validAcceleratedMobilePagesClicksPercentage,proto3" json:"valid_accelerated_mobile_pages_clicks_percentage,omitempty"`
	// The value of all conversions divided by the number of all conversions.
	ValuePerAllConversions *wrappers.DoubleValue `protobuf:"bytes,52,opt,name=value_per_all_conversions,json=valuePerAllConversions,proto3" json:"value_per_all_conversions,omitempty"`
	// The value of conversions divided by the number of conversions. This only
	// includes conversion actions which include_in_conversions_metric attribute
	// is set to true.
	ValuePerConversion *wrappers.DoubleValue `protobuf:"bytes,53,opt,name=value_per_conversion,json=valuePerConversion,proto3" json:"value_per_conversion,omitempty"`
	// The value of current model attributed conversions divided by the number of
	// the conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	ValuePerCurrentModelAttributedConversion *wrappers.DoubleValue `protobuf:"bytes,94,opt,name=value_per_current_model_attributed_conversion,json=valuePerCurrentModelAttributedConversion,proto3" json:"value_per_current_model_attributed_conversion,omitempty"`
	// Percentage of impressions where the viewer watched all of your video.
	VideoQuartile_100Rate *wrappers.DoubleValue `protobuf:"bytes,54,opt,name=video_quartile_100_rate,json=videoQuartile100Rate,proto3" json:"video_quartile_100_rate,omitempty"`
	// Percentage of impressions where the viewer watched 25% of your video.
	VideoQuartile_25Rate *wrappers.DoubleValue `protobuf:"bytes,55,opt,name=video_quartile_25_rate,json=videoQuartile25Rate,proto3" json:"video_quartile_25_rate,omitempty"`
	// Percentage of impressions where the viewer watched 50% of your video.
	VideoQuartile_50Rate *wrappers.DoubleValue `protobuf:"bytes,56,opt,name=video_quartile_50_rate,json=videoQuartile50Rate,proto3" json:"video_quartile_50_rate,omitempty"`
	// Percentage of impressions where the viewer watched 75% of your video.
	VideoQuartile_75Rate *wrappers.DoubleValue `protobuf:"bytes,57,opt,name=video_quartile_75_rate,json=videoQuartile75Rate,proto3" json:"video_quartile_75_rate,omitempty"`
	// The number of views your TrueView video ad receives divided by its number
	// of impressions, including thumbnail impressions for TrueView in-display
	// ads.
	VideoViewRate *wrappers.DoubleValue `protobuf:"bytes,58,opt,name=video_view_rate,json=videoViewRate,proto3" json:"video_view_rate,omitempty"`
	// The number of times your video ads were viewed.
	VideoViews *wrappers.Int64Value `protobuf:"bytes,59,opt,name=video_views,json=videoViews,proto3" json:"video_views,omitempty"`
	// The total number of view-through conversions.
	// These happen when a customer sees an image or rich media ad, then later
	// completes a conversion on your site without interacting with (e.g.,
	// clicking on) another ad.
	ViewThroughConversions *wrappers.Int64Value `protobuf:"bytes,60,opt,name=view_through_conversions,json=viewThroughConversions,proto3" json:"view_through_conversions,omitempty"`
}

func (x *Metrics) Reset() {
	*x = Metrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v3_common_metrics_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metrics) ProtoMessage() {}

func (x *Metrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v3_common_metrics_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metrics.ProtoReflect.Descriptor instead.
func (*Metrics) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v3_common_metrics_proto_rawDescGZIP(), []int{0}
}

func (x *Metrics) GetAbsoluteTopImpressionPercentage() *wrappers.DoubleValue {
	if x != nil {
		return x.AbsoluteTopImpressionPercentage
	}
	return nil
}

func (x *Metrics) GetActiveViewCpm() *wrappers.DoubleValue {
	if x != nil {
		return x.ActiveViewCpm
	}
	return nil
}

func (x *Metrics) GetActiveViewCtr() *wrappers.DoubleValue {
	if x != nil {
		return x.ActiveViewCtr
	}
	return nil
}

func (x *Metrics) GetActiveViewImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.ActiveViewImpressions
	}
	return nil
}

func (x *Metrics) GetActiveViewMeasurability() *wrappers.DoubleValue {
	if x != nil {
		return x.ActiveViewMeasurability
	}
	return nil
}

func (x *Metrics) GetActiveViewMeasurableCostMicros() *wrappers.Int64Value {
	if x != nil {
		return x.ActiveViewMeasurableCostMicros
	}
	return nil
}

func (x *Metrics) GetActiveViewMeasurableImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.ActiveViewMeasurableImpressions
	}
	return nil
}

func (x *Metrics) GetActiveViewViewability() *wrappers.DoubleValue {
	if x != nil {
		return x.ActiveViewViewability
	}
	return nil
}

func (x *Metrics) GetAllConversionsFromInteractionsRate() *wrappers.DoubleValue {
	if x != nil {
		return x.AllConversionsFromInteractionsRate
	}
	return nil
}

func (x *Metrics) GetAllConversionsValue() *wrappers.DoubleValue {
	if x != nil {
		return x.AllConversionsValue
	}
	return nil
}

func (x *Metrics) GetAllConversions() *wrappers.DoubleValue {
	if x != nil {
		return x.AllConversions
	}
	return nil
}

func (x *Metrics) GetAllConversionsValuePerCost() *wrappers.DoubleValue {
	if x != nil {
		return x.AllConversionsValuePerCost
	}
	return nil
}

func (x *Metrics) GetAllConversionsFromClickToCall() *wrappers.DoubleValue {
	if x != nil {
		return x.AllConversionsFromClickToCall
	}
	return nil
}

func (x *Metrics) GetAllConversionsFromDirections() *wrappers.DoubleValue {
	if x != nil {
		return x.AllConversionsFromDirections
	}
	return nil
}

func (x *Metrics) GetAllConversionsFromInteractionsValuePerInteraction() *wrappers.DoubleValue {
	if x != nil {
		return x.AllConversionsFromInteractionsValuePerInteraction
	}
	return nil
}

func (x *Metrics) GetAllConversionsFromMenu() *wrappers.DoubleValue {
	if x != nil {
		return x.AllConversionsFromMenu
	}
	return nil
}

func (x *Metrics) GetAllConversionsFromOrder() *wrappers.DoubleValue {
	if x != nil {
		return x.AllConversionsFromOrder
	}
	return nil
}

func (x *Metrics) GetAllConversionsFromOtherEngagement() *wrappers.DoubleValue {
	if x != nil {
		return x.AllConversionsFromOtherEngagement
	}
	return nil
}

func (x *Metrics) GetAllConversionsFromStoreVisit() *wrappers.DoubleValue {
	if x != nil {
		return x.AllConversionsFromStoreVisit
	}
	return nil
}

func (x *Metrics) GetAllConversionsFromStoreWebsite() *wrappers.DoubleValue {
	if x != nil {
		return x.AllConversionsFromStoreWebsite
	}
	return nil
}

func (x *Metrics) GetAverageCost() *wrappers.DoubleValue {
	if x != nil {
		return x.AverageCost
	}
	return nil
}

func (x *Metrics) GetAverageCpc() *wrappers.DoubleValue {
	if x != nil {
		return x.AverageCpc
	}
	return nil
}

func (x *Metrics) GetAverageCpe() *wrappers.DoubleValue {
	if x != nil {
		return x.AverageCpe
	}
	return nil
}

func (x *Metrics) GetAverageCpm() *wrappers.DoubleValue {
	if x != nil {
		return x.AverageCpm
	}
	return nil
}

func (x *Metrics) GetAverageCpv() *wrappers.DoubleValue {
	if x != nil {
		return x.AverageCpv
	}
	return nil
}

func (x *Metrics) GetAveragePageViews() *wrappers.DoubleValue {
	if x != nil {
		return x.AveragePageViews
	}
	return nil
}

func (x *Metrics) GetAverageTimeOnSite() *wrappers.DoubleValue {
	if x != nil {
		return x.AverageTimeOnSite
	}
	return nil
}

func (x *Metrics) GetBenchmarkAverageMaxCpc() *wrappers.DoubleValue {
	if x != nil {
		return x.BenchmarkAverageMaxCpc
	}
	return nil
}

func (x *Metrics) GetBenchmarkCtr() *wrappers.DoubleValue {
	if x != nil {
		return x.BenchmarkCtr
	}
	return nil
}

func (x *Metrics) GetBounceRate() *wrappers.DoubleValue {
	if x != nil {
		return x.BounceRate
	}
	return nil
}

func (x *Metrics) GetClicks() *wrappers.Int64Value {
	if x != nil {
		return x.Clicks
	}
	return nil
}

func (x *Metrics) GetCombinedClicks() *wrappers.Int64Value {
	if x != nil {
		return x.CombinedClicks
	}
	return nil
}

func (x *Metrics) GetCombinedClicksPerQuery() *wrappers.DoubleValue {
	if x != nil {
		return x.CombinedClicksPerQuery
	}
	return nil
}

func (x *Metrics) GetCombinedQueries() *wrappers.Int64Value {
	if x != nil {
		return x.CombinedQueries
	}
	return nil
}

func (x *Metrics) GetContentBudgetLostImpressionShare() *wrappers.DoubleValue {
	if x != nil {
		return x.ContentBudgetLostImpressionShare
	}
	return nil
}

func (x *Metrics) GetContentImpressionShare() *wrappers.DoubleValue {
	if x != nil {
		return x.ContentImpressionShare
	}
	return nil
}

func (x *Metrics) GetConversionLastReceivedRequestDateTime() *wrappers.StringValue {
	if x != nil {
		return x.ConversionLastReceivedRequestDateTime
	}
	return nil
}

func (x *Metrics) GetConversionLastConversionDate() *wrappers.StringValue {
	if x != nil {
		return x.ConversionLastConversionDate
	}
	return nil
}

func (x *Metrics) GetContentRankLostImpressionShare() *wrappers.DoubleValue {
	if x != nil {
		return x.ContentRankLostImpressionShare
	}
	return nil
}

func (x *Metrics) GetConversionsFromInteractionsRate() *wrappers.DoubleValue {
	if x != nil {
		return x.ConversionsFromInteractionsRate
	}
	return nil
}

func (x *Metrics) GetConversionsValue() *wrappers.DoubleValue {
	if x != nil {
		return x.ConversionsValue
	}
	return nil
}

func (x *Metrics) GetConversionsValuePerCost() *wrappers.DoubleValue {
	if x != nil {
		return x.ConversionsValuePerCost
	}
	return nil
}

func (x *Metrics) GetConversionsFromInteractionsValuePerInteraction() *wrappers.DoubleValue {
	if x != nil {
		return x.ConversionsFromInteractionsValuePerInteraction
	}
	return nil
}

func (x *Metrics) GetConversions() *wrappers.DoubleValue {
	if x != nil {
		return x.Conversions
	}
	return nil
}

func (x *Metrics) GetCostMicros() *wrappers.Int64Value {
	if x != nil {
		return x.CostMicros
	}
	return nil
}

func (x *Metrics) GetCostPerAllConversions() *wrappers.DoubleValue {
	if x != nil {
		return x.CostPerAllConversions
	}
	return nil
}

func (x *Metrics) GetCostPerConversion() *wrappers.DoubleValue {
	if x != nil {
		return x.CostPerConversion
	}
	return nil
}

func (x *Metrics) GetCostPerCurrentModelAttributedConversion() *wrappers.DoubleValue {
	if x != nil {
		return x.CostPerCurrentModelAttributedConversion
	}
	return nil
}

func (x *Metrics) GetCrossDeviceConversions() *wrappers.DoubleValue {
	if x != nil {
		return x.CrossDeviceConversions
	}
	return nil
}

func (x *Metrics) GetCtr() *wrappers.DoubleValue {
	if x != nil {
		return x.Ctr
	}
	return nil
}

func (x *Metrics) GetCurrentModelAttributedConversions() *wrappers.DoubleValue {
	if x != nil {
		return x.CurrentModelAttributedConversions
	}
	return nil
}

func (x *Metrics) GetCurrentModelAttributedConversionsFromInteractionsRate() *wrappers.DoubleValue {
	if x != nil {
		return x.CurrentModelAttributedConversionsFromInteractionsRate
	}
	return nil
}

func (x *Metrics) GetCurrentModelAttributedConversionsFromInteractionsValuePerInteraction() *wrappers.DoubleValue {
	if x != nil {
		return x.CurrentModelAttributedConversionsFromInteractionsValuePerInteraction
	}
	return nil
}

func (x *Metrics) GetCurrentModelAttributedConversionsValue() *wrappers.DoubleValue {
	if x != nil {
		return x.CurrentModelAttributedConversionsValue
	}
	return nil
}

func (x *Metrics) GetCurrentModelAttributedConversionsValuePerCost() *wrappers.DoubleValue {
	if x != nil {
		return x.CurrentModelAttributedConversionsValuePerCost
	}
	return nil
}

func (x *Metrics) GetEngagementRate() *wrappers.DoubleValue {
	if x != nil {
		return x.EngagementRate
	}
	return nil
}

func (x *Metrics) GetEngagements() *wrappers.Int64Value {
	if x != nil {
		return x.Engagements
	}
	return nil
}

func (x *Metrics) GetHotelAverageLeadValueMicros() *wrappers.DoubleValue {
	if x != nil {
		return x.HotelAverageLeadValueMicros
	}
	return nil
}

func (x *Metrics) GetHotelPriceDifferencePercentage() *wrappers.DoubleValue {
	if x != nil {
		return x.HotelPriceDifferencePercentage
	}
	return nil
}

func (x *Metrics) GetHistoricalCreativeQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if x != nil {
		return x.HistoricalCreativeQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (x *Metrics) GetHistoricalLandingPageQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if x != nil {
		return x.HistoricalLandingPageQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (x *Metrics) GetHistoricalQualityScore() *wrappers.Int64Value {
	if x != nil {
		return x.HistoricalQualityScore
	}
	return nil
}

func (x *Metrics) GetHistoricalSearchPredictedCtr() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if x != nil {
		return x.HistoricalSearchPredictedCtr
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (x *Metrics) GetGmailForwards() *wrappers.Int64Value {
	if x != nil {
		return x.GmailForwards
	}
	return nil
}

func (x *Metrics) GetGmailSaves() *wrappers.Int64Value {
	if x != nil {
		return x.GmailSaves
	}
	return nil
}

func (x *Metrics) GetGmailSecondaryClicks() *wrappers.Int64Value {
	if x != nil {
		return x.GmailSecondaryClicks
	}
	return nil
}

func (x *Metrics) GetImpressionsFromStoreReach() *wrappers.Int64Value {
	if x != nil {
		return x.ImpressionsFromStoreReach
	}
	return nil
}

func (x *Metrics) GetImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.Impressions
	}
	return nil
}

func (x *Metrics) GetInteractionRate() *wrappers.DoubleValue {
	if x != nil {
		return x.InteractionRate
	}
	return nil
}

func (x *Metrics) GetInteractions() *wrappers.Int64Value {
	if x != nil {
		return x.Interactions
	}
	return nil
}

func (x *Metrics) GetInteractionEventTypes() []enums.InteractionEventTypeEnum_InteractionEventType {
	if x != nil {
		return x.InteractionEventTypes
	}
	return nil
}

func (x *Metrics) GetInvalidClickRate() *wrappers.DoubleValue {
	if x != nil {
		return x.InvalidClickRate
	}
	return nil
}

func (x *Metrics) GetInvalidClicks() *wrappers.Int64Value {
	if x != nil {
		return x.InvalidClicks
	}
	return nil
}

func (x *Metrics) GetMessageChats() *wrappers.Int64Value {
	if x != nil {
		return x.MessageChats
	}
	return nil
}

func (x *Metrics) GetMessageImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.MessageImpressions
	}
	return nil
}

func (x *Metrics) GetMessageChatRate() *wrappers.DoubleValue {
	if x != nil {
		return x.MessageChatRate
	}
	return nil
}

func (x *Metrics) GetMobileFriendlyClicksPercentage() *wrappers.DoubleValue {
	if x != nil {
		return x.MobileFriendlyClicksPercentage
	}
	return nil
}

func (x *Metrics) GetOrganicClicks() *wrappers.Int64Value {
	if x != nil {
		return x.OrganicClicks
	}
	return nil
}

func (x *Metrics) GetOrganicClicksPerQuery() *wrappers.DoubleValue {
	if x != nil {
		return x.OrganicClicksPerQuery
	}
	return nil
}

func (x *Metrics) GetOrganicImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.OrganicImpressions
	}
	return nil
}

func (x *Metrics) GetOrganicImpressionsPerQuery() *wrappers.DoubleValue {
	if x != nil {
		return x.OrganicImpressionsPerQuery
	}
	return nil
}

func (x *Metrics) GetOrganicQueries() *wrappers.Int64Value {
	if x != nil {
		return x.OrganicQueries
	}
	return nil
}

func (x *Metrics) GetPercentNewVisitors() *wrappers.DoubleValue {
	if x != nil {
		return x.PercentNewVisitors
	}
	return nil
}

func (x *Metrics) GetPhoneCalls() *wrappers.Int64Value {
	if x != nil {
		return x.PhoneCalls
	}
	return nil
}

func (x *Metrics) GetPhoneImpressions() *wrappers.Int64Value {
	if x != nil {
		return x.PhoneImpressions
	}
	return nil
}

func (x *Metrics) GetPhoneThroughRate() *wrappers.DoubleValue {
	if x != nil {
		return x.PhoneThroughRate
	}
	return nil
}

func (x *Metrics) GetRelativeCtr() *wrappers.DoubleValue {
	if x != nil {
		return x.RelativeCtr
	}
	return nil
}

func (x *Metrics) GetSearchAbsoluteTopImpressionShare() *wrappers.DoubleValue {
	if x != nil {
		return x.SearchAbsoluteTopImpressionShare
	}
	return nil
}

func (x *Metrics) GetSearchBudgetLostAbsoluteTopImpressionShare() *wrappers.DoubleValue {
	if x != nil {
		return x.SearchBudgetLostAbsoluteTopImpressionShare
	}
	return nil
}

func (x *Metrics) GetSearchBudgetLostImpressionShare() *wrappers.DoubleValue {
	if x != nil {
		return x.SearchBudgetLostImpressionShare
	}
	return nil
}

func (x *Metrics) GetSearchBudgetLostTopImpressionShare() *wrappers.DoubleValue {
	if x != nil {
		return x.SearchBudgetLostTopImpressionShare
	}
	return nil
}

func (x *Metrics) GetSearchClickShare() *wrappers.DoubleValue {
	if x != nil {
		return x.SearchClickShare
	}
	return nil
}

func (x *Metrics) GetSearchExactMatchImpressionShare() *wrappers.DoubleValue {
	if x != nil {
		return x.SearchExactMatchImpressionShare
	}
	return nil
}

func (x *Metrics) GetSearchImpressionShare() *wrappers.DoubleValue {
	if x != nil {
		return x.SearchImpressionShare
	}
	return nil
}

func (x *Metrics) GetSearchRankLostAbsoluteTopImpressionShare() *wrappers.DoubleValue {
	if x != nil {
		return x.SearchRankLostAbsoluteTopImpressionShare
	}
	return nil
}

func (x *Metrics) GetSearchRankLostImpressionShare() *wrappers.DoubleValue {
	if x != nil {
		return x.SearchRankLostImpressionShare
	}
	return nil
}

func (x *Metrics) GetSearchRankLostTopImpressionShare() *wrappers.DoubleValue {
	if x != nil {
		return x.SearchRankLostTopImpressionShare
	}
	return nil
}

func (x *Metrics) GetSearchTopImpressionShare() *wrappers.DoubleValue {
	if x != nil {
		return x.SearchTopImpressionShare
	}
	return nil
}

func (x *Metrics) GetSpeedScore() *wrappers.Int64Value {
	if x != nil {
		return x.SpeedScore
	}
	return nil
}

func (x *Metrics) GetTopImpressionPercentage() *wrappers.DoubleValue {
	if x != nil {
		return x.TopImpressionPercentage
	}
	return nil
}

func (x *Metrics) GetValidAcceleratedMobilePagesClicksPercentage() *wrappers.DoubleValue {
	if x != nil {
		return x.ValidAcceleratedMobilePagesClicksPercentage
	}
	return nil
}

func (x *Metrics) GetValuePerAllConversions() *wrappers.DoubleValue {
	if x != nil {
		return x.ValuePerAllConversions
	}
	return nil
}

func (x *Metrics) GetValuePerConversion() *wrappers.DoubleValue {
	if x != nil {
		return x.ValuePerConversion
	}
	return nil
}

func (x *Metrics) GetValuePerCurrentModelAttributedConversion() *wrappers.DoubleValue {
	if x != nil {
		return x.ValuePerCurrentModelAttributedConversion
	}
	return nil
}

func (x *Metrics) GetVideoQuartile_100Rate() *wrappers.DoubleValue {
	if x != nil {
		return x.VideoQuartile_100Rate
	}
	return nil
}

func (x *Metrics) GetVideoQuartile_25Rate() *wrappers.DoubleValue {
	if x != nil {
		return x.VideoQuartile_25Rate
	}
	return nil
}

func (x *Metrics) GetVideoQuartile_50Rate() *wrappers.DoubleValue {
	if x != nil {
		return x.VideoQuartile_50Rate
	}
	return nil
}

func (x *Metrics) GetVideoQuartile_75Rate() *wrappers.DoubleValue {
	if x != nil {
		return x.VideoQuartile_75Rate
	}
	return nil
}

func (x *Metrics) GetVideoViewRate() *wrappers.DoubleValue {
	if x != nil {
		return x.VideoViewRate
	}
	return nil
}

func (x *Metrics) GetVideoViews() *wrappers.Int64Value {
	if x != nil {
		return x.VideoViews
	}
	return nil
}

func (x *Metrics) GetViewThroughConversions() *wrappers.Int64Value {
	if x != nil {
		return x.ViewThroughConversions
	}
	return nil
}

var File_google_ads_googleads_v3_common_metrics_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v3_common_metrics_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x1a, 0x3a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x33, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xc5, 0x4f, 0x0a, 0x07, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x69,
	0x0a, 0x22, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x61, 0x67, 0x65, 0x18, 0x5f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1f, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x65, 0x54, 0x6f, 0x70, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50,
	0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x12, 0x44, 0x0a, 0x0f, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63, 0x70, 0x6d, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x65, 0x77, 0x43, 0x70, 0x6d, 0x12,
	0x44, 0x0a, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63,
	0x74, 0x72, 0x18, 0x4f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69,
	0x65, 0x77, 0x43, 0x74, 0x72, 0x12, 0x53, 0x0a, 0x17, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x76, 0x69, 0x65, 0x77, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x15, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x65, 0x77, 0x49,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x58, 0x0a, 0x19, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x60, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x56, 0x69, 0x65, 0x77, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x12, 0x67, 0x0a, 0x22, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63,
	0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1e, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69, 0x65, 0x77, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x61,
	0x62, 0x6c, 0x65, 0x43, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x68, 0x0a,
	0x22, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69,
	0x65, 0x77, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x54, 0x0a, 0x17, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x18, 0x61, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x69,
	0x65, 0x77, 0x56, 0x69, 0x65, 0x77, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x70, 0x0a,
	0x26, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x41, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x22, 0x61, 0x6c, 0x6c,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x61, 0x74, 0x65, 0x12,
	0x50, 0x0a, 0x15, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x42, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x61, 0x6c,
	0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x45, 0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x60, 0x0a, 0x1e, 0x61, 0x6c, 0x6c, 0x5f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x3e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1a,
	0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x50, 0x65, 0x72, 0x43, 0x6f, 0x73, 0x74, 0x12, 0x67, 0x0a, 0x22, 0x61, 0x6c,
	0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72,
	0x6f, 0x6d, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x74, 0x6f, 0x5f, 0x63, 0x61, 0x6c, 0x6c,
	0x18, 0x76, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x1d, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x54, 0x6f, 0x43,
	0x61, 0x6c, 0x6c, 0x12, 0x63, 0x0a, 0x1f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x77, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1c, 0x61, 0x6c, 0x6c, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x90, 0x01, 0x0a, 0x37, 0x61, 0x6c, 0x6c,
	0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f,
	0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x43, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x31, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x65, 0x72,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x19, 0x61,
	0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66,
	0x72, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x6e, 0x75, 0x18, 0x78, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x61, 0x6c,
	0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d,
	0x4d, 0x65, 0x6e, 0x75, 0x12, 0x59, 0x0a, 0x1a, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x18, 0x79, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12,
	0x6e, 0x0a, 0x25, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x65, 0x6e,
	0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x7a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x21, 0x61, 0x6c,
	0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d,
	0x4f, 0x74, 0x68, 0x65, 0x72, 0x45, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x64, 0x0a, 0x20, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x76, 0x69,
	0x73, 0x69, 0x74, 0x18, 0x7b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1c, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x56, 0x69, 0x73, 0x69, 0x74, 0x12, 0x68, 0x0a, 0x22, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x5f, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x18, 0x7c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x1e, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46,
	0x72, 0x6f, 0x6d, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x57, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x12,
	0x3f, 0x0a, 0x0c, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0b, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x73, 0x74,
	0x12, 0x3d, 0x0a, 0x0b, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x70, 0x63, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0a, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x43, 0x70, 0x63, 0x12,
	0x3d, 0x0a, 0x0b, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x70, 0x65, 0x18, 0x62,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0a, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x43, 0x70, 0x65, 0x12, 0x3d,
	0x0a, 0x0b, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x70, 0x6d, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0a, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x43, 0x70, 0x6d, 0x12, 0x3d, 0x0a,
	0x0b, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x70, 0x76, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0a, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x43, 0x70, 0x76, 0x12, 0x4a, 0x0a, 0x12,
	0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x18, 0x63, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x50,
	0x61, 0x67, 0x65, 0x56, 0x69, 0x65, 0x77, 0x73, 0x12, 0x4d, 0x0a, 0x14, 0x61, 0x76, 0x65, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x74, 0x65,
	0x18, 0x54, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x4f, 0x6e, 0x53, 0x69, 0x74, 0x65, 0x12, 0x57, 0x0a, 0x19, 0x62, 0x65, 0x6e, 0x63, 0x68,
	0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6d, 0x61, 0x78,
	0x5f, 0x63, 0x70, 0x63, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x62, 0x65, 0x6e, 0x63, 0x68, 0x6d,
	0x61, 0x72, 0x6b, 0x41, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x4d, 0x61, 0x78, 0x43, 0x70, 0x63,
	0x12, 0x41, 0x0a, 0x0d, 0x62, 0x65, 0x6e, 0x63, 0x68, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x63, 0x74,
	0x72, 0x18, 0x4d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x62, 0x65, 0x6e, 0x63, 0x68, 0x6d, 0x61, 0x72, 0x6b,
	0x43, 0x74, 0x72, 0x12, 0x3d, 0x0a, 0x0b, 0x62, 0x6f, 0x75, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x61,
	0x74, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x62, 0x6f, 0x75, 0x6e, 0x63, 0x65, 0x52, 0x61,
	0x74, 0x65, 0x12, 0x33, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x06, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x44, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x62, 0x69,
	0x6e, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x73, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x63,
	0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x57, 0x0a,
	0x19, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73,
	0x5f, 0x70, 0x65, 0x72, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x74, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16,
	0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x50, 0x65,
	0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x46, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e,
	0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x75, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x63,
	0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x6c,
	0x0a, 0x24, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x20, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4c, 0x6f, 0x73, 0x74, 0x49, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x56, 0x0a, 0x18,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x12, 0x77, 0x0a, 0x2a, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x49, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x25, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x4c, 0x61, 0x73, 0x74, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x63, 0x0a,
	0x1f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x73, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65,
	0x18, 0x4a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x1c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x4c, 0x61, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x61,
	0x74, 0x65, 0x12, 0x68, 0x0a, 0x22, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x61,
	0x6e, 0x6b, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1e, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x61, 0x6e, 0x6b, 0x4c, 0x6f, 0x73, 0x74, 0x49, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x69, 0x0a, 0x22,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x72, 0x61,
	0x74, 0x65, 0x18, 0x45, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x61, 0x74, 0x65, 0x12, 0x49, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x46, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x59, 0x0a, 0x1a, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x73, 0x74,
	0x18, 0x47, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x65, 0x72, 0x43, 0x6f, 0x73, 0x74, 0x12, 0x89, 0x01,
	0x0a, 0x33, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72,
	0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x48, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x65, 0x72, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x0b, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3c, 0x0a, 0x0b, 0x63, 0x6f, 0x73,
	0x74, 0x5f, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x63, 0x6f, 0x73,
	0x74, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x55, 0x0a, 0x18, 0x63, 0x6f, 0x73, 0x74, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x44, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x63, 0x6f, 0x73, 0x74, 0x50, 0x65, 0x72,
	0x41, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4c,
	0x0a, 0x13, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x63, 0x6f, 0x73, 0x74, 0x50,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x7b, 0x0a, 0x2c,
	0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x6a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x27, 0x63, 0x6f, 0x73, 0x74, 0x50, 0x65, 0x72, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x18, 0x63, 0x72, 0x6f,
	0x73, 0x73, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x63, 0x72, 0x6f, 0x73, 0x73,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x2e, 0x0a, 0x03, 0x63, 0x74, 0x72, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x63, 0x74,
	0x72, 0x12, 0x6d, 0x0a, 0x24, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x21, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x98, 0x01, 0x0a, 0x3b, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x35, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x61, 0x74, 0x65, 0x12, 0xb8, 0x01, 0x0a, 0x4c,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x67, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x44, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x78, 0x0a, 0x2a, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x68, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x26, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x88, 0x01, 0x0a, 0x33, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x69, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x2d, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x50, 0x65, 0x72, 0x43, 0x6f, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x0f, 0x65,
	0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x1f,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0e, 0x65, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x61,
	0x74, 0x65, 0x12, 0x3d, 0x0a, 0x0b, 0x65, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x65, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x62, 0x0a, 0x1f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x61, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x6c, 0x65, 0x61, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x6d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x18, 0x4b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1b, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x41,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x65, 0x61, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4d,
	0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x68, 0x0a, 0x21, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x70,
	0x72, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f,
	0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x81, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x1e, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x50, 0x72, 0x69, 0x63, 0x65, 0x44, 0x69, 0x66, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x12,
	0x93, 0x01, 0x0a, 0x21, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x50, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45, 0x6e,
	0x75, 0x6d, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x1e, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61,
	0x6c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x76, 0x65, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x9a, 0x01, 0x0a, 0x25, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72,
	0x69, 0x63, 0x61, 0x6c, 0x5f, 0x6c, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18,
	0x51, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f,
	0x72, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x51, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52,
	0x21, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x4c, 0x61, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x50, 0x61, 0x67, 0x65, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f,
	0x72, 0x65, 0x12, 0x55, 0x0a, 0x18, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c,
	0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x52,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x16, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x51, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x8f, 0x01, 0x0a, 0x1f, 0x68, 0x69,
	0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f,
	0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x74, 0x72, 0x18, 0x53, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x1c, 0x68,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x43, 0x74, 0x72, 0x12, 0x42, 0x0a, 0x0e, 0x67,
	0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x73, 0x18, 0x55, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0d, 0x67, 0x6d, 0x61, 0x69, 0x6c, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x73, 0x12,
	0x3c, 0x0a, 0x0b, 0x67, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x73, 0x61, 0x76, 0x65, 0x73, 0x18, 0x56,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0a, 0x67, 0x6d, 0x61, 0x69, 0x6c, 0x53, 0x61, 0x76, 0x65, 0x73, 0x12, 0x51, 0x0a,
	0x16, 0x67, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79,
	0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x57, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x67, 0x6d, 0x61, 0x69,
	0x6c, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73,
	0x12, 0x5c, 0x0a, 0x1c, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x18, 0x7d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x19, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x46, 0x72, 0x6f, 0x6d, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x61, 0x63, 0x68, 0x12, 0x3d,
	0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x25, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0b, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x0a,
	0x10, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x61, 0x74,
	0x65, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x61, 0x74, 0x65, 0x12, 0x3f, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x17, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x18, 0x64, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x33, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e,
	0x75, 0x6d, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x15, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x4a,
	0x0a, 0x12, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f,
	0x72, 0x61, 0x74, 0x65, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x52, 0x61, 0x74, 0x65, 0x12, 0x42, 0x0a, 0x0e, 0x69, 0x6e,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x18, 0x29, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0d, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x40,
	0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x74, 0x73, 0x18,
	0x7e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x43, 0x68, 0x61, 0x74, 0x73,
	0x12, 0x4c, 0x0a, 0x13, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x7f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x49,
	0x0a, 0x11, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x74, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x18, 0x80, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x43, 0x68, 0x61, 0x74, 0x52, 0x61, 0x74, 0x65, 0x12, 0x67, 0x0a, 0x21, 0x6d, 0x6f, 0x62,
	0x69, 0x6c, 0x65, 0x5f, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79, 0x5f, 0x63, 0x6c, 0x69,
	0x63, 0x6b, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x6d,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x1e, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x46, 0x72, 0x69, 0x65, 0x6e, 0x64,
	0x6c, 0x79, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61,
	0x67, 0x65, 0x12, 0x42, 0x0a, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x5f, 0x63, 0x6c,
	0x69, 0x63, 0x6b, 0x73, 0x18, 0x6e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63,
	0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x12, 0x55, 0x0a, 0x18, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x63, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x18, 0x6f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x43,
	0x6c, 0x69, 0x63, 0x6b, 0x73, 0x50, 0x65, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x4c, 0x0a,
	0x13, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x70, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63,
	0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5f, 0x0a, 0x1d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x71, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x1a, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x50, 0x65, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x44, 0x0a, 0x0f,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x72, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0e, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x51, 0x75, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x4e, 0x0a, 0x14, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x65,
	0x77, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12,
	0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x4e, 0x65, 0x77, 0x56, 0x69, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x73, 0x12, 0x3c, 0x0a, 0x0b, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c,
	0x73, 0x18, 0x2b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x73,
	0x12, 0x48, 0x0a, 0x11, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x49,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4a, 0x0a, 0x12, 0x70, 0x68,
	0x6f, 0x6e, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x18, 0x2d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x54, 0x68, 0x72, 0x6f, 0x75,
	0x67, 0x68, 0x52, 0x61, 0x74, 0x65, 0x12, 0x3f, 0x0a, 0x0c, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x63, 0x74, 0x72, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x72, 0x65, 0x6c, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x43, 0x74, 0x72, 0x12, 0x6c, 0x0a, 0x24, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18,
	0x4e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x20, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x62, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x65, 0x54, 0x6f, 0x70, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x82, 0x01, 0x0a, 0x30, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x61, 0x62, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x58, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x2a,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4c, 0x6f, 0x73, 0x74,
	0x41, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x54, 0x6f, 0x70, 0x49, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x6a, 0x0a, 0x23, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x6f, 0x73, 0x74,
	0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x18, 0x2f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x42, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x4c, 0x6f, 0x73, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x71, 0x0a, 0x27, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x74, 0x6f, 0x70,
	0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x18, 0x59, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x22, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x42, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x4c, 0x6f, 0x73, 0x74, 0x54, 0x6f, 0x70, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x4a, 0x0a, 0x12, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18,
	0x30, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x10, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6c, 0x69, 0x63, 0x6b,
	0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x6a, 0x0a, 0x23, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f,
	0x65, 0x78, 0x61, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x31, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x1f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x78, 0x61, 0x63, 0x74, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72,
	0x65, 0x12, 0x54, 0x0a, 0x17, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x69, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x32, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x15, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x7e, 0x0a, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x61, 0x62, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x5a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x28, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x61, 0x6e, 0x6b, 0x4c, 0x6f, 0x73, 0x74, 0x41, 0x62, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x65, 0x54, 0x6f, 0x70, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x66, 0x0a, 0x21, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x33, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x1d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x61, 0x6e, 0x6b, 0x4c, 0x6f, 0x73, 0x74,
	0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12,
	0x6d, 0x0a, 0x25, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x6c,
	0x6f, 0x73, 0x74, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x5b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x20, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x52, 0x61, 0x6e, 0x6b, 0x4c, 0x6f, 0x73, 0x74, 0x54, 0x6f, 0x70, 0x49,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x5b,
	0x0a, 0x1b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x69, 0x6d, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x5c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x18, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x6f, 0x70, 0x49, 0x6d, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x3c, 0x0a, 0x0b, 0x73,
	0x70, 0x65, 0x65, 0x64, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x6b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x73,
	0x70, 0x65, 0x65, 0x64, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x58, 0x0a, 0x19, 0x74, 0x6f, 0x70,
	0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x5d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x74, 0x6f, 0x70, 0x49,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x61, 0x67, 0x65, 0x12, 0x83, 0x01, 0x0a, 0x30, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x61, 0x63,
	0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x73, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x5f, 0x70, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x6c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x2b, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x6f,
	0x62, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x67, 0x65, 0x73, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x50,
	0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x12, 0x57, 0x0a, 0x19, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x34, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x50, 0x65, 0x72, 0x41, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x4e, 0x0a, 0x14, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x35, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x7d, 0x0a, 0x2d, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x5f,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x5e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x28, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x65,
	0x72, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x53, 0x0a, 0x17, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x71, 0x75, 0x61, 0x72, 0x74,
	0x69, 0x6c, 0x65, 0x5f, 0x31, 0x30, 0x30, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x36, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x14, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x51, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x31,
	0x30, 0x30, 0x52, 0x61, 0x74, 0x65, 0x12, 0x51, 0x0a, 0x16, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f,
	0x71, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x5f, 0x32, 0x35, 0x5f, 0x72, 0x61, 0x74, 0x65,
	0x18, 0x37, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x51, 0x75, 0x61, 0x72, 0x74,
	0x69, 0x6c, 0x65, 0x32, 0x35, 0x52, 0x61, 0x74, 0x65, 0x12, 0x51, 0x0a, 0x16, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x5f, 0x71, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x5f, 0x35, 0x30, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x18, 0x38, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x51, 0x75,
	0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x35, 0x30, 0x52, 0x61, 0x74, 0x65, 0x12, 0x51, 0x0a, 0x16,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x71, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x5f, 0x37,
	0x35, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x39, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x51, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x37, 0x35, 0x52, 0x61, 0x74, 0x65, 0x12,
	0x44, 0x0a, 0x0f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x72, 0x61,
	0x74, 0x65, 0x18, 0x3a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x56, 0x69, 0x65,
	0x77, 0x52, 0x61, 0x74, 0x65, 0x12, 0x3c, 0x0a, 0x0b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x73, 0x18, 0x3b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x56, 0x69,
	0x65, 0x77, 0x73, 0x12, 0x55, 0x0a, 0x18, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x74, 0x68, 0x72, 0x6f,
	0x75, 0x67, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x3c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x16, 0x76, 0x69, 0x65, 0x77, 0x54, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0xe7, 0x01, 0x0a, 0x22, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x42, 0x0c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x1e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x33, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xca, 0x02,
	0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x33, 0x5c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xea,
	0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x33, 0x3a, 0x3a, 0x43, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v3_common_metrics_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v3_common_metrics_proto_rawDescData = file_google_ads_googleads_v3_common_metrics_proto_rawDesc
)

func file_google_ads_googleads_v3_common_metrics_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v3_common_metrics_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v3_common_metrics_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v3_common_metrics_proto_rawDescData)
	})
	return file_google_ads_googleads_v3_common_metrics_proto_rawDescData
}

var file_google_ads_googleads_v3_common_metrics_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_ads_googleads_v3_common_metrics_proto_goTypes = []interface{}{
	(*Metrics)(nil),                                          // 0: google.ads.googleads.v3.common.Metrics
	(*wrappers.DoubleValue)(nil),                             // 1: google.protobuf.DoubleValue
	(*wrappers.Int64Value)(nil),                              // 2: google.protobuf.Int64Value
	(*wrappers.StringValue)(nil),                             // 3: google.protobuf.StringValue
	(enums.QualityScoreBucketEnum_QualityScoreBucket)(0),     // 4: google.ads.googleads.v3.enums.QualityScoreBucketEnum.QualityScoreBucket
	(enums.InteractionEventTypeEnum_InteractionEventType)(0), // 5: google.ads.googleads.v3.enums.InteractionEventTypeEnum.InteractionEventType
}
var file_google_ads_googleads_v3_common_metrics_proto_depIdxs = []int32{
	1,   // 0: google.ads.googleads.v3.common.Metrics.absolute_top_impression_percentage:type_name -> google.protobuf.DoubleValue
	1,   // 1: google.ads.googleads.v3.common.Metrics.active_view_cpm:type_name -> google.protobuf.DoubleValue
	1,   // 2: google.ads.googleads.v3.common.Metrics.active_view_ctr:type_name -> google.protobuf.DoubleValue
	2,   // 3: google.ads.googleads.v3.common.Metrics.active_view_impressions:type_name -> google.protobuf.Int64Value
	1,   // 4: google.ads.googleads.v3.common.Metrics.active_view_measurability:type_name -> google.protobuf.DoubleValue
	2,   // 5: google.ads.googleads.v3.common.Metrics.active_view_measurable_cost_micros:type_name -> google.protobuf.Int64Value
	2,   // 6: google.ads.googleads.v3.common.Metrics.active_view_measurable_impressions:type_name -> google.protobuf.Int64Value
	1,   // 7: google.ads.googleads.v3.common.Metrics.active_view_viewability:type_name -> google.protobuf.DoubleValue
	1,   // 8: google.ads.googleads.v3.common.Metrics.all_conversions_from_interactions_rate:type_name -> google.protobuf.DoubleValue
	1,   // 9: google.ads.googleads.v3.common.Metrics.all_conversions_value:type_name -> google.protobuf.DoubleValue
	1,   // 10: google.ads.googleads.v3.common.Metrics.all_conversions:type_name -> google.protobuf.DoubleValue
	1,   // 11: google.ads.googleads.v3.common.Metrics.all_conversions_value_per_cost:type_name -> google.protobuf.DoubleValue
	1,   // 12: google.ads.googleads.v3.common.Metrics.all_conversions_from_click_to_call:type_name -> google.protobuf.DoubleValue
	1,   // 13: google.ads.googleads.v3.common.Metrics.all_conversions_from_directions:type_name -> google.protobuf.DoubleValue
	1,   // 14: google.ads.googleads.v3.common.Metrics.all_conversions_from_interactions_value_per_interaction:type_name -> google.protobuf.DoubleValue
	1,   // 15: google.ads.googleads.v3.common.Metrics.all_conversions_from_menu:type_name -> google.protobuf.DoubleValue
	1,   // 16: google.ads.googleads.v3.common.Metrics.all_conversions_from_order:type_name -> google.protobuf.DoubleValue
	1,   // 17: google.ads.googleads.v3.common.Metrics.all_conversions_from_other_engagement:type_name -> google.protobuf.DoubleValue
	1,   // 18: google.ads.googleads.v3.common.Metrics.all_conversions_from_store_visit:type_name -> google.protobuf.DoubleValue
	1,   // 19: google.ads.googleads.v3.common.Metrics.all_conversions_from_store_website:type_name -> google.protobuf.DoubleValue
	1,   // 20: google.ads.googleads.v3.common.Metrics.average_cost:type_name -> google.protobuf.DoubleValue
	1,   // 21: google.ads.googleads.v3.common.Metrics.average_cpc:type_name -> google.protobuf.DoubleValue
	1,   // 22: google.ads.googleads.v3.common.Metrics.average_cpe:type_name -> google.protobuf.DoubleValue
	1,   // 23: google.ads.googleads.v3.common.Metrics.average_cpm:type_name -> google.protobuf.DoubleValue
	1,   // 24: google.ads.googleads.v3.common.Metrics.average_cpv:type_name -> google.protobuf.DoubleValue
	1,   // 25: google.ads.googleads.v3.common.Metrics.average_page_views:type_name -> google.protobuf.DoubleValue
	1,   // 26: google.ads.googleads.v3.common.Metrics.average_time_on_site:type_name -> google.protobuf.DoubleValue
	1,   // 27: google.ads.googleads.v3.common.Metrics.benchmark_average_max_cpc:type_name -> google.protobuf.DoubleValue
	1,   // 28: google.ads.googleads.v3.common.Metrics.benchmark_ctr:type_name -> google.protobuf.DoubleValue
	1,   // 29: google.ads.googleads.v3.common.Metrics.bounce_rate:type_name -> google.protobuf.DoubleValue
	2,   // 30: google.ads.googleads.v3.common.Metrics.clicks:type_name -> google.protobuf.Int64Value
	2,   // 31: google.ads.googleads.v3.common.Metrics.combined_clicks:type_name -> google.protobuf.Int64Value
	1,   // 32: google.ads.googleads.v3.common.Metrics.combined_clicks_per_query:type_name -> google.protobuf.DoubleValue
	2,   // 33: google.ads.googleads.v3.common.Metrics.combined_queries:type_name -> google.protobuf.Int64Value
	1,   // 34: google.ads.googleads.v3.common.Metrics.content_budget_lost_impression_share:type_name -> google.protobuf.DoubleValue
	1,   // 35: google.ads.googleads.v3.common.Metrics.content_impression_share:type_name -> google.protobuf.DoubleValue
	3,   // 36: google.ads.googleads.v3.common.Metrics.conversion_last_received_request_date_time:type_name -> google.protobuf.StringValue
	3,   // 37: google.ads.googleads.v3.common.Metrics.conversion_last_conversion_date:type_name -> google.protobuf.StringValue
	1,   // 38: google.ads.googleads.v3.common.Metrics.content_rank_lost_impression_share:type_name -> google.protobuf.DoubleValue
	1,   // 39: google.ads.googleads.v3.common.Metrics.conversions_from_interactions_rate:type_name -> google.protobuf.DoubleValue
	1,   // 40: google.ads.googleads.v3.common.Metrics.conversions_value:type_name -> google.protobuf.DoubleValue
	1,   // 41: google.ads.googleads.v3.common.Metrics.conversions_value_per_cost:type_name -> google.protobuf.DoubleValue
	1,   // 42: google.ads.googleads.v3.common.Metrics.conversions_from_interactions_value_per_interaction:type_name -> google.protobuf.DoubleValue
	1,   // 43: google.ads.googleads.v3.common.Metrics.conversions:type_name -> google.protobuf.DoubleValue
	2,   // 44: google.ads.googleads.v3.common.Metrics.cost_micros:type_name -> google.protobuf.Int64Value
	1,   // 45: google.ads.googleads.v3.common.Metrics.cost_per_all_conversions:type_name -> google.protobuf.DoubleValue
	1,   // 46: google.ads.googleads.v3.common.Metrics.cost_per_conversion:type_name -> google.protobuf.DoubleValue
	1,   // 47: google.ads.googleads.v3.common.Metrics.cost_per_current_model_attributed_conversion:type_name -> google.protobuf.DoubleValue
	1,   // 48: google.ads.googleads.v3.common.Metrics.cross_device_conversions:type_name -> google.protobuf.DoubleValue
	1,   // 49: google.ads.googleads.v3.common.Metrics.ctr:type_name -> google.protobuf.DoubleValue
	1,   // 50: google.ads.googleads.v3.common.Metrics.current_model_attributed_conversions:type_name -> google.protobuf.DoubleValue
	1,   // 51: google.ads.googleads.v3.common.Metrics.current_model_attributed_conversions_from_interactions_rate:type_name -> google.protobuf.DoubleValue
	1,   // 52: google.ads.googleads.v3.common.Metrics.current_model_attributed_conversions_from_interactions_value_per_interaction:type_name -> google.protobuf.DoubleValue
	1,   // 53: google.ads.googleads.v3.common.Metrics.current_model_attributed_conversions_value:type_name -> google.protobuf.DoubleValue
	1,   // 54: google.ads.googleads.v3.common.Metrics.current_model_attributed_conversions_value_per_cost:type_name -> google.protobuf.DoubleValue
	1,   // 55: google.ads.googleads.v3.common.Metrics.engagement_rate:type_name -> google.protobuf.DoubleValue
	2,   // 56: google.ads.googleads.v3.common.Metrics.engagements:type_name -> google.protobuf.Int64Value
	1,   // 57: google.ads.googleads.v3.common.Metrics.hotel_average_lead_value_micros:type_name -> google.protobuf.DoubleValue
	1,   // 58: google.ads.googleads.v3.common.Metrics.hotel_price_difference_percentage:type_name -> google.protobuf.DoubleValue
	4,   // 59: google.ads.googleads.v3.common.Metrics.historical_creative_quality_score:type_name -> google.ads.googleads.v3.enums.QualityScoreBucketEnum.QualityScoreBucket
	4,   // 60: google.ads.googleads.v3.common.Metrics.historical_landing_page_quality_score:type_name -> google.ads.googleads.v3.enums.QualityScoreBucketEnum.QualityScoreBucket
	2,   // 61: google.ads.googleads.v3.common.Metrics.historical_quality_score:type_name -> google.protobuf.Int64Value
	4,   // 62: google.ads.googleads.v3.common.Metrics.historical_search_predicted_ctr:type_name -> google.ads.googleads.v3.enums.QualityScoreBucketEnum.QualityScoreBucket
	2,   // 63: google.ads.googleads.v3.common.Metrics.gmail_forwards:type_name -> google.protobuf.Int64Value
	2,   // 64: google.ads.googleads.v3.common.Metrics.gmail_saves:type_name -> google.protobuf.Int64Value
	2,   // 65: google.ads.googleads.v3.common.Metrics.gmail_secondary_clicks:type_name -> google.protobuf.Int64Value
	2,   // 66: google.ads.googleads.v3.common.Metrics.impressions_from_store_reach:type_name -> google.protobuf.Int64Value
	2,   // 67: google.ads.googleads.v3.common.Metrics.impressions:type_name -> google.protobuf.Int64Value
	1,   // 68: google.ads.googleads.v3.common.Metrics.interaction_rate:type_name -> google.protobuf.DoubleValue
	2,   // 69: google.ads.googleads.v3.common.Metrics.interactions:type_name -> google.protobuf.Int64Value
	5,   // 70: google.ads.googleads.v3.common.Metrics.interaction_event_types:type_name -> google.ads.googleads.v3.enums.InteractionEventTypeEnum.InteractionEventType
	1,   // 71: google.ads.googleads.v3.common.Metrics.invalid_click_rate:type_name -> google.protobuf.DoubleValue
	2,   // 72: google.ads.googleads.v3.common.Metrics.invalid_clicks:type_name -> google.protobuf.Int64Value
	2,   // 73: google.ads.googleads.v3.common.Metrics.message_chats:type_name -> google.protobuf.Int64Value
	2,   // 74: google.ads.googleads.v3.common.Metrics.message_impressions:type_name -> google.protobuf.Int64Value
	1,   // 75: google.ads.googleads.v3.common.Metrics.message_chat_rate:type_name -> google.protobuf.DoubleValue
	1,   // 76: google.ads.googleads.v3.common.Metrics.mobile_friendly_clicks_percentage:type_name -> google.protobuf.DoubleValue
	2,   // 77: google.ads.googleads.v3.common.Metrics.organic_clicks:type_name -> google.protobuf.Int64Value
	1,   // 78: google.ads.googleads.v3.common.Metrics.organic_clicks_per_query:type_name -> google.protobuf.DoubleValue
	2,   // 79: google.ads.googleads.v3.common.Metrics.organic_impressions:type_name -> google.protobuf.Int64Value
	1,   // 80: google.ads.googleads.v3.common.Metrics.organic_impressions_per_query:type_name -> google.protobuf.DoubleValue
	2,   // 81: google.ads.googleads.v3.common.Metrics.organic_queries:type_name -> google.protobuf.Int64Value
	1,   // 82: google.ads.googleads.v3.common.Metrics.percent_new_visitors:type_name -> google.protobuf.DoubleValue
	2,   // 83: google.ads.googleads.v3.common.Metrics.phone_calls:type_name -> google.protobuf.Int64Value
	2,   // 84: google.ads.googleads.v3.common.Metrics.phone_impressions:type_name -> google.protobuf.Int64Value
	1,   // 85: google.ads.googleads.v3.common.Metrics.phone_through_rate:type_name -> google.protobuf.DoubleValue
	1,   // 86: google.ads.googleads.v3.common.Metrics.relative_ctr:type_name -> google.protobuf.DoubleValue
	1,   // 87: google.ads.googleads.v3.common.Metrics.search_absolute_top_impression_share:type_name -> google.protobuf.DoubleValue
	1,   // 88: google.ads.googleads.v3.common.Metrics.search_budget_lost_absolute_top_impression_share:type_name -> google.protobuf.DoubleValue
	1,   // 89: google.ads.googleads.v3.common.Metrics.search_budget_lost_impression_share:type_name -> google.protobuf.DoubleValue
	1,   // 90: google.ads.googleads.v3.common.Metrics.search_budget_lost_top_impression_share:type_name -> google.protobuf.DoubleValue
	1,   // 91: google.ads.googleads.v3.common.Metrics.search_click_share:type_name -> google.protobuf.DoubleValue
	1,   // 92: google.ads.googleads.v3.common.Metrics.search_exact_match_impression_share:type_name -> google.protobuf.DoubleValue
	1,   // 93: google.ads.googleads.v3.common.Metrics.search_impression_share:type_name -> google.protobuf.DoubleValue
	1,   // 94: google.ads.googleads.v3.common.Metrics.search_rank_lost_absolute_top_impression_share:type_name -> google.protobuf.DoubleValue
	1,   // 95: google.ads.googleads.v3.common.Metrics.search_rank_lost_impression_share:type_name -> google.protobuf.DoubleValue
	1,   // 96: google.ads.googleads.v3.common.Metrics.search_rank_lost_top_impression_share:type_name -> google.protobuf.DoubleValue
	1,   // 97: google.ads.googleads.v3.common.Metrics.search_top_impression_share:type_name -> google.protobuf.DoubleValue
	2,   // 98: google.ads.googleads.v3.common.Metrics.speed_score:type_name -> google.protobuf.Int64Value
	1,   // 99: google.ads.googleads.v3.common.Metrics.top_impression_percentage:type_name -> google.protobuf.DoubleValue
	1,   // 100: google.ads.googleads.v3.common.Metrics.valid_accelerated_mobile_pages_clicks_percentage:type_name -> google.protobuf.DoubleValue
	1,   // 101: google.ads.googleads.v3.common.Metrics.value_per_all_conversions:type_name -> google.protobuf.DoubleValue
	1,   // 102: google.ads.googleads.v3.common.Metrics.value_per_conversion:type_name -> google.protobuf.DoubleValue
	1,   // 103: google.ads.googleads.v3.common.Metrics.value_per_current_model_attributed_conversion:type_name -> google.protobuf.DoubleValue
	1,   // 104: google.ads.googleads.v3.common.Metrics.video_quartile_100_rate:type_name -> google.protobuf.DoubleValue
	1,   // 105: google.ads.googleads.v3.common.Metrics.video_quartile_25_rate:type_name -> google.protobuf.DoubleValue
	1,   // 106: google.ads.googleads.v3.common.Metrics.video_quartile_50_rate:type_name -> google.protobuf.DoubleValue
	1,   // 107: google.ads.googleads.v3.common.Metrics.video_quartile_75_rate:type_name -> google.protobuf.DoubleValue
	1,   // 108: google.ads.googleads.v3.common.Metrics.video_view_rate:type_name -> google.protobuf.DoubleValue
	2,   // 109: google.ads.googleads.v3.common.Metrics.video_views:type_name -> google.protobuf.Int64Value
	2,   // 110: google.ads.googleads.v3.common.Metrics.view_through_conversions:type_name -> google.protobuf.Int64Value
	111, // [111:111] is the sub-list for method output_type
	111, // [111:111] is the sub-list for method input_type
	111, // [111:111] is the sub-list for extension type_name
	111, // [111:111] is the sub-list for extension extendee
	0,   // [0:111] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v3_common_metrics_proto_init() }
func file_google_ads_googleads_v3_common_metrics_proto_init() {
	if File_google_ads_googleads_v3_common_metrics_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v3_common_metrics_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v3_common_metrics_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v3_common_metrics_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v3_common_metrics_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v3_common_metrics_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v3_common_metrics_proto = out.File
	file_google_ads_googleads_v3_common_metrics_proto_rawDesc = nil
	file_google_ads_googleads_v3_common_metrics_proto_goTypes = nil
	file_google_ads_googleads_v3_common_metrics_proto_depIdxs = nil
}
