// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/managedidentities/v1/resource.proto

package managedidentities

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents the different states of a managed domain.
type Domain_State int32

const (
	// Not set.
	Domain_STATE_UNSPECIFIED Domain_State = 0
	// The domain is being created.
	Domain_CREATING Domain_State = 1
	// The domain has been created and is fully usable.
	Domain_READY Domain_State = 2
	// The domain's configuration is being updated.
	Domain_UPDATING Domain_State = 3
	// The domain is being deleted.
	Domain_DELETING Domain_State = 4
	// The domain is being repaired and may be unusable. Details
	// can be found in the `status_message` field.
	Domain_REPAIRING Domain_State = 5
	// The domain is undergoing maintenance.
	Domain_PERFORMING_MAINTENANCE Domain_State = 6
	// The domain is not serving requests.
	Domain_UNAVAILABLE Domain_State = 7
)

var Domain_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "READY",
	3: "UPDATING",
	4: "DELETING",
	5: "REPAIRING",
	6: "PERFORMING_MAINTENANCE",
	7: "UNAVAILABLE",
}

var Domain_State_value = map[string]int32{
	"STATE_UNSPECIFIED":      0,
	"CREATING":               1,
	"READY":                  2,
	"UPDATING":               3,
	"DELETING":               4,
	"REPAIRING":              5,
	"PERFORMING_MAINTENANCE": 6,
	"UNAVAILABLE":            7,
}

func (x Domain_State) String() string {
	return proto.EnumName(Domain_State_name, int32(x))
}

func (Domain_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a15846c99e9279f9, []int{0, 0}
}

// Represents the different states of a domain trust.
type Trust_State int32

const (
	// Not set.
	Trust_STATE_UNSPECIFIED Trust_State = 0
	// The domain trust is being created.
	Trust_CREATING Trust_State = 1
	// The domain trust is being updated.
	Trust_UPDATING Trust_State = 2
	// The domain trust is being deleted.
	Trust_DELETING Trust_State = 3
	// The domain trust is connected.
	Trust_CONNECTED Trust_State = 4
	// The domain trust is disconnected.
	Trust_DISCONNECTED Trust_State = 5
)

var Trust_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "CREATING",
	2: "UPDATING",
	3: "DELETING",
	4: "CONNECTED",
	5: "DISCONNECTED",
}

var Trust_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"UPDATING":          2,
	"DELETING":          3,
	"CONNECTED":         4,
	"DISCONNECTED":      5,
}

func (x Trust_State) String() string {
	return proto.EnumName(Trust_State_name, int32(x))
}

func (Trust_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a15846c99e9279f9, []int{1, 0}
}

// Represents the different inter-forest trust types.
type Trust_TrustType int32

const (
	// Not set.
	Trust_TRUST_TYPE_UNSPECIFIED Trust_TrustType = 0
	// The forest trust.
	Trust_FOREST Trust_TrustType = 1
	// The external domain trust.
	Trust_EXTERNAL Trust_TrustType = 2
)

var Trust_TrustType_name = map[int32]string{
	0: "TRUST_TYPE_UNSPECIFIED",
	1: "FOREST",
	2: "EXTERNAL",
}

var Trust_TrustType_value = map[string]int32{
	"TRUST_TYPE_UNSPECIFIED": 0,
	"FOREST":                 1,
	"EXTERNAL":               2,
}

func (x Trust_TrustType) String() string {
	return proto.EnumName(Trust_TrustType_name, int32(x))
}

func (Trust_TrustType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a15846c99e9279f9, []int{1, 1}
}

// Represents the direction of trust.
// See
// [System.DirectoryServices.ActiveDirectory.TrustDirection](https://docs.microsoft.com/en-us/dotnet/api/system.directoryservices.activedirectory.trustdirection?view=netframework-4.7.2)
// for more information.
type Trust_TrustDirection int32

const (
	// Not set.
	Trust_TRUST_DIRECTION_UNSPECIFIED Trust_TrustDirection = 0
	// The inbound direction represents the trusting side.
	Trust_INBOUND Trust_TrustDirection = 1
	// The outboud direction represents the trusted side.
	Trust_OUTBOUND Trust_TrustDirection = 2
	// The bidirectional direction represents the trusted / trusting side.
	Trust_BIDIRECTIONAL Trust_TrustDirection = 3
)

var Trust_TrustDirection_name = map[int32]string{
	0: "TRUST_DIRECTION_UNSPECIFIED",
	1: "INBOUND",
	2: "OUTBOUND",
	3: "BIDIRECTIONAL",
}

var Trust_TrustDirection_value = map[string]int32{
	"TRUST_DIRECTION_UNSPECIFIED": 0,
	"INBOUND":                     1,
	"OUTBOUND":                    2,
	"BIDIRECTIONAL":               3,
}

func (x Trust_TrustDirection) String() string {
	return proto.EnumName(Trust_TrustDirection_name, int32(x))
}

func (Trust_TrustDirection) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a15846c99e9279f9, []int{1, 2}
}

// Represents a managed Microsoft Active Directory domain.
type Domain struct {
	// Required. The unique name of the domain using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Resource labels that can contain user-provided metadata.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The full names of the Google Compute Engine
	// [networks](/compute/docs/networks-and-firewalls#networks) the domain
	// instance is connected to. Networks can be added using UpdateDomain.
	// The domain is only available on networks listed in `authorized_networks`.
	// If CIDR subnets overlap between networks, domain creation will fail.
	AuthorizedNetworks []string `protobuf:"bytes,3,rep,name=authorized_networks,json=authorizedNetworks,proto3" json:"authorized_networks,omitempty"`
	// Required. The CIDR range of internal addresses that are reserved for this
	// domain. Reserved networks must be /24 or larger. Ranges must be
	// unique and non-overlapping with existing subnets in
	// [Domain].[authorized_networks].
	ReservedIpRange string `protobuf:"bytes,4,opt,name=reserved_ip_range,json=reservedIpRange,proto3" json:"reserved_ip_range,omitempty"`
	// Required. Locations where domain needs to be provisioned.
	// [regions][compute/docs/regions-zones/]
	// e.g. us-west1 or us-east4
	// Service supports up to 4 locations at once. Each location will use a /26
	// block.
	Locations []string `protobuf:"bytes,5,rep,name=locations,proto3" json:"locations,omitempty"`
	// Optional. The name of delegated administrator account used to perform
	// Active Directory operations. If not specified, `setupadmin` will be used.
	Admin string `protobuf:"bytes,6,opt,name=admin,proto3" json:"admin,omitempty"`
	// Output only. The fully-qualified domain name of the exposed domain used by
	// clients to connect to the service. Similar to what would be chosen for an
	// Active Directory set up on an internal network.
	Fqdn string `protobuf:"bytes,10,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
	// Output only. The time the instance was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update time.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The current state of this domain.
	State Domain_State `protobuf:"varint,13,opt,name=state,proto3,enum=google.cloud.managedidentities.v1.Domain_State" json:"state,omitempty"`
	// Output only. Additional information about the current status of this
	// domain, if available.
	StatusMessage string `protobuf:"bytes,14,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. The current trusts associated with the domain.
	Trusts               []*Trust `protobuf:"bytes,15,rep,name=trusts,proto3" json:"trusts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Domain) Reset()         { *m = Domain{} }
func (m *Domain) String() string { return proto.CompactTextString(m) }
func (*Domain) ProtoMessage()    {}
func (*Domain) Descriptor() ([]byte, []int) {
	return fileDescriptor_a15846c99e9279f9, []int{0}
}

func (m *Domain) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Domain.Unmarshal(m, b)
}
func (m *Domain) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Domain.Marshal(b, m, deterministic)
}
func (m *Domain) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Domain.Merge(m, src)
}
func (m *Domain) XXX_Size() int {
	return xxx_messageInfo_Domain.Size(m)
}
func (m *Domain) XXX_DiscardUnknown() {
	xxx_messageInfo_Domain.DiscardUnknown(m)
}

var xxx_messageInfo_Domain proto.InternalMessageInfo

func (m *Domain) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Domain) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Domain) GetAuthorizedNetworks() []string {
	if m != nil {
		return m.AuthorizedNetworks
	}
	return nil
}

func (m *Domain) GetReservedIpRange() string {
	if m != nil {
		return m.ReservedIpRange
	}
	return ""
}

func (m *Domain) GetLocations() []string {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *Domain) GetAdmin() string {
	if m != nil {
		return m.Admin
	}
	return ""
}

func (m *Domain) GetFqdn() string {
	if m != nil {
		return m.Fqdn
	}
	return ""
}

func (m *Domain) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Domain) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Domain) GetState() Domain_State {
	if m != nil {
		return m.State
	}
	return Domain_STATE_UNSPECIFIED
}

func (m *Domain) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Domain) GetTrusts() []*Trust {
	if m != nil {
		return m.Trusts
	}
	return nil
}

// Represents a relationship between two domains. This allows a controller in
// one domain to authenticate a user in another domain.
type Trust struct {
	// Required. The fully qualified target domain name which will be in trust with the
	// current domain.
	TargetDomainName string `protobuf:"bytes,1,opt,name=target_domain_name,json=targetDomainName,proto3" json:"target_domain_name,omitempty"`
	// Required. The type of trust represented by the trust resource.
	TrustType Trust_TrustType `protobuf:"varint,2,opt,name=trust_type,json=trustType,proto3,enum=google.cloud.managedidentities.v1.Trust_TrustType" json:"trust_type,omitempty"`
	// Required. The trust direction, which decides if the current domain is trusted,
	// trusting, or both.
	TrustDirection Trust_TrustDirection `protobuf:"varint,3,opt,name=trust_direction,json=trustDirection,proto3,enum=google.cloud.managedidentities.v1.Trust_TrustDirection" json:"trust_direction,omitempty"`
	// Optional. The trust authentication type, which decides whether the trusted side has
	// forest/domain wide access or selective access to an approved set of
	// resources.
	SelectiveAuthentication bool `protobuf:"varint,4,opt,name=selective_authentication,json=selectiveAuthentication,proto3" json:"selective_authentication,omitempty"`
	// Required. The target DNS server IP addresses which can resolve the remote domain
	// involved in the trust.
	TargetDnsIpAddresses []string `protobuf:"bytes,5,rep,name=target_dns_ip_addresses,json=targetDnsIpAddresses,proto3" json:"target_dns_ip_addresses,omitempty"`
	// Required. The trust secret used for the handshake with the target domain. This will
	// not be stored.
	TrustHandshakeSecret string `protobuf:"bytes,6,opt,name=trust_handshake_secret,json=trustHandshakeSecret,proto3" json:"trust_handshake_secret,omitempty"`
	// Output only. The time the instance was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update time.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The current state of the trust.
	State Trust_State `protobuf:"varint,9,opt,name=state,proto3,enum=google.cloud.managedidentities.v1.Trust_State" json:"state,omitempty"`
	// Output only. Additional information about the current state of the trust, if available.
	StateDescription string `protobuf:"bytes,11,opt,name=state_description,json=stateDescription,proto3" json:"state_description,omitempty"`
	// Output only. The last heartbeat time when the trust was known to be connected.
	LastTrustHeartbeatTime *timestamp.Timestamp `protobuf:"bytes,12,opt,name=last_trust_heartbeat_time,json=lastTrustHeartbeatTime,proto3" json:"last_trust_heartbeat_time,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}             `json:"-"`
	XXX_unrecognized       []byte               `json:"-"`
	XXX_sizecache          int32                `json:"-"`
}

func (m *Trust) Reset()         { *m = Trust{} }
func (m *Trust) String() string { return proto.CompactTextString(m) }
func (*Trust) ProtoMessage()    {}
func (*Trust) Descriptor() ([]byte, []int) {
	return fileDescriptor_a15846c99e9279f9, []int{1}
}

func (m *Trust) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trust.Unmarshal(m, b)
}
func (m *Trust) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trust.Marshal(b, m, deterministic)
}
func (m *Trust) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trust.Merge(m, src)
}
func (m *Trust) XXX_Size() int {
	return xxx_messageInfo_Trust.Size(m)
}
func (m *Trust) XXX_DiscardUnknown() {
	xxx_messageInfo_Trust.DiscardUnknown(m)
}

var xxx_messageInfo_Trust proto.InternalMessageInfo

func (m *Trust) GetTargetDomainName() string {
	if m != nil {
		return m.TargetDomainName
	}
	return ""
}

func (m *Trust) GetTrustType() Trust_TrustType {
	if m != nil {
		return m.TrustType
	}
	return Trust_TRUST_TYPE_UNSPECIFIED
}

func (m *Trust) GetTrustDirection() Trust_TrustDirection {
	if m != nil {
		return m.TrustDirection
	}
	return Trust_TRUST_DIRECTION_UNSPECIFIED
}

func (m *Trust) GetSelectiveAuthentication() bool {
	if m != nil {
		return m.SelectiveAuthentication
	}
	return false
}

func (m *Trust) GetTargetDnsIpAddresses() []string {
	if m != nil {
		return m.TargetDnsIpAddresses
	}
	return nil
}

func (m *Trust) GetTrustHandshakeSecret() string {
	if m != nil {
		return m.TrustHandshakeSecret
	}
	return ""
}

func (m *Trust) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Trust) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Trust) GetState() Trust_State {
	if m != nil {
		return m.State
	}
	return Trust_STATE_UNSPECIFIED
}

func (m *Trust) GetStateDescription() string {
	if m != nil {
		return m.StateDescription
	}
	return ""
}

func (m *Trust) GetLastTrustHeartbeatTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastTrustHeartbeatTime
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.managedidentities.v1.Domain_State", Domain_State_name, Domain_State_value)
	proto.RegisterEnum("google.cloud.managedidentities.v1.Trust_State", Trust_State_name, Trust_State_value)
	proto.RegisterEnum("google.cloud.managedidentities.v1.Trust_TrustType", Trust_TrustType_name, Trust_TrustType_value)
	proto.RegisterEnum("google.cloud.managedidentities.v1.Trust_TrustDirection", Trust_TrustDirection_name, Trust_TrustDirection_value)
	proto.RegisterType((*Domain)(nil), "google.cloud.managedidentities.v1.Domain")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.managedidentities.v1.Domain.LabelsEntry")
	proto.RegisterType((*Trust)(nil), "google.cloud.managedidentities.v1.Trust")
}

func init() {
	proto.RegisterFile("google/cloud/managedidentities/v1/resource.proto", fileDescriptor_a15846c99e9279f9)
}

var fileDescriptor_a15846c99e9279f9 = []byte{
	// 1052 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xdf, 0x4e, 0xe3, 0xc6,
	0x17, 0xfe, 0x39, 0x21, 0x81, 0x9c, 0x2c, 0xc1, 0xcc, 0x6f, 0xbb, 0x18, 0x5a, 0x69, 0x21, 0x52,
	0x55, 0xd4, 0x8b, 0x78, 0xa1, 0xad, 0xba, 0x4b, 0xa5, 0xaa, 0x4e, 0x6c, 0x58, 0x57, 0xc1, 0x89,
	0x1c, 0x07, 0x75, 0xf7, 0xc6, 0x1a, 0xec, 0x21, 0xb8, 0x24, 0xb6, 0xeb, 0x99, 0xa4, 0xa2, 0x88,
	0x67, 0xe8, 0x0b, 0xf4, 0x09, 0xda, 0x9b, 0x3e, 0x52, 0xaf, 0xfb, 0x14, 0xd5, 0xcc, 0xd8, 0x09,
	0x01, 0xa9, 0x0b, 0xea, 0x8d, 0x35, 0xe7, 0xcf, 0xf7, 0xcd, 0xcc, 0x39, 0x73, 0x3e, 0x19, 0x5e,
	0x8d, 0x92, 0x64, 0x34, 0x26, 0x7a, 0x30, 0x4e, 0xa6, 0xa1, 0x3e, 0xc1, 0x31, 0x1e, 0x91, 0x30,
	0x0a, 0x49, 0xcc, 0x22, 0x16, 0x11, 0xaa, 0xcf, 0x0e, 0xf4, 0x8c, 0xd0, 0x64, 0x9a, 0x05, 0xa4,
	0x95, 0x66, 0x09, 0x4b, 0xd0, 0x9e, 0x44, 0xb4, 0x04, 0xa2, 0xf5, 0x00, 0xd1, 0x9a, 0x1d, 0xec,
	0xbc, 0xcc, 0x49, 0x71, 0x1a, 0xe9, 0x17, 0x11, 0x19, 0x87, 0xfe, 0x39, 0xb9, 0xc4, 0xb3, 0x28,
	0xc9, 0x24, 0xc7, 0xce, 0xf6, 0x9d, 0x84, 0x65, 0xfa, 0x39, 0x56, 0x58, 0xe7, 0xd3, 0x0b, 0x9d,
	0x45, 0x13, 0x42, 0x19, 0x9e, 0xa4, 0x79, 0xc2, 0x27, 0x77, 0xb0, 0x38, 0x8e, 0x13, 0x86, 0x59,
	0x94, 0xc4, 0x54, 0x46, 0x9b, 0x7f, 0xac, 0x42, 0xd5, 0x4c, 0x26, 0x38, 0x8a, 0xd1, 0x16, 0xac,
	0xc4, 0x78, 0x42, 0x34, 0x65, 0x57, 0xd9, 0xaf, 0xb5, 0xcb, 0x7f, 0x19, 0x25, 0x57, 0x38, 0x90,
	0x0b, 0xd5, 0x31, 0x3e, 0x27, 0x63, 0xaa, 0x95, 0x76, 0xcb, 0xfb, 0xf5, 0xc3, 0xaf, 0x5a, 0x1f,
	0xbc, 0x52, 0x4b, 0x72, 0xb6, 0xba, 0x02, 0x67, 0xc5, 0x2c, 0xbb, 0xe6, 0x8c, 0x8a, 0x9b, 0x33,
	0xa1, 0x2f, 0xe1, 0xff, 0x78, 0xca, 0x2e, 0x93, 0x2c, 0xfa, 0x85, 0x84, 0x7e, 0x4c, 0xd8, 0xcf,
	0x49, 0x76, 0x45, 0xb5, 0xf2, 0x6e, 0x59, 0xee, 0xad, 0xb8, 0x68, 0x11, 0x77, 0xf2, 0x30, 0xd2,
	0x61, 0x33, 0x23, 0x94, 0x64, 0x33, 0x12, 0xfa, 0x51, 0xea, 0x67, 0x38, 0x1e, 0x11, 0x6d, 0x65,
	0x71, 0xde, 0x8d, 0x22, 0x6a, 0xa7, 0x2e, 0x8f, 0xa1, 0x3d, 0xa8, 0x8d, 0x93, 0x40, 0xde, 0x58,
	0xab, 0x14, 0xe4, 0x25, 0x77, 0xe1, 0x45, 0xdb, 0x50, 0xc1, 0xe1, 0x24, 0x8a, 0xb5, 0x6a, 0xc1,
	0xa3, 0xb8, 0xd2, 0xc3, 0x2b, 0x72, 0xf1, 0x53, 0x18, 0x6b, 0x50, 0x44, 0xca, 0xae, 0x70, 0xa0,
	0xef, 0xa0, 0x1e, 0x64, 0x04, 0x33, 0xe2, 0xf3, 0x6a, 0x6b, 0xf5, 0x5d, 0x65, 0xbf, 0x7e, 0xb8,
	0x53, 0x94, 0xa5, 0x68, 0x45, 0xcb, 0x2b, 0x5a, 0x21, 0xb1, 0x20, 0x31, 0xdc, 0xcb, 0x19, 0xa6,
	0x69, 0x38, 0x67, 0x78, 0xf6, 0x48, 0x06, 0x89, 0x11, 0x0c, 0xdf, 0x43, 0x85, 0x32, 0xcc, 0x88,
	0xb6, 0xbe, 0xab, 0xec, 0x37, 0x0e, 0xf5, 0xc7, 0x37, 0x65, 0xc0, 0x61, 0x92, 0x50, 0x52, 0xa0,
	0xcf, 0xa1, 0xc1, 0x17, 0x53, 0xea, 0x4f, 0x08, 0xa5, 0x78, 0x44, 0xb4, 0xc6, 0xe2, 0xca, 0xeb,
	0x32, 0x74, 0x2a, 0x23, 0xc8, 0x82, 0x2a, 0xcb, 0xa6, 0x94, 0x51, 0x6d, 0x43, 0xbc, 0x86, 0xfd,
	0x47, 0x6c, 0xec, 0x71, 0x80, 0x64, 0xcb, 0xc1, 0x3b, 0x6f, 0xa0, 0x7e, 0xe7, 0x71, 0x20, 0x15,
	0xca, 0x57, 0xe4, 0x5a, 0xbe, 0x3d, 0x97, 0x2f, 0xd1, 0x73, 0xa8, 0xcc, 0xf0, 0x78, 0x4a, 0xb4,
	0x92, 0xf0, 0x49, 0xe3, 0xa8, 0xf4, 0x5a, 0x69, 0xfe, 0xaa, 0x40, 0x45, 0xdc, 0x01, 0x7d, 0x04,
	0x9b, 0x03, 0xcf, 0xf0, 0x2c, 0x7f, 0xe8, 0x0c, 0xfa, 0x56, 0xc7, 0x3e, 0xb6, 0x2d, 0x53, 0xfd,
	0x1f, 0x7a, 0x06, 0x6b, 0x1d, 0xd7, 0x32, 0x3c, 0xdb, 0x39, 0x51, 0x15, 0x54, 0x83, 0x8a, 0x6b,
	0x19, 0xe6, 0x3b, 0xb5, 0xc4, 0x03, 0xc3, 0xbe, 0x29, 0x03, 0x65, 0x6e, 0x99, 0x56, 0xd7, 0x12,
	0xd6, 0x0a, 0x5a, 0x87, 0x9a, 0x6b, 0xf5, 0x0d, 0xdb, 0xe5, 0x66, 0x05, 0xed, 0xc0, 0x8b, 0xbe,
	0xe5, 0x1e, 0xf7, 0xdc, 0x53, 0xdb, 0x39, 0xf1, 0x4f, 0x0d, 0xdb, 0xf1, 0x2c, 0xc7, 0x70, 0x3a,
	0x96, 0x5a, 0x45, 0x1b, 0x50, 0x1f, 0x3a, 0xc6, 0x99, 0x61, 0x77, 0x8d, 0x76, 0xd7, 0x52, 0x57,
	0x8f, 0x2e, 0xfe, 0x36, 0x02, 0xf8, 0xec, 0xe1, 0xd5, 0x65, 0x65, 0x70, 0x1a, 0xd1, 0x56, 0x90,
	0x4c, 0xf4, 0x7c, 0xd0, 0x5e, 0xa7, 0x59, 0xf2, 0x23, 0x09, 0x18, 0xd5, 0x6f, 0xf2, 0xd5, 0xad,
	0x3e, 0x7f, 0x8f, 0xfa, 0x4d, 0xb1, 0xbc, 0xd5, 0x43, 0x91, 0x4f, 0xf5, 0x1b, 0xb9, 0xb8, 0x6d,
	0xfe, 0xb6, 0x06, 0x15, 0x51, 0x4b, 0x74, 0x00, 0x88, 0xe1, 0x6c, 0x44, 0x98, 0x2f, 0x63, 0xfe,
	0xfd, 0xd1, 0x55, 0x65, 0x58, 0x6e, 0xe9, 0xf0, 0x31, 0x3e, 0x03, 0x10, 0xb5, 0xf7, 0xd9, 0x75,
	0x2a, 0xab, 0xda, 0x38, 0x3c, 0x7c, 0x6c, 0xf3, 0xe4, 0xd7, 0xbb, 0x4e, 0x49, 0x3e, 0x40, 0xac,
	0xb0, 0x11, 0x81, 0x0d, 0xc9, 0x1b, 0x46, 0x19, 0x09, 0xf8, 0xc9, 0xb5, 0xb2, 0x20, 0xff, 0xfa,
	0x69, 0xe4, 0x66, 0x01, 0x97, 0x3b, 0x34, 0xd8, 0x92, 0x13, 0x7d, 0x0b, 0x1a, 0x25, 0x63, 0x6e,
	0xcc, 0x88, 0xcf, 0xb5, 0x81, 0xd3, 0xc8, 0x4a, 0x09, 0x09, 0x58, 0x93, 0xa3, 0xbb, 0x35, 0x4f,
	0x32, 0x96, 0x72, 0xd0, 0x11, 0x6c, 0x15, 0x15, 0x8b, 0x29, 0x57, 0x0f, 0x1c, 0x86, 0x19, 0xa1,
	0x94, 0x2c, 0x09, 0xc3, 0xf3, 0xbc, 0x6c, 0x31, 0xb5, 0x53, 0xa3, 0x48, 0x40, 0x6f, 0xe0, 0x85,
	0xbc, 0xe2, 0x25, 0x8e, 0x43, 0x7a, 0x89, 0xaf, 0x88, 0x4f, 0x49, 0x90, 0x11, 0xb6, 0x10, 0x0d,
	0x0e, 0xe5, 0x29, 0x6f, 0x8b, 0x8c, 0x81, 0x48, 0xb8, 0x2f, 0x15, 0xab, 0xff, 0x59, 0x2a, 0xd6,
	0x9e, 0x2e, 0x15, 0x76, 0x21, 0x15, 0x35, 0xd1, 0x97, 0xd6, 0xa3, 0xfb, 0xf2, 0x50, 0x29, 0x5e,
	0xc1, 0xa6, 0x58, 0xf8, 0x21, 0xa1, 0x41, 0x16, 0xa5, 0xa2, 0xfc, 0xf5, 0x85, 0x58, 0xa8, 0x22,
	0x6a, 0x2e, 0x82, 0xe8, 0x3d, 0x6c, 0x8f, 0x31, 0x7f, 0x75, 0xb2, 0x80, 0x04, 0x67, 0xec, 0x9c,
	0x60, 0xf6, 0x24, 0xdd, 0x7b, 0xc1, 0x19, 0xc4, 0x91, 0xde, 0x16, 0x78, 0x9e, 0xd1, 0x8c, 0x9e,
	0x24, 0x04, 0x77, 0xa7, 0xbf, 0xb4, 0x34, 0xfd, 0x65, 0x3e, 0xfd, 0x9d, 0x9e, 0xe3, 0x58, 0x1d,
	0xcf, 0x32, 0xd5, 0x15, 0xa4, 0xc2, 0x33, 0xd3, 0x1e, 0x2c, 0x3c, 0x95, 0xa6, 0x01, 0xb5, 0xf9,
	0x08, 0x70, 0x71, 0xf0, 0xdc, 0xe1, 0xc0, 0xf3, 0xbd, 0x77, 0xfd, 0xfb, 0x7b, 0x02, 0x54, 0x8f,
	0x7b, 0xae, 0x35, 0xf0, 0xe4, 0x8e, 0xd6, 0x0f, 0x9e, 0xe5, 0x3a, 0x46, 0x57, 0x2d, 0x35, 0x7d,
	0x68, 0x2c, 0x3f, 0x74, 0xf4, 0x12, 0x3e, 0x96, 0x3c, 0xa6, 0xed, 0x5a, 0x1d, 0xcf, 0xee, 0x39,
	0xf7, 0xc8, 0xea, 0xb0, 0x6a, 0x3b, 0xed, 0xde, 0xd0, 0x31, 0x25, 0x5b, 0x6f, 0xe8, 0x49, 0xab,
	0x84, 0x36, 0x61, 0xbd, 0x6d, 0xcf, 0x71, 0x46, 0x57, 0x2d, 0xb7, 0xff, 0x54, 0xe0, 0xd3, 0x20,
	0x99, 0x7c, 0xb8, 0xbd, 0xed, 0x75, 0x37, 0xff, 0x8b, 0xe8, 0xf3, 0x8a, 0xf7, 0x95, 0xf7, 0x6e,
	0x8e, 0x19, 0x25, 0x63, 0x1c, 0x8f, 0x5a, 0x49, 0x36, 0xd2, 0x47, 0x24, 0x16, 0xfd, 0xd0, 0x17,
	0x2a, 0xf6, 0x2f, 0xbf, 0x3d, 0xdf, 0x3c, 0x70, 0xfe, 0x5e, 0xda, 0x3b, 0x91, 0xa4, 0x1d, 0x71,
	0x90, 0x53, 0x99, 0x60, 0x2f, 0x0e, 0x72, 0x76, 0x70, 0x5e, 0x15, 0x5b, 0x7c, 0xf1, 0x4f, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xd3, 0x21, 0x63, 0x77, 0x58, 0x09, 0x00, 0x00,
}
