// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/recommender/v1beta1/recommendation.proto

package recommender

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	money "google.golang.org/genproto/googleapis/type/money"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The category of the impact.
type Impact_Category int32

const (
	// Default unspecified category. Don't use directly.
	Impact_CATEGORY_UNSPECIFIED Impact_Category = 0
	// Indicates a potential increase or decrease in cost.
	Impact_COST Impact_Category = 1
	// Indicates a potential increase or decrease in security.
	Impact_SECURITY Impact_Category = 2
	// Indicates a potential increase or decrease in performance.
	Impact_PERFORMANCE Impact_Category = 3
	// Indicates a potential increase or decrease in manageability.
	Impact_MANAGEABILITY Impact_Category = 4
)

var Impact_Category_name = map[int32]string{
	0: "CATEGORY_UNSPECIFIED",
	1: "COST",
	2: "SECURITY",
	3: "PERFORMANCE",
	4: "MANAGEABILITY",
}

var Impact_Category_value = map[string]int32{
	"CATEGORY_UNSPECIFIED": 0,
	"COST":                 1,
	"SECURITY":             2,
	"PERFORMANCE":          3,
	"MANAGEABILITY":        4,
}

func (x Impact_Category) String() string {
	return proto.EnumName(Impact_Category_name, int32(x))
}

func (Impact_Category) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_79be8d5bd206286c, []int{6, 0}
}

// Represents Recommendation State.
type RecommendationStateInfo_State int32

const (
	// Default state. Don't use directly.
	RecommendationStateInfo_STATE_UNSPECIFIED RecommendationStateInfo_State = 0
	// Recommendation is active and can be applied. Recommendations content can
	// be updated by Google.
	//
	// ACTIVE recommendations can be marked as CLAIMED, SUCCEEDED, or FAILED.
	RecommendationStateInfo_ACTIVE RecommendationStateInfo_State = 1
	// Recommendation is in claimed state. Recommendations content is
	// immutable and cannot be updated by Google.
	//
	// CLAIMED recommendations can be marked as CLAIMED, SUCCEEDED, or FAILED.
	RecommendationStateInfo_CLAIMED RecommendationStateInfo_State = 6
	// Recommendation is in succeeded state. Recommendations content is
	// immutable and cannot be updated by Google.
	//
	// SUCCEEDED recommendations can be marked as SUCCEEDED, or FAILED.
	RecommendationStateInfo_SUCCEEDED RecommendationStateInfo_State = 3
	// Recommendation is in failed state. Recommendations content is immutable
	// and cannot be updated by Google.
	//
	// FAILED recommendations can be marked as SUCCEEDED, or FAILED.
	RecommendationStateInfo_FAILED RecommendationStateInfo_State = 4
	// Recommendation is in dismissed state. Recommendation content can be
	// updated by Google.
	//
	// DISMISSED recommendations can be marked as ACTIVE.
	RecommendationStateInfo_DISMISSED RecommendationStateInfo_State = 5
)

var RecommendationStateInfo_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "ACTIVE",
	6: "CLAIMED",
	3: "SUCCEEDED",
	4: "FAILED",
	5: "DISMISSED",
}

var RecommendationStateInfo_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"ACTIVE":            1,
	"CLAIMED":           6,
	"SUCCEEDED":         3,
	"FAILED":            4,
	"DISMISSED":         5,
}

func (x RecommendationStateInfo_State) String() string {
	return proto.EnumName(RecommendationStateInfo_State_name, int32(x))
}

func (RecommendationStateInfo_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_79be8d5bd206286c, []int{7, 0}
}

// A recommendation along with a suggested action. E.g., a rightsizing
// recommendation for an underutilized VM, IAM role recommendations, etc
type Recommendation struct {
	// Name of recommendation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Free-form human readable summary in English. The maximum length is 500
	// characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Contains an identifier for a subtype of recommendations produced for the
	// same recommender. Subtype is a function of content and impact, meaning a
	// new subtype might be added when significant changes to `content` or
	// `primary_impact.category` are introduced. See the Recommenders section
	// to see a list of subtypes for a given Recommender.
	//
	// Examples:
	//   For recommender = "google.iam.policy.Recommender",
	//   recommender_subtype can be one of "REMOVE_ROLE"/"REPLACE_ROLE"
	RecommenderSubtype string `protobuf:"bytes,12,opt,name=recommender_subtype,json=recommenderSubtype,proto3" json:"recommender_subtype,omitempty"`
	// Last time this recommendation was refreshed by the system that created it
	// in the first place.
	LastRefreshTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=last_refresh_time,json=lastRefreshTime,proto3" json:"last_refresh_time,omitempty"`
	// The primary impact that this recommendation can have while trying to
	// optimize for one category.
	PrimaryImpact *Impact `protobuf:"bytes,5,opt,name=primary_impact,json=primaryImpact,proto3" json:"primary_impact,omitempty"`
	// Optional set of additional impact that this recommendation may have when
	// trying to optimize for the primary category. These may be positive
	// or negative.
	AdditionalImpact []*Impact `protobuf:"bytes,6,rep,name=additional_impact,json=additionalImpact,proto3" json:"additional_impact,omitempty"`
	// Content of the recommendation describing recommended changes to resources.
	Content *RecommendationContent `protobuf:"bytes,7,opt,name=content,proto3" json:"content,omitempty"`
	// Information for state. Contains state and metadata.
	StateInfo *RecommendationStateInfo `protobuf:"bytes,10,opt,name=state_info,json=stateInfo,proto3" json:"state_info,omitempty"`
	// Fingerprint of the Recommendation. Provides optimistic locking when
	// updating states.
	Etag                 string   `protobuf:"bytes,11,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Recommendation) Reset()         { *m = Recommendation{} }
func (m *Recommendation) String() string { return proto.CompactTextString(m) }
func (*Recommendation) ProtoMessage()    {}
func (*Recommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_79be8d5bd206286c, []int{0}
}

func (m *Recommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation.Unmarshal(m, b)
}
func (m *Recommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation.Marshal(b, m, deterministic)
}
func (m *Recommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation.Merge(m, src)
}
func (m *Recommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation.Size(m)
}
func (m *Recommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation proto.InternalMessageInfo

func (m *Recommendation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Recommendation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Recommendation) GetRecommenderSubtype() string {
	if m != nil {
		return m.RecommenderSubtype
	}
	return ""
}

func (m *Recommendation) GetLastRefreshTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastRefreshTime
	}
	return nil
}

func (m *Recommendation) GetPrimaryImpact() *Impact {
	if m != nil {
		return m.PrimaryImpact
	}
	return nil
}

func (m *Recommendation) GetAdditionalImpact() []*Impact {
	if m != nil {
		return m.AdditionalImpact
	}
	return nil
}

func (m *Recommendation) GetContent() *RecommendationContent {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *Recommendation) GetStateInfo() *RecommendationStateInfo {
	if m != nil {
		return m.StateInfo
	}
	return nil
}

func (m *Recommendation) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

// Contains what resources are changing and how they are changing.
type RecommendationContent struct {
	// Operations to one or more Google Cloud resources grouped in such a way
	// that, all operations within one group are expected to be performed
	// atomically and in an order.
	OperationGroups      []*OperationGroup `protobuf:"bytes,2,rep,name=operation_groups,json=operationGroups,proto3" json:"operation_groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *RecommendationContent) Reset()         { *m = RecommendationContent{} }
func (m *RecommendationContent) String() string { return proto.CompactTextString(m) }
func (*RecommendationContent) ProtoMessage()    {}
func (*RecommendationContent) Descriptor() ([]byte, []int) {
	return fileDescriptor_79be8d5bd206286c, []int{1}
}

func (m *RecommendationContent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecommendationContent.Unmarshal(m, b)
}
func (m *RecommendationContent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecommendationContent.Marshal(b, m, deterministic)
}
func (m *RecommendationContent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecommendationContent.Merge(m, src)
}
func (m *RecommendationContent) XXX_Size() int {
	return xxx_messageInfo_RecommendationContent.Size(m)
}
func (m *RecommendationContent) XXX_DiscardUnknown() {
	xxx_messageInfo_RecommendationContent.DiscardUnknown(m)
}

var xxx_messageInfo_RecommendationContent proto.InternalMessageInfo

func (m *RecommendationContent) GetOperationGroups() []*OperationGroup {
	if m != nil {
		return m.OperationGroups
	}
	return nil
}

// Group of operations that need to be performed atomically.
type OperationGroup struct {
	// List of operations across one or more resources that belong to this group.
	// Loosely based on RFC6902 and should be performed in the order they appear.
	Operations           []*Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *OperationGroup) Reset()         { *m = OperationGroup{} }
func (m *OperationGroup) String() string { return proto.CompactTextString(m) }
func (*OperationGroup) ProtoMessage()    {}
func (*OperationGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_79be8d5bd206286c, []int{2}
}

func (m *OperationGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationGroup.Unmarshal(m, b)
}
func (m *OperationGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationGroup.Marshal(b, m, deterministic)
}
func (m *OperationGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationGroup.Merge(m, src)
}
func (m *OperationGroup) XXX_Size() int {
	return xxx_messageInfo_OperationGroup.Size(m)
}
func (m *OperationGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationGroup.DiscardUnknown(m)
}

var xxx_messageInfo_OperationGroup proto.InternalMessageInfo

func (m *OperationGroup) GetOperations() []*Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// Contains an operation for a resource loosely based on the JSON-PATCH format
// with support for:
//
// * Custom filters for describing partial array patch.
// * Extended path values for describing nested arrays.
// * Custom fields for describing the resource for which the operation is being
//   described.
// * Allows extension to custom operations not natively supported by RFC6902.
// See https://tools.ietf.org/html/rfc6902 for details on the original RFC.
type Operation struct {
	// Type of this operation. Contains one of 'and', 'remove', 'replace', 'move',
	// 'copy', 'test' and 'custom' operations. This field is case-insensitive and
	// always populated.
	Action string `protobuf:"bytes,1,opt,name=action,proto3" json:"action,omitempty"`
	// Type of GCP resource being modified/tested. This field is always populated.
	// Example: cloudresourcemanager.googleapis.com/Project,
	// compute.googleapis.com/Instance
	ResourceType string `protobuf:"bytes,2,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// Contains the fully qualified resource name. This field is always populated.
	// ex: //cloudresourcemanager.googleapis.com/projects/foo.
	Resource string `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
	// Path to the target field being operated on. If the operation is at the
	// resource level, then path should be "/". This field is always populated.
	Path string `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`
	// Can be set with action 'copy' to copy resource configuration across
	// different resources of the same type. Example: A resource clone can be
	// done via action = 'copy', path = "/", from = "/",
	// source_resource = <source> and resource_name = <target>.
	// This field is empty for all other values of `action`.
	SourceResource string `protobuf:"bytes,5,opt,name=source_resource,json=sourceResource,proto3" json:"source_resource,omitempty"`
	// Can be set with action 'copy' or 'move' to indicate the source field within
	// resource or source_resource, ignored if provided for other operation types.
	SourcePath string `protobuf:"bytes,6,opt,name=source_path,json=sourcePath,proto3" json:"source_path,omitempty"`
	// One of the fields in the following block will be set and intend to
	// describe a value for 'path' field.
	//
	// Types that are valid to be assigned to PathValue:
	//	*Operation_Value
	//	*Operation_ValueMatcher
	PathValue isOperation_PathValue `protobuf_oneof:"path_value"`
	// Set of filters to apply if `path` refers to array elements or nested array
	// elements in order to narrow down to a single unique element that is being
	// tested/modified.
	// This is intended to be an exact match per filter. To perform advanced
	// matching, use path_value_matchers.
	//
	// * Example: {
	//   "/versions/*/name" : "it-123"
	//   "/versions/*/targetSize/percent": 20
	//   }
	// * Example: {
	//   "/bindings/*/role": "roles/admin"
	//   "/bindings/*/condition" : null
	//   }
	// * Example: {
	//   "/bindings/*/role": "roles/admin"
	//   "/bindings/*/members/*" : ["x@google.com", "y@google.com"]
	//   }
	// When both path_filters and path_value_matchers are set, an implicit AND
	// must be performed.
	PathFilters map[string]*_struct.Value `protobuf:"bytes,8,rep,name=path_filters,json=pathFilters,proto3" json:"path_filters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Similar to path_filters, this contains set of filters to apply if `path`
	// field referes to array elements. This is meant to support value matching
	// beyond exact match. To perform exact match, use path_filters.
	// When both path_filters and path_value_matchers are set, an implicit AND
	// must be performed.
	PathValueMatchers    map[string]*ValueMatcher `protobuf:"bytes,11,rep,name=path_value_matchers,json=pathValueMatchers,proto3" json:"path_value_matchers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Operation) Reset()         { *m = Operation{} }
func (m *Operation) String() string { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()    {}
func (*Operation) Descriptor() ([]byte, []int) {
	return fileDescriptor_79be8d5bd206286c, []int{3}
}

func (m *Operation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Operation.Unmarshal(m, b)
}
func (m *Operation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Operation.Marshal(b, m, deterministic)
}
func (m *Operation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Operation.Merge(m, src)
}
func (m *Operation) XXX_Size() int {
	return xxx_messageInfo_Operation.Size(m)
}
func (m *Operation) XXX_DiscardUnknown() {
	xxx_messageInfo_Operation.DiscardUnknown(m)
}

var xxx_messageInfo_Operation proto.InternalMessageInfo

func (m *Operation) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *Operation) GetResourceType() string {
	if m != nil {
		return m.ResourceType
	}
	return ""
}

func (m *Operation) GetResource() string {
	if m != nil {
		return m.Resource
	}
	return ""
}

func (m *Operation) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *Operation) GetSourceResource() string {
	if m != nil {
		return m.SourceResource
	}
	return ""
}

func (m *Operation) GetSourcePath() string {
	if m != nil {
		return m.SourcePath
	}
	return ""
}

type isOperation_PathValue interface {
	isOperation_PathValue()
}

type Operation_Value struct {
	Value *_struct.Value `protobuf:"bytes,7,opt,name=value,proto3,oneof"`
}

type Operation_ValueMatcher struct {
	ValueMatcher *ValueMatcher `protobuf:"bytes,10,opt,name=value_matcher,json=valueMatcher,proto3,oneof"`
}

func (*Operation_Value) isOperation_PathValue() {}

func (*Operation_ValueMatcher) isOperation_PathValue() {}

func (m *Operation) GetPathValue() isOperation_PathValue {
	if m != nil {
		return m.PathValue
	}
	return nil
}

func (m *Operation) GetValue() *_struct.Value {
	if x, ok := m.GetPathValue().(*Operation_Value); ok {
		return x.Value
	}
	return nil
}

func (m *Operation) GetValueMatcher() *ValueMatcher {
	if x, ok := m.GetPathValue().(*Operation_ValueMatcher); ok {
		return x.ValueMatcher
	}
	return nil
}

func (m *Operation) GetPathFilters() map[string]*_struct.Value {
	if m != nil {
		return m.PathFilters
	}
	return nil
}

func (m *Operation) GetPathValueMatchers() map[string]*ValueMatcher {
	if m != nil {
		return m.PathValueMatchers
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Operation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Operation_Value)(nil),
		(*Operation_ValueMatcher)(nil),
	}
}

// Contains various matching options for values for a GCP resource field.
type ValueMatcher struct {
	// Types that are valid to be assigned to MatchVariant:
	//	*ValueMatcher_MatchesPattern
	MatchVariant         isValueMatcher_MatchVariant `protobuf_oneof:"match_variant"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *ValueMatcher) Reset()         { *m = ValueMatcher{} }
func (m *ValueMatcher) String() string { return proto.CompactTextString(m) }
func (*ValueMatcher) ProtoMessage()    {}
func (*ValueMatcher) Descriptor() ([]byte, []int) {
	return fileDescriptor_79be8d5bd206286c, []int{4}
}

func (m *ValueMatcher) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValueMatcher.Unmarshal(m, b)
}
func (m *ValueMatcher) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValueMatcher.Marshal(b, m, deterministic)
}
func (m *ValueMatcher) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValueMatcher.Merge(m, src)
}
func (m *ValueMatcher) XXX_Size() int {
	return xxx_messageInfo_ValueMatcher.Size(m)
}
func (m *ValueMatcher) XXX_DiscardUnknown() {
	xxx_messageInfo_ValueMatcher.DiscardUnknown(m)
}

var xxx_messageInfo_ValueMatcher proto.InternalMessageInfo

type isValueMatcher_MatchVariant interface {
	isValueMatcher_MatchVariant()
}

type ValueMatcher_MatchesPattern struct {
	MatchesPattern string `protobuf:"bytes,1,opt,name=matches_pattern,json=matchesPattern,proto3,oneof"`
}

func (*ValueMatcher_MatchesPattern) isValueMatcher_MatchVariant() {}

func (m *ValueMatcher) GetMatchVariant() isValueMatcher_MatchVariant {
	if m != nil {
		return m.MatchVariant
	}
	return nil
}

func (m *ValueMatcher) GetMatchesPattern() string {
	if x, ok := m.GetMatchVariant().(*ValueMatcher_MatchesPattern); ok {
		return x.MatchesPattern
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ValueMatcher) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ValueMatcher_MatchesPattern)(nil),
	}
}

// Contains metadata about how much money a recommendation can save or incur.
type CostProjection struct {
	// An approximate projection on amount saved or amount incurred. Negative cost
	// units indicate cost savings and positive cost units indicate increase.
	// See google.type.Money documentation for positive/negative units.
	Cost *money.Money `protobuf:"bytes,1,opt,name=cost,proto3" json:"cost,omitempty"`
	// Duration for which this cost applies.
	Duration             *duration.Duration `protobuf:"bytes,2,opt,name=duration,proto3" json:"duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *CostProjection) Reset()         { *m = CostProjection{} }
func (m *CostProjection) String() string { return proto.CompactTextString(m) }
func (*CostProjection) ProtoMessage()    {}
func (*CostProjection) Descriptor() ([]byte, []int) {
	return fileDescriptor_79be8d5bd206286c, []int{5}
}

func (m *CostProjection) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CostProjection.Unmarshal(m, b)
}
func (m *CostProjection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CostProjection.Marshal(b, m, deterministic)
}
func (m *CostProjection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CostProjection.Merge(m, src)
}
func (m *CostProjection) XXX_Size() int {
	return xxx_messageInfo_CostProjection.Size(m)
}
func (m *CostProjection) XXX_DiscardUnknown() {
	xxx_messageInfo_CostProjection.DiscardUnknown(m)
}

var xxx_messageInfo_CostProjection proto.InternalMessageInfo

func (m *CostProjection) GetCost() *money.Money {
	if m != nil {
		return m.Cost
	}
	return nil
}

func (m *CostProjection) GetDuration() *duration.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

// Contains the impact a recommendation can have for a given category.
type Impact struct {
	// Category that is being targeted.
	Category Impact_Category `protobuf:"varint,1,opt,name=category,proto3,enum=google.cloud.recommender.v1beta1.Impact_Category" json:"category,omitempty"`
	// Contains projections (if any) for this category.
	//
	// Types that are valid to be assigned to Projection:
	//	*Impact_CostProjection
	Projection           isImpact_Projection `protobuf_oneof:"projection"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Impact) Reset()         { *m = Impact{} }
func (m *Impact) String() string { return proto.CompactTextString(m) }
func (*Impact) ProtoMessage()    {}
func (*Impact) Descriptor() ([]byte, []int) {
	return fileDescriptor_79be8d5bd206286c, []int{6}
}

func (m *Impact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Impact.Unmarshal(m, b)
}
func (m *Impact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Impact.Marshal(b, m, deterministic)
}
func (m *Impact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Impact.Merge(m, src)
}
func (m *Impact) XXX_Size() int {
	return xxx_messageInfo_Impact.Size(m)
}
func (m *Impact) XXX_DiscardUnknown() {
	xxx_messageInfo_Impact.DiscardUnknown(m)
}

var xxx_messageInfo_Impact proto.InternalMessageInfo

func (m *Impact) GetCategory() Impact_Category {
	if m != nil {
		return m.Category
	}
	return Impact_CATEGORY_UNSPECIFIED
}

type isImpact_Projection interface {
	isImpact_Projection()
}

type Impact_CostProjection struct {
	CostProjection *CostProjection `protobuf:"bytes,100,opt,name=cost_projection,json=costProjection,proto3,oneof"`
}

func (*Impact_CostProjection) isImpact_Projection() {}

func (m *Impact) GetProjection() isImpact_Projection {
	if m != nil {
		return m.Projection
	}
	return nil
}

func (m *Impact) GetCostProjection() *CostProjection {
	if x, ok := m.GetProjection().(*Impact_CostProjection); ok {
		return x.CostProjection
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Impact) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Impact_CostProjection)(nil),
	}
}

// Information for state. Contains state and metadata.
type RecommendationStateInfo struct {
	// The state of the recommendation, Eg ACTIVE, SUCCEEDED, FAILED.
	State RecommendationStateInfo_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.recommender.v1beta1.RecommendationStateInfo_State" json:"state,omitempty"`
	// A map of metadata for the state, provided by user or automations systems.
	StateMetadata        map[string]string `protobuf:"bytes,2,rep,name=state_metadata,json=stateMetadata,proto3" json:"state_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *RecommendationStateInfo) Reset()         { *m = RecommendationStateInfo{} }
func (m *RecommendationStateInfo) String() string { return proto.CompactTextString(m) }
func (*RecommendationStateInfo) ProtoMessage()    {}
func (*RecommendationStateInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_79be8d5bd206286c, []int{7}
}

func (m *RecommendationStateInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecommendationStateInfo.Unmarshal(m, b)
}
func (m *RecommendationStateInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecommendationStateInfo.Marshal(b, m, deterministic)
}
func (m *RecommendationStateInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecommendationStateInfo.Merge(m, src)
}
func (m *RecommendationStateInfo) XXX_Size() int {
	return xxx_messageInfo_RecommendationStateInfo.Size(m)
}
func (m *RecommendationStateInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_RecommendationStateInfo.DiscardUnknown(m)
}

var xxx_messageInfo_RecommendationStateInfo proto.InternalMessageInfo

func (m *RecommendationStateInfo) GetState() RecommendationStateInfo_State {
	if m != nil {
		return m.State
	}
	return RecommendationStateInfo_STATE_UNSPECIFIED
}

func (m *RecommendationStateInfo) GetStateMetadata() map[string]string {
	if m != nil {
		return m.StateMetadata
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.recommender.v1beta1.Impact_Category", Impact_Category_name, Impact_Category_value)
	proto.RegisterEnum("google.cloud.recommender.v1beta1.RecommendationStateInfo_State", RecommendationStateInfo_State_name, RecommendationStateInfo_State_value)
	proto.RegisterType((*Recommendation)(nil), "google.cloud.recommender.v1beta1.Recommendation")
	proto.RegisterType((*RecommendationContent)(nil), "google.cloud.recommender.v1beta1.RecommendationContent")
	proto.RegisterType((*OperationGroup)(nil), "google.cloud.recommender.v1beta1.OperationGroup")
	proto.RegisterType((*Operation)(nil), "google.cloud.recommender.v1beta1.Operation")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.recommender.v1beta1.Operation.PathFiltersEntry")
	proto.RegisterMapType((map[string]*ValueMatcher)(nil), "google.cloud.recommender.v1beta1.Operation.PathValueMatchersEntry")
	proto.RegisterType((*ValueMatcher)(nil), "google.cloud.recommender.v1beta1.ValueMatcher")
	proto.RegisterType((*CostProjection)(nil), "google.cloud.recommender.v1beta1.CostProjection")
	proto.RegisterType((*Impact)(nil), "google.cloud.recommender.v1beta1.Impact")
	proto.RegisterType((*RecommendationStateInfo)(nil), "google.cloud.recommender.v1beta1.RecommendationStateInfo")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommender.v1beta1.RecommendationStateInfo.StateMetadataEntry")
}

func init() {
	proto.RegisterFile("google/cloud/recommender/v1beta1/recommendation.proto", fileDescriptor_79be8d5bd206286c)
}

var fileDescriptor_79be8d5bd206286c = []byte{
	// 1173 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xdd, 0x6e, 0x1b, 0x45,
	0x14, 0x8e, 0x1d, 0xdb, 0x75, 0x8e, 0xff, 0x36, 0xd3, 0xbf, 0xad, 0x85, 0x68, 0x64, 0x50, 0x69,
	0x05, 0xda, 0x25, 0x45, 0x15, 0x50, 0x90, 0xc0, 0x5e, 0x6f, 0x52, 0xd3, 0xb8, 0x09, 0x63, 0x27,
	0xa2, 0x54, 0x68, 0x99, 0xac, 0x27, 0xae, 0xc1, 0xbb, 0xb3, 0xda, 0x1d, 0x47, 0x8a, 0xaa, 0xbe,
	0x00, 0x17, 0x88, 0x0b, 0x9e, 0x00, 0x71, 0xc5, 0x4b, 0xf0, 0x3e, 0x7d, 0x04, 0xae, 0xd0, 0xfc,
	0xac, 0xb3, 0x76, 0x53, 0x92, 0xd0, 0xbb, 0x99, 0x73, 0xce, 0xf7, 0x9d, 0xbf, 0x39, 0x7b, 0x16,
	0x1e, 0x8c, 0x19, 0x1b, 0x4f, 0xa9, 0xed, 0x4f, 0xd9, 0x6c, 0x64, 0xc7, 0xd4, 0x67, 0x41, 0x40,
	0xc3, 0x11, 0x8d, 0xed, 0xe3, 0xcd, 0x43, 0xca, 0xc9, 0xe6, 0xa9, 0x8c, 0xf0, 0x09, 0x0b, 0xad,
	0x28, 0x66, 0x9c, 0xa1, 0x0d, 0x05, 0xb3, 0x24, 0xcc, 0xca, 0xc0, 0x2c, 0x0d, 0x6b, 0xde, 0xd2,
	0xc4, 0x24, 0x9a, 0xd8, 0x31, 0x4d, 0xd8, 0x2c, 0xf6, 0xa9, 0x02, 0x37, 0xdf, 0xd5, 0x2a, 0x79,
	0x3b, 0x9c, 0x1d, 0xd9, 0xa3, 0x59, 0x9c, 0x21, 0x6f, 0xbe, 0xb3, 0xac, 0x4f, 0x78, 0x3c, 0xf3,
	0xb9, 0xd6, 0xde, 0x5e, 0xd6, 0xf2, 0x49, 0x40, 0x13, 0x4e, 0x82, 0x48, 0x1b, 0xdc, 0xd4, 0x06,
	0xfc, 0x24, 0xa2, 0x76, 0xc0, 0x42, 0x7a, 0xa2, 0x14, 0xad, 0xbf, 0x8b, 0x50, 0xc7, 0x0b, 0xd9,
	0x20, 0x04, 0x85, 0x90, 0x04, 0xd4, 0xcc, 0x6d, 0xe4, 0xee, 0xae, 0x61, 0x79, 0x46, 0x1b, 0x50,
	0x19, 0xd1, 0xc4, 0x8f, 0x27, 0x91, 0x30, 0x31, 0xf3, 0x52, 0x95, 0x15, 0x21, 0x1b, 0xae, 0x66,
	0x52, 0xf6, 0x92, 0xd9, 0xa1, 0xf0, 0x65, 0x56, 0xa5, 0x25, 0xca, 0xa8, 0x06, 0x4a, 0x83, 0xb6,
	0x60, 0x7d, 0x4a, 0x12, 0xee, 0xc5, 0xf4, 0x28, 0xa6, 0xc9, 0x73, 0x4f, 0x84, 0x6c, 0x16, 0x36,
	0x72, 0x77, 0x2b, 0xf7, 0x9b, 0x96, 0x2e, 0x65, 0x9a, 0x8f, 0x35, 0x4c, 0xf3, 0xc1, 0x0d, 0x01,
	0xc2, 0x0a, 0x23, 0xa4, 0x68, 0x17, 0xea, 0x51, 0x3c, 0x09, 0x48, 0x7c, 0xe2, 0x4d, 0x82, 0x88,
	0xf8, 0xdc, 0x2c, 0x4a, 0x92, 0xbb, 0xd6, 0x79, 0xfd, 0xb0, 0x7a, 0xd2, 0x1e, 0xd7, 0x34, 0x5e,
	0x5d, 0xd1, 0x3e, 0xac, 0x93, 0xd1, 0x68, 0x22, 0xb2, 0x22, 0xd3, 0x94, 0xb3, 0xb4, 0xb1, 0x7a,
	0x29, 0x4e, 0xe3, 0x94, 0x42, 0xd3, 0x7e, 0x0b, 0x57, 0x7c, 0x16, 0x72, 0x1a, 0x72, 0xf3, 0x8a,
	0x0c, 0xf0, 0xd3, 0xf3, 0xc9, 0x16, 0x3b, 0xe3, 0x28, 0x38, 0x4e, 0x79, 0xd0, 0x77, 0x00, 0x09,
	0x27, 0x9c, 0x7a, 0x93, 0xf0, 0x88, 0x99, 0x20, 0x59, 0x3f, 0xbf, 0x2c, 0xeb, 0x40, 0x30, 0xf4,
	0xc2, 0x23, 0x86, 0xd7, 0x92, 0xf4, 0x28, 0xde, 0x00, 0xe5, 0x64, 0x6c, 0x56, 0xd4, 0x1b, 0x10,
	0xe7, 0x87, 0xbf, 0xe7, 0x5e, 0xb5, 0x7f, 0xcb, 0xc1, 0xbd, 0x2c, 0xa5, 0xf2, 0x45, 0xa2, 0x49,
	0x62, 0xf9, 0x2c, 0xb0, 0x97, 0x5e, 0x92, 0x1f, 0xc5, 0xec, 0x27, 0xea, 0xf3, 0xc4, 0x7e, 0xa1,
	0x4f, 0x2f, 0xed, 0x29, 0xf3, 0xa5, 0x32, 0xb1, 0x5f, 0xa4, 0xc7, 0x97, 0xd9, 0x19, 0x4b, 0xec,
	0x17, 0x99, 0xdb, 0xcb, 0xa5, 0x51, 0xcb, 0x6a, 0x15, 0xb6, 0xc5, 0xe1, 0xfa, 0x99, 0x65, 0x42,
	0xcf, 0xc0, 0x60, 0x11, 0x55, 0x53, 0xe4, 0x8d, 0x63, 0x36, 0x8b, 0x12, 0x33, 0x2f, 0xdb, 0xf8,
	0xf1, 0xf9, 0x35, 0xda, 0x4d, 0x91, 0xdb, 0x02, 0x88, 0x1b, 0x6c, 0xe1, 0x9e, 0xb4, 0x7e, 0x80,
	0xfa, 0xa2, 0x09, 0x7a, 0x0c, 0x30, 0x37, 0x4a, 0xcc, 0x9c, 0x74, 0xf4, 0xe1, 0x25, 0x1c, 0xe1,
	0x0c, 0xbc, 0xf5, 0x4f, 0x11, 0xd6, 0xe6, 0x1a, 0x74, 0x03, 0x4a, 0xc4, 0x97, 0x83, 0xa7, 0x66,
	0x52, 0xdf, 0xd0, 0x7b, 0x50, 0x4b, 0x3f, 0x23, 0x9e, 0x9c, 0x36, 0x35, 0x97, 0xd5, 0x54, 0x38,
	0x14, 0x73, 0xd6, 0x84, 0x72, 0x7a, 0x37, 0x57, 0xa5, 0x7e, 0x7e, 0x17, 0x6d, 0x8e, 0x08, 0x7f,
	0x2e, 0xc7, 0x6e, 0x0d, 0xcb, 0x33, 0xfa, 0x00, 0x1a, 0x9a, 0x72, 0x0e, 0x2b, 0x4a, 0x75, 0x5d,
	0xdd, 0x70, 0x0a, 0xbe, 0x0d, 0x15, 0x6d, 0x28, 0x39, 0x4a, 0xd2, 0x08, 0x94, 0x68, 0x4f, 0x30,
	0x59, 0x50, 0x3c, 0x26, 0xd3, 0x19, 0xd5, 0xef, 0xfd, 0xc6, 0x6b, 0x53, 0x7d, 0x20, 0xb4, 0x8f,
	0x56, 0xb0, 0x32, 0x43, 0xfb, 0x50, 0x93, 0x07, 0x2f, 0x20, 0xdc, 0x7f, 0x4e, 0x63, 0xfd, 0xa2,
	0xad, 0xf3, 0x8b, 0x28, 0x89, 0xfa, 0x0a, 0xf5, 0x68, 0x05, 0x57, 0x8f, 0x33, 0x77, 0xe4, 0x41,
	0x55, 0x04, 0xe8, 0x1d, 0x4d, 0xa6, 0x9c, 0xc6, 0x89, 0x59, 0x96, 0xad, 0xf9, 0xf2, 0x12, 0xad,
	0xb1, 0x44, 0x3a, 0x5b, 0x0a, 0xee, 0x86, 0x3c, 0x3e, 0xc1, 0x95, 0xe8, 0x54, 0x82, 0x62, 0xb8,
	0x2a, 0x1d, 0x2c, 0x04, 0x9f, 0x98, 0x15, 0xe9, 0xa7, 0x73, 0x59, 0x3f, 0xd9, 0x5c, 0xb4, 0xb7,
	0xf5, 0x68, 0x59, 0xde, 0x3c, 0x00, 0x63, 0x39, 0x28, 0x64, 0xc0, 0xea, 0xcf, 0xf4, 0x44, 0xbf,
	0x11, 0x71, 0x44, 0x1f, 0xa5, 0x1d, 0xc8, 0xff, 0x57, 0x07, 0x74, 0xfd, 0x1f, 0xe6, 0x3f, 0xcb,
	0x35, 0x39, 0xdc, 0x38, 0x3b, 0x88, 0x33, 0xd8, 0xbb, 0x8b, 0xec, 0x97, 0xec, 0x53, 0xc6, 0x6b,
	0xa7, 0x0a, 0x70, 0x5a, 0xc1, 0xd6, 0x37, 0x50, 0xcd, 0x1a, 0xa2, 0x7b, 0xd0, 0x50, 0x45, 0x4d,
	0xc4, 0x4b, 0xe3, 0x34, 0xd6, 0x73, 0xf0, 0x68, 0x05, 0xd7, 0xb5, 0x62, 0x4f, 0xc9, 0x3b, 0x0d,
	0xa8, 0x49, 0x89, 0x77, 0x4c, 0xe2, 0x09, 0x09, 0x79, 0x8b, 0x41, 0xdd, 0x61, 0x09, 0xdf, 0x53,
	0x9f, 0x1f, 0x31, 0x34, 0x77, 0xa0, 0xe0, 0xb3, 0x84, 0x4b, 0x8a, 0xca, 0x7d, 0x94, 0x06, 0x2d,
	0xe6, 0xc7, 0xea, 0x8b, 0xcd, 0x88, 0xa5, 0x1e, 0x3d, 0x80, 0x72, 0xba, 0x83, 0x75, 0x82, 0xb7,
	0x5e, 0x2b, 0x5f, 0x57, 0x1b, 0xe0, 0xb9, 0x69, 0xeb, 0xcf, 0x3c, 0x94, 0xf4, 0x17, 0xbf, 0x0f,
	0x65, 0x9f, 0x70, 0x3a, 0x66, 0xb1, 0x2a, 0x5b, 0xfd, 0xfe, 0xe6, 0x45, 0xf7, 0x87, 0xe5, 0x68,
	0x20, 0x9e, 0x53, 0xa0, 0x67, 0xd0, 0x10, 0x81, 0x79, 0xd1, 0x3c, 0x17, 0x73, 0x24, 0xe3, 0xba,
	0xc0, 0xe7, 0x6c, 0xb1, 0x06, 0xa2, 0x70, 0xfe, 0x82, 0xa4, 0xf5, 0x23, 0x94, 0x53, 0x97, 0xc8,
	0x84, 0x6b, 0x4e, 0x7b, 0xe8, 0x6e, 0xef, 0xe2, 0xa7, 0xde, 0xfe, 0x93, 0xc1, 0x9e, 0xeb, 0xf4,
	0xb6, 0x7a, 0x6e, 0xd7, 0x58, 0x41, 0x65, 0x28, 0x38, 0xbb, 0x83, 0xa1, 0x91, 0x43, 0x55, 0x28,
	0x0f, 0x5c, 0x67, 0x1f, 0xf7, 0x86, 0x4f, 0x8d, 0x3c, 0x6a, 0x40, 0x65, 0xcf, 0xc5, 0x5b, 0xbb,
	0xb8, 0xdf, 0x7e, 0xe2, 0xb8, 0xc6, 0x2a, 0x5a, 0x87, 0x5a, 0xbf, 0xfd, 0xa4, 0xbd, 0xed, 0xb6,
	0x3b, 0xbd, 0x1d, 0x61, 0x53, 0x90, 0x3d, 0x3e, 0xf5, 0xf7, 0xcb, 0x2a, 0xdc, 0x7c, 0xc3, 0x1e,
	0x42, 0xfb, 0x50, 0x94, 0x9b, 0x48, 0x17, 0xed, 0xab, 0xff, 0xbd, 0xd1, 0x2c, 0x79, 0xc2, 0x8a,
	0x0d, 0x25, 0x50, 0x57, 0xdb, 0x32, 0xa0, 0x9c, 0x8c, 0x08, 0x27, 0x7a, 0x1b, 0xec, 0xbc, 0x25,
	0x7f, 0x5f, 0xd3, 0xa9, 0x59, 0xad, 0x25, 0x59, 0x59, 0xf3, 0x6b, 0x40, 0xaf, 0x1b, 0x9d, 0x31,
	0x4b, 0xd7, 0xb2, 0xb3, 0xb4, 0x96, 0x99, 0x8d, 0x16, 0x81, 0xa2, 0x64, 0x40, 0xd7, 0x61, 0x7d,
	0x30, 0x6c, 0x0f, 0xdd, 0xa5, 0x9e, 0x00, 0x94, 0xda, 0xce, 0xb0, 0x77, 0xe0, 0x1a, 0x39, 0x54,
	0x81, 0x2b, 0xce, 0x4e, 0xbb, 0xd7, 0x77, 0xbb, 0x46, 0x09, 0xd5, 0x60, 0x6d, 0xb0, 0xef, 0x38,
	0xae, 0xdb, 0x75, 0xbb, 0xc6, 0xaa, 0xb0, 0xdb, 0x6a, 0xf7, 0x76, 0xdc, 0xae, 0x51, 0x10, 0xaa,
	0x6e, 0x6f, 0xd0, 0xef, 0x0d, 0x06, 0x6e, 0xd7, 0x28, 0x76, 0x7e, 0xcd, 0xbf, 0x6a, 0x4f, 0xe1,
	0xce, 0x45, 0x16, 0x3b, 0x8d, 0x51, 0xe7, 0xed, 0xb7, 0x3a, 0xbc, 0xef, 0xb3, 0xe0, 0xdc, 0xb2,
	0xef, 0xe5, 0xbe, 0x7f, 0xac, 0x6d, 0xc6, 0x6c, 0x4a, 0xc2, 0xb1, 0xc5, 0xe2, 0xb1, 0x3d, 0xa6,
	0xa1, 0x9c, 0x3f, 0xfb, 0x34, 0xc4, 0x37, 0xff, 0xa9, 0x7f, 0x91, 0x91, 0xfd, 0x91, 0x2f, 0x38,
	0xd8, 0x75, 0xfe, 0xca, 0x6f, 0x6c, 0x2b, 0x52, 0x47, 0x3a, 0xce, 0xa4, 0x66, 0x1d, 0x6c, 0x76,
	0x04, 0xea, 0xb0, 0x24, 0x3d, 0x7c, 0xf2, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x01, 0xee, 0x86,
	0xa5, 0x0a, 0x0c, 0x00, 0x00,
}
