// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/services/reach_plan_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [ReachForecastService.ListPlannableLocations][]
type ListPlannableLocationsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPlannableLocationsRequest) Reset()         { *m = ListPlannableLocationsRequest{} }
func (m *ListPlannableLocationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListPlannableLocationsRequest) ProtoMessage()    {}
func (*ListPlannableLocationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{0}
}

func (m *ListPlannableLocationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPlannableLocationsRequest.Unmarshal(m, b)
}
func (m *ListPlannableLocationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPlannableLocationsRequest.Marshal(b, m, deterministic)
}
func (m *ListPlannableLocationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPlannableLocationsRequest.Merge(m, src)
}
func (m *ListPlannableLocationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListPlannableLocationsRequest.Size(m)
}
func (m *ListPlannableLocationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPlannableLocationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPlannableLocationsRequest proto.InternalMessageInfo

// The list of plannable locations.
type ListPlannableLocationsResponse struct {
	// The list of locations available for planning (Countries, DMAs,
	// sub-countries).
	// For locations like Countries, DMAs see
	// https://developers.google.com/adwords/api/docs/appendix/geotargeting for
	// more information.
	PlannableLocations   []*PlannableLocation `protobuf:"bytes,1,rep,name=plannable_locations,json=plannableLocations,proto3" json:"plannable_locations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListPlannableLocationsResponse) Reset()         { *m = ListPlannableLocationsResponse{} }
func (m *ListPlannableLocationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListPlannableLocationsResponse) ProtoMessage()    {}
func (*ListPlannableLocationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{1}
}

func (m *ListPlannableLocationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPlannableLocationsResponse.Unmarshal(m, b)
}
func (m *ListPlannableLocationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPlannableLocationsResponse.Marshal(b, m, deterministic)
}
func (m *ListPlannableLocationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPlannableLocationsResponse.Merge(m, src)
}
func (m *ListPlannableLocationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListPlannableLocationsResponse.Size(m)
}
func (m *ListPlannableLocationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPlannableLocationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPlannableLocationsResponse proto.InternalMessageInfo

func (m *ListPlannableLocationsResponse) GetPlannableLocations() []*PlannableLocation {
	if m != nil {
		return m.PlannableLocations
	}
	return nil
}

// A plannable location: a country, a DMA, a metro region, a tv region,
// a province.
type PlannableLocation struct {
	// The location identifier.
	Id *wrappers.StringValue `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The unique location name in english.
	Name *wrappers.StringValue `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The parent country code, not present if location is a country.
	// If present will always be a criterion id: additional information, such as
	// country name are returned both via ListPlannableLocations or directly by
	// accessing GeoTargetConstantService with the criterion id.
	ParentCountryId      *wrappers.Int64Value `protobuf:"bytes,3,opt,name=parent_country_id,json=parentCountryId,proto3" json:"parent_country_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PlannableLocation) Reset()         { *m = PlannableLocation{} }
func (m *PlannableLocation) String() string { return proto.CompactTextString(m) }
func (*PlannableLocation) ProtoMessage()    {}
func (*PlannableLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{2}
}

func (m *PlannableLocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlannableLocation.Unmarshal(m, b)
}
func (m *PlannableLocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlannableLocation.Marshal(b, m, deterministic)
}
func (m *PlannableLocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlannableLocation.Merge(m, src)
}
func (m *PlannableLocation) XXX_Size() int {
	return xxx_messageInfo_PlannableLocation.Size(m)
}
func (m *PlannableLocation) XXX_DiscardUnknown() {
	xxx_messageInfo_PlannableLocation.DiscardUnknown(m)
}

var xxx_messageInfo_PlannableLocation proto.InternalMessageInfo

func (m *PlannableLocation) GetId() *wrappers.StringValue {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *PlannableLocation) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *PlannableLocation) GetParentCountryId() *wrappers.Int64Value {
	if m != nil {
		return m.ParentCountryId
	}
	return nil
}

// Request to list available products in a given location.
type ListPlannableProductsRequest struct {
	// The ID of the selected location for planning. To list the available
	// plannable location ids use ListPlannableLocations.
	PlannableLocationId  *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_location_id,json=plannableLocationId,proto3" json:"plannable_location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ListPlannableProductsRequest) Reset()         { *m = ListPlannableProductsRequest{} }
func (m *ListPlannableProductsRequest) String() string { return proto.CompactTextString(m) }
func (*ListPlannableProductsRequest) ProtoMessage()    {}
func (*ListPlannableProductsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{3}
}

func (m *ListPlannableProductsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPlannableProductsRequest.Unmarshal(m, b)
}
func (m *ListPlannableProductsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPlannableProductsRequest.Marshal(b, m, deterministic)
}
func (m *ListPlannableProductsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPlannableProductsRequest.Merge(m, src)
}
func (m *ListPlannableProductsRequest) XXX_Size() int {
	return xxx_messageInfo_ListPlannableProductsRequest.Size(m)
}
func (m *ListPlannableProductsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPlannableProductsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPlannableProductsRequest proto.InternalMessageInfo

func (m *ListPlannableProductsRequest) GetPlannableLocationId() *wrappers.StringValue {
	if m != nil {
		return m.PlannableLocationId
	}
	return nil
}

// A response with all available products.
type ListPlannableProductsResponse struct {
	// The list of products available for planning and related targeting metadata.
	ProductMetadata      []*ProductMetadata `protobuf:"bytes,1,rep,name=product_metadata,json=productMetadata,proto3" json:"product_metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ListPlannableProductsResponse) Reset()         { *m = ListPlannableProductsResponse{} }
func (m *ListPlannableProductsResponse) String() string { return proto.CompactTextString(m) }
func (*ListPlannableProductsResponse) ProtoMessage()    {}
func (*ListPlannableProductsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{4}
}

func (m *ListPlannableProductsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPlannableProductsResponse.Unmarshal(m, b)
}
func (m *ListPlannableProductsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPlannableProductsResponse.Marshal(b, m, deterministic)
}
func (m *ListPlannableProductsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPlannableProductsResponse.Merge(m, src)
}
func (m *ListPlannableProductsResponse) XXX_Size() int {
	return xxx_messageInfo_ListPlannableProductsResponse.Size(m)
}
func (m *ListPlannableProductsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPlannableProductsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPlannableProductsResponse proto.InternalMessageInfo

func (m *ListPlannableProductsResponse) GetProductMetadata() []*ProductMetadata {
	if m != nil {
		return m.ProductMetadata
	}
	return nil
}

// The metadata associated with an available plannable product.
type ProductMetadata struct {
	// The code associated with the ad product. E.g. Trueview, Bumper
	// To list the available plannable product codes use ListPlannableProducts.
	PlannableProductCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_product_code,json=plannableProductCode,proto3" json:"plannable_product_code,omitempty"`
	// The allowed plannable targeting for this product.
	PlannableTargeting   *PlannableTargeting `protobuf:"bytes,2,opt,name=plannable_targeting,json=plannableTargeting,proto3" json:"plannable_targeting,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ProductMetadata) Reset()         { *m = ProductMetadata{} }
func (m *ProductMetadata) String() string { return proto.CompactTextString(m) }
func (*ProductMetadata) ProtoMessage()    {}
func (*ProductMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{5}
}

func (m *ProductMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductMetadata.Unmarshal(m, b)
}
func (m *ProductMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductMetadata.Marshal(b, m, deterministic)
}
func (m *ProductMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductMetadata.Merge(m, src)
}
func (m *ProductMetadata) XXX_Size() int {
	return xxx_messageInfo_ProductMetadata.Size(m)
}
func (m *ProductMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ProductMetadata proto.InternalMessageInfo

func (m *ProductMetadata) GetPlannableProductCode() *wrappers.StringValue {
	if m != nil {
		return m.PlannableProductCode
	}
	return nil
}

func (m *ProductMetadata) GetPlannableTargeting() *PlannableTargeting {
	if m != nil {
		return m.PlannableTargeting
	}
	return nil
}

// The targeting for which traffic metrics will be reported.
type PlannableTargeting struct {
	// Allowed plannable age ranges for the product for which metrics will be
	// reported. Actual targeting is computed by mapping this age range onto
	// standard Google common.AgeRangeInfo values.
	AgeRanges []enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange `protobuf:"varint,1,rep,packed,name=age_ranges,json=ageRanges,proto3,enum=google.ads.googleads.v2.enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange" json:"age_ranges,omitempty"`
	// Targetable genders for the ad product.
	Genders []*common.GenderInfo `protobuf:"bytes,2,rep,name=genders,proto3" json:"genders,omitempty"`
	// Targetable devices for the ad product.
	Devices              []*common.DeviceInfo `protobuf:"bytes,3,rep,name=devices,proto3" json:"devices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PlannableTargeting) Reset()         { *m = PlannableTargeting{} }
func (m *PlannableTargeting) String() string { return proto.CompactTextString(m) }
func (*PlannableTargeting) ProtoMessage()    {}
func (*PlannableTargeting) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{6}
}

func (m *PlannableTargeting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlannableTargeting.Unmarshal(m, b)
}
func (m *PlannableTargeting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlannableTargeting.Marshal(b, m, deterministic)
}
func (m *PlannableTargeting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlannableTargeting.Merge(m, src)
}
func (m *PlannableTargeting) XXX_Size() int {
	return xxx_messageInfo_PlannableTargeting.Size(m)
}
func (m *PlannableTargeting) XXX_DiscardUnknown() {
	xxx_messageInfo_PlannableTargeting.DiscardUnknown(m)
}

var xxx_messageInfo_PlannableTargeting proto.InternalMessageInfo

func (m *PlannableTargeting) GetAgeRanges() []enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange {
	if m != nil {
		return m.AgeRanges
	}
	return nil
}

func (m *PlannableTargeting) GetGenders() []*common.GenderInfo {
	if m != nil {
		return m.Genders
	}
	return nil
}

func (m *PlannableTargeting) GetDevices() []*common.DeviceInfo {
	if m != nil {
		return m.Devices
	}
	return nil
}

// Request message for [ReachForecastService.GenerateProductMixIdeas][].
type GenerateProductMixIdeasRequest struct {
	// The ID of the customer.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The ID of the location, this is one of the ids returned by
	// ListPlannableLocations.
	PlannableLocationId *wrappers.StringValue `protobuf:"bytes,2,opt,name=plannable_location_id,json=plannableLocationId,proto3" json:"plannable_location_id,omitempty"`
	// Required. Currency code.
	// Three-character ISO 4217 currency code.
	CurrencyCode *wrappers.StringValue `protobuf:"bytes,3,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Required. Total budget.
	// Amount in micros. One million is equivalent to one unit.
	BudgetMicros *wrappers.Int64Value `protobuf:"bytes,4,opt,name=budget_micros,json=budgetMicros,proto3" json:"budget_micros,omitempty"`
	// The preferences of the suggested product mix.
	// An unset preference is interpreted as all possible values are allowed,
	// unless explicitly specified.
	Preferences          *Preferences `protobuf:"bytes,5,opt,name=preferences,proto3" json:"preferences,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *GenerateProductMixIdeasRequest) Reset()         { *m = GenerateProductMixIdeasRequest{} }
func (m *GenerateProductMixIdeasRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateProductMixIdeasRequest) ProtoMessage()    {}
func (*GenerateProductMixIdeasRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{7}
}

func (m *GenerateProductMixIdeasRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateProductMixIdeasRequest.Unmarshal(m, b)
}
func (m *GenerateProductMixIdeasRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateProductMixIdeasRequest.Marshal(b, m, deterministic)
}
func (m *GenerateProductMixIdeasRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateProductMixIdeasRequest.Merge(m, src)
}
func (m *GenerateProductMixIdeasRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateProductMixIdeasRequest.Size(m)
}
func (m *GenerateProductMixIdeasRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateProductMixIdeasRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateProductMixIdeasRequest proto.InternalMessageInfo

func (m *GenerateProductMixIdeasRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *GenerateProductMixIdeasRequest) GetPlannableLocationId() *wrappers.StringValue {
	if m != nil {
		return m.PlannableLocationId
	}
	return nil
}

func (m *GenerateProductMixIdeasRequest) GetCurrencyCode() *wrappers.StringValue {
	if m != nil {
		return m.CurrencyCode
	}
	return nil
}

func (m *GenerateProductMixIdeasRequest) GetBudgetMicros() *wrappers.Int64Value {
	if m != nil {
		return m.BudgetMicros
	}
	return nil
}

func (m *GenerateProductMixIdeasRequest) GetPreferences() *Preferences {
	if m != nil {
		return m.Preferences
	}
	return nil
}

// Set of preferences about the planned mix.
type Preferences struct {
	// True if ad skippable.
	// If not set, default is any value.
	IsSkippable *wrappers.BoolValue `protobuf:"bytes,1,opt,name=is_skippable,json=isSkippable,proto3" json:"is_skippable,omitempty"`
	// True if ad start with sound.
	// If not set, default is any value.
	StartsWithSound *wrappers.BoolValue `protobuf:"bytes,2,opt,name=starts_with_sound,json=startsWithSound,proto3" json:"starts_with_sound,omitempty"`
	// The length of the ad.
	// If not set, default is any value.
	AdLength enums.ReachPlanAdLengthEnum_ReachPlanAdLength `protobuf:"varint,3,opt,name=ad_length,json=adLength,proto3,enum=google.ads.googleads.v2.enums.ReachPlanAdLengthEnum_ReachPlanAdLength" json:"ad_length,omitempty"`
	// True if ad will only show on the top content.
	// If not set, default is false.
	TopContentOnly *wrappers.BoolValue `protobuf:"bytes,4,opt,name=top_content_only,json=topContentOnly,proto3" json:"top_content_only,omitempty"`
	// True if the price guaranteed. The cost of serving the ad is agreed upfront
	// and not subject to an auction.
	// If not set, default is any value.
	HasGuaranteedPrice   *wrappers.BoolValue `protobuf:"bytes,5,opt,name=has_guaranteed_price,json=hasGuaranteedPrice,proto3" json:"has_guaranteed_price,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Preferences) Reset()         { *m = Preferences{} }
func (m *Preferences) String() string { return proto.CompactTextString(m) }
func (*Preferences) ProtoMessage()    {}
func (*Preferences) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{8}
}

func (m *Preferences) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Preferences.Unmarshal(m, b)
}
func (m *Preferences) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Preferences.Marshal(b, m, deterministic)
}
func (m *Preferences) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Preferences.Merge(m, src)
}
func (m *Preferences) XXX_Size() int {
	return xxx_messageInfo_Preferences.Size(m)
}
func (m *Preferences) XXX_DiscardUnknown() {
	xxx_messageInfo_Preferences.DiscardUnknown(m)
}

var xxx_messageInfo_Preferences proto.InternalMessageInfo

func (m *Preferences) GetIsSkippable() *wrappers.BoolValue {
	if m != nil {
		return m.IsSkippable
	}
	return nil
}

func (m *Preferences) GetStartsWithSound() *wrappers.BoolValue {
	if m != nil {
		return m.StartsWithSound
	}
	return nil
}

func (m *Preferences) GetAdLength() enums.ReachPlanAdLengthEnum_ReachPlanAdLength {
	if m != nil {
		return m.AdLength
	}
	return enums.ReachPlanAdLengthEnum_UNSPECIFIED
}

func (m *Preferences) GetTopContentOnly() *wrappers.BoolValue {
	if m != nil {
		return m.TopContentOnly
	}
	return nil
}

func (m *Preferences) GetHasGuaranteedPrice() *wrappers.BoolValue {
	if m != nil {
		return m.HasGuaranteedPrice
	}
	return nil
}

// The suggested product mix.
type GenerateProductMixIdeasResponse struct {
	// A list of products (ad formats) and the associated budget allocation idea.
	ProductAllocation    []*ProductAllocation `protobuf:"bytes,1,rep,name=product_allocation,json=productAllocation,proto3" json:"product_allocation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GenerateProductMixIdeasResponse) Reset()         { *m = GenerateProductMixIdeasResponse{} }
func (m *GenerateProductMixIdeasResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateProductMixIdeasResponse) ProtoMessage()    {}
func (*GenerateProductMixIdeasResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{9}
}

func (m *GenerateProductMixIdeasResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateProductMixIdeasResponse.Unmarshal(m, b)
}
func (m *GenerateProductMixIdeasResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateProductMixIdeasResponse.Marshal(b, m, deterministic)
}
func (m *GenerateProductMixIdeasResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateProductMixIdeasResponse.Merge(m, src)
}
func (m *GenerateProductMixIdeasResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateProductMixIdeasResponse.Size(m)
}
func (m *GenerateProductMixIdeasResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateProductMixIdeasResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateProductMixIdeasResponse proto.InternalMessageInfo

func (m *GenerateProductMixIdeasResponse) GetProductAllocation() []*ProductAllocation {
	if m != nil {
		return m.ProductAllocation
	}
	return nil
}

// An allocation of a part of the budget on a given product.
type ProductAllocation struct {
	// Selected product for planning. The product codes returned are within the
	// set of the ones returned by ListPlannableProducts when using the same
	// location id.
	PlannableProductCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_product_code,json=plannableProductCode,proto3" json:"plannable_product_code,omitempty"`
	// The value to be allocated for the suggested product in requested currency.
	// Amount in micros. One million is equivalent to one unit.
	BudgetMicros         *wrappers.Int64Value `protobuf:"bytes,2,opt,name=budget_micros,json=budgetMicros,proto3" json:"budget_micros,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ProductAllocation) Reset()         { *m = ProductAllocation{} }
func (m *ProductAllocation) String() string { return proto.CompactTextString(m) }
func (*ProductAllocation) ProtoMessage()    {}
func (*ProductAllocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{10}
}

func (m *ProductAllocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductAllocation.Unmarshal(m, b)
}
func (m *ProductAllocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductAllocation.Marshal(b, m, deterministic)
}
func (m *ProductAllocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductAllocation.Merge(m, src)
}
func (m *ProductAllocation) XXX_Size() int {
	return xxx_messageInfo_ProductAllocation.Size(m)
}
func (m *ProductAllocation) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductAllocation.DiscardUnknown(m)
}

var xxx_messageInfo_ProductAllocation proto.InternalMessageInfo

func (m *ProductAllocation) GetPlannableProductCode() *wrappers.StringValue {
	if m != nil {
		return m.PlannableProductCode
	}
	return nil
}

func (m *ProductAllocation) GetBudgetMicros() *wrappers.Int64Value {
	if m != nil {
		return m.BudgetMicros
	}
	return nil
}

// Request message for [ReachPlanService.GenerateReachForecast][google.ads.googleads.v2.services.ReachPlanService.GenerateReachForecast].
type GenerateReachForecastRequest struct {
	// The ID of the customer.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The currency code.
	// Three-character ISO 4217 currency code.
	CurrencyCode *wrappers.StringValue `protobuf:"bytes,2,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Campaign duration.
	CampaignDuration *CampaignDuration `protobuf:"bytes,3,opt,name=campaign_duration,json=campaignDuration,proto3" json:"campaign_duration,omitempty"`
	// Desired cookie frequency cap that will be applied to each planned product.
	// This is equivalent to the frequency cap exposed in Google Ads when creating
	// a campaign, it represents the maximum number of times an ad can be shown to
	// the same user.
	// If not specified no cap is applied.
	CookieFrequencyCap *wrappers.Int32Value `protobuf:"bytes,4,opt,name=cookie_frequency_cap,json=cookieFrequencyCap,proto3" json:"cookie_frequency_cap,omitempty"`
	// Desired minimum effective frequency (the number of times a person was
	// exposed to the ad) for the reported reach metrics [1-10].
	// This won't affect the targeting, but just the reporting.
	// If not specified, a default of 1 is applied.
	MinEffectiveFrequency *wrappers.Int32Value `protobuf:"bytes,5,opt,name=min_effective_frequency,json=minEffectiveFrequency,proto3" json:"min_effective_frequency,omitempty"`
	// The targeting to be applied to all products selected in the product mix.
	//
	// This is planned targeting: execution details might vary based on the
	// advertising product, please consult an implementation specialist.
	//
	// If no targeting dimensions are specified, then campaigns will target
	// everywhere and everyone.
	//
	// See specific metrics for details on how targeting affects them.
	//
	// In some cases, targeting may be overridden using the
	// PlannedProduct.advanced_product_targeting field.
	Targeting *Targeting `protobuf:"bytes,6,opt,name=targeting,proto3" json:"targeting,omitempty"`
	// The product to be planned.
	PlannedProducts      []*PlannedProduct `protobuf:"bytes,7,rep,name=planned_products,json=plannedProducts,proto3" json:"planned_products,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *GenerateReachForecastRequest) Reset()         { *m = GenerateReachForecastRequest{} }
func (m *GenerateReachForecastRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateReachForecastRequest) ProtoMessage()    {}
func (*GenerateReachForecastRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{11}
}

func (m *GenerateReachForecastRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateReachForecastRequest.Unmarshal(m, b)
}
func (m *GenerateReachForecastRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateReachForecastRequest.Marshal(b, m, deterministic)
}
func (m *GenerateReachForecastRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateReachForecastRequest.Merge(m, src)
}
func (m *GenerateReachForecastRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateReachForecastRequest.Size(m)
}
func (m *GenerateReachForecastRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateReachForecastRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateReachForecastRequest proto.InternalMessageInfo

func (m *GenerateReachForecastRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *GenerateReachForecastRequest) GetCurrencyCode() *wrappers.StringValue {
	if m != nil {
		return m.CurrencyCode
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetCampaignDuration() *CampaignDuration {
	if m != nil {
		return m.CampaignDuration
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetCookieFrequencyCap() *wrappers.Int32Value {
	if m != nil {
		return m.CookieFrequencyCap
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetMinEffectiveFrequency() *wrappers.Int32Value {
	if m != nil {
		return m.MinEffectiveFrequency
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetTargeting() *Targeting {
	if m != nil {
		return m.Targeting
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetPlannedProducts() []*PlannedProduct {
	if m != nil {
		return m.PlannedProducts
	}
	return nil
}

// The targeting for which traffic metrics will be reported.
type Targeting struct {
	// Required. The ID of the selected location.
	// Plannable locations ID can be obtained from ListPlannableLocations.
	PlannableLocationId *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_location_id,json=plannableLocationId,proto3" json:"plannable_location_id,omitempty"`
	// Required
	// Selected age range to be planned on.
	AgeRange enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange `protobuf:"varint,2,opt,name=age_range,json=ageRange,proto3,enum=google.ads.googleads.v2.enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange" json:"age_range,omitempty"`
	// Targetable genders for the ad product.
	Genders []*common.GenderInfo `protobuf:"bytes,3,rep,name=genders,proto3" json:"genders,omitempty"`
	// Targetable devices for the ad product.
	Devices              []*common.DeviceInfo `protobuf:"bytes,4,rep,name=devices,proto3" json:"devices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Targeting) Reset()         { *m = Targeting{} }
func (m *Targeting) String() string { return proto.CompactTextString(m) }
func (*Targeting) ProtoMessage()    {}
func (*Targeting) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{12}
}

func (m *Targeting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Targeting.Unmarshal(m, b)
}
func (m *Targeting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Targeting.Marshal(b, m, deterministic)
}
func (m *Targeting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Targeting.Merge(m, src)
}
func (m *Targeting) XXX_Size() int {
	return xxx_messageInfo_Targeting.Size(m)
}
func (m *Targeting) XXX_DiscardUnknown() {
	xxx_messageInfo_Targeting.DiscardUnknown(m)
}

var xxx_messageInfo_Targeting proto.InternalMessageInfo

func (m *Targeting) GetPlannableLocationId() *wrappers.StringValue {
	if m != nil {
		return m.PlannableLocationId
	}
	return nil
}

func (m *Targeting) GetAgeRange() enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange {
	if m != nil {
		return m.AgeRange
	}
	return enums.ReachPlanAgeRangeEnum_UNSPECIFIED
}

func (m *Targeting) GetGenders() []*common.GenderInfo {
	if m != nil {
		return m.Genders
	}
	return nil
}

func (m *Targeting) GetDevices() []*common.DeviceInfo {
	if m != nil {
		return m.Devices
	}
	return nil
}

// The duration of a planned campaign.
type CampaignDuration struct {
	// The duration value in days.
	DurationInDays       *wrappers.Int32Value `protobuf:"bytes,1,opt,name=duration_in_days,json=durationInDays,proto3" json:"duration_in_days,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CampaignDuration) Reset()         { *m = CampaignDuration{} }
func (m *CampaignDuration) String() string { return proto.CompactTextString(m) }
func (*CampaignDuration) ProtoMessage()    {}
func (*CampaignDuration) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{13}
}

func (m *CampaignDuration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CampaignDuration.Unmarshal(m, b)
}
func (m *CampaignDuration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CampaignDuration.Marshal(b, m, deterministic)
}
func (m *CampaignDuration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CampaignDuration.Merge(m, src)
}
func (m *CampaignDuration) XXX_Size() int {
	return xxx_messageInfo_CampaignDuration.Size(m)
}
func (m *CampaignDuration) XXX_DiscardUnknown() {
	xxx_messageInfo_CampaignDuration.DiscardUnknown(m)
}

var xxx_messageInfo_CampaignDuration proto.InternalMessageInfo

func (m *CampaignDuration) GetDurationInDays() *wrappers.Int32Value {
	if m != nil {
		return m.DurationInDays
	}
	return nil
}

// A product being planned for reach.
type PlannedProduct struct {
	// Required. Selected product for planning.
	// Plannable products codes can be obtained from ListPlannableProducts.
	PlannableProductCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_product_code,json=plannableProductCode,proto3" json:"plannable_product_code,omitempty"`
	// Required. Maximum budget allocation in micros for the selected product.
	// The value is specified in the selected planning currency_code.
	// E.g. 1 000 000$ = 1 000 000 000 000 micros.
	BudgetMicros         *wrappers.Int64Value `protobuf:"bytes,2,opt,name=budget_micros,json=budgetMicros,proto3" json:"budget_micros,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PlannedProduct) Reset()         { *m = PlannedProduct{} }
func (m *PlannedProduct) String() string { return proto.CompactTextString(m) }
func (*PlannedProduct) ProtoMessage()    {}
func (*PlannedProduct) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{14}
}

func (m *PlannedProduct) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlannedProduct.Unmarshal(m, b)
}
func (m *PlannedProduct) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlannedProduct.Marshal(b, m, deterministic)
}
func (m *PlannedProduct) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlannedProduct.Merge(m, src)
}
func (m *PlannedProduct) XXX_Size() int {
	return xxx_messageInfo_PlannedProduct.Size(m)
}
func (m *PlannedProduct) XXX_DiscardUnknown() {
	xxx_messageInfo_PlannedProduct.DiscardUnknown(m)
}

var xxx_messageInfo_PlannedProduct proto.InternalMessageInfo

func (m *PlannedProduct) GetPlannableProductCode() *wrappers.StringValue {
	if m != nil {
		return m.PlannableProductCode
	}
	return nil
}

func (m *PlannedProduct) GetBudgetMicros() *wrappers.Int64Value {
	if m != nil {
		return m.BudgetMicros
	}
	return nil
}

// Response message containing the generated reach curve.
type GenerateReachForecastResponse struct {
	// Reference on target audiences for this curve.
	OnTargetAudienceMetrics *OnTargetAudienceMetrics `protobuf:"bytes,1,opt,name=on_target_audience_metrics,json=onTargetAudienceMetrics,proto3" json:"on_target_audience_metrics,omitempty"`
	// The generated reach curve for the planned product mix.
	ReachCurve           *ReachCurve `protobuf:"bytes,2,opt,name=reach_curve,json=reachCurve,proto3" json:"reach_curve,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *GenerateReachForecastResponse) Reset()         { *m = GenerateReachForecastResponse{} }
func (m *GenerateReachForecastResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateReachForecastResponse) ProtoMessage()    {}
func (*GenerateReachForecastResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{15}
}

func (m *GenerateReachForecastResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateReachForecastResponse.Unmarshal(m, b)
}
func (m *GenerateReachForecastResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateReachForecastResponse.Marshal(b, m, deterministic)
}
func (m *GenerateReachForecastResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateReachForecastResponse.Merge(m, src)
}
func (m *GenerateReachForecastResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateReachForecastResponse.Size(m)
}
func (m *GenerateReachForecastResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateReachForecastResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateReachForecastResponse proto.InternalMessageInfo

func (m *GenerateReachForecastResponse) GetOnTargetAudienceMetrics() *OnTargetAudienceMetrics {
	if m != nil {
		return m.OnTargetAudienceMetrics
	}
	return nil
}

func (m *GenerateReachForecastResponse) GetReachCurve() *ReachCurve {
	if m != nil {
		return m.ReachCurve
	}
	return nil
}

// The reach curve for the planned products.
type ReachCurve struct {
	// All points on the reach curve.
	ReachForecasts       []*ReachForecast `protobuf:"bytes,1,rep,name=reach_forecasts,json=reachForecasts,proto3" json:"reach_forecasts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ReachCurve) Reset()         { *m = ReachCurve{} }
func (m *ReachCurve) String() string { return proto.CompactTextString(m) }
func (*ReachCurve) ProtoMessage()    {}
func (*ReachCurve) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{16}
}

func (m *ReachCurve) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReachCurve.Unmarshal(m, b)
}
func (m *ReachCurve) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReachCurve.Marshal(b, m, deterministic)
}
func (m *ReachCurve) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReachCurve.Merge(m, src)
}
func (m *ReachCurve) XXX_Size() int {
	return xxx_messageInfo_ReachCurve.Size(m)
}
func (m *ReachCurve) XXX_DiscardUnknown() {
	xxx_messageInfo_ReachCurve.DiscardUnknown(m)
}

var xxx_messageInfo_ReachCurve proto.InternalMessageInfo

func (m *ReachCurve) GetReachForecasts() []*ReachForecast {
	if m != nil {
		return m.ReachForecasts
	}
	return nil
}

// A point on reach curve.
type ReachForecast struct {
	// The cost in micros.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// Forecasted traffic metrics for this point.
	Forecast *Forecast `protobuf:"bytes,2,opt,name=forecast,proto3" json:"forecast,omitempty"`
	// The forecasted allocation. This differs from the input allocation if one
	// or more product cannot fulfill the budget because of limited inventory.
	ForecastedProductAllocations []*ProductAllocation `protobuf:"bytes,3,rep,name=forecasted_product_allocations,json=forecastedProductAllocations,proto3" json:"forecasted_product_allocations,omitempty"`
	XXX_NoUnkeyedLiteral         struct{}             `json:"-"`
	XXX_unrecognized             []byte               `json:"-"`
	XXX_sizecache                int32                `json:"-"`
}

func (m *ReachForecast) Reset()         { *m = ReachForecast{} }
func (m *ReachForecast) String() string { return proto.CompactTextString(m) }
func (*ReachForecast) ProtoMessage()    {}
func (*ReachForecast) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{17}
}

func (m *ReachForecast) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReachForecast.Unmarshal(m, b)
}
func (m *ReachForecast) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReachForecast.Marshal(b, m, deterministic)
}
func (m *ReachForecast) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReachForecast.Merge(m, src)
}
func (m *ReachForecast) XXX_Size() int {
	return xxx_messageInfo_ReachForecast.Size(m)
}
func (m *ReachForecast) XXX_DiscardUnknown() {
	xxx_messageInfo_ReachForecast.DiscardUnknown(m)
}

var xxx_messageInfo_ReachForecast proto.InternalMessageInfo

func (m *ReachForecast) GetCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CostMicros
	}
	return nil
}

func (m *ReachForecast) GetForecast() *Forecast {
	if m != nil {
		return m.Forecast
	}
	return nil
}

func (m *ReachForecast) GetForecastedProductAllocations() []*ProductAllocation {
	if m != nil {
		return m.ForecastedProductAllocations
	}
	return nil
}

// Forecasted traffic metrics for the planned products and targeting.
type Forecast struct {
	// Number of unique people reached at least
	// GenerateReachForecastRequest.min_effective_frequency times that exactly
	// matches the Targeting.
	OnTargetReach *wrappers.Int64Value `protobuf:"bytes,1,opt,name=on_target_reach,json=onTargetReach,proto3" json:"on_target_reach,omitempty"`
	// Total number of unique people reached at least
	// GenerateReachForecastRequest.min_effective_frequency times. This includes
	// people that may fall outside the specified Targeting.
	TotalReach *wrappers.Int64Value `protobuf:"bytes,2,opt,name=total_reach,json=totalReach,proto3" json:"total_reach,omitempty"`
	// Number of ad impressions that exactly matches the Targeting.
	OnTargetImpressions *wrappers.Int64Value `protobuf:"bytes,3,opt,name=on_target_impressions,json=onTargetImpressions,proto3" json:"on_target_impressions,omitempty"`
	// Total number of ad impressions. This includes impressions that may fall
	// outside the specified Targeting, due to insufficent information on
	// signed-in users.
	TotalImpressions     *wrappers.Int64Value `protobuf:"bytes,4,opt,name=total_impressions,json=totalImpressions,proto3" json:"total_impressions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Forecast) Reset()         { *m = Forecast{} }
func (m *Forecast) String() string { return proto.CompactTextString(m) }
func (*Forecast) ProtoMessage()    {}
func (*Forecast) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{18}
}

func (m *Forecast) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Forecast.Unmarshal(m, b)
}
func (m *Forecast) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Forecast.Marshal(b, m, deterministic)
}
func (m *Forecast) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Forecast.Merge(m, src)
}
func (m *Forecast) XXX_Size() int {
	return xxx_messageInfo_Forecast.Size(m)
}
func (m *Forecast) XXX_DiscardUnknown() {
	xxx_messageInfo_Forecast.DiscardUnknown(m)
}

var xxx_messageInfo_Forecast proto.InternalMessageInfo

func (m *Forecast) GetOnTargetReach() *wrappers.Int64Value {
	if m != nil {
		return m.OnTargetReach
	}
	return nil
}

func (m *Forecast) GetTotalReach() *wrappers.Int64Value {
	if m != nil {
		return m.TotalReach
	}
	return nil
}

func (m *Forecast) GetOnTargetImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.OnTargetImpressions
	}
	return nil
}

func (m *Forecast) GetTotalImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.TotalImpressions
	}
	return nil
}

// Audience metrics for the planned products.
// These metrics consider the following targeting dimensions:
//
// - Location
// - PlannableAgeRange
// - Gender
type OnTargetAudienceMetrics struct {
	// Reference audience size matching the considered targeting for YouTube.
	YoutubeAudienceSize *wrappers.Int64Value `protobuf:"bytes,1,opt,name=youtube_audience_size,json=youtubeAudienceSize,proto3" json:"youtube_audience_size,omitempty"`
	// Reference audience size matching the considered targeting for Census.
	CensusAudienceSize   *wrappers.Int64Value `protobuf:"bytes,2,opt,name=census_audience_size,json=censusAudienceSize,proto3" json:"census_audience_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *OnTargetAudienceMetrics) Reset()         { *m = OnTargetAudienceMetrics{} }
func (m *OnTargetAudienceMetrics) String() string { return proto.CompactTextString(m) }
func (*OnTargetAudienceMetrics) ProtoMessage()    {}
func (*OnTargetAudienceMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{19}
}

func (m *OnTargetAudienceMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OnTargetAudienceMetrics.Unmarshal(m, b)
}
func (m *OnTargetAudienceMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OnTargetAudienceMetrics.Marshal(b, m, deterministic)
}
func (m *OnTargetAudienceMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OnTargetAudienceMetrics.Merge(m, src)
}
func (m *OnTargetAudienceMetrics) XXX_Size() int {
	return xxx_messageInfo_OnTargetAudienceMetrics.Size(m)
}
func (m *OnTargetAudienceMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_OnTargetAudienceMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_OnTargetAudienceMetrics proto.InternalMessageInfo

func (m *OnTargetAudienceMetrics) GetYoutubeAudienceSize() *wrappers.Int64Value {
	if m != nil {
		return m.YoutubeAudienceSize
	}
	return nil
}

func (m *OnTargetAudienceMetrics) GetCensusAudienceSize() *wrappers.Int64Value {
	if m != nil {
		return m.CensusAudienceSize
	}
	return nil
}

func init() {
	proto.RegisterType((*ListPlannableLocationsRequest)(nil), "google.ads.googleads.v2.services.ListPlannableLocationsRequest")
	proto.RegisterType((*ListPlannableLocationsResponse)(nil), "google.ads.googleads.v2.services.ListPlannableLocationsResponse")
	proto.RegisterType((*PlannableLocation)(nil), "google.ads.googleads.v2.services.PlannableLocation")
	proto.RegisterType((*ListPlannableProductsRequest)(nil), "google.ads.googleads.v2.services.ListPlannableProductsRequest")
	proto.RegisterType((*ListPlannableProductsResponse)(nil), "google.ads.googleads.v2.services.ListPlannableProductsResponse")
	proto.RegisterType((*ProductMetadata)(nil), "google.ads.googleads.v2.services.ProductMetadata")
	proto.RegisterType((*PlannableTargeting)(nil), "google.ads.googleads.v2.services.PlannableTargeting")
	proto.RegisterType((*GenerateProductMixIdeasRequest)(nil), "google.ads.googleads.v2.services.GenerateProductMixIdeasRequest")
	proto.RegisterType((*Preferences)(nil), "google.ads.googleads.v2.services.Preferences")
	proto.RegisterType((*GenerateProductMixIdeasResponse)(nil), "google.ads.googleads.v2.services.GenerateProductMixIdeasResponse")
	proto.RegisterType((*ProductAllocation)(nil), "google.ads.googleads.v2.services.ProductAllocation")
	proto.RegisterType((*GenerateReachForecastRequest)(nil), "google.ads.googleads.v2.services.GenerateReachForecastRequest")
	proto.RegisterType((*Targeting)(nil), "google.ads.googleads.v2.services.Targeting")
	proto.RegisterType((*CampaignDuration)(nil), "google.ads.googleads.v2.services.CampaignDuration")
	proto.RegisterType((*PlannedProduct)(nil), "google.ads.googleads.v2.services.PlannedProduct")
	proto.RegisterType((*GenerateReachForecastResponse)(nil), "google.ads.googleads.v2.services.GenerateReachForecastResponse")
	proto.RegisterType((*ReachCurve)(nil), "google.ads.googleads.v2.services.ReachCurve")
	proto.RegisterType((*ReachForecast)(nil), "google.ads.googleads.v2.services.ReachForecast")
	proto.RegisterType((*Forecast)(nil), "google.ads.googleads.v2.services.Forecast")
	proto.RegisterType((*OnTargetAudienceMetrics)(nil), "google.ads.googleads.v2.services.OnTargetAudienceMetrics")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/services/reach_plan_service.proto", fileDescriptor_c868579e438b97a9)
}

var fileDescriptor_c868579e438b97a9 = []byte{
	// 1645 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0xcb, 0x6f, 0x24, 0x47,
	0x19, 0x57, 0xb7, 0x97, 0xcd, 0xfa, 0xf3, 0xae, 0x1f, 0xb5, 0xeb, 0x78, 0x98, 0x38, 0xde, 0x55,
	0x6b, 0x91, 0x22, 0x93, 0xcc, 0x84, 0xd9, 0x80, 0x92, 0x81, 0x24, 0x3b, 0x6b, 0xaf, 0x9d, 0x91,
	0xd6, 0x5a, 0xab, 0x8d, 0xcc, 0xcb, 0x52, 0xab, 0xdc, 0x5d, 0x6e, 0x97, 0x32, 0x53, 0xd5, 0x54,
	0x55, 0x3b, 0x38, 0x28, 0x17, 0x24, 0xe0, 0x84, 0x84, 0xc4, 0x7f, 0xc0, 0x01, 0x01, 0x17, 0xce,
	0x48, 0x88, 0x03, 0xc7, 0x15, 0xe2, 0xc2, 0x85, 0x23, 0x07, 0x84, 0x04, 0x57, 0xae, 0x1c, 0x50,
	0xd7, 0xa3, 0x67, 0x3c, 0xe3, 0x99, 0x69, 0x9b, 0x45, 0xe2, 0x56, 0x53, 0xf5, 0xfd, 0x7e, 0xf5,
	0xbd, 0xbf, 0x9a, 0x86, 0xf7, 0x52, 0xce, 0xd3, 0x1e, 0x69, 0xe2, 0x44, 0x36, 0xcd, 0xb2, 0x58,
	0x9d, 0xb5, 0x9a, 0x92, 0x88, 0x33, 0x1a, 0x13, 0xd9, 0x14, 0x04, 0xc7, 0xa7, 0x51, 0xd6, 0xc3,
	0x2c, 0xb2, 0x7b, 0x8d, 0x4c, 0x70, 0xc5, 0xd1, 0x03, 0x23, 0xdf, 0xc0, 0x89, 0x6c, 0x94, 0xd0,
	0xc6, 0x59, 0xab, 0xe1, 0xa0, 0xf5, 0xb7, 0x26, 0x91, 0xc7, 0xbc, 0xdf, 0xe7, 0xac, 0x19, 0x0b,
	0xaa, 0x88, 0xa0, 0xd8, 0x10, 0xd6, 0xdf, 0x9d, 0x24, 0x4e, 0x58, 0xde, 0xbf, 0xa0, 0x08, 0x4e,
	0xa2, 0x1e, 0x61, 0xa9, 0x3a, 0xbd, 0x3a, 0x32, 0x25, 0x91, 0xc0, 0x2c, 0xb5, 0x46, 0xd4, 0xd7,
	0x1d, 0x32, 0xa3, 0x4d, 0xcc, 0x18, 0x57, 0x58, 0x51, 0xce, 0xa4, 0x3d, 0xdd, 0xb0, 0xa7, 0xfa,
	0xd7, 0x71, 0x7e, 0xd2, 0xfc, 0x44, 0xe0, 0x2c, 0x23, 0xc2, 0x9d, 0xaf, 0x0d, 0xa1, 0xe3, 0x1e,
	0x25, 0x4c, 0x99, 0x83, 0xe0, 0x3e, 0xbc, 0xfe, 0x8c, 0x4a, 0xb5, 0xdf, 0xc3, 0x8c, 0xe1, 0xe3,
	0x1e, 0x79, 0xc6, 0x63, 0x43, 0x1c, 0x92, 0xef, 0xe6, 0x44, 0xaa, 0xe0, 0x47, 0x1e, 0x6c, 0x4c,
	0x92, 0x90, 0x19, 0x67, 0x92, 0xa0, 0x04, 0xee, 0x66, 0xee, 0x34, 0xea, 0xb9, 0xe3, 0x9a, 0xf7,
	0x60, 0xee, 0x8d, 0x85, 0xd6, 0xa3, 0xc6, 0x2c, 0xef, 0x37, 0xc6, 0xa8, 0x43, 0x94, 0x8d, 0xdd,
	0x16, 0xfc, 0xce, 0x83, 0x95, 0x31, 0x49, 0xf4, 0x26, 0xf8, 0x34, 0xa9, 0x79, 0x0f, 0xbc, 0x37,
	0x16, 0x5a, 0xeb, 0xee, 0x2a, 0xe7, 0x85, 0xc6, 0x81, 0x12, 0x94, 0xa5, 0x87, 0xb8, 0x97, 0x93,
	0xd0, 0xa7, 0x09, 0x7a, 0x1b, 0x6e, 0x30, 0xdc, 0x27, 0x35, 0xbf, 0x82, 0xbc, 0x96, 0x44, 0xbb,
	0xb0, 0x92, 0x61, 0x41, 0x98, 0x8a, 0x62, 0x9e, 0x33, 0x25, 0xce, 0x23, 0x9a, 0xd4, 0xe6, 0x34,
	0xfc, 0xb5, 0x31, 0x78, 0x97, 0xa9, 0xaf, 0xbc, 0x63, 0xd0, 0x4b, 0x06, 0xb5, 0x65, 0x40, 0xdd,
	0x24, 0xc8, 0x60, 0xfd, 0x82, 0x1b, 0xf7, 0x05, 0x4f, 0xf2, 0x58, 0x39, 0x3f, 0xa3, 0x7d, 0x58,
	0x1d, 0x77, 0x62, 0x54, 0xd1, 0xb6, 0xbb, 0x63, 0xfe, 0xea, 0x26, 0xc1, 0x67, 0x23, 0xa1, 0x1d,
	0xdc, 0x68, 0xe3, 0x76, 0x04, 0xcb, 0x99, 0xd9, 0x8b, 0xfa, 0x44, 0xe1, 0x04, 0x2b, 0x6c, 0x83,
	0xf6, 0xa5, 0x0a, 0x41, 0x33, 0xc8, 0x3d, 0x0b, 0x0c, 0x97, 0xb2, 0x8b, 0x1b, 0xc1, 0x1f, 0x3d,
	0x58, 0x1a, 0x11, 0x42, 0x21, 0xbc, 0x3a, 0x30, 0xd2, 0xdd, 0x1d, 0xf3, 0x84, 0x54, 0xb2, 0xf2,
	0x5e, 0x36, 0x62, 0xca, 0x16, 0x4f, 0x08, 0x22, 0xc3, 0xd9, 0xa7, 0xb0, 0x48, 0x89, 0xa2, 0x2c,
	0xb5, 0x21, 0x7e, 0xe7, 0x0a, 0xd9, 0xf7, 0x75, 0x87, 0x1d, 0x4a, 0xbf, 0x72, 0x2f, 0xf8, 0xb1,
	0x0f, 0x68, 0x5c, 0x14, 0x11, 0x80, 0xb2, 0x52, 0x4d, 0xca, 0x2f, 0xb6, 0x76, 0x26, 0x5e, 0xaa,
	0xab, 0xbc, 0x11, 0x16, 0x55, 0x5e, 0x70, 0x75, 0x52, 0x12, 0x16, 0xc0, 0xa7, 0x2c, 0xef, 0x8f,
	0xef, 0x86, 0xf3, 0xd8, 0xae, 0x24, 0xda, 0x86, 0x57, 0x52, 0xc2, 0x12, 0x22, 0x64, 0xcd, 0xd7,
	0x11, 0xda, 0x9c, 0x78, 0x87, 0x69, 0x59, 0x8d, 0x5d, 0x2d, 0xde, 0x65, 0x27, 0x3c, 0x74, 0xd0,
	0x82, 0x25, 0x21, 0xda, 0xea, 0xda, 0x5c, 0x35, 0x96, 0x6d, 0x2d, 0x6e, 0x58, 0x2c, 0x34, 0xf8,
	0x87, 0x0f, 0x1b, 0xbb, 0x84, 0x11, 0x81, 0x95, 0x0b, 0xc4, 0x1e, 0xfd, 0x5e, 0x37, 0x21, 0xb8,
	0x4c, 0xe6, 0xfb, 0xb0, 0x10, 0xe7, 0x52, 0xf1, 0x3e, 0x11, 0x2e, 0x85, 0xe7, 0x43, 0x70, 0x5b,
	0xdd, 0x64, 0x72, 0xb6, 0xfb, 0xd7, 0xcc, 0x76, 0xd4, 0x81, 0x3b, 0x71, 0x2e, 0x04, 0x61, 0xf1,
	0xb9, 0xc9, 0xa8, 0xb9, 0x0a, 0x4c, 0xb7, 0x1d, 0x44, 0x67, 0xd2, 0x63, 0xb8, 0x73, 0x9c, 0x27,
	0x29, 0x51, 0x51, 0x9f, 0xc6, 0x82, 0xcb, 0xda, 0x8d, 0xd9, 0x75, 0x7e, 0xdb, 0x20, 0xf6, 0x34,
	0x00, 0x3d, 0x87, 0x85, 0x4c, 0x90, 0x13, 0x52, 0x70, 0x12, 0x59, 0xfb, 0x9c, 0xc6, 0xbf, 0x55,
	0xa5, 0x98, 0x4a, 0x50, 0x38, 0xcc, 0x10, 0xfc, 0x64, 0x0e, 0x16, 0x86, 0x0e, 0xd1, 0xfb, 0x70,
	0x9b, 0xca, 0x48, 0x7e, 0x4c, 0xb3, 0xac, 0xb0, 0xdf, 0x96, 0x4d, 0x7d, 0x4c, 0xc3, 0x27, 0x9c,
	0xf7, 0x8c, 0x82, 0x0b, 0x54, 0x1e, 0x38, 0x71, 0xb4, 0x03, 0x2b, 0x52, 0x61, 0xa1, 0x64, 0xf4,
	0x09, 0x55, 0xa7, 0x91, 0xe4, 0x39, 0x73, 0x2e, 0x9f, 0xc6, 0xb1, 0x64, 0x40, 0xdf, 0xa0, 0xea,
	0xf4, 0xa0, 0x80, 0xa0, 0x18, 0xe6, 0xcb, 0xc9, 0xa6, 0x1d, 0x7d, 0x95, 0xa4, 0x4f, 0x9e, 0x69,
	0xdc, 0x48, 0xd2, 0xdb, 0xdd, 0xf0, 0x16, 0xb6, 0x2b, 0xb4, 0x0d, 0xcb, 0x8a, 0x67, 0x51, 0xcc,
	0x99, 0x2a, 0xfa, 0x2f, 0x67, 0xbd, 0x73, 0x1b, 0x91, 0x69, 0xba, 0x2e, 0x2a, 0x9e, 0x6d, 0x19,
	0xc8, 0x73, 0xd6, 0x3b, 0x47, 0xcf, 0xe0, 0xde, 0x29, 0x96, 0x51, 0x9a, 0x63, 0x81, 0x99, 0x22,
	0x24, 0x89, 0x32, 0x41, 0x63, 0x62, 0x63, 0x33, 0x8d, 0x09, 0x9d, 0x62, 0xb9, 0x5b, 0xc2, 0xf6,
	0x0b, 0x54, 0xf0, 0x43, 0x0f, 0xee, 0x4f, 0xcc, 0x7d, 0xdb, 0x56, 0x8f, 0x01, 0xb9, 0xd6, 0x86,
	0x7b, 0x2e, 0xb7, 0xaf, 0x30, 0x0d, 0x0d, 0xb6, 0x53, 0x42, 0xc3, 0x95, 0x6c, 0x74, 0x2b, 0xf8,
	0x55, 0x31, 0x0c, 0x47, 0x77, 0xff, 0x27, 0xed, 0x75, 0xac, 0x28, 0xfc, 0x2b, 0x16, 0x45, 0xf0,
	0x9b, 0x1b, 0xb0, 0xee, 0x7c, 0xa6, 0xe3, 0xbd, 0xc3, 0x05, 0x89, 0xb1, 0x54, 0x95, 0xbb, 0xc5,
	0x58, 0x6d, 0xfb, 0x57, 0xae, 0xed, 0x08, 0x56, 0x62, 0xdc, 0xcf, 0x30, 0x4d, 0x59, 0x94, 0xe4,
	0xc2, 0xc4, 0xc4, 0xb4, 0x88, 0xd6, 0xec, 0x98, 0x6c, 0x59, 0xe8, 0xb6, 0x45, 0x86, 0xcb, 0xf1,
	0xc8, 0x0e, 0xda, 0x83, 0x7b, 0x31, 0xe7, 0x1f, 0x53, 0x12, 0x9d, 0x88, 0xc2, 0x2e, 0xad, 0x2b,
	0xce, 0xa6, 0xf5, 0x90, 0x47, 0x2d, 0x9b, 0x68, 0x06, 0xb8, 0xe3, 0x70, 0x5b, 0x38, 0x43, 0x07,
	0xb0, 0xd6, 0xa7, 0x2c, 0x22, 0x27, 0x27, 0x24, 0x56, 0xf4, 0x6c, 0x88, 0xd5, 0x66, 0xee, 0x54,
	0xc6, 0xd5, 0x3e, 0x65, 0x4f, 0x1d, 0xb4, 0xe4, 0x45, 0x5d, 0x98, 0x1f, 0x0c, 0xc8, 0x9b, 0x9a,
	0xe6, 0x8b, 0xb3, 0x8d, 0x1f, 0xcc, 0xc5, 0x01, 0x1a, 0x7d, 0x07, 0x96, 0x75, 0xba, 0xe8, 0x7a,
	0x32, 0xef, 0x8a, 0xda, 0x2b, 0x3a, 0xc5, 0xdf, 0xae, 0x38, 0x72, 0x8b, 0x92, 0xd2, 0xc0, 0x70,
	0x29, 0xbb, 0xf0, 0x5b, 0x06, 0x7f, 0xf2, 0x61, 0x7e, 0x30, 0x62, 0x5f, 0xfa, 0xcb, 0x48, 0xb7,
	0x2f, 0x37, 0xb4, 0x75, 0x2e, 0xbd, 0xbc, 0x99, 0x7d, 0xcb, 0xcd, 0xec, 0xe1, 0x91, 0x3d, 0xf7,
	0x52, 0x46, 0xf6, 0x8d, 0xeb, 0x8f, 0xec, 0x6f, 0xc1, 0xf2, 0x68, 0x0a, 0xa3, 0xa7, 0xb0, 0xec,
	0x0a, 0x21, 0xa2, 0x2c, 0x4a, 0xf0, 0xb9, 0xb4, 0x1e, 0x9d, 0x9a, 0x5a, 0x8b, 0x0e, 0xd4, 0x65,
	0xdb, 0xf8, 0x5c, 0x06, 0xbf, 0xf0, 0x60, 0xf1, 0x62, 0x3c, 0xff, 0x4f, 0xdb, 0xd0, 0xdf, 0x3d,
	0x78, 0x7d, 0x42, 0x1b, 0xb2, 0x8d, 0xfb, 0x0c, 0xea, 0x9c, 0xd9, 0x27, 0x64, 0x84, 0xf3, 0x84,
	0x16, 0x33, 0xb7, 0x78, 0x1a, 0x0b, 0x1a, 0x3b, 0xdf, 0xbc, 0x37, 0x3b, 0xbb, 0x9f, 0x33, 0x93,
	0xbb, 0x1d, 0xcb, 0xb0, 0x67, 0x08, 0xc2, 0x35, 0x7e, 0xf9, 0x01, 0xda, 0x83, 0x05, 0xf3, 0xc7,
	0x2f, 0xce, 0xc5, 0x99, 0x6b, 0x6e, 0x6f, 0xce, 0xbe, 0x48, 0x5b, 0xb1, 0x55, 0x60, 0x42, 0x10,
	0xe5, 0x3a, 0x38, 0x01, 0x18, 0x9c, 0xa0, 0x6f, 0xc2, 0x92, 0x21, 0x3f, 0xb1, 0xe6, 0xba, 0x3f,
	0x66, 0xcd, 0x8a, 0x17, 0x94, 0x6e, 0x5a, 0x14, 0xc3, 0x3f, 0x65, 0xf0, 0x53, 0x1f, 0xee, 0x5c,
	0x90, 0x40, 0x5f, 0x83, 0x85, 0x98, 0xcb, 0x32, 0x44, 0xde, 0xec, 0x10, 0x41, 0x21, 0x6f, 0x1f,
	0x4f, 0x3b, 0x70, 0xcb, 0xe9, 0x68, 0x7d, 0xb0, 0x39, 0x5b, 0xc5, 0x52, 0xbb, 0x12, 0x8b, 0xce,
	0x61, 0xc3, 0xad, 0x07, 0xdd, 0x69, 0x68, 0x14, 0xbb, 0x7a, 0xbc, 0xd6, 0x2c, 0x5e, 0x1f, 0x50,
	0x8f, 0x1d, 0xca, 0xe0, 0x97, 0x3e, 0xdc, 0x2a, 0xbd, 0xb1, 0x05, 0x4b, 0x83, 0x74, 0xd2, 0xbe,
	0xab, 0xe2, 0x91, 0x3b, 0x2e, 0x4b, 0xb4, 0x6b, 0x0b, 0x97, 0x2a, 0xae, 0x70, 0xcf, 0x12, 0x54,
	0xc8, 0x7a, 0xd0, 0xf2, 0x06, 0xfd, 0x1c, 0x56, 0x07, 0x2a, 0xd0, 0x7e, 0x26, 0x88, 0x94, 0xd6,
	0x03, 0x33, 0x79, 0xee, 0x3a, 0x45, 0xba, 0x03, 0x1c, 0xfa, 0x08, 0x56, 0x8c, 0x3a, 0xc3, 0x64,
	0x15, 0x9e, 0xc9, 0xcb, 0x1a, 0x35, 0xc4, 0x14, 0xfc, 0xd6, 0x83, 0xb5, 0x09, 0x95, 0x52, 0xa8,
	0x7d, 0xce, 0x73, 0x95, 0x1f, 0x93, 0x41, 0x19, 0x4a, 0xfa, 0x29, 0xa9, 0xe2, 0xbf, 0xbb, 0x16,
	0xe9, 0x38, 0x0f, 0xe8, 0xa7, 0x44, 0x0f, 0x67, 0xc2, 0x64, 0x2e, 0x47, 0xf8, 0x2a, 0xb8, 0x13,
	0x19, 0xe0, 0x30, 0x5d, 0xeb, 0x5f, 0x37, 0x61, 0xb9, 0x6c, 0xfd, 0x07, 0x26, 0x59, 0xd0, 0x1f,
	0x3c, 0x78, 0xf5, 0xf2, 0x0f, 0x25, 0xe8, 0xc3, 0xd9, 0x99, 0x36, 0xf5, 0x23, 0x4c, 0xfd, 0xf1,
	0xf5, 0x09, 0x4c, 0x6f, 0x0b, 0xbe, 0xf0, 0x83, 0x3f, 0xff, 0xed, 0x67, 0xfe, 0xfd, 0xa0, 0xde,
	0x3c, 0x6b, 0xb5, 0x7b, 0x97, 0xca, 0xb6, 0xbd, 0x4d, 0xf4, 0x7b, 0x0f, 0x56, 0x2f, 0xfd, 0x68,
	0x80, 0x3e, 0xb8, 0xa2, 0x0a, 0x23, 0xdf, 0x37, 0xea, 0x1f, 0x5e, 0x1b, 0x6f, 0x2d, 0x78, 0xa8,
	0x2d, 0xd8, 0x08, 0x3e, 0x3f, 0x66, 0x81, 0x13, 0x2d, 0x0c, 0xf8, 0xab, 0x07, 0x6b, 0x13, 0x1e,
	0xe8, 0xa8, 0x82, 0x17, 0xa7, 0xff, 0xaf, 0xad, 0x77, 0xfe, 0x0b, 0x06, 0x6b, 0xc6, 0x63, 0x6d,
	0x46, 0x3b, 0xf8, 0xb2, 0xfe, 0xbc, 0x68, 0xdf, 0xb8, 0xb2, 0xf9, 0xfd, 0xa1, 0x17, 0xf0, 0xfb,
	0x9b, 0x9f, 0xb5, 0xd3, 0xcb, 0x69, 0x0a, 0x13, 0xff, 0xe2, 0xc1, 0xea, 0xa5, 0x83, 0xac, 0x4a,
	0x8c, 0xa6, 0x3d, 0xc4, 0xab, 0xc4, 0x68, 0xea, 0x04, 0x0d, 0x3e, 0xd0, 0xc6, 0xbd, 0x1b, 0x3c,
	0xaa, 0x66, 0xdc, 0x05, 0x92, 0xb6, 0xb7, 0x59, 0x7f, 0xed, 0x45, 0xa7, 0x36, 0xb8, 0xd7, 0xae,
	0x32, 0x2a, 0x8b, 0xb7, 0xcd, 0x93, 0x7f, 0x7b, 0xf0, 0x30, 0xe6, 0xfd, 0x99, 0x3a, 0x3e, 0x59,
	0x1d, 0xad, 0xcd, 0xfd, 0xa2, 0xae, 0xf7, 0xbd, 0x6f, 0x7f, 0x64, 0xa1, 0x29, 0xef, 0x61, 0x96,
	0x36, 0xb8, 0x48, 0x9b, 0x29, 0x61, 0xba, 0xea, 0x9b, 0x83, 0xcb, 0x26, 0x7f, 0x62, 0xfe, 0xaa,
	0x5b, 0xfc, 0xdc, 0x9f, 0xdb, 0xed, 0x74, 0x7e, 0xed, 0x3f, 0xd8, 0x35, 0x84, 0x9d, 0x44, 0x36,
	0xcc, 0xb2, 0x58, 0x1d, 0xb6, 0x1a, 0xf6, 0x62, 0xf9, 0xc2, 0x89, 0x1c, 0x75, 0x12, 0x79, 0x54,
	0x8a, 0x1c, 0x1d, 0xb6, 0x8e, 0x9c, 0xc8, 0x3f, 0xfd, 0x87, 0x66, 0xbf, 0xdd, 0xee, 0x24, 0xb2,
	0xdd, 0x2e, 0x85, 0xda, 0xed, 0xc3, 0x56, 0xbb, 0xed, 0xc4, 0x8e, 0x6f, 0x6a, 0x3d, 0x1f, 0xfd,
	0x27, 0x00, 0x00, 0xff, 0xff, 0xf4, 0x1a, 0x77, 0x67, 0x09, 0x17, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ReachPlanServiceClient is the client API for ReachPlanService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ReachPlanServiceClient interface {
	// Returns the list of plannable locations (for example, countries & DMAs).
	ListPlannableLocations(ctx context.Context, in *ListPlannableLocationsRequest, opts ...grpc.CallOption) (*ListPlannableLocationsResponse, error)
	// Returns the list of per-location plannable YouTube ad formats with allowed
	// targeting.
	ListPlannableProducts(ctx context.Context, in *ListPlannableProductsRequest, opts ...grpc.CallOption) (*ListPlannableProductsResponse, error)
	// Generates a product mix ideas given a set of preferences. This method
	// helps the advertiser to obtain a good mix of ad formats and budget
	// allocations based on its preferences.
	GenerateProductMixIdeas(ctx context.Context, in *GenerateProductMixIdeasRequest, opts ...grpc.CallOption) (*GenerateProductMixIdeasResponse, error)
	// Generates a reach forecast for a given targeting / product mix.
	GenerateReachForecast(ctx context.Context, in *GenerateReachForecastRequest, opts ...grpc.CallOption) (*GenerateReachForecastResponse, error)
}

type reachPlanServiceClient struct {
	cc *grpc.ClientConn
}

func NewReachPlanServiceClient(cc *grpc.ClientConn) ReachPlanServiceClient {
	return &reachPlanServiceClient{cc}
}

func (c *reachPlanServiceClient) ListPlannableLocations(ctx context.Context, in *ListPlannableLocationsRequest, opts ...grpc.CallOption) (*ListPlannableLocationsResponse, error) {
	out := new(ListPlannableLocationsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.ReachPlanService/ListPlannableLocations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachPlanServiceClient) ListPlannableProducts(ctx context.Context, in *ListPlannableProductsRequest, opts ...grpc.CallOption) (*ListPlannableProductsResponse, error) {
	out := new(ListPlannableProductsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.ReachPlanService/ListPlannableProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachPlanServiceClient) GenerateProductMixIdeas(ctx context.Context, in *GenerateProductMixIdeasRequest, opts ...grpc.CallOption) (*GenerateProductMixIdeasResponse, error) {
	out := new(GenerateProductMixIdeasResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.ReachPlanService/GenerateProductMixIdeas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachPlanServiceClient) GenerateReachForecast(ctx context.Context, in *GenerateReachForecastRequest, opts ...grpc.CallOption) (*GenerateReachForecastResponse, error) {
	out := new(GenerateReachForecastResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.ReachPlanService/GenerateReachForecast", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReachPlanServiceServer is the server API for ReachPlanService service.
type ReachPlanServiceServer interface {
	// Returns the list of plannable locations (for example, countries & DMAs).
	ListPlannableLocations(context.Context, *ListPlannableLocationsRequest) (*ListPlannableLocationsResponse, error)
	// Returns the list of per-location plannable YouTube ad formats with allowed
	// targeting.
	ListPlannableProducts(context.Context, *ListPlannableProductsRequest) (*ListPlannableProductsResponse, error)
	// Generates a product mix ideas given a set of preferences. This method
	// helps the advertiser to obtain a good mix of ad formats and budget
	// allocations based on its preferences.
	GenerateProductMixIdeas(context.Context, *GenerateProductMixIdeasRequest) (*GenerateProductMixIdeasResponse, error)
	// Generates a reach forecast for a given targeting / product mix.
	GenerateReachForecast(context.Context, *GenerateReachForecastRequest) (*GenerateReachForecastResponse, error)
}

// UnimplementedReachPlanServiceServer can be embedded to have forward compatible implementations.
type UnimplementedReachPlanServiceServer struct {
}

func (*UnimplementedReachPlanServiceServer) ListPlannableLocations(ctx context.Context, req *ListPlannableLocationsRequest) (*ListPlannableLocationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPlannableLocations not implemented")
}
func (*UnimplementedReachPlanServiceServer) ListPlannableProducts(ctx context.Context, req *ListPlannableProductsRequest) (*ListPlannableProductsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPlannableProducts not implemented")
}
func (*UnimplementedReachPlanServiceServer) GenerateProductMixIdeas(ctx context.Context, req *GenerateProductMixIdeasRequest) (*GenerateProductMixIdeasResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateProductMixIdeas not implemented")
}
func (*UnimplementedReachPlanServiceServer) GenerateReachForecast(ctx context.Context, req *GenerateReachForecastRequest) (*GenerateReachForecastResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateReachForecast not implemented")
}

func RegisterReachPlanServiceServer(s *grpc.Server, srv ReachPlanServiceServer) {
	s.RegisterService(&_ReachPlanService_serviceDesc, srv)
}

func _ReachPlanService_ListPlannableLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlannableLocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).ListPlannableLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.ReachPlanService/ListPlannableLocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).ListPlannableLocations(ctx, req.(*ListPlannableLocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachPlanService_ListPlannableProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlannableProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).ListPlannableProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.ReachPlanService/ListPlannableProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).ListPlannableProducts(ctx, req.(*ListPlannableProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachPlanService_GenerateProductMixIdeas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateProductMixIdeasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).GenerateProductMixIdeas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.ReachPlanService/GenerateProductMixIdeas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).GenerateProductMixIdeas(ctx, req.(*GenerateProductMixIdeasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachPlanService_GenerateReachForecast_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateReachForecastRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).GenerateReachForecast(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.ReachPlanService/GenerateReachForecast",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).GenerateReachForecast(ctx, req.(*GenerateReachForecastRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReachPlanService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v2.services.ReachPlanService",
	HandlerType: (*ReachPlanServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPlannableLocations",
			Handler:    _ReachPlanService_ListPlannableLocations_Handler,
		},
		{
			MethodName: "ListPlannableProducts",
			Handler:    _ReachPlanService_ListPlannableProducts_Handler,
		},
		{
			MethodName: "GenerateProductMixIdeas",
			Handler:    _ReachPlanService_GenerateProductMixIdeas_Handler,
		},
		{
			MethodName: "GenerateReachForecast",
			Handler:    _ReachPlanService_GenerateReachForecast_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v2/services/reach_plan_service.proto",
}
