// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/storagetransfer/v1/transfer_types.proto
// DO NOT EDIT!

package google_storagetransfer_v1 // import "google.golang.org/genproto/googleapis/storagetransfer/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf3 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf4 "github.com/golang/protobuf/ptypes/timestamp"
import google_rpc "google.golang.org/genproto/googleapis/rpc/code"
import google_type "google.golang.org/genproto/googleapis/type/date"
import google_type1 "google.golang.org/genproto/googleapis/type/timeofday"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The status of the transfer job.
type TransferJob_Status int32

const (
	// Zero is an illegal value.
	TransferJob_STATUS_UNSPECIFIED TransferJob_Status = 0
	// New transfers will be performed based on the schedule.
	TransferJob_ENABLED TransferJob_Status = 1
	// New transfers will not be scheduled.
	TransferJob_DISABLED TransferJob_Status = 2
	// This is a soft delete state. After a transfer job is set to this
	// state, the job and all the transfer executions are subject to
	// garbage collection.
	TransferJob_DELETED TransferJob_Status = 3
)

var TransferJob_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "ENABLED",
	2: "DISABLED",
	3: "DELETED",
}
var TransferJob_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"ENABLED":            1,
	"DISABLED":           2,
	"DELETED":            3,
}

func (x TransferJob_Status) String() string {
	return proto.EnumName(TransferJob_Status_name, int32(x))
}
func (TransferJob_Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{9, 0} }

// The status of a TransferOperation.
type TransferOperation_Status int32

const (
	// Zero is an illegal value.
	TransferOperation_STATUS_UNSPECIFIED TransferOperation_Status = 0
	// In progress.
	TransferOperation_IN_PROGRESS TransferOperation_Status = 1
	// Paused.
	TransferOperation_PAUSED TransferOperation_Status = 2
	// Completed successfully.
	TransferOperation_SUCCESS TransferOperation_Status = 3
	// Terminated due to an unrecoverable failure.
	TransferOperation_FAILED TransferOperation_Status = 4
	// Aborted by the user.
	TransferOperation_ABORTED TransferOperation_Status = 5
)

var TransferOperation_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "IN_PROGRESS",
	2: "PAUSED",
	3: "SUCCESS",
	4: "FAILED",
	5: "ABORTED",
}
var TransferOperation_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"IN_PROGRESS":        1,
	"PAUSED":             2,
	"SUCCESS":            3,
	"FAILED":             4,
	"ABORTED":            5,
}

func (x TransferOperation_Status) String() string {
	return proto.EnumName(TransferOperation_Status_name, int32(x))
}
func (TransferOperation_Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{13, 0} }

// Google service account
type GoogleServiceAccount struct {
	// Required.
	AccountEmail string `protobuf:"bytes,1,opt,name=account_email,json=accountEmail" json:"account_email,omitempty"`
}

func (m *GoogleServiceAccount) Reset()                    { *m = GoogleServiceAccount{} }
func (m *GoogleServiceAccount) String() string            { return proto.CompactTextString(m) }
func (*GoogleServiceAccount) ProtoMessage()               {}
func (*GoogleServiceAccount) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

// AWS access key (see
// [AWS Security Credentials](http://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html)).
type AwsAccessKey struct {
	// AWS access key ID.
	// Required.
	AccessKeyId string `protobuf:"bytes,1,opt,name=access_key_id,json=accessKeyId" json:"access_key_id,omitempty"`
	// AWS secret access key. This field is not returned in RPC responses.
	// Required.
	SecretAccessKey string `protobuf:"bytes,2,opt,name=secret_access_key,json=secretAccessKey" json:"secret_access_key,omitempty"`
}

func (m *AwsAccessKey) Reset()                    { *m = AwsAccessKey{} }
func (m *AwsAccessKey) String() string            { return proto.CompactTextString(m) }
func (*AwsAccessKey) ProtoMessage()               {}
func (*AwsAccessKey) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

// Conditions that determine which objects will be transferred.
type ObjectConditions struct {
	// If unspecified, `minTimeElapsedSinceLastModification` takes a zero value
	// and `maxTimeElapsedSinceLastModification` takes the maximum possible
	// value of Duration. Objects that satisfy the object conditions
	// must either have a `lastModificationTime` greater or equal to
	// `NOW` - `maxTimeElapsedSinceLastModification` and less than
	// `NOW` - `minTimeElapsedSinceLastModification`, or not have a
	// `lastModificationTime`.
	MinTimeElapsedSinceLastModification *google_protobuf3.Duration `protobuf:"bytes,1,opt,name=min_time_elapsed_since_last_modification,json=minTimeElapsedSinceLastModification" json:"min_time_elapsed_since_last_modification,omitempty"`
	// `maxTimeElapsedSinceLastModification` is the complement to
	// `minTimeElapsedSinceLastModification`.
	MaxTimeElapsedSinceLastModification *google_protobuf3.Duration `protobuf:"bytes,2,opt,name=max_time_elapsed_since_last_modification,json=maxTimeElapsedSinceLastModification" json:"max_time_elapsed_since_last_modification,omitempty"`
	// If `includePrefixes` is specified, objects that satisfy the object
	// conditions must have names that start with one of the `includePrefixes`
	// and that do not start with any of the `excludePrefixes`. If `includePrefixes`
	// is not specified, all objects except those that have names starting with
	// one of the `excludePrefixes` must satisfy the object conditions.
	//
	// Requirements:
	//
	//   * Each include-prefix and exclude-prefix can contain any sequence of
	//     Unicode characters, of max length 1024 bytes when UTF8-encoded, and
	//     must not contain Carriage Return or Line Feed characters.  Wildcard
	//     matching and regular expression matching are not supported.
	//
	//   * Each include-prefix and exclude-prefix must omit the leading slash.
	//     For example, to include the `requests.gz` object in a transfer from
	//     `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the include
	//     prefix as `logs/y=2015/requests.gz`.
	//
	//   * None of the include-prefix or the exclude-prefix values can be empty,
	//     if specified.
	//
	//   * Each include-prefix must include a distinct portion of the object
	//     namespace, i.e., no include-prefix may be a prefix of another
	//     include-prefix.
	//
	//   * Each exclude-prefix must exclude a distinct portion of the object
	//     namespace, i.e., no exclude-prefix may be a prefix of another
	//     exclude-prefix.
	//
	//   * If `includePrefixes` is specified, then each exclude-prefix must start
	//     with the value of a path explicitly included by `includePrefixes`.
	//
	// The max size of `includePrefixes` is 20.
	IncludePrefixes []string `protobuf:"bytes,3,rep,name=include_prefixes,json=includePrefixes" json:"include_prefixes,omitempty"`
	// `excludePrefixes` must follow the requirements described for
	// `includePrefixes`.
	//
	// The max size of `excludePrefixes` is 20.
	ExcludePrefixes []string `protobuf:"bytes,4,rep,name=exclude_prefixes,json=excludePrefixes" json:"exclude_prefixes,omitempty"`
}

func (m *ObjectConditions) Reset()                    { *m = ObjectConditions{} }
func (m *ObjectConditions) String() string            { return proto.CompactTextString(m) }
func (*ObjectConditions) ProtoMessage()               {}
func (*ObjectConditions) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *ObjectConditions) GetMinTimeElapsedSinceLastModification() *google_protobuf3.Duration {
	if m != nil {
		return m.MinTimeElapsedSinceLastModification
	}
	return nil
}

func (m *ObjectConditions) GetMaxTimeElapsedSinceLastModification() *google_protobuf3.Duration {
	if m != nil {
		return m.MaxTimeElapsedSinceLastModification
	}
	return nil
}

// In a GcsData, an object's name is the Google Cloud Storage object's name and
// its `lastModificationTime` refers to the object's updated time, which changes
// when the content or the metadata of the object is updated.
type GcsData struct {
	// Google Cloud Storage bucket name (see
	// [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	// Required.
	BucketName string `protobuf:"bytes,1,opt,name=bucket_name,json=bucketName" json:"bucket_name,omitempty"`
}

func (m *GcsData) Reset()                    { *m = GcsData{} }
func (m *GcsData) String() string            { return proto.CompactTextString(m) }
func (*GcsData) ProtoMessage()               {}
func (*GcsData) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

// An AwsS3Data can be a data source, but not a data sink.
// In an AwsS3Data, an object's name is the S3 object's key name.
type AwsS3Data struct {
	// S3 Bucket name (see
	// [Creating a bucket](http://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
	// Required.
	BucketName string `protobuf:"bytes,1,opt,name=bucket_name,json=bucketName" json:"bucket_name,omitempty"`
	// AWS access key used to sign the API requests to the AWS S3 bucket.
	// Permissions on the bucket must be granted to the access ID of the
	// AWS access key.
	// Required.
	AwsAccessKey *AwsAccessKey `protobuf:"bytes,2,opt,name=aws_access_key,json=awsAccessKey" json:"aws_access_key,omitempty"`
}

func (m *AwsS3Data) Reset()                    { *m = AwsS3Data{} }
func (m *AwsS3Data) String() string            { return proto.CompactTextString(m) }
func (*AwsS3Data) ProtoMessage()               {}
func (*AwsS3Data) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *AwsS3Data) GetAwsAccessKey() *AwsAccessKey {
	if m != nil {
		return m.AwsAccessKey
	}
	return nil
}

// An HttpData specifies a list of objects on the web to be transferred over
// HTTP.  The information of the objects to be transferred is contained in a
// file referenced by a URL. The first line in the file must be
// "TsvHttpData-1.0", which specifies the format of the file.  Subsequent lines
// specify the information of the list of objects, one object per list entry.
// Each entry has the following tab-delimited fields:
//
// * HTTP URL - The location of the object.
//
// * Length - The size of the object in bytes.
//
// * MD5 - The base64-encoded MD5 hash of the object.
//
// For an example of a valid TSV file, see
// [Transferring data from URLs](https://cloud.google.com/storage/transfer/#urls)
//
// When transferring data based on a URL list, keep the following in mind:
//
// * When an object located at `http(s)://hostname:port/<URL-path>` is transferred
// to a data sink, the name of the object at the data sink is
// `<hostname>/<URL-path>`.
//
// * If the specified size of an object does not match the actual size of the
// object fetched, the object will not be transferred.
//
// * If the specified MD5 does not match the MD5 computed from the transferred
// bytes, the object transfer will fail. For more information, see
// [Generating MD5 hashes](https://cloud.google.com/storage/transfer/#md5)
//
// * Ensure that each URL you specify is publicly accessible. For
// example, in Google Cloud Storage you can
// [share an object publicly]
// (https://cloud.google.com/storage/docs/cloud-console#_sharingdata) and get
// a link to it.
//
// * Storage Transfer Service obeys `robots.txt` rules and requires the source
// HTTP server to support `Range` requests and to return a `Content-Length`
// header in each response.
//
// * [ObjectConditions](#ObjectConditions) have no effect when filtering objects
// to transfer.
type HttpData struct {
	// The URL that points to the file that stores the object list entries.
	// This file must allow public access.  Currently, only URLs with HTTP and
	// HTTPS schemes are supported.
	// Required.
	ListUrl string `protobuf:"bytes,1,opt,name=list_url,json=listUrl" json:"list_url,omitempty"`
}

func (m *HttpData) Reset()                    { *m = HttpData{} }
func (m *HttpData) String() string            { return proto.CompactTextString(m) }
func (*HttpData) ProtoMessage()               {}
func (*HttpData) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

// TransferOptions uses three boolean parameters to define the actions
// to be performed on objects in a transfer.
type TransferOptions struct {
	// Whether overwriting objects that already exist in the sink is allowed.
	OverwriteObjectsAlreadyExistingInSink bool `protobuf:"varint,1,opt,name=overwrite_objects_already_existing_in_sink,json=overwriteObjectsAlreadyExistingInSink" json:"overwrite_objects_already_existing_in_sink,omitempty"`
	// Whether objects that exist only in the sink should be deleted.
	DeleteObjectsUniqueInSink bool `protobuf:"varint,2,opt,name=delete_objects_unique_in_sink,json=deleteObjectsUniqueInSink" json:"delete_objects_unique_in_sink,omitempty"`
	// Whether objects should be deleted from the source after they are
	// transferred to the sink.
	DeleteObjectsFromSourceAfterTransfer bool `protobuf:"varint,3,opt,name=delete_objects_from_source_after_transfer,json=deleteObjectsFromSourceAfterTransfer" json:"delete_objects_from_source_after_transfer,omitempty"`
}

func (m *TransferOptions) Reset()                    { *m = TransferOptions{} }
func (m *TransferOptions) String() string            { return proto.CompactTextString(m) }
func (*TransferOptions) ProtoMessage()               {}
func (*TransferOptions) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

// Configuration for running a transfer.
type TransferSpec struct {
	// The read source of the data.
	//
	// Types that are valid to be assigned to DataSource:
	//	*TransferSpec_GcsDataSource
	//	*TransferSpec_AwsS3DataSource
	//	*TransferSpec_HttpDataSource
	DataSource isTransferSpec_DataSource `protobuf_oneof:"data_source"`
	// The write sink for the data.
	//
	// Types that are valid to be assigned to DataSink:
	//	*TransferSpec_GcsDataSink
	DataSink isTransferSpec_DataSink `protobuf_oneof:"data_sink"`
	// Only objects that satisfy these object conditions are included in the set
	// of data source and data sink objects.  Object conditions based on
	// objects' `lastModificationTime` do not exclude objects in a data sink.
	ObjectConditions *ObjectConditions `protobuf:"bytes,5,opt,name=object_conditions,json=objectConditions" json:"object_conditions,omitempty"`
	// If the option `deleteObjectsUniqueInSink` is `true`, object conditions
	// based on objects' `lastModificationTime` are ignored and do not exclude
	// objects in a data source or a data sink.
	TransferOptions *TransferOptions `protobuf:"bytes,6,opt,name=transfer_options,json=transferOptions" json:"transfer_options,omitempty"`
}

func (m *TransferSpec) Reset()                    { *m = TransferSpec{} }
func (m *TransferSpec) String() string            { return proto.CompactTextString(m) }
func (*TransferSpec) ProtoMessage()               {}
func (*TransferSpec) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

type isTransferSpec_DataSource interface {
	isTransferSpec_DataSource()
}
type isTransferSpec_DataSink interface {
	isTransferSpec_DataSink()
}

type TransferSpec_GcsDataSource struct {
	GcsDataSource *GcsData `protobuf:"bytes,1,opt,name=gcs_data_source,json=gcsDataSource,oneof"`
}
type TransferSpec_AwsS3DataSource struct {
	AwsS3DataSource *AwsS3Data `protobuf:"bytes,2,opt,name=aws_s3_data_source,json=awsS3DataSource,oneof"`
}
type TransferSpec_HttpDataSource struct {
	HttpDataSource *HttpData `protobuf:"bytes,3,opt,name=http_data_source,json=httpDataSource,oneof"`
}
type TransferSpec_GcsDataSink struct {
	GcsDataSink *GcsData `protobuf:"bytes,4,opt,name=gcs_data_sink,json=gcsDataSink,oneof"`
}

func (*TransferSpec_GcsDataSource) isTransferSpec_DataSource()   {}
func (*TransferSpec_AwsS3DataSource) isTransferSpec_DataSource() {}
func (*TransferSpec_HttpDataSource) isTransferSpec_DataSource()  {}
func (*TransferSpec_GcsDataSink) isTransferSpec_DataSink()       {}

func (m *TransferSpec) GetDataSource() isTransferSpec_DataSource {
	if m != nil {
		return m.DataSource
	}
	return nil
}
func (m *TransferSpec) GetDataSink() isTransferSpec_DataSink {
	if m != nil {
		return m.DataSink
	}
	return nil
}

func (m *TransferSpec) GetGcsDataSource() *GcsData {
	if x, ok := m.GetDataSource().(*TransferSpec_GcsDataSource); ok {
		return x.GcsDataSource
	}
	return nil
}

func (m *TransferSpec) GetAwsS3DataSource() *AwsS3Data {
	if x, ok := m.GetDataSource().(*TransferSpec_AwsS3DataSource); ok {
		return x.AwsS3DataSource
	}
	return nil
}

func (m *TransferSpec) GetHttpDataSource() *HttpData {
	if x, ok := m.GetDataSource().(*TransferSpec_HttpDataSource); ok {
		return x.HttpDataSource
	}
	return nil
}

func (m *TransferSpec) GetGcsDataSink() *GcsData {
	if x, ok := m.GetDataSink().(*TransferSpec_GcsDataSink); ok {
		return x.GcsDataSink
	}
	return nil
}

func (m *TransferSpec) GetObjectConditions() *ObjectConditions {
	if m != nil {
		return m.ObjectConditions
	}
	return nil
}

func (m *TransferSpec) GetTransferOptions() *TransferOptions {
	if m != nil {
		return m.TransferOptions
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TransferSpec) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TransferSpec_OneofMarshaler, _TransferSpec_OneofUnmarshaler, _TransferSpec_OneofSizer, []interface{}{
		(*TransferSpec_GcsDataSource)(nil),
		(*TransferSpec_AwsS3DataSource)(nil),
		(*TransferSpec_HttpDataSource)(nil),
		(*TransferSpec_GcsDataSink)(nil),
	}
}

func _TransferSpec_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TransferSpec)
	// data_source
	switch x := m.DataSource.(type) {
	case *TransferSpec_GcsDataSource:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GcsDataSource); err != nil {
			return err
		}
	case *TransferSpec_AwsS3DataSource:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AwsS3DataSource); err != nil {
			return err
		}
	case *TransferSpec_HttpDataSource:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HttpDataSource); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TransferSpec.DataSource has unexpected type %T", x)
	}
	// data_sink
	switch x := m.DataSink.(type) {
	case *TransferSpec_GcsDataSink:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GcsDataSink); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TransferSpec.DataSink has unexpected type %T", x)
	}
	return nil
}

func _TransferSpec_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TransferSpec)
	switch tag {
	case 1: // data_source.gcs_data_source
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GcsData)
		err := b.DecodeMessage(msg)
		m.DataSource = &TransferSpec_GcsDataSource{msg}
		return true, err
	case 2: // data_source.aws_s3_data_source
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AwsS3Data)
		err := b.DecodeMessage(msg)
		m.DataSource = &TransferSpec_AwsS3DataSource{msg}
		return true, err
	case 3: // data_source.http_data_source
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HttpData)
		err := b.DecodeMessage(msg)
		m.DataSource = &TransferSpec_HttpDataSource{msg}
		return true, err
	case 4: // data_sink.gcs_data_sink
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GcsData)
		err := b.DecodeMessage(msg)
		m.DataSink = &TransferSpec_GcsDataSink{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TransferSpec_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TransferSpec)
	// data_source
	switch x := m.DataSource.(type) {
	case *TransferSpec_GcsDataSource:
		s := proto.Size(x.GcsDataSource)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TransferSpec_AwsS3DataSource:
		s := proto.Size(x.AwsS3DataSource)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TransferSpec_HttpDataSource:
		s := proto.Size(x.HttpDataSource)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// data_sink
	switch x := m.DataSink.(type) {
	case *TransferSpec_GcsDataSink:
		s := proto.Size(x.GcsDataSink)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Transfers can be scheduled to recur or to run just once.
type Schedule struct {
	// The first day the recurring transfer is scheduled to run. If
	// `scheduleStartDate` is in the past, the transfer will run for the first
	// time on the following day.
	// Required.
	ScheduleStartDate *google_type.Date `protobuf:"bytes,1,opt,name=schedule_start_date,json=scheduleStartDate" json:"schedule_start_date,omitempty"`
	// The last day the recurring transfer will be run. If `scheduleEndDate`
	// is the same as `scheduleStartDate`, the transfer will be executed only
	// once.
	ScheduleEndDate *google_type.Date `protobuf:"bytes,2,opt,name=schedule_end_date,json=scheduleEndDate" json:"schedule_end_date,omitempty"`
	// The time in UTC at which the transfer will be scheduled to start in a day.
	// Transfers may start later than this time. If not specified, recurring and
	// one-time transfers that are scheduled to run today will run immediately;
	// recurring transfers that are scheduled to run on a future date will start
	// at approximately midnight UTC on that date. Note that when configuring a
	// transfer with the Cloud Platform Console, the transfer's start time in a
	// day is specified in your local timezone.
	StartTimeOfDay *google_type1.TimeOfDay `protobuf:"bytes,3,opt,name=start_time_of_day,json=startTimeOfDay" json:"start_time_of_day,omitempty"`
}

func (m *Schedule) Reset()                    { *m = Schedule{} }
func (m *Schedule) String() string            { return proto.CompactTextString(m) }
func (*Schedule) ProtoMessage()               {}
func (*Schedule) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *Schedule) GetScheduleStartDate() *google_type.Date {
	if m != nil {
		return m.ScheduleStartDate
	}
	return nil
}

func (m *Schedule) GetScheduleEndDate() *google_type.Date {
	if m != nil {
		return m.ScheduleEndDate
	}
	return nil
}

func (m *Schedule) GetStartTimeOfDay() *google_type1.TimeOfDay {
	if m != nil {
		return m.StartTimeOfDay
	}
	return nil
}

// This resource represents the configuration of a transfer job that runs
// periodically.
type TransferJob struct {
	// A globally unique name assigned by Storage Transfer Service when the
	// job is created. This field should be left empty in requests to create a new
	// transfer job; otherwise, the requests result in an `INVALID_ARGUMENT`
	// error.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A description provided by the user for the job. Its max length is 1024
	// bytes when Unicode-encoded.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// The ID of the Google Cloud Platform Console project that owns the job.
	// Required.
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Transfer specification.
	// Required.
	TransferSpec *TransferSpec `protobuf:"bytes,4,opt,name=transfer_spec,json=transferSpec" json:"transfer_spec,omitempty"`
	// Schedule specification.
	// Required.
	Schedule *Schedule `protobuf:"bytes,5,opt,name=schedule" json:"schedule,omitempty"`
	// Status of the job. This value MUST be specified for
	// `CreateTransferJobRequests`.
	//
	// NOTE: The effect of the new job status takes place during a subsequent job
	// run. For example, if you change the job status from `ENABLED` to
	// `DISABLED`, and an operation spawned by the transfer is running, the status
	// change would not affect the current operation.
	Status TransferJob_Status `protobuf:"varint,6,opt,name=status,enum=google.storagetransfer.v1.TransferJob_Status" json:"status,omitempty"`
	// This field cannot be changed by user requests.
	CreationTime *google_protobuf4.Timestamp `protobuf:"bytes,7,opt,name=creation_time,json=creationTime" json:"creation_time,omitempty"`
	// This field cannot be changed by user requests.
	LastModificationTime *google_protobuf4.Timestamp `protobuf:"bytes,8,opt,name=last_modification_time,json=lastModificationTime" json:"last_modification_time,omitempty"`
	// This field cannot be changed by user requests.
	DeletionTime *google_protobuf4.Timestamp `protobuf:"bytes,9,opt,name=deletion_time,json=deletionTime" json:"deletion_time,omitempty"`
}

func (m *TransferJob) Reset()                    { *m = TransferJob{} }
func (m *TransferJob) String() string            { return proto.CompactTextString(m) }
func (*TransferJob) ProtoMessage()               {}
func (*TransferJob) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *TransferJob) GetTransferSpec() *TransferSpec {
	if m != nil {
		return m.TransferSpec
	}
	return nil
}

func (m *TransferJob) GetSchedule() *Schedule {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (m *TransferJob) GetCreationTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.CreationTime
	}
	return nil
}

func (m *TransferJob) GetLastModificationTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.LastModificationTime
	}
	return nil
}

func (m *TransferJob) GetDeletionTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.DeletionTime
	}
	return nil
}

// An entry describing an error that has occurred.
type ErrorLogEntry struct {
	// A URL that refers to the target (a data source, a data sink,
	// or an object) with which the error is associated.
	// Required.
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
	// A list of messages that carry the error details.
	ErrorDetails []string `protobuf:"bytes,3,rep,name=error_details,json=errorDetails" json:"error_details,omitempty"`
}

func (m *ErrorLogEntry) Reset()                    { *m = ErrorLogEntry{} }
func (m *ErrorLogEntry) String() string            { return proto.CompactTextString(m) }
func (*ErrorLogEntry) ProtoMessage()               {}
func (*ErrorLogEntry) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

// A summary of errors by error code, plus a count and sample error log
// entries.
type ErrorSummary struct {
	// Required.
	ErrorCode google_rpc.Code `protobuf:"varint,1,opt,name=error_code,json=errorCode,enum=google.rpc.Code" json:"error_code,omitempty"`
	// Count of this type of error.
	// Required.
	ErrorCount int64 `protobuf:"varint,2,opt,name=error_count,json=errorCount" json:"error_count,omitempty"`
	// Error samples.
	ErrorLogEntries []*ErrorLogEntry `protobuf:"bytes,3,rep,name=error_log_entries,json=errorLogEntries" json:"error_log_entries,omitempty"`
}

func (m *ErrorSummary) Reset()                    { *m = ErrorSummary{} }
func (m *ErrorSummary) String() string            { return proto.CompactTextString(m) }
func (*ErrorSummary) ProtoMessage()               {}
func (*ErrorSummary) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *ErrorSummary) GetErrorLogEntries() []*ErrorLogEntry {
	if m != nil {
		return m.ErrorLogEntries
	}
	return nil
}

// A collection of counters that report the progress of a transfer operation.
type TransferCounters struct {
	// Objects found in the data source that are scheduled to be transferred,
	// which will be copied, excluded based on conditions, or skipped due to
	// failures.
	ObjectsFoundFromSource int64 `protobuf:"varint,1,opt,name=objects_found_from_source,json=objectsFoundFromSource" json:"objects_found_from_source,omitempty"`
	// Bytes found in the data source that are scheduled to be transferred,
	// which will be copied, excluded based on conditions, or skipped due to
	// failures.
	BytesFoundFromSource int64 `protobuf:"varint,2,opt,name=bytes_found_from_source,json=bytesFoundFromSource" json:"bytes_found_from_source,omitempty"`
	// Objects found only in the data sink that are scheduled to be deleted.
	ObjectsFoundOnlyFromSink int64 `protobuf:"varint,3,opt,name=objects_found_only_from_sink,json=objectsFoundOnlyFromSink" json:"objects_found_only_from_sink,omitempty"`
	// Bytes found only in the data sink that are scheduled to be deleted.
	BytesFoundOnlyFromSink int64 `protobuf:"varint,4,opt,name=bytes_found_only_from_sink,json=bytesFoundOnlyFromSink" json:"bytes_found_only_from_sink,omitempty"`
	// Objects in the data source that are not transferred because they already
	// exist in the data sink.
	ObjectsFromSourceSkippedBySync int64 `protobuf:"varint,5,opt,name=objects_from_source_skipped_by_sync,json=objectsFromSourceSkippedBySync" json:"objects_from_source_skipped_by_sync,omitempty"`
	// Bytes in the data source that are not transferred because they already
	// exist in the data sink.
	BytesFromSourceSkippedBySync int64 `protobuf:"varint,6,opt,name=bytes_from_source_skipped_by_sync,json=bytesFromSourceSkippedBySync" json:"bytes_from_source_skipped_by_sync,omitempty"`
	// Objects that are copied to the data sink.
	ObjectsCopiedToSink int64 `protobuf:"varint,7,opt,name=objects_copied_to_sink,json=objectsCopiedToSink" json:"objects_copied_to_sink,omitempty"`
	// Bytes that are copied to the data sink.
	BytesCopiedToSink int64 `protobuf:"varint,8,opt,name=bytes_copied_to_sink,json=bytesCopiedToSink" json:"bytes_copied_to_sink,omitempty"`
	// Objects that are deleted from the data source.
	ObjectsDeletedFromSource int64 `protobuf:"varint,9,opt,name=objects_deleted_from_source,json=objectsDeletedFromSource" json:"objects_deleted_from_source,omitempty"`
	// Bytes that are deleted from the data source.
	BytesDeletedFromSource int64 `protobuf:"varint,10,opt,name=bytes_deleted_from_source,json=bytesDeletedFromSource" json:"bytes_deleted_from_source,omitempty"`
	// Objects that are deleted from the data sink.
	ObjectsDeletedFromSink int64 `protobuf:"varint,11,opt,name=objects_deleted_from_sink,json=objectsDeletedFromSink" json:"objects_deleted_from_sink,omitempty"`
	// Bytes that are deleted from the data sink.
	BytesDeletedFromSink int64 `protobuf:"varint,12,opt,name=bytes_deleted_from_sink,json=bytesDeletedFromSink" json:"bytes_deleted_from_sink,omitempty"`
	// Objects in the data source that failed during the transfer.
	ObjectsFromSourceFailed int64 `protobuf:"varint,13,opt,name=objects_from_source_failed,json=objectsFromSourceFailed" json:"objects_from_source_failed,omitempty"`
	// Bytes in the data source that failed during the transfer.
	BytesFromSourceFailed int64 `protobuf:"varint,14,opt,name=bytes_from_source_failed,json=bytesFromSourceFailed" json:"bytes_from_source_failed,omitempty"`
	// Objects that failed to be deleted from the data sink.
	ObjectsFailedToDeleteFromSink int64 `protobuf:"varint,15,opt,name=objects_failed_to_delete_from_sink,json=objectsFailedToDeleteFromSink" json:"objects_failed_to_delete_from_sink,omitempty"`
	// Bytes that failed to be deleted from the data sink.
	BytesFailedToDeleteFromSink int64 `protobuf:"varint,16,opt,name=bytes_failed_to_delete_from_sink,json=bytesFailedToDeleteFromSink" json:"bytes_failed_to_delete_from_sink,omitempty"`
}

func (m *TransferCounters) Reset()                    { *m = TransferCounters{} }
func (m *TransferCounters) String() string            { return proto.CompactTextString(m) }
func (*TransferCounters) ProtoMessage()               {}
func (*TransferCounters) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

// A description of the execution of a transfer.
type TransferOperation struct {
	// A globally unique ID assigned by the system.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The ID of the Google Cloud Platform Console project that owns the operation.
	// Required.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Transfer specification.
	// Required.
	TransferSpec *TransferSpec `protobuf:"bytes,3,opt,name=transfer_spec,json=transferSpec" json:"transfer_spec,omitempty"`
	// Start time of this transfer execution.
	StartTime *google_protobuf4.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// End time of this transfer execution.
	EndTime *google_protobuf4.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// Status of the transfer operation.
	Status TransferOperation_Status `protobuf:"varint,6,opt,name=status,enum=google.storagetransfer.v1.TransferOperation_Status" json:"status,omitempty"`
	// Information about the progress of the transfer operation.
	Counters *TransferCounters `protobuf:"bytes,7,opt,name=counters" json:"counters,omitempty"`
	// Summarizes errors encountered with sample error log entries.
	ErrorBreakdowns []*ErrorSummary `protobuf:"bytes,8,rep,name=error_breakdowns,json=errorBreakdowns" json:"error_breakdowns,omitempty"`
	// The name of the transfer job that triggers this transfer operation.
	TransferJobName string `protobuf:"bytes,9,opt,name=transfer_job_name,json=transferJobName" json:"transfer_job_name,omitempty"`
}

func (m *TransferOperation) Reset()                    { *m = TransferOperation{} }
func (m *TransferOperation) String() string            { return proto.CompactTextString(m) }
func (*TransferOperation) ProtoMessage()               {}
func (*TransferOperation) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

func (m *TransferOperation) GetTransferSpec() *TransferSpec {
	if m != nil {
		return m.TransferSpec
	}
	return nil
}

func (m *TransferOperation) GetStartTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *TransferOperation) GetEndTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *TransferOperation) GetCounters() *TransferCounters {
	if m != nil {
		return m.Counters
	}
	return nil
}

func (m *TransferOperation) GetErrorBreakdowns() []*ErrorSummary {
	if m != nil {
		return m.ErrorBreakdowns
	}
	return nil
}

func init() {
	proto.RegisterType((*GoogleServiceAccount)(nil), "google.storagetransfer.v1.GoogleServiceAccount")
	proto.RegisterType((*AwsAccessKey)(nil), "google.storagetransfer.v1.AwsAccessKey")
	proto.RegisterType((*ObjectConditions)(nil), "google.storagetransfer.v1.ObjectConditions")
	proto.RegisterType((*GcsData)(nil), "google.storagetransfer.v1.GcsData")
	proto.RegisterType((*AwsS3Data)(nil), "google.storagetransfer.v1.AwsS3Data")
	proto.RegisterType((*HttpData)(nil), "google.storagetransfer.v1.HttpData")
	proto.RegisterType((*TransferOptions)(nil), "google.storagetransfer.v1.TransferOptions")
	proto.RegisterType((*TransferSpec)(nil), "google.storagetransfer.v1.TransferSpec")
	proto.RegisterType((*Schedule)(nil), "google.storagetransfer.v1.Schedule")
	proto.RegisterType((*TransferJob)(nil), "google.storagetransfer.v1.TransferJob")
	proto.RegisterType((*ErrorLogEntry)(nil), "google.storagetransfer.v1.ErrorLogEntry")
	proto.RegisterType((*ErrorSummary)(nil), "google.storagetransfer.v1.ErrorSummary")
	proto.RegisterType((*TransferCounters)(nil), "google.storagetransfer.v1.TransferCounters")
	proto.RegisterType((*TransferOperation)(nil), "google.storagetransfer.v1.TransferOperation")
	proto.RegisterEnum("google.storagetransfer.v1.TransferJob_Status", TransferJob_Status_name, TransferJob_Status_value)
	proto.RegisterEnum("google.storagetransfer.v1.TransferOperation_Status", TransferOperation_Status_name, TransferOperation_Status_value)
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/storagetransfer/v1/transfer_types.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 1751 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xa4, 0x57, 0x5f, 0x6f, 0x1b, 0xc7,
	0x11, 0x37, 0x45, 0x59, 0x22, 0x87, 0xa4, 0x48, 0x6d, 0x5c, 0x87, 0x52, 0xe2, 0xd6, 0x3d, 0x25,
	0xb0, 0xe3, 0xa0, 0x24, 0x22, 0x21, 0x08, 0x1c, 0x23, 0x75, 0x29, 0x91, 0x92, 0x18, 0xcb, 0x96,
	0x70, 0x47, 0xa1, 0xed, 0x4b, 0x0f, 0xcb, 0xbb, 0x25, 0xbd, 0xd1, 0xf1, 0xf6, 0x7a, 0xbb, 0xb4,
	0x74, 0xe8, 0x53, 0x9f, 0xfa, 0x19, 0xfa, 0x45, 0xfa, 0x29, 0x0a, 0xf4, 0xad, 0x9f, 0xa3, 0x8f,
	0x7d, 0x2c, 0xf6, 0xcf, 0x1d, 0xff, 0x88, 0x26, 0x59, 0xe4, 0x85, 0xd8, 0x9d, 0x9d, 0xdf, 0x6f,
	0x66, 0x76, 0x86, 0x33, 0x7b, 0xf0, 0x76, 0xc8, 0xd8, 0x30, 0x20, 0x8d, 0x21, 0x0b, 0x70, 0x38,
	0x6c, 0xb0, 0x78, 0xd8, 0x1c, 0x92, 0x30, 0x8a, 0x99, 0x60, 0x4d, 0x7d, 0x84, 0x23, 0xca, 0x9b,
	0x5c, 0xb0, 0x18, 0x0f, 0x89, 0x88, 0x71, 0xc8, 0x07, 0x24, 0x6e, 0x7e, 0xf8, 0xa6, 0x99, 0xae,
	0x5d, 0x91, 0x44, 0x84, 0x37, 0x14, 0x04, 0xed, 0x19, 0xba, 0x39, 0xfd, 0xc6, 0x87, 0x6f, 0xf6,
	0xbb, 0xeb, 0x59, 0xc2, 0x11, 0x6d, 0x72, 0x12, 0x7f, 0xa0, 0x1e, 0xf1, 0x58, 0x38, 0xa0, 0xc3,
	0x26, 0x0e, 0x43, 0x26, 0xb0, 0xa0, 0x2c, 0x34, 0x56, 0xf6, 0x5f, 0x0e, 0xa9, 0x78, 0x3f, 0xee,
	0x37, 0x3c, 0x36, 0x6a, 0x6a, 0xba, 0xa6, 0x3a, 0xe8, 0x8f, 0x07, 0xcd, 0x48, 0xb9, 0xd3, 0xf4,
	0xc7, 0xb1, 0x82, 0x64, 0x0b, 0x03, 0x7d, 0xb5, 0x1a, 0x2a, 0xe8, 0x88, 0x70, 0x81, 0x47, 0xd1,
	0x64, 0x95, 0xd9, 0x5d, 0x2b, 0x84, 0x38, 0xf2, 0x9a, 0x1e, 0xf3, 0x89, 0xfa, 0x31, 0xd0, 0xef,
	0xd7, 0x83, 0x4a, 0x0f, 0x9a, 0x3e, 0x16, 0xfa, 0xc7, 0x60, 0xdb, 0xff, 0x07, 0x56, 0xba, 0xcc,
	0x06, 0x3e, 0x4e, 0x26, 0x2b, 0xcd, 0x62, 0xbd, 0x82, 0x47, 0x67, 0x4a, 0xd9, 0xd1, 0xb7, 0xdb,
	0xf2, 0x3c, 0x36, 0x0e, 0x05, 0x3a, 0x80, 0x0a, 0xd6, 0x4b, 0x97, 0x8c, 0x30, 0x0d, 0xea, 0xb9,
	0xa7, 0xb9, 0xe7, 0x45, 0xbb, 0x6c, 0x84, 0x1d, 0x29, 0xb3, 0xfe, 0x04, 0xe5, 0xd6, 0x2d, 0x6f,
	0x79, 0x1e, 0xe1, 0xfc, 0x0d, 0x49, 0x90, 0xa5, 0x40, 0x84, 0x73, 0xf7, 0x86, 0x24, 0x2e, 0xf5,
	0x0d, 0xa8, 0x84, 0x53, 0x8d, 0xae, 0x8f, 0x5e, 0xc0, 0x2e, 0x27, 0x5e, 0x4c, 0x84, 0x3b, 0x51,
	0xad, 0x6f, 0x28, 0xbd, 0xaa, 0x3e, 0xc8, 0xf8, 0xac, 0x7f, 0x6e, 0x40, 0xed, 0xb2, 0xff, 0x13,
	0xf1, 0xc4, 0x09, 0x0b, 0x7d, 0xaa, 0x92, 0x8d, 0x22, 0x78, 0x3e, 0xa2, 0xa1, 0x2b, 0x03, 0x71,
	0x49, 0x80, 0x23, 0x4e, 0x7c, 0x97, 0xd3, 0xd0, 0x23, 0x6e, 0x80, 0xb9, 0x70, 0x47, 0xcc, 0xa7,
	0x03, 0xea, 0xa9, 0xec, 0x2a, 0xfb, 0xa5, 0xc3, 0xbd, 0x86, 0xb9, 0xaa, 0x34, 0xa7, 0x8d, 0xb6,
	0x49, 0xbf, 0x7d, 0x30, 0xa2, 0x61, 0x8f, 0x8e, 0x48, 0x47, 0x13, 0x39, 0x92, 0xe7, 0x02, 0x73,
	0xf1, 0x76, 0x8a, 0x45, 0x59, 0xc4, 0x77, 0xeb, 0x59, 0xdc, 0x58, 0x6d, 0x11, 0xdf, 0xad, 0xb4,
	0xf8, 0x15, 0xd4, 0x68, 0xe8, 0x05, 0x63, 0x9f, 0xb8, 0x51, 0x4c, 0x06, 0xf4, 0x8e, 0xf0, 0x7a,
	0xfe, 0x69, 0x5e, 0xde, 0x91, 0x91, 0x5f, 0x19, 0xb1, 0x54, 0x25, 0x77, 0x73, 0xaa, 0x9b, 0x5a,
	0xd5, 0xc8, 0x53, 0x55, 0xeb, 0x05, 0x6c, 0x9f, 0x79, 0xbc, 0x8d, 0x05, 0x46, 0xbf, 0x82, 0x52,
	0x7f, 0xec, 0xdd, 0x10, 0xe1, 0x86, 0x78, 0x44, 0x4c, 0x9e, 0x40, 0x8b, 0xde, 0xe1, 0x11, 0xb1,
	0xfe, 0x02, 0xc5, 0xd6, 0x2d, 0x77, 0x8e, 0xd6, 0xd2, 0x46, 0x6f, 0x61, 0x07, 0xdf, 0xf2, 0xf9,
	0x8c, 0x96, 0x0e, 0x9f, 0x35, 0x3e, 0xfa, 0xcf, 0x6f, 0x4c, 0x57, 0x8e, 0x5d, 0xc6, 0x53, 0x3b,
	0xeb, 0x4b, 0x28, 0x9c, 0x0b, 0x11, 0x29, 0xdb, 0x7b, 0x50, 0x08, 0x28, 0x17, 0xee, 0x38, 0x4e,
	0x6b, 0x70, 0x5b, 0xee, 0xaf, 0xe3, 0xc0, 0xfa, 0xdb, 0x06, 0x54, 0x7b, 0x86, 0xf1, 0x32, 0xd2,
	0xd5, 0xf1, 0x47, 0x78, 0xc1, 0x3e, 0x90, 0xf8, 0x36, 0xa6, 0x82, 0xb8, 0x4c, 0xd5, 0x0e, 0x77,
	0x71, 0x10, 0x13, 0xec, 0x27, 0x2e, 0xb9, 0xa3, 0x5c, 0xd0, 0x70, 0xe8, 0xd2, 0x50, 0x26, 0xf0,
	0x46, 0x11, 0x16, 0xec, 0x2f, 0x33, 0x84, 0x2e, 0x36, 0xde, 0xd2, 0xfa, 0x1d, 0xa3, 0xde, 0x0d,
	0x1d, 0x1a, 0xde, 0xa0, 0xdf, 0xc1, 0x13, 0x9f, 0x04, 0x64, 0x8a, 0x77, 0x1c, 0xd2, 0x3f, 0x8f,
	0x49, 0xc6, 0xb6, 0xa1, 0xd8, 0xf6, 0xb4, 0x92, 0xa1, 0xba, 0x56, 0x2a, 0x86, 0xe1, 0xf7, 0xf0,
	0xd5, 0x1c, 0xc3, 0x20, 0x66, 0x23, 0x97, 0xb3, 0x71, 0xec, 0x11, 0x17, 0x0f, 0x84, 0xec, 0x9b,
	0x26, 0xa0, 0x7a, 0x5e, 0xb1, 0x7d, 0x31, 0xc3, 0x76, 0x1a, 0xb3, 0x91, 0xa3, 0xb4, 0x5b, 0x52,
	0x39, 0x0d, 0xde, 0xfa, 0xfb, 0x26, 0x94, 0xd3, 0x8d, 0x13, 0x11, 0x0f, 0x5d, 0x40, 0x75, 0xe8,
	0x71, 0xd7, 0xc7, 0x02, 0x1b, 0x7a, 0xf3, 0x5f, 0xb0, 0x96, 0x64, 0xc4, 0x14, 0xc7, 0xf9, 0x03,
	0xbb, 0x32, 0xd4, 0x4b, 0x6d, 0x0b, 0x39, 0x80, 0x64, 0x7a, 0xf9, 0xd1, 0x0c, 0xa1, 0x4e, 0xf1,
	0x17, 0xcb, 0x53, 0xac, 0x2b, 0xe8, 0xfc, 0x81, 0x5d, 0xc5, 0xe9, 0xc6, 0x90, 0x5e, 0x42, 0xed,
	0xbd, 0x10, 0xd1, 0x0c, 0x65, 0x5e, 0x51, 0x1e, 0x2c, 0xa1, 0x4c, 0xeb, 0xe2, 0xfc, 0x81, 0xbd,
	0xf3, 0xde, 0xac, 0x0d, 0xe1, 0x39, 0x54, 0x26, 0x31, 0xcb, 0x7c, 0x6c, 0xae, 0x1d, 0x71, 0xce,
	0x2e, 0xa5, 0x11, 0xcb, 0x3c, 0xfd, 0x01, 0x76, 0x75, 0x82, 0x5c, 0x2f, 0xeb, 0x3b, 0xf5, 0x87,
	0x8a, 0xed, 0xeb, 0x25, 0x6c, 0xf3, 0xad, 0xca, 0xae, 0xb1, 0xf9, 0xe6, 0x75, 0x0d, 0xb5, 0x6c,
	0x42, 0x32, 0x5d, 0xb2, 0xf5, 0x2d, 0x45, 0xfc, 0x62, 0x09, 0xf1, 0x5c, 0x91, 0xdb, 0x55, 0x31,
	0x2b, 0x38, 0xae, 0x40, 0x69, 0xea, 0x1a, 0x8f, 0x4b, 0x50, 0xcc, 0x6e, 0xc1, 0xfa, 0x57, 0x0e,
	0x0a, 0x8e, 0xf7, 0x9e, 0xf8, 0xe3, 0x80, 0xa0, 0x16, 0x7c, 0xc2, 0xcd, 0xda, 0xe5, 0x02, 0xc7,
	0x42, 0x5e, 0x57, 0x5a, 0x1b, 0xbb, 0xa9, 0x0b, 0x72, 0x66, 0x34, 0xda, 0x58, 0x10, 0x7b, 0x37,
	0xd5, 0x76, 0xa4, 0xb2, 0x14, 0xa1, 0x1f, 0x20, 0x13, 0xba, 0x24, 0xf4, 0x35, 0xc1, 0xc6, 0xc7,
	0x08, 0xaa, 0xa9, 0x6e, 0x27, 0xf4, 0x15, 0xbc, 0x05, 0xbb, 0xda, 0xb0, 0x6a, 0xa7, 0x6c, 0xe0,
	0xfa, 0x38, 0x31, 0x79, 0x7f, 0x3c, 0x03, 0x97, 0x4d, 0xf2, 0x72, 0xd0, 0xc6, 0x89, 0xbd, 0xa3,
	0x00, 0xd9, 0xde, 0xfa, 0xf7, 0x26, 0x94, 0xd2, 0x2b, 0xf9, 0x91, 0xf5, 0x11, 0x82, 0xcd, 0xa9,
	0xbe, 0xa4, 0xd6, 0xe8, 0x29, 0x94, 0x7c, 0xc2, 0xbd, 0x98, 0x46, 0x59, 0x5b, 0x2e, 0xda, 0xd3,
	0x22, 0xf4, 0x04, 0x20, 0x8a, 0x99, 0xca, 0x32, 0xf5, 0x95, 0x07, 0x45, 0xbb, 0x68, 0x24, 0x5d,
	0x1f, 0x5d, 0x40, 0x25, 0xcb, 0x14, 0x8f, 0x88, 0x67, 0xaa, 0xe9, 0xd9, 0x1a, 0x69, 0x92, 0xff,
	0x40, 0xbb, 0x2c, 0xa6, 0xff, 0x8f, 0xaf, 0xa1, 0x90, 0x5e, 0x84, 0x29, 0xa4, 0x65, 0x45, 0x9e,
	0xa6, 0xcb, 0xce, 0x40, 0xa8, 0x03, 0x5b, 0x5c, 0x60, 0x31, 0xd6, 0xe5, 0xb2, 0x73, 0xf8, 0x9b,
	0x35, 0xfc, 0xf8, 0x91, 0xf5, 0x1b, 0x8e, 0x02, 0xd9, 0x06, 0x8c, 0x5e, 0x43, 0xc5, 0x8b, 0x89,
	0x1a, 0x32, 0x2a, 0x01, 0xf5, 0x6d, 0xe5, 0xcc, 0xfe, 0xbd, 0x79, 0xd5, 0x4b, 0x1f, 0x39, 0x76,
	0x39, 0x05, 0x48, 0x11, 0xba, 0x82, 0xc7, 0xf7, 0x86, 0x9e, 0x66, 0x2a, 0xac, 0x64, 0x7a, 0x14,
	0xcc, 0xcd, 0x39, 0xc5, 0xf8, 0x1a, 0x2a, 0xaa, 0xc7, 0x65, 0x44, 0xc5, 0xd5, 0x2e, 0xa5, 0x00,
	0x29, 0xb2, 0xce, 0x61, 0x4b, 0x47, 0x89, 0x1e, 0x03, 0x72, 0x7a, 0xad, 0xde, 0xb5, 0xe3, 0x5e,
	0xbf, 0x73, 0xae, 0x3a, 0x27, 0xdd, 0xd3, 0x6e, 0xa7, 0x5d, 0x7b, 0x80, 0x4a, 0xb0, 0xdd, 0x79,
	0xd7, 0x3a, 0xbe, 0xe8, 0xb4, 0x6b, 0x39, 0x54, 0x86, 0x42, 0xbb, 0xeb, 0xe8, 0xdd, 0x86, 0x3c,
	0x6a, 0x77, 0x2e, 0x3a, 0xbd, 0x4e, 0xbb, 0x96, 0xb7, 0x4e, 0xa1, 0xd2, 0x89, 0x63, 0x16, 0x5f,
	0xb0, 0x61, 0x27, 0x14, 0x71, 0x82, 0x6a, 0x90, 0x9f, 0xcc, 0x1d, 0xb9, 0x94, 0xef, 0x22, 0x22,
	0x55, 0x5c, 0x9f, 0x08, 0x4c, 0x83, 0x74, 0x2c, 0x97, 0x95, 0xb0, 0xad, 0x65, 0xd6, 0x3f, 0x72,
	0x50, 0x56, 0x44, 0xce, 0x78, 0x34, 0xc2, 0x71, 0x82, 0x9a, 0x00, 0x1a, 0x25, 0xdf, 0x7e, 0x8a,
	0x6e, 0xe7, 0xb0, 0x96, 0x06, 0x18, 0x47, 0x5e, 0xe3, 0x84, 0xf9, 0xc4, 0x2e, 0x2a, 0x1d, 0xb9,
	0x94, 0x13, 0x37, 0x05, 0x8c, 0x43, 0xa1, 0xca, 0x37, 0x6f, 0x83, 0x39, 0x97, 0xef, 0xb3, 0x1e,
	0xec, 0x6a, 0x85, 0x80, 0x0d, 0x5d, 0x12, 0x8a, 0x98, 0x9a, 0x27, 0x42, 0xe9, 0xf0, 0xf9, 0x92,
	0xd2, 0x98, 0x09, 0xcf, 0xae, 0x92, 0xa9, 0x2d, 0x25, 0xdc, 0xfa, 0xcf, 0x36, 0xd4, 0xd2, 0xea,
	0x51, 0x76, 0x48, 0xcc, 0xd1, 0x4b, 0xd8, 0xcb, 0xc6, 0x15, 0x1b, 0x87, 0xfe, 0xf4, 0xd0, 0x52,
	0xb1, 0xe4, 0xed, 0xc7, 0x46, 0xe1, 0x54, 0x9e, 0x4f, 0x86, 0x14, 0xfa, 0x16, 0x3e, 0xed, 0x27,
	0x82, 0x2c, 0x02, 0xea, 0x90, 0x1e, 0xa9, 0xe3, 0x79, 0xd8, 0x6f, 0xe1, 0xf3, 0x59, 0x8b, 0x2c,
	0x0c, 0x12, 0x83, 0x96, 0x8d, 0x3d, 0xaf, 0xb0, 0xf5, 0x69, 0xa3, 0x97, 0x61, 0x90, 0x28, 0x06,
	0xd9, 0xbf, 0xbf, 0x87, 0xfd, 0x69, 0xb3, 0x73, 0xe8, 0x4d, 0xed, 0xf2, 0xc4, 0xf2, 0x0c, 0xf6,
	0x0d, 0x1c, 0x2c, 0x1a, 0xce, 0xfc, 0x86, 0x46, 0x11, 0xf1, 0xdd, 0x7e, 0xe2, 0xf2, 0x24, 0xf4,
	0xd4, 0x9f, 0x38, 0x6f, 0xff, 0x92, 0xcd, 0xcf, 0x65, 0x47, 0xeb, 0x1d, 0x27, 0x4e, 0x12, 0x7a,
	0xe8, 0x0c, 0x7e, 0x6d, 0x1c, 0x59, 0x42, 0xb5, 0xa5, 0xa8, 0x3e, 0xd7, 0xfe, 0x7c, 0x84, 0xe8,
	0x08, 0xd2, 0x2b, 0x76, 0x3d, 0x16, 0x51, 0xe2, 0xbb, 0x82, 0xe9, 0x68, 0xb6, 0x15, 0xfa, 0x13,
	0x73, 0x7a, 0xa2, 0x0e, 0x7b, 0x4c, 0x85, 0xd2, 0x04, 0x7d, 0xbd, 0xf3, 0x90, 0x82, 0x82, 0xec,
	0xaa, 0xb3, 0x19, 0xc0, 0x0f, 0xf0, 0x59, 0x6a, 0x45, 0x3f, 0x3b, 0x66, 0x53, 0x56, 0x9c, 0xb9,
	0xf6, 0xb6, 0xd6, 0x98, 0x4a, 0xdb, 0x4b, 0xd8, 0xd3, 0xf6, 0x16, 0x81, 0x61, 0xea, 0xd6, 0x17,
	0x42, 0x17, 0x5b, 0x96, 0xfe, 0x96, 0x66, 0x6a, 0x6c, 0x1a, 0x2c, 0x9d, 0xce, 0x6a, 0xec, 0x3e,
	0xb0, 0x3c, 0x55, 0x63, 0xf3, 0xb0, 0x57, 0xb0, 0xbf, 0x28, 0xcf, 0x03, 0x4c, 0x03, 0xe2, 0xd7,
	0x2b, 0x0a, 0xf9, 0xe9, 0xbd, 0xf4, 0x9e, 0xaa, 0x63, 0xf4, 0x1d, 0xd4, 0xef, 0xe7, 0xd5, 0x40,
	0x77, 0x14, 0xf4, 0x17, 0x73, 0xe9, 0x34, 0xc0, 0x2e, 0x58, 0x99, 0x55, 0x25, 0x91, 0x49, 0x31,
	0x6f, 0xc2, 0x89, 0xdf, 0x55, 0x45, 0xf1, 0x24, 0xb5, 0xae, 0x14, 0x7b, 0x4c, 0x47, 0x90, 0x05,
	0xd0, 0x81, 0xa7, 0xc6, 0x87, 0x8f, 0x13, 0xd5, 0x14, 0xd1, 0x67, 0xda, 0x97, 0x85, 0x34, 0xd6,
	0x5f, 0x1f, 0xc2, 0xee, 0xe4, 0x7d, 0x41, 0xf4, 0x57, 0xca, 0xc2, 0x91, 0x3a, 0x3b, 0x30, 0x37,
	0x56, 0x0e, 0xcc, 0xfc, 0xcf, 0x19, 0x98, 0x2f, 0x01, 0x26, 0xcf, 0x04, 0x33, 0x7b, 0x97, 0x8d,
	0x84, 0x62, 0xf6, 0x46, 0x40, 0xdf, 0x42, 0x41, 0xbe, 0x4b, 0x14, 0xf0, 0xe1, 0x4a, 0xe0, 0x36,
	0x09, 0x7d, 0x05, 0x7b, 0x33, 0x37, 0x61, 0x8f, 0xd6, 0x7a, 0x90, 0x99, 0x0b, 0x9b, 0x9f, 0xb3,
	0x67, 0x50, 0xf0, 0x4c, 0xff, 0x34, 0x23, 0xf6, 0xeb, 0x35, 0xe8, 0xd2, 0x96, 0x6b, 0x67, 0x60,
	0x64, 0x43, 0x4d, 0xf7, 0xf9, 0x7e, 0x4c, 0xf0, 0x8d, 0xcf, 0x6e, 0x43, 0x5e, 0x2f, 0xa8, 0x36,
	0xff, 0x6c, 0x55, 0x9b, 0x37, 0xc3, 0xc7, 0x74, 0xf9, 0xe3, 0x0c, 0x2f, 0x3f, 0xc1, 0xb3, 0x4c,
	0xfd, 0xc4, 0xfa, 0xfa, 0xa3, 0xae, 0xa8, 0x3f, 0xc1, 0xc5, 0xe4, 0xed, 0xa0, 0xbe, 0x03, 0xbd,
	0x95, 0xc3, 0xb5, 0x0a, 0xa5, 0xee, 0x3b, 0xf7, 0xca, 0xbe, 0x3c, 0xb3, 0x3b, 0x8e, 0x53, 0xcb,
	0x21, 0x80, 0xad, 0xab, 0xd6, 0xb5, 0x93, 0x8e, 0x57, 0xe7, 0xfa, 0xe4, 0x44, 0x1e, 0xe4, 0xe5,
	0xc1, 0x69, 0xab, 0x2b, 0xe7, 0xee, 0xa6, 0x3c, 0x68, 0x1d, 0x5f, 0xda, 0x72, 0xee, 0x3e, 0x3c,
	0xfe, 0x0e, 0x0e, 0x3c, 0x36, 0x5a, 0x12, 0x8f, 0xca, 0xdb, 0x71, 0x25, 0xbd, 0xa7, 0x5e, 0x12,
	0x11, 0xfe, 0xdf, 0x5c, 0xae, 0xbf, 0xa5, 0x0e, 0x8e, 0xfe, 0x17, 0x00, 0x00, 0xff, 0xff, 0x9d,
	0x31, 0xa9, 0x7d, 0xb0, 0x12, 0x00, 0x00,
}
