// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/genomics/v1alpha2/pipelines.proto
// DO NOT EDIT!

/*
Package google_genomics_v1alpha2 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/genomics/v1alpha2/pipelines.proto

It has these top-level messages:
	ComputeEngine
	RuntimeMetadata
	Pipeline
	CreatePipelineRequest
	RunPipelineArgs
	RunPipelineRequest
	GetPipelineRequest
	ListPipelinesRequest
	ListPipelinesResponse
	DeletePipelineRequest
	GetControllerConfigRequest
	ControllerConfig
	TimestampEvent
	SetOperationStatusRequest
	ServiceAccount
	LoggingOptions
	PipelineResources
	PipelineParameter
	DockerExecutor
*/
package google_genomics_v1alpha2 // import "google.golang.org/genproto/googleapis/genomics/v1alpha2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf3 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf4 "github.com/golang/protobuf/ptypes/timestamp"
import google_rpc1 "google.golang.org/genproto/googleapis/rpc/code"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The types of disks that may be attached to VMs.
type PipelineResources_Disk_Type int32

const (
	// Default disk type. Use one of the other options below.
	PipelineResources_Disk_TYPE_UNSPECIFIED PipelineResources_Disk_Type = 0
	// Specifies a Google Compute Engine persistent hard disk. See
	// https://cloud.google.com/compute/docs/disks/#pdspecs for details.
	PipelineResources_Disk_PERSISTENT_HDD PipelineResources_Disk_Type = 1
	// Specifies a Google Compute Engine persistent solid-state disk. See
	// https://cloud.google.com/compute/docs/disks/#pdspecs for details.
	PipelineResources_Disk_PERSISTENT_SSD PipelineResources_Disk_Type = 2
	// Specifies a Google Compute Engine local SSD.
	// See https://cloud.google.com/compute/docs/disks/local-ssd for details.
	PipelineResources_Disk_LOCAL_SSD PipelineResources_Disk_Type = 3
)

var PipelineResources_Disk_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "PERSISTENT_HDD",
	2: "PERSISTENT_SSD",
	3: "LOCAL_SSD",
}
var PipelineResources_Disk_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"PERSISTENT_HDD":   1,
	"PERSISTENT_SSD":   2,
	"LOCAL_SSD":        3,
}

func (x PipelineResources_Disk_Type) String() string {
	return proto.EnumName(PipelineResources_Disk_Type_name, int32(x))
}
func (PipelineResources_Disk_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{16, 0, 0}
}

// Describes a Compute Engine resource that is being managed by a running
// [pipeline][google.genomics.v1alpha2.Pipeline].
type ComputeEngine struct {
	// The instance on which the operation is running.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName" json:"instance_name,omitempty"`
	// The availability zone in which the instance resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The machine type of the instance.
	MachineType string `protobuf:"bytes,3,opt,name=machine_type,json=machineType" json:"machine_type,omitempty"`
	// The names of the disks that were created for this pipeline.
	DiskNames []string `protobuf:"bytes,4,rep,name=disk_names,json=diskNames" json:"disk_names,omitempty"`
}

func (m *ComputeEngine) Reset()                    { *m = ComputeEngine{} }
func (m *ComputeEngine) String() string            { return proto.CompactTextString(m) }
func (*ComputeEngine) ProtoMessage()               {}
func (*ComputeEngine) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Runtime metadata that will be populated in the
// [runtimeMetadata][google.genomics.v1.OperationMetadata.runtime_metadata]
// field of the Operation associated with a RunPipeline execution.
type RuntimeMetadata struct {
	// Execution information specific to Google Compute Engine.
	ComputeEngine *ComputeEngine `protobuf:"bytes,1,opt,name=compute_engine,json=computeEngine" json:"compute_engine,omitempty"`
}

func (m *RuntimeMetadata) Reset()                    { *m = RuntimeMetadata{} }
func (m *RuntimeMetadata) String() string            { return proto.CompactTextString(m) }
func (*RuntimeMetadata) ProtoMessage()               {}
func (*RuntimeMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *RuntimeMetadata) GetComputeEngine() *ComputeEngine {
	if m != nil {
		return m.ComputeEngine
	}
	return nil
}

// The pipeline object. Represents a transformation from a set of input
// parameters to a set of output parameters. The transformation is defined
// as a docker image and command to run within that image. Each pipeline
// is run on a Google Compute Engine VM. A pipeline can be created with the
// `create` method and then later run with the `run` method, or a pipeline can
// be defined and run all at once with the `run` method.
type Pipeline struct {
	// Required. The project in which to create the pipeline. The caller must have
	// WRITE access.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. A user specified pipeline name that does not have to be unique.
	// This name can be used for filtering Pipelines in ListPipelines.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// User-specified description.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// Input parameters of the pipeline.
	InputParameters []*PipelineParameter `protobuf:"bytes,8,rep,name=input_parameters,json=inputParameters" json:"input_parameters,omitempty"`
	// Output parameters of the pipeline.
	OutputParameters []*PipelineParameter `protobuf:"bytes,9,rep,name=output_parameters,json=outputParameters" json:"output_parameters,omitempty"`
	// Required. The executor indicates in which environment the pipeline runs.
	//
	// Types that are valid to be assigned to Executor:
	//	*Pipeline_Docker
	Executor isPipeline_Executor `protobuf_oneof:"executor"`
	// Required. Specifies resource requirements for the pipeline run.
	// Required fields:
	//
	// *
	// [minimumCpuCores][google.genomics.v1alpha2.PipelineResources.minimum_cpu_cores]
	//
	// *
	// [minimumRamGb][google.genomics.v1alpha2.PipelineResources.minimum_ram_gb]
	Resources *PipelineResources `protobuf:"bytes,6,opt,name=resources" json:"resources,omitempty"`
	// Unique pipeline id that is generated by the service when CreatePipeline
	// is called. Cannot be specified in the Pipeline used in the
	// CreatePipelineRequest, and will be populated in the response to
	// CreatePipeline and all subsequent Get and List calls. Indicates that the
	// service has registered this pipeline.
	PipelineId string `protobuf:"bytes,7,opt,name=pipeline_id,json=pipelineId" json:"pipeline_id,omitempty"`
}

func (m *Pipeline) Reset()                    { *m = Pipeline{} }
func (m *Pipeline) String() string            { return proto.CompactTextString(m) }
func (*Pipeline) ProtoMessage()               {}
func (*Pipeline) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type isPipeline_Executor interface {
	isPipeline_Executor()
}

type Pipeline_Docker struct {
	Docker *DockerExecutor `protobuf:"bytes,5,opt,name=docker,oneof"`
}

func (*Pipeline_Docker) isPipeline_Executor() {}

func (m *Pipeline) GetExecutor() isPipeline_Executor {
	if m != nil {
		return m.Executor
	}
	return nil
}

func (m *Pipeline) GetInputParameters() []*PipelineParameter {
	if m != nil {
		return m.InputParameters
	}
	return nil
}

func (m *Pipeline) GetOutputParameters() []*PipelineParameter {
	if m != nil {
		return m.OutputParameters
	}
	return nil
}

func (m *Pipeline) GetDocker() *DockerExecutor {
	if x, ok := m.GetExecutor().(*Pipeline_Docker); ok {
		return x.Docker
	}
	return nil
}

func (m *Pipeline) GetResources() *PipelineResources {
	if m != nil {
		return m.Resources
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Pipeline) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Pipeline_OneofMarshaler, _Pipeline_OneofUnmarshaler, _Pipeline_OneofSizer, []interface{}{
		(*Pipeline_Docker)(nil),
	}
}

func _Pipeline_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Pipeline)
	// executor
	switch x := m.Executor.(type) {
	case *Pipeline_Docker:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Docker); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Pipeline.Executor has unexpected type %T", x)
	}
	return nil
}

func _Pipeline_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Pipeline)
	switch tag {
	case 5: // executor.docker
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DockerExecutor)
		err := b.DecodeMessage(msg)
		m.Executor = &Pipeline_Docker{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Pipeline_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Pipeline)
	// executor
	switch x := m.Executor.(type) {
	case *Pipeline_Docker:
		s := proto.Size(x.Docker)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The request to create a pipeline. The pipeline field here should not have
// `pipelineId` populated, as that will be populated by the server.
type CreatePipelineRequest struct {
	// The pipeline to create. Should not have `pipelineId` populated.
	Pipeline *Pipeline `protobuf:"bytes,1,opt,name=pipeline" json:"pipeline,omitempty"`
}

func (m *CreatePipelineRequest) Reset()                    { *m = CreatePipelineRequest{} }
func (m *CreatePipelineRequest) String() string            { return proto.CompactTextString(m) }
func (*CreatePipelineRequest) ProtoMessage()               {}
func (*CreatePipelineRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *CreatePipelineRequest) GetPipeline() *Pipeline {
	if m != nil {
		return m.Pipeline
	}
	return nil
}

// The pipeline run arguments.
type RunPipelineArgs struct {
	// Required. The project in which to run the pipeline. The caller must have
	// WRITER access to all Google Cloud services and resources (e.g. Google
	// Compute Engine) will be used.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Pipeline input arguments; keys are defined in the pipeline documentation.
	// All input parameters that do not have default values  must be specified.
	// If parameters with defaults are specified here, the defaults will be
	// overridden.
	Inputs map[string]string `protobuf:"bytes,2,rep,name=inputs" json:"inputs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Pipeline output arguments; keys are defined in the pipeline
	// documentation.  All output parameters of without default values
	// must be specified.  If parameters with defaults are specified
	// here, the defaults will be overridden.
	Outputs map[string]string `protobuf:"bytes,3,rep,name=outputs" json:"outputs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The Google Cloud Service Account that will be used to access data and
	// services. By default, the compute service account associated with
	// `projectId` is used.
	ServiceAccount *ServiceAccount `protobuf:"bytes,4,opt,name=service_account,json=serviceAccount" json:"service_account,omitempty"`
	// Client-specified pipeline operation identifier.
	ClientId string `protobuf:"bytes,5,opt,name=client_id,json=clientId" json:"client_id,omitempty"`
	// Specifies resource requirements/overrides for the pipeline run.
	Resources *PipelineResources `protobuf:"bytes,6,opt,name=resources" json:"resources,omitempty"`
	// Required. Logging options. Used by the service to communicate results
	// to the user.
	Logging *LoggingOptions `protobuf:"bytes,7,opt,name=logging" json:"logging,omitempty"`
	// How long to keep the VM up after a failure (for example docker command
	// failed, copying input or output files failed, etc). While the VM is up, one
	// can ssh into the VM to debug. Default is 0; maximum allowed value is 1 day.
	KeepVmAliveOnFailureDuration *google_protobuf3.Duration `protobuf:"bytes,8,opt,name=keep_vm_alive_on_failure_duration,json=keepVmAliveOnFailureDuration" json:"keep_vm_alive_on_failure_duration,omitempty"`
}

func (m *RunPipelineArgs) Reset()                    { *m = RunPipelineArgs{} }
func (m *RunPipelineArgs) String() string            { return proto.CompactTextString(m) }
func (*RunPipelineArgs) ProtoMessage()               {}
func (*RunPipelineArgs) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *RunPipelineArgs) GetInputs() map[string]string {
	if m != nil {
		return m.Inputs
	}
	return nil
}

func (m *RunPipelineArgs) GetOutputs() map[string]string {
	if m != nil {
		return m.Outputs
	}
	return nil
}

func (m *RunPipelineArgs) GetServiceAccount() *ServiceAccount {
	if m != nil {
		return m.ServiceAccount
	}
	return nil
}

func (m *RunPipelineArgs) GetResources() *PipelineResources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *RunPipelineArgs) GetLogging() *LoggingOptions {
	if m != nil {
		return m.Logging
	}
	return nil
}

func (m *RunPipelineArgs) GetKeepVmAliveOnFailureDuration() *google_protobuf3.Duration {
	if m != nil {
		return m.KeepVmAliveOnFailureDuration
	}
	return nil
}

// The request to run a pipeline. If `pipelineId` is specified, it
// refers to a saved pipeline created with CreatePipeline and set as
// the `pipelineId` of the returned Pipeline object. If
// `ephemeralPipeline` is specified, that pipeline is run once
// with the given args and not saved. It is an error to specify both
// `pipelineId` and `ephemeralPipeline`. `pipelineArgs`
// must be specified.
type RunPipelineRequest struct {
	// Types that are valid to be assigned to Pipeline:
	//	*RunPipelineRequest_PipelineId
	//	*RunPipelineRequest_EphemeralPipeline
	Pipeline isRunPipelineRequest_Pipeline `protobuf_oneof:"pipeline"`
	// The arguments to use when running this pipeline.
	PipelineArgs *RunPipelineArgs `protobuf:"bytes,3,opt,name=pipeline_args,json=pipelineArgs" json:"pipeline_args,omitempty"`
}

func (m *RunPipelineRequest) Reset()                    { *m = RunPipelineRequest{} }
func (m *RunPipelineRequest) String() string            { return proto.CompactTextString(m) }
func (*RunPipelineRequest) ProtoMessage()               {}
func (*RunPipelineRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type isRunPipelineRequest_Pipeline interface {
	isRunPipelineRequest_Pipeline()
}

type RunPipelineRequest_PipelineId struct {
	PipelineId string `protobuf:"bytes,1,opt,name=pipeline_id,json=pipelineId,oneof"`
}
type RunPipelineRequest_EphemeralPipeline struct {
	EphemeralPipeline *Pipeline `protobuf:"bytes,2,opt,name=ephemeral_pipeline,json=ephemeralPipeline,oneof"`
}

func (*RunPipelineRequest_PipelineId) isRunPipelineRequest_Pipeline()        {}
func (*RunPipelineRequest_EphemeralPipeline) isRunPipelineRequest_Pipeline() {}

func (m *RunPipelineRequest) GetPipeline() isRunPipelineRequest_Pipeline {
	if m != nil {
		return m.Pipeline
	}
	return nil
}

func (m *RunPipelineRequest) GetPipelineId() string {
	if x, ok := m.GetPipeline().(*RunPipelineRequest_PipelineId); ok {
		return x.PipelineId
	}
	return ""
}

func (m *RunPipelineRequest) GetEphemeralPipeline() *Pipeline {
	if x, ok := m.GetPipeline().(*RunPipelineRequest_EphemeralPipeline); ok {
		return x.EphemeralPipeline
	}
	return nil
}

func (m *RunPipelineRequest) GetPipelineArgs() *RunPipelineArgs {
	if m != nil {
		return m.PipelineArgs
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RunPipelineRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RunPipelineRequest_OneofMarshaler, _RunPipelineRequest_OneofUnmarshaler, _RunPipelineRequest_OneofSizer, []interface{}{
		(*RunPipelineRequest_PipelineId)(nil),
		(*RunPipelineRequest_EphemeralPipeline)(nil),
	}
}

func _RunPipelineRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RunPipelineRequest)
	// pipeline
	switch x := m.Pipeline.(type) {
	case *RunPipelineRequest_PipelineId:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.PipelineId)
	case *RunPipelineRequest_EphemeralPipeline:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EphemeralPipeline); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RunPipelineRequest.Pipeline has unexpected type %T", x)
	}
	return nil
}

func _RunPipelineRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RunPipelineRequest)
	switch tag {
	case 1: // pipeline.pipeline_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Pipeline = &RunPipelineRequest_PipelineId{x}
		return true, err
	case 2: // pipeline.ephemeral_pipeline
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Pipeline)
		err := b.DecodeMessage(msg)
		m.Pipeline = &RunPipelineRequest_EphemeralPipeline{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RunPipelineRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RunPipelineRequest)
	// pipeline
	switch x := m.Pipeline.(type) {
	case *RunPipelineRequest_PipelineId:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.PipelineId)))
		n += len(x.PipelineId)
	case *RunPipelineRequest_EphemeralPipeline:
		s := proto.Size(x.EphemeralPipeline)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A request to get a saved pipeline by id.
type GetPipelineRequest struct {
	// Caller must have READ access to the project in which this pipeline
	// is defined.
	PipelineId string `protobuf:"bytes,1,opt,name=pipeline_id,json=pipelineId" json:"pipeline_id,omitempty"`
}

func (m *GetPipelineRequest) Reset()                    { *m = GetPipelineRequest{} }
func (m *GetPipelineRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPipelineRequest) ProtoMessage()               {}
func (*GetPipelineRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

// A request to list pipelines in a given project. Pipelines can be
// filtered by name using `namePrefix`: all pipelines with names that
// begin with `namePrefix` will be returned. Uses standard pagination:
// `pageSize` indicates how many pipelines to return, and
// `pageToken` comes from a previous ListPipelinesResponse to
// indicate offset.
type ListPipelinesRequest struct {
	// Required. The name of the project to search for pipelines. Caller
	// must have READ access to this project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Pipelines with names that match this prefix should be
	// returned.  If unspecified, all pipelines in the project, up to
	// `pageSize`, will be returned.
	NamePrefix string `protobuf:"bytes,2,opt,name=name_prefix,json=namePrefix" json:"name_prefix,omitempty"`
	// Number of pipelines to return at once. Defaults to 256, and max
	// is 2048.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Token to use to indicate where to start getting results.
	// If unspecified, returns the first page of results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListPipelinesRequest) Reset()                    { *m = ListPipelinesRequest{} }
func (m *ListPipelinesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListPipelinesRequest) ProtoMessage()               {}
func (*ListPipelinesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

// The response of ListPipelines. Contains at most `pageSize`
// pipelines. If it contains `pageSize` pipelines, and more pipelines
// exist, then `nextPageToken` will be populated and should be
// used as the `pageToken` argument to a subsequent ListPipelines
// request.
type ListPipelinesResponse struct {
	// The matched pipelines.
	Pipelines []*Pipeline `protobuf:"bytes,1,rep,name=pipelines" json:"pipelines,omitempty"`
	// The token to use to get the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListPipelinesResponse) Reset()                    { *m = ListPipelinesResponse{} }
func (m *ListPipelinesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListPipelinesResponse) ProtoMessage()               {}
func (*ListPipelinesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ListPipelinesResponse) GetPipelines() []*Pipeline {
	if m != nil {
		return m.Pipelines
	}
	return nil
}

// The request to delete a saved pipeline by ID.
type DeletePipelineRequest struct {
	// Caller must have WRITE access to the project in which this pipeline
	// is defined.
	PipelineId string `protobuf:"bytes,1,opt,name=pipeline_id,json=pipelineId" json:"pipeline_id,omitempty"`
}

func (m *DeletePipelineRequest) Reset()                    { *m = DeletePipelineRequest{} }
func (m *DeletePipelineRequest) String() string            { return proto.CompactTextString(m) }
func (*DeletePipelineRequest) ProtoMessage()               {}
func (*DeletePipelineRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

// Request to get controller configuation.  Should only be used
// by VMs created by the Pipelines Service and not by end users.
type GetControllerConfigRequest struct {
	// The operation to retrieve controller configuration for.
	OperationId     string `protobuf:"bytes,1,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	ValidationToken uint64 `protobuf:"varint,2,opt,name=validation_token,json=validationToken" json:"validation_token,omitempty"`
}

func (m *GetControllerConfigRequest) Reset()                    { *m = GetControllerConfigRequest{} }
func (m *GetControllerConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*GetControllerConfigRequest) ProtoMessage()               {}
func (*GetControllerConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

// Stores the information that the controller will fetch from the
// server in order to run. Should only be used by VMs created by the
// Pipelines Service and not by end users.
type ControllerConfig struct {
	Image       string                                      `protobuf:"bytes,1,opt,name=image" json:"image,omitempty"`
	Cmd         string                                      `protobuf:"bytes,2,opt,name=cmd" json:"cmd,omitempty"`
	GcsLogPath  string                                      `protobuf:"bytes,3,opt,name=gcs_log_path,json=gcsLogPath" json:"gcs_log_path,omitempty"`
	MachineType string                                      `protobuf:"bytes,4,opt,name=machine_type,json=machineType" json:"machine_type,omitempty"`
	Vars        map[string]string                           `protobuf:"bytes,5,rep,name=vars" json:"vars,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Disks       map[string]string                           `protobuf:"bytes,6,rep,name=disks" json:"disks,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	GcsSources  map[string]*ControllerConfig_RepeatedString `protobuf:"bytes,7,rep,name=gcs_sources,json=gcsSources" json:"gcs_sources,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	GcsSinks    map[string]*ControllerConfig_RepeatedString `protobuf:"bytes,8,rep,name=gcs_sinks,json=gcsSinks" json:"gcs_sinks,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ControllerConfig) Reset()                    { *m = ControllerConfig{} }
func (m *ControllerConfig) String() string            { return proto.CompactTextString(m) }
func (*ControllerConfig) ProtoMessage()               {}
func (*ControllerConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *ControllerConfig) GetVars() map[string]string {
	if m != nil {
		return m.Vars
	}
	return nil
}

func (m *ControllerConfig) GetDisks() map[string]string {
	if m != nil {
		return m.Disks
	}
	return nil
}

func (m *ControllerConfig) GetGcsSources() map[string]*ControllerConfig_RepeatedString {
	if m != nil {
		return m.GcsSources
	}
	return nil
}

func (m *ControllerConfig) GetGcsSinks() map[string]*ControllerConfig_RepeatedString {
	if m != nil {
		return m.GcsSinks
	}
	return nil
}

type ControllerConfig_RepeatedString struct {
	Values []string `protobuf:"bytes,1,rep,name=values" json:"values,omitempty"`
}

func (m *ControllerConfig_RepeatedString) Reset()         { *m = ControllerConfig_RepeatedString{} }
func (m *ControllerConfig_RepeatedString) String() string { return proto.CompactTextString(m) }
func (*ControllerConfig_RepeatedString) ProtoMessage()    {}
func (*ControllerConfig_RepeatedString) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{11, 0}
}

// Stores the list of events and times they occured for major events in job
// execution.
type TimestampEvent struct {
	// String indicating the type of event
	Description string `protobuf:"bytes,1,opt,name=description" json:"description,omitempty"`
	// The time this event occured.
	Timestamp *google_protobuf4.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *TimestampEvent) Reset()                    { *m = TimestampEvent{} }
func (m *TimestampEvent) String() string            { return proto.CompactTextString(m) }
func (*TimestampEvent) ProtoMessage()               {}
func (*TimestampEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *TimestampEvent) GetTimestamp() *google_protobuf4.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

// Request to set operation status. Should only be used by VMs
// created by the Pipelines Service and not by end users.
type SetOperationStatusRequest struct {
	OperationId     string            `protobuf:"bytes,1,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	TimestampEvents []*TimestampEvent `protobuf:"bytes,2,rep,name=timestamp_events,json=timestampEvents" json:"timestamp_events,omitempty"`
	ErrorCode       google_rpc1.Code  `protobuf:"varint,3,opt,name=error_code,json=errorCode,enum=google.rpc.Code" json:"error_code,omitempty"`
	ErrorMessage    string            `protobuf:"bytes,4,opt,name=error_message,json=errorMessage" json:"error_message,omitempty"`
	ValidationToken uint64            `protobuf:"varint,5,opt,name=validation_token,json=validationToken" json:"validation_token,omitempty"`
}

func (m *SetOperationStatusRequest) Reset()                    { *m = SetOperationStatusRequest{} }
func (m *SetOperationStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*SetOperationStatusRequest) ProtoMessage()               {}
func (*SetOperationStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *SetOperationStatusRequest) GetTimestampEvents() []*TimestampEvent {
	if m != nil {
		return m.TimestampEvents
	}
	return nil
}

// A Google Cloud Service Account.
type ServiceAccount struct {
	// Email address of the service account. Defaults to `default`,
	// which uses the compute service account associated with the project.
	Email string `protobuf:"bytes,1,opt,name=email" json:"email,omitempty"`
	// List of scopes to be enabled for this service account on the
	// pipeline virtual machine.
	// The following scopes are automatically included:
	// * https://www.googleapis.com/auth/genomics
	// * https://www.googleapis.com/auth/compute
	// * https://www.googleapis.com/auth/devstorage.full_control
	Scopes []string `protobuf:"bytes,2,rep,name=scopes" json:"scopes,omitempty"`
}

func (m *ServiceAccount) Reset()                    { *m = ServiceAccount{} }
func (m *ServiceAccount) String() string            { return proto.CompactTextString(m) }
func (*ServiceAccount) ProtoMessage()               {}
func (*ServiceAccount) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

// The logging options for the pipeline run.
type LoggingOptions struct {
	// The location in Google Cloud Storage to which the pipeline logs
	// will be copied. Can be specified as a fully qualified directory
	// path, in which case logs will be output with a unique identifier
	// as the filename in that directory, or as a fully specified path,
	// which must end in `.log`, in which case that path will be
	// used, and the user must ensure that logs are not
	// overwritten. Stdout and stderr logs from the run are also
	// generated and output as `-stdout.log` and `-stderr.log`.
	GcsPath string `protobuf:"bytes,1,opt,name=gcs_path,json=gcsPath" json:"gcs_path,omitempty"`
}

func (m *LoggingOptions) Reset()                    { *m = LoggingOptions{} }
func (m *LoggingOptions) String() string            { return proto.CompactTextString(m) }
func (*LoggingOptions) ProtoMessage()               {}
func (*LoggingOptions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

// The system resources for the pipeline run.
type PipelineResources struct {
	// The minimum number of cores to use. Defaults to 1.
	MinimumCpuCores int32 `protobuf:"varint,1,opt,name=minimum_cpu_cores,json=minimumCpuCores" json:"minimum_cpu_cores,omitempty"`
	// At create time means that preemptible machines may be
	// used for the run. At run time, means they should be used. Cannot
	// be true at run time if false at create time.
	// Defaults to `false`.
	Preemptible bool `protobuf:"varint,2,opt,name=preemptible" json:"preemptible,omitempty"`
	// The minimum amount of RAM to use. Defaults to 3.75 (GB)
	MinimumRamGb float64 `protobuf:"fixed64,3,opt,name=minimum_ram_gb,json=minimumRamGb" json:"minimum_ram_gb,omitempty"`
	// Disks to attach.
	Disks []*PipelineResources_Disk `protobuf:"bytes,4,rep,name=disks" json:"disks,omitempty"`
	// List of Google Compute Engine availability zones to which resource
	// creation will restricted. If empty, any zone may be chosen.
	Zones []string `protobuf:"bytes,5,rep,name=zones" json:"zones,omitempty"`
	// The size of the boot disk. Defaults to 10 (GB).
	BootDiskSizeGb int32 `protobuf:"varint,6,opt,name=boot_disk_size_gb,json=bootDiskSizeGb" json:"boot_disk_size_gb,omitempty"`
}

func (m *PipelineResources) Reset()                    { *m = PipelineResources{} }
func (m *PipelineResources) String() string            { return proto.CompactTextString(m) }
func (*PipelineResources) ProtoMessage()               {}
func (*PipelineResources) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *PipelineResources) GetDisks() []*PipelineResources_Disk {
	if m != nil {
		return m.Disks
	}
	return nil
}

// A Google Compute Engine disk resource specification.
type PipelineResources_Disk struct {
	// Required. The name of the disk that can be used in the pipeline
	// parameters. Must be 1 - 63 characters.
	// The name "boot" is reserved for system use.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Required. The type of the disk to create.
	Type PipelineResources_Disk_Type `protobuf:"varint,2,opt,name=type,enum=google.genomics.v1alpha2.PipelineResources_Disk_Type" json:"type,omitempty"`
	// The size of the disk. Defaults to 500 (GB).
	// This field is not applicable for local SSD.
	SizeGb int32 `protobuf:"varint,3,opt,name=size_gb,json=sizeGb" json:"size_gb,omitempty"`
	// The full or partial URL of the persistent disk to attach. See
	// https://cloud.google.com/compute/docs/reference/latest/instances#resource
	// and
	// https://cloud.google.com/compute/docs/disks/persistent-disks#snapshots
	// for more details.
	Source string `protobuf:"bytes,4,opt,name=source" json:"source,omitempty"`
	// Specifies whether or not to delete the disk when the pipeline
	// completes. This field is applicable only for newly created disks. See
	// https://cloud.google.com/compute/docs/reference/latest/instances#resource
	// for more details.
	// By default, `autoDelete` is `false`. `autoDelete` will be enabled if set
	// to `true` at create time or run time.
	AutoDelete bool `protobuf:"varint,6,opt,name=auto_delete,json=autoDelete" json:"auto_delete,omitempty"`
	// Specifies how a sourced-base persistent disk will be mounted. See
	// https://cloud.google.com/compute/docs/disks/persistent-disks#use_multi_instances
	// for more details.
	// Can only be set at create time.
	ReadOnly bool `protobuf:"varint,7,opt,name=read_only,json=readOnly" json:"read_only,omitempty"`
	// Required at create time and cannot be overridden at run time.
	// Specifies the path in the docker container where files on
	// this disk should be located. For example, if `mountPoint`
	// is `/mnt/disk`, and the parameter has `localPath`
	// `inputs/file.txt`, the docker container can access the data at
	// `/mnt/disk/inputs/file.txt`.
	MountPoint string `protobuf:"bytes,8,opt,name=mount_point,json=mountPoint" json:"mount_point,omitempty"`
}

func (m *PipelineResources_Disk) Reset()                    { *m = PipelineResources_Disk{} }
func (m *PipelineResources_Disk) String() string            { return proto.CompactTextString(m) }
func (*PipelineResources_Disk) ProtoMessage()               {}
func (*PipelineResources_Disk) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16, 0} }

// Parameters facilitate setting and delivering data into the
// pipeline's execution environment. They are defined at create time,
// with optional defaults, and can be overridden at run time.
//
// If `localCopy` is unset, then the parameter specifies a string that
// is passed as-is into the pipeline, as the value of the environment
// variable with the given name.  A default value can be optionally
// specified at create time. The default can be overridden at run time
// using the inputs map. If no default is given, a value must be
// supplied at runtime.
//
// If `localCopy` is defined, then the parameter specifies a data
// source or sink, both in Google Cloud Storage and on the Docker container
// where the pipeline computation is run. The [service account associated with
// the Pipeline][google.genomics.v1alpha2.RunPipelineArgs.service_account] (by
// default the project's Compute Engine service account) must have access to the
// Google Cloud Storage paths.
//
// At run time, the Google Cloud Storage paths can be overridden if a default
// was provided at create time, or must be set otherwise. The pipeline runner
// should add a key/value pair to either the inputs or outputs map. The
// indicated data copies will be carried out before/after pipeline execution,
// just as if the corresponding arguments were provided to `gsutil cp`.
//
// For example: Given the following `PipelineParameter`, specified
// in the `inputParameters` list:
//
// ```
// {name: "input_file", localCopy: {path: "file.txt", disk: "pd1"}}
// ```
//
// where `disk` is defined in the `PipelineResources` object as:
//
// ```
// {name: "pd1", mountPoint: "/mnt/disk/"}
// ```
//
// We create a disk named `pd1`, mount it on the host VM, and map
// `/mnt/pd1` to `/mnt/disk` in the docker container.  At
// runtime, an entry for `input_file` would be required in the inputs
// map, such as:
//
// ```
//   inputs["input_file"] = "gs://my-bucket/bar.txt"
// ```
//
// This would generate the following gsutil call:
//
// ```
//   gsutil cp gs://my-bucket/bar.txt /mnt/pd1/file.txt
// ```
//
// The file `/mnt/pd1/file.txt` maps to `/mnt/disk/file.txt` in the
// Docker container. Acceptable paths are:
//
// <table>
//   <thead>
//     <tr><th>Google Cloud storage path</th><th>Local path</th></tr>
//   </thead>
//   <tbody>
//     <tr><td>file</td><td>file</td></tr>
//     <tr><td>glob</td><td>directory</td></tr>
//   </tbody>
// </table>
//
// For outputs, the direction of the copy is reversed:
//
// ```
//   gsutil cp /mnt/disk/file.txt gs://my-bucket/bar.txt
// ```
//
// Acceptable paths are:
//
// <table>
//   <thead>
//     <tr><th>Local path</th><th>Google Cloud Storage path</th></tr>
//   </thead>
//   <tbody>
//     <tr><td>file</td><td>file</td></tr>
//     <tr>
//       <td>file</td>
//       <td>directory - directory must already exist</td>
//     </tr>
//     <tr>
//       <td>glob</td>
//       <td>directory - directory will be created if it doesn't exist</td></tr>
//   </tbody>
// </table>
//
// One restriction due to docker limitations, is that for outputs that are found
// on the boot disk, the local path cannot be a glob and must be a file.
type PipelineParameter struct {
	// Required. Name of the parameter - the pipeline runner uses this string
	// as the key to the input and output maps in RunPipeline.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Human-readable description.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// The default value for this parameter. Can be overridden at runtime.
	// If `localCopy` is present, then this must be a Google Cloud Storage path
	// beginning with `gs://`.
	DefaultValue string `protobuf:"bytes,5,opt,name=default_value,json=defaultValue" json:"default_value,omitempty"`
	// If present, this parameter is marked for copying to and from the VM.
	// `LocalCopy` indicates where on the VM the file should be. The value
	// given to this parameter (either at runtime or using `defaultValue`)
	// must be the remote path where the file should be.
	LocalCopy *PipelineParameter_LocalCopy `protobuf:"bytes,6,opt,name=local_copy,json=localCopy" json:"local_copy,omitempty"`
}

func (m *PipelineParameter) Reset()                    { *m = PipelineParameter{} }
func (m *PipelineParameter) String() string            { return proto.CompactTextString(m) }
func (*PipelineParameter) ProtoMessage()               {}
func (*PipelineParameter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *PipelineParameter) GetLocalCopy() *PipelineParameter_LocalCopy {
	if m != nil {
		return m.LocalCopy
	}
	return nil
}

// LocalCopy defines how a remote file should be copied to and from the VM.
type PipelineParameter_LocalCopy struct {
	// Required. The path within the user's docker container where
	// this input should be localized to and from, relative to the specified
	// disk's mount point. For example: file.txt,
	Path string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	// Required. The name of the disk where this parameter is
	// located. Can be the name of one of the disks specified in the
	// Resources field, or "boot", which represents the Docker
	// instance's boot disk and has a mount point of `/`.
	Disk string `protobuf:"bytes,2,opt,name=disk" json:"disk,omitempty"`
}

func (m *PipelineParameter_LocalCopy) Reset()                    { *m = PipelineParameter_LocalCopy{} }
func (m *PipelineParameter_LocalCopy) String() string            { return proto.CompactTextString(m) }
func (*PipelineParameter_LocalCopy) ProtoMessage()               {}
func (*PipelineParameter_LocalCopy) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17, 0} }

// The Docker execuctor specification.
type DockerExecutor struct {
	// Required. Image name from either Docker Hub or Google Container Repository.
	// Users that run pipelines must have READ access to the image.
	ImageName string `protobuf:"bytes,1,opt,name=image_name,json=imageName" json:"image_name,omitempty"`
	// Required. The command string to run. Parameters that do not have
	// `localCopy` specified should be used as environment variables, while
	// those that do can be accessed at the defined paths.
	Cmd string `protobuf:"bytes,2,opt,name=cmd" json:"cmd,omitempty"`
}

func (m *DockerExecutor) Reset()                    { *m = DockerExecutor{} }
func (m *DockerExecutor) String() string            { return proto.CompactTextString(m) }
func (*DockerExecutor) ProtoMessage()               {}
func (*DockerExecutor) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func init() {
	proto.RegisterType((*ComputeEngine)(nil), "google.genomics.v1alpha2.ComputeEngine")
	proto.RegisterType((*RuntimeMetadata)(nil), "google.genomics.v1alpha2.RuntimeMetadata")
	proto.RegisterType((*Pipeline)(nil), "google.genomics.v1alpha2.Pipeline")
	proto.RegisterType((*CreatePipelineRequest)(nil), "google.genomics.v1alpha2.CreatePipelineRequest")
	proto.RegisterType((*RunPipelineArgs)(nil), "google.genomics.v1alpha2.RunPipelineArgs")
	proto.RegisterType((*RunPipelineRequest)(nil), "google.genomics.v1alpha2.RunPipelineRequest")
	proto.RegisterType((*GetPipelineRequest)(nil), "google.genomics.v1alpha2.GetPipelineRequest")
	proto.RegisterType((*ListPipelinesRequest)(nil), "google.genomics.v1alpha2.ListPipelinesRequest")
	proto.RegisterType((*ListPipelinesResponse)(nil), "google.genomics.v1alpha2.ListPipelinesResponse")
	proto.RegisterType((*DeletePipelineRequest)(nil), "google.genomics.v1alpha2.DeletePipelineRequest")
	proto.RegisterType((*GetControllerConfigRequest)(nil), "google.genomics.v1alpha2.GetControllerConfigRequest")
	proto.RegisterType((*ControllerConfig)(nil), "google.genomics.v1alpha2.ControllerConfig")
	proto.RegisterType((*ControllerConfig_RepeatedString)(nil), "google.genomics.v1alpha2.ControllerConfig.RepeatedString")
	proto.RegisterType((*TimestampEvent)(nil), "google.genomics.v1alpha2.TimestampEvent")
	proto.RegisterType((*SetOperationStatusRequest)(nil), "google.genomics.v1alpha2.SetOperationStatusRequest")
	proto.RegisterType((*ServiceAccount)(nil), "google.genomics.v1alpha2.ServiceAccount")
	proto.RegisterType((*LoggingOptions)(nil), "google.genomics.v1alpha2.LoggingOptions")
	proto.RegisterType((*PipelineResources)(nil), "google.genomics.v1alpha2.PipelineResources")
	proto.RegisterType((*PipelineResources_Disk)(nil), "google.genomics.v1alpha2.PipelineResources.Disk")
	proto.RegisterType((*PipelineParameter)(nil), "google.genomics.v1alpha2.PipelineParameter")
	proto.RegisterType((*PipelineParameter_LocalCopy)(nil), "google.genomics.v1alpha2.PipelineParameter.LocalCopy")
	proto.RegisterType((*DockerExecutor)(nil), "google.genomics.v1alpha2.DockerExecutor")
	proto.RegisterEnum("google.genomics.v1alpha2.PipelineResources_Disk_Type", PipelineResources_Disk_Type_name, PipelineResources_Disk_Type_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for PipelinesV1Alpha2 service

type PipelinesV1Alpha2Client interface {
	// Creates a pipeline that can be run later. Create takes a Pipeline that
	// has all fields other than `pipelineId` populated, and then returns
	// the same pipeline with `pipelineId` populated. This id can be used
	// to run the pipeline.
	//
	// Caller must have WRITE permission to the project.
	CreatePipeline(ctx context.Context, in *CreatePipelineRequest, opts ...grpc.CallOption) (*Pipeline, error)
	// Runs a pipeline. If `pipelineId` is specified in the request, then
	// run a saved pipeline. If `ephemeralPipeline` is specified, then run
	// that pipeline once without saving a copy.
	//
	// The caller must have READ permission to the project where the pipeline
	// is stored and WRITE permission to the project where the pipeline will be
	// run, as VMs will be created and storage will be used.
	RunPipeline(ctx context.Context, in *RunPipelineRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Retrieves a pipeline based on ID.
	//
	// Caller must have READ permission to the project.
	GetPipeline(ctx context.Context, in *GetPipelineRequest, opts ...grpc.CallOption) (*Pipeline, error)
	// Lists pipelines.
	//
	// Caller must have READ permission to the project.
	ListPipelines(ctx context.Context, in *ListPipelinesRequest, opts ...grpc.CallOption) (*ListPipelinesResponse, error)
	// Deletes a pipeline based on ID.
	//
	// Caller must have WRITE permission to the project.
	DeletePipeline(ctx context.Context, in *DeletePipelineRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
	// Gets controller configuration information. Should only be called
	// by VMs created by the Pipelines Service and not by end users.
	GetControllerConfig(ctx context.Context, in *GetControllerConfigRequest, opts ...grpc.CallOption) (*ControllerConfig, error)
	// Sets status of a given operation. All timestamps are sent on each
	// call, and the whole series of events is replaced, in case
	// intermediate calls are lost. Should only be called by VMs created
	// by the Pipelines Service and not by end users.
	SetOperationStatus(ctx context.Context, in *SetOperationStatusRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
}

type pipelinesV1Alpha2Client struct {
	cc *grpc.ClientConn
}

func NewPipelinesV1Alpha2Client(cc *grpc.ClientConn) PipelinesV1Alpha2Client {
	return &pipelinesV1Alpha2Client{cc}
}

func (c *pipelinesV1Alpha2Client) CreatePipeline(ctx context.Context, in *CreatePipelineRequest, opts ...grpc.CallOption) (*Pipeline, error) {
	out := new(Pipeline)
	err := grpc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/CreatePipeline", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) RunPipeline(ctx context.Context, in *RunPipelineRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/RunPipeline", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) GetPipeline(ctx context.Context, in *GetPipelineRequest, opts ...grpc.CallOption) (*Pipeline, error) {
	out := new(Pipeline)
	err := grpc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/GetPipeline", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) ListPipelines(ctx context.Context, in *ListPipelinesRequest, opts ...grpc.CallOption) (*ListPipelinesResponse, error) {
	out := new(ListPipelinesResponse)
	err := grpc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/ListPipelines", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) DeletePipeline(ctx context.Context, in *DeletePipelineRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/DeletePipeline", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) GetControllerConfig(ctx context.Context, in *GetControllerConfigRequest, opts ...grpc.CallOption) (*ControllerConfig, error) {
	out := new(ControllerConfig)
	err := grpc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/GetControllerConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pipelinesV1Alpha2Client) SetOperationStatus(ctx context.Context, in *SetOperationStatusRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1alpha2.PipelinesV1Alpha2/SetOperationStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for PipelinesV1Alpha2 service

type PipelinesV1Alpha2Server interface {
	// Creates a pipeline that can be run later. Create takes a Pipeline that
	// has all fields other than `pipelineId` populated, and then returns
	// the same pipeline with `pipelineId` populated. This id can be used
	// to run the pipeline.
	//
	// Caller must have WRITE permission to the project.
	CreatePipeline(context.Context, *CreatePipelineRequest) (*Pipeline, error)
	// Runs a pipeline. If `pipelineId` is specified in the request, then
	// run a saved pipeline. If `ephemeralPipeline` is specified, then run
	// that pipeline once without saving a copy.
	//
	// The caller must have READ permission to the project where the pipeline
	// is stored and WRITE permission to the project where the pipeline will be
	// run, as VMs will be created and storage will be used.
	RunPipeline(context.Context, *RunPipelineRequest) (*google_longrunning.Operation, error)
	// Retrieves a pipeline based on ID.
	//
	// Caller must have READ permission to the project.
	GetPipeline(context.Context, *GetPipelineRequest) (*Pipeline, error)
	// Lists pipelines.
	//
	// Caller must have READ permission to the project.
	ListPipelines(context.Context, *ListPipelinesRequest) (*ListPipelinesResponse, error)
	// Deletes a pipeline based on ID.
	//
	// Caller must have WRITE permission to the project.
	DeletePipeline(context.Context, *DeletePipelineRequest) (*google_protobuf2.Empty, error)
	// Gets controller configuration information. Should only be called
	// by VMs created by the Pipelines Service and not by end users.
	GetControllerConfig(context.Context, *GetControllerConfigRequest) (*ControllerConfig, error)
	// Sets status of a given operation. All timestamps are sent on each
	// call, and the whole series of events is replaced, in case
	// intermediate calls are lost. Should only be called by VMs created
	// by the Pipelines Service and not by end users.
	SetOperationStatus(context.Context, *SetOperationStatusRequest) (*google_protobuf2.Empty, error)
}

func RegisterPipelinesV1Alpha2Server(s *grpc.Server, srv PipelinesV1Alpha2Server) {
	s.RegisterService(&_PipelinesV1Alpha2_serviceDesc, srv)
}

func _PipelinesV1Alpha2_CreatePipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).CreatePipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/CreatePipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).CreatePipeline(ctx, req.(*CreatePipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_RunPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).RunPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/RunPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).RunPipeline(ctx, req.(*RunPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_GetPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).GetPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/GetPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).GetPipeline(ctx, req.(*GetPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_ListPipelines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPipelinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).ListPipelines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/ListPipelines",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).ListPipelines(ctx, req.(*ListPipelinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_DeletePipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).DeletePipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/DeletePipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).DeletePipeline(ctx, req.(*DeletePipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_GetControllerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetControllerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).GetControllerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/GetControllerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).GetControllerConfig(ctx, req.(*GetControllerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PipelinesV1Alpha2_SetOperationStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetOperationStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PipelinesV1Alpha2Server).SetOperationStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1alpha2.PipelinesV1Alpha2/SetOperationStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PipelinesV1Alpha2Server).SetOperationStatus(ctx, req.(*SetOperationStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PipelinesV1Alpha2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1alpha2.PipelinesV1Alpha2",
	HandlerType: (*PipelinesV1Alpha2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreatePipeline",
			Handler:    _PipelinesV1Alpha2_CreatePipeline_Handler,
		},
		{
			MethodName: "RunPipeline",
			Handler:    _PipelinesV1Alpha2_RunPipeline_Handler,
		},
		{
			MethodName: "GetPipeline",
			Handler:    _PipelinesV1Alpha2_GetPipeline_Handler,
		},
		{
			MethodName: "ListPipelines",
			Handler:    _PipelinesV1Alpha2_ListPipelines_Handler,
		},
		{
			MethodName: "DeletePipeline",
			Handler:    _PipelinesV1Alpha2_DeletePipeline_Handler,
		},
		{
			MethodName: "GetControllerConfig",
			Handler:    _PipelinesV1Alpha2_GetControllerConfig_Handler,
		},
		{
			MethodName: "SetOperationStatus",
			Handler:    _PipelinesV1Alpha2_SetOperationStatus_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/genomics/v1alpha2/pipelines.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/genomics/v1alpha2/pipelines.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 2057 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xbc, 0x58, 0x4f, 0x6f, 0x23, 0x49,
	0x15, 0x9f, 0x76, 0x9c, 0xc4, 0xfd, 0x9c, 0x38, 0x9e, 0xda, 0x99, 0x5d, 0x8f, 0x77, 0x57, 0x93,
	0xe9, 0x81, 0xdd, 0x24, 0x83, 0x6c, 0x26, 0xb3, 0x03, 0x99, 0x20, 0xad, 0x48, 0x1c, 0x4f, 0x62,
	0x91, 0x49, 0x4c, 0x3b, 0x1b, 0x40, 0x1c, 0x5a, 0x95, 0x76, 0xa5, 0xd3, 0x9b, 0xee, 0xae, 0xa6,
	0xab, 0x3a, 0x1a, 0x0f, 0x02, 0x09, 0xc4, 0x01, 0xad, 0xe0, 0x02, 0xfb, 0x21, 0x90, 0xf8, 0x26,
	0x48, 0x9c, 0x38, 0x71, 0xe0, 0xc6, 0x81, 0x8f, 0x00, 0x37, 0x54, 0x55, 0xdd, 0xed, 0x76, 0xec,
	0x24, 0xb6, 0x84, 0xb8, 0x58, 0x55, 0xaf, 0xeb, 0xfd, 0xea, 0x57, 0xaf, 0x5e, 0xbd, 0x3f, 0x86,
	0x7d, 0x87, 0x52, 0xc7, 0x23, 0x0d, 0x87, 0x7a, 0x38, 0x70, 0x1a, 0x34, 0x72, 0x9a, 0x0e, 0x09,
	0xc2, 0x88, 0x72, 0xda, 0x54, 0x9f, 0x70, 0xe8, 0x32, 0x21, 0xa3, 0xbe, 0x6b, 0xb3, 0xe6, 0xd5,
	0x73, 0xec, 0x85, 0x17, 0x78, 0xb3, 0x19, 0xba, 0x21, 0xf1, 0xdc, 0x80, 0xb0, 0x86, 0x5c, 0x8c,
	0x6a, 0x29, 0x50, 0xb2, 0xb2, 0x91, 0xae, 0xac, 0x77, 0xa6, 0xdb, 0x02, 0x87, 0x6e, 0x93, 0x91,
	0xe8, 0xca, 0xb5, 0x89, 0x4d, 0x83, 0x73, 0xd7, 0x69, 0xe2, 0x20, 0xa0, 0x1c, 0x73, 0x97, 0x06,
	0xc9, 0x26, 0xf5, 0xdd, 0xe9, 0xa0, 0x3c, 0x1a, 0x38, 0x51, 0x1c, 0x04, 0x6e, 0xe0, 0x34, 0x69,
	0x48, 0xa2, 0x11, 0x8c, 0x57, 0x8e, 0xcb, 0x2f, 0xe2, 0xb3, 0x86, 0x4d, 0xfd, 0xa6, 0xc2, 0x69,
	0xca, 0x0f, 0x67, 0xf1, 0x79, 0x33, 0xe4, 0x83, 0x90, 0xb0, 0x66, 0x3f, 0x56, 0x2a, 0xd9, 0x20,
	0x51, 0x7d, 0x71, 0xb7, 0x2a, 0xf1, 0x43, 0x3e, 0x50, 0xbf, 0x89, 0xd2, 0xf7, 0xee, 0x56, 0xe2,
	0xae, 0x4f, 0x18, 0xc7, 0x7e, 0x38, 0x1c, 0x65, 0x64, 0xa7, 0x3a, 0x70, 0x14, 0xda, 0x4d, 0x9b,
	0xf6, 0x89, 0xfc, 0x51, 0xaa, 0xc6, 0x57, 0x1a, 0x2c, 0xb7, 0xa8, 0x1f, 0xc6, 0x9c, 0xb4, 0x03,
	0xc7, 0x0d, 0x08, 0x7a, 0x0a, 0xcb, 0x6e, 0xc0, 0x38, 0x0e, 0x6c, 0x62, 0x05, 0xd8, 0x27, 0x35,
	0x6d, 0x55, 0x5b, 0xd3, 0xcd, 0xa5, 0x54, 0x78, 0x84, 0x7d, 0x82, 0x10, 0x14, 0xdf, 0xd1, 0x80,
	0xd4, 0x0a, 0xf2, 0x9b, 0x1c, 0xa3, 0x27, 0xb0, 0xe4, 0x63, 0xfb, 0xc2, 0x0d, 0x88, 0x25, 0x08,
	0xd7, 0xe6, 0xe4, 0xb7, 0x72, 0x22, 0x3b, 0x19, 0x84, 0x04, 0x7d, 0x0c, 0xd0, 0x77, 0xd9, 0xa5,
	0xc4, 0x65, 0xb5, 0xe2, 0xea, 0xdc, 0x9a, 0x6e, 0xea, 0x42, 0x22, 0x40, 0x99, 0x81, 0x61, 0xc5,
	0x8c, 0x03, 0x71, 0xba, 0x37, 0x84, 0xe3, 0x3e, 0xe6, 0x18, 0x1d, 0x41, 0xc5, 0x56, 0xf4, 0x2c,
	0x22, 0xf9, 0x49, 0x3a, 0xe5, 0xcd, 0x4f, 0x1b, 0x37, 0x79, 0x52, 0x63, 0xe4, 0x38, 0xe6, 0xb2,
	0x9d, 0x9f, 0x1a, 0x7f, 0x9d, 0x83, 0x52, 0x37, 0x71, 0x4a, 0x41, 0x27, 0x8c, 0xe8, 0x97, 0xc4,
	0xe6, 0x96, 0xdb, 0x4f, 0xce, 0xa9, 0x27, 0x92, 0x4e, 0x5f, 0x1c, 0x52, 0x1a, 0x20, 0x39, 0xa4,
	0x18, 0xa3, 0x55, 0x28, 0xf7, 0x09, 0xb3, 0x23, 0x37, 0x14, 0x37, 0x9e, 0x9e, 0x31, 0x27, 0x42,
	0xa7, 0x50, 0x75, 0x83, 0x30, 0xe6, 0x56, 0x88, 0x23, 0xec, 0x13, 0x4e, 0x22, 0x56, 0x2b, 0xad,
	0xce, 0xad, 0x95, 0x37, 0x9f, 0xdd, 0xcc, 0x39, 0xa5, 0xd4, 0x4d, 0x75, 0xcc, 0x15, 0x09, 0x92,
	0xcd, 0x19, 0xfa, 0x31, 0xdc, 0xa7, 0x31, 0xbf, 0x06, 0xac, 0xcf, 0x0e, 0x5c, 0x55, 0x28, 0x39,
	0xe4, 0x5d, 0x58, 0xe8, 0x53, 0xfb, 0x92, 0x44, 0xb5, 0x79, 0x69, 0xdb, 0xb5, 0x9b, 0xe1, 0xf6,
	0xe4, 0xba, 0xf6, 0x5b, 0x62, 0xc7, 0x9c, 0x46, 0x07, 0xf7, 0xcc, 0x44, 0x13, 0x75, 0x40, 0x8f,
	0x08, 0xa3, 0x71, 0x64, 0x13, 0x56, 0x5b, 0x90, 0x30, 0x53, 0xb0, 0x32, 0x53, 0x15, 0x73, 0xa8,
	0x8d, 0x1e, 0x43, 0x39, 0x0d, 0x1b, 0xe2, 0x5a, 0x16, 0xa5, 0x89, 0x21, 0x15, 0x75, 0xfa, 0xbb,
	0x00, 0x25, 0x92, 0x30, 0x30, 0x7e, 0x04, 0x0f, 0x5b, 0x11, 0xc1, 0x9c, 0x0c, 0x21, 0x7f, 0x16,
	0x13, 0xc6, 0xd1, 0xe7, 0x50, 0x4a, 0x55, 0x12, 0x97, 0x31, 0xa6, 0xe0, 0x93, 0xe9, 0x18, 0x7f,
	0x9e, 0x97, 0xce, 0x98, 0x7e, 0xd9, 0x89, 0x1c, 0x76, 0x97, 0xbf, 0xbc, 0x81, 0x05, 0x79, 0x69,
	0xac, 0x56, 0x90, 0xd7, 0xf2, 0xf2, 0xe6, 0x0d, 0xaf, 0x21, 0x37, 0x3a, 0x52, 0xaf, 0x1d, 0xf0,
	0x68, 0x60, 0x26, 0x20, 0xa8, 0x0b, 0x8b, 0xea, 0xaa, 0x58, 0x6d, 0x4e, 0xe2, 0x7d, 0x67, 0x7a,
	0xbc, 0x63, 0xa5, 0xa8, 0x00, 0x53, 0x18, 0xf4, 0x43, 0x58, 0x49, 0x62, 0xa7, 0x85, 0x6d, 0x9b,
	0xc6, 0x01, 0xaf, 0x15, 0xef, 0xba, 0xf1, 0x9e, 0x52, 0xd8, 0x51, 0xeb, 0xcd, 0x0a, 0x1b, 0x99,
	0xa3, 0x0f, 0x41, 0xb7, 0x3d, 0x97, 0x04, 0xd2, 0x22, 0xf3, 0xd2, 0x22, 0x25, 0x25, 0xe8, 0xf4,
	0xff, 0x97, 0x4e, 0xb1, 0x0b, 0x8b, 0x1e, 0x75, 0x1c, 0x37, 0x70, 0xa4, 0x43, 0xdc, 0x4a, 0xf9,
	0x50, 0x2d, 0x3c, 0x96, 0xef, 0x91, 0x99, 0xa9, 0x22, 0x3a, 0x83, 0x27, 0x97, 0x84, 0x84, 0xd6,
	0x95, 0x6f, 0x61, 0xcf, 0xbd, 0x22, 0x16, 0x0d, 0xac, 0x73, 0xec, 0x7a, 0x71, 0x44, 0xac, 0x34,
	0x86, 0xd7, 0x4a, 0x12, 0xfd, 0x51, 0x8a, 0x9e, 0x06, 0xe1, 0xc6, 0x5e, 0xb2, 0xc0, 0xfc, 0x48,
	0x60, 0x9c, 0xfa, 0x3b, 0x02, 0xe1, 0x38, 0x78, 0xad, 0xf4, 0xd3, 0xaf, 0xf5, 0x57, 0x50, 0xce,
	0xdd, 0x25, 0xaa, 0xc2, 0xdc, 0x25, 0x19, 0x24, 0xae, 0x22, 0x86, 0xe8, 0x01, 0xcc, 0x5f, 0x61,
	0x2f, 0x4e, 0xa3, 0x8a, 0x9a, 0x6c, 0x17, 0xb6, 0xb4, 0xfa, 0x36, 0x2c, 0xe5, 0xaf, 0x6d, 0x16,
	0x5d, 0xe3, 0x5f, 0x1a, 0xa0, 0x9c, 0x0f, 0xa4, 0x8f, 0xe0, 0xc9, 0xe8, 0x53, 0x92, 0x50, 0x07,
	0xf7, 0xf2, 0x8f, 0x09, 0xf5, 0x00, 0x91, 0xf0, 0x82, 0xf8, 0x24, 0xc2, 0x9e, 0x95, 0xbd, 0x98,
	0xc2, 0xb4, 0x2f, 0xe6, 0xe0, 0x9e, 0x79, 0x3f, 0xd3, 0xcf, 0x02, 0xeb, 0x11, 0x2c, 0x67, 0xfb,
	0xe2, 0xc8, 0x61, 0x32, 0x4e, 0x96, 0x37, 0xd7, 0xa7, 0x76, 0x60, 0x73, 0x29, 0xcc, 0xcd, 0xc4,
	0x8b, 0xcf, 0x1e, 0xe6, 0x4b, 0x40, 0xfb, 0x84, 0x5f, 0x3f, 0xe9, 0xe3, 0x09, 0x27, 0xcd, 0x9f,
	0xd3, 0xf8, 0x83, 0x06, 0x0f, 0x0e, 0x5d, 0x96, 0x29, 0xb2, 0x54, 0xf3, 0x8e, 0x47, 0xfd, 0x18,
	0xca, 0x22, 0xf0, 0x5b, 0x61, 0x44, 0xce, 0xdd, 0xb7, 0x89, 0xe5, 0x41, 0x88, 0xba, 0x52, 0x22,
	0x5e, 0x40, 0x88, 0x1d, 0x62, 0x31, 0xf7, 0x9d, 0xca, 0x79, 0xf3, 0x66, 0x49, 0x08, 0x7a, 0xee,
	0x3b, 0x95, 0x61, 0xc4, 0x47, 0x4e, 0x2f, 0x49, 0x20, 0x1f, 0x9b, 0x00, 0xc7, 0x0e, 0x39, 0x11,
	0x02, 0xe3, 0x57, 0x1a, 0x3c, 0xbc, 0x46, 0x8a, 0x85, 0x34, 0x60, 0x04, 0x7d, 0x1f, 0xf4, 0xac,
	0x76, 0xaa, 0x69, 0xf2, 0xf9, 0x4f, 0x13, 0xbf, 0x86, 0x4a, 0xe8, 0x13, 0x58, 0x09, 0xc8, 0x5b,
	0x91, 0x2d, 0xb2, 0xfd, 0x15, 0xf9, 0x65, 0x21, 0xee, 0x66, 0x1c, 0xb6, 0xe0, 0xe1, 0x1e, 0xf1,
	0xc8, 0x78, 0x04, 0xbd, 0xd3, 0xa4, 0x5f, 0x42, 0x7d, 0x9f, 0xf0, 0x16, 0x0d, 0x78, 0x44, 0x3d,
	0x8f, 0x44, 0x2d, 0x59, 0x90, 0x0d, 0x7d, 0x6f, 0x29, 0xab, 0xaa, 0x86, 0xfa, 0xe5, 0x4c, 0xd6,
	0xe9, 0xa3, 0x75, 0xa8, 0x5e, 0x61, 0xcf, 0xed, 0xab, 0x35, 0x43, 0x8e, 0x45, 0x73, 0x65, 0x28,
	0x57, 0x2c, 0xff, 0xbe, 0x00, 0xd5, 0xeb, 0x3b, 0x89, 0xf7, 0xe0, 0xfa, 0xd8, 0x49, 0x4b, 0x14,
	0x35, 0x11, 0xef, 0xc6, 0xf6, 0xfb, 0xc9, 0x61, 0xc5, 0x10, 0xad, 0xc2, 0x92, 0x63, 0x33, 0xcb,
	0xa3, 0x8e, 0x15, 0x62, 0x7e, 0x91, 0x64, 0x6d, 0x70, 0x6c, 0x76, 0x48, 0x9d, 0x2e, 0xe6, 0x17,
	0x63, 0xb5, 0x4b, 0x71, 0xbc, 0x76, 0x39, 0x80, 0xe2, 0x15, 0x8e, 0x58, 0x6d, 0x5e, 0x5e, 0xc6,
	0x67, 0xb7, 0xd5, 0x1f, 0xa3, 0x34, 0x1b, 0xa7, 0x38, 0x4a, 0x22, 0xb1, 0x44, 0x40, 0x3f, 0x80,
	0x79, 0x51, 0xf3, 0x88, 0x90, 0x78, 0x47, 0x9a, 0x18, 0x83, 0xda, 0x13, 0x7a, 0x0a, 0x4b, 0x61,
	0xa0, 0x9f, 0x42, 0x59, 0x9c, 0x2d, 0x8d, 0xb2, 0x8b, 0x12, 0x72, 0x7b, 0x06, 0xc8, 0x7d, 0x9b,
	0xf5, 0x94, 0xb2, 0xc2, 0x15, 0x66, 0x49, 0x04, 0xe8, 0x0b, 0xd0, 0x25, 0xb8, 0x1b, 0x5c, 0xa6,
	0x45, 0xcc, 0xd6, 0x8c, 0xd0, 0x42, 0x55, 0x01, 0x97, 0x9c, 0x64, 0x5a, 0x5f, 0x83, 0x8a, 0x49,
	0x42, 0x91, 0xb5, 0xfb, 0x3d, 0x1e, 0x89, 0xd0, 0xfc, 0x3e, 0x2c, 0xc8, 0x60, 0xa6, 0x7c, 0x5d,
	0x37, 0x93, 0x59, 0xfd, 0xbb, 0xa0, 0x67, 0xd6, 0x9b, 0x29, 0x98, 0x6e, 0x01, 0x0c, 0x6d, 0x35,
	0x93, 0xe6, 0x5b, 0x58, 0xb9, 0x66, 0x92, 0x09, 0xea, 0xc7, 0x79, 0xf5, 0xf2, 0xe6, 0xab, 0x19,
	0x8c, 0x32, 0x7a, 0xf2, 0xfc, 0xce, 0x57, 0xb0, 0x3c, 0x62, 0xb1, 0xff, 0xd3, 0xbe, 0x86, 0x07,
	0x95, 0x93, 0xb4, 0xa3, 0x68, 0x5f, 0x91, 0x80, 0x5f, 0xaf, 0x72, 0xb5, 0xf1, 0x2a, 0x77, 0x0b,
	0xf4, 0xac, 0x0b, 0x49, 0xc8, 0xd4, 0xc7, 0x72, 0x66, 0x86, 0x6a, 0x0e, 0x17, 0x1b, 0x5f, 0x17,
	0xe0, 0x51, 0x8f, 0xf0, 0xe3, 0x34, 0x0e, 0xf4, 0x38, 0xe6, 0x31, 0x9b, 0x21, 0x6a, 0xf4, 0xa0,
	0x9a, 0xa1, 0x59, 0x44, 0xf0, 0x4d, 0x0b, 0xae, 0x5b, 0x6a, 0x82, 0xd1, 0x03, 0x9a, 0x2b, 0x7c,
	0x64, 0xce, 0x50, 0x13, 0x80, 0x44, 0x11, 0x8d, 0x2c, 0xd1, 0x1b, 0xc9, 0x00, 0x51, 0xd9, 0xac,
	0xa6, 0x70, 0x51, 0x68, 0x37, 0x5a, 0xb4, 0x4f, 0x4c, 0x5d, 0xae, 0x11, 0x43, 0xd1, 0x26, 0x29,
	0x05, 0x9f, 0x30, 0x26, 0x62, 0x90, 0x0a, 0x19, 0x4b, 0x52, 0xf8, 0x46, 0xc9, 0x26, 0x06, 0xb8,
	0xf9, 0xc9, 0x01, 0xee, 0x73, 0xa8, 0x8c, 0x96, 0x5a, 0xc2, 0x45, 0x89, 0x8f, 0x5d, 0x2f, 0x8d,
	0x6e, 0x72, 0x22, 0x5e, 0x0a, 0xb3, 0x69, 0x48, 0xd4, 0x99, 0x75, 0x33, 0x99, 0x19, 0xcf, 0xa0,
	0x32, 0x5a, 0xf7, 0xa0, 0x47, 0x20, 0x5e, 0x9c, 0x8a, 0x78, 0x0a, 0x62, 0xd1, 0xb1, 0x99, 0x08,
	0x77, 0xc6, 0x3f, 0x8a, 0x70, 0x7f, 0xac, 0xdc, 0x42, 0x1b, 0x70, 0xdf, 0x77, 0x03, 0xd7, 0x8f,
	0x7d, 0xcb, 0x0e, 0x63, 0xcb, 0xa6, 0x91, 0x7c, 0x8f, 0x22, 0xa3, 0xad, 0x24, 0x1f, 0x5a, 0x61,
	0xdc, 0x12, 0x62, 0xe1, 0x21, 0x61, 0x44, 0x44, 0x07, 0xeb, 0x9e, 0x79, 0xca, 0x1d, 0x4b, 0x66,
	0x5e, 0x84, 0xbe, 0x01, 0x95, 0x14, 0x2d, 0xc2, 0xbe, 0xe5, 0x9c, 0x49, 0xab, 0x6a, 0xe6, 0x52,
	0x22, 0x35, 0xb1, 0xbf, 0x7f, 0x86, 0x5e, 0xa7, 0xb1, 0xb0, 0x28, 0x6f, 0xf0, 0xdb, 0x33, 0x94,
	0x87, 0x32, 0x18, 0xa6, 0x61, 0xf0, 0x01, 0xcc, 0x8b, 0x26, 0x54, 0x85, 0x67, 0xdd, 0x54, 0x13,
	0xb4, 0x0e, 0xf7, 0xcf, 0x28, 0xe5, 0x96, 0x6c, 0x3a, 0x45, 0x82, 0x16, 0x34, 0x16, 0xe4, 0x89,
	0x2a, 0xe2, 0x83, 0x40, 0x10, 0x79, 0x7a, 0xff, 0xac, 0xfe, 0x97, 0x02, 0x14, 0xc5, 0x34, 0xeb,
	0xfa, 0xb4, 0x5c, 0xd7, 0xd7, 0x81, 0xa2, 0x4c, 0x0b, 0x05, 0xe9, 0x17, 0x2f, 0x67, 0x25, 0xd9,
	0x10, 0x09, 0xc4, 0x94, 0x10, 0xe8, 0x03, 0x58, 0x4c, 0x89, 0xa8, 0x62, 0x61, 0x81, 0x49, 0x02,
	0xf2, 0x62, 0xa5, 0x4e, 0xe2, 0x49, 0xc9, 0x4c, 0xa4, 0x61, 0x1c, 0x73, 0x6a, 0xf5, 0x65, 0x92,
	0x96, 0xec, 0x4b, 0x26, 0x08, 0x91, 0x4a, 0xdb, 0xa2, 0x00, 0x89, 0x08, 0xee, 0x5b, 0x34, 0xf0,
	0x06, 0xb2, 0x38, 0x2e, 0x99, 0x25, 0x21, 0x38, 0x0e, 0xbc, 0x81, 0xd0, 0xf6, 0x85, 0x37, 0x59,
	0x21, 0x75, 0x03, 0x2e, 0xab, 0x5b, 0xdd, 0x04, 0x29, 0xea, 0x0a, 0x89, 0xd1, 0x83, 0xa2, 0x4c,
	0x6f, 0x0f, 0xa0, 0x7a, 0xf2, 0x93, 0x6e, 0xdb, 0xfa, 0xe2, 0xa8, 0xd7, 0x6d, 0xb7, 0x3a, 0xaf,
	0x3b, 0xed, 0xbd, 0xea, 0x3d, 0x84, 0xa0, 0xd2, 0x6d, 0x9b, 0xbd, 0x4e, 0xef, 0xa4, 0x7d, 0x74,
	0x62, 0x1d, 0xec, 0xed, 0x55, 0xb5, 0x6b, 0xb2, 0x5e, 0x6f, 0xaf, 0x5a, 0x40, 0xcb, 0xa0, 0x1f,
	0x1e, 0xb7, 0x76, 0x0e, 0xe5, 0x74, 0xce, 0xf8, 0x8f, 0x36, 0xf4, 0xaf, 0xac, 0xd1, 0x9c, 0x68,
	0xd9, 0x6b, 0x91, 0xa6, 0x30, 0x1e, 0x69, 0x9e, 0xc2, 0x72, 0x9f, 0x9c, 0xe3, 0xd8, 0xe3, 0x96,
	0x0a, 0x7d, 0xaa, 0xcb, 0x58, 0x4a, 0x84, 0xa7, 0x42, 0x86, 0x4e, 0x00, 0x3c, 0x6a, 0x63, 0xcf,
	0xb2, 0x69, 0x38, 0x48, 0x5a, 0x8d, 0x97, 0x33, 0x74, 0xc5, 0x8d, 0x43, 0xa1, 0xdd, 0xa2, 0xe1,
	0xc0, 0xd4, 0xbd, 0x74, 0x58, 0x7f, 0x01, 0x7a, 0x26, 0x17, 0xec, 0x73, 0x4f, 0x49, 0x8e, 0x85,
	0x4c, 0xb8, 0x56, 0xfa, 0x0f, 0x81, 0x18, 0x1b, 0x3b, 0x50, 0x19, 0xed, 0x92, 0x45, 0x11, 0x28,
	0x2b, 0x93, 0xfc, 0xdf, 0x29, 0xba, 0x94, 0xc8, 0xff, 0x52, 0xc6, 0xea, 0x95, 0xcd, 0xdf, 0x96,
	0x86, 0xe6, 0x63, 0xa7, 0xcf, 0x77, 0x24, 0x69, 0xf4, 0x3b, 0x0d, 0x2a, 0xa3, 0xbd, 0x2e, 0x6a,
	0xde, 0x12, 0xff, 0x27, 0x75, 0xc5, 0xf5, 0x29, 0x6a, 0x48, 0xe3, 0x9b, 0xbf, 0xfe, 0xdb, 0x3f,
	0xff, 0x58, 0x78, 0x6c, 0xbc, 0x37, 0xe1, 0x6f, 0xbc, 0xed, 0xac, 0x0e, 0x47, 0xbf, 0x84, 0x72,
	0xae, 0x68, 0x47, 0xdf, 0x9a, 0xaa, 0xb6, 0x4f, 0x79, 0x7c, 0x9c, 0xae, 0xce, 0xfd, 0x09, 0xd7,
	0xc8, 0x52, 0x82, 0x61, 0x48, 0x0a, 0x1f, 0x19, 0x1f, 0x4c, 0xa2, 0x10, 0xc5, 0xc1, 0xb6, 0xb6,
	0x81, 0xbe, 0xd2, 0xa0, 0x9c, 0x6b, 0x04, 0x6e, 0x23, 0x30, 0xde, 0x2f, 0x4c, 0x65, 0x88, 0x75,
	0xc9, 0xe2, 0x29, 0x7a, 0x32, 0x81, 0x45, 0xf3, 0xe7, 0xb9, 0xda, 0xf8, 0x17, 0xe8, 0xf7, 0x1a,
	0x2c, 0x8f, 0x14, 0xf2, 0xa8, 0x71, 0x4b, 0x7f, 0x3a, 0xa1, 0x0d, 0xa9, 0x37, 0xa7, 0x5e, 0xaf,
	0x3a, 0x04, 0xe3, 0x43, 0xc9, 0xee, 0x21, 0x9a, 0x74, 0x4d, 0xe8, 0x37, 0x1a, 0x54, 0x46, 0xab,
	0xfa, 0xdb, 0x7c, 0x65, 0x62, 0xfd, 0x5f, 0x7f, 0x7f, 0x2c, 0x9f, 0xb7, 0xfd, 0x90, 0x0f, 0x52,
	0xb3, 0x6c, 0x4c, 0x61, 0x96, 0x3f, 0x69, 0xf0, 0xde, 0x84, 0x16, 0x01, 0x7d, 0x76, 0xeb, 0x5d,
	0xdd, 0xd0, 0x51, 0xd4, 0x37, 0xa6, 0xaf, 0x76, 0x8c, 0xa6, 0x24, 0xb9, 0x8e, 0x3e, 0x9d, 0xe4,
	0x41, 0xce, 0x04, 0x4a, 0x5f, 0x6b, 0x80, 0xc6, 0xcb, 0x12, 0xf4, 0xe2, 0xb6, 0x7f, 0x46, 0x6e,
	0x28, 0x62, 0x6e, 0xb4, 0xdc, 0x73, 0x49, 0xea, 0x59, 0xfd, 0x93, 0x49, 0xa4, 0xd8, 0x18, 0xdc,
	0xb6, 0xb6, 0xb1, 0xdb, 0x80, 0x0f, 0x6c, 0xea, 0x4f, 0x22, 0xb1, 0x5b, 0xc9, 0x7c, 0xa2, 0x2b,
	0xb6, 0xe9, 0x6a, 0xff, 0xd6, 0xb4, 0xb3, 0x05, 0xb9, 0xe5, 0x8b, 0xff, 0x06, 0x00, 0x00, 0xff,
	0xff, 0x0b, 0x4c, 0xf5, 0x4a, 0xb2, 0x17, 0x00, 0x00,
}
