// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1/report_errors_service.proto
// DO NOT EDIT!

package google_devtools_clouderrorreporting_v1beta1 // import "google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A request for reporting an individual error event.
type ReportErrorEventRequest struct {
	// [Required] The resource name of the Google Cloud Platform project. Written
	// as `projects/` plus the
	// [Google Cloud Platform project ID](https://support.google.com/cloud/answer/6158840).
	// Example: `projects/my-project-123`.
	ProjectName string `protobuf:"bytes,1,opt,name=project_name,json=projectName" json:"project_name,omitempty"`
	// [Required] The error event to be reported.
	Event *ReportedErrorEvent `protobuf:"bytes,2,opt,name=event" json:"event,omitempty"`
}

func (m *ReportErrorEventRequest) Reset()                    { *m = ReportErrorEventRequest{} }
func (m *ReportErrorEventRequest) String() string            { return proto.CompactTextString(m) }
func (*ReportErrorEventRequest) ProtoMessage()               {}
func (*ReportErrorEventRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *ReportErrorEventRequest) GetEvent() *ReportedErrorEvent {
	if m != nil {
		return m.Event
	}
	return nil
}

// Response for reporting an individual error event.
// Data may be added to this message in the future.
type ReportErrorEventResponse struct {
}

func (m *ReportErrorEventResponse) Reset()                    { *m = ReportErrorEventResponse{} }
func (m *ReportErrorEventResponse) String() string            { return proto.CompactTextString(m) }
func (*ReportErrorEventResponse) ProtoMessage()               {}
func (*ReportErrorEventResponse) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{1} }

// An error event which is reported to the Error Reporting system.
type ReportedErrorEvent struct {
	// [Optional] Time when the event occurred.
	// If not provided, the time when the event was received by the
	// Error Reporting system will be used.
	EventTime *google_protobuf1.Timestamp `protobuf:"bytes,1,opt,name=event_time,json=eventTime" json:"event_time,omitempty"`
	// [Required] The service context in which this error has occurred.
	ServiceContext *ServiceContext `protobuf:"bytes,2,opt,name=service_context,json=serviceContext" json:"service_context,omitempty"`
	// [Required] A message describing the error. The message can contain an
	// exception stack in one of the supported programming languages and formats.
	// In that case, the message is parsed and detailed exception information
	// is returned when retrieving the error event again.
	Message string `protobuf:"bytes,3,opt,name=message" json:"message,omitempty"`
	// [Optional] A description of the context in which the error occurred.
	Context *ErrorContext `protobuf:"bytes,4,opt,name=context" json:"context,omitempty"`
}

func (m *ReportedErrorEvent) Reset()                    { *m = ReportedErrorEvent{} }
func (m *ReportedErrorEvent) String() string            { return proto.CompactTextString(m) }
func (*ReportedErrorEvent) ProtoMessage()               {}
func (*ReportedErrorEvent) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{2} }

func (m *ReportedErrorEvent) GetEventTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.EventTime
	}
	return nil
}

func (m *ReportedErrorEvent) GetServiceContext() *ServiceContext {
	if m != nil {
		return m.ServiceContext
	}
	return nil
}

func (m *ReportedErrorEvent) GetContext() *ErrorContext {
	if m != nil {
		return m.Context
	}
	return nil
}

func init() {
	proto.RegisterType((*ReportErrorEventRequest)(nil), "google.devtools.clouderrorreporting.v1beta1.ReportErrorEventRequest")
	proto.RegisterType((*ReportErrorEventResponse)(nil), "google.devtools.clouderrorreporting.v1beta1.ReportErrorEventResponse")
	proto.RegisterType((*ReportedErrorEvent)(nil), "google.devtools.clouderrorreporting.v1beta1.ReportedErrorEvent")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ReportErrorsService service

type ReportErrorsServiceClient interface {
	// Report an individual error event.
	//
	// This endpoint accepts <strong>either</strong> an OAuth token,
	// <strong>or</strong> an
	// <a href="https://support.google.com/cloud/answer/6158862">API key</a>
	// for authentication. To use an API key, append it to the URL as the value of
	// a `key` parameter. For example:
	// <pre>POST https://clouderrorreporting.googleapis.com/v1beta1/projects/example-project/events:report?key=123ABC456</pre>
	ReportErrorEvent(ctx context.Context, in *ReportErrorEventRequest, opts ...grpc.CallOption) (*ReportErrorEventResponse, error)
}

type reportErrorsServiceClient struct {
	cc *grpc.ClientConn
}

func NewReportErrorsServiceClient(cc *grpc.ClientConn) ReportErrorsServiceClient {
	return &reportErrorsServiceClient{cc}
}

func (c *reportErrorsServiceClient) ReportErrorEvent(ctx context.Context, in *ReportErrorEventRequest, opts ...grpc.CallOption) (*ReportErrorEventResponse, error) {
	out := new(ReportErrorEventResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouderrorreporting.v1beta1.ReportErrorsService/ReportErrorEvent", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ReportErrorsService service

type ReportErrorsServiceServer interface {
	// Report an individual error event.
	//
	// This endpoint accepts <strong>either</strong> an OAuth token,
	// <strong>or</strong> an
	// <a href="https://support.google.com/cloud/answer/6158862">API key</a>
	// for authentication. To use an API key, append it to the URL as the value of
	// a `key` parameter. For example:
	// <pre>POST https://clouderrorreporting.googleapis.com/v1beta1/projects/example-project/events:report?key=123ABC456</pre>
	ReportErrorEvent(context.Context, *ReportErrorEventRequest) (*ReportErrorEventResponse, error)
}

func RegisterReportErrorsServiceServer(s *grpc.Server, srv ReportErrorsServiceServer) {
	s.RegisterService(&_ReportErrorsService_serviceDesc, srv)
}

func _ReportErrorsService_ReportErrorEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportErrorEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportErrorsServiceServer).ReportErrorEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouderrorreporting.v1beta1.ReportErrorsService/ReportErrorEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportErrorsServiceServer).ReportErrorEvent(ctx, req.(*ReportErrorEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReportErrorsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.clouderrorreporting.v1beta1.ReportErrorsService",
	HandlerType: (*ReportErrorsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ReportErrorEvent",
			Handler:    _ReportErrorsService_ReportErrorEvent_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1/report_errors_service.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1/report_errors_service.proto", fileDescriptor3)
}

var fileDescriptor3 = []byte{
	// 468 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x93, 0xcd, 0x6e, 0x13, 0x31,
	0x10, 0xc7, 0xb5, 0xe1, 0xa3, 0xaa, 0x83, 0x00, 0x99, 0x03, 0xab, 0x3d, 0x95, 0x9c, 0x2a, 0x90,
	0x6c, 0x1a, 0x4e, 0x69, 0x85, 0x2a, 0x15, 0x72, 0xe0, 0x00, 0xaa, 0xb6, 0x20, 0x8e, 0x2b, 0x67,
	0x33, 0x31, 0x8b, 0xb2, 0x1e, 0x63, 0x3b, 0x11, 0x08, 0x71, 0xe1, 0x15, 0xfa, 0x0a, 0xbc, 0x11,
	0x2f, 0xc0, 0x81, 0x87, 0xe0, 0x88, 0xd6, 0x1f, 0x10, 0x48, 0x0f, 0x2c, 0x70, 0xcb, 0x78, 0x32,
	0xbf, 0xff, 0xcc, 0x7f, 0x66, 0xc9, 0x42, 0x22, 0xca, 0x25, 0x30, 0x89, 0x4b, 0xa1, 0x24, 0x43,
	0x23, 0xb9, 0x04, 0xa5, 0x0d, 0x3a, 0xe4, 0x21, 0x25, 0x74, 0x63, 0xf9, 0x1c, 0xd6, 0x0e, 0x71,
	0x69, 0x79, 0xbd, 0xc4, 0xd5, 0x1c, 0x8c, 0x41, 0x63, 0x40, 0xa3, 0x71, 0x8d, 0x92, 0x7c, 0x7d,
	0x30, 0x03, 0x27, 0x0e, 0x78, 0x78, 0xa9, 0x7c, 0xd6, 0x56, 0x16, 0xcc, 0xba, 0xa9, 0x81, 0x79,
	0x16, 0xbd, 0x17, 0x75, 0x12, 0x88, 0x5d, 0x00, 0x62, 0x11, 0x54, 0x3c, 0xf9, 0xb3, 0xa6, 0x84,
	0x6e, 0x78, 0x54, 0xa9, 0x51, 0x2d, 0x1a, 0xc9, 0x85, 0x52, 0xe8, 0x84, 0x6b, 0x50, 0xd9, 0xa0,
	0x5b, 0xbc, 0xfc, 0x8f, 0xf3, 0xd5, 0xd8, 0xb6, 0xa8, 0x22, 0xf8, 0x48, 0x36, 0xee, 0xd5, 0x6a,
	0xc6, 0x6a, 0x6c, 0x79, 0x80, 0x73, 0x9f, 0x98, 0xad, 0x16, 0x5c, 0xbb, 0x77, 0x1a, 0x2c, 0x77,
	0x4d, 0x0b, 0xd6, 0x89, 0x56, 0xff, 0xfc, 0x15, 0x8a, 0x47, 0xe7, 0x19, 0xb9, 0x5d, 0x7a, 0xfe,
	0xb4, 0x93, 0x9a, 0xae, 0x41, 0xb9, 0x12, 0xde, 0xac, 0xc0, 0x3a, 0x7a, 0x87, 0x5c, 0xd3, 0x06,
	0x5f, 0x43, 0xed, 0x2a, 0x25, 0x5a, 0xc8, 0xb3, 0xbd, 0x6c, 0x7f, 0xb7, 0x1c, 0xc6, 0xb7, 0x67,
	0xa2, 0x05, 0xfa, 0x82, 0x5c, 0x81, 0xae, 0x24, 0x1f, 0xec, 0x65, 0xfb, 0xc3, 0xf1, 0x31, 0xeb,
	0x61, 0x2e, 0x0b, 0xba, 0x30, 0xdf, 0x50, 0x0e, 0xb4, 0x51, 0x41, 0xf2, 0xed, 0xa6, 0xac, 0x46,
	0x65, 0x61, 0xf4, 0x69, 0x40, 0xe8, 0x76, 0x25, 0x9d, 0x10, 0xe2, 0x6b, 0xab, 0x6e, 0x42, 0xdf,
	0xea, 0x70, 0x5c, 0xa4, 0x76, 0x92, 0x1f, 0xec, 0x79, 0x1a, 0xbf, 0xdc, 0xf5, 0xff, 0xee, 0x62,
	0x3a, 0x27, 0x37, 0xe2, 0xf2, 0xaa, 0x1a, 0x95, 0x83, 0xb7, 0x69, 0x9c, 0xa3, 0x5e, 0xe3, 0x9c,
	0x05, 0xc6, 0xa3, 0x80, 0x28, 0xaf, 0xdb, 0x5f, 0x62, 0x9a, 0x93, 0x9d, 0x16, 0xac, 0x15, 0x12,
	0xf2, 0x4b, 0xde, 0xc8, 0x14, 0xd2, 0x33, 0xb2, 0x93, 0x74, 0x2f, 0x7b, 0xdd, 0x49, 0x2f, 0x5d,
	0x6f, 0x42, 0x52, 0x4d, 0xa4, 0xf1, 0xb7, 0x8c, 0xdc, 0xda, 0xf0, 0xd0, 0xc6, 0xee, 0xe8, 0x97,
	0x8c, 0xdc, 0xfc, 0xdd, 0x5b, 0xfa, 0xf8, 0x2f, 0xf6, 0xb6, 0x75, 0x2f, 0xc5, 0xf4, 0x1f, 0x29,
	0x71, 0xc1, 0xc7, 0x1f, 0x3f, 0x7f, 0x3d, 0x1f, 0x4c, 0x46, 0xf7, 0x7f, 0x9c, 0xfb, 0xfb, 0xcd,
	0x33, 0x7c, 0x18, 0x03, 0xcb, 0xef, 0x7e, 0xe0, 0x7e, 0x89, 0xf6, 0x30, 0xd0, 0x0f, 0xc3, 0xf5,
	0x9c, 0x3c, 0x25, 0xdd, 0x07, 0xd2, 0xa7, 0x99, 0x93, 0xfc, 0x02, 0xab, 0x4e, 0xbb, 0xa3, 0x39,
	0xcd, 0x66, 0x57, 0xfd, 0xf5, 0x3c, 0xf8, 0x1e, 0x00, 0x00, 0xff, 0xff, 0xb3, 0x99, 0xec, 0x95,
	0xa1, 0x04, 0x00, 0x00,
}
