// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1/error_group_service.proto
// DO NOT EDIT!

package google_devtools_clouderrorreporting_v1beta1 // import "google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A request to return an individual group.
type GetGroupRequest struct {
	// [Required] The group resource name. Written as
	// <code>projects/<var>projectID</var>/groups/<var>group_name</var></code>.
	// Call
	// <a href="/error-reporting/reference/rest/v1beta1/projects.groupStats/list">
	// <code>groupStats.list</code></a> to return a list of groups belonging to
	// this project.
	//
	// Example: <code>projects/my-project-123/groups/my-group</code>
	GroupName string `protobuf:"bytes,1,opt,name=group_name,json=groupName" json:"group_name,omitempty"`
}

func (m *GetGroupRequest) Reset()                    { *m = GetGroupRequest{} }
func (m *GetGroupRequest) String() string            { return proto.CompactTextString(m) }
func (*GetGroupRequest) ProtoMessage()               {}
func (*GetGroupRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

// A request to replace the existing data for the given group.
type UpdateGroupRequest struct {
	// [Required] The group which replaces the resource on the server.
	Group *ErrorGroup `protobuf:"bytes,1,opt,name=group" json:"group,omitempty"`
}

func (m *UpdateGroupRequest) Reset()                    { *m = UpdateGroupRequest{} }
func (m *UpdateGroupRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateGroupRequest) ProtoMessage()               {}
func (*UpdateGroupRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *UpdateGroupRequest) GetGroup() *ErrorGroup {
	if m != nil {
		return m.Group
	}
	return nil
}

func init() {
	proto.RegisterType((*GetGroupRequest)(nil), "google.devtools.clouderrorreporting.v1beta1.GetGroupRequest")
	proto.RegisterType((*UpdateGroupRequest)(nil), "google.devtools.clouderrorreporting.v1beta1.UpdateGroupRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ErrorGroupService service

type ErrorGroupServiceClient interface {
	// Get the specified group.
	GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*ErrorGroup, error)
	// Replace the data for the specified group.
	// Fails if the group does not exist.
	UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*ErrorGroup, error)
}

type errorGroupServiceClient struct {
	cc *grpc.ClientConn
}

func NewErrorGroupServiceClient(cc *grpc.ClientConn) ErrorGroupServiceClient {
	return &errorGroupServiceClient{cc}
}

func (c *errorGroupServiceClient) GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*ErrorGroup, error) {
	out := new(ErrorGroup)
	err := grpc.Invoke(ctx, "/google.devtools.clouderrorreporting.v1beta1.ErrorGroupService/GetGroup", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *errorGroupServiceClient) UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*ErrorGroup, error) {
	out := new(ErrorGroup)
	err := grpc.Invoke(ctx, "/google.devtools.clouderrorreporting.v1beta1.ErrorGroupService/UpdateGroup", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ErrorGroupService service

type ErrorGroupServiceServer interface {
	// Get the specified group.
	GetGroup(context.Context, *GetGroupRequest) (*ErrorGroup, error)
	// Replace the data for the specified group.
	// Fails if the group does not exist.
	UpdateGroup(context.Context, *UpdateGroupRequest) (*ErrorGroup, error)
}

func RegisterErrorGroupServiceServer(s *grpc.Server, srv ErrorGroupServiceServer) {
	s.RegisterService(&_ErrorGroupService_serviceDesc, srv)
}

func _ErrorGroupService_GetGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ErrorGroupServiceServer).GetGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouderrorreporting.v1beta1.ErrorGroupService/GetGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ErrorGroupServiceServer).GetGroup(ctx, req.(*GetGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ErrorGroupService_UpdateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ErrorGroupServiceServer).UpdateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouderrorreporting.v1beta1.ErrorGroupService/UpdateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ErrorGroupServiceServer).UpdateGroup(ctx, req.(*UpdateGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ErrorGroupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.clouderrorreporting.v1beta1.ErrorGroupService",
	HandlerType: (*ErrorGroupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetGroup",
			Handler:    _ErrorGroupService_GetGroup_Handler,
		},
		{
			MethodName: "UpdateGroup",
			Handler:    _ErrorGroupService_UpdateGroup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1/error_group_service.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1/error_group_service.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 358 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x52, 0xcd, 0x4a, 0x2b, 0x31,
	0x14, 0x66, 0xee, 0xe5, 0x5e, 0x6e, 0xd3, 0xc5, 0xc5, 0x2c, 0x44, 0x06, 0x04, 0xe9, 0x4a, 0x5b,
	0x48, 0x6c, 0x5d, 0x28, 0xa2, 0x08, 0x05, 0x29, 0x22, 0x4a, 0xa9, 0x88, 0xcb, 0x92, 0xce, 0x1c,
	0xc3, 0xc8, 0x4c, 0xce, 0x98, 0xa4, 0xdd, 0x88, 0x1b, 0x1f, 0xc0, 0x8d, 0xaf, 0xe2, 0x0b, 0xf8,
	0x0c, 0xbe, 0x82, 0x0f, 0x22, 0x93, 0xb4, 0x56, 0x5b, 0x05, 0xa7, 0xb8, 0xfd, 0x72, 0xf2, 0xfd,
	0x9d, 0x43, 0x62, 0x89, 0x28, 0x53, 0x60, 0x12, 0x53, 0xa1, 0x24, 0x43, 0x2d, 0xb9, 0x04, 0x95,
	0x6b, 0xb4, 0xc8, 0xfd, 0x93, 0xc8, 0x13, 0xc3, 0x63, 0x18, 0x59, 0xc4, 0xd4, 0xf0, 0x28, 0xc5,
	0x61, 0x0c, 0x5a, 0xa3, 0xd6, 0x90, 0xa3, 0xb6, 0x89, 0x92, 0x7c, 0xd4, 0x1c, 0x80, 0x15, 0x4d,
	0xee, 0xe0, 0xbe, 0xd4, 0x38, 0xcc, 0xfb, 0x06, 0xf4, 0x28, 0x89, 0x80, 0x39, 0x26, 0xda, 0x18,
	0xab, 0x4c, 0x68, 0xd8, 0x27, 0x34, 0x6c, 0x4c, 0x13, 0x1e, 0x7d, 0xcf, 0x92, 0xc8, 0x13, 0x3e,
	0x56, 0x89, 0x50, 0x5d, 0x26, 0x92, 0x0b, 0xa5, 0xd0, 0x0a, 0x9b, 0xa0, 0x32, 0x5e, 0x37, 0xbc,
	0xf8, 0xc1, 0x74, 0x11, 0x66, 0x19, 0x2a, 0x4f, 0x5c, 0xdb, 0x24, 0xff, 0x3b, 0x60, 0x3b, 0x45,
	0xd4, 0x1e, 0x5c, 0x0f, 0xc1, 0x58, 0xba, 0x4a, 0x88, 0x8f, 0xae, 0x44, 0x06, 0x2b, 0xc1, 0x5a,
	0xb0, 0x5e, 0xe9, 0x55, 0x1c, 0x72, 0x2a, 0x32, 0xa8, 0x45, 0x84, 0x9e, 0xe7, 0xb1, 0xb0, 0xf0,
	0xe1, 0xd3, 0x09, 0xf9, 0xe3, 0x46, 0xdc, 0x7c, 0xb5, 0xb5, 0xcd, 0x4a, 0x14, 0xc5, 0x0e, 0x0b,
	0xd8, 0xd3, 0x79, 0x96, 0xd6, 0xfd, 0x6f, 0xb2, 0x34, 0x45, 0xcf, 0x7c, 0x3b, 0xf4, 0x31, 0x20,
	0xff, 0x26, 0x6e, 0xe9, 0x5e, 0x29, 0x89, 0x99, 0x90, 0xe1, 0xa2, 0x06, 0x6b, 0xcd, 0xbb, 0xe7,
	0x97, 0x87, 0x5f, 0x0d, 0xba, 0xf1, 0xd6, 0xe7, 0xcd, 0xb4, 0xad, 0xfd, 0x5c, 0xe3, 0x15, 0x44,
	0xd6, 0xf0, 0x3a, 0x77, 0xa8, 0xe1, 0xf5, 0x5b, 0xfa, 0x14, 0x90, 0xea, 0xbb, 0xca, 0xe8, 0x41,
	0x29, 0xed, 0xf9, 0xb2, 0x17, 0x37, 0xbf, 0xe3, 0xcc, 0xb7, 0xc2, 0x59, 0xf3, 0xec, 0x4b, 0xf3,
	0xbb, 0x7e, 0x21, 0xed, 0x63, 0x52, 0xdc, 0x4d, 0x19, 0xdd, 0xf6, 0xf2, 0xdc, 0x02, 0xbb, 0xc5,
	0xc9, 0x75, 0x83, 0xc1, 0x5f, 0x77, 0x7b, 0x5b, 0xaf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x2f, 0x68,
	0x09, 0x8a, 0xb4, 0x03, 0x00, 0x00,
}
