// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/cloud/dataproc/v1/jobs.proto
// DO NOT EDIT!

package google_cloud_dataproc_v1 // import "google.golang.org/genproto/googleapis/cloud/dataproc/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The Log4j level for job execution. When running an
// [Apache Hive](http://hive.apache.org/) job, Cloud
// Dataproc configures the Hive client to an equivalent verbosity level.
type LoggingConfig_Level int32

const (
	// Level is unspecified. Use default level for log4j.
	LoggingConfig_LEVEL_UNSPECIFIED LoggingConfig_Level = 0
	// Use ALL level for log4j.
	LoggingConfig_ALL LoggingConfig_Level = 1
	// Use TRACE level for log4j.
	LoggingConfig_TRACE LoggingConfig_Level = 2
	// Use DEBUG level for log4j.
	LoggingConfig_DEBUG LoggingConfig_Level = 3
	// Use INFO level for log4j.
	LoggingConfig_INFO LoggingConfig_Level = 4
	// Use WARN level for log4j.
	LoggingConfig_WARN LoggingConfig_Level = 5
	// Use ERROR level for log4j.
	LoggingConfig_ERROR LoggingConfig_Level = 6
	// Use FATAL level for log4j.
	LoggingConfig_FATAL LoggingConfig_Level = 7
	// Turn off log4j.
	LoggingConfig_OFF LoggingConfig_Level = 8
)

var LoggingConfig_Level_name = map[int32]string{
	0: "LEVEL_UNSPECIFIED",
	1: "ALL",
	2: "TRACE",
	3: "DEBUG",
	4: "INFO",
	5: "WARN",
	6: "ERROR",
	7: "FATAL",
	8: "OFF",
}
var LoggingConfig_Level_value = map[string]int32{
	"LEVEL_UNSPECIFIED": 0,
	"ALL":               1,
	"TRACE":             2,
	"DEBUG":             3,
	"INFO":              4,
	"WARN":              5,
	"ERROR":             6,
	"FATAL":             7,
	"OFF":               8,
}

func (x LoggingConfig_Level) String() string {
	return proto.EnumName(LoggingConfig_Level_name, int32(x))
}
func (LoggingConfig_Level) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0, 0} }

// The job state.
type JobStatus_State int32

const (
	// The job state is unknown.
	JobStatus_STATE_UNSPECIFIED JobStatus_State = 0
	// The job is pending; it has been submitted, but is not yet running.
	JobStatus_PENDING JobStatus_State = 1
	// Job has been received by the service and completed initial setup;
	// it will soon be submitted to the cluster.
	JobStatus_SETUP_DONE JobStatus_State = 8
	// The job is running on the cluster.
	JobStatus_RUNNING JobStatus_State = 2
	// A CancelJob request has been received, but is pending.
	JobStatus_CANCEL_PENDING JobStatus_State = 3
	// Transient in-flight resources have been canceled, and the request to
	// cancel the running job has been issued to the cluster.
	JobStatus_CANCEL_STARTED JobStatus_State = 7
	// The job cancellation was successful.
	JobStatus_CANCELLED JobStatus_State = 4
	// The job has completed successfully.
	JobStatus_DONE JobStatus_State = 5
	// The job has completed, but encountered an error.
	JobStatus_ERROR JobStatus_State = 6
)

var JobStatus_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "PENDING",
	8: "SETUP_DONE",
	2: "RUNNING",
	3: "CANCEL_PENDING",
	7: "CANCEL_STARTED",
	4: "CANCELLED",
	5: "DONE",
	6: "ERROR",
}
var JobStatus_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"PENDING":           1,
	"SETUP_DONE":        8,
	"RUNNING":           2,
	"CANCEL_PENDING":    3,
	"CANCEL_STARTED":    7,
	"CANCELLED":         4,
	"DONE":              5,
	"ERROR":             6,
}

func (x JobStatus_State) String() string {
	return proto.EnumName(JobStatus_State_name, int32(x))
}
func (JobStatus_State) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{9, 0} }

// A matcher that specifies categories of job states.
type ListJobsRequest_JobStateMatcher int32

const (
	// Match all jobs, regardless of state.
	ListJobsRequest_ALL ListJobsRequest_JobStateMatcher = 0
	// Only match jobs in non-terminal states: PENDING, RUNNING, or
	// CANCEL_PENDING.
	ListJobsRequest_ACTIVE ListJobsRequest_JobStateMatcher = 1
	// Only match jobs in terminal states: CANCELLED, DONE, or ERROR.
	ListJobsRequest_NON_ACTIVE ListJobsRequest_JobStateMatcher = 2
)

var ListJobsRequest_JobStateMatcher_name = map[int32]string{
	0: "ALL",
	1: "ACTIVE",
	2: "NON_ACTIVE",
}
var ListJobsRequest_JobStateMatcher_value = map[string]int32{
	"ALL":        0,
	"ACTIVE":     1,
	"NON_ACTIVE": 2,
}

func (x ListJobsRequest_JobStateMatcher) String() string {
	return proto.EnumName(ListJobsRequest_JobStateMatcher_name, int32(x))
}
func (ListJobsRequest_JobStateMatcher) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{14, 0}
}

// The runtime logging config of the job.
type LoggingConfig struct {
	// The per-package log levels for the driver. This may include
	// "root" package name to configure rootLogger.
	// Examples:
	//   'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
	DriverLogLevels map[string]LoggingConfig_Level `protobuf:"bytes,2,rep,name=driver_log_levels,json=driverLogLevels" json:"driver_log_levels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value,enum=google.cloud.dataproc.v1.LoggingConfig_Level"`
}

func (m *LoggingConfig) Reset()                    { *m = LoggingConfig{} }
func (m *LoggingConfig) String() string            { return proto.CompactTextString(m) }
func (*LoggingConfig) ProtoMessage()               {}
func (*LoggingConfig) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *LoggingConfig) GetDriverLogLevels() map[string]LoggingConfig_Level {
	if m != nil {
		return m.DriverLogLevels
	}
	return nil
}

// A Cloud Dataproc job for running
// [Apache Hadoop MapReduce](https://hadoop.apache.org/docs/current/hadoop-mapreduce-client/hadoop-mapreduce-client-core/MapReduceTutorial.html)
// jobs on [Apache Hadoop YARN](https://hadoop.apache.org/docs/r2.7.1/hadoop-yarn/hadoop-yarn-site/YARN.html).
type HadoopJob struct {
	// [Required] Indicates the location of the driver's main class. Specify
	// either the jar file that contains the main class or the main class name.
	// To specify both, add the jar file to `jar_file_uris`, and then specify
	// the main class name in this property.
	//
	// Types that are valid to be assigned to Driver:
	//	*HadoopJob_MainJarFileUri
	//	*HadoopJob_MainClass
	Driver isHadoopJob_Driver `protobuf_oneof:"driver"`
	// [Optional] The arguments to pass to the driver. Do not
	// include arguments, such as `-libjars` or `-Dfoo=bar`, that can be set as job
	// properties, since a collision may occur that causes an incorrect job
	// submission.
	Args []string `protobuf:"bytes,3,rep,name=args" json:"args,omitempty"`
	// [Optional] Jar file URIs to add to the CLASSPATHs of the
	// Hadoop driver and tasks.
	JarFileUris []string `protobuf:"bytes,4,rep,name=jar_file_uris,json=jarFileUris" json:"jar_file_uris,omitempty"`
	// [Optional] HCFS (Hadoop Compatible Filesystem) URIs of files to be copied
	// to the working directory of Hadoop drivers and distributed tasks. Useful
	// for naively parallel tasks.
	FileUris []string `protobuf:"bytes,5,rep,name=file_uris,json=fileUris" json:"file_uris,omitempty"`
	// [Optional] HCFS URIs of archives to be extracted in the working directory of
	// Hadoop drivers and tasks. Supported file types:
	// .jar, .tar, .tar.gz, .tgz, or .zip.
	ArchiveUris []string `protobuf:"bytes,6,rep,name=archive_uris,json=archiveUris" json:"archive_uris,omitempty"`
	// [Optional] A mapping of property names to values, used to configure Hadoop.
	// Properties that conflict with values set by the Cloud Dataproc API may be
	// overwritten. Can include properties set in /etc/hadoop/conf/*-site and
	// classes in user code.
	Properties map[string]string `protobuf:"bytes,7,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] The runtime log config for job execution.
	LoggingConfig *LoggingConfig `protobuf:"bytes,8,opt,name=logging_config,json=loggingConfig" json:"logging_config,omitempty"`
}

func (m *HadoopJob) Reset()                    { *m = HadoopJob{} }
func (m *HadoopJob) String() string            { return proto.CompactTextString(m) }
func (*HadoopJob) ProtoMessage()               {}
func (*HadoopJob) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

type isHadoopJob_Driver interface {
	isHadoopJob_Driver()
}

type HadoopJob_MainJarFileUri struct {
	MainJarFileUri string `protobuf:"bytes,1,opt,name=main_jar_file_uri,json=mainJarFileUri,oneof"`
}
type HadoopJob_MainClass struct {
	MainClass string `protobuf:"bytes,2,opt,name=main_class,json=mainClass,oneof"`
}

func (*HadoopJob_MainJarFileUri) isHadoopJob_Driver() {}
func (*HadoopJob_MainClass) isHadoopJob_Driver()      {}

func (m *HadoopJob) GetDriver() isHadoopJob_Driver {
	if m != nil {
		return m.Driver
	}
	return nil
}

func (m *HadoopJob) GetMainJarFileUri() string {
	if x, ok := m.GetDriver().(*HadoopJob_MainJarFileUri); ok {
		return x.MainJarFileUri
	}
	return ""
}

func (m *HadoopJob) GetMainClass() string {
	if x, ok := m.GetDriver().(*HadoopJob_MainClass); ok {
		return x.MainClass
	}
	return ""
}

func (m *HadoopJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *HadoopJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HadoopJob) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HadoopJob_OneofMarshaler, _HadoopJob_OneofUnmarshaler, _HadoopJob_OneofSizer, []interface{}{
		(*HadoopJob_MainJarFileUri)(nil),
		(*HadoopJob_MainClass)(nil),
	}
}

func _HadoopJob_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HadoopJob)
	// driver
	switch x := m.Driver.(type) {
	case *HadoopJob_MainJarFileUri:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.MainJarFileUri)
	case *HadoopJob_MainClass:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.MainClass)
	case nil:
	default:
		return fmt.Errorf("HadoopJob.Driver has unexpected type %T", x)
	}
	return nil
}

func _HadoopJob_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HadoopJob)
	switch tag {
	case 1: // driver.main_jar_file_uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Driver = &HadoopJob_MainJarFileUri{x}
		return true, err
	case 2: // driver.main_class
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Driver = &HadoopJob_MainClass{x}
		return true, err
	default:
		return false, nil
	}
}

func _HadoopJob_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HadoopJob)
	// driver
	switch x := m.Driver.(type) {
	case *HadoopJob_MainJarFileUri:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.MainJarFileUri)))
		n += len(x.MainJarFileUri)
	case *HadoopJob_MainClass:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.MainClass)))
		n += len(x.MainClass)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Cloud Dataproc job for running [Apache Spark](http://spark.apache.org/)
// applications on YARN.
type SparkJob struct {
	// [Required] The specification of the main method to call to drive the job.
	// Specify either the jar file that contains the main class or the main class
	// name. To pass both a main jar and a main class in that jar, add the jar to
	// `CommonJob.jar_file_uris`, and then specify the main class name in `main_class`.
	//
	// Types that are valid to be assigned to Driver:
	//	*SparkJob_MainJarFileUri
	//	*SparkJob_MainClass
	Driver isSparkJob_Driver `protobuf_oneof:"driver"`
	// [Optional] The arguments to pass to the driver. Do not include arguments,
	// such as `--conf`, that can be set as job properties, since a collision may
	// occur that causes an incorrect job submission.
	Args []string `protobuf:"bytes,3,rep,name=args" json:"args,omitempty"`
	// [Optional] HCFS URIs of jar files to add to the CLASSPATHs of the
	// Spark driver and tasks.
	JarFileUris []string `protobuf:"bytes,4,rep,name=jar_file_uris,json=jarFileUris" json:"jar_file_uris,omitempty"`
	// [Optional] HCFS URIs of files to be copied to the working directory of
	// Spark drivers and distributed tasks. Useful for naively parallel tasks.
	FileUris []string `protobuf:"bytes,5,rep,name=file_uris,json=fileUris" json:"file_uris,omitempty"`
	// [Optional] HCFS URIs of archives to be extracted in the working directory
	// of Spark drivers and tasks. Supported file types:
	// .jar, .tar, .tar.gz, .tgz, and .zip.
	ArchiveUris []string `protobuf:"bytes,6,rep,name=archive_uris,json=archiveUris" json:"archive_uris,omitempty"`
	// [Optional] A mapping of property names to values, used to configure Spark.
	// Properties that conflict with values set by the Cloud Dataproc API may be
	// overwritten. Can include properties set in
	// /etc/spark/conf/spark-defaults.conf and classes in user code.
	Properties map[string]string `protobuf:"bytes,7,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] The runtime log config for job execution.
	LoggingConfig *LoggingConfig `protobuf:"bytes,8,opt,name=logging_config,json=loggingConfig" json:"logging_config,omitempty"`
}

func (m *SparkJob) Reset()                    { *m = SparkJob{} }
func (m *SparkJob) String() string            { return proto.CompactTextString(m) }
func (*SparkJob) ProtoMessage()               {}
func (*SparkJob) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

type isSparkJob_Driver interface {
	isSparkJob_Driver()
}

type SparkJob_MainJarFileUri struct {
	MainJarFileUri string `protobuf:"bytes,1,opt,name=main_jar_file_uri,json=mainJarFileUri,oneof"`
}
type SparkJob_MainClass struct {
	MainClass string `protobuf:"bytes,2,opt,name=main_class,json=mainClass,oneof"`
}

func (*SparkJob_MainJarFileUri) isSparkJob_Driver() {}
func (*SparkJob_MainClass) isSparkJob_Driver()      {}

func (m *SparkJob) GetDriver() isSparkJob_Driver {
	if m != nil {
		return m.Driver
	}
	return nil
}

func (m *SparkJob) GetMainJarFileUri() string {
	if x, ok := m.GetDriver().(*SparkJob_MainJarFileUri); ok {
		return x.MainJarFileUri
	}
	return ""
}

func (m *SparkJob) GetMainClass() string {
	if x, ok := m.GetDriver().(*SparkJob_MainClass); ok {
		return x.MainClass
	}
	return ""
}

func (m *SparkJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *SparkJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SparkJob) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SparkJob_OneofMarshaler, _SparkJob_OneofUnmarshaler, _SparkJob_OneofSizer, []interface{}{
		(*SparkJob_MainJarFileUri)(nil),
		(*SparkJob_MainClass)(nil),
	}
}

func _SparkJob_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SparkJob)
	// driver
	switch x := m.Driver.(type) {
	case *SparkJob_MainJarFileUri:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.MainJarFileUri)
	case *SparkJob_MainClass:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.MainClass)
	case nil:
	default:
		return fmt.Errorf("SparkJob.Driver has unexpected type %T", x)
	}
	return nil
}

func _SparkJob_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SparkJob)
	switch tag {
	case 1: // driver.main_jar_file_uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Driver = &SparkJob_MainJarFileUri{x}
		return true, err
	case 2: // driver.main_class
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Driver = &SparkJob_MainClass{x}
		return true, err
	default:
		return false, nil
	}
}

func _SparkJob_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SparkJob)
	// driver
	switch x := m.Driver.(type) {
	case *SparkJob_MainJarFileUri:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.MainJarFileUri)))
		n += len(x.MainJarFileUri)
	case *SparkJob_MainClass:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.MainClass)))
		n += len(x.MainClass)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Cloud Dataproc job for running
// [Apache PySpark](https://spark.apache.org/docs/0.9.0/python-programming-guide.html)
// applications on YARN.
type PySparkJob struct {
	// [Required] The HCFS URI of the main Python file to use as the driver. Must
	// be a .py file.
	MainPythonFileUri string `protobuf:"bytes,1,opt,name=main_python_file_uri,json=mainPythonFileUri" json:"main_python_file_uri,omitempty"`
	// [Optional] The arguments to pass to the driver.  Do not include arguments,
	// such as `--conf`, that can be set as job properties, since a collision may
	// occur that causes an incorrect job submission.
	Args []string `protobuf:"bytes,2,rep,name=args" json:"args,omitempty"`
	// [Optional] HCFS file URIs of Python files to pass to the PySpark
	// framework. Supported file types: .py, .egg, and .zip.
	PythonFileUris []string `protobuf:"bytes,3,rep,name=python_file_uris,json=pythonFileUris" json:"python_file_uris,omitempty"`
	// [Optional] HCFS URIs of jar files to add to the CLASSPATHs of the
	// Python driver and tasks.
	JarFileUris []string `protobuf:"bytes,4,rep,name=jar_file_uris,json=jarFileUris" json:"jar_file_uris,omitempty"`
	// [Optional] HCFS URIs of files to be copied to the working directory of
	// Python drivers and distributed tasks. Useful for naively parallel tasks.
	FileUris []string `protobuf:"bytes,5,rep,name=file_uris,json=fileUris" json:"file_uris,omitempty"`
	// [Optional] HCFS URIs of archives to be extracted in the working directory of
	// .jar, .tar, .tar.gz, .tgz, and .zip.
	ArchiveUris []string `protobuf:"bytes,6,rep,name=archive_uris,json=archiveUris" json:"archive_uris,omitempty"`
	// [Optional] A mapping of property names to values, used to configure PySpark.
	// Properties that conflict with values set by the Cloud Dataproc API may be
	// overwritten. Can include properties set in
	// /etc/spark/conf/spark-defaults.conf and classes in user code.
	Properties map[string]string `protobuf:"bytes,7,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] The runtime log config for job execution.
	LoggingConfig *LoggingConfig `protobuf:"bytes,8,opt,name=logging_config,json=loggingConfig" json:"logging_config,omitempty"`
}

func (m *PySparkJob) Reset()                    { *m = PySparkJob{} }
func (m *PySparkJob) String() string            { return proto.CompactTextString(m) }
func (*PySparkJob) ProtoMessage()               {}
func (*PySparkJob) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *PySparkJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *PySparkJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// A list of queries to run on a cluster.
type QueryList struct {
	// [Required] The queries to execute. You do not need to terminate a query
	// with a semicolon. Multiple queries can be specified in one string
	// by separating each with a semicolon. Here is an example of an Cloud
	// Dataproc API snippet that uses a QueryList to specify a HiveJob:
	//
	//     "hiveJob": {
	//       "queryList": {
	//         "queries": [
	//           "query1",
	//           "query2",
	//           "query3;query4",
	//         ]
	//       }
	//     }
	Queries []string `protobuf:"bytes,1,rep,name=queries" json:"queries,omitempty"`
}

func (m *QueryList) Reset()                    { *m = QueryList{} }
func (m *QueryList) String() string            { return proto.CompactTextString(m) }
func (*QueryList) ProtoMessage()               {}
func (*QueryList) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

// A Cloud Dataproc job for running [Apache Hive](https://hive.apache.org/)
// queries on YARN.
type HiveJob struct {
	// [Required] The sequence of Hive queries to execute, specified as either
	// an HCFS file URI or a list of queries.
	//
	// Types that are valid to be assigned to Queries:
	//	*HiveJob_QueryFileUri
	//	*HiveJob_QueryList
	Queries isHiveJob_Queries `protobuf_oneof:"queries"`
	// [Optional] Whether to continue executing queries if a query fails.
	// The default value is `false`. Setting to `true` can be useful when executing
	// independent parallel queries.
	ContinueOnFailure bool `protobuf:"varint,3,opt,name=continue_on_failure,json=continueOnFailure" json:"continue_on_failure,omitempty"`
	// [Optional] Mapping of query variable names to values (equivalent to the
	// Hive command: `SET name="value";`).
	ScriptVariables map[string]string `protobuf:"bytes,4,rep,name=script_variables,json=scriptVariables" json:"script_variables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] A mapping of property names and values, used to configure Hive.
	// Properties that conflict with values set by the Cloud Dataproc API may be
	// overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml,
	// /etc/hive/conf/hive-site.xml, and classes in user code.
	Properties map[string]string `protobuf:"bytes,5,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] HCFS URIs of jar files to add to the CLASSPATH of the
	// Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes
	// and UDFs.
	JarFileUris []string `protobuf:"bytes,6,rep,name=jar_file_uris,json=jarFileUris" json:"jar_file_uris,omitempty"`
}

func (m *HiveJob) Reset()                    { *m = HiveJob{} }
func (m *HiveJob) String() string            { return proto.CompactTextString(m) }
func (*HiveJob) ProtoMessage()               {}
func (*HiveJob) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

type isHiveJob_Queries interface {
	isHiveJob_Queries()
}

type HiveJob_QueryFileUri struct {
	QueryFileUri string `protobuf:"bytes,1,opt,name=query_file_uri,json=queryFileUri,oneof"`
}
type HiveJob_QueryList struct {
	QueryList *QueryList `protobuf:"bytes,2,opt,name=query_list,json=queryList,oneof"`
}

func (*HiveJob_QueryFileUri) isHiveJob_Queries() {}
func (*HiveJob_QueryList) isHiveJob_Queries()    {}

func (m *HiveJob) GetQueries() isHiveJob_Queries {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *HiveJob) GetQueryFileUri() string {
	if x, ok := m.GetQueries().(*HiveJob_QueryFileUri); ok {
		return x.QueryFileUri
	}
	return ""
}

func (m *HiveJob) GetQueryList() *QueryList {
	if x, ok := m.GetQueries().(*HiveJob_QueryList); ok {
		return x.QueryList
	}
	return nil
}

func (m *HiveJob) GetScriptVariables() map[string]string {
	if m != nil {
		return m.ScriptVariables
	}
	return nil
}

func (m *HiveJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HiveJob) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HiveJob_OneofMarshaler, _HiveJob_OneofUnmarshaler, _HiveJob_OneofSizer, []interface{}{
		(*HiveJob_QueryFileUri)(nil),
		(*HiveJob_QueryList)(nil),
	}
}

func _HiveJob_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HiveJob)
	// queries
	switch x := m.Queries.(type) {
	case *HiveJob_QueryFileUri:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.QueryFileUri)
	case *HiveJob_QueryList:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QueryList); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("HiveJob.Queries has unexpected type %T", x)
	}
	return nil
}

func _HiveJob_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HiveJob)
	switch tag {
	case 1: // queries.query_file_uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Queries = &HiveJob_QueryFileUri{x}
		return true, err
	case 2: // queries.query_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryList)
		err := b.DecodeMessage(msg)
		m.Queries = &HiveJob_QueryList{msg}
		return true, err
	default:
		return false, nil
	}
}

func _HiveJob_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HiveJob)
	// queries
	switch x := m.Queries.(type) {
	case *HiveJob_QueryFileUri:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.QueryFileUri)))
		n += len(x.QueryFileUri)
	case *HiveJob_QueryList:
		s := proto.Size(x.QueryList)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Cloud Dataproc job for running [Apache Spark SQL](http://spark.apache.org/sql/)
// queries.
type SparkSqlJob struct {
	// [Required] The sequence of Spark SQL queries to execute, specified as
	// either an HCFS file URI or as a list of queries.
	//
	// Types that are valid to be assigned to Queries:
	//	*SparkSqlJob_QueryFileUri
	//	*SparkSqlJob_QueryList
	Queries isSparkSqlJob_Queries `protobuf_oneof:"queries"`
	// [Optional] Mapping of query variable names to values (equivalent to the
	// Spark SQL command: SET `name="value";`).
	ScriptVariables map[string]string `protobuf:"bytes,3,rep,name=script_variables,json=scriptVariables" json:"script_variables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] A mapping of property names to values, used to configure
	// Spark SQL's SparkConf. Properties that conflict with values set by the
	// Cloud Dataproc API may be overwritten.
	Properties map[string]string `protobuf:"bytes,4,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] HCFS URIs of jar files to be added to the Spark CLASSPATH.
	JarFileUris []string `protobuf:"bytes,56,rep,name=jar_file_uris,json=jarFileUris" json:"jar_file_uris,omitempty"`
	// [Optional] The runtime log config for job execution.
	LoggingConfig *LoggingConfig `protobuf:"bytes,6,opt,name=logging_config,json=loggingConfig" json:"logging_config,omitempty"`
}

func (m *SparkSqlJob) Reset()                    { *m = SparkSqlJob{} }
func (m *SparkSqlJob) String() string            { return proto.CompactTextString(m) }
func (*SparkSqlJob) ProtoMessage()               {}
func (*SparkSqlJob) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

type isSparkSqlJob_Queries interface {
	isSparkSqlJob_Queries()
}

type SparkSqlJob_QueryFileUri struct {
	QueryFileUri string `protobuf:"bytes,1,opt,name=query_file_uri,json=queryFileUri,oneof"`
}
type SparkSqlJob_QueryList struct {
	QueryList *QueryList `protobuf:"bytes,2,opt,name=query_list,json=queryList,oneof"`
}

func (*SparkSqlJob_QueryFileUri) isSparkSqlJob_Queries() {}
func (*SparkSqlJob_QueryList) isSparkSqlJob_Queries()    {}

func (m *SparkSqlJob) GetQueries() isSparkSqlJob_Queries {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *SparkSqlJob) GetQueryFileUri() string {
	if x, ok := m.GetQueries().(*SparkSqlJob_QueryFileUri); ok {
		return x.QueryFileUri
	}
	return ""
}

func (m *SparkSqlJob) GetQueryList() *QueryList {
	if x, ok := m.GetQueries().(*SparkSqlJob_QueryList); ok {
		return x.QueryList
	}
	return nil
}

func (m *SparkSqlJob) GetScriptVariables() map[string]string {
	if m != nil {
		return m.ScriptVariables
	}
	return nil
}

func (m *SparkSqlJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *SparkSqlJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SparkSqlJob) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SparkSqlJob_OneofMarshaler, _SparkSqlJob_OneofUnmarshaler, _SparkSqlJob_OneofSizer, []interface{}{
		(*SparkSqlJob_QueryFileUri)(nil),
		(*SparkSqlJob_QueryList)(nil),
	}
}

func _SparkSqlJob_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SparkSqlJob)
	// queries
	switch x := m.Queries.(type) {
	case *SparkSqlJob_QueryFileUri:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.QueryFileUri)
	case *SparkSqlJob_QueryList:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QueryList); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("SparkSqlJob.Queries has unexpected type %T", x)
	}
	return nil
}

func _SparkSqlJob_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SparkSqlJob)
	switch tag {
	case 1: // queries.query_file_uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Queries = &SparkSqlJob_QueryFileUri{x}
		return true, err
	case 2: // queries.query_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryList)
		err := b.DecodeMessage(msg)
		m.Queries = &SparkSqlJob_QueryList{msg}
		return true, err
	default:
		return false, nil
	}
}

func _SparkSqlJob_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SparkSqlJob)
	// queries
	switch x := m.Queries.(type) {
	case *SparkSqlJob_QueryFileUri:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.QueryFileUri)))
		n += len(x.QueryFileUri)
	case *SparkSqlJob_QueryList:
		s := proto.Size(x.QueryList)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Cloud Dataproc job for running [Apache Pig](https://pig.apache.org/)
// queries on YARN.
type PigJob struct {
	// [Required] The sequence of Pig queries to execute, specified as an HCFS
	// file URI or a list of queries.
	//
	// Types that are valid to be assigned to Queries:
	//	*PigJob_QueryFileUri
	//	*PigJob_QueryList
	Queries isPigJob_Queries `protobuf_oneof:"queries"`
	// [Optional] Whether to continue executing queries if a query fails.
	// The default value is `false`. Setting to `true` can be useful when executing
	// independent parallel queries.
	ContinueOnFailure bool `protobuf:"varint,3,opt,name=continue_on_failure,json=continueOnFailure" json:"continue_on_failure,omitempty"`
	// [Optional] Mapping of query variable names to values (equivalent to the Pig
	// command: `name=[value]`).
	ScriptVariables map[string]string `protobuf:"bytes,4,rep,name=script_variables,json=scriptVariables" json:"script_variables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] A mapping of property names to values, used to configure Pig.
	// Properties that conflict with values set by the Cloud Dataproc API may be
	// overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml,
	// /etc/pig/conf/pig.properties, and classes in user code.
	Properties map[string]string `protobuf:"bytes,5,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// [Optional] HCFS URIs of jar files to add to the CLASSPATH of
	// the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
	JarFileUris []string `protobuf:"bytes,6,rep,name=jar_file_uris,json=jarFileUris" json:"jar_file_uris,omitempty"`
	// [Optional] The runtime log config for job execution.
	LoggingConfig *LoggingConfig `protobuf:"bytes,7,opt,name=logging_config,json=loggingConfig" json:"logging_config,omitempty"`
}

func (m *PigJob) Reset()                    { *m = PigJob{} }
func (m *PigJob) String() string            { return proto.CompactTextString(m) }
func (*PigJob) ProtoMessage()               {}
func (*PigJob) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

type isPigJob_Queries interface {
	isPigJob_Queries()
}

type PigJob_QueryFileUri struct {
	QueryFileUri string `protobuf:"bytes,1,opt,name=query_file_uri,json=queryFileUri,oneof"`
}
type PigJob_QueryList struct {
	QueryList *QueryList `protobuf:"bytes,2,opt,name=query_list,json=queryList,oneof"`
}

func (*PigJob_QueryFileUri) isPigJob_Queries() {}
func (*PigJob_QueryList) isPigJob_Queries()    {}

func (m *PigJob) GetQueries() isPigJob_Queries {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *PigJob) GetQueryFileUri() string {
	if x, ok := m.GetQueries().(*PigJob_QueryFileUri); ok {
		return x.QueryFileUri
	}
	return ""
}

func (m *PigJob) GetQueryList() *QueryList {
	if x, ok := m.GetQueries().(*PigJob_QueryList); ok {
		return x.QueryList
	}
	return nil
}

func (m *PigJob) GetScriptVariables() map[string]string {
	if m != nil {
		return m.ScriptVariables
	}
	return nil
}

func (m *PigJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *PigJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PigJob) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PigJob_OneofMarshaler, _PigJob_OneofUnmarshaler, _PigJob_OneofSizer, []interface{}{
		(*PigJob_QueryFileUri)(nil),
		(*PigJob_QueryList)(nil),
	}
}

func _PigJob_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PigJob)
	// queries
	switch x := m.Queries.(type) {
	case *PigJob_QueryFileUri:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.QueryFileUri)
	case *PigJob_QueryList:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QueryList); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PigJob.Queries has unexpected type %T", x)
	}
	return nil
}

func _PigJob_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PigJob)
	switch tag {
	case 1: // queries.query_file_uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Queries = &PigJob_QueryFileUri{x}
		return true, err
	case 2: // queries.query_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryList)
		err := b.DecodeMessage(msg)
		m.Queries = &PigJob_QueryList{msg}
		return true, err
	default:
		return false, nil
	}
}

func _PigJob_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PigJob)
	// queries
	switch x := m.Queries.(type) {
	case *PigJob_QueryFileUri:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.QueryFileUri)))
		n += len(x.QueryFileUri)
	case *PigJob_QueryList:
		s := proto.Size(x.QueryList)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Cloud Dataproc job config.
type JobPlacement struct {
	// [Required] The name of the cluster where the job will be submitted.
	ClusterName string `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
	// [Output-only] A cluster UUID generated by the Cloud Dataproc service when
	// the job is submitted.
	ClusterUuid string `protobuf:"bytes,2,opt,name=cluster_uuid,json=clusterUuid" json:"cluster_uuid,omitempty"`
}

func (m *JobPlacement) Reset()                    { *m = JobPlacement{} }
func (m *JobPlacement) String() string            { return proto.CompactTextString(m) }
func (*JobPlacement) ProtoMessage()               {}
func (*JobPlacement) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

// Cloud Dataproc job status.
type JobStatus struct {
	// [Output-only] A state message specifying the overall job state.
	State JobStatus_State `protobuf:"varint,1,opt,name=state,enum=google.cloud.dataproc.v1.JobStatus_State" json:"state,omitempty"`
	// [Output-only] Optional job state details, such as an error
	// description if the state is <code>ERROR</code>.
	Details string `protobuf:"bytes,2,opt,name=details" json:"details,omitempty"`
	// [Output-only] The time when this state was entered.
	StateStartTime *google_protobuf3.Timestamp `protobuf:"bytes,6,opt,name=state_start_time,json=stateStartTime" json:"state_start_time,omitempty"`
}

func (m *JobStatus) Reset()                    { *m = JobStatus{} }
func (m *JobStatus) String() string            { return proto.CompactTextString(m) }
func (*JobStatus) ProtoMessage()               {}
func (*JobStatus) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *JobStatus) GetStateStartTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.StateStartTime
	}
	return nil
}

// Encapsulates the full scoping used to reference a job.
type JobReference struct {
	// [Required] The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Optional] The job ID, which must be unique within the project. The job ID
	// is generated by the server upon job submission or provided by the user as a
	// means to perform retries without creating duplicate jobs. The ID must
	// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or
	// hyphens (-). The maximum length is 512 characters.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId" json:"job_id,omitempty"`
}

func (m *JobReference) Reset()                    { *m = JobReference{} }
func (m *JobReference) String() string            { return proto.CompactTextString(m) }
func (*JobReference) ProtoMessage()               {}
func (*JobReference) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

// A Cloud Dataproc job resource.
type Job struct {
	// [Optional] The fully qualified reference to the job, which can be used to
	// obtain the equivalent REST path of the job resource. If this property
	// is not specified when a job is created, the server generates a
	// <code>job_id</code>.
	Reference *JobReference `protobuf:"bytes,1,opt,name=reference" json:"reference,omitempty"`
	// [Required] Job information, including how, when, and where to
	// run the job.
	Placement *JobPlacement `protobuf:"bytes,2,opt,name=placement" json:"placement,omitempty"`
	// [Required] The application/framework-specific portion of the job.
	//
	// Types that are valid to be assigned to TypeJob:
	//	*Job_HadoopJob
	//	*Job_SparkJob
	//	*Job_PysparkJob
	//	*Job_HiveJob
	//	*Job_PigJob
	//	*Job_SparkSqlJob
	TypeJob isJob_TypeJob `protobuf_oneof:"type_job"`
	// [Output-only] The job status. Additional application-specific
	// status information may be contained in the <code>type_job</code>
	// and <code>yarn_applications</code> fields.
	Status *JobStatus `protobuf:"bytes,8,opt,name=status" json:"status,omitempty"`
	// [Output-only] The previous job status.
	StatusHistory []*JobStatus `protobuf:"bytes,13,rep,name=status_history,json=statusHistory" json:"status_history,omitempty"`
	// [Output-only] A URI pointing to the location of the stdout of the job's
	// driver program.
	DriverOutputResourceUri string `protobuf:"bytes,17,opt,name=driver_output_resource_uri,json=driverOutputResourceUri" json:"driver_output_resource_uri,omitempty"`
	// [Output-only] If present, the location of miscellaneous control files
	// which may be used as part of job setup and handling. If not present,
	// control files may be placed in the same location as `driver_output_uri`.
	DriverControlFilesUri string `protobuf:"bytes,15,opt,name=driver_control_files_uri,json=driverControlFilesUri" json:"driver_control_files_uri,omitempty"`
}

func (m *Job) Reset()                    { *m = Job{} }
func (m *Job) String() string            { return proto.CompactTextString(m) }
func (*Job) ProtoMessage()               {}
func (*Job) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

type isJob_TypeJob interface {
	isJob_TypeJob()
}

type Job_HadoopJob struct {
	HadoopJob *HadoopJob `protobuf:"bytes,3,opt,name=hadoop_job,json=hadoopJob,oneof"`
}
type Job_SparkJob struct {
	SparkJob *SparkJob `protobuf:"bytes,4,opt,name=spark_job,json=sparkJob,oneof"`
}
type Job_PysparkJob struct {
	PysparkJob *PySparkJob `protobuf:"bytes,5,opt,name=pyspark_job,json=pysparkJob,oneof"`
}
type Job_HiveJob struct {
	HiveJob *HiveJob `protobuf:"bytes,6,opt,name=hive_job,json=hiveJob,oneof"`
}
type Job_PigJob struct {
	PigJob *PigJob `protobuf:"bytes,7,opt,name=pig_job,json=pigJob,oneof"`
}
type Job_SparkSqlJob struct {
	SparkSqlJob *SparkSqlJob `protobuf:"bytes,12,opt,name=spark_sql_job,json=sparkSqlJob,oneof"`
}

func (*Job_HadoopJob) isJob_TypeJob()   {}
func (*Job_SparkJob) isJob_TypeJob()    {}
func (*Job_PysparkJob) isJob_TypeJob()  {}
func (*Job_HiveJob) isJob_TypeJob()     {}
func (*Job_PigJob) isJob_TypeJob()      {}
func (*Job_SparkSqlJob) isJob_TypeJob() {}

func (m *Job) GetTypeJob() isJob_TypeJob {
	if m != nil {
		return m.TypeJob
	}
	return nil
}

func (m *Job) GetReference() *JobReference {
	if m != nil {
		return m.Reference
	}
	return nil
}

func (m *Job) GetPlacement() *JobPlacement {
	if m != nil {
		return m.Placement
	}
	return nil
}

func (m *Job) GetHadoopJob() *HadoopJob {
	if x, ok := m.GetTypeJob().(*Job_HadoopJob); ok {
		return x.HadoopJob
	}
	return nil
}

func (m *Job) GetSparkJob() *SparkJob {
	if x, ok := m.GetTypeJob().(*Job_SparkJob); ok {
		return x.SparkJob
	}
	return nil
}

func (m *Job) GetPysparkJob() *PySparkJob {
	if x, ok := m.GetTypeJob().(*Job_PysparkJob); ok {
		return x.PysparkJob
	}
	return nil
}

func (m *Job) GetHiveJob() *HiveJob {
	if x, ok := m.GetTypeJob().(*Job_HiveJob); ok {
		return x.HiveJob
	}
	return nil
}

func (m *Job) GetPigJob() *PigJob {
	if x, ok := m.GetTypeJob().(*Job_PigJob); ok {
		return x.PigJob
	}
	return nil
}

func (m *Job) GetSparkSqlJob() *SparkSqlJob {
	if x, ok := m.GetTypeJob().(*Job_SparkSqlJob); ok {
		return x.SparkSqlJob
	}
	return nil
}

func (m *Job) GetStatus() *JobStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Job) GetStatusHistory() []*JobStatus {
	if m != nil {
		return m.StatusHistory
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Job) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Job_OneofMarshaler, _Job_OneofUnmarshaler, _Job_OneofSizer, []interface{}{
		(*Job_HadoopJob)(nil),
		(*Job_SparkJob)(nil),
		(*Job_PysparkJob)(nil),
		(*Job_HiveJob)(nil),
		(*Job_PigJob)(nil),
		(*Job_SparkSqlJob)(nil),
	}
}

func _Job_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Job)
	// type_job
	switch x := m.TypeJob.(type) {
	case *Job_HadoopJob:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HadoopJob); err != nil {
			return err
		}
	case *Job_SparkJob:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SparkJob); err != nil {
			return err
		}
	case *Job_PysparkJob:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PysparkJob); err != nil {
			return err
		}
	case *Job_HiveJob:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HiveJob); err != nil {
			return err
		}
	case *Job_PigJob:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PigJob); err != nil {
			return err
		}
	case *Job_SparkSqlJob:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SparkSqlJob); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Job.TypeJob has unexpected type %T", x)
	}
	return nil
}

func _Job_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Job)
	switch tag {
	case 3: // type_job.hadoop_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HadoopJob)
		err := b.DecodeMessage(msg)
		m.TypeJob = &Job_HadoopJob{msg}
		return true, err
	case 4: // type_job.spark_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SparkJob)
		err := b.DecodeMessage(msg)
		m.TypeJob = &Job_SparkJob{msg}
		return true, err
	case 5: // type_job.pyspark_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PySparkJob)
		err := b.DecodeMessage(msg)
		m.TypeJob = &Job_PysparkJob{msg}
		return true, err
	case 6: // type_job.hive_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HiveJob)
		err := b.DecodeMessage(msg)
		m.TypeJob = &Job_HiveJob{msg}
		return true, err
	case 7: // type_job.pig_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PigJob)
		err := b.DecodeMessage(msg)
		m.TypeJob = &Job_PigJob{msg}
		return true, err
	case 12: // type_job.spark_sql_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SparkSqlJob)
		err := b.DecodeMessage(msg)
		m.TypeJob = &Job_SparkSqlJob{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Job_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Job)
	// type_job
	switch x := m.TypeJob.(type) {
	case *Job_HadoopJob:
		s := proto.Size(x.HadoopJob)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Job_SparkJob:
		s := proto.Size(x.SparkJob)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Job_PysparkJob:
		s := proto.Size(x.PysparkJob)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Job_HiveJob:
		s := proto.Size(x.HiveJob)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Job_PigJob:
		s := proto.Size(x.PigJob)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Job_SparkSqlJob:
		s := proto.Size(x.SparkSqlJob)
		n += proto.SizeVarint(12<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A request to submit a job.
type SubmitJobRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The job resource.
	Job *Job `protobuf:"bytes,2,opt,name=job" json:"job,omitempty"`
}

func (m *SubmitJobRequest) Reset()                    { *m = SubmitJobRequest{} }
func (m *SubmitJobRequest) String() string            { return proto.CompactTextString(m) }
func (*SubmitJobRequest) ProtoMessage()               {}
func (*SubmitJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *SubmitJobRequest) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

// A request to get the resource representation for a job in a project.
type GetJobRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The job ID.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId" json:"job_id,omitempty"`
}

func (m *GetJobRequest) Reset()                    { *m = GetJobRequest{} }
func (m *GetJobRequest) String() string            { return proto.CompactTextString(m) }
func (*GetJobRequest) ProtoMessage()               {}
func (*GetJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

// A request to list jobs in a project.
type ListJobsRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,6,opt,name=region" json:"region,omitempty"`
	// [Optional] The number of results to return in each response.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// [Optional] The page token, returned by a previous call, to request the
	// next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// [Optional] If set, the returned jobs list includes only jobs that were
	// submitted to the named cluster.
	ClusterName string `protobuf:"bytes,4,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
	// [Optional] Specifies enumerated categories of jobs to list
	// (default = match ALL jobs).
	JobStateMatcher ListJobsRequest_JobStateMatcher `protobuf:"varint,5,opt,name=job_state_matcher,json=jobStateMatcher,enum=google.cloud.dataproc.v1.ListJobsRequest_JobStateMatcher" json:"job_state_matcher,omitempty"`
}

func (m *ListJobsRequest) Reset()                    { *m = ListJobsRequest{} }
func (m *ListJobsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListJobsRequest) ProtoMessage()               {}
func (*ListJobsRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{14} }

// A list of jobs in a project.
type ListJobsResponse struct {
	// [Output-only] Jobs list.
	Jobs []*Job `protobuf:"bytes,1,rep,name=jobs" json:"jobs,omitempty"`
	// [Optional] This token is included in the response if there are more results
	// to fetch. To fetch additional results, provide this value as the
	// `page_token` in a subsequent <code>ListJobsRequest</code>.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListJobsResponse) Reset()                    { *m = ListJobsResponse{} }
func (m *ListJobsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListJobsResponse) ProtoMessage()               {}
func (*ListJobsResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{15} }

func (m *ListJobsResponse) GetJobs() []*Job {
	if m != nil {
		return m.Jobs
	}
	return nil
}

// A request to cancel a job.
type CancelJobRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The job ID.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId" json:"job_id,omitempty"`
}

func (m *CancelJobRequest) Reset()                    { *m = CancelJobRequest{} }
func (m *CancelJobRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelJobRequest) ProtoMessage()               {}
func (*CancelJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{16} }

// A request to delete a job.
type DeleteJobRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The job ID.
	JobId string `protobuf:"bytes,2,opt,name=job_id,json=jobId" json:"job_id,omitempty"`
}

func (m *DeleteJobRequest) Reset()                    { *m = DeleteJobRequest{} }
func (m *DeleteJobRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteJobRequest) ProtoMessage()               {}
func (*DeleteJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{17} }

func init() {
	proto.RegisterType((*LoggingConfig)(nil), "google.cloud.dataproc.v1.LoggingConfig")
	proto.RegisterType((*HadoopJob)(nil), "google.cloud.dataproc.v1.HadoopJob")
	proto.RegisterType((*SparkJob)(nil), "google.cloud.dataproc.v1.SparkJob")
	proto.RegisterType((*PySparkJob)(nil), "google.cloud.dataproc.v1.PySparkJob")
	proto.RegisterType((*QueryList)(nil), "google.cloud.dataproc.v1.QueryList")
	proto.RegisterType((*HiveJob)(nil), "google.cloud.dataproc.v1.HiveJob")
	proto.RegisterType((*SparkSqlJob)(nil), "google.cloud.dataproc.v1.SparkSqlJob")
	proto.RegisterType((*PigJob)(nil), "google.cloud.dataproc.v1.PigJob")
	proto.RegisterType((*JobPlacement)(nil), "google.cloud.dataproc.v1.JobPlacement")
	proto.RegisterType((*JobStatus)(nil), "google.cloud.dataproc.v1.JobStatus")
	proto.RegisterType((*JobReference)(nil), "google.cloud.dataproc.v1.JobReference")
	proto.RegisterType((*Job)(nil), "google.cloud.dataproc.v1.Job")
	proto.RegisterType((*SubmitJobRequest)(nil), "google.cloud.dataproc.v1.SubmitJobRequest")
	proto.RegisterType((*GetJobRequest)(nil), "google.cloud.dataproc.v1.GetJobRequest")
	proto.RegisterType((*ListJobsRequest)(nil), "google.cloud.dataproc.v1.ListJobsRequest")
	proto.RegisterType((*ListJobsResponse)(nil), "google.cloud.dataproc.v1.ListJobsResponse")
	proto.RegisterType((*CancelJobRequest)(nil), "google.cloud.dataproc.v1.CancelJobRequest")
	proto.RegisterType((*DeleteJobRequest)(nil), "google.cloud.dataproc.v1.DeleteJobRequest")
	proto.RegisterEnum("google.cloud.dataproc.v1.LoggingConfig_Level", LoggingConfig_Level_name, LoggingConfig_Level_value)
	proto.RegisterEnum("google.cloud.dataproc.v1.JobStatus_State", JobStatus_State_name, JobStatus_State_value)
	proto.RegisterEnum("google.cloud.dataproc.v1.ListJobsRequest_JobStateMatcher", ListJobsRequest_JobStateMatcher_name, ListJobsRequest_JobStateMatcher_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for JobController service

type JobControllerClient interface {
	// Submits a job to a cluster.
	SubmitJob(ctx context.Context, in *SubmitJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Gets the resource representation for a job in a project.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Lists regions/{region}/jobs in a project.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Starts a job cancellation request. To access the job resource
	// after cancellation, call
	// [regions/{region}/jobs.list](/dataproc/reference/rest/v1/projects.regions.jobs/list) or
	// [regions/{region}/jobs.get](/dataproc/reference/rest/v1/projects.regions.jobs/get).
	CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Deletes the job from the project. If the job is active, the delete fails,
	// and the response returns `FAILED_PRECONDITION`.
	DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
}

type jobControllerClient struct {
	cc *grpc.ClientConn
}

func NewJobControllerClient(cc *grpc.ClientConn) JobControllerClient {
	return &jobControllerClient{cc}
}

func (c *jobControllerClient) SubmitJob(ctx context.Context, in *SubmitJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.JobController/SubmitJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobControllerClient) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.JobController/GetJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobControllerClient) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.JobController/ListJobs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobControllerClient) CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.JobController/CancelJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobControllerClient) DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.JobController/DeleteJob", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for JobController service

type JobControllerServer interface {
	// Submits a job to a cluster.
	SubmitJob(context.Context, *SubmitJobRequest) (*Job, error)
	// Gets the resource representation for a job in a project.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Lists regions/{region}/jobs in a project.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Starts a job cancellation request. To access the job resource
	// after cancellation, call
	// [regions/{region}/jobs.list](/dataproc/reference/rest/v1/projects.regions.jobs/list) or
	// [regions/{region}/jobs.get](/dataproc/reference/rest/v1/projects.regions.jobs/get).
	CancelJob(context.Context, *CancelJobRequest) (*Job, error)
	// Deletes the job from the project. If the job is active, the delete fails,
	// and the response returns `FAILED_PRECONDITION`.
	DeleteJob(context.Context, *DeleteJobRequest) (*google_protobuf2.Empty, error)
}

func RegisterJobControllerServer(s *grpc.Server, srv JobControllerServer) {
	s.RegisterService(&_JobController_serviceDesc, srv)
}

func _JobController_SubmitJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).SubmitJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.JobController/SubmitJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).SubmitJob(ctx, req.(*SubmitJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobController_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.JobController/GetJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobController_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.JobController/ListJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobController_CancelJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).CancelJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.JobController/CancelJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).CancelJob(ctx, req.(*CancelJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobController_DeleteJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).DeleteJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.JobController/DeleteJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).DeleteJob(ctx, req.(*DeleteJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _JobController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.JobController",
	HandlerType: (*JobControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SubmitJob",
			Handler:    _JobController_SubmitJob_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _JobController_GetJob_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _JobController_ListJobs_Handler,
		},
		{
			MethodName: "CancelJob",
			Handler:    _JobController_CancelJob_Handler,
		},
		{
			MethodName: "DeleteJob",
			Handler:    _JobController_DeleteJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/cloud/dataproc/v1/jobs.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/cloud/dataproc/v1/jobs.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 1878 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xdc, 0x58, 0xdd, 0x6e, 0x23, 0x49,
	0x15, 0x8e, 0xff, 0xdd, 0xc7, 0x63, 0xa7, 0x53, 0xcc, 0x2c, 0x96, 0x97, 0x15, 0xd9, 0x5e, 0x76,
	0xc8, 0xce, 0x0a, 0x37, 0xf1, 0xc0, 0xec, 0x90, 0x00, 0x8b, 0x63, 0x3b, 0x93, 0x04, 0xe3, 0x78,
	0xdb, 0xce, 0x70, 0x85, 0x7a, 0xda, 0x76, 0xc5, 0xe9, 0x4c, 0xbb, 0xab, 0xd3, 0x55, 0x6d, 0xe1,
	0x19, 0xcd, 0x0d, 0x2f, 0x80, 0xf8, 0x11, 0x12, 0x5c, 0xf2, 0x14, 0x48, 0x08, 0x71, 0x01, 0xe2,
	0x05, 0xb8, 0x45, 0x5c, 0xf1, 0x20, 0xa8, 0xaa, 0xba, 0x1d, 0xe7, 0xcf, 0x76, 0x76, 0x76, 0x57,
	0xbb, 0x73, 0x93, 0x54, 0x9f, 0xbf, 0x3a, 0x55, 0xdf, 0x77, 0x4e, 0x55, 0x19, 0x76, 0x86, 0x84,
	0x0c, 0x1d, 0x5c, 0x1e, 0x12, 0xc7, 0x72, 0x87, 0x65, 0xe2, 0x0f, 0xf5, 0x21, 0x76, 0x3d, 0x9f,
	0x30, 0xa2, 0x4b, 0x95, 0xe5, 0xd9, 0x54, 0xef, 0x3b, 0x24, 0x18, 0xe8, 0x03, 0x8b, 0x59, 0x9e,
	0x4f, 0xfa, 0xfa, 0x78, 0x53, 0x3f, 0x25, 0x3d, 0x5a, 0x16, 0x76, 0xa8, 0x18, 0xc6, 0x10, 0x46,
	0xe5, 0xc8, 0xa8, 0x3c, 0xde, 0x2c, 0xed, 0x2f, 0x17, 0xdd, 0xf2, 0x6c, 0x9d, 0x62, 0x7f, 0x6c,
	0xf7, 0x71, 0x9f, 0xb8, 0xc7, 0xf6, 0x50, 0xb7, 0x5c, 0x97, 0x30, 0x8b, 0xd9, 0xc4, 0x0d, 0x27,
	0x29, 0x3d, 0x1c, 0xda, 0xec, 0x24, 0xe8, 0x95, 0xfb, 0x64, 0xa4, 0xcb, 0x70, 0xba, 0x50, 0xf4,
	0x82, 0x63, 0xdd, 0x63, 0x13, 0x0f, 0x53, 0x1d, 0x8f, 0x3c, 0x36, 0x91, 0x7f, 0x43, 0xa7, 0xed,
	0xc5, 0x4e, 0xcc, 0x1e, 0x61, 0xca, 0xac, 0x91, 0x77, 0x3e, 0x92, 0xce, 0xda, 0x7f, 0xe3, 0x90,
	0x6f, 0x92, 0xe1, 0xd0, 0x76, 0x87, 0x35, 0x91, 0x15, 0x3a, 0x81, 0xb5, 0x81, 0x6f, 0x8f, 0xb1,
	0x6f, 0x3a, 0x64, 0x68, 0x3a, 0x78, 0x8c, 0x1d, 0x5a, 0x8c, 0xaf, 0x27, 0x36, 0x72, 0x95, 0x1f,
	0x96, 0x6f, 0xda, 0x84, 0xf2, 0x85, 0x18, 0xe5, 0xba, 0x08, 0xd0, 0x24, 0xc3, 0xa6, 0x70, 0x6f,
	0xb8, 0xcc, 0x9f, 0x18, 0xab, 0x83, 0x8b, 0xd2, 0xd2, 0x19, 0xdc, 0xbd, 0xce, 0x10, 0xa9, 0x90,
	0x78, 0x8e, 0x27, 0xc5, 0xd8, 0x7a, 0x6c, 0x43, 0x31, 0xf8, 0x10, 0xd5, 0x20, 0x35, 0xb6, 0x9c,
	0x00, 0x17, 0xe3, 0xeb, 0xb1, 0x8d, 0x42, 0xe5, 0x3b, 0xcb, 0xe6, 0x21, 0xa2, 0x1a, 0xd2, 0x77,
	0x2b, 0xfe, 0x38, 0xa6, 0x79, 0x90, 0x12, 0x32, 0x74, 0x0f, 0xd6, 0x9a, 0x8d, 0xa7, 0x8d, 0xa6,
	0x79, 0xd4, 0xea, 0xb4, 0x1b, 0xb5, 0xfd, 0xdd, 0xfd, 0x46, 0x5d, 0x5d, 0x41, 0x19, 0x48, 0x54,
	0x9b, 0x4d, 0x35, 0x86, 0x14, 0x48, 0x75, 0x8d, 0x6a, 0xad, 0xa1, 0xc6, 0xf9, 0xb0, 0xde, 0xd8,
	0x39, 0x7a, 0xa2, 0x26, 0x50, 0x16, 0x92, 0xfb, 0xad, 0xdd, 0x43, 0x35, 0xc9, 0x47, 0x3f, 0xaf,
	0x1a, 0x2d, 0x35, 0xc5, 0xd5, 0x0d, 0xc3, 0x38, 0x34, 0xd4, 0x34, 0x1f, 0xee, 0x56, 0xbb, 0xd5,
	0xa6, 0x9a, 0xe1, 0x81, 0x0e, 0x77, 0x77, 0xd5, 0xac, 0xf6, 0xf7, 0x04, 0x28, 0x7b, 0xd6, 0x80,
	0x10, 0xef, 0x80, 0xf4, 0xd0, 0x87, 0xb0, 0x36, 0xb2, 0x6c, 0xd7, 0x3c, 0xb5, 0x7c, 0xf3, 0xd8,
	0x76, 0xb0, 0x19, 0xf8, 0xb6, 0x5c, 0xe8, 0xde, 0x8a, 0x51, 0xe0, 0xaa, 0x03, 0xcb, 0xdf, 0xb5,
	0x1d, 0x7c, 0xe4, 0xdb, 0xe8, 0x9b, 0x00, 0xc2, 0xb8, 0xef, 0x58, 0x94, 0x8a, 0xa5, 0x73, 0x2b,
	0x85, 0xcb, 0x6a, 0x5c, 0x84, 0x10, 0x24, 0x2d, 0x7f, 0x48, 0x8b, 0x89, 0xf5, 0xc4, 0x86, 0x62,
	0x88, 0x31, 0xd2, 0x20, 0x3f, 0x1b, 0x9c, 0x16, 0x93, 0x42, 0x99, 0x3b, 0x9d, 0xc6, 0xa5, 0xe8,
	0x6d, 0x50, 0xce, 0xf5, 0x29, 0xa1, 0xcf, 0x1e, 0x47, 0xca, 0x77, 0xe1, 0x8e, 0xe5, 0xf7, 0x4f,
	0xec, 0x71, 0xa8, 0x4f, 0x4b, 0xff, 0x50, 0x26, 0x4c, 0x3a, 0x00, 0x9e, 0x4f, 0x3c, 0xec, 0x33,
	0x1b, 0xd3, 0x62, 0x46, 0x70, 0xe3, 0xe1, 0xcd, 0x98, 0x4c, 0x97, 0x5f, 0x6e, 0x4f, 0xbd, 0x24,
	0x25, 0x66, 0xc2, 0xa0, 0x16, 0x14, 0x1c, 0x09, 0x9e, 0x29, 0xeb, 0xa3, 0x98, 0x5d, 0x8f, 0x6d,
	0xe4, 0x2a, 0xdf, 0x5e, 0x12, 0x6c, 0x23, 0xef, 0xcc, 0x7e, 0x96, 0x7e, 0x04, 0xab, 0x97, 0xa6,
	0xbb, 0x86, 0x58, 0x77, 0x67, 0x89, 0xa5, 0xcc, 0x30, 0x65, 0x27, 0x0b, 0x69, 0xc9, 0x57, 0xed,
	0x6f, 0x09, 0xc8, 0x76, 0x3c, 0xcb, 0x7f, 0xfe, 0xe6, 0x00, 0x68, 0x5c, 0x03, 0x60, 0xe5, 0xe6,
	0x7d, 0x8e, 0x56, 0xff, 0xd5, 0xc4, 0xef, 0x9f, 0x09, 0x80, 0xf6, 0x64, 0x8a, 0xa0, 0x0e, 0x77,
	0x05, 0x28, 0xde, 0x84, 0x9d, 0x10, 0xf7, 0x12, 0x88, 0x86, 0x40, 0xb7, 0x2d, 0x54, 0x11, 0x8a,
	0x11, 0x48, 0xf1, 0x19, 0x90, 0x36, 0x40, 0xbd, 0xe4, 0x1f, 0x81, 0x58, 0xf0, 0x66, 0x9d, 0xbf,
	0x18, 0x38, 0xbb, 0xd7, 0xc0, 0xf9, 0xbd, 0x9b, 0xb7, 0xfd, 0x7c, 0x33, 0xbe, 0x42, 0x80, 0x6a,
	0xef, 0x83, 0xf2, 0x49, 0x80, 0xfd, 0x49, 0xd3, 0xa6, 0x0c, 0x15, 0x21, 0x73, 0x16, 0x60, 0x9f,
	0x2f, 0x37, 0x26, 0xf6, 0x23, 0xfa, 0xd4, 0x7e, 0x9d, 0x84, 0xcc, 0x9e, 0x3d, 0xc6, 0x1c, 0xea,
	0xfb, 0x50, 0xe0, 0xe2, 0xc9, 0xd5, 0x4a, 0xbd, 0x23, 0xe4, 0x11, 0xc2, 0x75, 0x00, 0x69, 0xe7,
	0xd8, 0x94, 0x89, 0x99, 0x73, 0x95, 0xf7, 0x6e, 0x5e, 0xe5, 0x34, 0x0d, 0x5e, 0xcc, 0x67, 0xd3,
	0x9c, 0xca, 0xf0, 0xb5, 0x3e, 0x71, 0x99, 0xed, 0x06, 0xd8, 0xe4, 0xc4, 0xb0, 0x6c, 0x27, 0xf0,
	0x71, 0x31, 0xb1, 0x1e, 0xdb, 0xc8, 0x1a, 0x6b, 0x91, 0xea, 0xd0, 0xdd, 0x95, 0x0a, 0x64, 0x81,
	0x4a, 0xfb, 0xbe, 0xed, 0x31, 0x73, 0x6c, 0xf9, 0xb6, 0xd5, 0x73, 0xb0, 0x24, 0x47, 0xae, 0xf2,
	0x68, 0x4e, 0x2f, 0x95, 0x4b, 0x2b, 0x77, 0x84, 0xe7, 0xd3, 0xc8, 0x31, 0x3c, 0x61, 0xe9, 0x45,
	0x29, 0xfa, 0xe4, 0x02, 0x31, 0x52, 0x22, 0xf8, 0xe6, 0xe2, 0xe0, 0xf3, 0x58, 0x71, 0x85, 0xcf,
	0xe9, 0x2b, 0x7c, 0x2e, 0xed, 0xc0, 0xdd, 0xeb, 0xf2, 0xbb, 0x0d, 0xdc, 0xaf, 0x5b, 0xfe, 0xca,
	0x94, 0x20, 0xda, 0x5f, 0x93, 0x90, 0x13, 0x84, 0xef, 0x9c, 0x39, 0x5f, 0x3c, 0x2b, 0xf0, 0x35,
	0x28, 0x27, 0x04, 0x10, 0x5b, 0x0b, 0x1a, 0xae, 0x4c, 0x77, 0x49, 0xa4, 0x8f, 0x2e, 0x20, 0x2d,
	0x69, 0xf4, 0xfd, 0xe5, 0x26, 0xb8, 0x15, 0xda, 0x8f, 0xaf, 0x76, 0xaf, 0xab, 0x7d, 0x22, 0xfd,
	0x5a, 0x7d, 0xe2, 0xcb, 0xc5, 0x9e, 0xff, 0x24, 0x21, 0xdd, 0xb6, 0x87, 0x5f, 0xfe, 0x76, 0xf2,
	0xec, 0xc6, 0x76, 0x32, 0x87, 0x07, 0x72, 0x65, 0x4b, 0x72, 0xac, 0x7d, 0x4d, 0x37, 0xf9, 0xee,
	0xc2, 0xd8, 0xaf, 0xd9, 0x4c, 0xae, 0xa1, 0x57, 0xe6, 0x0d, 0xa2, 0x57, 0x17, 0xee, 0x1c, 0x90,
	0x5e, 0xdb, 0xb1, 0xfa, 0x78, 0x84, 0x5d, 0xc6, 0x4f, 0xfb, 0xbe, 0x13, 0x50, 0x86, 0x7d, 0xd3,
	0xb5, 0x46, 0x38, 0x8c, 0x97, 0x0b, 0x65, 0x2d, 0x6b, 0x84, 0x67, 0x4d, 0x82, 0xc0, 0x1e, 0x84,
	0xe1, 0x23, 0x93, 0xa3, 0xc0, 0x1e, 0x68, 0xff, 0x88, 0x83, 0x72, 0x40, 0x7a, 0x1d, 0x66, 0xb1,
	0x80, 0xa2, 0x8f, 0x21, 0x45, 0x99, 0xc5, 0x64, 0xb0, 0x42, 0xe5, 0x83, 0x9b, 0x37, 0x6e, 0xea,
	0x53, 0xe6, 0xff, 0xb0, 0x21, 0xfd, 0xf8, 0x69, 0x3b, 0xc0, 0xcc, 0xb2, 0x9d, 0xf0, 0x12, 0x6b,
	0x44, 0x9f, 0xa8, 0x0e, 0xaa, 0x30, 0x31, 0x29, 0xb3, 0x7c, 0x66, 0xf2, 0xd7, 0x65, 0x58, 0xfd,
	0xa5, 0x68, 0x96, 0xe8, 0x2d, 0x5a, 0xee, 0x46, 0x4f, 0x4f, 0xa3, 0x20, 0x7c, 0x3a, 0xdc, 0x85,
	0x0b, 0xb5, 0xdf, 0xc7, 0x20, 0x25, 0x26, 0xe4, 0xcf, 0xb2, 0x4e, 0xb7, 0xda, 0x6d, 0x5c, 0x7a,
	0x96, 0xe5, 0x20, 0xd3, 0x6e, 0xb4, 0xea, 0xfb, 0xad, 0x27, 0x6a, 0x0c, 0x15, 0x00, 0x3a, 0x8d,
	0xee, 0x51, 0xdb, 0xac, 0x1f, 0xb6, 0x1a, 0x6a, 0x96, 0x2b, 0x8d, 0xa3, 0x56, 0x8b, 0x2b, 0xe3,
	0x08, 0x41, 0xa1, 0x56, 0x6d, 0xd5, 0x1a, 0x4d, 0x33, 0x72, 0x48, 0xcc, 0xc8, 0x3a, 0xdd, 0xaa,
	0xd1, 0x6d, 0xd4, 0xd5, 0x0c, 0xca, 0x83, 0x22, 0x65, 0xcd, 0x46, 0x5d, 0x3e, 0xe7, 0x44, 0xb4,
	0xd9, 0xe7, 0x9c, 0x56, 0x17, 0xd8, 0x18, 0xf8, 0x18, 0xfb, 0xd8, 0xed, 0x63, 0xf4, 0x8e, 0xe0,
	0xff, 0x29, 0xee, 0x33, 0xd3, 0x1e, 0x84, 0xc8, 0x28, 0xa1, 0x64, 0x7f, 0x80, 0xee, 0x41, 0xfa,
	0x94, 0xf4, 0xcc, 0x29, 0x22, 0xa9, 0x53, 0xd2, 0xdb, 0x1f, 0x68, 0x7f, 0x49, 0x43, 0x82, 0x77,
	0x8f, 0x3a, 0x28, 0x7e, 0x14, 0x4a, 0x38, 0xe7, 0x2a, 0xf7, 0xe7, 0x22, 0x31, 0x9d, 0xd8, 0x38,
	0x77, 0xe4, 0x51, 0xbc, 0x88, 0x2c, 0x61, 0x6b, 0x99, 0x1f, 0x65, 0x4a, 0x2d, 0xe3, 0xdc, 0x91,
	0x77, 0xa8, 0x13, 0xf1, 0x28, 0x33, 0x4f, 0x49, 0x4f, 0xb4, 0x94, 0xb9, 0x1d, 0x6a, 0xfa, 0x80,
	0xe3, 0x1d, 0xea, 0x64, 0xfa, 0x98, 0xad, 0x82, 0x42, 0xf9, 0x39, 0x22, 0x82, 0x24, 0x45, 0x10,
	0x6d, 0xf1, 0x23, 0x62, 0x6f, 0xc5, 0xc8, 0xd2, 0xe8, 0x32, 0xfe, 0x04, 0x72, 0xde, 0xe4, 0x3c,
	0x48, 0x4a, 0x04, 0xf9, 0xd6, 0x32, 0x57, 0xd7, 0xbd, 0x15, 0x03, 0x42, 0x57, 0x1e, 0xe8, 0xc7,
	0x90, 0x15, 0x57, 0x64, 0x1e, 0x45, 0x12, 0xf0, 0xdd, 0x85, 0xf7, 0x9c, 0xbd, 0x15, 0x23, 0x73,
	0x12, 0x5e, 0x15, 0xb7, 0x21, 0xe3, 0xd9, 0x43, 0xe1, 0x2e, 0xdb, 0xcb, 0xfa, 0xa2, 0xc6, 0xb6,
	0xb7, 0x62, 0xa4, 0x3d, 0x79, 0x30, 0xfc, 0x14, 0xf2, 0x72, 0x0d, 0xf4, 0xcc, 0x11, 0x21, 0xee,
	0x88, 0x10, 0xef, 0x2f, 0x75, 0xfe, 0xee, 0xad, 0x18, 0x39, 0x3a, 0x73, 0x3d, 0xd9, 0x86, 0x34,
	0x15, 0x35, 0x18, 0x5e, 0xb7, 0xdf, 0x5b, 0xa2, 0x5c, 0x8d, 0xd0, 0x05, 0x1d, 0x40, 0x41, 0x8e,
	0xcc, 0x13, 0x9b, 0x32, 0xe2, 0x4f, 0x8a, 0x79, 0xd1, 0xa6, 0x97, 0x0a, 0x92, 0x97, 0xae, 0x7b,
	0xd2, 0x13, 0x6d, 0x43, 0x29, 0xfc, 0x21, 0x88, 0x04, 0xcc, 0x0b, 0x98, 0xe9, 0x63, 0x4a, 0x02,
	0xbf, 0x2f, 0x8f, 0xbe, 0x35, 0xc1, 0xf1, 0xaf, 0x4b, 0x8b, 0x43, 0x61, 0x60, 0x84, 0x7a, 0x7e,
	0x06, 0x7e, 0x04, 0xc5, 0xd0, 0x99, 0x9f, 0x54, 0x3e, 0x71, 0x44, 0x93, 0xa7, 0xc2, 0x75, 0x55,
	0xb8, 0xde, 0x93, 0xfa, 0x9a, 0x54, 0xf3, 0x76, 0x4f, 0x8f, 0x7c, 0x7b, 0x07, 0x20, 0xcb, 0x26,
	0x9e, 0x00, 0x52, 0x7b, 0x01, 0x6a, 0x27, 0xe8, 0x8d, 0x6c, 0x26, 0xaa, 0xe1, 0x2c, 0xc0, 0x94,
	0x2d, 0x2a, 0xc2, 0xb7, 0x20, 0xed, 0xe3, 0xa1, 0x4d, 0x5c, 0xc1, 0x6a, 0xc5, 0x08, 0xbf, 0x90,
	0x0e, 0x09, 0x0e, 0x8c, 0xac, 0x98, 0x77, 0xe6, 0xd7, 0x1d, 0xb7, 0xd4, 0x7e, 0x01, 0xf9, 0x27,
	0xf8, 0x33, 0x98, 0xf8, 0x86, 0xae, 0xf0, 0xaf, 0x38, 0xac, 0xf2, 0x63, 0xfe, 0x80, 0xf4, 0xe8,
	0xad, 0x67, 0x48, 0x5f, 0x98, 0xe1, 0x6d, 0x50, 0x3c, 0x6b, 0x88, 0x4d, 0x6a, 0xbf, 0x90, 0x67,
	0x4d, 0xca, 0xc8, 0x72, 0x41, 0xc7, 0x7e, 0x21, 0x7b, 0x16, 0x57, 0x32, 0xf2, 0x1c, 0x47, 0xa9,
	0x09, 0xf3, 0x2e, 0x17, 0x5c, 0x39, 0x6e, 0x92, 0x57, 0x8f, 0x1b, 0x0c, 0x6b, 0x7c, 0x01, 0xb2,
	0xcd, 0x8f, 0x2c, 0xd6, 0x3f, 0xc1, 0xbe, 0x28, 0xd4, 0x42, 0xe5, 0x07, 0x73, 0x8e, 0xe0, 0x8b,
	0x6b, 0x8b, 0x58, 0x86, 0x7f, 0x26, 0x03, 0x18, 0xab, 0xa7, 0x17, 0x05, 0xda, 0x23, 0x58, 0xbd,
	0x64, 0x13, 0xfd, 0x18, 0xb7, 0x82, 0x00, 0xd2, 0xd5, 0x5a, 0x77, 0xff, 0x69, 0x43, 0x76, 0xff,
	0xd6, 0x61, 0xcb, 0x0c, 0xbf, 0xe3, 0xda, 0x08, 0xd4, 0xf3, 0xb9, 0xa8, 0x47, 0x5c, 0x8a, 0xd1,
	0x26, 0x24, 0x4f, 0x49, 0x4f, 0x3e, 0x0d, 0x17, 0xa2, 0x2d, 0x4c, 0xd1, 0x7d, 0x58, 0x75, 0xf1,
	0x2f, 0x99, 0x39, 0xb3, 0x59, 0x12, 0xaf, 0x3c, 0x17, 0xb7, 0xa3, 0x0d, 0xd3, 0x9e, 0x81, 0x5a,
	0xb3, 0xdc, 0x3e, 0x76, 0x3e, 0x37, 0x66, 0x3c, 0x03, 0xb5, 0x8e, 0x1d, 0xcc, 0xf0, 0xe7, 0x35,
	0x43, 0xe5, 0x0f, 0x69, 0xc8, 0x1f, 0x90, 0x5e, 0x58, 0x79, 0x0e, 0xf6, 0xd1, 0x1f, 0x63, 0xa0,
	0x4c, 0x2b, 0x0d, 0x3d, 0x98, 0xd3, 0xb7, 0x2e, 0x95, 0x63, 0x69, 0xfe, 0xe6, 0x6a, 0xd5, 0x5f,
	0xfd, 0xfb, 0x7f, 0xbf, 0x8b, 0x6f, 0x6b, 0x8f, 0xf4, 0xf1, 0xa6, 0x1e, 0x26, 0x4c, 0xf5, 0x97,
	0xe7, 0x8b, 0x79, 0xa5, 0xcb, 0x5c, 0xa9, 0xfe, 0x52, 0x0e, 0x5e, 0x89, 0x1f, 0xdd, 0xb7, 0xa8,
	0x98, 0x68, 0x2b, 0xf6, 0x00, 0xfd, 0x36, 0x06, 0x69, 0x59, 0x89, 0x68, 0xce, 0x95, 0xef, 0x42,
	0xad, 0x2e, 0xca, 0xea, 0x27, 0x22, 0xab, 0x2d, 0xf4, 0xf8, 0x96, 0x59, 0xe9, 0x2f, 0xe5, 0x76,
	0xbe, 0x42, 0x7f, 0x8a, 0x41, 0x36, 0xa2, 0x1d, 0xfa, 0x60, 0xe9, 0x32, 0x28, 0x3d, 0x58, 0xc6,
	0x54, 0xb2, 0x58, 0xfb, 0x48, 0x64, 0xb9, 0x89, 0xf4, 0x5b, 0x66, 0x89, 0xfe, 0x1c, 0x03, 0x65,
	0x4a, 0xd2, 0x79, 0x68, 0x5e, 0x66, 0xf2, 0xa2, 0x7d, 0x3b, 0x10, 0x19, 0xd5, 0xb5, 0x8f, 0x3f,
	0xed, 0xbe, 0x6d, 0xf5, 0xc5, 0x8c, 0x1c, 0xd6, 0xdf, 0xc4, 0x40, 0x99, 0xf2, 0x7c, 0x5e, 0x92,
	0x97, 0x8b, 0xa1, 0xf4, 0xd6, 0x95, 0x9b, 0x65, 0x63, 0xe4, 0xb1, 0x49, 0x84, 0xea, 0x83, 0x4f,
	0x8d, 0xea, 0xce, 0x87, 0xf0, 0x8d, 0x3e, 0x19, 0xdd, 0x98, 0xca, 0x0e, 0xbf, 0x53, 0xd3, 0x36,
	0x9f, 0xb5, 0x1d, 0xeb, 0xa5, 0xc5, 0xf4, 0x0f, 0xff, 0x1f, 0x00, 0x00, 0xff, 0xff, 0x8c, 0x97,
	0xbe, 0x46, 0x5d, 0x1a, 0x00, 0x00,
}
