// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/cloud/dataproc/v1/clusters.proto
// DO NOT EDIT!

/*
Package google_cloud_dataproc_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/cloud/dataproc/v1/clusters.proto
	google.golang.org/genproto/googleapis/cloud/dataproc/v1/jobs.proto
	google.golang.org/genproto/googleapis/cloud/dataproc/v1/operations.proto

It has these top-level messages:
	Cluster
	ClusterConfig
	GceClusterConfig
	InstanceGroupConfig
	ManagedGroupConfig
	DiskConfig
	NodeInitializationAction
	ClusterStatus
	SoftwareConfig
	CreateClusterRequest
	UpdateClusterRequest
	DeleteClusterRequest
	GetClusterRequest
	ListClustersRequest
	ListClustersResponse
	DiagnoseClusterRequest
	DiagnoseClusterResults
	LoggingConfig
	HadoopJob
	SparkJob
	PySparkJob
	QueryList
	HiveJob
	SparkSqlJob
	PigJob
	JobPlacement
	JobStatus
	JobReference
	Job
	SubmitJobRequest
	GetJobRequest
	ListJobsRequest
	ListJobsResponse
	CancelJobRequest
	DeleteJobRequest
	ClusterOperationStatus
	ClusterOperationMetadata
*/
package google_cloud_dataproc_v1 // import "google.golang.org/genproto/googleapis/cloud/dataproc/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf4 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf5 "google.golang.org/genproto/protobuf"
import google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The cluster state.
type ClusterStatus_State int32

const (
	// The cluster state is unknown.
	ClusterStatus_UNKNOWN ClusterStatus_State = 0
	// The cluster is being created and set up. It is not ready for use.
	ClusterStatus_CREATING ClusterStatus_State = 1
	// The cluster is currently running and healthy. It is ready for use.
	ClusterStatus_RUNNING ClusterStatus_State = 2
	// The cluster encountered an error. It is not ready for use.
	ClusterStatus_ERROR ClusterStatus_State = 3
	// The cluster is being deleted. It cannot be used.
	ClusterStatus_DELETING ClusterStatus_State = 4
	// The cluster is being updated. It continues to accept and process jobs.
	ClusterStatus_UPDATING ClusterStatus_State = 5
)

var ClusterStatus_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "DELETING",
	5: "UPDATING",
}
var ClusterStatus_State_value = map[string]int32{
	"UNKNOWN":  0,
	"CREATING": 1,
	"RUNNING":  2,
	"ERROR":    3,
	"DELETING": 4,
	"UPDATING": 5,
}

func (x ClusterStatus_State) String() string {
	return proto.EnumName(ClusterStatus_State_name, int32(x))
}
func (ClusterStatus_State) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 0} }

// Describes the identifying information, config, and status of
// a cluster of Google Compute Engine instances.
type Cluster struct {
	// [Required] The Google Cloud Platform project ID that the cluster belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The cluster name. Cluster names within a project must be
	// unique. Names of deleted clusters can be reused.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
	// [Required] The cluster config. Note that Cloud Dataproc may set
	// default values, and values may change when clusters are updated.
	Config *ClusterConfig `protobuf:"bytes,3,opt,name=config" json:"config,omitempty"`
	// [Output-only] Cluster status.
	Status *ClusterStatus `protobuf:"bytes,4,opt,name=status" json:"status,omitempty"`
	// [Output-only] The previous cluster status.
	StatusHistory []*ClusterStatus `protobuf:"bytes,7,rep,name=status_history,json=statusHistory" json:"status_history,omitempty"`
	// [Output-only] A cluster UUID (Unique Universal Identifier). Cloud Dataproc
	// generates this value when it creates the cluster.
	ClusterUuid string `protobuf:"bytes,6,opt,name=cluster_uuid,json=clusterUuid" json:"cluster_uuid,omitempty"`
}

func (m *Cluster) Reset()                    { *m = Cluster{} }
func (m *Cluster) String() string            { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()               {}
func (*Cluster) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetStatus() *ClusterStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Cluster) GetStatusHistory() []*ClusterStatus {
	if m != nil {
		return m.StatusHistory
	}
	return nil
}

// The cluster config.
type ClusterConfig struct {
	// [Optional] A Google Cloud Storage staging bucket used for sharing generated
	// SSH keys and config. If you do not specify a staging bucket, Cloud
	// Dataproc will determine an appropriate Cloud Storage location (US,
	// ASIA, or EU) for your cluster's staging bucket according to the Google
	// Compute Engine zone where your cluster is deployed, and then it will create
	// and manage this project-level, per-location bucket for you.
	ConfigBucket string `protobuf:"bytes,1,opt,name=config_bucket,json=configBucket" json:"config_bucket,omitempty"`
	// [Required] The shared Google Compute Engine config settings for
	// all instances in a cluster.
	GceClusterConfig *GceClusterConfig `protobuf:"bytes,8,opt,name=gce_cluster_config,json=gceClusterConfig" json:"gce_cluster_config,omitempty"`
	// [Optional] The Google Compute Engine config settings for
	// the master instance in a cluster.
	MasterConfig *InstanceGroupConfig `protobuf:"bytes,9,opt,name=master_config,json=masterConfig" json:"master_config,omitempty"`
	// [Optional] The Google Compute Engine config settings for
	// worker instances in a cluster.
	WorkerConfig *InstanceGroupConfig `protobuf:"bytes,10,opt,name=worker_config,json=workerConfig" json:"worker_config,omitempty"`
	// [Optional] The Google Compute Engine config settings for
	// additional worker instances in a cluster.
	SecondaryWorkerConfig *InstanceGroupConfig `protobuf:"bytes,12,opt,name=secondary_worker_config,json=secondaryWorkerConfig" json:"secondary_worker_config,omitempty"`
	// [Optional] The config settings for software inside the cluster.
	SoftwareConfig *SoftwareConfig `protobuf:"bytes,13,opt,name=software_config,json=softwareConfig" json:"software_config,omitempty"`
	// [Optional] Commands to execute on each node after config is
	// completed. By default, executables are run on master and all worker nodes.
	// You can test a node's <code>role</code> metadata to run an executable on
	// a master or worker node, as shown below using `curl` (you can also use `wget`):
	//
	//     ROLE=$(curl -H Metadata-Flavor:Google http://metadata/computeMetadata/v1/instance/attributes/dataproc-role)
	//     if [[ "${ROLE}" == 'Master' ]]; then
	//       ... master specific actions ...
	//     else
	//       ... worker specific actions ...
	//     fi
	InitializationActions []*NodeInitializationAction `protobuf:"bytes,11,rep,name=initialization_actions,json=initializationActions" json:"initialization_actions,omitempty"`
}

func (m *ClusterConfig) Reset()                    { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string            { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()               {}
func (*ClusterConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *ClusterConfig) GetGceClusterConfig() *GceClusterConfig {
	if m != nil {
		return m.GceClusterConfig
	}
	return nil
}

func (m *ClusterConfig) GetMasterConfig() *InstanceGroupConfig {
	if m != nil {
		return m.MasterConfig
	}
	return nil
}

func (m *ClusterConfig) GetWorkerConfig() *InstanceGroupConfig {
	if m != nil {
		return m.WorkerConfig
	}
	return nil
}

func (m *ClusterConfig) GetSecondaryWorkerConfig() *InstanceGroupConfig {
	if m != nil {
		return m.SecondaryWorkerConfig
	}
	return nil
}

func (m *ClusterConfig) GetSoftwareConfig() *SoftwareConfig {
	if m != nil {
		return m.SoftwareConfig
	}
	return nil
}

func (m *ClusterConfig) GetInitializationActions() []*NodeInitializationAction {
	if m != nil {
		return m.InitializationActions
	}
	return nil
}

// Common config settings for resources of Google Compute Engine cluster
// instances, applicable to all instances in the cluster.
type GceClusterConfig struct {
	// [Required] The zone where the Google Compute Engine cluster will be located.
	// Example: `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]`.
	ZoneUri string `protobuf:"bytes,1,opt,name=zone_uri,json=zoneUri" json:"zone_uri,omitempty"`
	// [Optional] The Google Compute Engine network to be used for machine
	// communications. Cannot be specified with subnetwork_uri. If neither
	// `network_uri` nor `subnetwork_uri` is specified, the "default" network of
	// the project is used, if it exists. Cannot be a "Custom Subnet Network" (see
	// [Using Subnetworks](/compute/docs/subnetworks) for more information).
	// Example: `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default`.
	NetworkUri string `protobuf:"bytes,2,opt,name=network_uri,json=networkUri" json:"network_uri,omitempty"`
	// [Optional] The Google Compute Engine subnetwork to be used for machine
	// communications. Cannot be specified with network_uri.
	// Example: `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/sub0`.
	SubnetworkUri string `protobuf:"bytes,6,opt,name=subnetwork_uri,json=subnetworkUri" json:"subnetwork_uri,omitempty"`
	// [Optional] If true, all instances in the cluster will only have internal IP
	// addresses. By default, clusters are not restricted to internal IP addresses,
	// and will have ephemeral external IP addresses assigned to each instance.
	// This `internal_ip_only` restriction can only be enabled for subnetwork
	// enabled networks, and all off-cluster dependencies must be configured to be
	// accessible without external IP addresses.
	InternalIpOnly bool `protobuf:"varint,7,opt,name=internal_ip_only,json=internalIpOnly" json:"internal_ip_only,omitempty"`
	// [Optional] The URIs of service account scopes to be included in Google
	// Compute Engine instances. The following base set of scopes is always
	// included:
	//
	// * https://www.googleapis.com/auth/cloud.useraccounts.readonly
	// * https://www.googleapis.com/auth/devstorage.read_write
	// * https://www.googleapis.com/auth/logging.write
	//
	// If no scopes are specified, the following defaults are also provided:
	//
	// * https://www.googleapis.com/auth/bigquery
	// * https://www.googleapis.com/auth/bigtable.admin.table
	// * https://www.googleapis.com/auth/bigtable.data
	// * https://www.googleapis.com/auth/devstorage.full_control
	ServiceAccountScopes []string `protobuf:"bytes,3,rep,name=service_account_scopes,json=serviceAccountScopes" json:"service_account_scopes,omitempty"`
	// The Google Compute Engine tags to add to all instances (see
	// [Labeling instances](/compute/docs/label-or-tag-resources#labeling_instances)).
	Tags []string `protobuf:"bytes,4,rep,name=tags" json:"tags,omitempty"`
	// The Google Compute Engine metadata entries to add to all instances (see
	// [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *GceClusterConfig) Reset()                    { *m = GceClusterConfig{} }
func (m *GceClusterConfig) String() string            { return proto.CompactTextString(m) }
func (*GceClusterConfig) ProtoMessage()               {}
func (*GceClusterConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *GceClusterConfig) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// [Optional] The config settings for Google Compute Engine resources in
// an instance group, such as a master or worker group.
type InstanceGroupConfig struct {
	// [Required] The number of VM instances in the instance group.
	// For master instance groups, must be set to 1.
	NumInstances int32 `protobuf:"varint,1,opt,name=num_instances,json=numInstances" json:"num_instances,omitempty"`
	// [Optional] The list of instance names. Cloud Dataproc derives the names from
	// `cluster_name`, `num_instances`, and the instance group if not set by user
	// (recommended practice is to let Cloud Dataproc derive the name).
	InstanceNames []string `protobuf:"bytes,2,rep,name=instance_names,json=instanceNames" json:"instance_names,omitempty"`
	// [Output-only] The Google Compute Engine image resource used for cluster
	// instances. Inferred from `SoftwareConfig.image_version`.
	ImageUri string `protobuf:"bytes,3,opt,name=image_uri,json=imageUri" json:"image_uri,omitempty"`
	// [Required] The Google Compute Engine machine type used for cluster instances.
	// Example: `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`.
	MachineTypeUri string `protobuf:"bytes,4,opt,name=machine_type_uri,json=machineTypeUri" json:"machine_type_uri,omitempty"`
	// [Optional] Disk option config settings.
	DiskConfig *DiskConfig `protobuf:"bytes,5,opt,name=disk_config,json=diskConfig" json:"disk_config,omitempty"`
	// [Optional] Specifies that this instance group contains preemptible instances.
	IsPreemptible bool `protobuf:"varint,6,opt,name=is_preemptible,json=isPreemptible" json:"is_preemptible,omitempty"`
	// [Output-only] The config for Google Compute Engine Instance Group
	// Manager that manages this group.
	// This is only used for preemptible instance groups.
	ManagedGroupConfig *ManagedGroupConfig `protobuf:"bytes,7,opt,name=managed_group_config,json=managedGroupConfig" json:"managed_group_config,omitempty"`
}

func (m *InstanceGroupConfig) Reset()                    { *m = InstanceGroupConfig{} }
func (m *InstanceGroupConfig) String() string            { return proto.CompactTextString(m) }
func (*InstanceGroupConfig) ProtoMessage()               {}
func (*InstanceGroupConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *InstanceGroupConfig) GetDiskConfig() *DiskConfig {
	if m != nil {
		return m.DiskConfig
	}
	return nil
}

func (m *InstanceGroupConfig) GetManagedGroupConfig() *ManagedGroupConfig {
	if m != nil {
		return m.ManagedGroupConfig
	}
	return nil
}

// Specifies the resources used to actively manage an instance group.
type ManagedGroupConfig struct {
	// [Output-only] The name of the Instance Template used for the Managed
	// Instance Group.
	InstanceTemplateName string `protobuf:"bytes,1,opt,name=instance_template_name,json=instanceTemplateName" json:"instance_template_name,omitempty"`
	// [Output-only] The name of the Instance Group Manager for this group.
	InstanceGroupManagerName string `protobuf:"bytes,2,opt,name=instance_group_manager_name,json=instanceGroupManagerName" json:"instance_group_manager_name,omitempty"`
}

func (m *ManagedGroupConfig) Reset()                    { *m = ManagedGroupConfig{} }
func (m *ManagedGroupConfig) String() string            { return proto.CompactTextString(m) }
func (*ManagedGroupConfig) ProtoMessage()               {}
func (*ManagedGroupConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// Specifies the config of disk options for a group of VM instances.
type DiskConfig struct {
	// [Optional] Size in GB of the boot disk (default is 500GB).
	BootDiskSizeGb int32 `protobuf:"varint,1,opt,name=boot_disk_size_gb,json=bootDiskSizeGb" json:"boot_disk_size_gb,omitempty"`
	// [Optional] Number of attached SSDs, from 0 to 4 (default is 0).
	// If SSDs are not attached, the boot disk is used to store runtime logs and
	// [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data.
	// If one or more SSDs are attached, this runtime bulk
	// data is spread across them, and the boot disk contains only basic
	// config and installed binaries.
	NumLocalSsds int32 `protobuf:"varint,2,opt,name=num_local_ssds,json=numLocalSsds" json:"num_local_ssds,omitempty"`
}

func (m *DiskConfig) Reset()                    { *m = DiskConfig{} }
func (m *DiskConfig) String() string            { return proto.CompactTextString(m) }
func (*DiskConfig) ProtoMessage()               {}
func (*DiskConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// Specifies an executable to run on a fully configured node and a
// timeout period for executable completion.
type NodeInitializationAction struct {
	// [Required] Google Cloud Storage URI of executable file.
	ExecutableFile string `protobuf:"bytes,1,opt,name=executable_file,json=executableFile" json:"executable_file,omitempty"`
	// [Optional] Amount of time executable has to complete. Default is
	// 10 minutes. Cluster creation fails with an explanatory error message (the
	// name of the executable that caused the error and the exceeded timeout
	// period) if the executable is not completed at end of the timeout period.
	ExecutionTimeout *google_protobuf4.Duration `protobuf:"bytes,2,opt,name=execution_timeout,json=executionTimeout" json:"execution_timeout,omitempty"`
}

func (m *NodeInitializationAction) Reset()                    { *m = NodeInitializationAction{} }
func (m *NodeInitializationAction) String() string            { return proto.CompactTextString(m) }
func (*NodeInitializationAction) ProtoMessage()               {}
func (*NodeInitializationAction) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *NodeInitializationAction) GetExecutionTimeout() *google_protobuf4.Duration {
	if m != nil {
		return m.ExecutionTimeout
	}
	return nil
}

// The status of a cluster and its instances.
type ClusterStatus struct {
	// [Output-only] The cluster's state.
	State ClusterStatus_State `protobuf:"varint,1,opt,name=state,enum=google.cloud.dataproc.v1.ClusterStatus_State" json:"state,omitempty"`
	// [Output-only] Optional details of cluster's state.
	Detail string `protobuf:"bytes,2,opt,name=detail" json:"detail,omitempty"`
	// [Output-only] Time when this state was entered.
	StateStartTime *google_protobuf3.Timestamp `protobuf:"bytes,3,opt,name=state_start_time,json=stateStartTime" json:"state_start_time,omitempty"`
}

func (m *ClusterStatus) Reset()                    { *m = ClusterStatus{} }
func (m *ClusterStatus) String() string            { return proto.CompactTextString(m) }
func (*ClusterStatus) ProtoMessage()               {}
func (*ClusterStatus) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ClusterStatus) GetStateStartTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.StateStartTime
	}
	return nil
}

// Specifies the selection and config of software inside the cluster.
type SoftwareConfig struct {
	// [Optional] The version of software inside the cluster. It must match the
	// regular expression `[0-9]+\.[0-9]+`. If unspecified, it defaults to the
	// latest version (see [Cloud Dataproc Versioning](/dataproc/versioning)).
	ImageVersion string `protobuf:"bytes,1,opt,name=image_version,json=imageVersion" json:"image_version,omitempty"`
	// [Optional] The properties to set on daemon config files.
	//
	// Property keys are specified in `prefix:property` format, such as
	// `core:fs.defaultFS`. The following are supported prefixes
	// and their mappings:
	//
	// * core:   `core-site.xml`
	// * hdfs:   `hdfs-site.xml`
	// * mapred: `mapred-site.xml`
	// * yarn:   `yarn-site.xml`
	// * hive:   `hive-site.xml`
	// * pig:    `pig.properties`
	// * spark:  `spark-defaults.conf`
	Properties map[string]string `protobuf:"bytes,2,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *SoftwareConfig) Reset()                    { *m = SoftwareConfig{} }
func (m *SoftwareConfig) String() string            { return proto.CompactTextString(m) }
func (*SoftwareConfig) ProtoMessage()               {}
func (*SoftwareConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *SoftwareConfig) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

// A request to create a cluster.
type CreateClusterRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The cluster to create.
	Cluster *Cluster `protobuf:"bytes,2,opt,name=cluster" json:"cluster,omitempty"`
}

func (m *CreateClusterRequest) Reset()                    { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()               {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *CreateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

// A request to update a cluster.
type UpdateClusterRequest struct {
	// [Required] The ID of the Google Cloud Platform project the
	// cluster belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,5,opt,name=region" json:"region,omitempty"`
	// [Required] The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
	// [Required] The changes to the cluster.
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster" json:"cluster,omitempty"`
	// [Required] Specifies the path, relative to <code>Cluster</code>, of
	// the field to update. For example, to change the number of workers
	// in a cluster to 5, the <code>update_mask</code> parameter would be
	// specified as <code>config.worker_config.num_instances</code>,
	// and the `PATCH` request body would specify the new value, as follows:
	//
	//     {
	//       "config":{
	//         "workerConfig":{
	//           "numInstances":"5"
	//         }
	//       }
	//     }
	// Similarly, to change the number of preemptible workers in a cluster to 5, the
	// <code>update_mask</code> parameter would be <code>config.secondary_worker_config.num_instances</code>,
	// and the `PATCH` request body would be set as follows:
	//
	//     {
	//       "config":{
	//         "secondaryWorkerConfig":{
	//           "numInstances":"5"
	//         }
	//       }
	//     }
	// <strong>Note:</strong> Currently, <code>config.worker_config.num_instances</code>
	// and <code>config.secondary_worker_config.num_instances</code> are the only
	// fields that can be updated.
	UpdateMask *google_protobuf5.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateClusterRequest) Reset()                    { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()               {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *UpdateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *UpdateClusterRequest) GetUpdateMask() *google_protobuf5.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// A request to delete a cluster.
type DeleteClusterRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
}

func (m *DeleteClusterRequest) Reset()                    { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()               {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

// Request to get the resource representation for a cluster in a project.
type GetClusterRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
}

func (m *GetClusterRequest) Reset()                    { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()               {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

// A request to list the clusters in a project.
type ListClustersRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,4,opt,name=region" json:"region,omitempty"`
	// [Optional] The standard List page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// [Optional] The standard List page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListClustersRequest) Reset()                    { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()               {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

// The list of all clusters in a project.
type ListClustersResponse struct {
	// [Output-only] The clusters in the project.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters" json:"clusters,omitempty"`
	// [Output-only] This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// `page_token` in a subsequent <code>ListClustersRequest</code>.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListClustersResponse) Reset()                    { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()               {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

// A request to collect cluster diagnostic information.
type DiagnoseClusterRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
}

func (m *DiagnoseClusterRequest) Reset()                    { *m = DiagnoseClusterRequest{} }
func (m *DiagnoseClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*DiagnoseClusterRequest) ProtoMessage()               {}
func (*DiagnoseClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

// The location of diagnostic output.
type DiagnoseClusterResults struct {
	// [Output-only] The Google Cloud Storage URI of the diagnostic output.
	// The output report is a plain text file with a summary of collected
	// diagnostics.
	OutputUri string `protobuf:"bytes,1,opt,name=output_uri,json=outputUri" json:"output_uri,omitempty"`
}

func (m *DiagnoseClusterResults) Reset()                    { *m = DiagnoseClusterResults{} }
func (m *DiagnoseClusterResults) String() string            { return proto.CompactTextString(m) }
func (*DiagnoseClusterResults) ProtoMessage()               {}
func (*DiagnoseClusterResults) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func init() {
	proto.RegisterType((*Cluster)(nil), "google.cloud.dataproc.v1.Cluster")
	proto.RegisterType((*ClusterConfig)(nil), "google.cloud.dataproc.v1.ClusterConfig")
	proto.RegisterType((*GceClusterConfig)(nil), "google.cloud.dataproc.v1.GceClusterConfig")
	proto.RegisterType((*InstanceGroupConfig)(nil), "google.cloud.dataproc.v1.InstanceGroupConfig")
	proto.RegisterType((*ManagedGroupConfig)(nil), "google.cloud.dataproc.v1.ManagedGroupConfig")
	proto.RegisterType((*DiskConfig)(nil), "google.cloud.dataproc.v1.DiskConfig")
	proto.RegisterType((*NodeInitializationAction)(nil), "google.cloud.dataproc.v1.NodeInitializationAction")
	proto.RegisterType((*ClusterStatus)(nil), "google.cloud.dataproc.v1.ClusterStatus")
	proto.RegisterType((*SoftwareConfig)(nil), "google.cloud.dataproc.v1.SoftwareConfig")
	proto.RegisterType((*CreateClusterRequest)(nil), "google.cloud.dataproc.v1.CreateClusterRequest")
	proto.RegisterType((*UpdateClusterRequest)(nil), "google.cloud.dataproc.v1.UpdateClusterRequest")
	proto.RegisterType((*DeleteClusterRequest)(nil), "google.cloud.dataproc.v1.DeleteClusterRequest")
	proto.RegisterType((*GetClusterRequest)(nil), "google.cloud.dataproc.v1.GetClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "google.cloud.dataproc.v1.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "google.cloud.dataproc.v1.ListClustersResponse")
	proto.RegisterType((*DiagnoseClusterRequest)(nil), "google.cloud.dataproc.v1.DiagnoseClusterRequest")
	proto.RegisterType((*DiagnoseClusterResults)(nil), "google.cloud.dataproc.v1.DiagnoseClusterResults")
	proto.RegisterEnum("google.cloud.dataproc.v1.ClusterStatus_State", ClusterStatus_State_name, ClusterStatus_State_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ClusterController service

type ClusterControllerClient interface {
	// Creates a cluster in a project.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Updates a cluster in a project.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes a cluster in a project.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Gets the resource representation for a cluster in a project.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Lists all regions/{region}/clusters in a project.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets cluster diagnostic information.
	// After the operation completes, the Operation.response field
	// contains `DiagnoseClusterOutputLocation`.
	DiagnoseCluster(ctx context.Context, in *DiagnoseClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type clusterControllerClient struct {
	cc *grpc.ClientConn
}

func NewClusterControllerClient(cc *grpc.ClientConn) ClusterControllerClient {
	return &clusterControllerClient{cc}
}

func (c *clusterControllerClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/CreateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/UpdateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/DeleteCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/GetCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/ListClusters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) DiagnoseCluster(ctx context.Context, in *DiagnoseClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/DiagnoseCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ClusterController service

type ClusterControllerServer interface {
	// Creates a cluster in a project.
	CreateCluster(context.Context, *CreateClusterRequest) (*google_longrunning.Operation, error)
	// Updates a cluster in a project.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*google_longrunning.Operation, error)
	// Deletes a cluster in a project.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*google_longrunning.Operation, error)
	// Gets the resource representation for a cluster in a project.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Lists all regions/{region}/clusters in a project.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets cluster diagnostic information.
	// After the operation completes, the Operation.response field
	// contains `DiagnoseClusterOutputLocation`.
	DiagnoseCluster(context.Context, *DiagnoseClusterRequest) (*google_longrunning.Operation, error)
}

func RegisterClusterControllerServer(s *grpc.Server, srv ClusterControllerServer) {
	s.RegisterService(&_ClusterController_serviceDesc, srv)
}

func _ClusterController_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_DiagnoseCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiagnoseClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).DiagnoseCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/DiagnoseCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).DiagnoseCluster(ctx, req.(*DiagnoseClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.ClusterController",
	HandlerType: (*ClusterControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCluster",
			Handler:    _ClusterController_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _ClusterController_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _ClusterController_DeleteCluster_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _ClusterController_GetCluster_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _ClusterController_ListClusters_Handler,
		},
		{
			MethodName: "DiagnoseCluster",
			Handler:    _ClusterController_DiagnoseCluster_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/cloud/dataproc/v1/clusters.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/cloud/dataproc/v1/clusters.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1684 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xbc, 0x58, 0x4f, 0x77, 0x1c, 0x47,
	0x11, 0x67, 0x56, 0x5a, 0x69, 0x55, 0xd2, 0xae, 0xd6, 0x1d, 0x45, 0x6c, 0x64, 0xf2, 0x70, 0x86,
	0x40, 0x84, 0x81, 0x1d, 0xa2, 0x84, 0x47, 0xb0, 0x5e, 0xe0, 0x59, 0x5a, 0x59, 0x11, 0xb1, 0xd7,
	0x62, 0x24, 0x39, 0xb9, 0xc0, 0xbc, 0xde, 0x99, 0xd6, 0xb8, 0xd9, 0x99, 0xe9, 0x61, 0xba, 0x47,
	0x89, 0xec, 0xe7, 0x0b, 0x27, 0x08, 0x47, 0xbe, 0x02, 0x07, 0x5e, 0x8e, 0x70, 0xe3, 0xc4, 0x27,
	0xe0, 0xc2, 0x91, 0x2b, 0x27, 0x3e, 0x00, 0x27, 0x0e, 0xbc, 0xfe, 0x33, 0xbb, 0x3b, 0xd2, 0xfe,
	0x91, 0x15, 0x3d, 0x9f, 0xd4, 0x53, 0x5d, 0xf5, 0xab, 0x5f, 0x57, 0x57, 0x55, 0xd7, 0x0a, 0x1e,
	0x84, 0x8c, 0x85, 0x11, 0x69, 0x87, 0x2c, 0xc2, 0x49, 0xd8, 0x66, 0x59, 0xe8, 0x84, 0x24, 0x49,
	0x33, 0x26, 0x98, 0xa3, 0xb7, 0x70, 0x4a, 0xb9, 0xe3, 0x47, 0x2c, 0x0f, 0x9c, 0x00, 0x0b, 0x9c,
	0x66, 0xcc, 0x77, 0xce, 0xde, 0x75, 0xfc, 0x28, 0xe7, 0x82, 0x64, 0xbc, 0xad, 0x74, 0x51, 0xcb,
	0xe0, 0x28, 0xc5, 0x76, 0xa1, 0xd8, 0x3e, 0x7b, 0x77, 0xe3, 0xe0, 0x6a, 0x1e, 0x70, 0x4a, 0x1d,
	0x4e, 0xb2, 0x33, 0xea, 0x13, 0x9f, 0x25, 0xa7, 0x34, 0x74, 0x70, 0x92, 0x30, 0x81, 0x05, 0x65,
	0x89, 0x71, 0xb2, 0xf1, 0xd1, 0x75, 0xc9, 0xb2, 0x94, 0x64, 0x25, 0xa4, 0x9d, 0xab, 0x21, 0x45,
	0x2c, 0x09, 0xb3, 0x3c, 0x49, 0x68, 0x12, 0x5e, 0xc6, 0xf8, 0x49, 0x48, 0xc5, 0xd3, 0xbc, 0xd7,
	0xf6, 0x59, 0xec, 0x68, 0x1c, 0x47, 0x6d, 0xf4, 0xf2, 0x53, 0x27, 0x15, 0xe7, 0x29, 0xe1, 0x4e,
	0x90, 0x6b, 0x93, 0xc1, 0xc2, 0x98, 0xbe, 0x3f, 0xc5, 0xfd, 0x00, 0xe3, 0x94, 0x92, 0x28, 0xf0,
	0x62, 0xcc, 0xfb, 0xc6, 0x6a, 0x7b, 0xb6, 0x43, 0x41, 0x63, 0xc2, 0x05, 0x8e, 0xd3, 0xe1, 0x4a,
	0x1b, 0xdb, 0x7f, 0xaf, 0xc0, 0xe2, 0xae, 0xbe, 0x33, 0xf4, 0x26, 0x40, 0x9a, 0xb1, 0x5f, 0x13,
	0x5f, 0x78, 0x34, 0x68, 0x59, 0x77, 0xac, 0xcd, 0x25, 0x77, 0xc9, 0x48, 0x0e, 0x02, 0xf4, 0x16,
	0xac, 0x98, 0xdb, 0xf5, 0x12, 0x1c, 0x93, 0x56, 0x45, 0x29, 0x2c, 0x1b, 0x59, 0x17, 0xc7, 0x04,
	0xfd, 0x0c, 0x16, 0xf4, 0x2d, 0xb5, 0xe6, 0xee, 0x58, 0x9b, 0xcb, 0x5b, 0xef, 0xb4, 0x27, 0xdd,
	0x7f, 0xdb, 0x38, 0xdd, 0x55, 0xea, 0xae, 0x31, 0x93, 0x00, 0x5c, 0x60, 0x91, 0xf3, 0xd6, 0xfc,
	0x15, 0x01, 0x8e, 0x94, 0xba, 0x6b, 0xcc, 0x50, 0x17, 0x1a, 0x7a, 0xe5, 0x3d, 0xa5, 0x5c, 0xb0,
	0xec, 0xbc, 0xb5, 0x78, 0x67, 0xee, 0x65, 0x80, 0xea, 0xda, 0xfc, 0x23, 0x6d, 0x3d, 0x7a, 0xe8,
	0x3c, 0xa7, 0x41, 0x6b, 0xa1, 0x74, 0xe8, 0x93, 0x9c, 0x06, 0xf6, 0xbf, 0xe6, 0xa1, 0x5e, 0x3a,
	0x0d, 0xfa, 0x16, 0xd4, 0xf5, 0x79, 0xbc, 0x5e, 0xee, 0xf7, 0x89, 0x30, 0xb1, 0x5c, 0xd1, 0xc2,
	0x1d, 0x25, 0x43, 0x9f, 0x02, 0x0a, 0x7d, 0xe2, 0x15, 0xe8, 0x26, 0x6e, 0x35, 0x75, 0xec, 0xbb,
	0x93, 0xd9, 0xee, 0xfb, 0xa4, 0x1c, 0xba, 0x66, 0x78, 0x41, 0x82, 0x5c, 0xa8, 0xc7, 0x78, 0x14,
	0x74, 0x49, 0x81, 0xfe, 0x60, 0x32, 0xe8, 0x41, 0xc2, 0x05, 0x4e, 0x7c, 0xb2, 0x9f, 0xb1, 0x3c,
	0x35, 0xb8, 0x2b, 0x1a, 0x63, 0x88, 0xf9, 0x19, 0xcb, 0xfa, 0x43, 0x4c, 0xb8, 0x16, 0xa6, 0xc6,
	0x30, 0x98, 0x04, 0xbe, 0xce, 0x65, 0x55, 0x07, 0x38, 0x3b, 0xf7, 0xca, 0xe8, 0x2b, 0xd7, 0x41,
	0x7f, 0x7d, 0x80, 0xf6, 0xc9, 0xa8, 0x9b, 0x5f, 0xc0, 0x2a, 0x67, 0xa7, 0xe2, 0x33, 0x9c, 0x91,
	0x02, 0xbe, 0xae, 0xe0, 0x37, 0x27, 0xc3, 0x1f, 0x19, 0x03, 0x83, 0xdc, 0xe0, 0xa5, 0x6f, 0x44,
	0x61, 0x9d, 0x26, 0x54, 0x50, 0x1c, 0xd1, 0x67, 0xaa, 0x80, 0x3d, 0xec, 0xab, 0x1e, 0xd0, 0x5a,
	0x56, 0xd9, 0xb6, 0x35, 0x19, 0xb9, 0xcb, 0x02, 0x72, 0x50, 0xb2, 0xbd, 0xaf, 0x4c, 0xdd, 0xd7,
	0xe9, 0x18, 0x29, 0xb7, 0xff, 0x57, 0x81, 0xe6, 0xc5, 0x3b, 0x47, 0x6f, 0x40, 0xed, 0x19, 0x4b,
	0x88, 0x97, 0x67, 0xd4, 0xe4, 0xd6, 0xa2, 0xfc, 0x3e, 0xc9, 0x28, 0xfa, 0x26, 0x2c, 0x27, 0x44,
	0xc8, 0x68, 0xaa, 0x5d, 0x5d, 0xa4, 0x60, 0x44, 0x52, 0xe1, 0xdb, 0xd0, 0xe0, 0x79, 0x6f, 0x54,
	0x47, 0xe7, 0x74, 0x7d, 0x28, 0x95, 0x6a, 0x9b, 0xd0, 0xa4, 0x89, 0x20, 0x59, 0x82, 0x23, 0x8f,
	0xa6, 0x1e, 0x4b, 0x22, 0x59, 0x4a, 0xd6, 0x66, 0xcd, 0x6d, 0x14, 0xf2, 0x83, 0xf4, 0x71, 0x12,
	0x9d, 0xa3, 0xf7, 0x61, 0xdd, 0x74, 0x68, 0x0f, 0xfb, 0x3e, 0xcb, 0x13, 0xe1, 0x71, 0x9f, 0xa5,
	0x84, 0xb7, 0xe6, 0xee, 0xcc, 0x6d, 0x2e, 0xb9, 0x6b, 0x66, 0xf7, 0xbe, 0xde, 0x3c, 0x52, 0x7b,
	0x08, 0xc1, 0xbc, 0xc0, 0xa1, 0xac, 0x73, 0xa9, 0xa3, 0xd6, 0xe8, 0x18, 0x6a, 0x31, 0x11, 0x58,
	0x86, 0xab, 0x55, 0x55, 0x81, 0xfc, 0xe0, 0xea, 0x85, 0xd0, 0x7e, 0x64, 0x4c, 0xf7, 0x12, 0x91,
	0x9d, 0xbb, 0x03, 0xa4, 0x8d, 0x6d, 0xa8, 0x97, 0xb6, 0x50, 0x13, 0xe6, 0xfa, 0xe4, 0xdc, 0x04,
	0x4e, 0x2e, 0xd1, 0x1a, 0x54, 0xcf, 0x70, 0x94, 0x17, 0x3d, 0x4d, 0x7f, 0xdc, 0xab, 0x7c, 0x60,
	0xd9, 0xff, 0xad, 0xc0, 0x6b, 0x63, 0x72, 0x4d, 0x96, 0x78, 0x92, 0xc7, 0x1e, 0x35, 0x5b, 0x5c,
	0xa1, 0x55, 0xdd, 0x95, 0x24, 0x8f, 0x0b, 0x75, 0x2e, 0x43, 0x5d, 0x28, 0xa8, 0x96, 0xc9, 0x5b,
	0x15, 0x75, 0xda, 0x7a, 0x21, 0x95, 0x4d, 0x93, 0xa3, 0xdb, 0xb0, 0x44, 0x63, 0x1c, 0xea, 0xeb,
	0x9c, 0x53, 0x0c, 0x6a, 0x4a, 0x60, 0xee, 0x21, 0xc6, 0xfe, 0x53, 0x9a, 0x10, 0x4f, 0xf6, 0x72,
	0xa5, 0x33, 0xaf, 0x74, 0x1a, 0x46, 0x7e, 0x7c, 0x9e, 0x2a, 0xcd, 0x3d, 0x58, 0x0e, 0x28, 0xef,
	0x17, 0x39, 0x5e, 0x55, 0x39, 0xfe, 0xf6, 0xe4, 0x00, 0x76, 0x28, 0xef, 0x9b, 0xfc, 0x86, 0x60,
	0xb0, 0x56, 0xa4, 0xb9, 0x97, 0x66, 0x84, 0xc4, 0xa9, 0xa0, 0xbd, 0x88, 0xa8, 0xfc, 0xa8, 0xb9,
	0x75, 0xca, 0x0f, 0x87, 0x42, 0xf4, 0x2b, 0x58, 0x8b, 0x71, 0x82, 0x43, 0x12, 0x78, 0xa1, 0x8c,
	0x4b, 0xe1, 0x76, 0x51, 0xb9, 0xfd, 0xfe, 0x64, 0xb7, 0x8f, 0xb4, 0xd5, 0x68, 0xe1, 0xa2, 0xf8,
	0x92, 0xcc, 0xfe, 0xbd, 0x05, 0xe8, 0xb2, 0xaa, 0x4c, 0xb6, 0x41, 0x48, 0x05, 0x89, 0xd3, 0x08,
	0x0b, 0x1d, 0x5b, 0x73, 0x9d, 0x6b, 0xc5, 0xee, 0xb1, 0xd9, 0x54, 0xef, 0xd2, 0x87, 0x70, 0x7b,
	0x60, 0xa5, 0xd9, 0x6a, 0x8f, 0xa5, 0x97, 0xac, 0x45, 0x47, 0xef, 0x59, 0xfb, 0x56, 0xcf, 0x9a,
	0xfd, 0x4b, 0x80, 0x61, 0xb0, 0xd0, 0x77, 0xe1, 0x56, 0x8f, 0x31, 0xe1, 0xa9, 0x60, 0x73, 0xfa,
	0x8c, 0x78, 0x61, 0xcf, 0x5c, 0x7f, 0x43, 0x6e, 0x48, 0xd5, 0x23, 0xfa, 0x8c, 0xec, 0xf7, 0xd0,
	0xdb, 0xd0, 0x90, 0x59, 0x12, 0x31, 0x1f, 0x47, 0x1e, 0xe7, 0x01, 0x57, 0xae, 0x74, 0x9a, 0x3c,
	0x94, 0xc2, 0x23, 0x1e, 0x70, 0xfb, 0x0f, 0x16, 0xb4, 0x26, 0xb5, 0x05, 0xf4, 0x0e, 0xac, 0x92,
	0xcf, 0x89, 0x9f, 0x0b, 0xdc, 0x8b, 0x88, 0x77, 0x4a, 0xa3, 0xe2, 0xa4, 0x8d, 0xa1, 0xf8, 0x01,
	0x8d, 0x08, 0x7a, 0x00, 0xb7, 0xb4, 0x44, 0xb6, 0x23, 0xf9, 0xcc, 0xb3, 0x5c, 0x28, 0x77, 0xcb,
	0x5b, 0x6f, 0x14, 0xb7, 0x51, 0xcc, 0x05, 0xed, 0x8e, 0x19, 0x3c, 0xdc, 0xe6, 0xc0, 0xe6, 0x58,
	0x9b, 0xd8, 0x5f, 0x54, 0x06, 0xcf, 0x99, 0x7e, 0x12, 0xd1, 0x2e, 0x54, 0xe5, 0xa3, 0xa8, 0x1d,
	0x37, 0xa6, 0x75, 0xe5, 0x92, 0x5d, 0x5b, 0xfe, 0x21, 0xae, 0xb6, 0x45, 0xeb, 0xb0, 0x10, 0x10,
	0x81, 0x69, 0x64, 0xa2, 0x6d, 0xbe, 0x50, 0x07, 0x9a, 0x4a, 0xc1, 0xe3, 0x02, 0x67, 0x42, 0x11,
	0x37, 0xc3, 0xc3, 0xc6, 0x25, 0xd6, 0xc7, 0xc5, 0xf0, 0xe2, 0xaa, 0x47, 0x9e, 0x1c, 0x49, 0x13,
	0x29, 0xb4, 0x9f, 0x40, 0x55, 0x79, 0x43, 0xcb, 0xb0, 0x78, 0xd2, 0xfd, 0xb8, 0xfb, 0xf8, 0x93,
	0x6e, 0xf3, 0x6b, 0x68, 0x05, 0x6a, 0xbb, 0xee, 0xde, 0xfd, 0xe3, 0x83, 0xee, 0x7e, 0xd3, 0x92,
	0x5b, 0xee, 0x49, 0xb7, 0x2b, 0x3f, 0x2a, 0x68, 0x09, 0xaa, 0x7b, 0xae, 0xfb, 0xd8, 0x6d, 0xce,
	0x49, 0xad, 0xce, 0xde, 0xc3, 0x3d, 0xa5, 0x35, 0x2f, 0xbf, 0x4e, 0x0e, 0x3b, 0xda, 0xa6, 0x6a,
	0xff, 0xc3, 0x82, 0x46, 0xf9, 0x2d, 0x90, 0x95, 0xaf, 0xab, 0xf5, 0x8c, 0x64, 0x9c, 0xb2, 0xa4,
	0x78, 0xdc, 0x95, 0xf0, 0x89, 0x96, 0xa1, 0x4f, 0xd5, 0x28, 0x95, 0x92, 0x4c, 0x50, 0x53, 0xf5,
	0x53, 0x7b, 0x59, 0xd9, 0x45, 0xfb, 0x70, 0x60, 0xaa, 0x7b, 0xd9, 0x08, 0xd6, 0xc6, 0x87, 0xb0,
	0x7a, 0x61, 0xfb, 0xa5, 0xfa, 0xd9, 0x17, 0x16, 0xac, 0xed, 0x66, 0x04, 0x8b, 0xa2, 0x79, 0xba,
	0xe4, 0x37, 0x39, 0xe1, 0x62, 0xd6, 0xf0, 0xb7, 0x0e, 0x0b, 0x19, 0x09, 0xe5, 0x71, 0x75, 0x83,
	0x32, 0x5f, 0x68, 0x1b, 0x16, 0xcd, 0x04, 0x63, 0x72, 0xed, 0xad, 0x99, 0xd9, 0xe1, 0x16, 0x16,
	0xf6, 0x7f, 0x2c, 0x58, 0x3b, 0x49, 0x83, 0xaf, 0x40, 0xa6, 0x5a, 0x22, 0x73, 0x85, 0x09, 0x75,
	0x84, 0xef, 0xdc, 0xcb, 0xf2, 0x45, 0xdb, 0xb0, 0x9c, 0x2b, 0xba, 0x6a, 0xfc, 0x36, 0x23, 0xea,
	0xe5, 0x34, 0x7d, 0x20, 0x27, 0xf4, 0x47, 0x98, 0xf7, 0x5d, 0xd0, 0xea, 0x72, 0x6d, 0xa7, 0xb0,
	0xd6, 0x21, 0x11, 0xb9, 0xa9, 0xc0, 0xcf, 0x3e, 0xab, 0x1d, 0xc3, 0xad, 0x7d, 0x22, 0x5e, 0x99,
	0xbb, 0xdf, 0x59, 0xf0, 0xda, 0x43, 0xca, 0x0b, 0x87, 0xfc, 0xa5, 0x3d, 0xce, 0x97, 0x3c, 0xde,
	0x86, 0xa5, 0x54, 0x96, 0x99, 0xec, 0xb0, 0xa6, 0x6d, 0xd6, 0xa4, 0x40, 0xb6, 0x56, 0x85, 0x29,
	0x37, 0x05, 0xeb, 0x93, 0x82, 0xaa, 0x52, 0x3f, 0x96, 0x02, 0xfb, 0x05, 0xac, 0x95, 0x99, 0xf0,
	0x94, 0x25, 0x5c, 0xbe, 0x03, 0xb5, 0xe2, 0x07, 0x6a, 0xcb, 0x52, 0x45, 0x79, 0x85, 0xeb, 0x1f,
	0x98, 0xa0, 0xef, 0xc0, 0x6a, 0x42, 0x3e, 0x17, 0xde, 0x88, 0x6b, 0x1d, 0x87, 0xba, 0x14, 0x1f,
	0x0e, 0xdc, 0x67, 0xb0, 0xde, 0xa1, 0x38, 0x4c, 0x18, 0x7f, 0x75, 0x97, 0xfd, 0xe3, 0x31, 0x3e,
	0x79, 0x1e, 0x09, 0x2e, 0x7d, 0xb2, 0x5c, 0xa4, 0xb9, 0x18, 0x19, 0x17, 0x97, 0xb4, 0xe4, 0x24,
	0xa3, 0x5b, 0x7f, 0xa9, 0xc1, 0xad, 0xe1, 0x20, 0x25, 0x32, 0x16, 0x45, 0x24, 0x43, 0x7f, 0xb2,
	0xa0, 0x5e, 0xea, 0x13, 0xa8, 0x3d, 0x25, 0x52, 0x63, 0x1a, 0xca, 0xc6, 0x9b, 0x85, 0xfe, 0xc8,
	0xaf, 0xe5, 0xf6, 0xe3, 0xe2, 0xd7, 0xb2, 0xdd, 0xf9, 0xed, 0x3f, 0xff, 0xfd, 0xc7, 0xca, 0x4f,
	0xed, 0xf7, 0xe4, 0x0f, 0x71, 0x13, 0x01, 0xee, 0x3c, 0x1f, 0x46, 0xe7, 0x85, 0xa3, 0x0f, 0xcf,
	0x9d, 0xe7, 0x7a, 0xf1, 0x62, 0xf0, 0xcf, 0x85, 0x7b, 0x83, 0x8a, 0xfc, 0xab, 0x05, 0xf5, 0x52,
	0x07, 0x99, 0x46, 0x73, 0x5c, 0xab, 0x99, 0x45, 0xf3, 0x48, 0xd1, 0x7c, 0xb4, 0xb5, 0x73, 0x0d,
	0x9a, 0xce, 0xf3, 0xd1, 0x4b, 0x7b, 0x31, 0x64, 0xfd, 0xa5, 0x05, 0xf5, 0x52, 0x2f, 0x98, 0xc6,
	0x7a, 0x5c, 0xd3, 0x98, 0xc5, 0xfa, 0xe7, 0x8a, 0x75, 0xe7, 0xee, 0x0d, 0xb0, 0x46, 0x7f, 0xb6,
	0x00, 0x86, 0x6d, 0x04, 0x7d, 0x6f, 0xca, 0x44, 0x7e, 0xb1, 0xd9, 0x6c, 0xcc, 0xae, 0xae, 0x82,
	0x2a, 0xba, 0x09, 0xaa, 0x5f, 0x5a, 0xb0, 0x32, 0x5a, 0xf7, 0x68, 0xca, 0xa8, 0x32, 0xa6, 0x53,
	0x6d, 0xb4, 0xaf, 0xaa, 0xae, 0xdb, 0x89, 0xbd, 0xad, 0xb8, 0xff, 0x08, 0x5d, 0x27, 0x87, 0xd1,
	0xdf, 0x2c, 0x58, 0xbd, 0x50, 0xb1, 0xe8, 0x87, 0xd3, 0xa6, 0xf5, 0x71, 0x0d, 0x65, 0x56, 0x22,
	0x3c, 0x51, 0x0c, 0x0f, 0xed, 0x8f, 0x6f, 0x20, 0x7d, 0x03, 0xc3, 0xe0, 0x9e, 0x75, 0x77, 0xc7,
	0x81, 0x6f, 0xf8, 0x2c, 0x9e, 0xc8, 0x76, 0xa7, 0x98, 0x20, 0xf9, 0xa1, 0x7c, 0x14, 0x0f, 0xad,
	0xde, 0x82, 0x7a, 0x1d, 0xdf, 0xfb, 0x7f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa6, 0x0b, 0x0f, 0xab,
	0x59, 0x14, 0x00, 0x00,
}
