// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/appengine/v1/service.proto
// DO NOT EDIT!

package google_appengine_v1 // import "google.golang.org/genproto/googleapis/appengine/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Available sharding mechanisms.
type TrafficSplit_ShardBy int32

const (
	// Diversion method unspecified.
	TrafficSplit_UNSPECIFIED TrafficSplit_ShardBy = 0
	// Diversion based on a specially named cookie, "GOOGAPPUID." The cookie
	// must be set by the application itself or no diversion will occur.
	TrafficSplit_COOKIE TrafficSplit_ShardBy = 1
	// Diversion based on applying the modulus operation to a fingerprint
	// of the IP address.
	TrafficSplit_IP TrafficSplit_ShardBy = 2
)

var TrafficSplit_ShardBy_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "COOKIE",
	2: "IP",
}
var TrafficSplit_ShardBy_value = map[string]int32{
	"UNSPECIFIED": 0,
	"COOKIE":      1,
	"IP":          2,
}

func (x TrafficSplit_ShardBy) String() string {
	return proto.EnumName(TrafficSplit_ShardBy_name, int32(x))
}
func (TrafficSplit_ShardBy) EnumDescriptor() ([]byte, []int) { return fileDescriptor7, []int{1, 0} }

// A Service resource is a logical component of an application that can share
// state and communicate in a secure fashion with other services.
// For example, an application that handles customer requests might
// include separate services to handle tasks such as backend data
// analysis or API requests from mobile devices. Each service has a
// collection of versions that define a specific set of code used to
// implement the functionality of that service.
type Service struct {
	// Full path to the Service resource in the API.
	// Example: `apps/myapp/services/default`.
	//
	// @OutputOnly
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Relative name of the service within the application.
	// Example: `default`.
	//
	// @OutputOnly
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// Mapping that defines fractional HTTP traffic diversion to
	// different versions within the service.
	Split *TrafficSplit `protobuf:"bytes,3,opt,name=split" json:"split,omitempty"`
}

func (m *Service) Reset()                    { *m = Service{} }
func (m *Service) String() string            { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()               {}
func (*Service) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{0} }

func (m *Service) GetSplit() *TrafficSplit {
	if m != nil {
		return m.Split
	}
	return nil
}

// Traffic routing configuration for versions within a single service. Traffic
// splits define how traffic directed to the service is assigned to versions.
type TrafficSplit struct {
	// Mechanism used to determine which version a request is sent to.
	// The traffic selection algorithm will
	// be stable for either type until allocations are changed.
	ShardBy TrafficSplit_ShardBy `protobuf:"varint,1,opt,name=shard_by,json=shardBy,enum=google.appengine.v1.TrafficSplit_ShardBy" json:"shard_by,omitempty"`
	// Mapping from version IDs within the service to fractional
	// (0.000, 1] allocations of traffic for that version. Each version can
	// be specified only once, but some versions in the service may not
	// have any traffic allocation. Services that have traffic allocated
	// cannot be deleted until either the service is deleted or
	// their traffic allocation is removed. Allocations must sum to 1.
	// Up to two decimal place precision is supported for IP-based splits and
	// up to three decimal places is supported for cookie-based splits.
	Allocations map[string]float64 `protobuf:"bytes,2,rep,name=allocations" json:"allocations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"fixed64,2,opt,name=value"`
}

func (m *TrafficSplit) Reset()                    { *m = TrafficSplit{} }
func (m *TrafficSplit) String() string            { return proto.CompactTextString(m) }
func (*TrafficSplit) ProtoMessage()               {}
func (*TrafficSplit) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{1} }

func (m *TrafficSplit) GetAllocations() map[string]float64 {
	if m != nil {
		return m.Allocations
	}
	return nil
}

func init() {
	proto.RegisterType((*Service)(nil), "google.appengine.v1.Service")
	proto.RegisterType((*TrafficSplit)(nil), "google.appengine.v1.TrafficSplit")
	proto.RegisterEnum("google.appengine.v1.TrafficSplit_ShardBy", TrafficSplit_ShardBy_name, TrafficSplit_ShardBy_value)
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/appengine/v1/service.proto", fileDescriptor7)
}

var fileDescriptor7 = []byte{
	// 350 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x91, 0xcd, 0x6a, 0xe3, 0x30,
	0x10, 0x80, 0xd7, 0xca, 0x26, 0xd9, 0x1d, 0x87, 0xac, 0xd1, 0x2e, 0xac, 0xc9, 0x29, 0x9b, 0x53,
	0x72, 0x91, 0x89, 0xf7, 0xd0, 0xd2, 0x43, 0x69, 0x93, 0xb8, 0x60, 0x0a, 0x8d, 0xb1, 0xd3, 0x73,
	0x51, 0x1c, 0x59, 0x15, 0x75, 0x24, 0x63, 0xbb, 0x06, 0xbf, 0x4a, 0x9f, 0xb6, 0xf8, 0xa7, 0x6d,
	0x28, 0x81, 0xf4, 0x36, 0x1a, 0x7d, 0xf3, 0x69, 0x34, 0x03, 0x57, 0x5c, 0x29, 0x1e, 0x33, 0xc2,
	0x55, 0x4c, 0x25, 0x27, 0x2a, 0xe5, 0x16, 0x67, 0x32, 0x49, 0x55, 0xae, 0xac, 0xe6, 0x8a, 0x26,
	0x22, 0xb3, 0x68, 0x92, 0x30, 0xc9, 0x85, 0x64, 0x56, 0x31, 0xb7, 0x32, 0x96, 0x16, 0x22, 0x64,
	0xa4, 0xa6, 0xf0, 0xef, 0xd6, 0xf0, 0x8e, 0x90, 0x62, 0x3e, 0x72, 0xbf, 0xaa, 0x15, 0x6f, 0xb6,
	0x50, 0xc9, 0x48, 0x70, 0x8b, 0x4a, 0xa9, 0x72, 0x9a, 0x0b, 0x25, 0xb3, 0xc6, 0x3f, 0x89, 0xa0,
	0x1f, 0x34, 0x08, 0xc6, 0xf0, 0x5d, 0xd2, 0x3d, 0x33, 0xb5, 0xb1, 0x36, 0xfd, 0xe9, 0xd7, 0x31,
	0x1e, 0x02, 0x12, 0x3b, 0x13, 0xd5, 0x19, 0x24, 0x76, 0xf8, 0x0c, 0xba, 0x59, 0x12, 0x8b, 0xdc,
	0xec, 0x8c, 0xb5, 0xa9, 0x6e, 0xff, 0x23, 0x47, 0xda, 0x23, 0x9b, 0x94, 0x46, 0x91, 0x08, 0x83,
	0x0a, 0xf4, 0x1b, 0x7e, 0xf2, 0x82, 0x60, 0x70, 0x98, 0xc7, 0x2b, 0xf8, 0x91, 0x3d, 0xd2, 0x74,
	0xf7, 0xb0, 0x2d, 0xeb, 0x17, 0x87, 0xf6, 0xec, 0xa4, 0x8c, 0x04, 0x55, 0xc5, 0xa2, 0xf4, 0xfb,
	0x59, 0x13, 0xe0, 0x0d, 0xe8, 0x34, 0x8e, 0x55, 0xd8, 0xfc, 0xc9, 0x44, 0xe3, 0xce, 0x54, 0xb7,
	0xed, 0xd3, 0xa2, 0xeb, 0x8f, 0x22, 0x47, 0xe6, 0x69, 0xe9, 0x1f, 0x6a, 0x46, 0x97, 0x60, 0x7c,
	0x06, 0xb0, 0x01, 0x9d, 0x27, 0x56, 0xb6, 0xc3, 0xa9, 0x42, 0xfc, 0x07, 0xba, 0x05, 0x8d, 0x9f,
	0x59, 0x3d, 0x1e, 0xcd, 0x6f, 0x0e, 0x17, 0xe8, 0x5c, 0x9b, 0x10, 0xe8, 0xb7, 0x9d, 0xe2, 0x5f,
	0xa0, 0xdf, 0xdf, 0x05, 0x9e, 0xb3, 0x74, 0x6f, 0x5c, 0x67, 0x65, 0x7c, 0xc3, 0x00, 0xbd, 0xe5,
	0x7a, 0x7d, 0xeb, 0x3a, 0x86, 0x86, 0x7b, 0x80, 0x5c, 0xcf, 0x40, 0x8b, 0x19, 0xfc, 0x0d, 0xd5,
	0xfe, 0x58, 0xd7, 0x8b, 0x41, 0xbb, 0x1d, 0xaf, 0xda, 0x96, 0xa7, 0x6d, 0x7b, 0xf5, 0xda, 0xfe,
	0xbf, 0x06, 0x00, 0x00, 0xff, 0xff, 0xf2, 0x86, 0xd3, 0x59, 0x5a, 0x02, 0x00, 0x00,
}
