// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/serviceconfig/system_parameter.proto
// DO NOT EDIT!

package google_api // import "google.golang.org/genproto/googleapis/api/serviceconfig"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// ### System parameter configuration
//
// A system parameter is a special kind of parameter defined by the API
// system, not by an individual API. It is typically mapped to an HTTP header
// and/or a URL query parameter. This configuration specifies which methods
// change the names of the system parameters.
type SystemParameters struct {
	// Define system parameters.
	//
	// The parameters defined here will override the default parameters
	// implemented by the system. If this field is missing from the service
	// config, default system parameters will be used. Default system parameters
	// and names is implementation-dependent.
	//
	// Example: define api key and alt name for all methods
	//
	// system_parameters
	//   rules:
	//     - selector: "*"
	//       parameters:
	//         - name: api_key
	//           url_query_parameter: api_key
	//         - name: alt
	//           http_header: Response-Content-Type
	//
	// Example: define 2 api key names for a specific method.
	//
	// system_parameters
	//   rules:
	//     - selector: "/ListShelves"
	//       parameters:
	//         - name: api_key
	//           http_header: Api-Key1
	//         - name: api_key
	//           http_header: Api-Key2
	//
	// **NOTE:** All service configuration rules follow "last one wins" order.
	Rules []*SystemParameterRule `protobuf:"bytes,1,rep,name=rules" json:"rules,omitempty"`
}

func (m *SystemParameters) Reset()                    { *m = SystemParameters{} }
func (m *SystemParameters) String() string            { return proto.CompactTextString(m) }
func (*SystemParameters) ProtoMessage()               {}
func (*SystemParameters) Descriptor() ([]byte, []int) { return fileDescriptor14, []int{0} }

func (m *SystemParameters) GetRules() []*SystemParameterRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

// Define a system parameter rule mapping system parameter definitions to
// methods.
type SystemParameterRule struct {
	// Selects the methods to which this rule applies. Use '*' to indicate all
	// methods in all APIs.
	//
	// Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
	Selector string `protobuf:"bytes,1,opt,name=selector" json:"selector,omitempty"`
	// Define parameters. Multiple names may be defined for a parameter.
	// For a given method call, only one of them should be used. If multiple
	// names are used the behavior is implementation-dependent.
	// If none of the specified names are present the behavior is
	// parameter-dependent.
	Parameters []*SystemParameter `protobuf:"bytes,2,rep,name=parameters" json:"parameters,omitempty"`
}

func (m *SystemParameterRule) Reset()                    { *m = SystemParameterRule{} }
func (m *SystemParameterRule) String() string            { return proto.CompactTextString(m) }
func (*SystemParameterRule) ProtoMessage()               {}
func (*SystemParameterRule) Descriptor() ([]byte, []int) { return fileDescriptor14, []int{1} }

func (m *SystemParameterRule) GetParameters() []*SystemParameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

// Define a parameter's name and location. The parameter may be passed as either
// an HTTP header or a URL query parameter, and if both are passed the behavior
// is implementation-dependent.
type SystemParameter struct {
	// Define the name of the parameter, such as "api_key", "alt", "callback",
	// and etc. It is case sensitive.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Define the HTTP header name to use for the parameter. It is case
	// insensitive.
	HttpHeader string `protobuf:"bytes,2,opt,name=http_header,json=httpHeader" json:"http_header,omitempty"`
	// Define the URL query parameter name to use for the parameter. It is case
	// sensitive.
	UrlQueryParameter string `protobuf:"bytes,3,opt,name=url_query_parameter,json=urlQueryParameter" json:"url_query_parameter,omitempty"`
}

func (m *SystemParameter) Reset()                    { *m = SystemParameter{} }
func (m *SystemParameter) String() string            { return proto.CompactTextString(m) }
func (*SystemParameter) ProtoMessage()               {}
func (*SystemParameter) Descriptor() ([]byte, []int) { return fileDescriptor14, []int{2} }

func init() {
	proto.RegisterType((*SystemParameters)(nil), "google.api.SystemParameters")
	proto.RegisterType((*SystemParameterRule)(nil), "google.api.SystemParameterRule")
	proto.RegisterType((*SystemParameter)(nil), "google.api.SystemParameter")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/serviceconfig/system_parameter.proto", fileDescriptor14)
}

var fileDescriptor14 = []byte{
	// 278 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x7c, 0x90, 0xbf, 0x4e, 0xc3, 0x30,
	0x10, 0xc6, 0x95, 0xb6, 0x20, 0xb8, 0x4a, 0xfc, 0x71, 0x19, 0x22, 0x18, 0x5a, 0x65, 0xea, 0x64,
	0x4b, 0x20, 0x26, 0x26, 0xba, 0x40, 0x17, 0x14, 0xc2, 0x03, 0x44, 0x26, 0x1c, 0x6e, 0x24, 0x27,
	0x36, 0x67, 0xa7, 0x52, 0x5f, 0x87, 0x27, 0x45, 0x71, 0x4b, 0x5a, 0x45, 0x88, 0xcd, 0xbe, 0xdf,
	0xcf, 0xfe, 0x4e, 0x1f, 0xbc, 0x28, 0x63, 0x94, 0x46, 0xae, 0x8c, 0x96, 0xb5, 0xe2, 0x86, 0x94,
	0x50, 0x58, 0x5b, 0x32, 0xde, 0x88, 0x2d, 0x92, 0xb6, 0x74, 0x42, 0xda, 0x52, 0x38, 0xa4, 0x75,
	0x59, 0x60, 0x61, 0xea, 0xcf, 0x52, 0x09, 0xb7, 0x71, 0x1e, 0xab, 0xdc, 0x4a, 0x92, 0x15, 0x7a,
	0x24, 0x1e, 0xde, 0x30, 0xd8, 0xfd, 0x27, 0x6d, 0x99, 0x2c, 0xe1, 0xe2, 0x2d, 0x58, 0xe9, 0xaf,
	0xe4, 0xd8, 0x3d, 0x1c, 0x51, 0xa3, 0xd1, 0xc5, 0xd1, 0x6c, 0x38, 0x1f, 0xdf, 0x4e, 0xf9, 0xde,
	0xe7, 0x3d, 0x39, 0x6b, 0x34, 0x66, 0x5b, 0x3b, 0xa9, 0x61, 0xf2, 0x07, 0x65, 0xd7, 0x70, 0xe2,
	0x50, 0x63, 0xe1, 0x0d, 0xc5, 0xd1, 0x2c, 0x9a, 0x9f, 0x66, 0xdd, 0x9d, 0x3d, 0x00, 0x74, 0xcb,
	0xb9, 0x78, 0x10, 0xe2, 0x6e, 0xfe, 0x8b, 0x3b, 0xd0, 0x93, 0x35, 0x9c, 0xf7, 0x30, 0x63, 0x30,
	0xaa, 0x65, 0x85, 0xbb, 0x9c, 0x70, 0x66, 0x53, 0x18, 0xaf, 0xbc, 0xb7, 0xf9, 0x0a, 0xe5, 0x07,
	0x52, 0x3c, 0x08, 0x08, 0xda, 0xd1, 0x73, 0x98, 0x30, 0x0e, 0x93, 0x86, 0x74, 0xfe, 0xd5, 0x20,
	0x6d, 0xf6, 0x5d, 0xc5, 0xc3, 0x20, 0x5e, 0x36, 0xa4, 0x5f, 0x5b, 0xd2, 0x85, 0x2c, 0x04, 0x9c,
	0x15, 0xa6, 0x3a, 0xd8, 0x72, 0x71, 0xd5, 0xdb, 0x23, 0x6d, 0x6b, 0x4e, 0xa3, 0xef, 0xc1, 0xe8,
	0xe9, 0x31, 0x5d, 0xbe, 0x1f, 0x87, 0xda, 0xef, 0x7e, 0x02, 0x00, 0x00, 0xff, 0xff, 0x56, 0xd1,
	0x77, 0xac, 0xc8, 0x01, 0x00, 0x00,
}
