// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/serviceconfig/consumer.proto
// DO NOT EDIT!

package google_api // import "google.golang.org/genproto/googleapis/api/serviceconfig"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Supported data type of the property values
type Property_PropertyType int32

const (
	// The type is unspecified, and will result in an error.
	Property_UNSPECIFIED Property_PropertyType = 0
	// The type is `int64`.
	Property_INT64 Property_PropertyType = 1
	// The type is `bool`.
	Property_BOOL Property_PropertyType = 2
	// The type is `string`.
	Property_STRING Property_PropertyType = 3
	// The type is 'double'.
	Property_DOUBLE Property_PropertyType = 4
)

var Property_PropertyType_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "INT64",
	2: "BOOL",
	3: "STRING",
	4: "DOUBLE",
}
var Property_PropertyType_value = map[string]int32{
	"UNSPECIFIED": 0,
	"INT64":       1,
	"BOOL":        2,
	"STRING":      3,
	"DOUBLE":      4,
}

func (x Property_PropertyType) String() string {
	return proto.EnumName(Property_PropertyType_name, int32(x))
}
func (Property_PropertyType) EnumDescriptor() ([]byte, []int) { return fileDescriptor4, []int{1, 0} }

// A descriptor for defining project properties for a service. One service may
// have many consumer projects, and the service may want to behave differently
// depending on some properties on the project. For example, a project may be
// associated with a school, or a business, or a government agency, a business
// type property on the project may affect how a service responds to the client.
// This descriptor defines which properties are allowed to be set on a project.
//
// Example:
//
//    project_properties:
//      properties:
//      - name: NO_WATERMARK
//        type: BOOL
//        description: Allows usage of the API without watermarks.
//      - name: EXTENDED_TILE_CACHE_PERIOD
//        type: INT64
type ProjectProperties struct {
	// List of per consumer project-specific properties.
	Properties []*Property `protobuf:"bytes,1,rep,name=properties" json:"properties,omitempty"`
}

func (m *ProjectProperties) Reset()                    { *m = ProjectProperties{} }
func (m *ProjectProperties) String() string            { return proto.CompactTextString(m) }
func (*ProjectProperties) ProtoMessage()               {}
func (*ProjectProperties) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{0} }

func (m *ProjectProperties) GetProperties() []*Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

// Defines project properties.
//
// API services can define properties that can be assigned to consumer projects
// so that backends can perform response customization without having to make
// additional calls or maintain additional storage. For example, Maps API
// defines properties that controls map tile cache period, or whether to embed a
// watermark in a result.
//
// These values can be set via API producer console. Only API providers can
// define and set these properties.
type Property struct {
	// The name of the property (a.k.a key).
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The type of this property.
	Type Property_PropertyType `protobuf:"varint,2,opt,name=type,enum=google.api.Property_PropertyType" json:"type,omitempty"`
	// The description of the property
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
}

func (m *Property) Reset()                    { *m = Property{} }
func (m *Property) String() string            { return proto.CompactTextString(m) }
func (*Property) ProtoMessage()               {}
func (*Property) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{1} }

func init() {
	proto.RegisterType((*ProjectProperties)(nil), "google.api.ProjectProperties")
	proto.RegisterType((*Property)(nil), "google.api.Property")
	proto.RegisterEnum("google.api.Property_PropertyType", Property_PropertyType_name, Property_PropertyType_value)
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/serviceconfig/consumer.proto", fileDescriptor4)
}

var fileDescriptor4 = []byte{
	// 290 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x6c, 0x90, 0xcf, 0x4e, 0xf2, 0x40,
	0x14, 0xc5, 0xbf, 0x81, 0x7e, 0x04, 0x2e, 0x8a, 0x75, 0xe2, 0xa2, 0xcb, 0xc2, 0x8a, 0x55, 0x9b,
	0x20, 0xfa, 0x00, 0xe5, 0x8f, 0x69, 0x42, 0xa0, 0x29, 0xf0, 0x00, 0x75, 0xbc, 0x4e, 0xc6, 0xd0,
	0xb9, 0x93, 0x69, 0x35, 0xe9, 0x03, 0xfa, 0x5e, 0x86, 0x5a, 0xb1, 0x0b, 0x77, 0x67, 0xe6, 0xfc,
	0xce, 0xc9, 0xcd, 0x81, 0xb5, 0x24, 0x92, 0x27, 0x0c, 0x24, 0x9d, 0x32, 0x2d, 0x03, 0xb2, 0x32,
	0x94, 0xa8, 0x8d, 0xa5, 0x92, 0xc2, 0x6f, 0x2b, 0x33, 0xaa, 0x08, 0x33, 0xa3, 0xc2, 0x02, 0xed,
	0x87, 0x12, 0x28, 0x48, 0xbf, 0x2a, 0x19, 0x0a, 0xd2, 0xc5, 0x7b, 0x8e, 0x36, 0xa8, 0x59, 0x0e,
	0x4d, 0x4f, 0x66, 0xd4, 0x24, 0x86, 0xdb, 0xc4, 0xd2, 0x1b, 0x8a, 0x32, 0xb1, 0x64, 0xd0, 0x96,
	0x0a, 0x0b, 0x3e, 0x07, 0x30, 0x97, 0x97, 0xc7, 0xfc, 0xee, 0x74, 0x38, 0xbb, 0x0b, 0x7e, 0x53,
	0x41, 0xc3, 0x56, 0x69, 0x8b, 0x9b, 0x7c, 0x32, 0xe8, 0xff, 0x18, 0x9c, 0x83, 0xa3, 0xb3, 0x1c,
	0x3d, 0xe6, 0xb3, 0xe9, 0x20, 0xad, 0x35, 0x7f, 0x00, 0xa7, 0xac, 0x0c, 0x7a, 0x1d, 0x9f, 0x4d,
	0x47, 0xb3, 0xf1, 0x5f, 0x85, 0x17, 0x71, 0xa8, 0x0c, 0xa6, 0x35, 0xce, 0x7d, 0x18, 0xbe, 0x60,
	0x21, 0xac, 0x32, 0xa5, 0x22, 0xed, 0x75, 0xeb, 0xc6, 0xf6, 0xd7, 0x64, 0x03, 0x57, 0xed, 0x1c,
	0xbf, 0x81, 0xe1, 0x71, 0xbb, 0x4f, 0x56, 0x8b, 0x78, 0x1d, 0xaf, 0x96, 0xee, 0x3f, 0x3e, 0x80,
	0xff, 0xf1, 0xf6, 0xf0, 0x38, 0x77, 0x19, 0xef, 0x83, 0x13, 0xed, 0x76, 0x1b, 0xb7, 0xc3, 0x01,
	0x7a, 0xfb, 0x43, 0x1a, 0x6f, 0x9f, 0xdc, 0xee, 0x59, 0x2f, 0x77, 0xc7, 0x68, 0xb3, 0x72, 0x9d,
	0x68, 0x0c, 0x23, 0x41, 0x79, 0xeb, 0xba, 0xe8, 0x7a, 0xd1, 0x0c, 0x98, 0x9c, 0xf7, 0x4b, 0xd8,
	0x73, 0xaf, 0x1e, 0xf2, 0xfe, 0x2b, 0x00, 0x00, 0xff, 0xff, 0x61, 0xba, 0x74, 0x16, 0x92, 0x01,
	0x00, 0x00,
}
