// Code generated by protoc-gen-go.
// source: google.golang.org/cloud/datastore/internal/proto/query.proto
// DO NOT EDIT!

package google_datastore_v1beta3

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf2 "github.com/golang/protobuf/ptypes/wrappers"
import _ "google.golang.org/cloud/datastore/internal/type_proto"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Specifies what data the 'entity' field contains.
// A `ResultType` is either implied (for example, in `LookupResponse.missing`
// from `datastore.proto`, it is always `KEY_ONLY`) or specified by context
// (for example, in message `QueryResultBatch`, field `entity_result_type`
// specifies a `ResultType` for all the values in field `entity_results`).
type EntityResult_ResultType int32

const (
	// Unspecified. This value is never used.
	EntityResult_RESULT_TYPE_UNSPECIFIED EntityResult_ResultType = 0
	// The key and properties.
	EntityResult_FULL EntityResult_ResultType = 1
	// A projected subset of properties. The entity may have no key.
	EntityResult_PROJECTION EntityResult_ResultType = 2
	// Only the key.
	EntityResult_KEY_ONLY EntityResult_ResultType = 3
)

var EntityResult_ResultType_name = map[int32]string{
	0: "RESULT_TYPE_UNSPECIFIED",
	1: "FULL",
	2: "PROJECTION",
	3: "KEY_ONLY",
}
var EntityResult_ResultType_value = map[string]int32{
	"RESULT_TYPE_UNSPECIFIED": 0,
	"FULL":       1,
	"PROJECTION": 2,
	"KEY_ONLY":   3,
}

func (x EntityResult_ResultType) String() string {
	return proto.EnumName(EntityResult_ResultType_name, int32(x))
}
func (EntityResult_ResultType) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{0, 0} }

// The sort direction.
type PropertyOrder_Direction int32

const (
	// Unspecified. This value must not be used.
	PropertyOrder_DIRECTION_UNSPECIFIED PropertyOrder_Direction = 0
	// Ascending.
	PropertyOrder_ASCENDING PropertyOrder_Direction = 1
	// Descending.
	PropertyOrder_DESCENDING PropertyOrder_Direction = 2
)

var PropertyOrder_Direction_name = map[int32]string{
	0: "DIRECTION_UNSPECIFIED",
	1: "ASCENDING",
	2: "DESCENDING",
}
var PropertyOrder_Direction_value = map[string]int32{
	"DIRECTION_UNSPECIFIED": 0,
	"ASCENDING":             1,
	"DESCENDING":            2,
}

func (x PropertyOrder_Direction) String() string {
	return proto.EnumName(PropertyOrder_Direction_name, int32(x))
}
func (PropertyOrder_Direction) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{5, 0} }

// A composite filter operator.
type CompositeFilter_Operator int32

const (
	// Unspecified. This value must not be used.
	CompositeFilter_OPERATOR_UNSPECIFIED CompositeFilter_Operator = 0
	// The results are required to satisfy each of the combined filters.
	CompositeFilter_AND CompositeFilter_Operator = 1
)

var CompositeFilter_Operator_name = map[int32]string{
	0: "OPERATOR_UNSPECIFIED",
	1: "AND",
}
var CompositeFilter_Operator_value = map[string]int32{
	"OPERATOR_UNSPECIFIED": 0,
	"AND": 1,
}

func (x CompositeFilter_Operator) String() string {
	return proto.EnumName(CompositeFilter_Operator_name, int32(x))
}
func (CompositeFilter_Operator) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{7, 0} }

// A property filter operator.
type PropertyFilter_Operator int32

const (
	// Unspecified. This value must not be used.
	PropertyFilter_OPERATOR_UNSPECIFIED PropertyFilter_Operator = 0
	// Less than.
	PropertyFilter_LESS_THAN PropertyFilter_Operator = 1
	// Less than or equal.
	PropertyFilter_LESS_THAN_OR_EQUAL PropertyFilter_Operator = 2
	// Greater than.
	PropertyFilter_GREATER_THAN PropertyFilter_Operator = 3
	// Greater than or equal.
	PropertyFilter_GREATER_THAN_OR_EQUAL PropertyFilter_Operator = 4
	// Equal.
	PropertyFilter_EQUAL PropertyFilter_Operator = 5
	// Has ancestor.
	PropertyFilter_HAS_ANCESTOR PropertyFilter_Operator = 11
)

var PropertyFilter_Operator_name = map[int32]string{
	0:  "OPERATOR_UNSPECIFIED",
	1:  "LESS_THAN",
	2:  "LESS_THAN_OR_EQUAL",
	3:  "GREATER_THAN",
	4:  "GREATER_THAN_OR_EQUAL",
	5:  "EQUAL",
	11: "HAS_ANCESTOR",
}
var PropertyFilter_Operator_value = map[string]int32{
	"OPERATOR_UNSPECIFIED":  0,
	"LESS_THAN":             1,
	"LESS_THAN_OR_EQUAL":    2,
	"GREATER_THAN":          3,
	"GREATER_THAN_OR_EQUAL": 4,
	"EQUAL":                 5,
	"HAS_ANCESTOR":          11,
}

func (x PropertyFilter_Operator) String() string {
	return proto.EnumName(PropertyFilter_Operator_name, int32(x))
}
func (PropertyFilter_Operator) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{8, 0} }

// The possible values for the `more_results` field.
type QueryResultBatch_MoreResultsType int32

const (
	// Unspecified. This value is never used.
	QueryResultBatch_MORE_RESULTS_TYPE_UNSPECIFIED QueryResultBatch_MoreResultsType = 0
	// There may be additional batches to fetch from this query.
	QueryResultBatch_NOT_FINISHED QueryResultBatch_MoreResultsType = 1
	// The query is finished, but there may be more results after the limit.
	QueryResultBatch_MORE_RESULTS_AFTER_LIMIT QueryResultBatch_MoreResultsType = 2
	// The query is finished, but there may be more results after the end cursor.
	QueryResultBatch_MORE_RESULTS_AFTER_CURSOR QueryResultBatch_MoreResultsType = 4
	// The query has been exhausted.
	QueryResultBatch_NO_MORE_RESULTS QueryResultBatch_MoreResultsType = 3
)

var QueryResultBatch_MoreResultsType_name = map[int32]string{
	0: "MORE_RESULTS_TYPE_UNSPECIFIED",
	1: "NOT_FINISHED",
	2: "MORE_RESULTS_AFTER_LIMIT",
	4: "MORE_RESULTS_AFTER_CURSOR",
	3: "NO_MORE_RESULTS",
}
var QueryResultBatch_MoreResultsType_value = map[string]int32{
	"MORE_RESULTS_TYPE_UNSPECIFIED": 0,
	"NOT_FINISHED":                  1,
	"MORE_RESULTS_AFTER_LIMIT":      2,
	"MORE_RESULTS_AFTER_CURSOR":     4,
	"NO_MORE_RESULTS":               3,
}

func (x QueryResultBatch_MoreResultsType) String() string {
	return proto.EnumName(QueryResultBatch_MoreResultsType_name, int32(x))
}
func (QueryResultBatch_MoreResultsType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor2, []int{11, 0}
}

// The result of fetching an entity from Datastore.
type EntityResult struct {
	// The resulting entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity" json:"entity,omitempty"`
	// A cursor that points to the position after the result entity.
	// Set only when the `EntityResult` is part of a `QueryResultBatch` message.
	Cursor []byte `protobuf:"bytes,3,opt,name=cursor,proto3" json:"cursor,omitempty"`
}

func (m *EntityResult) Reset()                    { *m = EntityResult{} }
func (m *EntityResult) String() string            { return proto.CompactTextString(m) }
func (*EntityResult) ProtoMessage()               {}
func (*EntityResult) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

func (m *EntityResult) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

// A query for entities.
type Query struct {
	// The projection to return. Defaults to returning all properties.
	Projection []*Projection `protobuf:"bytes,2,rep,name=projection" json:"projection,omitempty"`
	// The kinds to query (if empty, returns entities of all kinds).
	// Currently at most 1 kind may be specified.
	Kind []*KindExpression `protobuf:"bytes,3,rep,name=kind" json:"kind,omitempty"`
	// The filter to apply.
	Filter *Filter `protobuf:"bytes,4,opt,name=filter" json:"filter,omitempty"`
	// The order to apply to the query results (if empty, order is unspecified).
	Order []*PropertyOrder `protobuf:"bytes,5,rep,name=order" json:"order,omitempty"`
	// The properties to make distinct. The query results will contain the first
	// result for each distinct combination of values for the given properties
	// (if empty, all results are returned).
	DistinctOn []*PropertyReference `protobuf:"bytes,6,rep,name=distinct_on,json=distinctOn" json:"distinct_on,omitempty"`
	// A starting point for the query results. Query cursors are
	// returned in query result batches.
	StartCursor []byte `protobuf:"bytes,7,opt,name=start_cursor,json=startCursor,proto3" json:"start_cursor,omitempty"`
	// An ending point for the query results. Query cursors are
	// returned in query result batches.
	EndCursor []byte `protobuf:"bytes,8,opt,name=end_cursor,json=endCursor,proto3" json:"end_cursor,omitempty"`
	// The number of results to skip. Applies before limit, but after all other
	// constraints. Optional. Must be >= 0 if specified.
	Offset int32 `protobuf:"varint,10,opt,name=offset" json:"offset,omitempty"`
	// The maximum number of results to return. Applies after all other
	// constraints. Optional.
	// Unspecified is interpreted as no limit.
	// Must be >= 0 if specified.
	Limit *google_protobuf2.Int32Value `protobuf:"bytes,12,opt,name=limit" json:"limit,omitempty"`
}

func (m *Query) Reset()                    { *m = Query{} }
func (m *Query) String() string            { return proto.CompactTextString(m) }
func (*Query) ProtoMessage()               {}
func (*Query) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{1} }

func (m *Query) GetProjection() []*Projection {
	if m != nil {
		return m.Projection
	}
	return nil
}

func (m *Query) GetKind() []*KindExpression {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (m *Query) GetFilter() *Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *Query) GetOrder() []*PropertyOrder {
	if m != nil {
		return m.Order
	}
	return nil
}

func (m *Query) GetDistinctOn() []*PropertyReference {
	if m != nil {
		return m.DistinctOn
	}
	return nil
}

func (m *Query) GetLimit() *google_protobuf2.Int32Value {
	if m != nil {
		return m.Limit
	}
	return nil
}

// A representation of a kind.
type KindExpression struct {
	// The name of the kind.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *KindExpression) Reset()                    { *m = KindExpression{} }
func (m *KindExpression) String() string            { return proto.CompactTextString(m) }
func (*KindExpression) ProtoMessage()               {}
func (*KindExpression) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{2} }

// A reference to a property relative to the kind expressions.
type PropertyReference struct {
	// The name of the property.
	// If name includes "."s, it may be interpreted as a property name path.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
}

func (m *PropertyReference) Reset()                    { *m = PropertyReference{} }
func (m *PropertyReference) String() string            { return proto.CompactTextString(m) }
func (*PropertyReference) ProtoMessage()               {}
func (*PropertyReference) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{3} }

// A representation of a property in a projection.
type Projection struct {
	// The property to project.
	Property *PropertyReference `protobuf:"bytes,1,opt,name=property" json:"property,omitempty"`
}

func (m *Projection) Reset()                    { *m = Projection{} }
func (m *Projection) String() string            { return proto.CompactTextString(m) }
func (*Projection) ProtoMessage()               {}
func (*Projection) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{4} }

func (m *Projection) GetProperty() *PropertyReference {
	if m != nil {
		return m.Property
	}
	return nil
}

// The desired order for a specific property.
type PropertyOrder struct {
	// The property to order by.
	Property *PropertyReference `protobuf:"bytes,1,opt,name=property" json:"property,omitempty"`
	// The direction to order by. Defaults to `ASCENDING`.
	Direction PropertyOrder_Direction `protobuf:"varint,2,opt,name=direction,enum=google.datastore.v1beta3.PropertyOrder_Direction" json:"direction,omitempty"`
}

func (m *PropertyOrder) Reset()                    { *m = PropertyOrder{} }
func (m *PropertyOrder) String() string            { return proto.CompactTextString(m) }
func (*PropertyOrder) ProtoMessage()               {}
func (*PropertyOrder) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{5} }

func (m *PropertyOrder) GetProperty() *PropertyReference {
	if m != nil {
		return m.Property
	}
	return nil
}

// A holder for any type of filter.
type Filter struct {
	// The type of filter.
	//
	// Types that are valid to be assigned to FilterType:
	//	*Filter_CompositeFilter
	//	*Filter_PropertyFilter
	FilterType isFilter_FilterType `protobuf_oneof:"filter_type"`
}

func (m *Filter) Reset()                    { *m = Filter{} }
func (m *Filter) String() string            { return proto.CompactTextString(m) }
func (*Filter) ProtoMessage()               {}
func (*Filter) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{6} }

type isFilter_FilterType interface {
	isFilter_FilterType()
}

type Filter_CompositeFilter struct {
	CompositeFilter *CompositeFilter `protobuf:"bytes,1,opt,name=composite_filter,json=compositeFilter,oneof"`
}
type Filter_PropertyFilter struct {
	PropertyFilter *PropertyFilter `protobuf:"bytes,2,opt,name=property_filter,json=propertyFilter,oneof"`
}

func (*Filter_CompositeFilter) isFilter_FilterType() {}
func (*Filter_PropertyFilter) isFilter_FilterType()  {}

func (m *Filter) GetFilterType() isFilter_FilterType {
	if m != nil {
		return m.FilterType
	}
	return nil
}

func (m *Filter) GetCompositeFilter() *CompositeFilter {
	if x, ok := m.GetFilterType().(*Filter_CompositeFilter); ok {
		return x.CompositeFilter
	}
	return nil
}

func (m *Filter) GetPropertyFilter() *PropertyFilter {
	if x, ok := m.GetFilterType().(*Filter_PropertyFilter); ok {
		return x.PropertyFilter
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Filter) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Filter_OneofMarshaler, _Filter_OneofUnmarshaler, _Filter_OneofSizer, []interface{}{
		(*Filter_CompositeFilter)(nil),
		(*Filter_PropertyFilter)(nil),
	}
}

func _Filter_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Filter)
	// filter_type
	switch x := m.FilterType.(type) {
	case *Filter_CompositeFilter:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CompositeFilter); err != nil {
			return err
		}
	case *Filter_PropertyFilter:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PropertyFilter); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Filter.FilterType has unexpected type %T", x)
	}
	return nil
}

func _Filter_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Filter)
	switch tag {
	case 1: // filter_type.composite_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CompositeFilter)
		err := b.DecodeMessage(msg)
		m.FilterType = &Filter_CompositeFilter{msg}
		return true, err
	case 2: // filter_type.property_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PropertyFilter)
		err := b.DecodeMessage(msg)
		m.FilterType = &Filter_PropertyFilter{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Filter_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Filter)
	// filter_type
	switch x := m.FilterType.(type) {
	case *Filter_CompositeFilter:
		s := proto.Size(x.CompositeFilter)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Filter_PropertyFilter:
		s := proto.Size(x.PropertyFilter)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A filter that merges multiple other filters using the given operator.
type CompositeFilter struct {
	// The operator for combining multiple filters.
	Op CompositeFilter_Operator `protobuf:"varint,1,opt,name=op,enum=google.datastore.v1beta3.CompositeFilter_Operator" json:"op,omitempty"`
	// The list of filters to combine.
	// Must contain at least one filter.
	Filters []*Filter `protobuf:"bytes,2,rep,name=filters" json:"filters,omitempty"`
}

func (m *CompositeFilter) Reset()                    { *m = CompositeFilter{} }
func (m *CompositeFilter) String() string            { return proto.CompactTextString(m) }
func (*CompositeFilter) ProtoMessage()               {}
func (*CompositeFilter) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{7} }

func (m *CompositeFilter) GetFilters() []*Filter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// A filter on a specific property.
type PropertyFilter struct {
	// The property to filter by.
	Property *PropertyReference `protobuf:"bytes,1,opt,name=property" json:"property,omitempty"`
	// The operator to filter by.
	Op PropertyFilter_Operator `protobuf:"varint,2,opt,name=op,enum=google.datastore.v1beta3.PropertyFilter_Operator" json:"op,omitempty"`
	// The value to compare the property to.
	Value *Value `protobuf:"bytes,3,opt,name=value" json:"value,omitempty"`
}

func (m *PropertyFilter) Reset()                    { *m = PropertyFilter{} }
func (m *PropertyFilter) String() string            { return proto.CompactTextString(m) }
func (*PropertyFilter) ProtoMessage()               {}
func (*PropertyFilter) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{8} }

func (m *PropertyFilter) GetProperty() *PropertyReference {
	if m != nil {
		return m.Property
	}
	return nil
}

func (m *PropertyFilter) GetValue() *Value {
	if m != nil {
		return m.Value
	}
	return nil
}

// A [GQL query](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
type GqlQuery struct {
	// A string of the format described
	// [here](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
	QueryString string `protobuf:"bytes,1,opt,name=query_string,json=queryString" json:"query_string,omitempty"`
	// When false, the query string must not contain any literals and instead
	// must bind all values. For example,
	// `SELECT * FROM Kind WHERE a = 'string literal'` is not allowed, while
	// `SELECT * FROM Kind WHERE a = @value` is.
	AllowLiterals bool `protobuf:"varint,2,opt,name=allow_literals,json=allowLiterals" json:"allow_literals,omitempty"`
	// For each non-reserved named binding site in the query string,
	// there must be a named parameter with that name,
	// but not necessarily the inverse.
	// Key must match regex `[A-Za-z_$][A-Za-z_$0-9]*`, must not match regex
	// `__.*__`, and must not be `""`.
	NamedBindings map[string]*GqlQueryParameter `protobuf:"bytes,5,rep,name=named_bindings,json=namedBindings" json:"named_bindings,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Numbered binding site @1 references the first numbered parameter,
	// effectively using 1-based indexing, rather than the usual 0.
	// For each binding site numbered i in `query_string`,
	// there must be an i-th numbered parameter.
	// The inverse must also be true.
	PositionalBindings []*GqlQueryParameter `protobuf:"bytes,4,rep,name=positional_bindings,json=positionalBindings" json:"positional_bindings,omitempty"`
}

func (m *GqlQuery) Reset()                    { *m = GqlQuery{} }
func (m *GqlQuery) String() string            { return proto.CompactTextString(m) }
func (*GqlQuery) ProtoMessage()               {}
func (*GqlQuery) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{9} }

func (m *GqlQuery) GetNamedBindings() map[string]*GqlQueryParameter {
	if m != nil {
		return m.NamedBindings
	}
	return nil
}

func (m *GqlQuery) GetPositionalBindings() []*GqlQueryParameter {
	if m != nil {
		return m.PositionalBindings
	}
	return nil
}

// A binding parameter for a GQL query.
type GqlQueryParameter struct {
	// The type of parameter.
	//
	// Types that are valid to be assigned to ParameterType:
	//	*GqlQueryParameter_Value
	//	*GqlQueryParameter_Cursor
	ParameterType isGqlQueryParameter_ParameterType `protobuf_oneof:"parameter_type"`
}

func (m *GqlQueryParameter) Reset()                    { *m = GqlQueryParameter{} }
func (m *GqlQueryParameter) String() string            { return proto.CompactTextString(m) }
func (*GqlQueryParameter) ProtoMessage()               {}
func (*GqlQueryParameter) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{10} }

type isGqlQueryParameter_ParameterType interface {
	isGqlQueryParameter_ParameterType()
}

type GqlQueryParameter_Value struct {
	Value *Value `protobuf:"bytes,2,opt,name=value,oneof"`
}
type GqlQueryParameter_Cursor struct {
	Cursor []byte `protobuf:"bytes,3,opt,name=cursor,proto3,oneof"`
}

func (*GqlQueryParameter_Value) isGqlQueryParameter_ParameterType()  {}
func (*GqlQueryParameter_Cursor) isGqlQueryParameter_ParameterType() {}

func (m *GqlQueryParameter) GetParameterType() isGqlQueryParameter_ParameterType {
	if m != nil {
		return m.ParameterType
	}
	return nil
}

func (m *GqlQueryParameter) GetValue() *Value {
	if x, ok := m.GetParameterType().(*GqlQueryParameter_Value); ok {
		return x.Value
	}
	return nil
}

func (m *GqlQueryParameter) GetCursor() []byte {
	if x, ok := m.GetParameterType().(*GqlQueryParameter_Cursor); ok {
		return x.Cursor
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*GqlQueryParameter) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _GqlQueryParameter_OneofMarshaler, _GqlQueryParameter_OneofUnmarshaler, _GqlQueryParameter_OneofSizer, []interface{}{
		(*GqlQueryParameter_Value)(nil),
		(*GqlQueryParameter_Cursor)(nil),
	}
}

func _GqlQueryParameter_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*GqlQueryParameter)
	// parameter_type
	switch x := m.ParameterType.(type) {
	case *GqlQueryParameter_Value:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Value); err != nil {
			return err
		}
	case *GqlQueryParameter_Cursor:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Cursor)
	case nil:
	default:
		return fmt.Errorf("GqlQueryParameter.ParameterType has unexpected type %T", x)
	}
	return nil
}

func _GqlQueryParameter_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*GqlQueryParameter)
	switch tag {
	case 2: // parameter_type.value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Value)
		err := b.DecodeMessage(msg)
		m.ParameterType = &GqlQueryParameter_Value{msg}
		return true, err
	case 3: // parameter_type.cursor
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.ParameterType = &GqlQueryParameter_Cursor{x}
		return true, err
	default:
		return false, nil
	}
}

func _GqlQueryParameter_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*GqlQueryParameter)
	// parameter_type
	switch x := m.ParameterType.(type) {
	case *GqlQueryParameter_Value:
		s := proto.Size(x.Value)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GqlQueryParameter_Cursor:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Cursor)))
		n += len(x.Cursor)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A batch of results produced by a query.
type QueryResultBatch struct {
	// The number of results skipped, typically because of an offset.
	SkippedResults int32 `protobuf:"varint,6,opt,name=skipped_results,json=skippedResults" json:"skipped_results,omitempty"`
	// A cursor that points to the position after the last skipped result.
	// Will be set when `skipped_results` != 0.
	SkippedCursor []byte `protobuf:"bytes,3,opt,name=skipped_cursor,json=skippedCursor,proto3" json:"skipped_cursor,omitempty"`
	// The result type for every entity in `entity_results`.
	EntityResultType EntityResult_ResultType `protobuf:"varint,1,opt,name=entity_result_type,json=entityResultType,enum=google.datastore.v1beta3.EntityResult_ResultType" json:"entity_result_type,omitempty"`
	// The results for this batch.
	EntityResults []*EntityResult `protobuf:"bytes,2,rep,name=entity_results,json=entityResults" json:"entity_results,omitempty"`
	// A cursor that points to the position after the last result in the batch.
	EndCursor []byte `protobuf:"bytes,4,opt,name=end_cursor,json=endCursor,proto3" json:"end_cursor,omitempty"`
	// The state of the query after the current batch.
	MoreResults QueryResultBatch_MoreResultsType `protobuf:"varint,5,opt,name=more_results,json=moreResults,enum=google.datastore.v1beta3.QueryResultBatch_MoreResultsType" json:"more_results,omitempty"`
}

func (m *QueryResultBatch) Reset()                    { *m = QueryResultBatch{} }
func (m *QueryResultBatch) String() string            { return proto.CompactTextString(m) }
func (*QueryResultBatch) ProtoMessage()               {}
func (*QueryResultBatch) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{11} }

func (m *QueryResultBatch) GetEntityResults() []*EntityResult {
	if m != nil {
		return m.EntityResults
	}
	return nil
}

func init() {
	proto.RegisterType((*EntityResult)(nil), "google.datastore.v1beta3.EntityResult")
	proto.RegisterType((*Query)(nil), "google.datastore.v1beta3.Query")
	proto.RegisterType((*KindExpression)(nil), "google.datastore.v1beta3.KindExpression")
	proto.RegisterType((*PropertyReference)(nil), "google.datastore.v1beta3.PropertyReference")
	proto.RegisterType((*Projection)(nil), "google.datastore.v1beta3.Projection")
	proto.RegisterType((*PropertyOrder)(nil), "google.datastore.v1beta3.PropertyOrder")
	proto.RegisterType((*Filter)(nil), "google.datastore.v1beta3.Filter")
	proto.RegisterType((*CompositeFilter)(nil), "google.datastore.v1beta3.CompositeFilter")
	proto.RegisterType((*PropertyFilter)(nil), "google.datastore.v1beta3.PropertyFilter")
	proto.RegisterType((*GqlQuery)(nil), "google.datastore.v1beta3.GqlQuery")
	proto.RegisterType((*GqlQueryParameter)(nil), "google.datastore.v1beta3.GqlQueryParameter")
	proto.RegisterType((*QueryResultBatch)(nil), "google.datastore.v1beta3.QueryResultBatch")
	proto.RegisterEnum("google.datastore.v1beta3.EntityResult_ResultType", EntityResult_ResultType_name, EntityResult_ResultType_value)
	proto.RegisterEnum("google.datastore.v1beta3.PropertyOrder_Direction", PropertyOrder_Direction_name, PropertyOrder_Direction_value)
	proto.RegisterEnum("google.datastore.v1beta3.CompositeFilter_Operator", CompositeFilter_Operator_name, CompositeFilter_Operator_value)
	proto.RegisterEnum("google.datastore.v1beta3.PropertyFilter_Operator", PropertyFilter_Operator_name, PropertyFilter_Operator_value)
	proto.RegisterEnum("google.datastore.v1beta3.QueryResultBatch_MoreResultsType", QueryResultBatch_MoreResultsType_name, QueryResultBatch_MoreResultsType_value)
}

func init() {
	proto.RegisterFile("google.golang.org/cloud/datastore/internal/proto/query.proto", fileDescriptor2)
}

var fileDescriptor2 = []byte{
	// 1208 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x56, 0x5d, 0x6e, 0xdb, 0x46,
	0x10, 0x0e, 0xf5, 0xe3, 0x48, 0x23, 0x89, 0x66, 0x36, 0x6d, 0xaa, 0x24, 0x4d, 0xeb, 0x12, 0x69,
	0xed, 0xa2, 0x28, 0x05, 0xcb, 0x08, 0x1a, 0x18, 0xc9, 0x83, 0x7e, 0x68, 0x5b, 0x8d, 0x4c, 0xca,
	0x4b, 0x29, 0x80, 0x81, 0x16, 0x04, 0x2d, 0xd1, 0x2a, 0x6b, 0x8a, 0x54, 0x48, 0x2a, 0x89, 0x0f,
	0x52, 0xa0, 0x77, 0xe8, 0x63, 0x2f, 0xd0, 0x87, 0xde, 0xa3, 0x07, 0xe8, 0x4b, 0x6f, 0xd0, 0x2e,
	0x77, 0x97, 0xfa, 0xb3, 0x55, 0xd9, 0x40, 0xde, 0xc8, 0xd9, 0xef, 0xfb, 0x66, 0x76, 0x76, 0x76,
	0x76, 0xe0, 0xc5, 0xd0, 0xf7, 0x87, 0xae, 0xad, 0x0c, 0x7d, 0xd7, 0xf2, 0x86, 0x8a, 0x1f, 0x0c,
	0x2b, 0x7d, 0xd7, 0x9f, 0x0c, 0x2a, 0x03, 0x2b, 0xb2, 0xc2, 0xc8, 0x0f, 0xec, 0x8a, 0xe3, 0x45,
	0x76, 0xe0, 0x59, 0x6e, 0x65, 0x1c, 0xf8, 0x91, 0x5f, 0x79, 0x33, 0xb1, 0x83, 0x4b, 0x85, 0x7e,
	0xa3, 0x32, 0x67, 0x4f, 0xc1, 0xca, 0xdb, 0xdd, 0x33, 0x3b, 0xb2, 0xf6, 0x1e, 0xbd, 0xbc, 0xb5,
	0xae, 0xed, 0x45, 0x4e, 0xc4, 0x85, 0x1f, 0x7d, 0xc6, 0xe8, 0x6c, 0xe9, 0x6c, 0x72, 0x5e, 0x79,
	0x17, 0x58, 0xe3, 0xb1, 0x1d, 0x84, 0x7c, 0xbd, 0x7e, 0x0b, 0xf9, 0xe8, 0x72, 0x6c, 0x9b, 0xcc,
	0x87, 0x6b, 0x45, 0x2e, 0x81, 0xd3, 0x1f, 0xf9, 0x77, 0x01, 0x8a, 0x2a, 0x75, 0x8a, 0xed, 0x70,
	0xe2, 0x46, 0xe8, 0x39, 0x6c, 0xb0, 0x20, 0xca, 0xc2, 0x96, 0xb0, 0x53, 0xa8, 0x6e, 0x29, 0xab,
	0xb6, 0xa7, 0x70, 0x1e, 0xc7, 0xa3, 0x07, 0xb0, 0xd1, 0x9f, 0x04, 0xa1, 0x1f, 0x94, 0xd3, 0x84,
	0x59, 0xc4, 0xfc, 0x4f, 0x3e, 0x01, 0x60, 0xda, 0x5d, 0x12, 0x03, 0x7a, 0x0c, 0x9f, 0x60, 0xd5,
	0xe8, 0xb5, 0xbb, 0x66, 0xf7, 0xb4, 0xa3, 0x9a, 0x3d, 0xcd, 0xe8, 0xa8, 0x8d, 0xd6, 0x41, 0x4b,
	0x6d, 0x4a, 0x77, 0x50, 0x0e, 0x32, 0x07, 0xbd, 0x76, 0x5b, 0x12, 0x90, 0x08, 0xd0, 0xc1, 0xfa,
	0xf7, 0x6a, 0xa3, 0xdb, 0xd2, 0x35, 0x29, 0x85, 0x8a, 0x90, 0x7b, 0xa5, 0x9e, 0x9a, 0xba, 0xd6,
	0x3e, 0x95, 0xd2, 0xf2, 0x5f, 0x69, 0xc8, 0x9e, 0xc4, 0x47, 0x80, 0x9a, 0x00, 0x64, 0x23, 0x3f,
	0xdb, 0xfd, 0xc8, 0xf1, 0xbd, 0x72, 0x6a, 0x2b, 0x4d, 0x42, 0x7e, 0xba, 0x3a, 0xe4, 0xce, 0x14,
	0x8b, 0xe7, 0x78, 0xe8, 0x05, 0x64, 0x2e, 0x1c, 0x6f, 0x40, 0x02, 0x8f, 0xf9, 0x3b, 0xab, 0xf9,
	0xaf, 0x08, 0x4a, 0x7d, 0x3f, 0x0e, 0xec, 0x30, 0x8c, 0x35, 0x28, 0x2b, 0x4e, 0xd9, 0xb9, 0xe3,
	0x92, 0x44, 0x97, 0x33, 0xeb, 0x52, 0x76, 0x40, 0x71, 0x98, 0xe3, 0xd1, 0x4b, 0xc8, 0xfa, 0xc1,
	0x80, 0x10, 0xb3, 0xd4, 0xf1, 0xf6, 0xff, 0x06, 0x4e, 0x4e, 0x3e, 0xba, 0xd4, 0x63, 0x38, 0x66,
	0x2c, 0xd4, 0x86, 0xc2, 0xc0, 0x09, 0x23, 0xc7, 0xeb, 0x47, 0x26, 0xd9, 0xfd, 0x06, 0x15, 0xf9,
	0x66, 0xbd, 0x08, 0xb6, 0xcf, 0xed, 0xc0, 0xf6, 0xfa, 0x36, 0x86, 0x84, 0xaf, 0x7b, 0xe8, 0x0b,
	0x28, 0x86, 0x91, 0x15, 0x44, 0x26, 0x3f, 0xc5, 0xbb, 0xf4, 0x14, 0x0b, 0xd4, 0xd6, 0xa0, 0x26,
	0xf4, 0x04, 0xc0, 0xf6, 0x06, 0x09, 0x20, 0x47, 0x01, 0x79, 0x62, 0xe1, 0xcb, 0xa4, 0x02, 0xfc,
	0xf3, 0xf3, 0xd0, 0x8e, 0xca, 0x40, 0x96, 0xb2, 0x98, 0xff, 0xa1, 0x5d, 0xc8, 0xba, 0xce, 0xc8,
	0x89, 0xca, 0x45, 0x9a, 0x9f, 0xc7, 0x49, 0x84, 0x49, 0x61, 0x2b, 0x2d, 0x2f, 0xda, 0xab, 0xbe,
	0xb6, 0xdc, 0x89, 0x8d, 0x19, 0x52, 0x7e, 0x0a, 0xe2, 0x62, 0xae, 0x11, 0x82, 0x8c, 0x67, 0x8d,
	0x6c, 0x5a, 0x96, 0x79, 0x4c, 0xbf, 0xe5, 0x6d, 0xb8, 0x77, 0x65, 0x4f, 0x53, 0x60, 0x6a, 0x0e,
	0xd8, 0x23, 0xe5, 0x34, 0x3b, 0xee, 0x43, 0xc8, 0x8d, 0x39, 0x8d, 0x57, 0xf9, 0xad, 0x92, 0x36,
	0x25, 0xcb, 0xff, 0x08, 0x50, 0x5a, 0x38, 0x99, 0x0f, 0x26, 0x8d, 0x74, 0xc8, 0x0f, 0x9c, 0x60,
	0x5a, 0xd7, 0xc2, 0x8e, 0x58, 0xdd, 0xbd, 0x61, 0x79, 0x28, 0xcd, 0x84, 0x88, 0x67, 0x1a, 0xb2,
	0x0a, 0xf9, 0xa9, 0x1d, 0x3d, 0x84, 0x8f, 0x9b, 0x2d, 0xcc, 0x6e, 0xd7, 0xd2, 0x1d, 0x2c, 0x41,
	0xbe, 0x66, 0x34, 0x54, 0xad, 0xd9, 0xd2, 0x0e, 0xd9, 0x45, 0x6c, 0xaa, 0xd3, 0xff, 0x94, 0xfc,
	0xa7, 0x00, 0x1b, 0xac, 0x8a, 0xd1, 0x6b, 0x90, 0xfa, 0xfe, 0x68, 0xec, 0x87, 0x4e, 0x64, 0x9b,
	0xfc, 0x06, 0xb0, 0x3d, 0x7f, 0xbd, 0x3a, 0xd2, 0x46, 0xc2, 0x60, 0x22, 0x47, 0x77, 0xf0, 0x66,
	0x7f, 0xd1, 0x84, 0x0c, 0xd8, 0x4c, 0xd2, 0x90, 0xc8, 0xa6, 0xa8, 0xec, 0xce, 0xfa, 0x04, 0x4c,
	0x55, 0xc5, 0xf1, 0x82, 0xa5, 0x5e, 0x82, 0x02, 0xd3, 0x32, 0xe3, 0x56, 0x28, 0xff, 0x21, 0xc0,
	0xe6, 0x52, 0x28, 0xa8, 0x0e, 0x29, 0x7f, 0x4c, 0x77, 0x20, 0x56, 0xab, 0x37, 0xde, 0x81, 0xa2,
	0x13, 0x37, 0x16, 0x41, 0x60, 0xc2, 0x46, 0xfb, 0x70, 0x97, 0xb9, 0x09, 0x79, 0x33, 0x5a, 0xdf,
	0x0c, 0x12, 0x82, 0xfc, 0x2d, 0xe4, 0x12, 0x2d, 0x54, 0x86, 0x8f, 0xf4, 0x8e, 0x8a, 0x6b, 0x5d,
	0x1d, 0x2f, 0x9d, 0xcf, 0x5d, 0x48, 0xd7, 0xb4, 0xa6, 0x24, 0xc8, 0x7f, 0xa7, 0x40, 0x5c, 0xdc,
	0xf6, 0x87, 0xab, 0xbe, 0x1a, 0x4d, 0xc5, 0x8d, 0xcb, 0xee, 0xba, 0x4c, 0x3c, 0x83, 0xec, 0xdb,
	0xf8, 0x46, 0xd3, 0xd7, 0xa0, 0x50, 0xfd, 0x7c, 0xb5, 0x0a, 0xbf, 0xf8, 0x14, 0x2d, 0xff, 0x22,
	0xdc, 0x28, 0x0b, 0xa4, 0x4a, 0xdb, 0xaa, 0x61, 0x98, 0xdd, 0xa3, 0x9a, 0x46, 0xaa, 0xf4, 0x01,
	0xa0, 0xe9, 0xaf, 0x49, 0xc0, 0xea, 0x49, 0xaf, 0xd6, 0x26, 0xcf, 0x86, 0x04, 0xc5, 0x43, 0xac,
	0xd6, 0xba, 0x2a, 0x66, 0xc8, 0x74, 0x5c, 0xf9, 0xf3, 0x96, 0x19, 0x38, 0x83, 0xf2, 0x90, 0x65,
	0x9f, 0xd9, 0x98, 0x77, 0x54, 0x33, 0xcc, 0x9a, 0xd6, 0x50, 0x0d, 0xe2, 0x5c, 0x2a, 0xc8, 0xff,
	0xa6, 0x20, 0x77, 0xf8, 0xc6, 0x65, 0xaf, 0x0e, 0x69, 0x95, 0x74, 0x02, 0x30, 0xc3, 0x28, 0x70,
	0xbc, 0x21, 0xef, 0x49, 0x05, 0x6a, 0x33, 0xa8, 0x09, 0x7d, 0x09, 0xa2, 0xe5, 0xba, 0xfe, 0x3b,
	0xd3, 0x25, 0x95, 0x12, 0x58, 0x6e, 0x48, 0xb3, 0x99, 0xc3, 0x25, 0x6a, 0x6d, 0x73, 0x23, 0xfa,
	0x01, 0xc4, 0xb8, 0x41, 0x0d, 0xcc, 0x33, 0xd2, 0xed, 0x08, 0x2f, 0xe4, 0x4f, 0xc1, 0xb3, 0xd5,
	0xe9, 0x4a, 0xa2, 0x50, 0xb4, 0x98, 0x58, 0xe7, 0x3c, 0xf2, 0x18, 0x07, 0x97, 0xb8, 0xe4, 0xcd,
	0xdb, 0x88, 0xfa, 0x7d, 0x5a, 0xaa, 0xe4, 0xca, 0x5b, 0xee, 0xcc, 0x45, 0x66, 0xdd, 0x43, 0x91,
	0xb8, 0xe8, 0x58, 0x01, 0xd1, 0x8b, 0x8b, 0x14, 0xcd, 0x74, 0x12, 0xf5, 0x47, 0x23, 0x40, 0x57,
	0x43, 0x20, 0xa9, 0x4b, 0x5f, 0xd8, 0x97, 0x3c, 0x25, 0xf1, 0x27, 0x29, 0x26, 0x5e, 0x09, 0xa9,
	0x75, 0x25, 0x79, 0xd5, 0x2f, 0x63, 0xee, 0xa7, 0x9e, 0x0b, 0xf2, 0x7b, 0xb8, 0x77, 0x65, 0x1d,
	0x7d, 0xb7, 0xa8, 0xbd, 0xae, 0xca, 0x48, 0x63, 0x60, 0x78, 0x52, 0x5a, 0x0b, 0xd3, 0x0a, 0x59,
	0xe0, 0xff, 0x75, 0x09, 0xc4, 0x71, 0xa2, 0xcf, 0x9a, 0xc5, 0x6f, 0x19, 0x90, 0xa8, 0x5f, 0x36,
	0xc7, 0xd4, 0xad, 0xa8, 0xff, 0x13, 0xda, 0x86, 0xcd, 0xf0, 0xc2, 0x21, 0xf3, 0xd8, 0xc0, 0x0c,
	0xa8, 0x39, 0x24, 0x0f, 0x70, 0xfc, 0xea, 0x89, 0xdc, 0xcc, 0xc0, 0x61, 0x5c, 0x09, 0x09, 0x70,
	0x61, 0x3e, 0x2a, 0x71, 0x2b, 0x7f, 0x3c, 0x4d, 0x40, 0x6c, 0x90, 0xe2, 0x72, 0xd4, 0x35, 0xef,
	0x46, 0xbb, 0x6b, 0x87, 0x30, 0x4a, 0x51, 0x66, 0x73, 0x16, 0x96, 0xec, 0xb9, 0x05, 0x3a, 0x79,
	0x1d, 0x83, 0xb8, 0xe0, 0x20, 0xe9, 0x50, 0x5f, 0xdd, 0x4c, 0x1c, 0x97, 0xe6, 0x15, 0xc3, 0xa5,
	0x59, 0x20, 0xb3, 0x3c, 0x0b, 0xfc, 0x08, 0xc5, 0x11, 0x91, 0x9a, 0xfa, 0xca, 0xd2, 0x8d, 0xec,
	0xaf, 0xf6, 0xb5, 0x9c, 0x60, 0xe5, 0x98, 0xac, 0x72, 0x67, 0x74, 0x47, 0x85, 0xd1, 0xcc, 0x20,
	0xff, 0x4a, 0xfa, 0xf7, 0x12, 0x80, 0xdc, 0xca, 0x27, 0xc7, 0x3a, 0x56, 0x4d, 0x36, 0x5f, 0x1a,
	0xd7, 0x0d, 0x98, 0xe4, 0x5e, 0x6b, 0x7a, 0xd7, 0x3c, 0x68, 0x69, 0x2d, 0xe3, 0x88, 0x58, 0x04,
	0xf4, 0x29, 0x94, 0x17, 0x48, 0xb5, 0x83, 0xb8, 0x35, 0xb4, 0x5b, 0xc7, 0xad, 0x2e, 0xe9, 0x1f,
	0x4f, 0xe0, 0xe1, 0x35, 0xab, 0x8d, 0x1e, 0x36, 0x48, 0x53, 0xc8, 0xa0, 0xfb, 0xb0, 0xa9, 0xe9,
	0xe6, 0x3c, 0x42, 0x4a, 0x9f, 0x6d, 0xd0, 0xb1, 0x66, 0xef, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xee, 0x2d, 0x21, 0x6f, 0x56, 0x0c, 0x00, 0x00,
}
