// Code generated by protoc-gen-go.
// source: google.golang.org/cloud/bigtable/internal/table_service_proto/bigtable_table_service_messages.proto
// DO NOT EDIT!

/*
Package google_bigtable_admin_table_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/cloud/bigtable/internal/table_service_proto/bigtable_table_service_messages.proto
	google.golang.org/cloud/bigtable/internal/table_service_proto/bigtable_table_service.proto

It has these top-level messages:
	CreateTableRequest
	ListTablesRequest
	ListTablesResponse
	GetTableRequest
	DeleteTableRequest
	RenameTableRequest
	CreateColumnFamilyRequest
	DeleteColumnFamilyRequest
	BulkDeleteRowsRequest
*/
package google_bigtable_admin_table_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_bigtable_admin_table_v11 "google.golang.org/cloud/bigtable/internal/table_data_proto"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type CreateTableRequest struct {
	// The unique name of the cluster in which to create the new table.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name by which the new table should be referred to within the cluster,
	// e.g. "foobar" rather than "<cluster_name>/tables/foobar".
	TableId string `protobuf:"bytes,2,opt,name=table_id,json=tableId" json:"table_id,omitempty"`
	// The Table to create. The `name` field of the Table and all of its
	// ColumnFamilies must be left blank, and will be populated in the response.
	Table *google_bigtable_admin_table_v11.Table `protobuf:"bytes,3,opt,name=table" json:"table,omitempty"`
	// The optional list of row keys that will be used to initially split the
	// table into several tablets (Tablets are similar to HBase regions).
	// Given two split keys, "s1" and "s2", three tablets will be created,
	// spanning the key ranges: [, s1), [s1, s2), [s2, ).
	//
	// Example:
	//  * Row keys := ["a", "apple", "custom", "customer_1", "customer_2",
	//                 "other", "zz"]
	//  * initial_split_keys := ["apple", "customer_1", "customer_2", "other"]
	//  * Key assignment:
	//    - Tablet 1 [, apple)                => {"a"}.
	//    - Tablet 2 [apple, customer_1)      => {"apple", "custom"}.
	//    - Tablet 3 [customer_1, customer_2) => {"customer_1"}.
	//    - Tablet 4 [customer_2, other)      => {"customer_2"}.
	//    - Tablet 5 [other, )                => {"other", "zz"}.
	InitialSplitKeys []string `protobuf:"bytes,4,rep,name=initial_split_keys,json=initialSplitKeys" json:"initial_split_keys,omitempty"`
}

func (m *CreateTableRequest) Reset()                    { *m = CreateTableRequest{} }
func (m *CreateTableRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateTableRequest) ProtoMessage()               {}
func (*CreateTableRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *CreateTableRequest) GetTable() *google_bigtable_admin_table_v11.Table {
	if m != nil {
		return m.Table
	}
	return nil
}

type ListTablesRequest struct {
	// The unique name of the cluster for which tables should be listed.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *ListTablesRequest) Reset()                    { *m = ListTablesRequest{} }
func (m *ListTablesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTablesRequest) ProtoMessage()               {}
func (*ListTablesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type ListTablesResponse struct {
	// The tables present in the requested cluster.
	// At present, only the names of the tables are populated.
	Tables []*google_bigtable_admin_table_v11.Table `protobuf:"bytes,1,rep,name=tables" json:"tables,omitempty"`
}

func (m *ListTablesResponse) Reset()                    { *m = ListTablesResponse{} }
func (m *ListTablesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTablesResponse) ProtoMessage()               {}
func (*ListTablesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ListTablesResponse) GetTables() []*google_bigtable_admin_table_v11.Table {
	if m != nil {
		return m.Tables
	}
	return nil
}

type GetTableRequest struct {
	// The unique name of the requested table.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetTableRequest) Reset()                    { *m = GetTableRequest{} }
func (m *GetTableRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTableRequest) ProtoMessage()               {}
func (*GetTableRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type DeleteTableRequest struct {
	// The unique name of the table to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteTableRequest) Reset()                    { *m = DeleteTableRequest{} }
func (m *DeleteTableRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteTableRequest) ProtoMessage()               {}
func (*DeleteTableRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

type RenameTableRequest struct {
	// The current unique name of the table.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The new name by which the table should be referred to within its containing
	// cluster, e.g. "foobar" rather than "<cluster_name>/tables/foobar".
	NewId string `protobuf:"bytes,2,opt,name=new_id,json=newId" json:"new_id,omitempty"`
}

func (m *RenameTableRequest) Reset()                    { *m = RenameTableRequest{} }
func (m *RenameTableRequest) String() string            { return proto.CompactTextString(m) }
func (*RenameTableRequest) ProtoMessage()               {}
func (*RenameTableRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type CreateColumnFamilyRequest struct {
	// The unique name of the table in which to create the new column family.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name by which the new column family should be referred to within the
	// table, e.g. "foobar" rather than "<table_name>/columnFamilies/foobar".
	ColumnFamilyId string `protobuf:"bytes,2,opt,name=column_family_id,json=columnFamilyId" json:"column_family_id,omitempty"`
	// The column family to create. The `name` field must be left blank.
	ColumnFamily *google_bigtable_admin_table_v11.ColumnFamily `protobuf:"bytes,3,opt,name=column_family,json=columnFamily" json:"column_family,omitempty"`
}

func (m *CreateColumnFamilyRequest) Reset()                    { *m = CreateColumnFamilyRequest{} }
func (m *CreateColumnFamilyRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateColumnFamilyRequest) ProtoMessage()               {}
func (*CreateColumnFamilyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *CreateColumnFamilyRequest) GetColumnFamily() *google_bigtable_admin_table_v11.ColumnFamily {
	if m != nil {
		return m.ColumnFamily
	}
	return nil
}

type DeleteColumnFamilyRequest struct {
	// The unique name of the column family to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteColumnFamilyRequest) Reset()                    { *m = DeleteColumnFamilyRequest{} }
func (m *DeleteColumnFamilyRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteColumnFamilyRequest) ProtoMessage()               {}
func (*DeleteColumnFamilyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type BulkDeleteRowsRequest struct {
	// The unique name of the table on which to perform the bulk delete
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName" json:"table_name,omitempty"`
	// Types that are valid to be assigned to Target:
	//	*BulkDeleteRowsRequest_RowKeyPrefix
	//	*BulkDeleteRowsRequest_DeleteAllDataFromTable
	Target isBulkDeleteRowsRequest_Target `protobuf_oneof:"target"`
}

func (m *BulkDeleteRowsRequest) Reset()                    { *m = BulkDeleteRowsRequest{} }
func (m *BulkDeleteRowsRequest) String() string            { return proto.CompactTextString(m) }
func (*BulkDeleteRowsRequest) ProtoMessage()               {}
func (*BulkDeleteRowsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

type isBulkDeleteRowsRequest_Target interface {
	isBulkDeleteRowsRequest_Target()
}

type BulkDeleteRowsRequest_RowKeyPrefix struct {
	RowKeyPrefix []byte `protobuf:"bytes,2,opt,name=row_key_prefix,json=rowKeyPrefix,proto3,oneof"`
}
type BulkDeleteRowsRequest_DeleteAllDataFromTable struct {
	DeleteAllDataFromTable bool `protobuf:"varint,3,opt,name=delete_all_data_from_table,json=deleteAllDataFromTable,oneof"`
}

func (*BulkDeleteRowsRequest_RowKeyPrefix) isBulkDeleteRowsRequest_Target()           {}
func (*BulkDeleteRowsRequest_DeleteAllDataFromTable) isBulkDeleteRowsRequest_Target() {}

func (m *BulkDeleteRowsRequest) GetTarget() isBulkDeleteRowsRequest_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *BulkDeleteRowsRequest) GetRowKeyPrefix() []byte {
	if x, ok := m.GetTarget().(*BulkDeleteRowsRequest_RowKeyPrefix); ok {
		return x.RowKeyPrefix
	}
	return nil
}

func (m *BulkDeleteRowsRequest) GetDeleteAllDataFromTable() bool {
	if x, ok := m.GetTarget().(*BulkDeleteRowsRequest_DeleteAllDataFromTable); ok {
		return x.DeleteAllDataFromTable
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*BulkDeleteRowsRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _BulkDeleteRowsRequest_OneofMarshaler, _BulkDeleteRowsRequest_OneofUnmarshaler, _BulkDeleteRowsRequest_OneofSizer, []interface{}{
		(*BulkDeleteRowsRequest_RowKeyPrefix)(nil),
		(*BulkDeleteRowsRequest_DeleteAllDataFromTable)(nil),
	}
}

func _BulkDeleteRowsRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*BulkDeleteRowsRequest)
	// target
	switch x := m.Target.(type) {
	case *BulkDeleteRowsRequest_RowKeyPrefix:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.RowKeyPrefix)
	case *BulkDeleteRowsRequest_DeleteAllDataFromTable:
		t := uint64(0)
		if x.DeleteAllDataFromTable {
			t = 1
		}
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("BulkDeleteRowsRequest.Target has unexpected type %T", x)
	}
	return nil
}

func _BulkDeleteRowsRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*BulkDeleteRowsRequest)
	switch tag {
	case 2: // target.row_key_prefix
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Target = &BulkDeleteRowsRequest_RowKeyPrefix{x}
		return true, err
	case 3: // target.delete_all_data_from_table
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Target = &BulkDeleteRowsRequest_DeleteAllDataFromTable{x != 0}
		return true, err
	default:
		return false, nil
	}
}

func _BulkDeleteRowsRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*BulkDeleteRowsRequest)
	// target
	switch x := m.Target.(type) {
	case *BulkDeleteRowsRequest_RowKeyPrefix:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.RowKeyPrefix)))
		n += len(x.RowKeyPrefix)
	case *BulkDeleteRowsRequest_DeleteAllDataFromTable:
		n += proto.SizeVarint(3<<3 | proto.WireVarint)
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*CreateTableRequest)(nil), "google.bigtable.admin.table.v1.CreateTableRequest")
	proto.RegisterType((*ListTablesRequest)(nil), "google.bigtable.admin.table.v1.ListTablesRequest")
	proto.RegisterType((*ListTablesResponse)(nil), "google.bigtable.admin.table.v1.ListTablesResponse")
	proto.RegisterType((*GetTableRequest)(nil), "google.bigtable.admin.table.v1.GetTableRequest")
	proto.RegisterType((*DeleteTableRequest)(nil), "google.bigtable.admin.table.v1.DeleteTableRequest")
	proto.RegisterType((*RenameTableRequest)(nil), "google.bigtable.admin.table.v1.RenameTableRequest")
	proto.RegisterType((*CreateColumnFamilyRequest)(nil), "google.bigtable.admin.table.v1.CreateColumnFamilyRequest")
	proto.RegisterType((*DeleteColumnFamilyRequest)(nil), "google.bigtable.admin.table.v1.DeleteColumnFamilyRequest")
	proto.RegisterType((*BulkDeleteRowsRequest)(nil), "google.bigtable.admin.table.v1.BulkDeleteRowsRequest")
}

func init() {
	proto.RegisterFile("google.golang.org/cloud/bigtable/internal/table_service_proto/bigtable_table_service_messages.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 499 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x94, 0x54, 0xdf, 0x6f, 0xd3, 0x30,
	0x10, 0x26, 0x74, 0x2b, 0xdd, 0x51, 0xc6, 0xb0, 0x34, 0xd4, 0x4e, 0x02, 0x0d, 0x4b, 0x83, 0x3e,
	0x4c, 0x89, 0x80, 0x47, 0x40, 0x88, 0x6c, 0x1a, 0x54, 0xfc, 0x50, 0x49, 0xf7, 0x1e, 0xb9, 0xc9,
	0x35, 0xb2, 0xe6, 0xc4, 0x25, 0x76, 0x57, 0xf6, 0x0f, 0xf1, 0x84, 0xf8, 0x1b, 0x71, 0xec, 0xb0,
	0xb6, 0x12, 0x6a, 0xb6, 0x37, 0xfb, 0xee, 0xfb, 0xee, 0xce, 0xdf, 0xdd, 0x19, 0x92, 0x4c, 0xca,
	0x4c, 0xa0, 0x9f, 0x49, 0xc1, 0x8a, 0xcc, 0x97, 0x65, 0x16, 0x24, 0x42, 0xce, 0xd3, 0x60, 0xc2,
	0x33, 0xcd, 0x26, 0x02, 0x03, 0x5e, 0x68, 0x2c, 0x0b, 0x26, 0x02, 0x7b, 0x8d, 0x15, 0x96, 0x97,
	0x3c, 0xc1, 0x78, 0x56, 0x4a, 0x2d, 0xaf, 0x51, 0xf1, 0xba, 0x33, 0x47, 0xa5, 0x58, 0x86, 0xca,
	0xb7, 0x28, 0xf2, 0xb4, 0x4e, 0xf2, 0x0f, 0xed, 0xb3, 0x34, 0xe7, 0x85, 0xef, 0xce, 0x97, 0x2f,
	0x0f, 0xce, 0x6f, 0x5b, 0x44, 0xca, 0x34, 0xfb, 0x7f, 0x05, 0x95, 0xc7, 0x65, 0xa5, 0x7f, 0x3c,
	0x20, 0x27, 0x25, 0x32, 0x8d, 0xe7, 0x95, 0x2b, 0xc2, 0x1f, 0x73, 0x54, 0x9a, 0x10, 0xd8, 0x2a,
	0x58, 0x8e, 0x3d, 0xef, 0xd0, 0x1b, 0xec, 0x44, 0xf6, 0x4c, 0xfa, 0xd0, 0x71, 0x74, 0x9e, 0xf6,
	0xee, 0x5a, 0xfb, 0x3d, 0x7b, 0x1f, 0xa6, 0xe4, 0x0d, 0x6c, 0xdb, 0x63, 0xaf, 0x65, 0xec, 0xf7,
	0x5f, 0x1d, 0xf9, 0x9b, 0xdf, 0xe2, 0xbb, 0x5c, 0x8e, 0x43, 0x8e, 0x81, 0xf0, 0x82, 0x6b, 0xce,
	0x44, 0xac, 0x66, 0x82, 0xeb, 0xf8, 0x02, 0xaf, 0x54, 0x6f, 0xeb, 0xb0, 0x65, 0x32, 0xec, 0xd5,
	0x9e, 0x71, 0xe5, 0xf8, 0x6c, 0xec, 0xf4, 0x05, 0x3c, 0xfa, 0xc2, 0x95, 0xb6, 0x11, 0xd4, 0x86,
	0x72, 0xe9, 0x18, 0xc8, 0x2a, 0x50, 0xcd, 0x64, 0xa1, 0x90, 0xbc, 0x83, 0xb6, 0xcd, 0xaa, 0x0c,
	0xb6, 0x75, 0xf3, 0x52, 0x6b, 0x12, 0x3d, 0x82, 0x87, 0x1f, 0x51, 0x37, 0x49, 0x45, 0x07, 0x40,
	0x4e, 0x51, 0x60, 0xb3, 0xa8, 0xf4, 0x3d, 0x90, 0x08, 0xab, 0x53, 0xa3, 0xfc, 0xfb, 0xd0, 0x2e,
	0x70, 0xb1, 0x14, 0x7f, 0xdb, 0xdc, 0x86, 0x29, 0xfd, 0xed, 0x41, 0xdf, 0x35, 0xf0, 0x44, 0x8a,
	0x79, 0x5e, 0x9c, 0xb1, 0x9c, 0x8b, 0xab, 0x4d, 0x81, 0x06, 0xb0, 0x97, 0x58, 0x68, 0x3c, 0xb5,
	0xd8, 0x65, 0xc8, 0xdd, 0x64, 0x25, 0x84, 0x69, 0xeb, 0x77, 0x78, 0xb0, 0x86, 0xac, 0xdb, 0x7b,
	0xdc, 0xa4, 0xd9, 0x5a, 0x25, 0xdd, 0xd5, 0xa0, 0x34, 0x80, 0xbe, 0x53, 0xe6, 0x86, 0xd5, 0xd2,
	0x5f, 0x1e, 0xec, 0x87, 0x73, 0x71, 0xe1, 0x58, 0x91, 0x5c, 0x5c, 0x37, 0xfd, 0x09, 0x80, 0x9b,
	0xc7, 0x15, 0xce, 0x8e, 0xb5, 0x7c, 0xab, 0x9e, 0xf9, 0x1c, 0x76, 0x4b, 0xb9, 0xa8, 0x86, 0xc9,
	0x2c, 0x01, 0x4e, 0xf9, 0x4f, 0xfb, 0xc8, 0xee, 0xa7, 0x3b, 0x51, 0xd7, 0xd8, 0xcd, 0x2c, 0x8d,
	0xac, 0x95, 0xbc, 0x85, 0x83, 0xd4, 0xc6, 0x8e, 0x99, 0x10, 0x6e, 0x69, 0xa6, 0xa5, 0xcc, 0xe3,
	0xe5, 0x40, 0x77, 0x0c, 0xe7, 0xb1, 0xc3, 0x7c, 0x10, 0xe2, 0xd4, 0x20, 0xce, 0x0c, 0xc0, 0x36,
	0x2c, 0xec, 0x54, 0xf3, 0x54, 0x66, 0xa8, 0xc3, 0x21, 0xd0, 0x44, 0xe6, 0x0d, 0xd2, 0x84, 0xcf,
	0xc2, 0xda, 0x61, 0xe9, 0x63, 0xf7, 0x15, 0x7c, 0xad, 0x7f, 0x82, 0x51, 0xb5, 0x92, 0x23, 0x6f,
	0xd2, 0xb6, 0xbb, 0xf9, 0xfa, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa1, 0x16, 0xdf, 0x02, 0x78,
	0x04, 0x00, 0x00,
}
