// Code generated by protoc-gen-go.
// source: google.golang.org/cloud/bigtable/internal/service_proto/bigtable_service_messages.proto
// DO NOT EDIT!

/*
Package google_bigtable_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/cloud/bigtable/internal/service_proto/bigtable_service_messages.proto
	google.golang.org/cloud/bigtable/internal/service_proto/bigtable_service.proto

It has these top-level messages:
	ReadRowsRequest
	ReadRowsResponse
	SampleRowKeysRequest
	SampleRowKeysResponse
	MutateRowRequest
	MutateRowsRequest
	MutateRowsResponse
	CheckAndMutateRowRequest
	CheckAndMutateRowResponse
	ReadModifyWriteRowRequest
*/
package google_bigtable_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_bigtable_v11 "google.golang.org/cloud/bigtable/internal/data_proto"
import google_rpc "google.golang.org/cloud/bigtable/internal/rpc_status_proto"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for BigtableServer.ReadRows.
type ReadRowsRequest struct {
	// The unique name of the table from which to read.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName" json:"table_name,omitempty"`
	// If neither row_key nor row_range is set, reads from all rows.
	//
	// Types that are valid to be assigned to Target:
	//	*ReadRowsRequest_RowKey
	//	*ReadRowsRequest_RowRange
	//	*ReadRowsRequest_RowSet
	Target isReadRowsRequest_Target `protobuf_oneof:"target"`
	// The filter to apply to the contents of the specified row(s). If unset,
	// reads the entire table.
	Filter *google_bigtable_v11.RowFilter `protobuf:"bytes,5,opt,name=filter" json:"filter,omitempty"`
	// By default, rows are read sequentially, producing results which are
	// guaranteed to arrive in increasing row order. Setting
	// "allow_row_interleaving" to true allows multiple rows to be interleaved in
	// the response stream, which increases throughput but breaks this guarantee,
	// and may force the client to use more memory to buffer partially-received
	// rows. Cannot be set to true when specifying "num_rows_limit".
	AllowRowInterleaving bool `protobuf:"varint,6,opt,name=allow_row_interleaving,json=allowRowInterleaving" json:"allow_row_interleaving,omitempty"`
	// The read will terminate after committing to N rows' worth of results. The
	// default (zero) is to return all results.
	// Note that "allow_row_interleaving" cannot be set to true when this is set.
	NumRowsLimit int64 `protobuf:"varint,7,opt,name=num_rows_limit,json=numRowsLimit" json:"num_rows_limit,omitempty"`
}

func (m *ReadRowsRequest) Reset()                    { *m = ReadRowsRequest{} }
func (m *ReadRowsRequest) String() string            { return proto.CompactTextString(m) }
func (*ReadRowsRequest) ProtoMessage()               {}
func (*ReadRowsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type isReadRowsRequest_Target interface {
	isReadRowsRequest_Target()
}

type ReadRowsRequest_RowKey struct {
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3,oneof"`
}
type ReadRowsRequest_RowRange struct {
	RowRange *google_bigtable_v11.RowRange `protobuf:"bytes,3,opt,name=row_range,json=rowRange,oneof"`
}
type ReadRowsRequest_RowSet struct {
	RowSet *google_bigtable_v11.RowSet `protobuf:"bytes,8,opt,name=row_set,json=rowSet,oneof"`
}

func (*ReadRowsRequest_RowKey) isReadRowsRequest_Target()   {}
func (*ReadRowsRequest_RowRange) isReadRowsRequest_Target() {}
func (*ReadRowsRequest_RowSet) isReadRowsRequest_Target()   {}

func (m *ReadRowsRequest) GetTarget() isReadRowsRequest_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ReadRowsRequest) GetRowKey() []byte {
	if x, ok := m.GetTarget().(*ReadRowsRequest_RowKey); ok {
		return x.RowKey
	}
	return nil
}

func (m *ReadRowsRequest) GetRowRange() *google_bigtable_v11.RowRange {
	if x, ok := m.GetTarget().(*ReadRowsRequest_RowRange); ok {
		return x.RowRange
	}
	return nil
}

func (m *ReadRowsRequest) GetRowSet() *google_bigtable_v11.RowSet {
	if x, ok := m.GetTarget().(*ReadRowsRequest_RowSet); ok {
		return x.RowSet
	}
	return nil
}

func (m *ReadRowsRequest) GetFilter() *google_bigtable_v11.RowFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ReadRowsRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ReadRowsRequest_OneofMarshaler, _ReadRowsRequest_OneofUnmarshaler, _ReadRowsRequest_OneofSizer, []interface{}{
		(*ReadRowsRequest_RowKey)(nil),
		(*ReadRowsRequest_RowRange)(nil),
		(*ReadRowsRequest_RowSet)(nil),
	}
}

func _ReadRowsRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ReadRowsRequest)
	// target
	switch x := m.Target.(type) {
	case *ReadRowsRequest_RowKey:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.RowKey)
	case *ReadRowsRequest_RowRange:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RowRange); err != nil {
			return err
		}
	case *ReadRowsRequest_RowSet:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RowSet); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ReadRowsRequest.Target has unexpected type %T", x)
	}
	return nil
}

func _ReadRowsRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ReadRowsRequest)
	switch tag {
	case 2: // target.row_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Target = &ReadRowsRequest_RowKey{x}
		return true, err
	case 3: // target.row_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_bigtable_v11.RowRange)
		err := b.DecodeMessage(msg)
		m.Target = &ReadRowsRequest_RowRange{msg}
		return true, err
	case 8: // target.row_set
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_bigtable_v11.RowSet)
		err := b.DecodeMessage(msg)
		m.Target = &ReadRowsRequest_RowSet{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ReadRowsRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ReadRowsRequest)
	// target
	switch x := m.Target.(type) {
	case *ReadRowsRequest_RowKey:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.RowKey)))
		n += len(x.RowKey)
	case *ReadRowsRequest_RowRange:
		s := proto.Size(x.RowRange)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ReadRowsRequest_RowSet:
		s := proto.Size(x.RowSet)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for BigtableService.ReadRows.
type ReadRowsResponse struct {
	// The key of the row for which we're receiving data.
	// Results will be received in increasing row key order, unless
	// "allow_row_interleaving" was specified in the request.
	RowKey []byte `protobuf:"bytes,1,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// One or more chunks of the row specified by "row_key".
	Chunks []*ReadRowsResponse_Chunk `protobuf:"bytes,2,rep,name=chunks" json:"chunks,omitempty"`
}

func (m *ReadRowsResponse) Reset()                    { *m = ReadRowsResponse{} }
func (m *ReadRowsResponse) String() string            { return proto.CompactTextString(m) }
func (*ReadRowsResponse) ProtoMessage()               {}
func (*ReadRowsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *ReadRowsResponse) GetChunks() []*ReadRowsResponse_Chunk {
	if m != nil {
		return m.Chunks
	}
	return nil
}

// Specifies a piece of a row's contents returned as part of the read
// response stream.
type ReadRowsResponse_Chunk struct {
	// Types that are valid to be assigned to Chunk:
	//	*ReadRowsResponse_Chunk_RowContents
	//	*ReadRowsResponse_Chunk_ResetRow
	//	*ReadRowsResponse_Chunk_CommitRow
	Chunk isReadRowsResponse_Chunk_Chunk `protobuf_oneof:"chunk"`
}

func (m *ReadRowsResponse_Chunk) Reset()                    { *m = ReadRowsResponse_Chunk{} }
func (m *ReadRowsResponse_Chunk) String() string            { return proto.CompactTextString(m) }
func (*ReadRowsResponse_Chunk) ProtoMessage()               {}
func (*ReadRowsResponse_Chunk) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1, 0} }

type isReadRowsResponse_Chunk_Chunk interface {
	isReadRowsResponse_Chunk_Chunk()
}

type ReadRowsResponse_Chunk_RowContents struct {
	RowContents *google_bigtable_v11.Family `protobuf:"bytes,1,opt,name=row_contents,json=rowContents,oneof"`
}
type ReadRowsResponse_Chunk_ResetRow struct {
	ResetRow bool `protobuf:"varint,2,opt,name=reset_row,json=resetRow,oneof"`
}
type ReadRowsResponse_Chunk_CommitRow struct {
	CommitRow bool `protobuf:"varint,3,opt,name=commit_row,json=commitRow,oneof"`
}

func (*ReadRowsResponse_Chunk_RowContents) isReadRowsResponse_Chunk_Chunk() {}
func (*ReadRowsResponse_Chunk_ResetRow) isReadRowsResponse_Chunk_Chunk()    {}
func (*ReadRowsResponse_Chunk_CommitRow) isReadRowsResponse_Chunk_Chunk()   {}

func (m *ReadRowsResponse_Chunk) GetChunk() isReadRowsResponse_Chunk_Chunk {
	if m != nil {
		return m.Chunk
	}
	return nil
}

func (m *ReadRowsResponse_Chunk) GetRowContents() *google_bigtable_v11.Family {
	if x, ok := m.GetChunk().(*ReadRowsResponse_Chunk_RowContents); ok {
		return x.RowContents
	}
	return nil
}

func (m *ReadRowsResponse_Chunk) GetResetRow() bool {
	if x, ok := m.GetChunk().(*ReadRowsResponse_Chunk_ResetRow); ok {
		return x.ResetRow
	}
	return false
}

func (m *ReadRowsResponse_Chunk) GetCommitRow() bool {
	if x, ok := m.GetChunk().(*ReadRowsResponse_Chunk_CommitRow); ok {
		return x.CommitRow
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ReadRowsResponse_Chunk) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ReadRowsResponse_Chunk_OneofMarshaler, _ReadRowsResponse_Chunk_OneofUnmarshaler, _ReadRowsResponse_Chunk_OneofSizer, []interface{}{
		(*ReadRowsResponse_Chunk_RowContents)(nil),
		(*ReadRowsResponse_Chunk_ResetRow)(nil),
		(*ReadRowsResponse_Chunk_CommitRow)(nil),
	}
}

func _ReadRowsResponse_Chunk_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ReadRowsResponse_Chunk)
	// chunk
	switch x := m.Chunk.(type) {
	case *ReadRowsResponse_Chunk_RowContents:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RowContents); err != nil {
			return err
		}
	case *ReadRowsResponse_Chunk_ResetRow:
		t := uint64(0)
		if x.ResetRow {
			t = 1
		}
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *ReadRowsResponse_Chunk_CommitRow:
		t := uint64(0)
		if x.CommitRow {
			t = 1
		}
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("ReadRowsResponse_Chunk.Chunk has unexpected type %T", x)
	}
	return nil
}

func _ReadRowsResponse_Chunk_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ReadRowsResponse_Chunk)
	switch tag {
	case 1: // chunk.row_contents
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_bigtable_v11.Family)
		err := b.DecodeMessage(msg)
		m.Chunk = &ReadRowsResponse_Chunk_RowContents{msg}
		return true, err
	case 2: // chunk.reset_row
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Chunk = &ReadRowsResponse_Chunk_ResetRow{x != 0}
		return true, err
	case 3: // chunk.commit_row
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Chunk = &ReadRowsResponse_Chunk_CommitRow{x != 0}
		return true, err
	default:
		return false, nil
	}
}

func _ReadRowsResponse_Chunk_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ReadRowsResponse_Chunk)
	// chunk
	switch x := m.Chunk.(type) {
	case *ReadRowsResponse_Chunk_RowContents:
		s := proto.Size(x.RowContents)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ReadRowsResponse_Chunk_ResetRow:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += 1
	case *ReadRowsResponse_Chunk_CommitRow:
		n += proto.SizeVarint(3<<3 | proto.WireVarint)
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request message for BigtableService.SampleRowKeys.
type SampleRowKeysRequest struct {
	// The unique name of the table from which to sample row keys.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName" json:"table_name,omitempty"`
}

func (m *SampleRowKeysRequest) Reset()                    { *m = SampleRowKeysRequest{} }
func (m *SampleRowKeysRequest) String() string            { return proto.CompactTextString(m) }
func (*SampleRowKeysRequest) ProtoMessage()               {}
func (*SampleRowKeysRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Response message for BigtableService.SampleRowKeys.
type SampleRowKeysResponse struct {
	// Sorted streamed sequence of sample row keys in the table. The table might
	// have contents before the first row key in the list and after the last one,
	// but a key containing the empty string indicates "end of table" and will be
	// the last response given, if present.
	// Note that row keys in this list may not have ever been written to or read
	// from, and users should therefore not make any assumptions about the row key
	// structure that are specific to their use case.
	RowKey []byte `protobuf:"bytes,1,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Approximate total storage space used by all rows in the table which precede
	// "row_key". Buffering the contents of all rows between two subsequent
	// samples would require space roughly equal to the difference in their
	// "offset_bytes" fields.
	OffsetBytes int64 `protobuf:"varint,2,opt,name=offset_bytes,json=offsetBytes" json:"offset_bytes,omitempty"`
}

func (m *SampleRowKeysResponse) Reset()                    { *m = SampleRowKeysResponse{} }
func (m *SampleRowKeysResponse) String() string            { return proto.CompactTextString(m) }
func (*SampleRowKeysResponse) ProtoMessage()               {}
func (*SampleRowKeysResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// Request message for BigtableService.MutateRow.
type MutateRowRequest struct {
	// The unique name of the table to which the mutation should be applied.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName" json:"table_name,omitempty"`
	// The key of the row to which the mutation should be applied.
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Changes to be atomically applied to the specified row. Entries are applied
	// in order, meaning that earlier mutations can be masked by later ones.
	// Must contain at least one entry and at most 100000.
	Mutations []*google_bigtable_v11.Mutation `protobuf:"bytes,3,rep,name=mutations" json:"mutations,omitempty"`
}

func (m *MutateRowRequest) Reset()                    { *m = MutateRowRequest{} }
func (m *MutateRowRequest) String() string            { return proto.CompactTextString(m) }
func (*MutateRowRequest) ProtoMessage()               {}
func (*MutateRowRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *MutateRowRequest) GetMutations() []*google_bigtable_v11.Mutation {
	if m != nil {
		return m.Mutations
	}
	return nil
}

// Request message for BigtableService.MutateRows.
type MutateRowsRequest struct {
	// The unique name of the table to which the mutations should be applied.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName" json:"table_name,omitempty"`
	// The row keys/mutations to be applied in bulk.
	// Each entry is applied as an atomic mutation, but the entries may be
	// applied in arbitrary order (even between entries for the same row).
	// At least one entry must be specified, and in total the entries may
	// contain at most 100000 mutations.
	Entries []*MutateRowsRequest_Entry `protobuf:"bytes,2,rep,name=entries" json:"entries,omitempty"`
}

func (m *MutateRowsRequest) Reset()                    { *m = MutateRowsRequest{} }
func (m *MutateRowsRequest) String() string            { return proto.CompactTextString(m) }
func (*MutateRowsRequest) ProtoMessage()               {}
func (*MutateRowsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *MutateRowsRequest) GetEntries() []*MutateRowsRequest_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

type MutateRowsRequest_Entry struct {
	// The key of the row to which the `mutations` should be applied.
	RowKey []byte `protobuf:"bytes,1,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Changes to be atomically applied to the specified row. Mutations are
	// applied in order, meaning that earlier mutations can be masked by
	// later ones.
	// At least one mutation must be specified.
	Mutations []*google_bigtable_v11.Mutation `protobuf:"bytes,2,rep,name=mutations" json:"mutations,omitempty"`
}

func (m *MutateRowsRequest_Entry) Reset()                    { *m = MutateRowsRequest_Entry{} }
func (m *MutateRowsRequest_Entry) String() string            { return proto.CompactTextString(m) }
func (*MutateRowsRequest_Entry) ProtoMessage()               {}
func (*MutateRowsRequest_Entry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5, 0} }

func (m *MutateRowsRequest_Entry) GetMutations() []*google_bigtable_v11.Mutation {
	if m != nil {
		return m.Mutations
	}
	return nil
}

// Response message for BigtableService.MutateRows.
type MutateRowsResponse struct {
	// The results for each Entry from the request, presented in the order
	// in which the entries were originally given.
	// Depending on how requests are batched during execution, it is possible
	// for one Entry to fail due to an error with another Entry. In the event
	// that this occurs, the same error will be reported for both entries.
	Statuses []*google_rpc.Status `protobuf:"bytes,1,rep,name=statuses" json:"statuses,omitempty"`
}

func (m *MutateRowsResponse) Reset()                    { *m = MutateRowsResponse{} }
func (m *MutateRowsResponse) String() string            { return proto.CompactTextString(m) }
func (*MutateRowsResponse) ProtoMessage()               {}
func (*MutateRowsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *MutateRowsResponse) GetStatuses() []*google_rpc.Status {
	if m != nil {
		return m.Statuses
	}
	return nil
}

// Request message for BigtableService.CheckAndMutateRowRequest
type CheckAndMutateRowRequest struct {
	// The unique name of the table to which the conditional mutation should be
	// applied.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName" json:"table_name,omitempty"`
	// The key of the row to which the conditional mutation should be applied.
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// The filter to be applied to the contents of the specified row. Depending
	// on whether or not any results are yielded, either "true_mutations" or
	// "false_mutations" will be executed. If unset, checks that the row contains
	// any values at all.
	PredicateFilter *google_bigtable_v11.RowFilter `protobuf:"bytes,6,opt,name=predicate_filter,json=predicateFilter" json:"predicate_filter,omitempty"`
	// Changes to be atomically applied to the specified row if "predicate_filter"
	// yields at least one cell when applied to "row_key". Entries are applied in
	// order, meaning that earlier mutations can be masked by later ones.
	// Must contain at least one entry if "false_mutations" is empty, and at most
	// 100000.
	TrueMutations []*google_bigtable_v11.Mutation `protobuf:"bytes,4,rep,name=true_mutations,json=trueMutations" json:"true_mutations,omitempty"`
	// Changes to be atomically applied to the specified row if "predicate_filter"
	// does not yield any cells when applied to "row_key". Entries are applied in
	// order, meaning that earlier mutations can be masked by later ones.
	// Must contain at least one entry if "true_mutations" is empty, and at most
	// 100000.
	FalseMutations []*google_bigtable_v11.Mutation `protobuf:"bytes,5,rep,name=false_mutations,json=falseMutations" json:"false_mutations,omitempty"`
}

func (m *CheckAndMutateRowRequest) Reset()                    { *m = CheckAndMutateRowRequest{} }
func (m *CheckAndMutateRowRequest) String() string            { return proto.CompactTextString(m) }
func (*CheckAndMutateRowRequest) ProtoMessage()               {}
func (*CheckAndMutateRowRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *CheckAndMutateRowRequest) GetPredicateFilter() *google_bigtable_v11.RowFilter {
	if m != nil {
		return m.PredicateFilter
	}
	return nil
}

func (m *CheckAndMutateRowRequest) GetTrueMutations() []*google_bigtable_v11.Mutation {
	if m != nil {
		return m.TrueMutations
	}
	return nil
}

func (m *CheckAndMutateRowRequest) GetFalseMutations() []*google_bigtable_v11.Mutation {
	if m != nil {
		return m.FalseMutations
	}
	return nil
}

// Response message for BigtableService.CheckAndMutateRowRequest.
type CheckAndMutateRowResponse struct {
	// Whether or not the request's "predicate_filter" yielded any results for
	// the specified row.
	PredicateMatched bool `protobuf:"varint,1,opt,name=predicate_matched,json=predicateMatched" json:"predicate_matched,omitempty"`
}

func (m *CheckAndMutateRowResponse) Reset()                    { *m = CheckAndMutateRowResponse{} }
func (m *CheckAndMutateRowResponse) String() string            { return proto.CompactTextString(m) }
func (*CheckAndMutateRowResponse) ProtoMessage()               {}
func (*CheckAndMutateRowResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

// Request message for BigtableService.ReadModifyWriteRowRequest.
type ReadModifyWriteRowRequest struct {
	// The unique name of the table to which the read/modify/write rules should be
	// applied.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName" json:"table_name,omitempty"`
	// The key of the row to which the read/modify/write rules should be applied.
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Rules specifying how the specified row's contents are to be transformed
	// into writes. Entries are applied in order, meaning that earlier rules will
	// affect the results of later ones.
	Rules []*google_bigtable_v11.ReadModifyWriteRule `protobuf:"bytes,3,rep,name=rules" json:"rules,omitempty"`
}

func (m *ReadModifyWriteRowRequest) Reset()                    { *m = ReadModifyWriteRowRequest{} }
func (m *ReadModifyWriteRowRequest) String() string            { return proto.CompactTextString(m) }
func (*ReadModifyWriteRowRequest) ProtoMessage()               {}
func (*ReadModifyWriteRowRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *ReadModifyWriteRowRequest) GetRules() []*google_bigtable_v11.ReadModifyWriteRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func init() {
	proto.RegisterType((*ReadRowsRequest)(nil), "google.bigtable.v1.ReadRowsRequest")
	proto.RegisterType((*ReadRowsResponse)(nil), "google.bigtable.v1.ReadRowsResponse")
	proto.RegisterType((*ReadRowsResponse_Chunk)(nil), "google.bigtable.v1.ReadRowsResponse.Chunk")
	proto.RegisterType((*SampleRowKeysRequest)(nil), "google.bigtable.v1.SampleRowKeysRequest")
	proto.RegisterType((*SampleRowKeysResponse)(nil), "google.bigtable.v1.SampleRowKeysResponse")
	proto.RegisterType((*MutateRowRequest)(nil), "google.bigtable.v1.MutateRowRequest")
	proto.RegisterType((*MutateRowsRequest)(nil), "google.bigtable.v1.MutateRowsRequest")
	proto.RegisterType((*MutateRowsRequest_Entry)(nil), "google.bigtable.v1.MutateRowsRequest.Entry")
	proto.RegisterType((*MutateRowsResponse)(nil), "google.bigtable.v1.MutateRowsResponse")
	proto.RegisterType((*CheckAndMutateRowRequest)(nil), "google.bigtable.v1.CheckAndMutateRowRequest")
	proto.RegisterType((*CheckAndMutateRowResponse)(nil), "google.bigtable.v1.CheckAndMutateRowResponse")
	proto.RegisterType((*ReadModifyWriteRowRequest)(nil), "google.bigtable.v1.ReadModifyWriteRowRequest")
}

func init() {
	proto.RegisterFile("google.golang.org/cloud/bigtable/internal/service_proto/bigtable_service_messages.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 776 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x55, 0x5b, 0x6f, 0xd3, 0x4a,
	0x10, 0x3e, 0x49, 0x4e, 0x6e, 0xd3, 0x9c, 0x5e, 0xac, 0x9e, 0xd6, 0x8d, 0x5a, 0x9d, 0x83, 0x85,
	0x04, 0xa2, 0x92, 0x23, 0x2e, 0x95, 0x10, 0x08, 0x21, 0x12, 0x5a, 0x82, 0x20, 0xa8, 0xda, 0x3c,
	0xf4, 0x05, 0x29, 0xda, 0x38, 0x1b, 0xd7, 0xaa, 0x2f, 0x61, 0x77, 0xdd, 0x2a, 0xcf, 0x48, 0xbc,
	0xc3, 0xaf, 0xe0, 0x1f, 0xf1, 0xc2, 0x8f, 0x61, 0x76, 0xed, 0x38, 0x21, 0x34, 0xc2, 0x48, 0x7d,
	0x88, 0x14, 0x7f, 0x33, 0xdf, 0x37, 0x33, 0xdf, 0xae, 0xc7, 0x70, 0xe6, 0x46, 0x91, 0xeb, 0x33,
	0xdb, 0x8d, 0x7c, 0x1a, 0xba, 0x76, 0xc4, 0xdd, 0x96, 0xe3, 0x47, 0xf1, 0xa8, 0x35, 0xf4, 0x5c,
	0x49, 0x87, 0x3e, 0x6b, 0x79, 0xa1, 0x64, 0x3c, 0xa4, 0x7e, 0x4b, 0x30, 0x7e, 0xe9, 0x39, 0x6c,
	0x30, 0xe1, 0x91, 0x8c, 0xb2, 0xf8, 0x60, 0x06, 0x07, 0x4c, 0x08, 0xea, 0x32, 0x61, 0xeb, 0xb8,
	0x61, 0xa4, 0xc2, 0xb3, 0x3c, 0xfb, 0xf2, 0x7e, 0xb3, 0x9b, 0xbf, 0xd8, 0x88, 0x4a, 0xba, 0x5c,
	0x49, 0x61, 0x89, 0x7a, 0xf3, 0x55, 0x7e, 0x25, 0x3e, 0x71, 0x06, 0x42, 0x52, 0x19, 0x8b, 0x54,
	0x2f, 0x79, 0x48, 0x84, 0xac, 0xef, 0x45, 0xd8, 0x20, 0x8c, 0x8e, 0x48, 0x74, 0x25, 0x08, 0xfb,
	0x10, 0x33, 0x21, 0x8d, 0x03, 0x80, 0xa4, 0x60, 0x48, 0x03, 0x66, 0x16, 0xfe, 0x2f, 0xdc, 0xad,
	0x93, 0xba, 0x46, 0xde, 0x21, 0x60, 0xec, 0x41, 0x95, 0x47, 0x57, 0x83, 0x0b, 0x36, 0x35, 0x8b,
	0x18, 0x6b, 0x74, 0xff, 0x22, 0x15, 0x04, 0xde, 0xb0, 0xa9, 0xf1, 0x14, 0xea, 0x2a, 0xc4, 0xb1,
	0x27, 0x66, 0x96, 0x30, 0xb8, 0xf6, 0x60, 0xdf, 0xfe, 0xd5, 0x08, 0x1b, 0xab, 0x11, 0x95, 0x83,
	0xd4, 0x1a, 0x4f, 0xff, 0x1b, 0x47, 0x89, 0xae, 0x60, 0xd2, 0xac, 0x69, 0x6a, 0x73, 0x05, 0xb5,
	0xcf, 0x64, 0x5a, 0x13, 0xff, 0x21, 0xad, 0x32, 0xf6, 0x7c, 0x1c, 0xd6, 0x2c, 0x6b, 0xd6, 0xc1,
	0x0a, 0xd6, 0x89, 0x4e, 0x22, 0x69, 0xb2, 0xf1, 0x08, 0x76, 0xa8, 0xef, 0xab, 0x66, 0xf1, 0xa7,
	0xcd, 0xf2, 0x19, 0xbd, 0xf4, 0x42, 0xd7, 0xac, 0xa0, 0x4c, 0x8d, 0x6c, 0xeb, 0x28, 0xf2, 0x5e,
	0x2f, 0xc4, 0x8c, 0xdb, 0xb0, 0x1e, 0xc6, 0x81, 0xe2, 0x88, 0x81, 0xef, 0x05, 0x9e, 0x34, 0xab,
	0x98, 0x5d, 0x22, 0x0d, 0x44, 0x95, 0x85, 0x6f, 0x15, 0xd6, 0xae, 0x41, 0x45, 0x52, 0xee, 0x32,
	0x69, 0x7d, 0x2c, 0xc2, 0xe6, 0xdc, 0x5e, 0x31, 0x89, 0x42, 0xc1, 0x8c, 0xdd, 0xb9, 0x81, 0xca,
	0xdc, 0x46, 0x66, 0x5f, 0x1b, 0x2a, 0xce, 0x79, 0x1c, 0x5e, 0x08, 0x34, 0xb6, 0x84, 0xa3, 0xdc,
	0xbb, 0x76, 0x94, 0x25, 0x39, 0xbb, 0xa3, 0x28, 0x24, 0x65, 0x36, 0x3f, 0x17, 0xa0, 0xac, 0x11,
	0xe3, 0x39, 0x34, 0x54, 0x19, 0x27, 0xc2, 0x01, 0x42, 0x29, 0x74, 0xad, 0x15, 0xa6, 0x9e, 0xd0,
	0xc0, 0xf3, 0xa7, 0x68, 0xea, 0x1a, 0x32, 0x3a, 0x29, 0x01, 0xef, 0x41, 0x9d, 0x33, 0x3c, 0x0e,
	0x35, 0xae, 0x3e, 0xea, 0x9a, 0x3e, 0x2f, 0x05, 0x61, 0x03, 0xc6, 0x7f, 0x00, 0x4e, 0x14, 0xe0,
	0xbc, 0x3a, 0x5e, 0x4a, 0xe3, 0xf5, 0x04, 0xc3, 0x84, 0x76, 0x15, 0xca, 0xba, 0x29, 0xeb, 0x08,
	0xb6, 0xfb, 0x34, 0x98, 0xf8, 0x8c, 0xe8, 0x39, 0x73, 0x5e, 0x34, 0xab, 0x0f, 0xff, 0x2e, 0xd1,
	0x7e, 0x67, 0xe0, 0x2d, 0x68, 0x44, 0xe3, 0xb1, 0x6a, 0x79, 0x38, 0x95, 0x4c, 0xe8, 0xa6, 0x4b,
	0x64, 0x2d, 0xc1, 0xda, 0x0a, 0xb2, 0x3e, 0x15, 0x60, 0xb3, 0x17, 0xe3, 0x2b, 0xa0, 0x54, 0x73,
	0xde, 0xf8, 0xdd, 0xa5, 0x1b, 0x9f, 0xd5, 0x7b, 0x02, 0xf5, 0x40, 0x69, 0x79, 0xd8, 0x16, 0x3a,
	0x50, 0x5a, 0x75, 0xdf, 0x7b, 0x69, 0x12, 0x99, 0xa7, 0x5b, 0xdf, 0x0a, 0xb0, 0x95, 0x35, 0x92,
	0xf7, 0xdd, 0x3b, 0x86, 0x2a, 0x1e, 0x0d, 0xf7, 0xd8, 0xec, 0x8a, 0x1c, 0xae, 0x2c, 0xb7, 0x28,
	0x6b, 0x1f, 0x23, 0x69, 0x4a, 0x66, 0xdc, 0xe6, 0x7b, 0x28, 0x6b, 0x64, 0xb5, 0x93, 0x3f, 0x4d,
	0x56, 0xfc, 0xb3, 0xc9, 0x5e, 0x82, 0xb1, 0xd8, 0x41, 0x7a, 0x68, 0x36, 0xd4, 0x92, 0xcd, 0xc3,
	0xd4, 0x55, 0x54, 0x82, 0xc6, 0x4c, 0x10, 0x57, 0x94, 0xdd, 0xd7, 0x31, 0x92, 0xe5, 0x58, 0x5f,
	0x8b, 0x60, 0x76, 0xce, 0x99, 0x73, 0xf1, 0x22, 0x1c, 0xdd, 0xd8, 0x81, 0x75, 0x61, 0x73, 0xc2,
	0xd9, 0xc8, 0x73, 0x50, 0x6e, 0x90, 0xae, 0x8d, 0x4a, 0x9e, 0xb5, 0xb1, 0x91, 0xd1, 0x12, 0xc0,
	0xe8, 0xc0, 0xba, 0xe4, 0x31, 0xae, 0xfd, 0xcc, 0xa5, 0xbf, 0x73, 0xb8, 0xf4, 0x8f, 0xe2, 0xcc,
	0x9e, 0x04, 0x1e, 0xe7, 0xc6, 0x98, 0xfa, 0x62, 0x51, 0xa5, 0x9c, 0x43, 0x65, 0x5d, 0x93, 0x32,
	0x19, 0xab, 0x0b, 0x7b, 0xd7, 0x38, 0x95, 0xfa, 0x7e, 0x08, 0x5b, 0xf3, 0x91, 0x03, 0x2a, 0x9d,
	0x73, 0x36, 0xd2, 0x8e, 0xd5, 0xc8, 0xdc, 0x8b, 0x5e, 0x82, 0x5b, 0x5f, 0x0a, 0xb0, 0xa7, 0x16,
	0x4c, 0x2f, 0x1a, 0x79, 0xe3, 0xe9, 0x19, 0xf7, 0x6e, 0xc4, 0xf5, 0x67, 0x50, 0xe6, 0xb1, 0xcf,
	0x66, 0xaf, 0xc8, 0x9d, 0x55, 0x6b, 0x6d, 0xb1, 0x2a, 0xe6, 0x93, 0x84, 0xd5, 0x7e, 0x0c, 0x3b,
	0xb8, 0x54, 0xae, 0x21, 0xb5, 0xf7, 0xdb, 0xe9, 0x43, 0x3f, 0xf9, 0x08, 0xf7, 0xd2, 0x6f, 0xf0,
	0xa9, 0xfa, 0xb6, 0x9d, 0x16, 0x86, 0x15, 0xfd, 0x91, 0x7b, 0xf8, 0x23, 0x00, 0x00, 0xff, 0xff,
	0x9a, 0xba, 0xcf, 0xcf, 0xe6, 0x07, 0x00, 0x00,
}
