// Code generated by protoc-gen-go.
// source: google.golang.org/cloud/bigtable/internal/cluster_data_proto/bigtable_cluster_data.proto
// DO NOT EDIT!

/*
Package google_bigtable_admin_cluster_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/cloud/bigtable/internal/cluster_data_proto/bigtable_cluster_data.proto

It has these top-level messages:
	Zone
	Cluster
*/
package google_bigtable_admin_cluster_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type StorageType int32

const (
	// The storage type used is unspecified.
	StorageType_STORAGE_UNSPECIFIED StorageType = 0
	// Data will be stored in SSD, providing low and consistent latencies.
	StorageType_STORAGE_SSD StorageType = 1
	// Data will be stored in HDD, providing high and less predictable
	// latencies.
	StorageType_STORAGE_HDD StorageType = 2
)

var StorageType_name = map[int32]string{
	0: "STORAGE_UNSPECIFIED",
	1: "STORAGE_SSD",
	2: "STORAGE_HDD",
}
var StorageType_value = map[string]int32{
	"STORAGE_UNSPECIFIED": 0,
	"STORAGE_SSD":         1,
	"STORAGE_HDD":         2,
}

func (x StorageType) String() string {
	return proto.EnumName(StorageType_name, int32(x))
}
func (StorageType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Possible states of a zone.
type Zone_Status int32

const (
	// The state of the zone is unknown or unspecified.
	Zone_UNKNOWN Zone_Status = 0
	// The zone is in a good state.
	Zone_OK Zone_Status = 1
	// The zone is down for planned maintenance.
	Zone_PLANNED_MAINTENANCE Zone_Status = 2
	// The zone is down for emergency or unplanned maintenance.
	Zone_EMERGENCY_MAINENANCE Zone_Status = 3
)

var Zone_Status_name = map[int32]string{
	0: "UNKNOWN",
	1: "OK",
	2: "PLANNED_MAINTENANCE",
	3: "EMERGENCY_MAINENANCE",
}
var Zone_Status_value = map[string]int32{
	"UNKNOWN": 0,
	"OK":      1,
	"PLANNED_MAINTENANCE":  2,
	"EMERGENCY_MAINENANCE": 3,
}

func (x Zone_Status) String() string {
	return proto.EnumName(Zone_Status_name, int32(x))
}
func (Zone_Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 0} }

// A physical location in which a particular project can allocate Cloud BigTable
// resources.
type Zone struct {
	// A permanent unique identifier for the zone.
	// Values are of the form projects/<project>/zones/[a-z][-a-z0-9]*
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name of this zone as it appears in UIs.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// The current state of this zone.
	Status Zone_Status `protobuf:"varint,3,opt,name=status,enum=google.bigtable.admin.cluster.v1.Zone_Status" json:"status,omitempty"`
}

func (m *Zone) Reset()                    { *m = Zone{} }
func (m *Zone) String() string            { return proto.CompactTextString(m) }
func (*Zone) ProtoMessage()               {}
func (*Zone) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// An isolated set of Cloud BigTable resources on which tables can be hosted.
type Cluster struct {
	// A permanent unique identifier for the cluster. For technical reasons, the
	// zone in which the cluster resides is included here.
	// Values are of the form
	// projects/<project>/zones/<zone>/clusters/[a-z][-a-z0-9]*
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The descriptive name for this cluster as it appears in UIs.
	// Must be unique per zone.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// The number of serve nodes allocated to this cluster.
	ServeNodes int32 `protobuf:"varint,5,opt,name=serve_nodes,json=serveNodes" json:"serve_nodes,omitempty"`
	// What storage type to use for tables in this cluster. Only configurable at
	// cluster creation time. If unspecified, STORAGE_SSD will be used.
	DefaultStorageType StorageType `protobuf:"varint,8,opt,name=default_storage_type,json=defaultStorageType,enum=google.bigtable.admin.cluster.v1.StorageType" json:"default_storage_type,omitempty"`
}

func (m *Cluster) Reset()                    { *m = Cluster{} }
func (m *Cluster) String() string            { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()               {}
func (*Cluster) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func init() {
	proto.RegisterType((*Zone)(nil), "google.bigtable.admin.cluster.v1.Zone")
	proto.RegisterType((*Cluster)(nil), "google.bigtable.admin.cluster.v1.Cluster")
	proto.RegisterEnum("google.bigtable.admin.cluster.v1.StorageType", StorageType_name, StorageType_value)
	proto.RegisterEnum("google.bigtable.admin.cluster.v1.Zone_Status", Zone_Status_name, Zone_Status_value)
}

func init() {
	proto.RegisterFile("google.golang.org/cloud/bigtable/internal/cluster_data_proto/bigtable_cluster_data.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 395 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x92, 0xdf, 0x6e, 0xd3, 0x30,
	0x18, 0xc5, 0x49, 0xd6, 0x65, 0xf0, 0x05, 0x41, 0x64, 0x26, 0x91, 0x3b, 0x46, 0xc5, 0x05, 0x42,
	0xc2, 0x15, 0xf0, 0x04, 0xf9, 0x63, 0xb6, 0x6a, 0xcc, 0x8d, 0x92, 0x4e, 0xfc, 0xb9, 0xb1, 0xdc,
	0xc5, 0x44, 0x91, 0xd2, 0xb8, 0x4a, 0x9c, 0x49, 0x7b, 0x3d, 0x1e, 0x82, 0xe7, 0xc1, 0x71, 0x0d,
	0x8a, 0xc4, 0x45, 0x7b, 0xe7, 0x9c, 0xdf, 0x39, 0xfe, 0xe2, 0xa3, 0x0f, 0xbe, 0x55, 0x52, 0x56,
	0x8d, 0xc0, 0x95, 0x6c, 0x78, 0x5b, 0x61, 0xd9, 0x55, 0x8b, 0xbb, 0x46, 0x0e, 0xe5, 0x62, 0x53,
	0x57, 0x8a, 0x6f, 0x1a, 0xb1, 0xa8, 0x5b, 0x25, 0xba, 0x96, 0x37, 0x5a, 0x1f, 0x7a, 0x7d, 0x64,
	0x25, 0x57, 0x9c, 0xed, 0x3a, 0xa9, 0xe4, 0x3f, 0x13, 0x9b, 0x32, 0x6c, 0x18, 0xba, 0xb0, 0x37,
	0xff, 0xf5, 0x60, 0x5e, 0x6e, 0xeb, 0x16, 0x5b, 0x27, 0xbe, 0xff, 0x30, 0xff, 0xed, 0xc0, 0xec,
	0x87, 0x6c, 0x05, 0x42, 0x30, 0x6b, 0xf9, 0x56, 0x84, 0xce, 0x85, 0xf3, 0xf6, 0x49, 0x6e, 0xce,
	0xe8, 0x35, 0x3c, 0x2d, 0xeb, 0x7e, 0xd7, 0xf0, 0x07, 0x66, 0x98, 0x6b, 0x98, 0x6f, 0x35, 0x3a,
	0x5a, 0x08, 0x78, 0xbd, 0xe2, 0x6a, 0xe8, 0xc3, 0x13, 0x0d, 0x9f, 0x7d, 0x7c, 0x8f, 0x0f, 0x8d,
	0xc4, 0xe3, 0x38, 0x5c, 0x98, 0x50, 0x6e, 0xc3, 0xf3, 0x0c, 0xbc, 0xbd, 0x82, 0x7c, 0x38, 0xbb,
	0xa5, 0xd7, 0x74, 0xf5, 0x95, 0x06, 0x8f, 0x90, 0x07, 0xee, 0xea, 0x3a, 0x70, 0xd0, 0x4b, 0x78,
	0x91, 0x7d, 0x89, 0x28, 0x25, 0x29, 0xbb, 0x89, 0x96, 0x74, 0x4d, 0x68, 0x44, 0x13, 0x12, 0xb8,
	0x28, 0x84, 0x73, 0x72, 0x43, 0xf2, 0x4b, 0x42, 0x93, 0xef, 0x06, 0x59, 0x72, 0x32, 0xff, 0xe5,
	0xc0, 0x59, 0xb2, 0x1f, 0x7a, 0xd4, 0xdb, 0x66, 0xff, 0xbf, 0xed, 0x15, 0xf8, 0xbd, 0xe8, 0xee,
	0x05, 0x6b, 0x65, 0x29, 0xfa, 0xf0, 0x54, 0x3b, 0x4e, 0x73, 0x30, 0x12, 0x1d, 0x15, 0xc4, 0xe0,
	0xbc, 0x14, 0x3f, 0xf9, 0xd0, 0x28, 0xd6, 0x2b, 0xd9, 0xf1, 0x4a, 0x30, 0xf5, 0xb0, 0x13, 0xe1,
	0xe3, 0x63, 0xab, 0x28, 0xf6, 0xa9, 0xb5, 0x0e, 0xe5, 0xc8, 0x5e, 0x35, 0xd1, 0xde, 0x5d, 0x81,
	0x3f, 0xf9, 0x1c, 0x6b, 0x28, 0xd6, 0xab, 0x3c, 0xba, 0x24, 0xec, 0x96, 0x16, 0x19, 0x49, 0x96,
	0x9f, 0x97, 0x24, 0xd5, 0x3d, 0x3d, 0xd7, 0x3e, 0x0b, 0x8a, 0x22, 0xd5, 0x85, 0x4d, 0x84, 0xab,
	0x34, 0x0d, 0xdc, 0x38, 0x86, 0x37, 0x77, 0x72, 0x7b, 0xf0, 0x8f, 0xe2, 0x30, 0xb6, 0xc8, 0x76,
	0x97, 0xea, 0x65, 0xca, 0xc6, 0x5d, 0xca, 0x9c, 0x8d, 0x67, 0x96, 0xea, 0xd3, 0x9f, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x4e, 0x74, 0xe9, 0xe5, 0xb0, 0x02, 0x00, 0x00,
}
