// Code generated by goyacc -o parser.go parser.go.y. DO NOT EDIT.

//line parser.go.y:2
package gojq

import __yyfmt__ "fmt"

//line parser.go.y:2

// Parse a query string, and returns the query struct.
//
// If parsing failed, the returned error has the method Token() (string, int),
// which reports the invalid token and the byte offset in the query string. The
// token is empty if the error occurred after scanning the entire query string.
// The byte offset is the scanned bytes when the error occurred.
func Parse(src string) (*Query, error) {
	l := newLexer(src)
	if yyParse(l) > 0 {
		return nil, l.err
	}
	return l.result, nil
}

func reverseFuncDef(xs []*FuncDef) []*FuncDef {
	for i, j := 0, len(xs)-1; i < j; i, j = i+1, j-1 {
		xs[i], xs[j] = xs[j], xs[i]
	}
	return xs
}

func prependFuncDef(xs []*FuncDef, x *FuncDef) []*FuncDef {
	xs = append(xs, nil)
	copy(xs[1:], xs)
	xs[0] = x
	return xs
}

//line parser.go.y:33
type yySymType struct {
	yys      int
	value    interface{}
	token    string
	operator Operator
}

const tokAltOp = 57346
const tokUpdateOp = 57347
const tokDestAltOp = 57348
const tokOrOp = 57349
const tokAndOp = 57350
const tokCompareOp = 57351
const tokModule = 57352
const tokImport = 57353
const tokInclude = 57354
const tokDef = 57355
const tokAs = 57356
const tokLabel = 57357
const tokBreak = 57358
const tokNull = 57359
const tokTrue = 57360
const tokFalse = 57361
const tokIdent = 57362
const tokVariable = 57363
const tokModuleIdent = 57364
const tokModuleVariable = 57365
const tokIndex = 57366
const tokNumber = 57367
const tokFormat = 57368
const tokString = 57369
const tokStringStart = 57370
const tokStringQuery = 57371
const tokStringEnd = 57372
const tokIf = 57373
const tokThen = 57374
const tokElif = 57375
const tokElse = 57376
const tokEnd = 57377
const tokTry = 57378
const tokCatch = 57379
const tokReduce = 57380
const tokForeach = 57381
const tokRecurse = 57382
const tokFuncDefPost = 57383
const tokTermPost = 57384
const tokEmptyCatch = 57385
const tokInvalid = 57386
const tokInvalidEscapeSequence = 57387
const tokUnterminatedString = 57388

var yyToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"tokAltOp",
	"tokUpdateOp",
	"tokDestAltOp",
	"tokOrOp",
	"tokAndOp",
	"tokCompareOp",
	"tokModule",
	"tokImport",
	"tokInclude",
	"tokDef",
	"tokAs",
	"tokLabel",
	"tokBreak",
	"tokNull",
	"tokTrue",
	"tokFalse",
	"tokIdent",
	"tokVariable",
	"tokModuleIdent",
	"tokModuleVariable",
	"tokIndex",
	"tokNumber",
	"tokFormat",
	"tokString",
	"tokStringStart",
	"tokStringQuery",
	"tokStringEnd",
	"tokIf",
	"tokThen",
	"tokElif",
	"tokElse",
	"tokEnd",
	"tokTry",
	"tokCatch",
	"tokReduce",
	"tokForeach",
	"tokRecurse",
	"tokFuncDefPost",
	"tokTermPost",
	"tokEmptyCatch",
	"tokInvalid",
	"tokInvalidEscapeSequence",
	"tokUnterminatedString",
	"'|'",
	"','",
	"'+'",
	"'-'",
	"'*'",
	"'/'",
	"'%'",
	"'.'",
	"'?'",
	"'['",
	"';'",
	"':'",
	"'('",
	"')'",
	"']'",
	"'{'",
	"'}'",
}

var yyStatenames = [...]string{}

const yyEofCode = 1
const yyErrCode = 2
const yyInitialStackSize = 16

//line parser.go.y:693

//line yacctab:1
var yyExca = [...]int16{
	-1, 1,
	1, -1,
	-2, 0,
	-1, 97,
	55, 0,
	-2, 104,
	-1, 130,
	5, 0,
	-2, 32,
	-1, 133,
	9, 0,
	-2, 35,
	-1, 194,
	58, 114,
	-2, 54,
}

const yyPrivate = 57344

const yyLast = 1127

var yyAct = [...]int16{
	86, 214, 174, 112, 12, 203, 9, 175, 111, 31,
	190, 6, 156, 140, 117, 47, 95, 97, 93, 94,
	89, 141, 49, 7, 179, 180, 181, 240, 246, 264,
	239, 103, 177, 106, 178, 227, 164, 119, 107, 108,
	105, 245, 102, 75, 76, 113, 77, 78, 79, 123,
	226, 163, 211, 225, 259, 210, 142, 179, 180, 181,
	158, 159, 143, 182, 122, 177, 224, 178, 219, 7,
	235, 234, 104, 127, 243, 128, 129, 130, 131, 132,
	133, 134, 135, 136, 137, 138, 72, 74, 80, 81,
	82, 83, 84, 147, 73, 88, 182, 196, 73, 229,
	195, 145, 7, 150, 228, 161, 166, 165, 157, 126,
	125, 124, 144, 88, 258, 167, 80, 81, 82, 83,
	84, 206, 73, 44, 242, 91, 90, 92, 183, 184,
	82, 83, 84, 154, 73, 153, 267, 186, 49, 173,
	42, 43, 100, 91, 90, 92, 99, 191, 120, 197,
	256, 257, 200, 192, 201, 202, 188, 75, 76, 207,
	77, 78, 79, 198, 199, 209, 42, 43, 216, 92,
	215, 215, 218, 213, 113, 98, 75, 76, 185, 77,
	78, 79, 204, 205, 101, 221, 222, 170, 155, 171,
	169, 3, 28, 27, 230, 96, 220, 232, 176, 46,
	223, 11, 80, 81, 82, 83, 84, 11, 73, 78,
	79, 157, 241, 110, 8, 152, 237, 255, 236, 72,
	74, 80, 81, 82, 83, 84, 85, 73, 79, 278,
	160, 191, 277, 121, 189, 253, 254, 192, 248, 247,
	187, 139, 249, 250, 208, 262, 260, 261, 215, 263,
	80, 81, 82, 83, 84, 149, 73, 268, 269, 10,
	270, 5, 4, 2, 1, 88, 272, 273, 80, 81,
	82, 83, 84, 0, 73, 279, 0, 0, 271, 280,
	51, 52, 0, 53, 54, 55, 56, 57, 58, 59,
	60, 61, 62, 115, 116, 91, 90, 92, 0, 0,
	42, 43, 0, 87, 63, 64, 65, 66, 67, 68,
	69, 70, 71, 88, 0, 20, 0, 17, 37, 24,
	25, 26, 38, 40, 39, 41, 23, 29, 30, 42,
	43, 0, 114, 15, 0, 0, 212, 0, 16, 0,
	13, 14, 22, 91, 90, 92, 0, 0, 0, 0,
	0, 33, 34, 0, 0, 0, 21, 0, 36, 0,
	148, 32, 0, 146, 35, 51, 52, 0, 53, 54,
	55, 56, 57, 58, 59, 60, 61, 62, 115, 116,
	0, 0, 0, 0, 0, 42, 43, 0, 0, 63,
	64, 65, 66, 67, 68, 69, 70, 71, 18, 19,
	20, 0, 17, 37, 24, 25, 26, 38, 40, 39,
	41, 23, 29, 30, 42, 43, 0, 114, 15, 0,
	0, 109, 0, 16, 0, 13, 14, 22, 0, 0,
	0, 0, 0, 0, 0, 0, 33, 34, 0, 0,
	0, 21, 0, 36, 0, 0, 32, 0, 20, 35,
	17, 37, 24, 25, 26, 38, 40, 39, 41, 23,
	29, 30, 42, 43, 0, 0, 15, 0, 0, 0,
	0, 16, 0, 13, 14, 22, 0, 0, 0, 0,
	0, 0, 0, 0, 33, 34, 0, 0, 0, 21,
	0, 36, 0, 0, 32, 0, 231, 35, 20, 0,
	17, 37, 24, 25, 26, 38, 40, 39, 41, 23,
	29, 30, 42, 43, 0, 0, 15, 0, 0, 0,
	0, 16, 0, 13, 14, 22, 0, 0, 0, 0,
	0, 0, 0, 0, 33, 34, 0, 0, 0, 21,
	0, 36, 0, 0, 32, 0, 118, 35, 20, 0,
	17, 37, 24, 25, 26, 38, 40, 39, 41, 23,
	29, 30, 42, 43, 0, 0, 15, 0, 77, 78,
	79, 16, 0, 13, 14, 22, 0, 0, 0, 0,
	0, 0, 0, 0, 33, 34, 0, 0, 0, 21,
	0, 36, 0, 0, 32, 51, 52, 35, 53, 54,
	55, 56, 57, 58, 59, 60, 61, 62, 48, 0,
	80, 81, 82, 83, 84, 50, 73, 0, 0, 63,
	64, 65, 66, 67, 68, 69, 70, 71, 51, 52,
	0, 53, 54, 55, 56, 57, 58, 59, 60, 61,
	62, 48, 0, 0, 0, 0, 0, 0, 50, 0,
	0, 172, 63, 64, 65, 66, 67, 68, 69, 70,
	71, 51, 52, 0, 53, 54, 55, 56, 57, 58,
	59, 60, 61, 62, 115, 194, 0, 0, 0, 0,
	0, 42, 43, 0, 45, 63, 64, 65, 66, 67,
	68, 69, 70, 71, 37, 24, 25, 26, 38, 40,
	39, 41, 23, 29, 30, 42, 43, 75, 76, 0,
	77, 78, 79, 193, 0, 0, 0, 0, 22, 0,
	0, 0, 0, 0, 0, 0, 0, 33, 34, 0,
	0, 0, 21, 0, 36, 0, 0, 32, 75, 76,
	35, 77, 78, 79, 0, 0, 0, 0, 0, 0,
	72, 74, 80, 81, 82, 83, 84, 0, 73, 0,
	0, 0, 75, 76, 252, 77, 78, 79, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 72, 74, 80, 81, 82, 83, 84, 0, 73,
	0, 0, 0, 75, 76, 233, 77, 78, 79, 0,
	0, 0, 0, 0, 0, 72, 74, 80, 81, 82,
	83, 84, 0, 73, 0, 0, 0, 75, 76, 168,
	77, 78, 79, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 72, 74, 80, 81,
	82, 83, 84, 0, 73, 0, 0, 75, 76, 281,
	77, 78, 79, 0, 0, 0, 0, 0, 0, 0,
	72, 74, 80, 81, 82, 83, 84, 0, 73, 0,
	0, 75, 76, 276, 77, 78, 79, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	72, 74, 80, 81, 82, 83, 84, 0, 73, 0,
	0, 75, 76, 251, 77, 78, 79, 0, 0, 0,
	0, 0, 0, 0, 72, 74, 80, 81, 82, 83,
	84, 0, 73, 0, 0, 75, 76, 244, 77, 78,
	79, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 72, 74, 80, 81, 82, 83,
	84, 0, 73, 0, 0, 75, 76, 217, 77, 78,
	79, 0, 0, 0, 0, 0, 0, 0, 72, 74,
	80, 81, 82, 83, 84, 0, 73, 0, 0, 75,
	76, 162, 77, 78, 79, 0, 0, 0, 0, 0,
	75, 76, 0, 77, 78, 79, 0, 0, 72, 74,
	80, 81, 82, 83, 84, 0, 73, 0, 275, 75,
	76, 0, 77, 78, 79, 0, 0, 0, 0, 0,
	0, 0, 72, 74, 80, 81, 82, 83, 84, 0,
	73, 0, 266, 72, 74, 80, 81, 82, 83, 84,
	0, 73, 0, 265, 75, 76, 0, 77, 78, 79,
	0, 0, 72, 74, 80, 81, 82, 83, 84, 0,
	73, 0, 238, 0, 0, 0, 75, 76, 0, 77,
	78, 79, 274, 0, 0, 75, 76, 0, 77, 78,
	79, 0, 0, 0, 0, 0, 0, 72, 74, 80,
	81, 82, 83, 84, 151, 73, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 72,
	74, 80, 81, 82, 83, 84, 0, 73, 72, 74,
	80, 81, 82, 83, 84, 0, 73,
}

var yyPact = [...]int16{
	181, -1000, -1000, -39, -1000, 387, 66, 621, -1000, 1071,
	-1000, 535, 289, 678, 678, 535, 535, 154, 119, 115,
	164, 113, -1000, -1000, -1000, -1000, -1000, 13, -1000, -1000,
	139, -1000, 535, 678, 678, 358, 485, 127, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, 1, -1000, 53, 52,
	51, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, 535, -1000, 535, 535, 535, 535, 535, 535,
	535, 535, 535, 535, 535, -1000, 1071, 0, -1000, -1000,
	-1000, 113, 302, 241, 89, 1062, 535, 98, 86, 174,
	-39, 2, -1000, -1000, 535, -1000, 921, 71, 71, -1000,
	-12, -1000, 49, 48, 535, -1000, -1000, -1000, -1000, 758,
	-1000, 160, -1000, 588, 40, 40, 40, 1071, 153, 153,
	561, 201, 219, 67, 79, 79, 43, 43, 43, 131,
	-1000, -1000, 0, 654, -1000, -1000, -1000, 39, 535, 0,
	0, 535, -1000, 535, 535, 162, 64, -1000, 535, 162,
	-5, 1071, -1000, -1000, 273, 678, 678, 897, -1000, -1000,
	-1000, 535, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, 7, -1000, -1000, 535, 0, 5, -1000, -13,
	-1000, 46, 41, 535, -1000, -1000, 435, 734, 12, 11,
	1071, -1000, 1071, -39, -1000, -1000, -1000, 1005, -30, -1000,
	-1000, 535, -1000, -1000, 77, 71, 77, 16, 867, -1000,
	-20, -1000, 1071, -1000, -1000, 0, -1000, 654, 0, 0,
	843, -1000, 703, -1000, 535, 535, 117, 57, -1000, -4,
	162, 1071, 678, 678, -1000, -1000, 40, -1000, -1000, -1000,
	-1000, -29, -1000, 986, 975, 101, 535, 535, -1000, 535,
	-1000, 71, 77, -1000, 0, 535, 535, -1000, 1040, 1071,
	951, -1000, 813, 172, 535, -1000, -1000, -1000, 535, 1071,
	789, -1000,
}

var yyPgo = [...]int16{
	0, 264, 263, 262, 261, 259, 12, 214, 195, 244,
	0, 241, 13, 240, 234, 10, 4, 9, 233, 20,
	230, 218, 217, 215, 213, 8, 1, 2, 7, 199,
	15, 198, 196, 5, 193, 192, 14, 3,
}

var yyR1 = [...]int8{
	0, 1, 2, 2, 3, 3, 4, 4, 5, 5,
	6, 6, 7, 7, 8, 8, 9, 9, 33, 33,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
	10, 10, 11, 11, 12, 12, 12, 13, 13, 14,
	14, 15, 15, 15, 15, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 16, 16, 17, 17, 18, 18, 18, 34,
	34, 35, 35, 19, 19, 19, 19, 19, 20, 20,
	21, 21, 22, 22, 23, 23, 24, 24, 25, 25,
	25, 25, 25, 37, 37, 37, 26, 26, 27, 27,
	27, 27, 27, 27, 27, 28, 28, 28, 29, 29,
	30, 30, 30, 31, 31, 32, 32, 36, 36, 36,
	36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
	36, 36, 36, 36, 36, 36, 36, 36,
}

var yyR2 = [...]int8{
	0, 2, 0, 3, 2, 2, 0, 2, 6, 4,
	0, 1, 0, 2, 5, 8, 1, 3, 1, 1,
	2, 3, 5, 9, 9, 11, 7, 3, 4, 2,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 1, 1, 3, 1, 3, 3, 1, 3, 1,
	3, 3, 3, 5, 1, 1, 1, 1, 2, 2,
	1, 1, 1, 1, 4, 1, 1, 1, 2, 1,
	3, 2, 2, 2, 3, 4, 2, 3, 2, 2,
	2, 2, 3, 3, 1, 3, 0, 2, 4, 1,
	1, 1, 1, 2, 3, 4, 4, 5, 1, 3,
	0, 5, 0, 2, 0, 2, 1, 3, 3, 3,
	5, 1, 1, 1, 1, 1, 1, 3, 1, 1,
	1, 1, 1, 1, 1, 2, 3, 4, 1, 3,
	3, 3, 3, 2, 3, 1, 3, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
}

var yyChk = [...]int16{
	-1000, -1, -2, 10, -3, -4, -28, 62, -7, -10,
	-5, -8, -16, 38, 39, 31, 36, 15, 11, 12,
	13, 54, 40, 24, 17, 18, 19, -34, -35, 25,
	26, -17, 59, 49, 50, 62, 56, 16, 20, 22,
	21, 23, 27, 28, 57, 63, -29, -30, 20, -36,
	27, 7, 8, 10, 11, 12, 13, 14, 15, 16,
	17, 18, 19, 31, 32, 33, 34, 35, 36, 37,
	38, 39, 47, 55, 48, 4, 5, 7, 8, 9,
	49, 50, 51, 52, 53, -7, -10, 14, 24, -19,
	55, 54, 56, -16, -16, -10, -8, -10, 21, 27,
	27, 20, -19, -17, 59, -17, -10, -16, -16, 63,
	-24, -25, -37, -17, 59, 20, 21, -36, 61, -10,
	21, -18, 63, 48, 58, 58, 58, -10, -10, -10,
	-10, -10, -10, -10, -10, -10, -10, -10, -10, -11,
	-12, 21, 56, 62, -19, -17, 61, -10, 58, 14,
	14, 32, -23, 37, 47, 14, -6, -28, 58, 59,
	-20, -10, 60, 63, 48, 58, 58, -10, 61, 30,
	27, 29, 63, -30, -27, -28, -31, 25, 27, 17,
	18, 19, 56, -27, -27, 47, 6, -13, -12, -14,
	-15, -37, -17, 59, 21, 61, 58, -10, -12, -12,
	-10, -10, -10, -33, 20, 21, 57, -10, -9, -33,
	60, 57, 63, -25, -26, -16, -26, 60, -10, 61,
	-32, -27, -10, -12, 61, 48, 63, 48, 58, 58,
	-10, 61, -10, 61, 59, 59, -21, -6, 57, 60,
	57, -10, 47, 58, 60, 61, 48, -12, -15, -12,
	-12, 60, 61, -10, -10, -22, 33, 34, 57, 58,
	-33, -16, -26, -27, 58, 57, 57, 35, -10, -10,
	-10, -12, -10, -10, 32, 57, 60, 60, 57, -10,
	-10, 60,
}

var yyDef = [...]int16{
	2, -2, 6, 0, 1, 12, 0, 0, 4, 5,
	7, 12, 41, 0, 0, 0, 0, 0, 0, 0,
	0, 55, 56, 57, 60, 61, 62, 63, 65, 66,
	67, 69, 0, 0, 0, 0, 0, 0, 89, 90,
	91, 92, 84, 86, 3, 125, 0, 128, 0, 0,
	0, 137, 138, 139, 140, 141, 142, 143, 144, 145,
	146, 147, 148, 149, 150, 151, 152, 153, 154, 155,
	156, 157, 0, 29, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 13, 20, 0, 79, 80,
	81, 0, 0, 0, 0, 0, 0, -2, 0, 0,
	10, 0, 58, 59, 0, 68, 0, 71, 72, 73,
	0, 106, 111, 112, 0, 113, 114, 115, 76, 0,
	78, 0, 126, 0, 0, 0, 0, 21, 30, 31,
	-2, 33, 34, -2, 36, 37, 38, 39, 40, 0,
	42, 44, 0, 0, 82, 83, 93, 0, 0, 0,
	0, 0, 27, 0, 0, 0, 0, 11, 0, 0,
	0, 98, 70, 74, 0, 0, 0, 0, 77, 85,
	87, 0, 127, 129, 130, 118, 119, 120, 121, 122,
	123, 124, 0, 131, 132, 0, 0, 0, 47, 0,
	49, 0, 0, 0, -2, 94, 0, 0, 0, 0,
	100, 105, 28, 10, 18, 19, 9, 0, 0, 16,
	64, 0, 75, 107, 108, 116, 109, 0, 0, 133,
	0, 135, 22, 43, 45, 0, 46, 0, 0, 0,
	0, 95, 0, 96, 0, 0, 102, 0, 14, 0,
	0, 99, 0, 0, 88, 134, 0, 48, 50, 51,
	52, 0, 97, 0, 0, 0, 0, 0, 8, 0,
	17, 117, 110, 136, 0, 0, 0, 26, 0, 103,
	0, 53, 0, 0, 0, 15, 23, 24, 0, 101,
	0, 25,
}

var yyTok1 = [...]int8{
	1, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 53, 3, 3,
	59, 60, 51, 49, 48, 50, 54, 52, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 58, 57,
	3, 3, 3, 55, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 56, 3, 61, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 62, 47, 63,
}

var yyTok2 = [...]int8{
	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46,
}

var yyTok3 = [...]int8{
	0,
}

var yyErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{}

//line yaccpar:1

/*	parser for yacc output	*/

var (
	yyDebug        = 0
	yyErrorVerbose = false
)

type yyLexer interface {
	Lex(lval *yySymType) int
	Error(s string)
}

type yyParser interface {
	Parse(yyLexer) int
	Lookahead() int
}

type yyParserImpl struct {
	lval  yySymType
	stack [yyInitialStackSize]yySymType
	char  int
}

func (p *yyParserImpl) Lookahead() int {
	return p.char
}

func yyNewParser() yyParser {
	return &yyParserImpl{}
}

const yyFlag = -1000

func yyTokname(c int) string {
	if c >= 1 && c-1 < len(yyToknames) {
		if yyToknames[c-1] != "" {
			return yyToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func yyStatname(s int) string {
	if s >= 0 && s < len(yyStatenames) {
		if yyStatenames[s] != "" {
			return yyStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func yyErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !yyErrorVerbose {
		return "syntax error"
	}

	for _, e := range yyErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + yyTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := int(yyPact[state])
	for tok := TOKSTART; tok-1 < len(yyToknames); tok++ {
		if n := base + tok; n >= 0 && n < yyLast && int(yyChk[int(yyAct[n])]) == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if yyDef[state] == -2 {
		i := 0
		for yyExca[i] != -1 || int(yyExca[i+1]) != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; yyExca[i] >= 0; i += 2 {
			tok := int(yyExca[i])
			if tok < TOKSTART || yyExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if yyExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += yyTokname(tok)
	}
	return res
}

func yylex1(lex yyLexer, lval *yySymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = int(yyTok1[0])
		goto out
	}
	if char < len(yyTok1) {
		token = int(yyTok1[char])
		goto out
	}
	if char >= yyPrivate {
		if char < yyPrivate+len(yyTok2) {
			token = int(yyTok2[char-yyPrivate])
			goto out
		}
	}
	for i := 0; i < len(yyTok3); i += 2 {
		token = int(yyTok3[i+0])
		if token == char {
			token = int(yyTok3[i+1])
			goto out
		}
	}

out:
	if token == 0 {
		token = int(yyTok2[1]) /* unknown char */
	}
	if yyDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", yyTokname(token), uint(char))
	}
	return char, token
}

func yyParse(yylex yyLexer) int {
	return yyNewParser().Parse(yylex)
}

func (yyrcvr *yyParserImpl) Parse(yylex yyLexer) int {
	var yyn int
	var yyVAL yySymType
	var yyDollar []yySymType
	_ = yyDollar // silence set and not used
	yyS := yyrcvr.stack[:]

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	yystate := 0
	yyrcvr.char = -1
	yytoken := -1 // yyrcvr.char translated into internal numbering
	defer func() {
		// Make sure we report no lookahead when not parsing.
		yystate = -1
		yyrcvr.char = -1
		yytoken = -1
	}()
	yyp := -1
	goto yystack

ret0:
	return 0

ret1:
	return 1

yystack:
	/* put a state and value onto the stack */
	if yyDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", yyTokname(yytoken), yyStatname(yystate))
	}

	yyp++
	if yyp >= len(yyS) {
		nyys := make([]yySymType, len(yyS)*2)
		copy(nyys, yyS)
		yyS = nyys
	}
	yyS[yyp] = yyVAL
	yyS[yyp].yys = yystate

yynewstate:
	yyn = int(yyPact[yystate])
	if yyn <= yyFlag {
		goto yydefault /* simple state */
	}
	if yyrcvr.char < 0 {
		yyrcvr.char, yytoken = yylex1(yylex, &yyrcvr.lval)
	}
	yyn += yytoken
	if yyn < 0 || yyn >= yyLast {
		goto yydefault
	}
	yyn = int(yyAct[yyn])
	if int(yyChk[yyn]) == yytoken { /* valid shift */
		yyrcvr.char = -1
		yytoken = -1
		yyVAL = yyrcvr.lval
		yystate = yyn
		if Errflag > 0 {
			Errflag--
		}
		goto yystack
	}

yydefault:
	/* default state action */
	yyn = int(yyDef[yystate])
	if yyn == -2 {
		if yyrcvr.char < 0 {
			yyrcvr.char, yytoken = yylex1(yylex, &yyrcvr.lval)
		}

		/* look through exception table */
		xi := 0
		for {
			if yyExca[xi+0] == -1 && int(yyExca[xi+1]) == yystate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			yyn = int(yyExca[xi+0])
			if yyn < 0 || yyn == yytoken {
				break
			}
		}
		yyn = int(yyExca[xi+1])
		if yyn < 0 {
			goto ret0
		}
	}
	if yyn == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			yylex.Error(yyErrorMessage(yystate, yytoken))
			Nerrs++
			if yyDebug >= 1 {
				__yyfmt__.Printf("%s", yyStatname(yystate))
				__yyfmt__.Printf(" saw %s\n", yyTokname(yytoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for yyp >= 0 {
				yyn = int(yyPact[yyS[yyp].yys]) + yyErrCode
				if yyn >= 0 && yyn < yyLast {
					yystate = int(yyAct[yyn]) /* simulate a shift of "error" */
					if int(yyChk[yystate]) == yyErrCode {
						goto yystack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if yyDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", yyS[yyp].yys)
				}
				yyp--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if yyDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", yyTokname(yytoken))
			}
			if yytoken == yyEofCode {
				goto ret1
			}
			yyrcvr.char = -1
			yytoken = -1
			goto yynewstate /* try again in the same state */
		}
	}

	/* reduction by production yyn */
	if yyDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", yyn, yyStatname(yystate))
	}

	yynt := yyn
	yypt := yyp
	_ = yypt // guard against "declared and not used"

	yyp -= int(yyR2[yyn])
	// yyp is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if yyp+1 >= len(yyS) {
		nyys := make([]yySymType, len(yyS)*2)
		copy(nyys, yyS)
		yyS = nyys
	}
	yyVAL = yyS[yyp+1]

	/* consult goto table to find next state */
	yyn = int(yyR1[yyn])
	yyg := int(yyPgo[yyn])
	yyj := yyg + yyS[yyp].yys + 1

	if yyj >= yyLast {
		yystate = int(yyAct[yyg])
	} else {
		yystate = int(yyAct[yyj])
		if int(yyChk[yystate]) != -yyn {
			yystate = int(yyAct[yyg])
		}
	}
	// dummy call; replaced with literal code
	switch yynt {

	case 1:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:73
		{
			if yyDollar[1].value != nil {
				yyDollar[2].value.(*Query).Meta = yyDollar[1].value.(*ConstObject)
			}
			yylex.(*lexer).result = yyDollar[2].value.(*Query)
		}
	case 2:
		yyDollar = yyS[yypt-0 : yypt+1]
//line parser.go.y:80
		{
			yyVAL.value = nil
		}
	case 3:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:84
		{
			yyVAL.value = yyDollar[2].value
		}
	case 4:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:90
		{
			yyVAL.value = &Query{Imports: yyDollar[1].value.([]*Import), FuncDefs: reverseFuncDef(yyDollar[2].value.([]*FuncDef)), Term: &Term{Type: TermTypeIdentity}}
		}
	case 5:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:94
		{
			if yyDollar[1].value != nil {
				yyDollar[2].value.(*Query).Imports = yyDollar[1].value.([]*Import)
			}
			yyVAL.value = yyDollar[2].value
		}
	case 6:
		yyDollar = yyS[yypt-0 : yypt+1]
//line parser.go.y:101
		{
			yyVAL.value = []*Import(nil)
		}
	case 7:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:105
		{
			yyVAL.value = append(yyDollar[1].value.([]*Import), yyDollar[2].value.(*Import))
		}
	case 8:
		yyDollar = yyS[yypt-6 : yypt+1]
//line parser.go.y:111
		{
			yyVAL.value = &Import{ImportPath: yyDollar[2].token, ImportAlias: yyDollar[4].token, Meta: yyDollar[5].value.(*ConstObject)}
		}
	case 9:
		yyDollar = yyS[yypt-4 : yypt+1]
//line parser.go.y:115
		{
			yyVAL.value = &Import{IncludePath: yyDollar[2].token, Meta: yyDollar[3].value.(*ConstObject)}
		}
	case 10:
		yyDollar = yyS[yypt-0 : yypt+1]
//line parser.go.y:121
		{
			yyVAL.value = (*ConstObject)(nil)
		}
	case 11:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:124
		{
		}
	case 12:
		yyDollar = yyS[yypt-0 : yypt+1]
//line parser.go.y:128
		{
			yyVAL.value = []*FuncDef(nil)
		}
	case 13:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:132
		{
			yyVAL.value = append(yyDollar[2].value.([]*FuncDef), yyDollar[1].value.(*FuncDef))
		}
	case 14:
		yyDollar = yyS[yypt-5 : yypt+1]
//line parser.go.y:138
		{
			yyVAL.value = &FuncDef{Name: yyDollar[2].token, Body: yyDollar[4].value.(*Query)}
		}
	case 15:
		yyDollar = yyS[yypt-8 : yypt+1]
//line parser.go.y:142
		{
			yyVAL.value = &FuncDef{yyDollar[2].token, yyDollar[4].value.([]string), yyDollar[7].value.(*Query)}
		}
	case 16:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:148
		{
			yyVAL.value = []string{yyDollar[1].token}
		}
	case 17:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:152
		{
			yyVAL.value = append(yyDollar[1].value.([]string), yyDollar[3].token)
		}
	case 18:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:157
		{
		}
	case 19:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:158
		{
		}
	case 20:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:162
		{
			yyDollar[2].value.(*Query).FuncDefs = prependFuncDef(yyDollar[2].value.(*Query).FuncDefs, yyDollar[1].value.(*FuncDef))
			yyVAL.value = yyDollar[2].value
		}
	case 21:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:167
		{
			yyVAL.value = &Query{Left: yyDollar[1].value.(*Query), Op: OpPipe, Right: yyDollar[3].value.(*Query)}
		}
	case 22:
		yyDollar = yyS[yypt-5 : yypt+1]
//line parser.go.y:171
		{
			yyDollar[1].value.(*Term).SuffixList = append(yyDollar[1].value.(*Term).SuffixList, &Suffix{Bind: &Bind{yyDollar[3].value.([]*Pattern), yyDollar[5].value.(*Query)}})
			yyVAL.value = &Query{Term: yyDollar[1].value.(*Term)}
		}
	case 23:
		yyDollar = yyS[yypt-9 : yypt+1]
//line parser.go.y:176
		{
			yyVAL.value = &Query{Term: &Term{Type: TermTypeReduce, Reduce: &Reduce{yyDollar[2].value.(*Term), yyDollar[4].value.(*Pattern), yyDollar[6].value.(*Query), yyDollar[8].value.(*Query)}}}
		}
	case 24:
		yyDollar = yyS[yypt-9 : yypt+1]
//line parser.go.y:180
		{
			yyVAL.value = &Query{Term: &Term{Type: TermTypeForeach, Foreach: &Foreach{yyDollar[2].value.(*Term), yyDollar[4].value.(*Pattern), yyDollar[6].value.(*Query), yyDollar[8].value.(*Query), nil}}}
		}
	case 25:
		yyDollar = yyS[yypt-11 : yypt+1]
//line parser.go.y:184
		{
			yyVAL.value = &Query{Term: &Term{Type: TermTypeForeach, Foreach: &Foreach{yyDollar[2].value.(*Term), yyDollar[4].value.(*Pattern), yyDollar[6].value.(*Query), yyDollar[8].value.(*Query), yyDollar[10].value.(*Query)}}}
		}
	case 26:
		yyDollar = yyS[yypt-7 : yypt+1]
//line parser.go.y:188
		{
			yyVAL.value = &Query{Term: &Term{Type: TermTypeIf, If: &If{yyDollar[2].value.(*Query), yyDollar[4].value.(*Query), yyDollar[5].value.([]*IfElif), yyDollar[6].value.(*Query)}}}
		}
	case 27:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:192
		{
			yyVAL.value = &Query{Term: &Term{Type: TermTypeTry, Try: &Try{yyDollar[2].value.(*Query), yyDollar[3].value.(*Query)}}}
		}
	case 28:
		yyDollar = yyS[yypt-4 : yypt+1]
//line parser.go.y:196
		{
			yyVAL.value = &Query{Term: &Term{Type: TermTypeLabel, Label: &Label{yyDollar[2].token, yyDollar[4].value.(*Query)}}}
		}
	case 29:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:200
		{
			if t := yyDollar[1].value.(*Query).Term; t != nil {
				t.SuffixList = append(t.SuffixList, &Suffix{Optional: true})
			} else {
				yyVAL.value = &Query{Term: &Term{Type: TermTypeQuery, Query: yyDollar[1].value.(*Query), SuffixList: []*Suffix{{Optional: true}}}}
			}
		}
	case 30:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:208
		{
			yyVAL.value = &Query{Left: yyDollar[1].value.(*Query), Op: OpComma, Right: yyDollar[3].value.(*Query)}
		}
	case 31:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:212
		{
			yyVAL.value = &Query{Left: yyDollar[1].value.(*Query), Op: yyDollar[2].operator, Right: yyDollar[3].value.(*Query)}
		}
	case 32:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:216
		{
			yyVAL.value = &Query{Left: yyDollar[1].value.(*Query), Op: yyDollar[2].operator, Right: yyDollar[3].value.(*Query)}
		}
	case 33:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:220
		{
			yyVAL.value = &Query{Left: yyDollar[1].value.(*Query), Op: OpOr, Right: yyDollar[3].value.(*Query)}
		}
	case 34:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:224
		{
			yyVAL.value = &Query{Left: yyDollar[1].value.(*Query), Op: OpAnd, Right: yyDollar[3].value.(*Query)}
		}
	case 35:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:228
		{
			yyVAL.value = &Query{Left: yyDollar[1].value.(*Query), Op: yyDollar[2].operator, Right: yyDollar[3].value.(*Query)}
		}
	case 36:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:232
		{
			yyVAL.value = &Query{Left: yyDollar[1].value.(*Query), Op: OpAdd, Right: yyDollar[3].value.(*Query)}
		}
	case 37:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:236
		{
			yyVAL.value = &Query{Left: yyDollar[1].value.(*Query), Op: OpSub, Right: yyDollar[3].value.(*Query)}
		}
	case 38:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:240
		{
			yyVAL.value = &Query{Left: yyDollar[1].value.(*Query), Op: OpMul, Right: yyDollar[3].value.(*Query)}
		}
	case 39:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:244
		{
			yyVAL.value = &Query{Left: yyDollar[1].value.(*Query), Op: OpDiv, Right: yyDollar[3].value.(*Query)}
		}
	case 40:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:248
		{
			yyVAL.value = &Query{Left: yyDollar[1].value.(*Query), Op: OpMod, Right: yyDollar[3].value.(*Query)}
		}
	case 41:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:252
		{
			yyVAL.value = &Query{Term: yyDollar[1].value.(*Term)}
		}
	case 42:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:258
		{
			yyVAL.value = []*Pattern{yyDollar[1].value.(*Pattern)}
		}
	case 43:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:262
		{
			yyVAL.value = append(yyDollar[1].value.([]*Pattern), yyDollar[3].value.(*Pattern))
		}
	case 44:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:268
		{
			yyVAL.value = &Pattern{Name: yyDollar[1].token}
		}
	case 45:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:272
		{
			yyVAL.value = &Pattern{Array: yyDollar[2].value.([]*Pattern)}
		}
	case 46:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:276
		{
			yyVAL.value = &Pattern{Object: yyDollar[2].value.([]*PatternObject)}
		}
	case 47:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:282
		{
			yyVAL.value = []*Pattern{yyDollar[1].value.(*Pattern)}
		}
	case 48:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:286
		{
			yyVAL.value = append(yyDollar[1].value.([]*Pattern), yyDollar[3].value.(*Pattern))
		}
	case 49:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:292
		{
			yyVAL.value = []*PatternObject{yyDollar[1].value.(*PatternObject)}
		}
	case 50:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:296
		{
			yyVAL.value = append(yyDollar[1].value.([]*PatternObject), yyDollar[3].value.(*PatternObject))
		}
	case 51:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:302
		{
			yyVAL.value = &PatternObject{Key: yyDollar[1].token, Val: yyDollar[3].value.(*Pattern)}
		}
	case 52:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:306
		{
			yyVAL.value = &PatternObject{KeyString: yyDollar[1].value.(*String), Val: yyDollar[3].value.(*Pattern)}
		}
	case 53:
		yyDollar = yyS[yypt-5 : yypt+1]
//line parser.go.y:310
		{
			yyVAL.value = &PatternObject{KeyQuery: yyDollar[2].value.(*Query), Val: yyDollar[5].value.(*Pattern)}
		}
	case 54:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:314
		{
			yyVAL.value = &PatternObject{Key: yyDollar[1].token}
		}
	case 55:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:320
		{
			yyVAL.value = &Term{Type: TermTypeIdentity}
		}
	case 56:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:324
		{
			yyVAL.value = &Term{Type: TermTypeRecurse}
		}
	case 57:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:328
		{
			yyVAL.value = &Term{Type: TermTypeIndex, Index: &Index{Name: yyDollar[1].token}}
		}
	case 58:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:332
		{
			if yyDollar[2].value.(*Suffix).Iter {
				yyVAL.value = &Term{Type: TermTypeIdentity, SuffixList: []*Suffix{yyDollar[2].value.(*Suffix)}}
			} else {
				yyVAL.value = &Term{Type: TermTypeIndex, Index: yyDollar[2].value.(*Suffix).Index}
			}
		}
	case 59:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:340
		{
			yyVAL.value = &Term{Type: TermTypeIndex, Index: &Index{Str: yyDollar[2].value.(*String)}}
		}
	case 60:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:344
		{
			yyVAL.value = &Term{Type: TermTypeNull}
		}
	case 61:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:348
		{
			yyVAL.value = &Term{Type: TermTypeTrue}
		}
	case 62:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:352
		{
			yyVAL.value = &Term{Type: TermTypeFalse}
		}
	case 63:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:356
		{
			yyVAL.value = &Term{Type: TermTypeFunc, Func: &Func{Name: yyDollar[1].token}}
		}
	case 64:
		yyDollar = yyS[yypt-4 : yypt+1]
//line parser.go.y:360
		{
			yyVAL.value = &Term{Type: TermTypeFunc, Func: &Func{Name: yyDollar[1].token, Args: yyDollar[3].value.([]*Query)}}
		}
	case 65:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:364
		{
			yyVAL.value = &Term{Type: TermTypeFunc, Func: &Func{Name: yyDollar[1].token}}
		}
	case 66:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:368
		{
			yyVAL.value = &Term{Type: TermTypeNumber, Number: yyDollar[1].token}
		}
	case 67:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:372
		{
			yyVAL.value = &Term{Type: TermTypeFormat, Format: yyDollar[1].token}
		}
	case 68:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:376
		{
			yyVAL.value = &Term{Type: TermTypeFormat, Format: yyDollar[1].token, Str: yyDollar[2].value.(*String)}
		}
	case 69:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:380
		{
			yyVAL.value = &Term{Type: TermTypeString, Str: yyDollar[1].value.(*String)}
		}
	case 70:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:384
		{
			yyVAL.value = &Term{Type: TermTypeQuery, Query: yyDollar[2].value.(*Query)}
		}
	case 71:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:388
		{
			yyVAL.value = &Term{Type: TermTypeUnary, Unary: &Unary{OpAdd, yyDollar[2].value.(*Term)}}
		}
	case 72:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:392
		{
			yyVAL.value = &Term{Type: TermTypeUnary, Unary: &Unary{OpSub, yyDollar[2].value.(*Term)}}
		}
	case 73:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:396
		{
			yyVAL.value = &Term{Type: TermTypeObject, Object: &Object{}}
		}
	case 74:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:400
		{
			yyVAL.value = &Term{Type: TermTypeObject, Object: &Object{yyDollar[2].value.([]*ObjectKeyVal)}}
		}
	case 75:
		yyDollar = yyS[yypt-4 : yypt+1]
//line parser.go.y:404
		{
			yyVAL.value = &Term{Type: TermTypeObject, Object: &Object{yyDollar[2].value.([]*ObjectKeyVal)}}
		}
	case 76:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:408
		{
			yyVAL.value = &Term{Type: TermTypeArray, Array: &Array{}}
		}
	case 77:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:412
		{
			yyVAL.value = &Term{Type: TermTypeArray, Array: &Array{yyDollar[2].value.(*Query)}}
		}
	case 78:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:416
		{
			yyVAL.value = &Term{Type: TermTypeBreak, Break: yyDollar[2].token}
		}
	case 79:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:420
		{
			yyDollar[1].value.(*Term).SuffixList = append(yyDollar[1].value.(*Term).SuffixList, &Suffix{Index: &Index{Name: yyDollar[2].token}})
		}
	case 80:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:424
		{
			yyDollar[1].value.(*Term).SuffixList = append(yyDollar[1].value.(*Term).SuffixList, yyDollar[2].value.(*Suffix))
		}
	case 81:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:428
		{
			yyDollar[1].value.(*Term).SuffixList = append(yyDollar[1].value.(*Term).SuffixList, &Suffix{Optional: true})
		}
	case 82:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:432
		{
			yyDollar[1].value.(*Term).SuffixList = append(yyDollar[1].value.(*Term).SuffixList, yyDollar[3].value.(*Suffix))
		}
	case 83:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:436
		{
			yyDollar[1].value.(*Term).SuffixList = append(yyDollar[1].value.(*Term).SuffixList, &Suffix{Index: &Index{Str: yyDollar[3].value.(*String)}})
		}
	case 84:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:442
		{
			yyVAL.value = &String{Str: yyDollar[1].token}
		}
	case 85:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:446
		{
			yyVAL.value = &String{Queries: yyDollar[2].value.([]*Query)}
		}
	case 86:
		yyDollar = yyS[yypt-0 : yypt+1]
//line parser.go.y:452
		{
			yyVAL.value = []*Query{}
		}
	case 87:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:456
		{
			yyVAL.value = append(yyDollar[1].value.([]*Query), &Query{Term: &Term{Type: TermTypeString, Str: &String{Str: yyDollar[2].token}}})
		}
	case 88:
		yyDollar = yyS[yypt-4 : yypt+1]
//line parser.go.y:460
		{
			yylex.(*lexer).inString = true
			yyVAL.value = append(yyDollar[1].value.([]*Query), &Query{Term: &Term{Type: TermTypeQuery, Query: yyDollar[3].value.(*Query)}})
		}
	case 89:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:466
		{
		}
	case 90:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:467
		{
		}
	case 91:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:470
		{
		}
	case 92:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:471
		{
		}
	case 93:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:475
		{
			yyVAL.value = &Suffix{Iter: true}
		}
	case 94:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:479
		{
			yyVAL.value = &Suffix{Index: &Index{Start: yyDollar[2].value.(*Query)}}
		}
	case 95:
		yyDollar = yyS[yypt-4 : yypt+1]
//line parser.go.y:483
		{
			yyVAL.value = &Suffix{Index: &Index{Start: yyDollar[2].value.(*Query), IsSlice: true}}
		}
	case 96:
		yyDollar = yyS[yypt-4 : yypt+1]
//line parser.go.y:487
		{
			yyVAL.value = &Suffix{Index: &Index{End: yyDollar[3].value.(*Query), IsSlice: true}}
		}
	case 97:
		yyDollar = yyS[yypt-5 : yypt+1]
//line parser.go.y:491
		{
			yyVAL.value = &Suffix{Index: &Index{Start: yyDollar[2].value.(*Query), End: yyDollar[4].value.(*Query), IsSlice: true}}
		}
	case 98:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:497
		{
			yyVAL.value = []*Query{yyDollar[1].value.(*Query)}
		}
	case 99:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:501
		{
			yyVAL.value = append(yyDollar[1].value.([]*Query), yyDollar[3].value.(*Query))
		}
	case 100:
		yyDollar = yyS[yypt-0 : yypt+1]
//line parser.go.y:507
		{
			yyVAL.value = []*IfElif(nil)
		}
	case 101:
		yyDollar = yyS[yypt-5 : yypt+1]
//line parser.go.y:511
		{
			yyVAL.value = append(yyDollar[1].value.([]*IfElif), &IfElif{yyDollar[3].value.(*Query), yyDollar[5].value.(*Query)})
		}
	case 102:
		yyDollar = yyS[yypt-0 : yypt+1]
//line parser.go.y:517
		{
			yyVAL.value = (*Query)(nil)
		}
	case 103:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:521
		{
			yyVAL.value = yyDollar[2].value
		}
	case 104:
		yyDollar = yyS[yypt-0 : yypt+1]
//line parser.go.y:527
		{
			yyVAL.value = (*Query)(nil)
		}
	case 105:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:531
		{
			yyVAL.value = yyDollar[2].value
		}
	case 106:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:537
		{
			yyVAL.value = []*ObjectKeyVal{yyDollar[1].value.(*ObjectKeyVal)}
		}
	case 107:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:541
		{
			yyVAL.value = append(yyDollar[1].value.([]*ObjectKeyVal), yyDollar[3].value.(*ObjectKeyVal))
		}
	case 108:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:547
		{
			yyVAL.value = &ObjectKeyVal{Key: yyDollar[1].token, Val: yyDollar[3].value.(*ObjectVal)}
		}
	case 109:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:551
		{
			yyVAL.value = &ObjectKeyVal{KeyString: yyDollar[1].value.(*String), Val: yyDollar[3].value.(*ObjectVal)}
		}
	case 110:
		yyDollar = yyS[yypt-5 : yypt+1]
//line parser.go.y:555
		{
			yyVAL.value = &ObjectKeyVal{KeyQuery: yyDollar[2].value.(*Query), Val: yyDollar[5].value.(*ObjectVal)}
		}
	case 111:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:559
		{
			yyVAL.value = &ObjectKeyVal{Key: yyDollar[1].token}
		}
	case 112:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:563
		{
			yyVAL.value = &ObjectKeyVal{KeyString: yyDollar[1].value.(*String)}
		}
	case 113:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:568
		{
		}
	case 114:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:569
		{
		}
	case 115:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:570
		{
		}
	case 116:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:574
		{
			yyVAL.value = &ObjectVal{[]*Query{{Term: yyDollar[1].value.(*Term)}}}
		}
	case 117:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:578
		{
			yyVAL.value = &ObjectVal{append(yyDollar[1].value.(*ObjectVal).Queries, &Query{Term: yyDollar[3].value.(*Term)})}
		}
	case 118:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:584
		{
			yyVAL.value = &ConstTerm{Object: yyDollar[1].value.(*ConstObject)}
		}
	case 119:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:588
		{
			yyVAL.value = &ConstTerm{Array: yyDollar[1].value.(*ConstArray)}
		}
	case 120:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:592
		{
			yyVAL.value = &ConstTerm{Number: yyDollar[1].token}
		}
	case 121:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:596
		{
			yyVAL.value = &ConstTerm{Str: yyDollar[1].token}
		}
	case 122:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:600
		{
			yyVAL.value = &ConstTerm{Null: true}
		}
	case 123:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:604
		{
			yyVAL.value = &ConstTerm{True: true}
		}
	case 124:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:608
		{
			yyVAL.value = &ConstTerm{False: true}
		}
	case 125:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:614
		{
			yyVAL.value = &ConstObject{}
		}
	case 126:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:618
		{
			yyVAL.value = &ConstObject{yyDollar[2].value.([]*ConstObjectKeyVal)}
		}
	case 127:
		yyDollar = yyS[yypt-4 : yypt+1]
//line parser.go.y:622
		{
			yyVAL.value = &ConstObject{yyDollar[2].value.([]*ConstObjectKeyVal)}
		}
	case 128:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:628
		{
			yyVAL.value = []*ConstObjectKeyVal{yyDollar[1].value.(*ConstObjectKeyVal)}
		}
	case 129:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:632
		{
			yyVAL.value = append(yyDollar[1].value.([]*ConstObjectKeyVal), yyDollar[3].value.(*ConstObjectKeyVal))
		}
	case 130:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:638
		{
			yyVAL.value = &ConstObjectKeyVal{Key: yyDollar[1].token, Val: yyDollar[3].value.(*ConstTerm)}
		}
	case 131:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:642
		{
			yyVAL.value = &ConstObjectKeyVal{Key: yyDollar[1].token, Val: yyDollar[3].value.(*ConstTerm)}
		}
	case 132:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:646
		{
			yyVAL.value = &ConstObjectKeyVal{KeyString: yyDollar[1].token, Val: yyDollar[3].value.(*ConstTerm)}
		}
	case 133:
		yyDollar = yyS[yypt-2 : yypt+1]
//line parser.go.y:652
		{
			yyVAL.value = &ConstArray{}
		}
	case 134:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:656
		{
			yyVAL.value = &ConstArray{yyDollar[2].value.([]*ConstTerm)}
		}
	case 135:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:662
		{
			yyVAL.value = []*ConstTerm{yyDollar[1].value.(*ConstTerm)}
		}
	case 136:
		yyDollar = yyS[yypt-3 : yypt+1]
//line parser.go.y:666
		{
			yyVAL.value = append(yyDollar[1].value.([]*ConstTerm), yyDollar[3].value.(*ConstTerm))
		}
	case 137:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:671
		{
		}
	case 138:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:672
		{
		}
	case 139:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:673
		{
		}
	case 140:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:674
		{
		}
	case 141:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:675
		{
		}
	case 142:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:676
		{
		}
	case 143:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:677
		{
		}
	case 144:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:678
		{
		}
	case 145:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:679
		{
		}
	case 146:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:680
		{
		}
	case 147:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:681
		{
		}
	case 148:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:682
		{
		}
	case 149:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:683
		{
		}
	case 150:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:684
		{
		}
	case 151:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:685
		{
		}
	case 152:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:686
		{
		}
	case 153:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:687
		{
		}
	case 154:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:688
		{
		}
	case 155:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:689
		{
		}
	case 156:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:690
		{
		}
	case 157:
		yyDollar = yyS[yypt-1 : yypt+1]
//line parser.go.y:691
		{
		}
	}
	goto yystack /* stack new state and value */
}
