// Tideland Go Library - Atom Feed
//
// Copyright (C) 2012-2015 Frank Mueller / Tideland / Oldenburg / Germany
//
// All rights reserved. Use of this source code is governed
// by the new BSD license.

// The Tideland Go Library atom package implements an atom feed client.
//
// The Atom package provides the Atom XML schema as Go types for the
// usage with the standard marshalling/unmarshalling. The supported
// format is Atom 1.0. A client allows to retrieve Atom documents.
package atom

//--------------------
// IMPORTS
//--------------------

import (
	"github.com/tideland/golib/version"
)

//--------------------
// VERSION
//--------------------

// PackageVersion returns the version of the version package.
func PackageVersion() version.Version {
	return version.New(3, 0, 0)
}

// EOF
