package css

// generated by hasher -type=Hash -file=hash.go; DO NOT EDIT, except for adding more constants to the list and rerun go generate

// uses github.com/tdewolff/hasher
//go:generate hasher -type=Hash -file=hash.go

// Hash defines perfect hashes for a predefined list of strings
type Hash uint32

// Unique hash definitions to be used instead of strings
const (
	Accelerator                 Hash = 0x4b30b // accelerator
	Aliceblue                   Hash = 0x56109 // aliceblue
	Alpha                       Hash = 0x5eb05 // alpha
	Antiquewhite                Hash = 0x4900c // antiquewhite
	Aquamarine                  Hash = 0x73a0a // aquamarine
	Azimuth                     Hash = 0x5ef07 // azimuth
	Background                  Hash = 0xa     // background
	Background_Attachment       Hash = 0x9115  // background-attachment
	Background_Color            Hash = 0x11210 // background-color
	Background_Image            Hash = 0x9ca10 // background-image
	Background_Position         Hash = 0x13    // background-position
	Background_Position_X       Hash = 0x84015 // background-position-x
	Background_Position_Y       Hash = 0x15    // background-position-y
	Background_Repeat           Hash = 0x1511  // background-repeat
	Behavior                    Hash = 0x3108  // behavior
	Black                       Hash = 0x5805  // black
	Blanchedalmond              Hash = 0x5d0e  // blanchedalmond
	Blueviolet                  Hash = 0x5660a // blueviolet
	Bold                        Hash = 0x7204  // bold
	Border                      Hash = 0x7d06  // border
	Border_Bottom               Hash = 0x7d0d  // border-bottom
	Border_Bottom_Color         Hash = 0x7d13  // border-bottom-color
	Border_Bottom_Style         Hash = 0xb413  // border-bottom-style
	Border_Bottom_Width         Hash = 0xd713  // border-bottom-width
	Border_Collapse             Hash = 0xf80f  // border-collapse
	Border_Color                Hash = 0x1480c // border-color
	Border_Left                 Hash = 0x15d0b // border-left
	Border_Left_Color           Hash = 0x15d11 // border-left-color
	Border_Left_Style           Hash = 0x18911 // border-left-style
	Border_Left_Width           Hash = 0x19a11 // border-left-width
	Border_Right                Hash = 0x1ab0c // border-right
	Border_Right_Color          Hash = 0x1ab12 // border-right-color
	Border_Right_Style          Hash = 0x1c912 // border-right-style
	Border_Right_Width          Hash = 0x1db12 // border-right-width
	Border_Spacing              Hash = 0x1ed0e // border-spacing
	Border_Style                Hash = 0x2100c // border-style
	Border_Top                  Hash = 0x21c0a // border-top
	Border_Top_Color            Hash = 0x21c10 // border-top-color
	Border_Top_Style            Hash = 0x22c10 // border-top-style
	Border_Top_Width            Hash = 0x23c10 // border-top-width
	Border_Width                Hash = 0x24c0c // border-width
	Bottom                      Hash = 0x8406  // bottom
	Box_Shadow                  Hash = 0x2580a // box-shadow
	Burlywood                   Hash = 0x26b09 // burlywood
	Cadetblue                   Hash = 0x28a09 // cadetblue
	Calc                        Hash = 0x28704 // calc
	Caption_Side                Hash = 0x2930c // caption-side
	Charset                     Hash = 0x47607 // charset
	Chartreuse                  Hash = 0x2a50a // chartreuse
	Chocolate                   Hash = 0x2af09 // chocolate
	Clear                       Hash = 0x2dd05 // clear
	Clip                        Hash = 0x2e204 // clip
	Color                       Hash = 0x8b05  // color
	Content                     Hash = 0x31e07 // content
	Cornflowerblue              Hash = 0x3530e // cornflowerblue
	Cornsilk                    Hash = 0x36108 // cornsilk
	Counter_Increment           Hash = 0x36911 // counter-increment
	Counter_Reset               Hash = 0x3840d // counter-reset
	Cue                         Hash = 0x39103 // cue
	Cue_After                   Hash = 0x39109 // cue-after
	Cue_Before                  Hash = 0x39a0a // cue-before
	Cursive                     Hash = 0x3ab07 // cursive
	Cursor                      Hash = 0x3be06 // cursor
	Darkblue                    Hash = 0x6a08  // darkblue
	Darkcyan                    Hash = 0x7508  // darkcyan
	Darkgoldenrod               Hash = 0x2730d // darkgoldenrod
	Darkgray                    Hash = 0x27f08 // darkgray
	Darkgreen                   Hash = 0x7ca09 // darkgreen
	Darkkhaki                   Hash = 0x8bd09 // darkkhaki
	Darkmagenta                 Hash = 0x5280b // darkmagenta
	Darkolivegreen              Hash = 0x7590e // darkolivegreen
	Darkorange                  Hash = 0x7be0a // darkorange
	Darkorchid                  Hash = 0x8b40a // darkorchid
	Darksalmon                  Hash = 0x8f80a // darksalmon
	Darkseagreen                Hash = 0x95c0c // darkseagreen
	Darkslateblue               Hash = 0x3c40d // darkslateblue
	Darkslategray               Hash = 0x3d10d // darkslategray
	Darkturquoise               Hash = 0x3de0d // darkturquoise
	Darkviolet                  Hash = 0x3eb0a // darkviolet
	Deeppink                    Hash = 0x29d08 // deeppink
	Deepskyblue                 Hash = 0x8cb0b // deepskyblue
	Default                     Hash = 0x5b707 // default
	Direction                   Hash = 0xa2909 // direction
	Display                     Hash = 0x3f507 // display
	Document                    Hash = 0x40308 // document
	Dodgerblue                  Hash = 0x40b0a // dodgerblue
	Elevation                   Hash = 0x4d409 // elevation
	Empty_Cells                 Hash = 0x4f60b // empty-cells
	Fantasy                     Hash = 0x60a07 // fantasy
	Filter                      Hash = 0x5d406 // filter
	Firebrick                   Hash = 0x41509 // firebrick
	Flex                        Hash = 0x41e04 // flex
	Float                       Hash = 0x42205 // float
	Floralwhite                 Hash = 0x4270b // floralwhite
	Font                        Hash = 0xce04  // font
	Font_Face                   Hash = 0xce09  // font-face
	Font_Family                 Hash = 0x4510b // font-family
	Font_Size                   Hash = 0x45c09 // font-size
	Font_Size_Adjust            Hash = 0x45c10 // font-size-adjust
	Font_Stretch                Hash = 0x46c0c // font-stretch
	Font_Style                  Hash = 0x47d0a // font-style
	Font_Variant                Hash = 0x4870c // font-variant
	Font_Weight                 Hash = 0x4a20b // font-weight
	Forestgreen                 Hash = 0x3a00b // forestgreen
	Fuchsia                     Hash = 0x4ad07 // fuchsia
	Gainsboro                   Hash = 0x17909 // gainsboro
	Ghostwhite                  Hash = 0x1fa0a // ghostwhite
	Goldenrod                   Hash = 0x27709 // goldenrod
	Greenyellow                 Hash = 0x7ce0b // greenyellow
	Height                      Hash = 0x6ae06 // height
	Honeydew                    Hash = 0x5f508 // honeydew
	Hsl                         Hash = 0xe903  // hsl
	Hsla                        Hash = 0xe904  // hsla
	Ime_Mode                    Hash = 0x8c508 // ime-mode
	Import                      Hash = 0x51706 // import
	Important                   Hash = 0x51709 // important
	Include_Source              Hash = 0x82a0e // include-source
	Indianred                   Hash = 0x52009 // indianred
	Inherit                     Hash = 0x55507 // inherit
	Initial                     Hash = 0x55c07 // initial
	Keyframes                   Hash = 0x43509 // keyframes
	Lavender                    Hash = 0xeb08  // lavender
	Lavenderblush               Hash = 0xeb0d  // lavenderblush
	Lawngreen                   Hash = 0x50e09 // lawngreen
	Layer_Background_Color      Hash = 0x10c16 // layer-background-color
	Layer_Background_Image      Hash = 0x9c416 // layer-background-image
	Layout_Flow                 Hash = 0x5370b // layout-flow
	Layout_Grid                 Hash = 0x57b0b // layout-grid
	Layout_Grid_Char            Hash = 0x57b10 // layout-grid-char
	Layout_Grid_Char_Spacing    Hash = 0x57b18 // layout-grid-char-spacing
	Layout_Grid_Line            Hash = 0x59310 // layout-grid-line
	Layout_Grid_Mode            Hash = 0x5a910 // layout-grid-mode
	Layout_Grid_Type            Hash = 0x5be10 // layout-grid-type
	Left                        Hash = 0x16404 // left
	Lemonchiffon                Hash = 0xc50c  // lemonchiffon
	Letter_Spacing              Hash = 0x56d0e // letter-spacing
	Lightblue                   Hash = 0x5da09 // lightblue
	Lightcoral                  Hash = 0x5e30a // lightcoral
	Lightcyan                   Hash = 0x61109 // lightcyan
	Lightgoldenrodyellow        Hash = 0x61a14 // lightgoldenrodyellow
	Lightgray                   Hash = 0x63909 // lightgray
	Lightgreen                  Hash = 0x6420a // lightgreen
	Lightpink                   Hash = 0x64c09 // lightpink
	Lightsalmon                 Hash = 0x6550b // lightsalmon
	Lightseagreen               Hash = 0x6600d // lightseagreen
	Lightskyblue                Hash = 0x66d0c // lightskyblue
	Lightslateblue              Hash = 0x6790e // lightslateblue
	Lightsteelblue              Hash = 0x6870e // lightsteelblue
	Lightyellow                 Hash = 0x6950b // lightyellow
	Limegreen                   Hash = 0x6a009 // limegreen
	Line_Break                  Hash = 0x59f0a // line-break
	Line_Height                 Hash = 0x6a90b // line-height
	Linear_Gradient             Hash = 0x6b40f // linear-gradient
	List_Style                  Hash = 0x6c30a // list-style
	List_Style_Image            Hash = 0x6c310 // list-style-image
	List_Style_Position         Hash = 0x6d313 // list-style-position
	List_Style_Type             Hash = 0x6e60f // list-style-type
	Magenta                     Hash = 0x52c07 // magenta
	Margin                      Hash = 0x2f206 // margin
	Margin_Bottom               Hash = 0x2f20d // margin-bottom
	Margin_Left                 Hash = 0x2fe0b // margin-left
	Margin_Right                Hash = 0x3310c // margin-right
	Margin_Top                  Hash = 0x8050a // margin-top
	Marker_Offset               Hash = 0x6f50d // marker-offset
	Marks                       Hash = 0x70205 // marks
	Max_Height                  Hash = 0x7210a // max-height
	Max_Width                   Hash = 0x72b09 // max-width
	Media                       Hash = 0xa4c05 // media
	Mediumaquamarine            Hash = 0x73410 // mediumaquamarine
	Mediumblue                  Hash = 0x7440a // mediumblue
	Mediumorchid                Hash = 0x74e0c // mediumorchid
	Mediumpurple                Hash = 0x7670c // mediumpurple
	Mediumseagreen              Hash = 0x7730e // mediumseagreen
	Mediumslateblue             Hash = 0x7810f // mediumslateblue
	Mediumspringgreen           Hash = 0x79011 // mediumspringgreen
	Mediumturquoise             Hash = 0x7a10f // mediumturquoise
	Mediumvioletred             Hash = 0x7b00f // mediumvioletred
	Midnightblue                Hash = 0x7de0c // midnightblue
	Min_Height                  Hash = 0x7ea0a // min-height
	Min_Width                   Hash = 0x7f409 // min-width
	Mintcream                   Hash = 0x7fd09 // mintcream
	Mistyrose                   Hash = 0x81b09 // mistyrose
	Moccasin                    Hash = 0x82408 // moccasin
	Monospace                   Hash = 0x8ff09 // monospace
	Namespace                   Hash = 0x4cc09 // namespace
	Navajowhite                 Hash = 0x4dc0b // navajowhite
	None                        Hash = 0x4f304 // none
	Normal                      Hash = 0x50906 // normal
	Olivedrab                   Hash = 0x83809 // olivedrab
	Orangered                   Hash = 0x7c209 // orangered
	Orphans                     Hash = 0x4bc07 // orphans
	Outline                     Hash = 0x85507 // outline
	Outline_Color               Hash = 0x8550d // outline-color
	Outline_Style               Hash = 0x8620d // outline-style
	Outline_Width               Hash = 0x86f0d // outline-width
	Overflow                    Hash = 0xaa08  // overflow
	Overflow_X                  Hash = 0xaa0a  // overflow-x
	Overflow_Y                  Hash = 0x87c0a // overflow-y
	Padding                     Hash = 0x2e507 // padding
	Padding_Bottom              Hash = 0x2e50e // padding-bottom
	Padding_Left                Hash = 0x5490c // padding-left
	Padding_Right               Hash = 0x80e0d // padding-right
	Padding_Top                 Hash = 0x9110b // padding-top
	Page                        Hash = 0x88604 // page
	Page_Break_After            Hash = 0x91b10 // page-break-after
	Page_Break_Before           Hash = 0x88611 // page-break-before
	Page_Break_Inside           Hash = 0x89711 // page-break-inside
	Palegoldenrod               Hash = 0x8a80d // palegoldenrod
	Palegreen                   Hash = 0x8d609 // palegreen
	Paleturquoise               Hash = 0x8df0d // paleturquoise
	Palevioletred               Hash = 0x8ec0d // palevioletred
	Papayawhip                  Hash = 0x9080a // papayawhip
	Pause                       Hash = 0x92b05 // pause
	Pause_After                 Hash = 0x92b0b // pause-after
	Pause_Before                Hash = 0x9360c // pause-before
	Peachpuff                   Hash = 0x5cc09 // peachpuff
	Pitch                       Hash = 0x94205 // pitch
	Pitch_Range                 Hash = 0x9420b // pitch-range
	Play_During                 Hash = 0x3f80b // play-during
	Position                    Hash = 0xb08   // position
	Powderblue                  Hash = 0x94d0a // powderblue
	Progid                      Hash = 0x95706 // progid
	Quotes                      Hash = 0x96806 // quotes
	Radial_Gradient             Hash = 0x380f  // radial-gradient
	Rgb                         Hash = 0x8f03  // rgb
	Rgba                        Hash = 0x8f04  // rgba
	Richness                    Hash = 0x12108 // richness
	Right                       Hash = 0x1b205 // right
	Rosybrown                   Hash = 0x18009 // rosybrown
	Royalblue                   Hash = 0x13f09 // royalblue
	Ruby_Align                  Hash = 0x1530a // ruby-align
	Ruby_Overhang               Hash = 0x16d0d // ruby-overhang
	Ruby_Position               Hash = 0x1bc0d // ruby-position
	Saddlebrown                 Hash = 0x4c20b // saddlebrown
	Sandybrown                  Hash = 0x5000a // sandybrown
	Sans_Serif                  Hash = 0x6010a // sans-serif
	Scrollbar_3d_Light_Color    Hash = 0x12818 // scrollbar-3d-light-color
	Scrollbar_Arrow_Color       Hash = 0x2c815 // scrollbar-arrow-color
	Scrollbar_Base_Color        Hash = 0x43d14 // scrollbar-base-color
	Scrollbar_Dark_Shadow_Color Hash = 0x7061b // scrollbar-dark-shadow-color
	Scrollbar_Face_Color        Hash = 0x96d14 // scrollbar-face-color
	Scrollbar_Highlight_Color   Hash = 0xa0619 // scrollbar-highlight-color
	Scrollbar_Shadow_Color      Hash = 0x98116 // scrollbar-shadow-color
	Scrollbar_Track_Color       Hash = 0x99715 // scrollbar-track-color
	Seagreen                    Hash = 0x66508 // seagreen
	Seashell                    Hash = 0x10508 // seashell
	Serif                       Hash = 0x60605 // serif
	Size                        Hash = 0x46104 // size
	Slateblue                   Hash = 0x3c809 // slateblue
	Slategray                   Hash = 0x3d509 // slategray
	Speak                       Hash = 0x9ac05 // speak
	Speak_Header                Hash = 0x9ac0c // speak-header
	Speak_Numeral               Hash = 0x9b80d // speak-numeral
	Speak_Punctuation           Hash = 0x9da11 // speak-punctuation
	Speech_Rate                 Hash = 0x9eb0b // speech-rate
	Springgreen                 Hash = 0x7960b // springgreen
	Steelblue                   Hash = 0x68c09 // steelblue
	Stress                      Hash = 0x2c306 // stress
	Supports                    Hash = 0x9ff08 // supports
	Table_Layout                Hash = 0x5310c // table-layout
	Text_Align                  Hash = 0x2b60a // text-align
	Text_Align_Last             Hash = 0x2b60f // text-align-last
	Text_Autospace              Hash = 0x2020e // text-autospace
	Text_Decoration             Hash = 0x4e50f // text-decoration
	Text_Indent                 Hash = 0x9f40b // text-indent
	Text_Justify                Hash = 0x250c  // text-justify
	Text_Kashida_Space          Hash = 0x4612  // text-kashida-space
	Text_Overflow               Hash = 0xa50d  // text-overflow
	Text_Shadow                 Hash = 0x3080b // text-shadow
	Text_Transform              Hash = 0x3240e // text-transform
	Text_Underline_Position     Hash = 0x33c17 // text-underline-position
	Top                         Hash = 0x22303 // top
	Transparent                 Hash = 0x3790b // transparent
	Turquoise                   Hash = 0x3e209 // turquoise
	Unicode_Bidi                Hash = 0xa1f0c // unicode-bidi
	Vertical_Align              Hash = 0x3b00e // vertical-align
	Visibility                  Hash = 0xa320a // visibility
	Voice_Family                Hash = 0xa3c0c // voice-family
	Volume                      Hash = 0xa4806 // volume
	White                       Hash = 0x1ff05 // white
	White_Space                 Hash = 0x4970b // white-space
	Whitesmoke                  Hash = 0x42d0a // whitesmoke
	Widows                      Hash = 0x5fc06 // widows
	Width                       Hash = 0xe505  // width
	Word_Break                  Hash = 0x2610a // word-break
	Word_Spacing                Hash = 0x3120c // word-spacing
	Word_Wrap                   Hash = 0x54109 // word-wrap
	Writing_Mode                Hash = 0x62d0c // writing-mode
	Yellow                      Hash = 0x62806 // yellow
	Yellowgreen                 Hash = 0x7d30b // yellowgreen
	Z_Index                     Hash = 0xa5107 // z-index
)

// String returns the hash' name.
func (i Hash) String() string {
	start := uint32(i >> 8)
	n := uint32(i & 0xff)
	if start+n > uint32(len(_Hash_text)) {
		return ""
	}
	return _Hash_text[start : start+n]
}

// ToHash returns the hash whose name is s. It returns zero if there is no
// such hash. It is case sensitive.
func ToHash(s []byte) Hash {
	if len(s) == 0 || len(s) > _Hash_maxLen {
		return 0
	}
	h := uint32(_Hash_hash0)
	for i := 0; i < len(s); i++ {
		h ^= uint32(s[i])
		h *= 16777619
	}
	if i := _Hash_table[h&uint32(len(_Hash_table)-1)]; int(i&0xff) == len(s) {
		t := _Hash_text[i>>8 : i>>8+i&0xff]
		for i := 0; i < len(s); i++ {
			if t[i] != s[i] {
				goto NEXT
			}
		}
		return i
	}
NEXT:
	if i := _Hash_table[(h>>16)&uint32(len(_Hash_table)-1)]; int(i&0xff) == len(s) {
		t := _Hash_text[i>>8 : i>>8+i&0xff]
		for i := 0; i < len(s); i++ {
			if t[i] != s[i] {
				return 0
			}
		}
		return i
	}
	return 0
}

const _Hash_hash0 = 0x700e0976
const _Hash_maxLen = 27
const _Hash_text = "background-position-ybackground-repeatext-justifybehavioradi" +
	"al-gradientext-kashida-spaceblackblanchedalmondarkblueboldar" +
	"kcyanborder-bottom-colorgbackground-attachmentext-overflow-x" +
	"border-bottom-stylemonchiffont-faceborder-bottom-widthslaven" +
	"derblushborder-collapseashellayer-background-colorichnesscro" +
	"llbar-3d-light-coloroyalblueborder-coloruby-alignborder-left" +
	"-coloruby-overhangainsborosybrownborder-left-styleborder-lef" +
	"t-widthborder-right-coloruby-positionborder-right-styleborde" +
	"r-right-widthborder-spacinghostwhitext-autospaceborder-style" +
	"border-top-colorborder-top-styleborder-top-widthborder-width" +
	"box-shadoword-breakburlywoodarkgoldenrodarkgraycalcadetbluec" +
	"aption-sideeppinkchartreusechocolatext-align-lastresscrollba" +
	"r-arrow-colorclearclipadding-bottomargin-bottomargin-leftext" +
	"-shadoword-spacingcontentext-transformargin-rightext-underli" +
	"ne-positioncornflowerbluecornsilkcounter-incrementransparent" +
	"counter-resetcue-aftercue-beforestgreencursivertical-aligncu" +
	"rsordarkslatebluedarkslategraydarkturquoisedarkvioletdisplay" +
	"-duringdocumentdodgerbluefirebrickflexfloatfloralwhitesmokey" +
	"framescrollbar-base-colorfont-familyfont-size-adjustfont-str" +
	"etcharsetfont-stylefont-variantiquewhite-spacefont-weightfuc" +
	"hsiacceleratorphansaddlebrownamespacelevationavajowhitext-de" +
	"corationonempty-cellsandybrownormalawngreenimportantindianre" +
	"darkmagentable-layout-floword-wrapadding-leftinheritinitiali" +
	"cebluevioletter-spacinglayout-grid-char-spacinglayout-grid-l" +
	"ine-breaklayout-grid-modefaultlayout-grid-typeachpuffilterli" +
	"ghtbluelightcoralphazimuthoneydewidowsans-serifantasylightcy" +
	"anlightgoldenrodyellowriting-modelightgraylightgreenlightpin" +
	"klightsalmonlightseagreenlightskybluelightslatebluelightstee" +
	"lbluelightyellowlimegreenline-heightlinear-gradientlist-styl" +
	"e-imagelist-style-positionlist-style-typemarker-offsetmarksc" +
	"rollbar-dark-shadow-colormax-heightmax-widthmediumaquamarine" +
	"mediumbluemediumorchidarkolivegreenmediumpurplemediumseagree" +
	"nmediumslatebluemediumspringgreenmediumturquoisemediumviolet" +
	"redarkorangeredarkgreenyellowgreenmidnightbluemin-heightmin-" +
	"widthmintcreamargin-topadding-rightmistyrosemoccasinclude-so" +
	"urceolivedrabackground-position-xoutline-coloroutline-styleo" +
	"utline-widthoverflow-ypage-break-beforepage-break-insidepale" +
	"goldenrodarkorchidarkkhakime-modeepskybluepalegreenpaleturqu" +
	"oisepalevioletredarksalmonospacepapayawhipadding-topage-brea" +
	"k-afterpause-afterpause-beforepitch-rangepowderblueprogidark" +
	"seagreenquotescrollbar-face-colorscrollbar-shadow-colorscrol" +
	"lbar-track-colorspeak-headerspeak-numeralayer-background-ima" +
	"gespeak-punctuationspeech-ratext-indentsupportscrollbar-high" +
	"light-colorunicode-bidirectionvisibilityvoice-familyvolumedi" +
	"az-index"

var _Hash_table = [1 << 9]Hash{
	0x0:   0x5000a, // sandybrown
	0x1:   0x22303, // top
	0x4:   0x13f09, // royalblue
	0x6:   0x4e50f, // text-decoration
	0xb:   0x5370b, // layout-flow
	0xc:   0x11210, // background-color
	0xd:   0x8406,  // bottom
	0x10:  0x6600d, // lightseagreen
	0x11:  0x8cb0b, // deepskyblue
	0x12:  0x3c809, // slateblue
	0x13:  0x4f60b, // empty-cells
	0x14:  0x2e204, // clip
	0x15:  0x7440a, // mediumblue
	0x16:  0x4cc09, // namespace
	0x18:  0x2f20d, // margin-bottom
	0x1a:  0x1480c, // border-color
	0x1b:  0x5f508, // honeydew
	0x1d:  0x24c0c, // border-width
	0x1e:  0x9ac0c, // speak-header
	0x1f:  0x8ec0d, // palevioletred
	0x20:  0x1ed0e, // border-spacing
	0x22:  0x2e507, // padding
	0x23:  0x3310c, // margin-right
	0x27:  0x7f409, // min-width
	0x29:  0x8f03,  // rgb
	0x2a:  0x6950b, // lightyellow
	0x2c:  0x91b10, // page-break-after
	0x2d:  0x31e07, // content
	0x30:  0x250c,  // text-justify
	0x32:  0x2b60f, // text-align-last
	0x34:  0x96d14, // scrollbar-face-color
	0x35:  0x43509, // keyframes
	0x36:  0x27f08, // darkgray
	0x37:  0x52c07, // magenta
	0x38:  0x3d509, // slategray
	0x3a:  0x9ca10, // background-image
	0x3c:  0x82a0e, // include-source
	0x3d:  0x68c09, // steelblue
	0x3e:  0x8550d, // outline-color
	0x40:  0xf80f,  // border-collapse
	0x41:  0xeb08,  // lavender
	0x42:  0x9ff08, // supports
	0x44:  0x6a90b, // line-height
	0x45:  0x9da11, // speak-punctuation
	0x46:  0xa320a, // visibility
	0x47:  0x2dd05, // clear
	0x4b:  0x5660a, // blueviolet
	0x4e:  0x5b707, // default
	0x50:  0x6f50d, // marker-offset
	0x52:  0x36911, // counter-increment
	0x53:  0x6790e, // lightslateblue
	0x54:  0x10508, // seashell
	0x56:  0x1bc0d, // ruby-position
	0x57:  0x8620d, // outline-style
	0x58:  0x66508, // seagreen
	0x59:  0x8b05,  // color
	0x5c:  0x2930c, // caption-side
	0x5d:  0x6ae06, // height
	0x5e:  0x7810f, // mediumslateblue
	0x5f:  0x9360c, // pause-before
	0x60:  0xc50c,  // lemonchiffon
	0x63:  0x3ab07, // cursive
	0x66:  0x4dc0b, // navajowhite
	0x67:  0xa3c0c, // voice-family
	0x68:  0x2730d, // darkgoldenrod
	0x69:  0x41509, // firebrick
	0x6a:  0x47d0a, // font-style
	0x6b:  0xa2909, // direction
	0x6d:  0x7be0a, // darkorange
	0x6f:  0x4870c, // font-variant
	0x70:  0x2f206, // margin
	0x71:  0x88611, // page-break-before
	0x73:  0xa50d,  // text-overflow
	0x74:  0x4612,  // text-kashida-space
	0x75:  0x36108, // cornsilk
	0x76:  0x4a20b, // font-weight
	0x77:  0x46104, // size
	0x78:  0x57b0b, // layout-grid
	0x79:  0x9110b, // padding-top
	0x7a:  0x47607, // charset
	0x7d:  0x81b09, // mistyrose
	0x7e:  0x5ef07, // azimuth
	0x7f:  0x92b0b, // pause-after
	0x83:  0x28704, // calc
	0x84:  0x3be06, // cursor
	0x85:  0xe903,  // hsl
	0x86:  0x56d0e, // letter-spacing
	0x88:  0x7ca09, // darkgreen
	0x8b:  0x40308, // document
	0x8d:  0x39109, // cue-after
	0x8f:  0x39a0a, // cue-before
	0x91:  0x60a07, // fantasy
	0x94:  0x16d0d, // ruby-overhang
	0x95:  0x2e50e, // padding-bottom
	0x9a:  0x5da09, // lightblue
	0x9c:  0x8f80a, // darksalmon
	0x9d:  0x45c10, // font-size-adjust
	0x9e:  0x64c09, // lightpink
	0xa0:  0x95c0c, // darkseagreen
	0xa2:  0x89711, // page-break-inside
	0xa4:  0x27709, // goldenrod
	0xa5:  0x63909, // lightgray
	0xa6:  0xa4c05, // media
	0xa7:  0x57b18, // layout-grid-char-spacing
	0xa9:  0x51709, // important
	0xaa:  0x7ea0a, // min-height
	0xb0:  0x15d11, // border-left-color
	0xb1:  0x88604, // page
	0xb2:  0x9c416, // layer-background-image
	0xb5:  0x59310, // layout-grid-line
	0xb6:  0x1511,  // background-repeat
	0xb7:  0x7d13,  // border-bottom-color
	0xb9:  0x2580a, // box-shadow
	0xbb:  0x5490c, // padding-left
	0xbc:  0x1b205, // right
	0xc0:  0x43d14, // scrollbar-base-color
	0xc1:  0x41e04, // flex
	0xc2:  0xe505,  // width
	0xc5:  0x3e209, // turquoise
	0xc8:  0x42205, // float
	0xca:  0x1530a, // ruby-align
	0xcb:  0xb08,   // position
	0xcc:  0x8050a, // margin-top
	0xce:  0x2fe0b, // margin-left
	0xcf:  0x3080b, // text-shadow
	0xd0:  0x2610a, // word-break
	0xd4:  0x42d0a, // whitesmoke
	0xd6:  0x33c17, // text-underline-position
	0xd7:  0x1db12, // border-right-width
	0xd8:  0x83809, // olivedrab
	0xd9:  0x8d609, // palegreen
	0xdb:  0x51706, // import
	0xdc:  0x70205, // marks
	0xdd:  0x3eb0a, // darkviolet
	0xde:  0x13,    // background-position
	0xe0:  0x73410, // mediumaquamarine
	0xe1:  0x7204,  // bold
	0xe2:  0x7a10f, // mediumturquoise
	0xe4:  0x8a80d, // palegoldenrod
	0xe5:  0x5280b, // darkmagenta
	0xe6:  0x18009, // rosybrown
	0xe7:  0x19a11, // border-left-width
	0xe8:  0x8bd09, // darkkhaki
	0xea:  0x5d0e,  // blanchedalmond
	0xeb:  0x55c07, // initial
	0xec:  0x7061b, // scrollbar-dark-shadow-color
	0xee:  0x4c20b, // saddlebrown
	0xef:  0x8df0d, // paleturquoise
	0xf1:  0x1ab12, // border-right-color
	0xf3:  0x1ff05, // white
	0xf7:  0xa0619, // scrollbar-highlight-color
	0xf9:  0x5a910, // layout-grid-mode
	0xfc:  0x2100c, // border-style
	0xfe:  0x6d313, // list-style-position
	0x100: 0x10c16, // layer-background-color
	0x102: 0x5be10, // layout-grid-type
	0x103: 0x15d0b, // border-left
	0x104: 0xaa08,  // overflow
	0x105: 0x7de0c, // midnightblue
	0x10b: 0x2b60a, // text-align
	0x10e: 0x22c10, // border-top-style
	0x110: 0x61a14, // lightgoldenrodyellow
	0x114: 0x7d06,  // border
	0x119: 0xce04,  // font
	0x11c: 0x73a0a, // aquamarine
	0x11d: 0x6420a, // lightgreen
	0x11e: 0x62806, // yellow
	0x120: 0x9ac05, // speak
	0x121: 0x4970b, // white-space
	0x123: 0x3c40d, // darkslateblue
	0x125: 0x2020e, // text-autospace
	0x128: 0xeb0d,  // lavenderblush
	0x12c: 0x6550b, // lightsalmon
	0x12d: 0x55507, // inherit
	0x131: 0x8b40a, // darkorchid
	0x132: 0x21c0a, // border-top
	0x133: 0x3f80b, // play-during
	0x137: 0x23c10, // border-top-width
	0x139: 0x4bc07, // orphans
	0x13a: 0x4510b, // font-family
	0x13d: 0x40b0a, // dodgerblue
	0x13f: 0x9080a, // papayawhip
	0x140: 0x92b05, // pause
	0x142: 0x6b40f, // linear-gradient
	0x143: 0x3530e, // cornflowerblue
	0x144: 0x3f507, // display
	0x146: 0x56109, // aliceblue
	0x14a: 0x6a08,  // darkblue
	0x14b: 0x3108,  // behavior
	0x14c: 0x3840d, // counter-reset
	0x14d: 0x7ce0b, // greenyellow
	0x14e: 0x79011, // mediumspringgreen
	0x14f: 0x94d0a, // powderblue
	0x150: 0x57b10, // layout-grid-char
	0x158: 0x85507, // outline
	0x159: 0x26b09, // burlywood
	0x15b: 0xd713,  // border-bottom-width
	0x15c: 0x4f304, // none
	0x15e: 0x39103, // cue
	0x15f: 0x5310c, // table-layout
	0x160: 0x9420b, // pitch-range
	0x161: 0xa5107, // z-index
	0x162: 0x2c306, // stress
	0x163: 0x84015, // background-position-x
	0x165: 0x50906, // normal
	0x167: 0x7670c, // mediumpurple
	0x169: 0x5e30a, // lightcoral
	0x16c: 0x7210a, // max-height
	0x16d: 0x8f04,  // rgba
	0x16e: 0x6c310, // list-style-image
	0x170: 0x29d08, // deeppink
	0x173: 0x95706, // progid
	0x175: 0x7960b, // springgreen
	0x176: 0x3a00b, // forestgreen
	0x178: 0x3790b, // transparent
	0x179: 0x82408, // moccasin
	0x17a: 0x7b00f, // mediumvioletred
	0x17e: 0x9f40b, // text-indent
	0x181: 0x6e60f, // list-style-type
	0x182: 0x17909, // gainsboro
	0x183: 0x3de0d, // darkturquoise
	0x184: 0x3d10d, // darkslategray
	0x189: 0xaa0a,  // overflow-x
	0x18b: 0x96806, // quotes
	0x18c: 0x9115,  // background-attachment
	0x18f: 0x1ab0c, // border-right
	0x191: 0x5805,  // black
	0x192: 0x7d30b, // yellowgreen
	0x194: 0x5cc09, // peachpuff
	0x197: 0x4270b, // floralwhite
	0x19c: 0x7590e, // darkolivegreen
	0x19d: 0x54109, // word-wrap
	0x19e: 0x18911, // border-left-style
	0x1a0: 0x9eb0b, // speech-rate
	0x1a1: 0x86f0d, // outline-width
	0x1a2: 0xa1f0c, // unicode-bidi
	0x1a3: 0x6c30a, // list-style
	0x1a4: 0x94205, // pitch
	0x1a5: 0x99715, // scrollbar-track-color
	0x1a6: 0x4ad07, // fuchsia
	0x1a8: 0x3b00e, // vertical-align
	0x1ad: 0x5eb05, // alpha
	0x1ae: 0x72b09, // max-width
	0x1af: 0x12108, // richness
	0x1b0: 0x380f,  // radial-gradient
	0x1b1: 0x80e0d, // padding-right
	0x1b2: 0x2c815, // scrollbar-arrow-color
	0x1b3: 0x16404, // left
	0x1b5: 0x4d409, // elevation
	0x1b6: 0x59f0a, // line-break
	0x1ba: 0x2af09, // chocolate
	0x1bb: 0x9b80d, // speak-numeral
	0x1bd: 0x4b30b, // accelerator
	0x1be: 0x6a009, // limegreen
	0x1c1: 0x7508,  // darkcyan
	0x1c3: 0x66d0c, // lightskyblue
	0x1c5: 0x6010a, // sans-serif
	0x1c6: 0x7d0d,  // border-bottom
	0x1c7: 0xa,     // background
	0x1c8: 0xa4806, // volume
	0x1ca: 0x62d0c, // writing-mode
	0x1cb: 0x12818, // scrollbar-3d-light-color
	0x1cc: 0x5fc06, // widows
	0x1cf: 0x45c09, // font-size
	0x1d0: 0x15,    // background-position-y
	0x1d1: 0x61109, // lightcyan
	0x1d4: 0x52009, // indianred
	0x1d7: 0x1fa0a, // ghostwhite
	0x1db: 0x7c209, // orangered
	0x1dc: 0x4900c, // antiquewhite
	0x1dd: 0x50e09, // lawngreen
	0x1df: 0x7730e, // mediumseagreen
	0x1e0: 0x21c10, // border-top-color
	0x1e2: 0xe904,  // hsla
	0x1e4: 0x3240e, // text-transform
	0x1e6: 0x74e0c, // mediumorchid
	0x1e9: 0x8ff09, // monospace
	0x1ec: 0x98116, // scrollbar-shadow-color
	0x1ed: 0x6870e, // lightsteelblue
	0x1ef: 0x28a09, // cadetblue
	0x1f0: 0x5d406, // filter
	0x1f1: 0x1c912, // border-right-style
	0x1f6: 0x87c0a, // overflow-y
	0x1f7: 0xce09,  // font-face
	0x1f8: 0x3120c, // word-spacing
	0x1fa: 0xb413,  // border-bottom-style
	0x1fb: 0x46c0c, // font-stretch
	0x1fc: 0x7fd09, // mintcream
	0x1fd: 0x8c508, // ime-mode
	0x1fe: 0x2a50a, // chartreuse
	0x1ff: 0x60605, // serif
}
